# What is MINTO?

MINTO is a Python framework that supports the entire process of mathematical optimization experiments, from planning and execution to analysis of results.

## Core Concepts

MINTO is designed around three key concepts:

1. **Reproducibility and Shareability**  
Systematically records experimental settings, execution, and results to ensure reproducibility and facilitate knowledge sharing within teams.

2. **Comprehensive Experiment Support**  
Provides comprehensive support for the complete experimental process, including planning, execution, and analysis.

3. **Standardized Benchmark Environment**  
Offers standard optimization problems through the `problems` module to facilitate benchmark experiments, enabling efficient performance evaluation of new algorithms and methods.

## What is MINTO used for?

MINTO supports mathematical optimization experiments in the following aspects:

1. **Experiment Planning and Design**
   - Provision of standard optimization problems
   - Management of parameter settings
   - Systematization of experimental conditions

2. **Experiment Execution**
   - Automation of solver configuration and execution
   - Automatic recording of experimental processes
   - Error handling and log management

3. **Result Analysis and Sharing**
   - Structured storage of experimental results
   - Comparative analysis between different experimental conditions
   - Sharing of experimental results among team members

## Who uses it?

MINTO's target users include:
- Researchers and engineers in mathematical optimization
- Project members solving optimization problems in companies
- Anyone conducting optimization experiments

MINTO supports experiments of all scales, from small to large-scale implementations.

## Core Features

### 1. Experiment Process Support
- Support for systematic experiment planning
- Automation of experimental condition settings and management
- Efficient execution and recording of experiments

### 2. Benchmark Environment
- Standard problems through the `problems` module
- Management of benchmark datasets
- Standardization of performance evaluation

### 3. Data Management and Sharing
- Systematic management of problem definitions, parameters, and results
- Experiment sharing via GitHub and Docker
- Facilitation of knowledge sharing among teams

## Benefits

### For Researchers and Developers
- Easy access to standard benchmark environments
- Ensured experimental reproducibility
- Systematic analysis of experimental results

### For Teams
- Easy sharing of experimental insights
- Establishment of standardized experimental processes
- Efficient collaboration

MINTO enhances the efficiency of the entire mathematical optimization experimental process, enabling high-quality research and development. Through standardized problem sets and tools, it provides consistent support from experiment planning to result sharing.