# *** WARNING: this file was generated by the Pulumi Kubernetes codegen tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
from copy import deepcopy
from typing import Optional

import pulumi.runtime
import requests
import yaml
from pulumi_kubernetes.admissionregistration.v1beta1 import *
from pulumi_kubernetes.apiextensions.v1beta1 import *
from pulumi_kubernetes.apiregistration.v1 import *
from pulumi_kubernetes.apiregistration.v1beta1 import *
from pulumi_kubernetes.apps.v1 import *
from pulumi_kubernetes.apps.v1beta1 import *
from pulumi_kubernetes.apps.v1beta2 import *
from pulumi_kubernetes.auditregistration.v1alpha1 import *
from pulumi_kubernetes.authentication.v1 import *
from pulumi_kubernetes.authentication.v1beta1 import *
from pulumi_kubernetes.authorization.v1 import *
from pulumi_kubernetes.authorization.v1beta1 import *
from pulumi_kubernetes.autoscaling.v1 import *
from pulumi_kubernetes.autoscaling.v2beta1 import *
from pulumi_kubernetes.autoscaling.v2beta2 import *
from pulumi_kubernetes.batch.v1 import *
from pulumi_kubernetes.batch.v1beta1 import *
from pulumi_kubernetes.batch.v2alpha1 import *
from pulumi_kubernetes.certificates.v1beta1 import *
from pulumi_kubernetes.coordination.v1 import *
from pulumi_kubernetes.coordination.v1beta1 import *
from pulumi_kubernetes.core.v1 import *
from pulumi_kubernetes.events.v1beta1 import *
from pulumi_kubernetes.extensions.v1beta1 import *
from pulumi_kubernetes.meta.v1 import *
from pulumi_kubernetes.networking.v1 import *
from pulumi_kubernetes.networking.v1beta1 import *
from pulumi_kubernetes.node.v1alpha1 import *
from pulumi_kubernetes.node.v1beta1 import *
from pulumi_kubernetes.policy.v1beta1 import *
from pulumi_kubernetes.rbac.v1 import *
from pulumi_kubernetes.rbac.v1alpha1 import *
from pulumi_kubernetes.rbac.v1beta1 import *
from pulumi_kubernetes.scheduling.v1 import *
from pulumi_kubernetes.scheduling.v1alpha1 import *
from pulumi_kubernetes.scheduling.v1beta1 import *
from pulumi_kubernetes.settings.v1alpha1 import *
from pulumi_kubernetes.storage.v1 import *
from pulumi_kubernetes.storage.v1alpha1 import *
from pulumi_kubernetes.storage.v1beta1 import *

from . import tables


class ConfigFile(pulumi.ComponentResource):
    """
    ConfigFile creates a set of Kubernetes resources from a Kubernetes YAML file. If `config.name`
    is not specified, `ConfigFile` assumes the argument `name` is the filename.

    :param str name: A name for a resource.
    :param str file_id: Path or a URL that uniquely identifies a file.
    :param ResourceOptions opts: A bag of optional settings that control a resource's behavior.
    """

    def __init__(self, name: str, file_id: str, opts: Optional[pulumi.ResourceOptions] = None):
        if not name:
            raise TypeError('Missing resource name argument (for URN creation)')
        if not isinstance(name, str):
            raise TypeError('Expected resource name to be a string')
        if opts and not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')

        __props__ = dict()

        super(ConfigFile, self).__init__(
            "kubernetes:yaml:ConfigFile",
            name,
            __props__,
            opts)

        if file_id.startswith('http://') or file_id.startswith('https://'):
            text = read_url(file_id)
        else:
            text = read_file(file_id)

        # TODO: transformation support
        if opts is not None:
            _opts = deepcopy(opts)
            _opts.parent = self
        else:
            _opts = pulumi.ResourceOptions(parent=self)

        self.register_outputs(parse_yaml_document(yaml.safe_load_all(text), _opts))

    def translate_output_property(self, prop: str) -> str:
        return tables._CASING_FORWARD_TABLE.get(prop) or prop

    def translate_input_property(self, prop: str) -> str:
        return tables._CASING_BACKWARD_TABLE.get(prop) or prop


def read_url(url: str) -> str:
    response = requests.get(url)
    response.raise_for_status()

    return response.text


def read_file(path: str) -> str:
    with open(path, 'r') as file:
        data = file.read()

    return data


def parse_yaml_document(objects, opts: Optional[pulumi.ResourceOptions] = None):
    resources = {}
    for obj in objects:
        # TODO: transformation support
        file_objects = parse_yaml_object(obj, opts)
        for key, value in file_objects:
            resources[key] = value

    return resources


def parse_yaml_object(obj, opts: Optional[pulumi.ResourceOptions] = None):
    if not obj:
        return []

    # TODO: transformation support

    if "kind" not in obj or "apiVersion" not in obj:
        raise Exception("Kubernetes resources require a kind and apiVersion: {}".format(json.dumps(obj)))

    api_version = obj["apiVersion"]
    kind = obj["kind"]

    if kind.endswith("List"):
        objs = []
        if "items" in obj:
            for item in obj["items"]:
                objs = objs + parse_yaml_object(item, opts)
        return objs

    if "metadata" not in obj or "name" not in obj["metadata"]:
        raise Exception("YAML object does not have a .metadata.name: {}/{} {}".format(
            api_version, kind, json.dumps(obj)))

    metadata = obj["metadata"]
    spec = obj.get("spec")
    identifier = metadata["name"]
    if "namespace" in metadata:
        identifier = "{}/{}".format(metadata["namespace"], metadata["name"])

    gvk = f"{api_version}/{kind}"
    if gvk == "admissionregistration.k8s.io/v1beta1/MutatingWebhookConfiguration":
        return [(f"admissionregistration.k8s.io/v1beta1/MutatingWebhookConfiguration:{identifier}",
                 MutatingWebhookConfiguration(identifier, opts, metadata, spec))]
    if gvk == "admissionregistration.k8s.io/v1beta1/MutatingWebhookConfigurationList":
        return [(f"admissionregistration.k8s.io/v1beta1/MutatingWebhookConfigurationList:{identifier}",
                 MutatingWebhookConfigurationList(identifier, opts, metadata, spec))]
    if gvk == "admissionregistration.k8s.io/v1beta1/ValidatingWebhookConfiguration":
        return [(f"admissionregistration.k8s.io/v1beta1/ValidatingWebhookConfiguration:{identifier}",
                 ValidatingWebhookConfiguration(identifier, opts, metadata, spec))]
    if gvk == "admissionregistration.k8s.io/v1beta1/ValidatingWebhookConfigurationList":
        return [(f"admissionregistration.k8s.io/v1beta1/ValidatingWebhookConfigurationList:{identifier}",
                 ValidatingWebhookConfigurationList(identifier, opts, metadata, spec))]
    if gvk == "apiextensions.k8s.io/v1beta1/CustomResourceDefinition":
        return [(f"apiextensions.k8s.io/v1beta1/CustomResourceDefinition:{identifier}",
                 CustomResourceDefinition(identifier, opts, metadata, spec))]
    if gvk == "apiextensions.k8s.io/v1beta1/CustomResourceDefinitionList":
        return [(f"apiextensions.k8s.io/v1beta1/CustomResourceDefinitionList:{identifier}",
                 CustomResourceDefinitionList(identifier, opts, metadata, spec))]
    if gvk == "apiregistration.k8s.io/v1/APIService":
        return [(f"apiregistration.k8s.io/v1/APIService:{identifier}",
                 APIService(identifier, opts, metadata, spec))]
    if gvk == "apiregistration.k8s.io/v1/APIServiceList":
        return [(f"apiregistration.k8s.io/v1/APIServiceList:{identifier}",
                 APIServiceList(identifier, opts, metadata, spec))]
    if gvk == "apiregistration.k8s.io/v1beta1/APIService":
        return [(f"apiregistration.k8s.io/v1beta1/APIService:{identifier}",
                 APIService(identifier, opts, metadata, spec))]
    if gvk == "apiregistration.k8s.io/v1beta1/APIServiceList":
        return [(f"apiregistration.k8s.io/v1beta1/APIServiceList:{identifier}",
                 APIServiceList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1/ControllerRevision":
        return [(f"apps/v1/ControllerRevision:{identifier}",
                 ControllerRevision(identifier, opts, metadata, spec))]
    if gvk == "apps/v1/ControllerRevisionList":
        return [(f"apps/v1/ControllerRevisionList:{identifier}",
                 ControllerRevisionList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1/DaemonSet":
        return [(f"apps/v1/DaemonSet:{identifier}",
                 DaemonSet(identifier, opts, metadata, spec))]
    if gvk == "apps/v1/DaemonSetList":
        return [(f"apps/v1/DaemonSetList:{identifier}",
                 DaemonSetList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1/Deployment":
        return [(f"apps/v1/Deployment:{identifier}",
                 Deployment(identifier, opts, metadata, spec))]
    if gvk == "apps/v1/DeploymentList":
        return [(f"apps/v1/DeploymentList:{identifier}",
                 DeploymentList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1/ReplicaSet":
        return [(f"apps/v1/ReplicaSet:{identifier}",
                 ReplicaSet(identifier, opts, metadata, spec))]
    if gvk == "apps/v1/ReplicaSetList":
        return [(f"apps/v1/ReplicaSetList:{identifier}",
                 ReplicaSetList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1/StatefulSet":
        return [(f"apps/v1/StatefulSet:{identifier}",
                 StatefulSet(identifier, opts, metadata, spec))]
    if gvk == "apps/v1/StatefulSetList":
        return [(f"apps/v1/StatefulSetList:{identifier}",
                 StatefulSetList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta1/ControllerRevision":
        return [(f"apps/v1beta1/ControllerRevision:{identifier}",
                 ControllerRevision(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta1/ControllerRevisionList":
        return [(f"apps/v1beta1/ControllerRevisionList:{identifier}",
                 ControllerRevisionList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta1/Deployment":
        return [(f"apps/v1beta1/Deployment:{identifier}",
                 Deployment(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta1/DeploymentList":
        return [(f"apps/v1beta1/DeploymentList:{identifier}",
                 DeploymentList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta1/StatefulSet":
        return [(f"apps/v1beta1/StatefulSet:{identifier}",
                 StatefulSet(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta1/StatefulSetList":
        return [(f"apps/v1beta1/StatefulSetList:{identifier}",
                 StatefulSetList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta2/ControllerRevision":
        return [(f"apps/v1beta2/ControllerRevision:{identifier}",
                 ControllerRevision(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta2/ControllerRevisionList":
        return [(f"apps/v1beta2/ControllerRevisionList:{identifier}",
                 ControllerRevisionList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta2/DaemonSet":
        return [(f"apps/v1beta2/DaemonSet:{identifier}",
                 DaemonSet(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta2/DaemonSetList":
        return [(f"apps/v1beta2/DaemonSetList:{identifier}",
                 DaemonSetList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta2/Deployment":
        return [(f"apps/v1beta2/Deployment:{identifier}",
                 Deployment(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta2/DeploymentList":
        return [(f"apps/v1beta2/DeploymentList:{identifier}",
                 DeploymentList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta2/ReplicaSet":
        return [(f"apps/v1beta2/ReplicaSet:{identifier}",
                 ReplicaSet(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta2/ReplicaSetList":
        return [(f"apps/v1beta2/ReplicaSetList:{identifier}",
                 ReplicaSetList(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta2/StatefulSet":
        return [(f"apps/v1beta2/StatefulSet:{identifier}",
                 StatefulSet(identifier, opts, metadata, spec))]
    if gvk == "apps/v1beta2/StatefulSetList":
        return [(f"apps/v1beta2/StatefulSetList:{identifier}",
                 StatefulSetList(identifier, opts, metadata, spec))]
    if gvk == "auditregistration.k8s.io/v1alpha1/AuditSink":
        return [(f"auditregistration.k8s.io/v1alpha1/AuditSink:{identifier}",
                 AuditSink(identifier, opts, metadata, spec))]
    if gvk == "auditregistration.k8s.io/v1alpha1/AuditSinkList":
        return [(f"auditregistration.k8s.io/v1alpha1/AuditSinkList:{identifier}",
                 AuditSinkList(identifier, opts, metadata, spec))]
    if gvk == "authentication.k8s.io/v1/TokenReview":
        return [(f"authentication.k8s.io/v1/TokenReview:{identifier}",
                 TokenReview(identifier, opts, metadata, spec))]
    if gvk == "authentication.k8s.io/v1beta1/TokenReview":
        return [(f"authentication.k8s.io/v1beta1/TokenReview:{identifier}",
                 TokenReview(identifier, opts, metadata, spec))]
    if gvk == "authorization.k8s.io/v1/LocalSubjectAccessReview":
        return [(f"authorization.k8s.io/v1/LocalSubjectAccessReview:{identifier}",
                 LocalSubjectAccessReview(identifier, opts, metadata, spec))]
    if gvk == "authorization.k8s.io/v1/SelfSubjectAccessReview":
        return [(f"authorization.k8s.io/v1/SelfSubjectAccessReview:{identifier}",
                 SelfSubjectAccessReview(identifier, opts, metadata, spec))]
    if gvk == "authorization.k8s.io/v1/SelfSubjectRulesReview":
        return [(f"authorization.k8s.io/v1/SelfSubjectRulesReview:{identifier}",
                 SelfSubjectRulesReview(identifier, opts, metadata, spec))]
    if gvk == "authorization.k8s.io/v1/SubjectAccessReview":
        return [(f"authorization.k8s.io/v1/SubjectAccessReview:{identifier}",
                 SubjectAccessReview(identifier, opts, metadata, spec))]
    if gvk == "authorization.k8s.io/v1beta1/LocalSubjectAccessReview":
        return [(f"authorization.k8s.io/v1beta1/LocalSubjectAccessReview:{identifier}",
                 LocalSubjectAccessReview(identifier, opts, metadata, spec))]
    if gvk == "authorization.k8s.io/v1beta1/SelfSubjectAccessReview":
        return [(f"authorization.k8s.io/v1beta1/SelfSubjectAccessReview:{identifier}",
                 SelfSubjectAccessReview(identifier, opts, metadata, spec))]
    if gvk == "authorization.k8s.io/v1beta1/SelfSubjectRulesReview":
        return [(f"authorization.k8s.io/v1beta1/SelfSubjectRulesReview:{identifier}",
                 SelfSubjectRulesReview(identifier, opts, metadata, spec))]
    if gvk == "authorization.k8s.io/v1beta1/SubjectAccessReview":
        return [(f"authorization.k8s.io/v1beta1/SubjectAccessReview:{identifier}",
                 SubjectAccessReview(identifier, opts, metadata, spec))]
    if gvk == "autoscaling/v1/HorizontalPodAutoscaler":
        return [(f"autoscaling/v1/HorizontalPodAutoscaler:{identifier}",
                 HorizontalPodAutoscaler(identifier, opts, metadata, spec))]
    if gvk == "autoscaling/v1/HorizontalPodAutoscalerList":
        return [(f"autoscaling/v1/HorizontalPodAutoscalerList:{identifier}",
                 HorizontalPodAutoscalerList(identifier, opts, metadata, spec))]
    if gvk == "autoscaling/v2beta1/HorizontalPodAutoscaler":
        return [(f"autoscaling/v2beta1/HorizontalPodAutoscaler:{identifier}",
                 HorizontalPodAutoscaler(identifier, opts, metadata, spec))]
    if gvk == "autoscaling/v2beta1/HorizontalPodAutoscalerList":
        return [(f"autoscaling/v2beta1/HorizontalPodAutoscalerList:{identifier}",
                 HorizontalPodAutoscalerList(identifier, opts, metadata, spec))]
    if gvk == "autoscaling/v2beta2/HorizontalPodAutoscaler":
        return [(f"autoscaling/v2beta2/HorizontalPodAutoscaler:{identifier}",
                 HorizontalPodAutoscaler(identifier, opts, metadata, spec))]
    if gvk == "autoscaling/v2beta2/HorizontalPodAutoscalerList":
        return [(f"autoscaling/v2beta2/HorizontalPodAutoscalerList:{identifier}",
                 HorizontalPodAutoscalerList(identifier, opts, metadata, spec))]
    if gvk == "batch/v1/Job":
        return [(f"batch/v1/Job:{identifier}",
                 Job(identifier, opts, metadata, spec))]
    if gvk == "batch/v1/JobList":
        return [(f"batch/v1/JobList:{identifier}",
                 JobList(identifier, opts, metadata, spec))]
    if gvk == "batch/v1beta1/CronJob":
        return [(f"batch/v1beta1/CronJob:{identifier}",
                 CronJob(identifier, opts, metadata, spec))]
    if gvk == "batch/v1beta1/CronJobList":
        return [(f"batch/v1beta1/CronJobList:{identifier}",
                 CronJobList(identifier, opts, metadata, spec))]
    if gvk == "batch/v2alpha1/CronJob":
        return [(f"batch/v2alpha1/CronJob:{identifier}",
                 CronJob(identifier, opts, metadata, spec))]
    if gvk == "batch/v2alpha1/CronJobList":
        return [(f"batch/v2alpha1/CronJobList:{identifier}",
                 CronJobList(identifier, opts, metadata, spec))]
    if gvk == "certificates.k8s.io/v1beta1/CertificateSigningRequest":
        return [(f"certificates.k8s.io/v1beta1/CertificateSigningRequest:{identifier}",
                 CertificateSigningRequest(identifier, opts, metadata, spec))]
    if gvk == "certificates.k8s.io/v1beta1/CertificateSigningRequestList":
        return [(f"certificates.k8s.io/v1beta1/CertificateSigningRequestList:{identifier}",
                 CertificateSigningRequestList(identifier, opts, metadata, spec))]
    if gvk == "coordination.k8s.io/v1/Lease":
        return [(f"coordination.k8s.io/v1/Lease:{identifier}",
                 Lease(identifier, opts, metadata, spec))]
    if gvk == "coordination.k8s.io/v1/LeaseList":
        return [(f"coordination.k8s.io/v1/LeaseList:{identifier}",
                 LeaseList(identifier, opts, metadata, spec))]
    if gvk == "coordination.k8s.io/v1beta1/Lease":
        return [(f"coordination.k8s.io/v1beta1/Lease:{identifier}",
                 Lease(identifier, opts, metadata, spec))]
    if gvk == "coordination.k8s.io/v1beta1/LeaseList":
        return [(f"coordination.k8s.io/v1beta1/LeaseList:{identifier}",
                 LeaseList(identifier, opts, metadata, spec))]
    if gvk == "v1/Binding":
        return [(f"v1/Binding:{identifier}",
                 Binding(identifier, opts, metadata, spec))]
    if gvk == "v1/ComponentStatus":
        return [(f"v1/ComponentStatus:{identifier}",
                 ComponentStatus(identifier, opts, metadata, spec))]
    if gvk == "v1/ComponentStatusList":
        return [(f"v1/ComponentStatusList:{identifier}",
                 ComponentStatusList(identifier, opts, metadata, spec))]
    if gvk == "v1/ConfigMap":
        return [(f"v1/ConfigMap:{identifier}",
                 ConfigMap(identifier, opts, metadata, spec))]
    if gvk == "v1/ConfigMapList":
        return [(f"v1/ConfigMapList:{identifier}",
                 ConfigMapList(identifier, opts, metadata, spec))]
    if gvk == "v1/Endpoints":
        return [(f"v1/Endpoints:{identifier}",
                 Endpoints(identifier, opts, metadata, spec))]
    if gvk == "v1/EndpointsList":
        return [(f"v1/EndpointsList:{identifier}",
                 EndpointsList(identifier, opts, metadata, spec))]
    if gvk == "v1/Event":
        return [(f"v1/Event:{identifier}",
                 Event(identifier, opts, metadata, spec))]
    if gvk == "v1/EventList":
        return [(f"v1/EventList:{identifier}",
                 EventList(identifier, opts, metadata, spec))]
    if gvk == "v1/LimitRange":
        return [(f"v1/LimitRange:{identifier}",
                 LimitRange(identifier, opts, metadata, spec))]
    if gvk == "v1/LimitRangeList":
        return [(f"v1/LimitRangeList:{identifier}",
                 LimitRangeList(identifier, opts, metadata, spec))]
    if gvk == "v1/Namespace":
        return [(f"v1/Namespace:{identifier}",
                 Namespace(identifier, opts, metadata, spec))]
    if gvk == "v1/NamespaceList":
        return [(f"v1/NamespaceList:{identifier}",
                 NamespaceList(identifier, opts, metadata, spec))]
    if gvk == "v1/Node":
        return [(f"v1/Node:{identifier}",
                 Node(identifier, opts, metadata, spec))]
    if gvk == "v1/NodeList":
        return [(f"v1/NodeList:{identifier}",
                 NodeList(identifier, opts, metadata, spec))]
    if gvk == "v1/PersistentVolume":
        return [(f"v1/PersistentVolume:{identifier}",
                 PersistentVolume(identifier, opts, metadata, spec))]
    if gvk == "v1/PersistentVolumeClaim":
        return [(f"v1/PersistentVolumeClaim:{identifier}",
                 PersistentVolumeClaim(identifier, opts, metadata, spec))]
    if gvk == "v1/PersistentVolumeClaimList":
        return [(f"v1/PersistentVolumeClaimList:{identifier}",
                 PersistentVolumeClaimList(identifier, opts, metadata, spec))]
    if gvk == "v1/PersistentVolumeList":
        return [(f"v1/PersistentVolumeList:{identifier}",
                 PersistentVolumeList(identifier, opts, metadata, spec))]
    if gvk == "v1/Pod":
        return [(f"v1/Pod:{identifier}",
                 Pod(identifier, opts, metadata, spec))]
    if gvk == "v1/PodList":
        return [(f"v1/PodList:{identifier}",
                 PodList(identifier, opts, metadata, spec))]
    if gvk == "v1/PodTemplate":
        return [(f"v1/PodTemplate:{identifier}",
                 PodTemplate(identifier, opts, metadata, spec))]
    if gvk == "v1/PodTemplateList":
        return [(f"v1/PodTemplateList:{identifier}",
                 PodTemplateList(identifier, opts, metadata, spec))]
    if gvk == "v1/ReplicationController":
        return [(f"v1/ReplicationController:{identifier}",
                 ReplicationController(identifier, opts, metadata, spec))]
    if gvk == "v1/ReplicationControllerList":
        return [(f"v1/ReplicationControllerList:{identifier}",
                 ReplicationControllerList(identifier, opts, metadata, spec))]
    if gvk == "v1/ResourceQuota":
        return [(f"v1/ResourceQuota:{identifier}",
                 ResourceQuota(identifier, opts, metadata, spec))]
    if gvk == "v1/ResourceQuotaList":
        return [(f"v1/ResourceQuotaList:{identifier}",
                 ResourceQuotaList(identifier, opts, metadata, spec))]
    if gvk == "v1/Secret":
        return [(f"v1/Secret:{identifier}",
                 Secret(identifier, opts, metadata, spec))]
    if gvk == "v1/SecretList":
        return [(f"v1/SecretList:{identifier}",
                 SecretList(identifier, opts, metadata, spec))]
    if gvk == "v1/Service":
        return [(f"v1/Service:{identifier}",
                 Service(identifier, opts, metadata, spec))]
    if gvk == "v1/ServiceAccount":
        return [(f"v1/ServiceAccount:{identifier}",
                 ServiceAccount(identifier, opts, metadata, spec))]
    if gvk == "v1/ServiceAccountList":
        return [(f"v1/ServiceAccountList:{identifier}",
                 ServiceAccountList(identifier, opts, metadata, spec))]
    if gvk == "v1/ServiceList":
        return [(f"v1/ServiceList:{identifier}",
                 ServiceList(identifier, opts, metadata, spec))]
    if gvk == "events.k8s.io/v1beta1/Event":
        return [(f"events.k8s.io/v1beta1/Event:{identifier}",
                 Event(identifier, opts, metadata, spec))]
    if gvk == "events.k8s.io/v1beta1/EventList":
        return [(f"events.k8s.io/v1beta1/EventList:{identifier}",
                 EventList(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/DaemonSet":
        return [(f"extensions/v1beta1/DaemonSet:{identifier}",
                 DaemonSet(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/DaemonSetList":
        return [(f"extensions/v1beta1/DaemonSetList:{identifier}",
                 DaemonSetList(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/Deployment":
        return [(f"extensions/v1beta1/Deployment:{identifier}",
                 Deployment(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/DeploymentList":
        return [(f"extensions/v1beta1/DeploymentList:{identifier}",
                 DeploymentList(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/Ingress":
        return [(f"extensions/v1beta1/Ingress:{identifier}",
                 Ingress(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/IngressList":
        return [(f"extensions/v1beta1/IngressList:{identifier}",
                 IngressList(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/NetworkPolicy":
        return [(f"extensions/v1beta1/NetworkPolicy:{identifier}",
                 NetworkPolicy(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/NetworkPolicyList":
        return [(f"extensions/v1beta1/NetworkPolicyList:{identifier}",
                 NetworkPolicyList(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/PodSecurityPolicy":
        return [(f"extensions/v1beta1/PodSecurityPolicy:{identifier}",
                 PodSecurityPolicy(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/PodSecurityPolicyList":
        return [(f"extensions/v1beta1/PodSecurityPolicyList:{identifier}",
                 PodSecurityPolicyList(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/ReplicaSet":
        return [(f"extensions/v1beta1/ReplicaSet:{identifier}",
                 ReplicaSet(identifier, opts, metadata, spec))]
    if gvk == "extensions/v1beta1/ReplicaSetList":
        return [(f"extensions/v1beta1/ReplicaSetList:{identifier}",
                 ReplicaSetList(identifier, opts, metadata, spec))]
    if gvk == "v1/Status":
        return [(f"v1/Status:{identifier}",
                 Status(identifier, opts, metadata, spec))]
    if gvk == "networking.k8s.io/v1/NetworkPolicy":
        return [(f"networking.k8s.io/v1/NetworkPolicy:{identifier}",
                 NetworkPolicy(identifier, opts, metadata, spec))]
    if gvk == "networking.k8s.io/v1/NetworkPolicyList":
        return [(f"networking.k8s.io/v1/NetworkPolicyList:{identifier}",
                 NetworkPolicyList(identifier, opts, metadata, spec))]
    if gvk == "networking.k8s.io/v1beta1/Ingress":
        return [(f"networking.k8s.io/v1beta1/Ingress:{identifier}",
                 Ingress(identifier, opts, metadata, spec))]
    if gvk == "networking.k8s.io/v1beta1/IngressList":
        return [(f"networking.k8s.io/v1beta1/IngressList:{identifier}",
                 IngressList(identifier, opts, metadata, spec))]
    if gvk == "node.k8s.io/v1alpha1/RuntimeClass":
        return [(f"node.k8s.io/v1alpha1/RuntimeClass:{identifier}",
                 RuntimeClass(identifier, opts, metadata, spec))]
    if gvk == "node.k8s.io/v1alpha1/RuntimeClassList":
        return [(f"node.k8s.io/v1alpha1/RuntimeClassList:{identifier}",
                 RuntimeClassList(identifier, opts, metadata, spec))]
    if gvk == "node.k8s.io/v1beta1/RuntimeClass":
        return [(f"node.k8s.io/v1beta1/RuntimeClass:{identifier}",
                 RuntimeClass(identifier, opts, metadata, spec))]
    if gvk == "node.k8s.io/v1beta1/RuntimeClassList":
        return [(f"node.k8s.io/v1beta1/RuntimeClassList:{identifier}",
                 RuntimeClassList(identifier, opts, metadata, spec))]
    if gvk == "policy/v1beta1/PodDisruptionBudget":
        return [(f"policy/v1beta1/PodDisruptionBudget:{identifier}",
                 PodDisruptionBudget(identifier, opts, metadata, spec))]
    if gvk == "policy/v1beta1/PodDisruptionBudgetList":
        return [(f"policy/v1beta1/PodDisruptionBudgetList:{identifier}",
                 PodDisruptionBudgetList(identifier, opts, metadata, spec))]
    if gvk == "policy/v1beta1/PodSecurityPolicy":
        return [(f"policy/v1beta1/PodSecurityPolicy:{identifier}",
                 PodSecurityPolicy(identifier, opts, metadata, spec))]
    if gvk == "policy/v1beta1/PodSecurityPolicyList":
        return [(f"policy/v1beta1/PodSecurityPolicyList:{identifier}",
                 PodSecurityPolicyList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1/ClusterRole":
        return [(f"rbac.authorization.k8s.io/v1/ClusterRole:{identifier}",
                 ClusterRole(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1/ClusterRoleBinding":
        return [(f"rbac.authorization.k8s.io/v1/ClusterRoleBinding:{identifier}",
                 ClusterRoleBinding(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1/ClusterRoleBindingList":
        return [(f"rbac.authorization.k8s.io/v1/ClusterRoleBindingList:{identifier}",
                 ClusterRoleBindingList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1/ClusterRoleList":
        return [(f"rbac.authorization.k8s.io/v1/ClusterRoleList:{identifier}",
                 ClusterRoleList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1/Role":
        return [(f"rbac.authorization.k8s.io/v1/Role:{identifier}",
                 Role(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1/RoleBinding":
        return [(f"rbac.authorization.k8s.io/v1/RoleBinding:{identifier}",
                 RoleBinding(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1/RoleBindingList":
        return [(f"rbac.authorization.k8s.io/v1/RoleBindingList:{identifier}",
                 RoleBindingList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1/RoleList":
        return [(f"rbac.authorization.k8s.io/v1/RoleList:{identifier}",
                 RoleList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1alpha1/ClusterRole":
        return [(f"rbac.authorization.k8s.io/v1alpha1/ClusterRole:{identifier}",
                 ClusterRole(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1alpha1/ClusterRoleBinding":
        return [(f"rbac.authorization.k8s.io/v1alpha1/ClusterRoleBinding:{identifier}",
                 ClusterRoleBinding(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1alpha1/ClusterRoleBindingList":
        return [(f"rbac.authorization.k8s.io/v1alpha1/ClusterRoleBindingList:{identifier}",
                 ClusterRoleBindingList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1alpha1/ClusterRoleList":
        return [(f"rbac.authorization.k8s.io/v1alpha1/ClusterRoleList:{identifier}",
                 ClusterRoleList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1alpha1/Role":
        return [(f"rbac.authorization.k8s.io/v1alpha1/Role:{identifier}",
                 Role(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1alpha1/RoleBinding":
        return [(f"rbac.authorization.k8s.io/v1alpha1/RoleBinding:{identifier}",
                 RoleBinding(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1alpha1/RoleBindingList":
        return [(f"rbac.authorization.k8s.io/v1alpha1/RoleBindingList:{identifier}",
                 RoleBindingList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1alpha1/RoleList":
        return [(f"rbac.authorization.k8s.io/v1alpha1/RoleList:{identifier}",
                 RoleList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1beta1/ClusterRole":
        return [(f"rbac.authorization.k8s.io/v1beta1/ClusterRole:{identifier}",
                 ClusterRole(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1beta1/ClusterRoleBinding":
        return [(f"rbac.authorization.k8s.io/v1beta1/ClusterRoleBinding:{identifier}",
                 ClusterRoleBinding(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1beta1/ClusterRoleBindingList":
        return [(f"rbac.authorization.k8s.io/v1beta1/ClusterRoleBindingList:{identifier}",
                 ClusterRoleBindingList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1beta1/ClusterRoleList":
        return [(f"rbac.authorization.k8s.io/v1beta1/ClusterRoleList:{identifier}",
                 ClusterRoleList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1beta1/Role":
        return [(f"rbac.authorization.k8s.io/v1beta1/Role:{identifier}",
                 Role(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1beta1/RoleBinding":
        return [(f"rbac.authorization.k8s.io/v1beta1/RoleBinding:{identifier}",
                 RoleBinding(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1beta1/RoleBindingList":
        return [(f"rbac.authorization.k8s.io/v1beta1/RoleBindingList:{identifier}",
                 RoleBindingList(identifier, opts, metadata, spec))]
    if gvk == "rbac.authorization.k8s.io/v1beta1/RoleList":
        return [(f"rbac.authorization.k8s.io/v1beta1/RoleList:{identifier}",
                 RoleList(identifier, opts, metadata, spec))]
    if gvk == "scheduling.k8s.io/v1/PriorityClass":
        return [(f"scheduling.k8s.io/v1/PriorityClass:{identifier}",
                 PriorityClass(identifier, opts, metadata, spec))]
    if gvk == "scheduling.k8s.io/v1/PriorityClassList":
        return [(f"scheduling.k8s.io/v1/PriorityClassList:{identifier}",
                 PriorityClassList(identifier, opts, metadata, spec))]
    if gvk == "scheduling.k8s.io/v1alpha1/PriorityClass":
        return [(f"scheduling.k8s.io/v1alpha1/PriorityClass:{identifier}",
                 PriorityClass(identifier, opts, metadata, spec))]
    if gvk == "scheduling.k8s.io/v1alpha1/PriorityClassList":
        return [(f"scheduling.k8s.io/v1alpha1/PriorityClassList:{identifier}",
                 PriorityClassList(identifier, opts, metadata, spec))]
    if gvk == "scheduling.k8s.io/v1beta1/PriorityClass":
        return [(f"scheduling.k8s.io/v1beta1/PriorityClass:{identifier}",
                 PriorityClass(identifier, opts, metadata, spec))]
    if gvk == "scheduling.k8s.io/v1beta1/PriorityClassList":
        return [(f"scheduling.k8s.io/v1beta1/PriorityClassList:{identifier}",
                 PriorityClassList(identifier, opts, metadata, spec))]
    if gvk == "settings.k8s.io/v1alpha1/PodPreset":
        return [(f"settings.k8s.io/v1alpha1/PodPreset:{identifier}",
                 PodPreset(identifier, opts, metadata, spec))]
    if gvk == "settings.k8s.io/v1alpha1/PodPresetList":
        return [(f"settings.k8s.io/v1alpha1/PodPresetList:{identifier}",
                 PodPresetList(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1/StorageClass":
        return [(f"storage.k8s.io/v1/StorageClass:{identifier}",
                 StorageClass(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1/StorageClassList":
        return [(f"storage.k8s.io/v1/StorageClassList:{identifier}",
                 StorageClassList(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1/VolumeAttachment":
        return [(f"storage.k8s.io/v1/VolumeAttachment:{identifier}",
                 VolumeAttachment(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1/VolumeAttachmentList":
        return [(f"storage.k8s.io/v1/VolumeAttachmentList:{identifier}",
                 VolumeAttachmentList(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1alpha1/VolumeAttachment":
        return [(f"storage.k8s.io/v1alpha1/VolumeAttachment:{identifier}",
                 VolumeAttachment(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1alpha1/VolumeAttachmentList":
        return [(f"storage.k8s.io/v1alpha1/VolumeAttachmentList:{identifier}",
                 VolumeAttachmentList(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1beta1/CSIDriver":
        return [(f"storage.k8s.io/v1beta1/CSIDriver:{identifier}",
                 CSIDriver(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1beta1/CSIDriverList":
        return [(f"storage.k8s.io/v1beta1/CSIDriverList:{identifier}",
                 CSIDriverList(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1beta1/CSINode":
        return [(f"storage.k8s.io/v1beta1/CSINode:{identifier}",
                 CSINode(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1beta1/CSINodeList":
        return [(f"storage.k8s.io/v1beta1/CSINodeList:{identifier}",
                 CSINodeList(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1beta1/StorageClass":
        return [(f"storage.k8s.io/v1beta1/StorageClass:{identifier}",
                 StorageClass(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1beta1/StorageClassList":
        return [(f"storage.k8s.io/v1beta1/StorageClassList:{identifier}",
                 StorageClassList(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1beta1/VolumeAttachment":
        return [(f"storage.k8s.io/v1beta1/VolumeAttachment:{identifier}",
                 VolumeAttachment(identifier, opts, metadata, spec))]
    if gvk == "storage.k8s.io/v1beta1/VolumeAttachmentList":
        return [(f"storage.k8s.io/v1beta1/VolumeAttachmentList:{identifier}",
                 VolumeAttachmentList(identifier, opts, metadata, spec))]
    raise Exception(f"Unsupported gvk: {gvk}")
