from subprocess import check_call

from setuptools import setup, find_packages
from setuptools.command.install import install


class InstallPluginCommand(install):
    def run(self):
        install.run(self)
        check_call(['pulumi', 'plugin', 'install', 'resource', 'kubernetes', 'v0.22.1-dev.1554172342+g5bb247b'])


def readme():
    with open('README.rst') as f:
        return f.read()


setup(name='pulumi_kubernetes',
      version='0.22.1.dev1554172342',
      description='A Pulumi package for creating and managing Kubernetes resources.',
      long_description=readme(),
      cmdclass={
          'install': InstallPluginCommand,
      },
      keywords='pulumi kubernetes',
      url='https://pulumi.io',
      project_urls={
          'Repository': 'https://github.com/pulumi/pulumi-kubernetes'
      },
      license='Apache-2.0',
      packages=find_packages(),
      install_requires=[
          'pulumi>=0.17.1,<0.18.0',
          'requests>=2.21.0,<2.22.0',
          'pyyaml>=4.2b1,<4.3',
      ],
      zip_safe=False)
