from typing import Annotated

from langchain_core.prompts import ChatPromptTemplate, MessagesPlaceholder
from langchain_core.runnables import Runnable, RunnableConfig
from langchain_core.tools import tool
from langgraph.prebuilt import InjectedState, tools_condition

# from mtmai.agents.graphchatdemo.tools.python_repl_tool import python_repl_tool
from mtmai.agents.graphchatdemo.tools.search_tools import search_tool
from mtmai.agents.states.ctx import get_mtmai_ctx
from mtmai.agents.states.state import MainState
from mtmai.core.config import settings
from mtmai.core.logging import get_logger

logger = get_logger()


def edge_chat_node(state: MainState):
    is_tools = tools_condition(state)
    if is_tools == "tools":
        return "chat_tools_node"
    if state.get("next"):
        return state.get("next")
    else:
        return "human_node"


# @tool
# def call_supervisor(question: str):
#     """Useful to call supervisor"""
#     logger.info("调用 call_supervisor 工具 %s", question)
#     return [f"我已经收到用户的问题, 正在后台处理 {question}"]


@tool(parse_docstring=False, response_format="content_and_artifact")
def open_document_editor(title: str, state: Annotated[dict, InjectedState]):
    """Useful to show document editor ui for user, 用户能够看到这个编辑器进行文章编辑"""
    return (
        "操作成功",
        {
            "artifaceType": "Document",
            "props": {
                "id": "fake-document-id",
                "title": "document-title1",
            },
        },
    )


@tool(parse_docstring=False, response_format="content_and_artifact")
def create_document(title: str, content: str, state: Annotated[dict, InjectedState]):
    """Useful to create new document for user"""
    return (
        "操作成功",
        {
            "artifaceType": "Document",
            "props": {
                "id": "fake-document-id",
                "title": title,
            },
        },
    )


@tool(parse_docstring=False, response_format="content_and_artifact")
def show_workflow_image():
    """Useful tool for displaying the internal workflow diagram of the current agent."""
    return (
        "Operation successful",
        {
            "artifaceType": "Image",
            "props": {
                "src": f"{settings.API_V1_STR}/agent/image/mtmaibot",
                "title": "流程图",
            },
        },
    )


@tool(parse_docstring=False, response_format="content_and_artifact")
def show_supperadmin_panel():
    """当用户明确要求显示管理面板时，显示管理面板给用户进行下一步的操作"""
    return (
        "Operation successful",
        {
            "artifaceType": "AdminView",
            "props": {
                "title": "管理面板",
            },
        },
    )


chatbot_tools = [
    search_tool,
    create_document,
]


class ChatNode:
    def __init__(self, runnable: Runnable):
        self.runnable = runnable

    async def __call__(self, state: MainState, config: RunnableConfig):
        messages = state.messages
        if len(messages) < 1:
            raise Exception("消息长度不正确")  # noqa: EM101, TRY002
        ctx = get_mtmai_ctx()
        direct_gen_outline_prompt = ChatPromptTemplate.from_messages(
            [
                (
                    "system",
                    "你是网站前端 copilot 助手，负责展示网站前端管理面板，用户通过管理面板可以进行文章编辑，文章发布等操作"
                    "[ IMPORTANT ]:"
                    "\n- 必须使用简体中文",
                ),
                MessagesPlaceholder(variable_name="messages", optional=True),
            ]
        )
        # ai_msg = await ctx.call_model_chat(
        #     direct_gen_outline_prompt, {"messages": messages}
        # )

        messages = await direct_gen_outline_prompt.ainvoke({"messages": messages})
        ai_msg = await self.runnable.ainvoke(messages, config)

        finnal_state = {
            "messages": [
                ai_msg,
            ],
        }
        return finnal_state
