from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class VinAccessType(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    VIN_ACCESS_TYPE_UNKNOWN: _ClassVar[VinAccessType]
    VIN_ACCESS_TYPE_PRIMARY: _ClassVar[VinAccessType]
    VIN_ACCESS_TYPE_SECONDARY: _ClassVar[VinAccessType]
    VIN_ACCESS_TYPE_NONE: _ClassVar[VinAccessType]

class Theme(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    THEME_UNKNOWN: _ClassVar[Theme]
    THEME_DAY: _ClassVar[Theme]
    THEME_NIGHT: _ClassVar[Theme]
    THEME_SOLITUDE: _ClassVar[Theme]
    THEME_SERENE: _ClassVar[Theme]
    THEME_ESCAPE: _ClassVar[Theme]
    THEME_SPACE: _ClassVar[Theme]
    THEME_SAPPHIRE: _ClassVar[Theme]
    THEME_INSPIRE: _ClassVar[Theme]
    THEME_WONDER: _ClassVar[Theme]

class BluetoothState(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    BLUETOOTH_STATE_UNKNOWN: _ClassVar[BluetoothState]
    BLUETOOTH_STATE_ON: _ClassVar[BluetoothState]
    BLUETOOTH_STATE_OFF: _ClassVar[BluetoothState]

class TemperatureUnits(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    TEMPERATURE_UNITS_UNKNOWN: _ClassVar[TemperatureUnits]
    TEMPERATURE_UNITS_FAHRENHEIT: _ClassVar[TemperatureUnits]
    TEMPERATURE_UNITS_CELSIUS: _ClassVar[TemperatureUnits]

class TimeFormat(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    TIME_FORMAT_UNKNOWN: _ClassVar[TimeFormat]
    TIME_FORMAT_TWELVE_HOUR: _ClassVar[TimeFormat]
    TIME_FORMAT_TWENTY_FOUR_HOUR: _ClassVar[TimeFormat]

class SystemLanguage(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    SYSTEM_LANGUAGE_UNKNOWN: _ClassVar[SystemLanguage]
    SYSTEM_LANGUAGE_EN_US: _ClassVar[SystemLanguage]
    SYSTEM_LANGUAGE_EN_CA: _ClassVar[SystemLanguage]
    SYSTEM_LANGUAGE_TODO_LANGUAGES: _ClassVar[SystemLanguage]

class BatteryUnits(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    BATTERY_UNITS_UNKNOWN: _ClassVar[BatteryUnits]
    BATTERY_UNITS_DISTANCE: _ClassVar[BatteryUnits]
    BATTERY_UNITS_PERCENTAGE: _ClassVar[BatteryUnits]

class TirePressureUnits(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    TIRE_PRESSURE_UNITS_UNKNOWN: _ClassVar[TirePressureUnits]
    TIRE_PRESSURE_UNITS_PSI: _ClassVar[TirePressureUnits]
    TIRE_PRESSURE_UNITS_KILOPASCAL: _ClassVar[TirePressureUnits]

class DistanceUnits(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    DISTANCE_UNITS_UNKNOWN: _ClassVar[DistanceUnits]
    DISTANCE_UNITS_MILES: _ClassVar[DistanceUnits]
    DISTANCE_UNITS_KILOMETERS: _ClassVar[DistanceUnits]

class HeightSetting(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    HEIGHT_SETTING_UNKNOWN: _ClassVar[HeightSetting]
    HEIGHT_SETTING_LEVEL_1: _ClassVar[HeightSetting]
    HEIGHT_SETTING_LEVEL_2: _ClassVar[HeightSetting]
    HEIGHT_SETTING_LEVEL_3: _ClassVar[HeightSetting]
    HEIGHT_SETTING_LEVEL_4: _ClassVar[HeightSetting]

class EasyEntrySetting(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    EASY_ENTRY_SETTING_UNKNOWN: _ClassVar[EasyEntrySetting]
    EASY_ENTRY_SETTING_SEATS_ONLY: _ClassVar[EasyEntrySetting]
    EASY_ENTRY_SETTING_SEATS_AND_STEERING: _ClassVar[EasyEntrySetting]

class EasyEntryRideHeight(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
    __slots__ = ()
    EASY_ENTRY_RIDE_HEIGHT_UNKNOWN: _ClassVar[EasyEntryRideHeight]
    EASY_ENTRY_RIDE_HEIGHT_LOWEST: _ClassVar[EasyEntryRideHeight]
VIN_ACCESS_TYPE_UNKNOWN: VinAccessType
VIN_ACCESS_TYPE_PRIMARY: VinAccessType
VIN_ACCESS_TYPE_SECONDARY: VinAccessType
VIN_ACCESS_TYPE_NONE: VinAccessType
THEME_UNKNOWN: Theme
THEME_DAY: Theme
THEME_NIGHT: Theme
THEME_SOLITUDE: Theme
THEME_SERENE: Theme
THEME_ESCAPE: Theme
THEME_SPACE: Theme
THEME_SAPPHIRE: Theme
THEME_INSPIRE: Theme
THEME_WONDER: Theme
BLUETOOTH_STATE_UNKNOWN: BluetoothState
BLUETOOTH_STATE_ON: BluetoothState
BLUETOOTH_STATE_OFF: BluetoothState
TEMPERATURE_UNITS_UNKNOWN: TemperatureUnits
TEMPERATURE_UNITS_FAHRENHEIT: TemperatureUnits
TEMPERATURE_UNITS_CELSIUS: TemperatureUnits
TIME_FORMAT_UNKNOWN: TimeFormat
TIME_FORMAT_TWELVE_HOUR: TimeFormat
TIME_FORMAT_TWENTY_FOUR_HOUR: TimeFormat
SYSTEM_LANGUAGE_UNKNOWN: SystemLanguage
SYSTEM_LANGUAGE_EN_US: SystemLanguage
SYSTEM_LANGUAGE_EN_CA: SystemLanguage
SYSTEM_LANGUAGE_TODO_LANGUAGES: SystemLanguage
BATTERY_UNITS_UNKNOWN: BatteryUnits
BATTERY_UNITS_DISTANCE: BatteryUnits
BATTERY_UNITS_PERCENTAGE: BatteryUnits
TIRE_PRESSURE_UNITS_UNKNOWN: TirePressureUnits
TIRE_PRESSURE_UNITS_PSI: TirePressureUnits
TIRE_PRESSURE_UNITS_KILOPASCAL: TirePressureUnits
DISTANCE_UNITS_UNKNOWN: DistanceUnits
DISTANCE_UNITS_MILES: DistanceUnits
DISTANCE_UNITS_KILOMETERS: DistanceUnits
HEIGHT_SETTING_UNKNOWN: HeightSetting
HEIGHT_SETTING_LEVEL_1: HeightSetting
HEIGHT_SETTING_LEVEL_2: HeightSetting
HEIGHT_SETTING_LEVEL_3: HeightSetting
HEIGHT_SETTING_LEVEL_4: HeightSetting
EASY_ENTRY_SETTING_UNKNOWN: EasyEntrySetting
EASY_ENTRY_SETTING_SEATS_ONLY: EasyEntrySetting
EASY_ENTRY_SETTING_SEATS_AND_STEERING: EasyEntrySetting
EASY_ENTRY_RIDE_HEIGHT_UNKNOWN: EasyEntryRideHeight
EASY_ENTRY_RIDE_HEIGHT_LOWEST: EasyEntryRideHeight

class Empty(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class MobileKeyPairing(_message.Message):
    __slots__ = ("device_type", "device_id")
    DEVICE_TYPE_FIELD_NUMBER: _ClassVar[int]
    DEVICE_ID_FIELD_NUMBER: _ClassVar[int]
    device_type: int
    device_id: str
    def __init__(self, device_type: _Optional[int] = ..., device_id: _Optional[str] = ...) -> None: ...

class KeyFobLinking(_message.Message):
    __slots__ = ("device_type", "deviceId")
    DEVICE_TYPE_FIELD_NUMBER: _ClassVar[int]
    DEVICEID_FIELD_NUMBER: _ClassVar[int]
    device_type: int
    deviceId: str
    def __init__(self, device_type: _Optional[int] = ..., deviceId: _Optional[str] = ...) -> None: ...

class PreferencesManagement(_message.Message):
    __slots__ = ("key_assignment", "key_reassignment", "key_unassignment", "remove_preferences")
    KEY_ASSIGNMENT_FIELD_NUMBER: _ClassVar[int]
    KEY_REASSIGNMENT_FIELD_NUMBER: _ClassVar[int]
    KEY_UNASSIGNMENT_FIELD_NUMBER: _ClassVar[int]
    REMOVE_PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    key_assignment: bool
    key_reassignment: bool
    key_unassignment: bool
    remove_preferences: bool
    def __init__(self, key_assignment: bool = ..., key_reassignment: bool = ..., key_unassignment: bool = ..., remove_preferences: bool = ...) -> None: ...

class BluetoothDevice(_message.Message):
    __slots__ = ("device_id", "mac_address", "pairing_priority_phone_functions", "pairing_priority_audio_functions")
    DEVICE_ID_FIELD_NUMBER: _ClassVar[int]
    MAC_ADDRESS_FIELD_NUMBER: _ClassVar[int]
    PAIRING_PRIORITY_PHONE_FUNCTIONS_FIELD_NUMBER: _ClassVar[int]
    PAIRING_PRIORITY_AUDIO_FUNCTIONS_FIELD_NUMBER: _ClassVar[int]
    device_id: str
    mac_address: str
    pairing_priority_phone_functions: int
    pairing_priority_audio_functions: int
    def __init__(self, device_id: _Optional[str] = ..., mac_address: _Optional[str] = ..., pairing_priority_phone_functions: _Optional[int] = ..., pairing_priority_audio_functions: _Optional[int] = ...) -> None: ...

class DataSharing(_message.Message):
    __slots__ = ("data_sharing", "vehicle_privacy_policy")
    DATA_SHARING_FIELD_NUMBER: _ClassVar[int]
    VEHICLE_PRIVACY_POLICY_FIELD_NUMBER: _ClassVar[int]
    data_sharing: bool
    vehicle_privacy_policy: bool
    def __init__(self, data_sharing: bool = ..., vehicle_privacy_policy: bool = ...) -> None: ...

class VinPreferences(_message.Message):
    __slots__ = ("vin", "access_type", "mobile_key_pairing", "key_fob_linking", "preferences_management", "theme", "ota_trigger_and_scheduling", "face_id", "bluetooth_state", "bluetooth_saved_devices")
    VIN_FIELD_NUMBER: _ClassVar[int]
    ACCESS_TYPE_FIELD_NUMBER: _ClassVar[int]
    MOBILE_KEY_PAIRING_FIELD_NUMBER: _ClassVar[int]
    KEY_FOB_LINKING_FIELD_NUMBER: _ClassVar[int]
    PREFERENCES_MANAGEMENT_FIELD_NUMBER: _ClassVar[int]
    THEME_FIELD_NUMBER: _ClassVar[int]
    OTA_TRIGGER_AND_SCHEDULING_FIELD_NUMBER: _ClassVar[int]
    FACE_ID_FIELD_NUMBER: _ClassVar[int]
    BLUETOOTH_STATE_FIELD_NUMBER: _ClassVar[int]
    BLUETOOTH_SAVED_DEVICES_FIELD_NUMBER: _ClassVar[int]
    vin: str
    access_type: VinAccessType
    mobile_key_pairing: MobileKeyPairing
    key_fob_linking: KeyFobLinking
    preferences_management: PreferencesManagement
    theme: Theme
    ota_trigger_and_scheduling: bool
    face_id: bytes
    bluetooth_state: BluetoothState
    bluetooth_saved_devices: _containers.RepeatedCompositeFieldContainer[BluetoothDevice]
    def __init__(self, vin: _Optional[str] = ..., access_type: _Optional[_Union[VinAccessType, str]] = ..., mobile_key_pairing: _Optional[_Union[MobileKeyPairing, _Mapping]] = ..., key_fob_linking: _Optional[_Union[KeyFobLinking, _Mapping]] = ..., preferences_management: _Optional[_Union[PreferencesManagement, _Mapping]] = ..., theme: _Optional[_Union[Theme, str]] = ..., ota_trigger_and_scheduling: bool = ..., face_id: _Optional[bytes] = ..., bluetooth_state: _Optional[_Union[BluetoothState, str]] = ..., bluetooth_saved_devices: _Optional[_Iterable[_Union[BluetoothDevice, _Mapping]]] = ...) -> None: ...

class UserPreferences(_message.Message):
    __slots__ = ("first_name", "last_name", "nickname", "photo_url", "vin_preferences", "pin", "pin_to_switch_toggle", "temperature_units", "time_format", "system_language", "battery_units", "tire_pressure_units", "distance_units", "data_sharing", "home_address", "work_address", "updated_ns", "vehicle_model_preferences", "email")
    FIRST_NAME_FIELD_NUMBER: _ClassVar[int]
    LAST_NAME_FIELD_NUMBER: _ClassVar[int]
    NICKNAME_FIELD_NUMBER: _ClassVar[int]
    PHOTO_URL_FIELD_NUMBER: _ClassVar[int]
    VIN_PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    PIN_FIELD_NUMBER: _ClassVar[int]
    PIN_TO_SWITCH_TOGGLE_FIELD_NUMBER: _ClassVar[int]
    TEMPERATURE_UNITS_FIELD_NUMBER: _ClassVar[int]
    TIME_FORMAT_FIELD_NUMBER: _ClassVar[int]
    SYSTEM_LANGUAGE_FIELD_NUMBER: _ClassVar[int]
    BATTERY_UNITS_FIELD_NUMBER: _ClassVar[int]
    TIRE_PRESSURE_UNITS_FIELD_NUMBER: _ClassVar[int]
    DISTANCE_UNITS_FIELD_NUMBER: _ClassVar[int]
    DATA_SHARING_FIELD_NUMBER: _ClassVar[int]
    HOME_ADDRESS_FIELD_NUMBER: _ClassVar[int]
    WORK_ADDRESS_FIELD_NUMBER: _ClassVar[int]
    UPDATED_NS_FIELD_NUMBER: _ClassVar[int]
    VEHICLE_MODEL_PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    EMAIL_FIELD_NUMBER: _ClassVar[int]
    first_name: str
    last_name: str
    nickname: str
    photo_url: str
    vin_preferences: _containers.RepeatedCompositeFieldContainer[VinPreferences]
    pin: int
    pin_to_switch_toggle: bytes
    temperature_units: TemperatureUnits
    time_format: TimeFormat
    system_language: SystemLanguage
    battery_units: BatteryUnits
    tire_pressure_units: TirePressureUnits
    distance_units: DistanceUnits
    data_sharing: DataSharing
    home_address: str
    work_address: str
    updated_ns: int
    vehicle_model_preferences: _containers.RepeatedCompositeFieldContainer[VehicleModelPreferences]
    email: str
    def __init__(self, first_name: _Optional[str] = ..., last_name: _Optional[str] = ..., nickname: _Optional[str] = ..., photo_url: _Optional[str] = ..., vin_preferences: _Optional[_Iterable[_Union[VinPreferences, _Mapping]]] = ..., pin: _Optional[int] = ..., pin_to_switch_toggle: _Optional[bytes] = ..., temperature_units: _Optional[_Union[TemperatureUnits, str]] = ..., time_format: _Optional[_Union[TimeFormat, str]] = ..., system_language: _Optional[_Union[SystemLanguage, str]] = ..., battery_units: _Optional[_Union[BatteryUnits, str]] = ..., tire_pressure_units: _Optional[_Union[TirePressureUnits, str]] = ..., distance_units: _Optional[_Union[DistanceUnits, str]] = ..., data_sharing: _Optional[_Union[DataSharing, _Mapping]] = ..., home_address: _Optional[str] = ..., work_address: _Optional[str] = ..., updated_ns: _Optional[int] = ..., vehicle_model_preferences: _Optional[_Iterable[_Union[VehicleModelPreferences, _Mapping]]] = ..., email: _Optional[str] = ...) -> None: ...

class GetUserPreferencesResponse(_message.Message):
    __slots__ = ("preferences", "commit_ns")
    PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    COMMIT_NS_FIELD_NUMBER: _ClassVar[int]
    preferences: UserPreferences
    commit_ns: int
    def __init__(self, preferences: _Optional[_Union[UserPreferences, _Mapping]] = ..., commit_ns: _Optional[int] = ...) -> None: ...

class CreateUserPreferencesRequest(_message.Message):
    __slots__ = ("preferences",)
    PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    preferences: UserPreferences
    def __init__(self, preferences: _Optional[_Union[UserPreferences, _Mapping]] = ...) -> None: ...

class GetUserPreferencesCommitIDResponse(_message.Message):
    __slots__ = ("commit_ns",)
    COMMIT_NS_FIELD_NUMBER: _ClassVar[int]
    commit_ns: int
    def __init__(self, commit_ns: _Optional[int] = ...) -> None: ...

class SetUserPreferencesRequest(_message.Message):
    __slots__ = ("preferences", "prev_commit_id")
    PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    PREV_COMMIT_ID_FIELD_NUMBER: _ClassVar[int]
    preferences: UserPreferences
    prev_commit_id: int
    def __init__(self, preferences: _Optional[_Union[UserPreferences, _Mapping]] = ..., prev_commit_id: _Optional[int] = ...) -> None: ...

class SetUserPreferencesResponse(_message.Message):
    __slots__ = ("commit_id",)
    COMMIT_ID_FIELD_NUMBER: _ClassVar[int]
    commit_id: int
    def __init__(self, commit_id: _Optional[int] = ...) -> None: ...

class CreateUserVinPreferencesRequest(_message.Message):
    __slots__ = ("preferences",)
    PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    preferences: VinPreferences
    def __init__(self, preferences: _Optional[_Union[VinPreferences, _Mapping]] = ...) -> None: ...

class CreateUserVinPreferencesResponse(_message.Message):
    __slots__ = ("commit_id",)
    COMMIT_ID_FIELD_NUMBER: _ClassVar[int]
    commit_id: int
    def __init__(self, commit_id: _Optional[int] = ...) -> None: ...

class GetUserVinPreferencesRequest(_message.Message):
    __slots__ = ("vin",)
    VIN_FIELD_NUMBER: _ClassVar[int]
    vin: str
    def __init__(self, vin: _Optional[str] = ...) -> None: ...

class GetUserVinPreferencesResponse(_message.Message):
    __slots__ = ("preferences", "commit_id")
    PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    COMMIT_ID_FIELD_NUMBER: _ClassVar[int]
    preferences: VinPreferences
    commit_id: int
    def __init__(self, preferences: _Optional[_Union[VinPreferences, _Mapping]] = ..., commit_id: _Optional[int] = ...) -> None: ...

class SetUserVinPreferencesRequest(_message.Message):
    __slots__ = ("preferences", "prev_commit_id")
    PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    PREV_COMMIT_ID_FIELD_NUMBER: _ClassVar[int]
    preferences: VinPreferences
    prev_commit_id: int
    def __init__(self, preferences: _Optional[_Union[VinPreferences, _Mapping]] = ..., prev_commit_id: _Optional[int] = ...) -> None: ...

class SetUserVinPreferencesResponse(_message.Message):
    __slots__ = ("commit_id",)
    COMMIT_ID_FIELD_NUMBER: _ClassVar[int]
    commit_id: int
    def __init__(self, commit_id: _Optional[int] = ...) -> None: ...

class AudioSettings(_message.Message):
    __slots__ = ("lucid_ui_sounds", "dynamic_volume", "speed_compensation", "avas")
    LUCID_UI_SOUNDS_FIELD_NUMBER: _ClassVar[int]
    DYNAMIC_VOLUME_FIELD_NUMBER: _ClassVar[int]
    SPEED_COMPENSATION_FIELD_NUMBER: _ClassVar[int]
    AVAS_FIELD_NUMBER: _ClassVar[int]
    lucid_ui_sounds: bool
    dynamic_volume: bool
    speed_compensation: bool
    avas: bool
    def __init__(self, lucid_ui_sounds: bool = ..., dynamic_volume: bool = ..., speed_compensation: bool = ..., avas: bool = ...) -> None: ...

class VehicleModelPreferences(_message.Message):
    __slots__ = ("model", "height_setting", "passive_lock", "passive_unlock", "easy_entry", "easy_entry_setting", "easy_entry_ride_height", "screen_brightness", "audio_settings")
    MODEL_FIELD_NUMBER: _ClassVar[int]
    HEIGHT_SETTING_FIELD_NUMBER: _ClassVar[int]
    PASSIVE_LOCK_FIELD_NUMBER: _ClassVar[int]
    PASSIVE_UNLOCK_FIELD_NUMBER: _ClassVar[int]
    EASY_ENTRY_FIELD_NUMBER: _ClassVar[int]
    EASY_ENTRY_SETTING_FIELD_NUMBER: _ClassVar[int]
    EASY_ENTRY_RIDE_HEIGHT_FIELD_NUMBER: _ClassVar[int]
    SCREEN_BRIGHTNESS_FIELD_NUMBER: _ClassVar[int]
    AUDIO_SETTINGS_FIELD_NUMBER: _ClassVar[int]
    model: str
    height_setting: HeightSetting
    passive_lock: bool
    passive_unlock: bool
    easy_entry: bool
    easy_entry_setting: EasyEntrySetting
    easy_entry_ride_height: EasyEntryRideHeight
    screen_brightness: int
    audio_settings: AudioSettings
    def __init__(self, model: _Optional[str] = ..., height_setting: _Optional[_Union[HeightSetting, str]] = ..., passive_lock: bool = ..., passive_unlock: bool = ..., easy_entry: bool = ..., easy_entry_setting: _Optional[_Union[EasyEntrySetting, str]] = ..., easy_entry_ride_height: _Optional[_Union[EasyEntryRideHeight, str]] = ..., screen_brightness: _Optional[int] = ..., audio_settings: _Optional[_Union[AudioSettings, _Mapping]] = ...) -> None: ...

class CreateUserModelPreferencesRequest(_message.Message):
    __slots__ = ("preferences",)
    PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    preferences: VehicleModelPreferences
    def __init__(self, preferences: _Optional[_Union[VehicleModelPreferences, _Mapping]] = ...) -> None: ...

class CreateUserModelPreferencesResponse(_message.Message):
    __slots__ = ("commit_id",)
    COMMIT_ID_FIELD_NUMBER: _ClassVar[int]
    commit_id: int
    def __init__(self, commit_id: _Optional[int] = ...) -> None: ...

class GetUserModelPreferencesRequest(_message.Message):
    __slots__ = ("model",)
    MODEL_FIELD_NUMBER: _ClassVar[int]
    model: str
    def __init__(self, model: _Optional[str] = ...) -> None: ...

class GetUserModelPreferencesResponse(_message.Message):
    __slots__ = ("preferences", "commit_id")
    PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    COMMIT_ID_FIELD_NUMBER: _ClassVar[int]
    preferences: VehicleModelPreferences
    commit_id: int
    def __init__(self, preferences: _Optional[_Union[VehicleModelPreferences, _Mapping]] = ..., commit_id: _Optional[int] = ...) -> None: ...

class SetUserModelPreferencesRequest(_message.Message):
    __slots__ = ("preferences", "prev_commit_id")
    PREFERENCES_FIELD_NUMBER: _ClassVar[int]
    PREV_COMMIT_ID_FIELD_NUMBER: _ClassVar[int]
    preferences: VehicleModelPreferences
    prev_commit_id: int
    def __init__(self, preferences: _Optional[_Union[VehicleModelPreferences, _Mapping]] = ..., prev_commit_id: _Optional[int] = ...) -> None: ...

class SetUserModelPreferencesResponse(_message.Message):
    __slots__ = ("commit_id",)
    COMMIT_ID_FIELD_NUMBER: _ClassVar[int]
    commit_id: int
    def __init__(self, commit_id: _Optional[int] = ...) -> None: ...

class InviteSecondaryOwnerRequest(_message.Message):
    __slots__ = ("vin", "invite_email")
    VIN_FIELD_NUMBER: _ClassVar[int]
    INVITE_EMAIL_FIELD_NUMBER: _ClassVar[int]
    vin: str
    invite_email: str
    def __init__(self, vin: _Optional[str] = ..., invite_email: _Optional[str] = ...) -> None: ...

class RemoveSecondaryOwnerRequest(_message.Message):
    __slots__ = ("vin", "secondary_user_id")
    VIN_FIELD_NUMBER: _ClassVar[int]
    SECONDARY_USER_ID_FIELD_NUMBER: _ClassVar[int]
    vin: str
    secondary_user_id: str
    def __init__(self, vin: _Optional[str] = ..., secondary_user_id: _Optional[str] = ...) -> None: ...
