#pragma once

#include <cstdint>

/**
* @file log_factorial_lookup_table.hpp
* @brief table of \f$\ln(n!)\f$ for \f$n \in [0, {n_max}]\f$
*/

namespace mathutils {

constexpr uint64_t LOG_FACTORIAL_LOOKUP_TABLE_SIZE = 201;

constexpr double LOG_FACTORIAL_LOOKUP_TABLE[201] ={0,
                                                   0,
                                                   0.693147180559945,
                                                   1.79175946922805,
                                                   3.17805383034795,
                                                   4.78749174278205,
                                                   6.5792512120101,
                                                   8.52516136106541,
                                                   10.6046029027453,
                                                   12.8018274800815,
                                                   15.1044125730755,
                                                   17.5023078458739,
                                                   19.9872144956619,
                                                   22.5521638531234,
                                                   25.1912211827387,
                                                   27.8992713838409,
                                                   30.6718601060807,
                                                   33.5050734501369,
                                                   36.3954452080331,
                                                   39.3398841871995,
                                                   42.3356164607535,
                                                   45.3801388984769,
                                                   48.4711813518352,
                                                   51.6066755677644,
                                                   54.7847293981123,
                                                   58.0036052229805,
                                                   61.261701761002,
                                                   64.5575386270063,
                                                   67.8897431371815,
                                                   71.257038967168,
                                                   74.6582363488302,
                                                   78.0922235533153,
                                                   81.557959456115,
                                                   85.0544670175815,
                                                   88.5808275421977,
                                                   92.1361756036871,
                                                   95.7196945421432,
                                                   99.3306124547874,
                                                   102.968198614514,
                                                   106.631760260643,
                                                   110.320639714757,
                                                   114.034211781462,
                                                   117.771881399745,
                                                   121.533081515439,
                                                   125.317271149357,
                                                   129.123933639127,
                                                   132.952575035616,
                                                   136.802722637326,
                                                   140.673923648234,
                                                   144.565743946345,
                                                   148.477766951773,
                                                   152.409592584497,
                                                   156.360836303079,
                                                   160.331128216631,
                                                   164.320112263195,
                                                   168.327445448428,
                                                   172.352797139163,
                                                   176.395848406997,
                                                   180.456291417544,
                                                   184.533828861449,
                                                   188.628173423672,
                                                   192.739047287845,
                                                   196.86618167289,
                                                   201.009316399282,
                                                   205.168199482641,
                                                   209.342586752537,
                                                   213.532241494563,
                                                   217.736934113954,
                                                   221.95644181913,
                                                   226.190548323728,
                                                   230.439043565777,
                                                   234.701723442818,
                                                   238.978389561834,
                                                   243.268849002983,
                                                   247.572914096187,
                                                   251.890402209723,
                                                   256.22113555001,
                                                   260.564940971863,
                                                   264.921649798553,
                                                   269.29109765102,
                                                   273.673124285694,
                                                   278.067573440366,
                                                   282.47429268763,
                                                   286.893133295427,
                                                   291.32395009427,
                                                   295.766601350761,
                                                   300.220948647014,
                                                   304.686856765669,
                                                   309.164193580147,
                                                   313.652829949879,
                                                   318.152639620209,
                                                   322.663499126726,
                                                   327.185287703775,
                                                   331.717887196928,
                                                   336.261181979198,
                                                   340.815058870799,
                                                   345.379407062267,
                                                   349.95411804077,
                                                   354.539085519441,
                                                   359.134205369575,
                                                   363.739375555563,
                                                   368.354496072405,
                                                   372.979468885689,
                                                   377.614197873919,
                                                   382.25858877306,
                                                   386.912549123218,
                                                   391.57598821733,
                                                   396.248817051792,
                                                   400.930948278916,
                                                   405.622296161145,
                                                   410.322776526937,
                                                   415.03230672825,
                                                   419.750805599545,
                                                   424.478193418257,
                                                   429.214391866652,
                                                   433.959323995015,
                                                   438.712914186121,
                                                   443.475088120919,
                                                   448.245772745385,
                                                   453.024896238496,
                                                   457.812387981278,
                                                   462.608178526875,
                                                   467.412199571608,
                                                   472.224383926981,
                                                   477.044665492586,
                                                   481.872979229888,
                                                   486.709261136839,
                                                   491.553448223298,
                                                   496.405478487218,
                                                   501.265290891579,
                                                   506.132825342035,
                                                   511.008022665236,
                                                   515.890824587822,
                                                   520.781173716044,
                                                   525.679013515995,
                                                   530.584288294433,
                                                   535.49694318017,
                                                   540.416924105998,
                                                   545.344177791155,
                                                   550.278651724286,
                                                   555.220294146895,
                                                   560.169054037273,
                                                   565.124881094874,
                                                   570.087725725134,
                                                   575.05753902471,
                                                   580.034272767131,
                                                   585.017879388839,
                                                   590.008311975618,
                                                   595.005524249382,
                                                   600.009470555327,
                                                   605.020105849424,
                                                   610.037385686239,
                                                   615.061266207085,
                                                   620.091704128477,
                                                   625.128656730891,
                                                   630.17208184781,
                                                   635.22193785506,
                                                   640.278183660408,
                                                   645.340778693435,
                                                   650.409682895655,
                                                   655.484856710889,
                                                   660.566261075874,
                                                   665.653857411106,
                                                   670.747607611913,
                                                   675.847474039737,
                                                   680.953419513637,
                                                   686.065407301994,
                                                   691.183401114411,
                                                   696.307365093814,
                                                   701.437263808737,
                                                   706.573062245787,
                                                   711.71472580229,
                                                   716.862220279103,
                                                   722.015511873601,
                                                   727.174567172816,
                                                   732.339353146739,
                                                   737.509837141777,
                                                   742.685986874351,
                                                   747.867770424643,
                                                   753.055156230484,
                                                   758.248113081374,
                                                   763.44661011264,
                                                   768.650616799717,
                                                   773.860102952558,
                                                   779.075038710167,
                                                   784.295394535246,
                                                   789.521141208959,
                                                   794.752249825813,
                                                   799.988691788643,
                                                   805.230438803703,
                                                   810.477462875864,
                                                   815.72973630391,
                                                   820.987231675938,
                                                   826.249921864843,
                                                   831.517780023906,
                                                   836.79077958247,
                                                   842.0688942417,
                                                   847.352097970438,
                                                   852.640365001133,
                                                   857.933669825857,
                                                   863.231987192405};

} // namespace mathutils
