#!/usr/bin/env python3
"""
[ Cartesian x Spherical ] conversion matrices
"""

import numpy as np

def cart_sphe(n):
  """ Matrices have dimension ( N_cartesian, N_sperical ) """
  if n == 0:
       result = np.array([
    [1.0],
])
       return result

  if n == 1:
       result = np.array([
    [0, 0, 1.0],
    [1.0, 0, 0],
    [0, 1.0, 0],
]).T
       return result

  if n == 2:
       result = np.array([
    [-0.5, 0, 0, -0.5, 0, 1.0],
    [0, 0, 1.0, 0, 0, 0],
    [0, 0, 0, 0, 1.0, 0],
    [0.86602540378443864676, 0, 0, -0.86602540378443864676, 0, 0],
    [0, 1.0, 0, 0, 0, 0],
]).T
       return result

  if n == 3:
       result = np.array([
    [0, 0, -0.67082039324993690892, 0, 0, 0, 0, -0.67082039324993690892, 0, 1.0],
    [-0.61237243569579452455, 0, 0, -0.27386127875258305673, 0, 1.0954451150103322269, 0, 0, 0, 0],
    [0, -0.27386127875258305673, 0, 0, 0, 0, -0.61237243569579452455, 0, 1.0954451150103322269, 0],
    [0, 0, 0.86602540378443864676, 0, 0, 0, 0, -0.86602540378443864676, 0, 0],
    [0, 0, 0, 0, 1.0, 0, 0, 0, 0, 0],
    [0.790569415042094833, 0, 0, -1.0606601717798212866, 0, 0, 0, 0, 0, 0],
    [0, 1.0606601717798212866, 0, 0, 0, 0, -0.790569415042094833, 0, 0, 0],
]).T
       return result

  if n == 4:
       result = np.array([
    [0.375, 0, 0, 0.21957751641341996535, 0, -0.87831006565367986142, 0, 0, 0, 0, 0.375, 0, -0.87831006565367986142, 0, 1.0],
    [0, 0, -0.89642145700079522998, 0, 0, 0, 0, -0.40089186286863657703, 0, 1.19522860933439364, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, -0.40089186286863657703, 0, 0, 0, 0, 0, 0, -0.89642145700079522998, 0, 1.19522860933439364, 0],
    [-0.5590169943749474241, 0, 0, 0, 0, 0.9819805060619657157, 0, 0, 0, 0, 0.5590169943749474241, 0, -0.9819805060619657157, 0, 0],
    [0, -0.42257712736425828875, 0, 0, 0, 0, -0.42257712736425828875, 0, 1.1338934190276816816, 0, 0, 0, 0, 0, 0],
    [0, 0, 0.790569415042094833, 0, 0, 0, 0, -1.0606601717798212866, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 1.0606601717798212866, 0, 0, 0, 0, 0, 0, -0.790569415042094833, 0, 0, 0],
    [0.73950997288745200532, 0, 0, -1.2990381056766579701, 0, 0, 0, 0, 0, 0, 0.73950997288745200532, 0, 0, 0, 0],
    [0, 1.1180339887498948482, 0, 0, 0, 0, -1.1180339887498948482, 0, 0, 0, 0, 0, 0, 0, 0],
]).T
       return result

  if n == 5:
       result = np.array([
    [0, 0, 0.625, 0, 0, 0, 0, 0.36596252735569994226, 0, -1.0910894511799619063, 0, 0, 0, 0, 0, 0, 0.625, 0, -1.0910894511799619063, 0, 1.0],
    [0.48412291827592711065, 0, 0, 0.21128856368212914438, 0, -1.2677313820927748663, 0, 0, 0, 0, 0.16137430609197570355, 0, -0.56694670951384084082, 0, 1.2909944487358056284, 0, 0, 0, 0, 0, 0],
    [0, 0.16137430609197570355, 0, 0, 0, 0, 0.21128856368212914438, 0, -0.56694670951384084082, 0, 0, 0, 0, 0, 0, 0.48412291827592711065, 0, -1.2677313820927748663, 0, 1.2909944487358056284, 0],
    [0, 0, -0.85391256382996653193, 0, 0, 0, 0, 0, 0, 1.1180339887498948482, 0, 0, 0, 0, 0, 0, 0.85391256382996653193, 0, -1.1180339887498948482, 0, 0],
    [0, 0, 0, 0, -0.6454972243679028142, 0, 0, 0, 0, 0, 0, -0.6454972243679028142, 0, 1.2909944487358056284, 0, 0, 0, 0, 0, 0, 0],
    [-0.52291251658379721749, 0, 0, 0.22821773229381921394, 0, 0.91287092917527685576, 0, 0, 0, 0, 0.52291251658379721749, 0, -1.2247448713915890491, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, -0.52291251658379721749, 0, 0, 0, 0, -0.22821773229381921394, 0, 1.2247448713915890491, 0, 0, 0, 0, 0, 0, 0.52291251658379721749, 0, -0.91287092917527685576, 0, 0, 0],
    [0, 0, 0.73950997288745200532, 0, 0, 0, 0, -1.2990381056766579701, 0, 0, 0, 0, 0, 0, 0, 0, 0.73950997288745200532, 0, 0, 0, 0],
    [0, 0, 0, 0, 1.1180339887498948482, 0, 0, 0, 0, 0, 0, -1.1180339887498948482, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0.7015607600201140098, 0, 0, -1.5309310892394863114, 0, 0, 0, 0, 0, 0, 1.169267933366856683, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 1.169267933366856683, 0, 0, 0, 0, -1.5309310892394863114, 0, 0, 0, 0, 0, 0, 0, 0, 0.7015607600201140098, 0, 0, 0, 0, 0],
]).T
       return result

  if n == 6:
       result = np.array([
    [-0.3125, 0, 0, -0.16319780245846672329, 0, 0.97918681475080033975, 0, 0, 0, 0, -0.16319780245846672329, 0, 0.57335309036732873772, 0, -1.3055824196677337863, 0, 0, 0, 0, 0, 0, -0.3125, 0, 0.97918681475080033975, 0, -1.3055824196677337863, 0, 1.0],
    [0, 0, 0.86356159963469679725, 0, 0, 0, 0, 0.37688918072220452831, 0, -1.6854996561581052156, 0, 0, 0, 0, 0, 0, 0.28785386654489893242, 0, -0.75377836144440905662, 0, 1.3816985594155148756, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0.28785386654489893242, 0, 0, 0, 0, 0, 0, 0.37688918072220452831, 0, -0.75377836144440905662, 0, 0, 0, 0, 0, 0, 0, 0, 0.86356159963469679725, 0, -1.6854996561581052156, 0, 1.3816985594155148756, 0],
    [0.45285552331841995543, 0, 0, 0.078832027985861408788, 0, -1.2613124477737825406, 0, 0, 0, 0, -0.078832027985861408788, 0, 0, 0, 1.2613124477737825406, 0, 0, 0, 0, 0, 0, -0.45285552331841995543, 0, 1.2613124477737825406, 0, -1.2613124477737825406, 0, 0],
    [0, 0.27308215547040717681, 0, 0, 0, 0, 0.26650089544451304287, 0, -0.95346258924559231545, 0, 0, 0, 0, 0, 0, 0.27308215547040717681, 0, -0.95346258924559231545, 0, 1.4564381625088382763, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, -0.81924646641122153043, 0, 0, 0, 0, 0.35754847096709711829, 0, 1.0660035817780521715, 0, 0, 0, 0, 0, 0, 0.81924646641122153043, 0, -1.4301938838683884732, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, -0.81924646641122153043, 0, 0, 0, 0, 0, 0, -0.35754847096709711829, 0, 1.4301938838683884732, 0, 0, 0, 0, 0, 0, 0, 0, 0.81924646641122153043, 0, -1.0660035817780521715, 0, 0, 0],
    [-0.49607837082461073572, 0, 0, 0.43178079981734839863, 0, 0.86356159963469679725, 0, 0, 0, 0, 0.43178079981734839863, 0, -1.5169496905422946941, 0, 0, 0, 0, 0, 0, 0, 0, -0.49607837082461073572, 0, 0.86356159963469679725, 0, 0, 0, 0],
    [0, -0.59829302641309923139, 0, 0, 0, 0, 0, 0, 1.3055824196677337863, 0, 0, 0, 0, 0, 0, 0.59829302641309923139, 0, -1.3055824196677337863, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0.7015607600201140098, 0, 0, 0, 0, -1.5309310892394863114, 0, 0, 0, 0, 0, 0, 0, 0, 1.169267933366856683, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 1.169267933366856683, 0, 0, 0, 0, 0, 0, -1.5309310892394863114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.7015607600201140098, 0, 0, 0, 0, 0],
    [0.67169328938139615748, 0, 0, -1.7539019000502850245, 0, 0, 0, 0, 0, 0, 1.7539019000502850245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.67169328938139615748, 0, 0, 0, 0, 0, 0],
    [0, 1.2151388809514737933, 0, 0, 0, 0, -1.9764235376052370825, 0, 0, 0, 0, 0, 0, 0, 0, 1.2151388809514737933, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
]).T
       return result

  if n == 7:
       result = np.array([
    [0, 0, -0.60670333962134435221, 0, 0, 0, 0, -0.31684048566533184861, 0, 1.4169537279434593918, 0, 0, 0, 0, 0, 0, -0.31684048566533184861, 0, 0.82968314787883083417, 0, -1.5208343311935928733, 0, 0, 0, 0, 0, 0, 0, 0, -0.60670333962134435221, 0, 1.4169537279434593918, 0, -1.5208343311935928733, 0, 1.0],
    [-0.41339864235384227977, 0, 0, -0.17963167078872714852, 0, 1.4370533663098171882, 0, 0, 0, 0, -0.13388954226515238921, 0, 0.62718150750531807803, 0, -2.1422326762424382273, 0, 0, 0, 0, 0, 0, -0.1146561540164598136, 0, 0.47901778876993906273, 0, -0.95803557753987812546, 0, 1.4675987714106856141, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, -0.1146561540164598136, 0, 0, 0, 0, -0.13388954226515238921, 0, 0.47901778876993906273, 0, 0, 0, 0, 0, 0, -0.17963167078872714852, 0, 0.62718150750531807803, 0, -0.95803557753987812546, 0, 0, 0, 0, 0, 0, 0, 0, -0.41339864235384227977, 0, 1.4370533663098171882, 0, -2.1422326762424382273, 0, 1.4675987714106856141, 0],
    [0, 0, 0.84254721963085980365, 0, 0, 0, 0, 0.14666864502533059662, 0, -1.7491256557036030854, 0, 0, 0, 0, 0, 0, -0.14666864502533059662, 0, 0, 0, 1.4080189922431737275, 0, 0, 0, 0, 0, 0, 0, 0, -0.84254721963085980365, 0, 1.7491256557036030854, 0, -1.4080189922431737275, 0, 0],
    [0, 0, 0, 0, 0.50807509012231371428, 0, 0, 0, 0, 0, 0, 0.49583051751369852316, 0, -1.3222147133698627284, 0, 0, 0, 0, 0, 0, 0, 0, 0.50807509012231371428, 0, -1.3222147133698627284, 0, 1.6258402883914038857, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0.42961647140211000062, 0, 0, -0.062226236090912312563, 0, -1.2445247218182462513, 0, 0, 0, 0, -0.23190348980538452414, 0, 0.54315511828342602619, 0, 1.2368186122953841287, 0, 0, 0, 0, 0, 0, -0.35746251148251142922, 0, 1.2445247218182462513, 0, -1.6593662957576616683, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0.35746251148251142922, 0, 0, 0, 0, 0.23190348980538452414, 0, -1.2445247218182462513, 0, 0, 0, 0, 0, 0, 0.062226236090912312563, 0, -0.54315511828342602619, 0, 1.6593662957576616683, 0, 0, 0, 0, 0, 0, 0, 0, -0.42961647140211000062, 0, 1.2445247218182462513, 0, -1.2368186122953841287, 0, 0, 0],
    [0, 0, -0.79037935147039945351, 0, 0, 0, 0, 0.6879369240987588816, 0, 1.025515817677958738, 0, 0, 0, 0, 0, 0, 0.6879369240987588816, 0, -1.8014417303072302517, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.79037935147039945351, 0, 1.025515817677958738, 0, 0, 0, 0],
    [0, 0, 0, 0, -0.95323336395336381126, 0, 0, 0, 0, 0, 0, 0, 0, 1.5504341823651057024, 0, 0, 0, 0, 0, 0, 0, 0, 0.95323336395336381126, 0, -1.5504341823651057024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [-0.47495887979908323849, 0, 0, 0.61914323168888299344, 0, 0.82552430891851065792, 0, 0, 0, 0, 0.25637895441948968451, 0, -1.8014417303072302517, 0, 0, 0, 0, 0, 0, 0, 0, -0.65864945955866621126, 0, 1.3758738481975177632, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, -0.65864945955866621126, 0, 0, 0, 0, 0.25637895441948968451, 0, 1.3758738481975177632, 0, 0, 0, 0, 0, 0, 0.61914323168888299344, 0, -1.8014417303072302517, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.47495887979908323849, 0, 0.82552430891851065792, 0, 0, 0, 0, 0],
    [0, 0, 0.67169328938139615748, 0, 0, 0, 0, -1.7539019000502850245, 0, 0, 0, 0, 0, 0, 0, 0, 1.7539019000502850245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.67169328938139615748, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 1.2151388809514737933, 0, 0, 0, 0, 0, 0, -1.9764235376052370825, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.2151388809514737933, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0.64725984928774934788, 0, 0, -1.96875, 0, 0, 0, 0, 0, 0, 2.4456993503903949804, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.2566230789301937693, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 1.2566230789301937693, 0, 0, 0, 0, -2.4456993503903949804, 0, 0, 0, 0, 0, 0, 0, 0, 1.96875, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.64725984928774934788, 0, 0, 0, 0, 0, 0, 0],
]).T
       return result

  if n == 8:
       result = np.array([
    [0.2734375, 0, 0, 0.13566299095694674896, 0, -1.0853039276555739917, 0, 0, 0, 0, 0.12099545906566282998, 0, -0.56678149117738375672, 0, 1.9359273450506052797, 0, 0, 0, 0, 0, 0, 0.13566299095694674896, 0, -0.56678149117738375672, 0, 1.1335629823547675134, 0, -1.7364862842489183867, 0, 0, 0, 0, 0, 0, 0, 0, 0.2734375, 0, -1.0853039276555739917, 0, 1.9359273450506052797, 0, -1.7364862842489183867, 0, 1.0],
    [0, 0, -0.84721510698287244363, 0, 0, 0, 0, -0.36813537731583001376, 0, 2.1951352762686132731, 0, 0, 0, 0, 0, 0, -0.27439190953357665914, 0, 0.95803557753987812546, 0, -2.6341623315223359277, 0, 0, 0, 0, 0, 0, 0, 0, -0.23497519304418891392, 0, 0.73171175875620442437, 0, -1.178033207410656044, 0, 1.5491933384829667541, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, -0.23497519304418891392, 0, 0, 0, 0, 0, 0, -0.27439190953357665914, 0, 0.73171175875620442437, 0, 0, 0, 0, 0, 0, 0, 0, -0.36813537731583001376, 0, 0.95803557753987812546, 0, -1.178033207410656044, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.84721510698287244363, 0, 2.1951352762686132731, 0, -2.6341623315223359277, 0, 1.5491933384829667541, 0],
    [-0.39218438743784791311, 0, 0, -0.0972889728117695298, 0, 1.459334592176542947, 0, 0, 0, 0, 0, 0, 0.25403754506115685714, 0, -2.3138757483972597747, 0, 0, 0, 0, 0, 0, 0.0972889728117695298, 0, -0.25403754506115685714, 0, 0, 0, 1.5566235649883124768, 0, 0, 0, 0, 0, 0, 0, 0, 0.39218438743784791311, 0, -1.459334592176542947, 0, 2.3138757483972597747, 0, -1.5566235649883124768, 0, 0],
    [0, -0.20252314682524563222, 0, 0, 0, 0, -0.1967766362666553471, 0, 0.8800118701519835797, 0, 0, 0, 0, 0, 0, -0.1967766362666553471, 0, 0.85880364827689588344, 0, -1.7491256557036030854, 0, 0, 0, 0, 0, 0, 0, 0, -0.20252314682524563222, 0, 0.8800118701519835797, 0, -1.7491256557036030854, 0, 1.7974340685458342478, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0.82265291131801144316, 0, 0, 0, 0, -0.11915417049417047641, 0, -1.7762455001837659611, 0, 0, 0, 0, 0, 0, -0.44406137504594149028, 0, 0.77521709118255285119, 0, 1.4209964001470127689, 0, 0, 0, 0, 0, 0, 0, 0, -0.68448859700003543819, 0, 1.7762455001837659611, 0, -1.9064667279067276225, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0.68448859700003543819, 0, 0, 0, 0, 0, 0, 0.44406137504594149028, 0, -1.7762455001837659611, 0, 0, 0, 0, 0, 0, 0, 0, 0.11915417049417047641, 0, -0.77521709118255285119, 0, 1.9064667279067276225, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.82265291131801144316, 0, 1.7762455001837659611, 0, -1.4209964001470127689, 0, 0, 0],
    [0.41132645565900572158, 0, 0, -0.20407507102873838124, 0, -1.2244504261724302874, 0, 0, 0, 0, -0.3033516698106721761, 0, 1.0657473001102595767, 0, 1.2134066792426887044, 0, 0, 0, 0, 0, 0, -0.20407507102873838124, 0, 1.0657473001102595767, 0, -2.1314946002205191534, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.41132645565900572158, 0, -1.2244504261724302874, 0, 1.2134066792426887044, 0, 0, 0, 0],
    [0, 0.42481613669916071115, 0, 0, 0, 0, 0.13758738481975177632, 0, -1.4767427774562605828, 0, 0, 0, 0, 0, 0, -0.13758738481975177632, 0, 0, 0, 1.8344984642633570176, 0, 0, 0, 0, 0, 0, 0, 0, -0.42481613669916071115, 0, 1.4767427774562605828, 0, -1.8344984642633570176, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, -0.76584818175667166625, 0, 0, 0, 0, 0.99833846339806020718, 0, 0.99215674164922147144, 0, 0, 0, 0, 0, 0, 0.41339864235384227977, 0, -2.1650635094610966169, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.0620403417479017779, 0, 1.6535945694153691191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, -1.0620403417479017779, 0, 0, 0, 0, 0, 0, 0.41339864235384227977, 0, 1.6535945694153691191, 0, 0, 0, 0, 0, 0, 0, 0, 0.99833846339806020718, 0, -2.1650635094610966169, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.76584818175667166625, 0, 0.99215674164922147144, 0, 0, 0, 0, 0],
    [-0.45768182862115030664, 0, 0, 0.79475821795059156217, 0, 0.79475821795059156217, 0, 0, 0, 0, 0, 0, -2.0752447144854989366, 0, 0, 0, 0, 0, 0, 0, 0, -0.79475821795059156217, 0, 2.0752447144854989366, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.45768182862115030664, 0, -0.79475821795059156217, 0, 0, 0, 0, 0, 0],
    [0, -0.70903764004458888811, 0, 0, 0, 0, 0.53582588123382020898, 0, 1.4377717134510610478, 0, 0, 0, 0, 0, 0, 0.53582588123382020898, 0, -2.338535866733713366, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.70903764004458888811, 0, 1.4377717134510610478, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0.64725984928774934788, 0, 0, 0, 0, -1.96875, 0, 0, 0, 0, 0, 0, 0, 0, 2.4456993503903949804, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.2566230789301937693, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 1.2566230789301937693, 0, 0, 0, 0, 0, 0, -2.4456993503903949804, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.96875, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.64725984928774934788, 0, 0, 0, 0, 0, 0, 0],
    [0.626706654240043952, 0, 0, -2.176535018670731151, 0, 0, 0, 0, 0, 0, 3.2353561313826025233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2.176535018670731151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.626706654240043952, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 1.2945196985754986958, 0, 0, 0, 0, -2.9348392204684739765, 0, 0, 0, 0, 0, 0, 0, 0, 2.9348392204684739765, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.2945196985754986958, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
]).T
       return result

  if n == 9:
       result = np.array([
    [0, 0, 0.59686501473785067702, 0, 0, 0, 0, 0.29612797475437320937, 0, -1.7657660842403202261, 0, 0, 0, 0, 0, 0, 0.26411138361943717788, 0, -0.92214126273187869253, 0, 2.5354692827465969076, 0, 0, 0, 0, 0, 0, 0, 0, 0.29612797475437320937, 0, -0.92214126273187869253, 0, 1.4846187947947014119, 0, -1.952374120367905548, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.59686501473785067702, 0, -1.7657660842403202261, 0, 2.5354692827465969076, 0, -1.952374120367905548, 0, 1.0],
    [0.36685490255855924707, 0, 0, 0.15916400393009351387, 0, -1.5916400393009351387, 0, 0, 0, 0, 0.11811420148091719529, 0, -0.6916059470489090194, 0, 3.1497120394911252077, 0, 0, 0, 0, 0, 0, 0.098709324918124403125, 0, -0.51549263708149354579, 0, 1.3746470322173161221, 0, -3.1586983973799809, 0, 0, 0, 0, 0, 0, 0, 0, 0.088975383089683195547, 0, -0.44144152106008005653, 0, 1.0499040131637084026, 0, -1.4126128673922561809, 0, 1.62697843363992129, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0.088975383089683195547, 0, 0, 0, 0, 0.098709324918124403125, 0, -0.44144152106008005653, 0, 0, 0, 0, 0, 0, 0.11811420148091719529, 0, -0.51549263708149354579, 0, 1.0499040131637084026, 0, 0, 0, 0, 0, 0, 0, 0, 0.15916400393009351387, 0, -0.6916059470489090194, 0, 1.3746470322173161221, 0, -1.4126128673922561809, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.36685490255855924707, 0, -1.5916400393009351387, 0, 3.1497120394911252077, 0, -3.1586983973799809, 0, 1.62697843363992129, 0],
    [0, 0, -0.83466307816035426155, 0, 0, 0, 0, -0.2070544267420625878, 0, 2.3149388661875113029, 0, 0, 0, 0, 0, 0, 0, 0, 0.40297913150666282783, 0, -2.9546917977869539993, 0, 0, 0, 0, 0, 0, 0, 0, 0.2070544267420625878, 0, -0.40297913150666282783, 0, 0, 0, 1.7063893769835631924, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.83466307816035426155, 0, -2.3149388661875113029, 0, 2.9546917977869539993, 0, -1.7063893769835631924, 0, 0],
    [0, 0, 0, 0, -0.43101816018790287844, 0, 0, 0, 0, 0, 0, -0.4187881980957120927, 0, 1.395960660319040309, 0, 0, 0, 0, 0, 0, 0, 0, -0.4187881980957120927, 0, 1.3623181102386339839, 0, -2.2335370565104644944, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.43101816018790287844, 0, 1.395960660319040309, 0, -2.2335370565104644944, 0, 1.9703687322875560157, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [-0.37548796377180986812, 0, 0, 0, 0, 1.4661859659554465543, 0, 0, 0, 0, 0.12089373945199884835, 0, -0.21236437647040795145, 0, -2.417874789039976967, 0, 0, 0, 0, 0, 0, 0.20206443016189559856, 0, -0.79143530297864839268, 0, 1.0552470706381978569, 0, 1.6165154412951647885, 0, 0, 0, 0, 0, 0, 0, 0, 0.27320762396104757397, 0, -1.2199404645272449631, 0, 2.417874789039976967, 0, -2.16878304804843549, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, -0.27320762396104757397, 0, 0, 0, 0, -0.20206443016189559856, 0, 1.2199404645272449631, 0, 0, 0, 0, 0, 0, -0.12089373945199884835, 0, 0.79143530297864839268, 0, -2.417874789039976967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.21236437647040795145, 0, -1.0552470706381978569, 0, 2.16878304804843549, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.37548796377180986812, 0, -1.4661859659554465543, 0, 2.417874789039976967, 0, -1.6165154412951647885, 0, 0, 0],
    [0, 0, 0.80430146722719804411, 0, 0, 0, 0, -0.39904527606894581113, 0, -1.7845847267806657796, 0, 0, 0, 0, 0, 0, -0.59316922059788797031, 0, 1.5532816304615888184, 0, 1.4236061294349311288, 0, 0, 0, 0, 0, 0, 0, 0, -0.39904527606894581113, 0, 1.5532816304615888184, 0, -2.5007351860179508607, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.80430146722719804411, 0, -1.7845847267806657796, 0, 1.4236061294349311288, 0, 0, 0, 0],
    [0, 0, 0, 0, 0.83067898344030094085, 0, 0, 0, 0, 0, 0, 0.26903627024228973454, 0, -2.1522901619383178764, 0, 0, 0, 0, 0, 0, 0, 0, -0.26903627024228973454, 0, 0, 0, 2.1522901619383178764, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.83067898344030094085, 0, 2.1522901619383178764, 0, -2.1522901619383178764, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0.39636409043643194293, 0, 0, -0.34393377440500167929, 0, -1.2037682104175058775, 0, 0, 0, 0, -0.29776858550677551679, 0, 1.5691988753163563388, 0, 1.1910743420271020672, 0, 0, 0, 0, 0, 0, 0, 0, 0.64978432507844251538, 0, -2.5991373003137700615, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.48066206207978815025, 0, -1.6693261563207085231, 0, 1.9851239033785034453, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0.48066206207978815025, 0, 0, 0, 0, 0, 0, -1.6693261563207085231, 0, 0, 0, 0, 0, 0, -0.29776858550677551679, 0, 0.64978432507844251538, 0, 1.9851239033785034453, 0, 0, 0, 0, 0, 0, 0, 0, -0.34393377440500167929, 0, 1.5691988753163563388, 0, -2.5991373003137700615, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.39636409043643194293, 0, -1.2037682104175058775, 0, 1.1910743420271020672, 0, 0, 0, 0, 0],
    [0, 0, -0.74463846463549402274, 0, 0, 0, 0, 1.2930544805637086353, 0, 0.96378590571704436469, 0, 0, 0, 0, 0, 0, 0, 0, -2.5166038696554342464, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.2930544805637086353, 0, 2.5166038696554342464, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.74463846463549402274, 0, -0.96378590571704436469, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, -1.1535889489914915606, 0, 0, 0, 0, 0, 0, 0.87177715295353129935, 0, 1.7435543059070625987, 0, 0, 0, 0, 0, 0, 0, 0, 0.87177715295353129935, 0, -2.8358912905407192076, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.1535889489914915606, 0, 1.7435543059070625987, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [-0.44314852502786805507, 0, 0, 0.96132412415957630049, 0, 0.76905929932766104039, 0, 0, 0, 0, -0.33291539937855436029, 0, -2.3392235702823930554, 0, 0, 0, 0, 0, 0, 0, 0, -0.83466307816035426155, 0, 2.9059238431784376645, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.75235513151094117345, 0, -1.4930907048606177933, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, -0.75235513151094117345, 0, 0, 0, 0, 0.83466307816035426155, 0, 1.4930907048606177933, 0, 0, 0, 0, 0, 0, 0.33291539937855436029, 0, -2.9059238431784376645, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.96132412415957630049, 0, 2.3392235702823930554, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.44314852502786805507, 0, -0.76905929932766104039, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0.626706654240043952, 0, 0, 0, 0, -2.176535018670731151, 0, 0, 0, 0, 0, 0, 0, 0, 3.2353561313826025233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2.176535018670731151, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.626706654240043952, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 1.2945196985754986958, 0, 0, 0, 0, 0, 0, -2.9348392204684739765, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.9348392204684739765, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.2945196985754986958, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0.60904939217552380708, 0, 0, -2.3781845426185916576, 0, 0, 0, 0, 0, 0, 4.1179360680974030877, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.4414040330583097636, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.3294455750836041652, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 1.3294455750836041652, 0, 0, 0, 0, -3.4414040330583097636, 0, 0, 0, 0, 0, 0, 0, 0, 4.1179360680974030877, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2.3781845426185916576, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.60904939217552380708, 0, 0, 0, 0, 0, 0, 0, 0, 0],
]).T
       return result

  if n == 10:
       result = np.array([
    [-0.24609375, 0, 0, -0.11858505372305812003, 0, 1.1858505372305812003, 0, 0, 0, 0, -0.10047931526668538772, 0, 0.58834662659146160065, 0, -2.6794484071116103391, 0, 0, 0, 0, 0, 0, -0.10047931526668538772, 0, 0.52473611020974468895, 0, -1.3992962938926525039, 0, 3.2153380885339324069, 0, 0, 0, 0, 0, 0, 0, 0, -0.11858505372305812003, 0, 0.58834662659146160065, 0, -1.3992962938926525039, 0, 1.8827092050926771221, 0, -2.1684124109359199092, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.24609375, 0, 1.1858505372305812003, 0, -2.6794484071116103391, 0, 3.2153380885339324069, 0, -2.1684124109359199092, 0, 1.0],
    [0, 0, 0.83740417939178506787, 0, 0, 0, 0, 0.36331694402943203347, 0, -2.7080046140909879357, 0, 0, 0, 0, 0, 0, 0.26961429512272912425, 0, -1.1766932531829232013, 0, 4.313828721963665988, 0, 0, 0, 0, 0, 0, 0, 0, 0.22531960362226453071, 0, -0.87705536759412901916, 0, 1.8827092050926771221, 0, -3.7138348993247834547, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.20310034605682409518, 0, -0.75106534540754843571, 0, 1.437942907321221996, 0, -1.6608774584202607245, 0, 1.7013926184468014077, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0.20310034605682409518, 0, 0, 0, 0, 0, 0, 0.22531960362226453071, 0, -0.75106534540754843571, 0, 0, 0, 0, 0, 0, 0, 0, 0.26961429512272912425, 0, -0.87705536759412901916, 0, 1.437942907321221996, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.36331694402943203347, 0, -1.1766932531829232013, 0, 1.8827092050926771221, 0, -1.6608774584202607245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.83740417939178506787, 0, -2.7080046140909879357, 0, 4.313828721963665988, 0, -3.7138348993247834547, 0, 1.7013926184468014077, 0],
    [0.35123682832287462164, 0, 0, 0.10155017302841204759, 0, -1.6248027684545927614, 0, 0, 0, 0, 0.028681781643235369086, 0, -0.40306396029015307011, 0, 3.4418137971882442903, 0, 0, 0, 0, 0, 0, -0.028681781643235369086, 0, 0, 0, 0.59914287805050916501, 0, -3.671268050334127243, 0, 0, 0, 0, 0, 0, 0, 0, -0.10155017302841204759, 0, 0.40306396029015307011, 0, -0.59914287805050916501, 0, 0, 0, 1.8569174496623917273, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.35123682832287462164, 0, 1.6248027684545927614, 0, -3.4418137971882442903, 0, 3.671268050334127243, 0, -1.8569174496623917273, 0, 0],
    [0, 0.16115850946412159102, 0, 0, 0, 0, 0.15634671929121805204, 0, -0.83904454174617912686, 0, 0, 0, 0, 0, 0, 0.15566188586647886474, 0, -0.81523699977453260905, 0, 2.0754918115530515298, 0, 0, 0, 0, 0, 0, 0, 0, 0.15634671929121805204, 0, -0.81523699977453260905, 0, 2.0254726102987062665, 0, -2.7752177878403030036, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.16115850946412159102, 0, -0.83904454174617912686, 0, 2.0754918115530515298, 0, -2.7752177878403030036, 0, 2.144183578850990428, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, -0.82175038453908348563, 0, 0, 0, 0, 0, 0, 2.3916449176564030209, 0, 0, 0, 0, 0, 0, 0.26457433118527621615, 0, -0.34640911417109820836, 0, -3.1748919742233145938, 0, 0, 0, 0, 0, 0, 0, 0, 0.44221530170835956711, 0, -1.2909905455201021811, 0, 1.3856364566843928334, 0, 1.822205651547735635, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.59791122941410075523, 0, -1.989968857687618052, 0, 3.1748919742233145938, 0, -2.4447454235070190498, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, -0.59791122941410075523, 0, 0, 0, 0, 0, 0, -0.44221530170835956711, 0, 1.989968857687618052, 0, 0, 0, 0, 0, 0, 0, 0, -0.26457433118527621615, 0, 1.2909905455201021811, 0, -3.1748919742233145938, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.34640911417109820836, 0, -1.3856364566843928334, 0, 2.4447454235070190498, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.82175038453908348563, 0, -2.3916449176564030209, 0, 3.1748919742233145938, 0, -1.822205651547735635, 0, 0, 0],
    [-0.36182925552841909469, 0, 0, 0.10461267311033710355, 0, 1.4645774235447194496, 0, 0, 0, 0, 0.20682726877269383945, 0, -0.72663388805886406695, 0, -2.4819272252723260733, 0, 0, 0, 0, 0, 0, 0.20682726877269383945, 0, -1.0801201840700893574, 0, 2.1602403681401787147, 0, 1.6546181501815507156, 0, 0, 0, 0, 0, 0, 0, 0, 0.10461267311033710355, 0, -0.72663388805886406695, 0, 2.1602403681401787147, 0, -2.9065355522354562678, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.36182925552841909469, 0, 1.4645774235447194496, 0, -2.4819272252723260733, 0, 1.6546181501815507156, 0, 0, 0, 0],
    [0, -0.33203729677156513836, 0, 0, 0, 0, -0.16106174661573187074, 0, 1.5126090588320172805, 0, 0, 0, 0, 0, 0, 0, 0, 0.48989646739041700006, 0, -2.9933168593440682608, 0, 0, 0, 0, 0, 0, 0, 0, 0.16106174661573187074, 0, -0.48989646739041700006, 0, 0, 0, 2.5015475086594888326, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.33203729677156513836, 0, -1.5126090588320172805, 0, 2.9933168593440682608, 0, -2.5015475086594888326, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0.78749559444256408387, 0, 0, 0, 0, -0.68332711933040086312, 0, -1.7826268713072013905, 0, 0, 0, 0, 0, 0, -0.59160618963182012549, 0, 2.3237829819361839259, 0, 1.4198548551163683012, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.96224753936416168989, 0, -3.0983773092482452346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.95497868105742931632, 0, -2.4720586882761771815, 0, 2.366424758527280502, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0.95497868105742931632, 0, 0, 0, 0, 0, 0, 0, 0, -2.4720586882761771815, 0, 0, 0, 0, 0, 0, 0, 0, -0.59160618963182012549, 0, 0.96224753936416168989, 0, 2.366424758527280502, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.68332711933040086312, 0, 2.3237829819361839259, 0, -3.0983773092482452346, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.78749559444256408387, 0, -1.7826268713072013905, 0, 1.4198548551163683012, 0, 0, 0, 0, 0],
    [0.38377788032373784791, 0, 0, -0.48082014860341125496, 0, -1.1835572888699353968, 0, 0, 0, 0, -0.21937344642519671472, 0, 2.0552309987454778474, 0, 1.1699917142677158118, 0, 0, 0, 0, 0, 0, 0.21937344642519671472, 0, 0, 0, -3.0550412266096884411, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.48082014860341125496, 0, -2.0552309987454778474, 0, 3.0550412266096884411, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.38377788032373784791, 0, 1.1835572888699353968, 0, -1.1699917142677158118, 0, 0, 0, 0, 0, 0],
    [0, 0.52826810434655366934, 0, 0, 0, 0, -0.17083177983260021578, 0, -1.8335590676302642873, 0, 0, 0, 0, 0, 0, -0.39686149677791432422, 0, 1.3856364566843928334, 0, 2.1165946494822097292, 0, 0, 0, 0, 0, 0, 0, 0, -0.17083177983260021578, 0, 1.3856364566843928334, 0, -3.4426414547202724829, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.52826810434655366934, 0, -1.8335590676302642873, 0, 2.1165946494822097292, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, -0.72603506428855091706, 0, 0, 0, 0, 1.5749911888851281677, 0, 0.93914329661609541215, 0, 0, 0, 0, 0, 0, -0.54543395665202120543, 0, -2.8565627348081709585, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.3674752986559612903, 0, 3.5485935872354305223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.2326255768086252285, 0, -1.8233003982079483871, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, -1.2326255768086252285, 0, 0, 0, 0, 0, 0, 1.3674752986559612903, 0, 1.8233003982079483871, 0, 0, 0, 0, 0, 0, 0, 0, 0.54543395665202120543, 0, -3.5485935872354305223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.5749911888851281677, 0, 2.8565627348081709585, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.72603506428855091706, 0, -0.93914329661609541215, 0, 0, 0, 0, 0, 0, 0],
    [-0.43066295528485788256, 0, 0, 1.120625876604032342, 0, 0.74708391773602156131, 0, 0, 0, 0, -0.7385210685055943188, 0, -2.5946019526630973949, 0, 0, 0, 0, 0, 0, 0, 0, -0.7385210685055943188, 0, 3.8568004943805360605, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.120625876604032342, 0, -2.5946019526630973949, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.43066295528485788256, 0, 0.74708391773602156131, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, -0.79040686350032478234, 0, 0, 0, 0, 1.1502109360323527426, 0, 1.5431699048592017869, 0, 0, 0, 0, 0, 0, 0, 0, -3.4985605592646392353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1.1502109360323527426, 0, 3.4985605592646392353, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.79040686350032478234, 0, -1.5431699048592017869, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0.60904939217552380708, 0, 0, 0, 0, -2.3781845426185916576, 0, 0, 0, 0, 0, 0, 0, 0, 4.1179360680974030877, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.4414040330583097636, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.3294455750836041652, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 1.3294455750836041652, 0, 0, 0, 0, 0, 0, -3.4414040330583097636, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4.1179360680974030877, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2.3781845426185916576, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.60904939217552380708, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0.59362791713657322739, 0, 0, -2.5744602859939704749, 0, 0, 0, 0, 0, 0, 5.0899052063634372758, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -5.0899052063634372758, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2.5744602859939704749, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -0.59362791713657322739, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [0, 1.361875842559399759, 0, 0, 0, 0, -3.9636409043643194293, 0, 0, 0, 0, 0, 0, 0, 0, 5.5247909851583978272, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3.9636409043643194293, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.361875842559399759, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
]).T
       return result

  raise TypeError("Angular momentum too large")

data = {}
for i in range(11):
   data[i] = cart_sphe(i)


# What follows is generated by the utilities/to_gamess_normalization.py script

normalization = {}
normalization[0] = [1.0]
normalization[1] = [1.0, 1.0, 1.0]
normalization[2] = [1.0, 1.7320508075688772, 1.7320508075688772, 1.0, 1.7320508075688772, 1.0]
normalization[3] = [1.0, 2.23606797749979, 2.23606797749979, 2.23606797749979, 3.872983346207417, 2.23606797749979, 1.0, 2.23606797749979, 2.23606797749979, 1.0]
normalization[4] = [1.0, 2.6457513110645907, 2.6457513110645907, 3.4156502553198664, 5.916079783099616, 3.415650255319866, 2.6457513110645907, 5.916079783099616, 5.916079783099616, 2.6457513110645907, 1.0, 2.6457513110645907, 3.415650255319866, 2.6457513110645907, 1.0]
normalization[5] = [0.9999999999999999, 3.0, 3.0000000000000004, 4.58257569495584, 7.937253933193773, 4.58257569495584, 4.58257569495584, 10.246950765959598, 10.246950765959598, 4.582575694955841, 3.0, 7.937253933193773, 10.246950765959598, 7.937253933193773, 3.0, 0.9999999999999999, 3.0000000000000004, 4.58257569495584, 4.582575694955841, 3.0, 1.0]
normalization[6] = [1.0, 3.3166247903554003, 3.3166247903554003, 5.744562646538029, 9.949874371066201, 5.744562646538029, 6.797058187186571, 15.198684153570666, 15.198684153570664, 6.797058187186572, 5.744562646538029, 15.198684153570666, 19.621416870348583, 15.198684153570666, 5.744562646538029, 3.3166247903554003, 9.949874371066201, 15.198684153570664, 15.198684153570666, 9.9498743710662, 3.3166247903554003, 1.0, 3.3166247903554003, 5.744562646538029, 6.797058187186572, 5.744562646538029, 3.3166247903554003, 1.0]
normalization[7] = [1.0000000000000002, 3.6055512754639896, 3.605551275463989, 6.904105059069327, 11.958260743101398, 6.904105059069326, 9.26282894152753, 20.712315177207984, 20.71231517720798, 9.26282894152753, 9.26282894152753, 24.507141816213494, 31.63858403911275, 24.507141816213494, 9.262828941527529, 6.904105059069327, 20.712315177207984, 31.63858403911275, 31.63858403911275, 20.71231517720798, 6.904105059069327, 3.6055512754639896, 11.958260743101398, 20.71231517720798, 24.507141816213494, 20.71231517720798, 11.958260743101398, 3.6055512754639896, 1.0000000000000002, 3.605551275463989, 6.904105059069326, 9.26282894152753, 9.262828941527529, 6.904105059069327, 3.6055512754639896, 1.0]
normalization[8] = [1.0, 3.872983346207417, 3.872983346207417, 8.062257748298551, 13.964240043768942, 8.06225774829855, 11.958260743101398, 26.739483914241877, 26.739483914241877, 11.958260743101398, 13.55939315961975, 35.874782229304195, 46.31414470763765, 35.874782229304195, 13.55939315961975, 11.958260743101398, 35.874782229304195, 54.79963503528103, 54.79963503528103, 35.874782229304195, 11.958260743101398, 8.062257748298551, 26.739483914241877, 46.31414470763765, 54.79963503528103, 46.314144707637645, 26.739483914241877, 8.06225774829855, 3.872983346207417, 13.964240043768942, 26.739483914241877, 35.874782229304195, 35.874782229304195, 26.739483914241877, 13.96424004376894, 3.8729833462074166, 1.0, 3.872983346207417, 8.06225774829855, 11.958260743101398, 13.55939315961975, 11.958260743101398, 8.06225774829855, 3.8729833462074166, 1.0]
normalization[9] = [1.0000000000000002, 4.1231056256176615, 4.1231056256176615, 9.219544457292889, 15.968719422671313, 9.219544457292889, 14.86606874731851, 33.24154027718933, 33.24154027718933, 14.866068747318508, 18.635603405463275, 49.30517214248421, 63.652703529910404, 49.30517214248421, 18.635603405463275, 18.635603405463275, 55.90681021638982, 85.39906322671229, 85.39906322671229, 55.90681021638983, 18.635603405463275, 14.86606874731851, 49.30517214248421, 85.39906322671229, 101.04553429023969, 85.3990632267123, 49.30517214248421, 14.866068747318508, 9.219544457292889, 33.24154027718933, 63.652703529910404, 85.39906322671229, 85.3990632267123, 63.65270352991039, 33.24154027718933, 9.219544457292887, 4.1231056256176615, 15.968719422671313, 33.24154027718933, 49.30517214248421, 55.90681021638983, 49.30517214248421, 33.24154027718933, 15.968719422671313, 4.1231056256176615, 1.0000000000000002, 4.1231056256176615, 9.219544457292889, 14.866068747318508, 18.635603405463275, 18.635603405463275, 14.866068747318508, 9.219544457292887, 4.1231056256176615, 1.0]
normalization[10] = [1.0, 4.358898943540674, 4.358898943540674, 10.376254944182257, 17.97220075561143, 10.376254944182254, 17.972200755611432, 40.18706259482024, 40.18706259482024, 17.97220075561143, 24.491981195018568, 64.79969135728966, 83.6560418220545, 64.79969135728966, 24.491981195018564, 27.07690399877228, 81.23071199631686, 124.08196215942644, 124.08196215942641, 81.23071199631683, 27.07690399877228, 24.491981195018568, 81.23071199631686, 140.69572031261546, 166.47342130202045, 140.69572031261546, 81.23071199631684, 24.491981195018564, 17.972200755611432, 64.79969135728966, 124.08196215942644, 166.47342130202045, 166.47342130202045, 124.08196215942644, 64.79969135728965, 17.972200755611432, 10.376254944182257, 1.7763568394002502e+17, 83.6560418220545, 124.08196215942641, 140.69572031261546, 124.08196215942644, 83.65604182205452, 40.18706259482024, 10.376254944182254, 4.358898943540674, 17.97220075561143, 40.18706259482024, 64.79969135728966, 81.23071199631683, 81.23071199631684, 64.79969135728965, 40.18706259482024, 17.972200755611425, 4.358898943540674, 1.0, 4.358898943540674, 10.376254944182254, 17.97220075561143, 24.491981195018564, 27.07690399877228, 24.491981195018564, 17.972200755611432, 10.376254944182254, 4.358898943540674, 1.0]

