"""Remove package-analyzer

Revision ID: 6389973bd8b6
Revises: 84588707e6ba
Create Date: 2020-09-14 08:31:09.089734+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '6389973bd8b6'
down_revision = '84588707e6ba'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('investigated')
    op.drop_table('investigated_file')
    op.drop_table('package_analyzer_run')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('investigated_file',
    sa.Column('package_analyzer_run_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('python_file_digest_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['package_analyzer_run_id'], ['package_analyzer_run.id'], name='investigated_file_package_analyzer_run_id_fkey', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_file_digest_id'], ['python_file_digest.id'], name='investigated_file_python_file_digest_id_fkey', ondelete='CASCADE')
    )
    op.create_table('package_analyzer_run',
    sa.Column('id', sa.INTEGER(), server_default=sa.text("nextval('package_analyzer_run_id_seq'::regclass)"), autoincrement=True, nullable=False),
    sa.Column('package_analyzer_name', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('package_analyzer_version', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('package_analysis_document_id', sa.TEXT(), autoincrement=False, nullable=False),
    sa.Column('datetime', postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
    sa.Column('debug', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('package_analyzer_error', sa.BOOLEAN(), autoincrement=False, nullable=False),
    sa.Column('duration', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('input_python_package_version_entity_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['input_python_package_version_entity_id'], ['python_package_version_entity.id'], name='package_analyzer_run_input_python_package_version_entity_i_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='package_analyzer_run_pkey'),
    postgresql_ignore_search_path=False
    )
    op.create_table('investigated',
    sa.Column('package_analyzer_run_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.Column('python_artifact_id', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['package_analyzer_run_id'], ['package_analyzer_run.id'], name='investigated_package_analyzer_run_id_fkey', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_artifact_id'], ['python_artifact.id'], name='investigated_python_artifact_id_fkey', ondelete='CASCADE')
    )
    # ### end Alembic commands ###
