"""Robust Syncs

Revision ID: 650a13fd0a08
Revises: 9a8ce1e52efb
Create Date: 2019-10-07 14:47:33.441781+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '650a13fd0a08'
down_revision = '9a8ce1e52efb'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('external_python_requirements_lock',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('python_package_version_entity_id', sa.Integer(), nullable=False),
    sa.Column('python_software_stack_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['python_package_version_entity_id'], ['python_package_version_entity.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_software_stack_id'], ['python_software_stack.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'python_package_version_entity_id', 'python_software_stack_id')
    )
    op.add_column('identified', sa.Column('python_package_version_entity_id', sa.Integer(), nullable=False))
    op.drop_constraint('identified_python_package_version_id_fkey', 'identified', type_='foreignkey')
    op.create_foreign_key(None, 'identified', 'python_package_version_entity', ['python_package_version_entity_id'], ['id'], ondelete='CASCADE')
    op.drop_column('identified', 'python_package_version_id')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('identified', sa.Column('python_package_version_id', sa.INTEGER(), autoincrement=False, nullable=False))
    op.drop_constraint(None, 'identified', type_='foreignkey')
    op.create_foreign_key('identified_python_package_version_id_fkey', 'identified', 'python_package_version', ['python_package_version_id'], ['id'], ondelete='CASCADE')
    op.drop_column('identified', 'python_package_version_entity_id')
    op.drop_table('external_python_requirements_lock')
    # ### end Alembic commands ###
