"""Initial schema

Revision ID: 9168881dd125
Revises: 
Create Date: 2019-09-19 11:56:44.670642+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '9168881dd125'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('cve',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('advisory', sa.String(length=16384), nullable=True),
    sa.Column('cve_name', sa.String(length=256), nullable=True),
    sa.Column('cve_id', sa.String(length=256), nullable=True),
    sa.Column('version_range', sa.String(length=256), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('deb_dependency',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('package_name', sa.String(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('deb_package_version',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('package_name', sa.String(length=256), nullable=False),
    sa.Column('package_version', sa.String(length=256), nullable=False),
    sa.Column('epoch', sa.String(length=256), nullable=True),
    sa.Column('arch', sa.String(length=256), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('ecosystem_solver',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('ecosystem', sa.String(length=256), nullable=False),
    sa.Column('solver_name', sa.String(length=256), nullable=False),
    sa.Column('solver_version', sa.String(length=16), nullable=False),
    sa.Column('os_name', sa.String(length=128), nullable=False),
    sa.Column('os_version', sa.String(length=8), nullable=False),
    sa.Column('python_version', sa.String(length=8), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('ecosystem', 'solver_name', 'solver_version', 'os_name', 'os_version', 'python_version')
    )
    op.create_index('ecosystem_solver_idx', 'ecosystem_solver', ['ecosystem', 'solver_name', 'solver_version', 'os_name', 'os_version', 'python_version'], unique=True)
    op.create_table('hardware_information',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('cpu_vendor', sa.Integer(), nullable=True),
    sa.Column('cpu_model', sa.Integer(), nullable=True),
    sa.Column('cpu_cores', sa.Integer(), nullable=True),
    sa.Column('cpu_model_name', sa.String(length=256), nullable=True),
    sa.Column('cpu_family', sa.Integer(), nullable=True),
    sa.Column('cpu_physical_cpus', sa.Integer(), nullable=True),
    sa.Column('gpu_model_name', sa.String(length=256), nullable=True),
    sa.Column('gpu_vendor', sa.String(length=256), nullable=True),
    sa.Column('gpu_cores', sa.Integer(), nullable=True),
    sa.Column('gpu_memory_size', sa.Integer(), nullable=True),
    sa.Column('ram_size', sa.Integer(), nullable=True),
    sa.Column('is_user', sa.Boolean(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('python_artifact',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('artifact_hash_sha256', sa.String(length=256), nullable=False),
    sa.Column('artifact_name', sa.String(length=256), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('python_file_digest',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('sha256', sa.String(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('sha256')
    )
    op.create_index('sha256_idx', 'python_file_digest', ['sha256'], unique=True)
    op.create_table('python_package_index',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('url', sa.String(length=256), nullable=False),
    sa.Column('warehouse_api_url', sa.String(length=256), nullable=True),
    sa.Column('verify_ssl', sa.Boolean(), nullable=False),
    sa.Column('enabled', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('url')
    )
    op.create_index('url_idx', 'python_package_index', ['url'], unique=True)
    op.create_table('python_software_stack',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('software_stack_type', postgresql.ENUM('USER', 'INSPECTION', 'ADVISED', name='software_stack_type'), nullable=True),
    sa.Column('performance_score', sa.Float(), nullable=True),
    sa.Column('overall_score', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('rpm_package_version',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('package_name', sa.String(length=256), nullable=False),
    sa.Column('package_version', sa.String(length=256), nullable=False),
    sa.Column('release', sa.String(length=256), nullable=True),
    sa.Column('epoch', sa.String(length=256), nullable=True),
    sa.Column('arch', sa.String(length=256), nullable=True),
    sa.Column('src', sa.Boolean(), nullable=True),
    sa.Column('package_identifier', sa.String(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('rpm_requirement',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('rpm_requirement_name', sa.String(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('software_environment',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('environment_name', sa.String(length=256), nullable=True),
    sa.Column('python_version', sa.String(length=256), nullable=True),
    sa.Column('image_name', sa.String(length=256), nullable=True),
    sa.Column('image_sha', sa.String(length=256), nullable=True),
    sa.Column('os_name', sa.String(length=256), nullable=True),
    sa.Column('os_version', sa.String(length=256), nullable=True),
    sa.Column('cuda_version', sa.String(length=256), nullable=True),
    sa.Column('environment_type', postgresql.ENUM('RUNTIME', 'BUILDTIME', name='environment_type'), nullable=False),
    sa.Column('is_user', sa.Boolean(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('versioned_symbol',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('library_name', sa.String(length=256), nullable=False),
    sa.Column('symbol', sa.String(length=256), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('adviser_run',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('adviser_document_id', sa.String(length=256), nullable=False),
    sa.Column('datetime', sa.DateTime(), nullable=False),
    sa.Column('adviser_version', sa.String(length=256), nullable=False),
    sa.Column('adviser_name', sa.String(length=256), nullable=False),
    sa.Column('count', sa.Integer(), nullable=True),
    sa.Column('limit', sa.Integer(), nullable=True),
    sa.Column('origin', sa.String(length=256), nullable=True),
    sa.Column('debug', sa.Boolean(), nullable=False),
    sa.Column('limit_latest_versions', sa.Integer(), nullable=False),
    sa.Column('adviser_error', sa.Boolean(), nullable=False),
    sa.Column('recommendation_type', postgresql.ENUM('STABLE', 'TESTING', 'LATEST', name='recommendation_type'), nullable=False),
    sa.Column('requirements_format', postgresql.ENUM('PIPENV', name='requirements_format'), nullable=False),
    sa.Column('duration', sa.Integer(), nullable=True),
    sa.Column('advised_configuration_changes', sa.Boolean(), nullable=False),
    sa.Column('additional_stack_info', sa.Boolean(), nullable=False),
    sa.Column('user_run_software_environment_id', sa.Integer(), nullable=True),
    sa.Column('user_build_software_environment_id', sa.Integer(), nullable=True),
    sa.Column('user_software_stack_id', sa.Integer(), nullable=True),
    sa.Column('hardware_information_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['hardware_information_id'], ['hardware_information.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['user_build_software_environment_id'], ['software_environment.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['user_run_software_environment_id'], ['software_environment.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['user_software_stack_id'], ['python_software_stack.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('deb_depends',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('version_range', sa.String(length=256), nullable=False),
    sa.Column('deb_dependency_id', sa.Integer(), nullable=False),
    sa.Column('deb_package_version_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['deb_dependency_id'], ['deb_dependency.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['deb_package_version_id'], ['deb_package_version.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'deb_dependency_id', 'deb_package_version_id')
    )
    op.create_table('deb_pre_depends',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('deb_dependency_id', sa.Integer(), nullable=False),
    sa.Column('deb_package_version_id', sa.Integer(), nullable=False),
    sa.Column('version_range', sa.String(length=256), nullable=True),
    sa.ForeignKeyConstraint(['deb_dependency_id'], ['deb_dependency.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['deb_package_version_id'], ['deb_package_version.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'deb_dependency_id', 'deb_package_version_id')
    )
    op.create_table('deb_replaces',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('deb_dependency_id', sa.Integer(), nullable=False),
    sa.Column('deb_package_version_id', sa.Integer(), nullable=False),
    sa.Column('version_range', sa.String(length=256), nullable=False),
    sa.ForeignKeyConstraint(['deb_dependency_id'], ['deb_dependency.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['deb_package_version_id'], ['deb_package_version.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'deb_dependency_id', 'deb_package_version_id')
    )
    op.create_table('dependency_monkey_run',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('dependency_monkey_document_id', sa.String(length=256), nullable=False),
    sa.Column('datetime', sa.DateTime(), nullable=False),
    sa.Column('dependency_monkey_name', sa.String(length=256), nullable=False),
    sa.Column('dependency_monkey_version', sa.String(length=256), nullable=False),
    sa.Column('seed', sa.Integer(), nullable=True),
    sa.Column('decision', sa.String(length=64), nullable=False),
    sa.Column('count', sa.Integer(), nullable=True),
    sa.Column('limit_latest_versions', sa.Integer(), nullable=True),
    sa.Column('debug', sa.Boolean(), nullable=True),
    sa.Column('dependency_monkey_error', sa.Boolean(), nullable=True),
    sa.Column('duration', sa.Integer(), nullable=True),
    sa.Column('run_software_environment_id', sa.Integer(), nullable=True),
    sa.Column('build_software_environment_id', sa.Integer(), nullable=True),
    sa.Column('run_hardware_information_id', sa.Integer(), nullable=True),
    sa.Column('build_hardware_information_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['build_hardware_information_id'], ['hardware_information.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['build_software_environment_id'], ['software_environment.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['run_hardware_information_id'], ['hardware_information.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['run_software_environment_id'], ['software_environment.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('has_symbol',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('software_environment_id', sa.Integer(), nullable=False),
    sa.Column('versioned_symbol_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['software_environment_id'], ['software_environment.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['versioned_symbol_id'], ['versioned_symbol.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'software_environment_id', 'versioned_symbol_id')
    )
    op.create_table('included_file',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('file', sa.String(length=256), nullable=False),
    sa.Column('python_file_digest_id', sa.Integer(), nullable=False),
    sa.Column('python_artifact_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['python_artifact_id'], ['python_artifact.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_file_digest_id'], ['python_file_digest.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'python_file_digest_id', 'python_artifact_id')
    )
    op.create_table('package_extract_run',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('package_extract_name', sa.String(length=256), nullable=False),
    sa.Column('package_extract_version', sa.String(length=256), nullable=False),
    sa.Column('analysis_document_id', sa.String(length=256), nullable=False),
    sa.Column('datetime', sa.DateTime(), nullable=False),
    sa.Column('environment_type', postgresql.ENUM('RUNTIME', 'BUILDTIME', name='environment_type'), nullable=False),
    sa.Column('origin', sa.String(length=256), nullable=True),
    sa.Column('debug', sa.Boolean(), nullable=False),
    sa.Column('package_extract_error', sa.Boolean(), nullable=False),
    sa.Column('image_tag', sa.String(length=256), nullable=False),
    sa.Column('duration', sa.Integer(), nullable=True),
    sa.Column('os_name', sa.String(length=256), nullable=False),
    sa.Column('os_id', sa.String(length=256), nullable=False),
    sa.Column('os_version_id', sa.String(length=256), nullable=False),
    sa.Column('software_environment_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['software_environment_id'], ['software_environment.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('provenance_checker_run',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('provenance_checker_document_id', sa.String(length=256), nullable=False),
    sa.Column('datetime', sa.DateTime(), nullable=False),
    sa.Column('provenance_checker_version', sa.String(length=256), nullable=False),
    sa.Column('provenance_checker_name', sa.String(length=256), nullable=False),
    sa.Column('origin', sa.String(length=256), nullable=True),
    sa.Column('debug', sa.Boolean(), nullable=False),
    sa.Column('provenance_checker_error', sa.Boolean(), nullable=False),
    sa.Column('duration', sa.Integer(), nullable=True),
    sa.Column('user_software_stack_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['user_software_stack_id'], ['python_software_stack.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'user_software_stack_id')
    )
    op.create_table('python_package_requirement',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('name', sa.String(length=256), nullable=False),
    sa.Column('version_range', sa.String(length=256), nullable=False),
    sa.Column('develop', sa.Boolean(), nullable=False),
    sa.Column('python_package_index_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['python_package_index_id'], ['python_package_index.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('python_package_version_entity',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('package_name', sa.String(length=256), nullable=False),
    sa.Column('package_version', sa.String(length=256), nullable=True),
    sa.Column('python_package_index_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['python_package_index_id'], ['python_package_index.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('id'),
    sa.UniqueConstraint('package_name', 'package_version', 'python_package_index_id')
    )
    op.create_index('python_package_version_entity_idx', 'python_package_version_entity', ['package_name', 'package_version', 'python_package_index_id'], unique=True)
    op.create_table('requires_symbol',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('python_artifact_id', sa.Integer(), nullable=False),
    sa.Column('versioned_symbol_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['python_artifact_id'], ['python_artifact.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['versioned_symbol_id'], ['versioned_symbol.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'python_artifact_id', 'versioned_symbol_id')
    )
    op.create_table('rpm_requires',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('rpm_package_version_id', sa.Integer(), nullable=False),
    sa.Column('rpm_requirement_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['rpm_package_version_id'], ['rpm_package_version.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['rpm_requirement_id'], ['rpm_requirement.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'rpm_package_version_id', 'rpm_requirement_id')
    )
    op.create_table('advised',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('adviser_run_id', sa.Integer(), nullable=True),
    sa.Column('python_software_stack_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['adviser_run_id'], ['adviser_run.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_software_stack_id'], ['python_software_stack.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('detected_symbol',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('package_extract_run_id', sa.Integer(), nullable=False),
    sa.Column('versioned_symbol_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['package_extract_run_id'], ['package_extract_run.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['versioned_symbol_id'], ['versioned_symbol.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'package_extract_run_id', 'versioned_symbol_id')
    )
    op.create_table('found_deb',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('deb_package_version_id', sa.Integer(), nullable=False),
    sa.Column('package_extract_run_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['deb_package_version_id'], ['deb_package_version.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['package_extract_run_id'], ['package_extract_run.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'deb_package_version_id', 'package_extract_run_id')
    )
    op.create_table('found_python_file',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('file', sa.String(length=256), nullable=False),
    sa.Column('python_file_digest_id', sa.Integer(), nullable=False),
    sa.Column('package_extract_run_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['package_extract_run_id'], ['package_extract_run.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_file_digest_id'], ['python_file_digest.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'python_file_digest_id', 'package_extract_run_id')
    )
    op.create_table('found_rpm',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('rpm_package_version_id', sa.Integer(), nullable=False),
    sa.Column('package_extract_run_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['package_extract_run_id'], ['package_extract_run.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['rpm_package_version_id'], ['rpm_package_version.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'rpm_package_version_id', 'package_extract_run_id')
    )
    op.create_table('has_vulnerability',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('python_package_version_entity_id', sa.Integer(), nullable=False),
    sa.Column('cve_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['cve_id'], ['cve.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_package_version_entity_id'], ['python_package_version_entity.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'python_package_version_entity_id', 'cve_id')
    )
    op.create_table('inspection_run',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('inspection_document_id', sa.String(length=256), nullable=False),
    sa.Column('datetime', sa.DateTime(), nullable=True),
    sa.Column('amun_version', sa.String(length=256), nullable=True),
    sa.Column('build_requests_cpu', sa.Float(), nullable=True),
    sa.Column('build_requests_memory', sa.Float(), nullable=True),
    sa.Column('run_requests_cpu', sa.Float(), nullable=True),
    sa.Column('run_requests_memory', sa.Float(), nullable=True),
    sa.Column('inspection_sync_state', postgresql.ENUM('PENDING', 'SYNCED', name='inspection_sync_state'), nullable=False),
    sa.Column('build_hardware_information_id', sa.Integer(), nullable=True),
    sa.Column('run_hardware_information_id', sa.Integer(), nullable=True),
    sa.Column('build_software_environment_id', sa.Integer(), nullable=True),
    sa.Column('run_software_environment_id', sa.Integer(), nullable=True),
    sa.Column('dependency_monkey_run_id', sa.Integer(), nullable=True),
    sa.Column('inspection_software_stack_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['build_hardware_information_id'], ['hardware_information.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['build_software_environment_id'], ['software_environment.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['dependency_monkey_run_id'], ['dependency_monkey_run.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['inspection_software_stack_id'], ['python_software_stack.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['run_hardware_information_id'], ['hardware_information.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['run_software_environment_id'], ['software_environment.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('inspection_document_id')
    )
    op.create_table('package_analyzer_run',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('package_analyzer_name', sa.String(length=256), nullable=True),
    sa.Column('package_analyzer_version', sa.String(length=256), nullable=True),
    sa.Column('package_analysis_document_id', sa.String(length=256), nullable=False),
    sa.Column('datetime', sa.DateTime(), nullable=False),
    sa.Column('debug', sa.Boolean(), nullable=False),
    sa.Column('package_analyzer_error', sa.Boolean(), nullable=False),
    sa.Column('duration', sa.Integer(), nullable=True),
    sa.Column('input_python_package_version_entity_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['input_python_package_version_entity_id'], ['python_package_version_entity.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('python_dependency_monkey_requirements',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('python_package_requirement_id', sa.Integer(), nullable=False),
    sa.Column('dependency_monkey_run_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['dependency_monkey_run_id'], ['dependency_monkey_run.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_package_requirement_id'], ['python_package_requirement.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'python_package_requirement_id', 'dependency_monkey_run_id')
    )
    op.create_table('python_package_version',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('package_name', sa.String(length=256), nullable=False),
    sa.Column('package_version', sa.String(length=256), nullable=False),
    sa.Column('os_name', sa.String(length=256), nullable=True),
    sa.Column('os_version', sa.String(length=256), nullable=True),
    sa.Column('python_version', sa.String(length=256), nullable=True),
    sa.Column('entity_id', sa.Integer(), nullable=False),
    sa.Column('python_package_index_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['entity_id'], ['python_package_version_entity.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_package_index_id'], ['python_package_index.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('package_name', 'package_version', 'python_package_index_id', 'os_name', 'os_version', 'python_version')
    )
    op.create_index('python_package_version_idx', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id'], unique=False)
    op.create_index('python_package_version_index_idx_10', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'python_package_index_id'], unique=False)
    op.create_index('python_package_version_index_idx_11', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'os_name'], unique=False)
    op.create_index('python_package_version_index_idx_12', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'os_version'], unique=False)
    op.create_index('python_package_version_index_idx_13', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'python_version'], unique=False)
    op.create_index('python_package_version_index_idx_20', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'python_package_index_id', 'os_name'], unique=False)
    op.create_index('python_package_version_index_idx_21', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'python_package_index_id', 'os_version'], unique=False)
    op.create_index('python_package_version_index_idx_22', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'python_package_index_id', 'python_version'], unique=False)
    op.create_index('python_package_version_index_idx_23', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'os_name', 'os_version'], unique=False)
    op.create_index('python_package_version_index_idx_24', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'os_name', 'python_version'], unique=False)
    op.create_index('python_package_version_index_idx_25', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'os_version', 'python_version'], unique=False)
    op.create_index('python_package_version_index_idx_30', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'python_package_index_id', 'os_name', 'os_version'], unique=False)
    op.create_index('python_package_version_index_idx_31', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'python_package_index_id', 'os_name', 'python_version'], unique=False)
    op.create_index('python_package_version_index_idx_32', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'python_package_index_id', 'os_version', 'python_version'], unique=False)
    op.create_index('python_package_version_index_idx_33', 'python_package_version', ['package_name', 'package_version', 'python_package_index_id', 'os_name', 'os_version', 'python_version'], unique=False)
    op.create_table('python_requirements',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('python_package_requirement_id', sa.Integer(), nullable=False),
    sa.Column('python_software_stack_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['python_package_requirement_id'], ['python_package_requirement.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_software_stack_id'], ['python_software_stack.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'python_package_requirement_id', 'python_software_stack_id')
    )
    op.create_table('depends_on',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('entity_id', sa.Integer(), nullable=False),
    sa.Column('version_id', sa.Integer(), nullable=False),
    sa.Column('version_range', sa.String(length=128), nullable=True),
    sa.ForeignKeyConstraint(['entity_id'], ['python_package_version_entity.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['version_id'], ['python_package_version.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'entity_id', 'version_id'),
    sa.UniqueConstraint('entity_id', 'version_id', 'version_range')
    )
    op.create_index('depends_on_idx', 'depends_on', ['entity_id', 'version_id', 'version_range'], unique=False)
    op.create_index('depends_on_version_range_idx', 'depends_on', ['entity_id', 'version_id', 'version_range'], unique=False)
    op.create_table('has_artifact',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('python_package_version_id', sa.Integer(), nullable=False),
    sa.Column('python_artifact_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['python_artifact_id'], ['python_artifact.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_package_version_id'], ['python_package_version.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'python_package_version_id', 'python_artifact_id')
    )
    op.create_table('identified',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('package_extract_run_id', sa.Integer(), nullable=False),
    sa.Column('python_package_version_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['package_extract_run_id'], ['package_extract_run.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_package_version_id'], ['python_package_version.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'package_extract_run_id', 'python_package_version_id')
    )
    op.create_table('investigated',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('package_analyzer_run_id', sa.Integer(), nullable=False),
    sa.Column('python_artifact_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['package_analyzer_run_id'], ['package_analyzer_run.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_artifact_id'], ['python_artifact.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'package_analyzer_run_id', 'python_artifact_id')
    )
    op.create_table('investigated_file',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('package_analyzer_run_id', sa.Integer(), nullable=False),
    sa.Column('python_file_digest_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['package_analyzer_run_id'], ['package_analyzer_run.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_file_digest_id'], ['python_file_digest.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'package_analyzer_run_id', 'python_file_digest_id')
    )
    op.create_table('pi_conv1d',
    sa.Column('framework', sa.String(length=256), nullable=True),
    sa.Column('origin', sa.String(length=256), nullable=True),
    sa.Column('version', sa.String(length=256), nullable=False),
    sa.Column('overall_score', sa.Float(), nullable=True),
    sa.Column('exit_code', sa.Integer(), nullable=False),
    sa.Column('ru_utime', sa.Float(), nullable=False),
    sa.Column('ru_stime', sa.Float(), nullable=False),
    sa.Column('ru_maxrss', sa.Integer(), nullable=False),
    sa.Column('ru_ixrss', sa.Integer(), nullable=False),
    sa.Column('ru_idrss', sa.Integer(), nullable=False),
    sa.Column('ru_isrss', sa.Integer(), nullable=False),
    sa.Column('ru_minflt', sa.Integer(), nullable=False),
    sa.Column('ru_majflt', sa.Integer(), nullable=False),
    sa.Column('ru_nswap', sa.Integer(), nullable=False),
    sa.Column('ru_inblock', sa.Integer(), nullable=False),
    sa.Column('ru_oublock', sa.Integer(), nullable=False),
    sa.Column('ru_msgsnd', sa.Integer(), nullable=False),
    sa.Column('ru_msgrcv', sa.Integer(), nullable=False),
    sa.Column('ru_nsignals', sa.Integer(), nullable=False),
    sa.Column('ru_nvcsw', sa.Integer(), nullable=False),
    sa.Column('ru_nivcsw', sa.Integer(), nullable=False),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('inspection_run_id', sa.Integer(), nullable=False),
    sa.Column('device', sa.String(length=256), nullable=False),
    sa.Column('dtype', sa.String(length=256), nullable=False),
    sa.Column('reps', sa.Integer(), nullable=False),
    sa.Column('data_format', sa.String(length=256), nullable=False),
    sa.Column('batch', sa.Integer(), nullable=False),
    sa.Column('input_width', sa.Integer(), nullable=False),
    sa.Column('input_channels', sa.Integer(), nullable=False),
    sa.Column('filter_width', sa.Integer(), nullable=False),
    sa.Column('output_channels', sa.Integer(), nullable=False),
    sa.Column('strides', sa.Integer(), nullable=False),
    sa.Column('padding', sa.String(length=256), nullable=False),
    sa.Column('elapsed', sa.Float(), nullable=False),
    sa.Column('rate', sa.Float(), nullable=False),
    sa.ForeignKeyConstraint(['inspection_run_id'], ['inspection_run.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('pi_conv2d',
    sa.Column('framework', sa.String(length=256), nullable=True),
    sa.Column('origin', sa.String(length=256), nullable=True),
    sa.Column('version', sa.String(length=256), nullable=False),
    sa.Column('overall_score', sa.Float(), nullable=True),
    sa.Column('exit_code', sa.Integer(), nullable=False),
    sa.Column('ru_utime', sa.Float(), nullable=False),
    sa.Column('ru_stime', sa.Float(), nullable=False),
    sa.Column('ru_maxrss', sa.Integer(), nullable=False),
    sa.Column('ru_ixrss', sa.Integer(), nullable=False),
    sa.Column('ru_idrss', sa.Integer(), nullable=False),
    sa.Column('ru_isrss', sa.Integer(), nullable=False),
    sa.Column('ru_minflt', sa.Integer(), nullable=False),
    sa.Column('ru_majflt', sa.Integer(), nullable=False),
    sa.Column('ru_nswap', sa.Integer(), nullable=False),
    sa.Column('ru_inblock', sa.Integer(), nullable=False),
    sa.Column('ru_oublock', sa.Integer(), nullable=False),
    sa.Column('ru_msgsnd', sa.Integer(), nullable=False),
    sa.Column('ru_msgrcv', sa.Integer(), nullable=False),
    sa.Column('ru_nsignals', sa.Integer(), nullable=False),
    sa.Column('ru_nvcsw', sa.Integer(), nullable=False),
    sa.Column('ru_nivcsw', sa.Integer(), nullable=False),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('inspection_run_id', sa.Integer(), nullable=False),
    sa.Column('device', sa.String(length=256), nullable=False),
    sa.Column('dtype', sa.String(length=256), nullable=False),
    sa.Column('reps', sa.Integer(), nullable=False),
    sa.Column('data_format', sa.String(length=256), nullable=False),
    sa.Column('batch', sa.Integer(), nullable=False),
    sa.Column('input_height', sa.Integer(), nullable=False),
    sa.Column('input_width', sa.Integer(), nullable=False),
    sa.Column('input_channels', sa.Integer(), nullable=False),
    sa.Column('filter_height', sa.Integer(), nullable=False),
    sa.Column('filter_width', sa.Integer(), nullable=False),
    sa.Column('output_channels', sa.Integer(), nullable=False),
    sa.Column('strides', sa.Integer(), nullable=False),
    sa.Column('padding', sa.String(length=256), nullable=False),
    sa.Column('elapsed', sa.Float(), nullable=False),
    sa.Column('rate', sa.Float(), nullable=False),
    sa.ForeignKeyConstraint(['inspection_run_id'], ['inspection_run.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('pi_matmul',
    sa.Column('framework', sa.String(length=256), nullable=True),
    sa.Column('origin', sa.String(length=256), nullable=True),
    sa.Column('version', sa.String(length=256), nullable=False),
    sa.Column('overall_score', sa.Float(), nullable=True),
    sa.Column('exit_code', sa.Integer(), nullable=False),
    sa.Column('ru_utime', sa.Float(), nullable=False),
    sa.Column('ru_stime', sa.Float(), nullable=False),
    sa.Column('ru_maxrss', sa.Integer(), nullable=False),
    sa.Column('ru_ixrss', sa.Integer(), nullable=False),
    sa.Column('ru_idrss', sa.Integer(), nullable=False),
    sa.Column('ru_isrss', sa.Integer(), nullable=False),
    sa.Column('ru_minflt', sa.Integer(), nullable=False),
    sa.Column('ru_majflt', sa.Integer(), nullable=False),
    sa.Column('ru_nswap', sa.Integer(), nullable=False),
    sa.Column('ru_inblock', sa.Integer(), nullable=False),
    sa.Column('ru_oublock', sa.Integer(), nullable=False),
    sa.Column('ru_msgsnd', sa.Integer(), nullable=False),
    sa.Column('ru_msgrcv', sa.Integer(), nullable=False),
    sa.Column('ru_nsignals', sa.Integer(), nullable=False),
    sa.Column('ru_nvcsw', sa.Integer(), nullable=False),
    sa.Column('ru_nivcsw', sa.Integer(), nullable=False),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('inspection_run_id', sa.Integer(), nullable=False),
    sa.Column('device', sa.String(length=256), nullable=False),
    sa.Column('matrix_size', sa.Integer(), nullable=False),
    sa.Column('dtype', sa.String(length=256), nullable=False),
    sa.Column('reps', sa.Integer(), nullable=False),
    sa.Column('elapsed', sa.Float(), nullable=False),
    sa.Column('rate', sa.Float(), nullable=False),
    sa.ForeignKeyConstraint(['inspection_run_id'], ['inspection_run.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('python_requirements_lock',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('python_package_version_id', sa.Integer(), nullable=False),
    sa.Column('python_software_stack_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['python_package_version_id'], ['python_package_version.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['python_software_stack_id'], ['python_software_stack.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'python_package_version_id', 'python_software_stack_id')
    )
    op.create_table('solved',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('datetime', sa.DateTime(), nullable=False),
    sa.Column('document_id', sa.String(length=128), nullable=False),
    sa.Column('duration', sa.Integer(), nullable=True),
    sa.Column('error', sa.Boolean(), nullable=False),
    sa.Column('error_unparseable', sa.Boolean(), nullable=False),
    sa.Column('error_unsolvable', sa.Boolean(), nullable=False),
    sa.Column('is_provided', sa.Boolean(), nullable=True),
    sa.Column('ecosystem_solver_id', sa.Integer(), nullable=False),
    sa.Column('version_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['ecosystem_solver_id'], ['ecosystem_solver.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['version_id'], ['python_package_version.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', 'ecosystem_solver_id', 'version_id')
    )
    op.create_index('solver_document_id_idx', 'solved', ['document_id'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('solver_document_id_idx', table_name='solved')
    op.drop_table('solved')
    op.drop_table('python_requirements_lock')
    op.drop_table('pi_matmul')
    op.drop_table('pi_conv2d')
    op.drop_table('pi_conv1d')
    op.drop_table('investigated_file')
    op.drop_table('investigated')
    op.drop_table('identified')
    op.drop_table('has_artifact')
    op.drop_index('depends_on_version_range_idx', table_name='depends_on')
    op.drop_index('depends_on_idx', table_name='depends_on')
    op.drop_table('depends_on')
    op.drop_table('python_requirements')
    op.drop_index('python_package_version_index_idx_33', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_32', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_31', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_30', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_25', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_24', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_23', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_22', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_21', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_20', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_13', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_12', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_11', table_name='python_package_version')
    op.drop_index('python_package_version_index_idx_10', table_name='python_package_version')
    op.drop_index('python_package_version_idx', table_name='python_package_version')
    op.drop_table('python_package_version')
    op.drop_table('python_dependency_monkey_requirements')
    op.drop_table('package_analyzer_run')
    op.drop_table('inspection_run')
    op.drop_table('has_vulnerability')
    op.drop_table('found_rpm')
    op.drop_table('found_python_file')
    op.drop_table('found_deb')
    op.drop_table('detected_symbol')
    op.drop_table('advised')
    op.drop_table('rpm_requires')
    op.drop_table('requires_symbol')
    op.drop_index('python_package_version_entity_idx', table_name='python_package_version_entity')
    op.drop_table('python_package_version_entity')
    op.drop_table('python_package_requirement')
    op.drop_table('provenance_checker_run')
    op.drop_table('package_extract_run')
    op.drop_table('included_file')
    op.drop_table('has_symbol')
    op.drop_table('dependency_monkey_run')
    op.drop_table('deb_replaces')
    op.drop_table('deb_pre_depends')
    op.drop_table('deb_depends')
    op.drop_table('adviser_run')
    op.drop_table('versioned_symbol')
    op.drop_table('software_environment')
    op.drop_table('rpm_requirement')
    op.drop_table('rpm_package_version')
    op.drop_table('python_software_stack')
    op.drop_index('url_idx', table_name='python_package_index')
    op.drop_table('python_package_index')
    op.drop_index('sha256_idx', table_name='python_file_digest')
    op.drop_table('python_file_digest')
    op.drop_table('python_artifact')
    op.drop_table('hardware_information')
    op.drop_index('ecosystem_solver_idx', table_name='ecosystem_solver')
    op.drop_table('ecosystem_solver')
    op.drop_table('deb_package_version')
    op.drop_table('deb_dependency')
    op.drop_table('cve')
    # ### end Alembic commands ###
