"""Added SecurityIndicatorAggregatedRun Table and Aggregated Table

Revision ID: 9aa4e29fa260
Revises: d77154f3c15f
Create Date: 2020-07-03 12:23:50.615984+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '9aa4e29fa260'
down_revision = 'd77154f3c15f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('si_aggregated_run',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('si_aggregated_run_document_id', sa.Text(), nullable=False),
    sa.Column('severity_high_confidence_high', sa.Integer(), nullable=False),
    sa.Column('severity_high_confidence_low', sa.Integer(), nullable=False),
    sa.Column('severity_high_confidence_medium', sa.Integer(), nullable=False),
    sa.Column('severity_high_confidence_undefined', sa.Integer(), nullable=False),
    sa.Column('severity_low_confidence_high', sa.Integer(), nullable=False),
    sa.Column('severity_low_confidence_low', sa.Integer(), nullable=False),
    sa.Column('severity_low_confidence_medium', sa.Integer(), nullable=False),
    sa.Column('severity_low_confidence_undefined', sa.Integer(), nullable=False),
    sa.Column('severity_medium_confidence_high', sa.Integer(), nullable=False),
    sa.Column('severity_medium_confidence_low', sa.Integer(), nullable=False),
    sa.Column('severity_medium_confidence_medium', sa.Integer(), nullable=False),
    sa.Column('severity_medium_confidence_undefined', sa.Integer(), nullable=False),
    sa.Column('number_of_analyzed_files', sa.Integer(), nullable=False),
    sa.Column('number_of_files_total', sa.Integer(), nullable=False),
    sa.Column('number_of_files_with_severities', sa.Integer(), nullable=False),
    sa.Column('number_of_filtered_files', sa.Integer(), nullable=False),
    sa.Column('number_of_python_files', sa.Integer(), nullable=False),
    sa.Column('number_of_lines_with_comments_in_python_files', sa.Integer(), nullable=False),
    sa.Column('number_of_blank_lines_in_python_files', sa.Integer(), nullable=False),
    sa.Column('number_of_lines_with_code_in_python_files', sa.Integer(), nullable=False),
    sa.Column('total_number_of_files', sa.Integer(), nullable=False),
    sa.Column('total_number_of_lines', sa.Integer(), nullable=False),
    sa.Column('total_number_of_lines_with_comments', sa.Integer(), nullable=False),
    sa.Column('total_number_of_blank_lines', sa.Integer(), nullable=False),
    sa.Column('total_number_of_lines_with_code', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('si_aggregated',
    sa.Column('si_aggregated_run_id', sa.Integer(), nullable=False),
    sa.Column('python_package_version_entity_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['python_package_version_entity_id'], ['python_package_version_entity.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['si_aggregated_run_id'], ['si_aggregated_run.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('si_aggregated_run_id', 'python_package_version_entity_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('si_aggregated')
    op.drop_table('si_aggregated_run')
    # ### end Alembic commands ###
