from typing import Protocol, Optional, Sequence
from baltra_sdk.domain.models.company_group import CompanyGroup

class CompanyGroupRepository(Protocol):
    def create(self, entity: CompanyGroup) -> CompanyGroup: ...
    def get(self, group_id: int) -> Optional[CompanyGroup]: ...
    def list(self, limit: int = 100, offset: int = 0) -> Sequence[CompanyGroup]: ...
