from typing import Protocol, Optional, Sequence
from baltra_sdk.domain.models.location import Location

class LocationRepository(Protocol):
    def create(self, entity: Location) -> Location: ...
    def get(self, location_id: int) -> Optional[Location]: ...
    def list_by_company(self, company_id: int, limit: int = 100, offset: int = 0) -> Sequence[Location]: ...
