# Glossary

Glossary terms for units found within the codebase.

```{glossary}

arcsec
    Arcsecond, a unit of angular measurement equal to 1/3600 of a degree. Used here to denote coordinates in the lens plane, deflection angles, the core radius, the scale radius, the Einstein radius of the lens, and the softening parameter.


arcsec^2
    Square arcseconds, used to denote the gravitational lensing potential at given coordinates and also used in the calculation of the radius in the lensing potential and convergence formulas.


Msun
    Solar mass, used here to denote the total mass of the lens.


Mpc
    Megaparsec, a unit of distance used in astronomy, used to denote distances related to the angular diameter distance in the cosmology calculations.


Msun/Mpc^2
    Solar masses per square megaparsec, used to denote the surface mass density at given coordinates and the critical surface density.


Msun/Mpc^3
    Solar masses per cubic megaparsec, used here to denote the central mass density in the central convergence calculation.


seconds
    Time unit, used here to denote the gravitational time delay.


radians
    A unit of angular measure used to denote the orientation of the lens on the sky and the position angle of the lens.

arcsec/pixel
    Arcseconds per pixel, used to denote the pixel scale of the source image in the lens plane, indicating the angular size each pixel represents.


flux
    A unit of brightness, used here to denote the intensity values within the pixelated source image and the intensity at the effective radius (Ie) of the Sersic source.


unitless
    Indicates a dimensionless quantity, used here for redshifts, the axis ratio of the lens, the power-law slope parameter of the lens model, shear components, the redshift of the lens, the concentration parameter, and the convergence of the lens.
```
