from enum import Enum

import numpy as np
from numpy.typing import NDArray
from typing_extensions import TypedDict

Array = NDArray
FloatArray64 = NDArray[np.float64]
FloatArray32 = NDArray[np.float32]
IntArray64 = NDArray[np.int64]
IntArray32 = NDArray[np.int32]


class FilePath(TypedDict):
    # 配置文件路径
    cfg_path: str
    # 数据文件路径
    dat_path: str
    # 模型文件路径
    dmf_path: str


class IdxType(Enum):
    INDEX = (0, "index索引")
    CFGAN = (1, "cfg_idx索引")


class ChannelType(Enum):
    ANALOG = (0, "模拟通道")
    DIGITAL = (1, "开关量通道")
