import unittest

from spruned.dependencies.pybitcointools import serialize, deserialize


class TestSerialize(unittest.TestCase):

    def test_serialize(self):
        tx = '0100000001239f932c780e517015842f3b02ff765fba97f9f63f9f1bc718b686a56ed9c73400000000fd5d01004730440' \
             '2200c40fa58d3f6d5537a343cf9c8d13bc7470baf1d13867e0de3e535cd6b4354c802200f2b48f67494835b060d0b2ff8' \
             '5657d2ba2d9ea4e697888c8cb580e8658183a801483045022056f488c59849a4259e7cef70fe5d6d53a4bd1c59a195b05' \
             '77bd81cb76044beca022100a735b319fa66af7b178fc719b93f905961ef4d4446deca8757a90de2106dd98a014cc95241' \
             '046c7d87fd72caeab48e937f2feca9e9a4bd77f0eff4ebb2dbbb9855c023e334e188d32aaec4632ea4cbc575c037d8101' \
             'aec73d029236e7b1c2380f3e4ad7edced41046fd41cddf3bbda33a240b417a825cc46555949917c7ccf64c59f42fd8dfe' \
             '95f34fae3b09ed279c8c5b3530510e8cca6230791102eef9961d895e8db54af0563c410488d618b988efd2511fc1f9c03' \
             'f11c210808852b07fe46128c1a6b1155aa22cdf4b6802460ba593db2d11c7e6cbe19cedef76b7bcabd05d26fd97f4c5a5' \
             '9b225053aeffffffff0310270000000000001976a914a89733100315c37d228a529853af341a9d290a4588ac409c00000' \
             '000000017a9142b56f9a4009d9ff99b8f97bea4455cd71135f5dd87409c00000000000017a9142b56f9a4009d9ff99b8f' \
             '97bea4455cd71135f5dd8700000000'
        reserialized = serialize(deserialize(tx))
        self.assertEqual(
            reserialized,
            tx,
            "Serialize roundtrip failed"
        )

    def test_segwit_serialize(self):
        tx = '01000000000103b0c03779c38ddabc044947b164adbcffde8e0ddb3678494f4e8b83f13b37629d0100000000ffffffff06' \
             '0eeae54b70d12caddcc15f8897ebc2b6c3011c9a600aba74d49b969991cab30000000000ffffffff7f715ba408db028911' \
             '8f9b8578e54e721f1aee10d09844510793b8b20c87903e0100000000ffffffff02d5781100000000001976a914342ab422' \
             'c9e3ef285efe9882ae54269ed9713dd688ac20a10700000000001976a91488d924f51033b74a895863a5fb57fd545529df' \
             '7d88ac02483045022100f3c0f555cd39198caf77f6756256801fc57bcabe4892601b9def52259698f40a0220230262841b' \
             'ff151eb617f7d4cdda6bf06d6fa791230c152e47f68bcdd0e6f64a01210204b3506d8903ca601c97a4abab6548e91004c5' \
             '35a5a45e21299a494b146859ca024830450221009dbeb64ddd4646e1118503c87feaa95c531b5178c6e543be782f6ecb05' \
             'e8fbe602203945570f8dc56c145617f0283fa4032e0b7895a9cf2a81c7b65665b8ac608cb00121026602a5dc59c30f485b' \
             '2c457ac8e2f617e27b10a1d2ae76f3231f9b01dff089640248304502210095e300886ec4df78e39d6d0cf5e5e531ded8f4' \
             '2f00e5730c371d8951867dad5b02203c55f9403f6c2aac444213161a93a86661e7367d4007be74ffb3981387cc1c790121' \
             '023f0aadfeb71a4964c5087fec8b052c8236051dae838d4747543330c6b266ce6e00000000'
        reserialized = serialize(deserialize(tx))
        self.assertEqual(
            reserialized,
            tx,
            "Serialize roundtrip failed"
        )
