# mypy-boto3-rekognition

[![PyPI - mypy-boto3-rekognition](https://img.shields.io/pypi/v/mypy-boto3-rekognition.svg?color=blue)](https://pypi.org/project/mypy-boto3-rekognition)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-rekognition.svg?color=blue)](https://pypi.org/project/mypy-boto3-rekognition)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Rekognition 1.12.44](https://boto3.amazonaws.com/v1/documentation/api/1.12.44/reference/services/rekognition.html#Rekognition) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.7](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-rekognition](#mypy-boto3-rekognition)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Rekognition` service.

```bash
python -m pip install boto3-stubs[rekognition]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import rekognition
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_rekognition as rekognition

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("rekognition")
client: rekognition.RekognitionClient = boto3.client("rekognition")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: rekognition.RekognitionClient = session.client("rekognition")


# Waiters need type annotation on creation
project_version_running_waiter: rekognition.ProjectVersionRunningWaiter = client.get_waiter("project_version_running")
project_version_training_completed_waiter: rekognition.ProjectVersionTrainingCompletedWaiter = client.get_waiter("project_version_training_completed")

# Paginators need type annotation on creation
describe_project_versions_paginator: rekognition.DescribeProjectVersionsPaginator = client.get_paginator("describe_project_versions")
describe_projects_paginator: rekognition.DescribeProjectsPaginator = client.get_paginator("describe_projects")
list_collections_paginator: rekognition.ListCollectionsPaginator = client.get_paginator("list_collections")
list_faces_paginator: rekognition.ListFacesPaginator = client.get_paginator("list_faces")
list_stream_processors_paginator: rekognition.ListStreamProcessorsPaginator = client.get_paginator("list_stream_processors")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.