"""hash functions for the cubicbweb-file cube

:organization: Logilab
:copyright: 2018-2022 LOGILAB S.A. (Paris, FRANCE), all rights reserved.
:contact: http://www.logilab.fr/ -- mailto:contact@logilab.fr
"""

import re
import hashlib


def compute_hash(value, alg):
    hashvalue = compute_row_hash(value, alg)
    if hashvalue:
        return f"{{{alg}}}{hashvalue}"


def compute_row_hash(value, alg):
    if value is not None:
        hasher = hashlib.new(alg, value)
        return str(hasher.hexdigest())


def check_hash(hash_value, value):
    m = re.match("{(?P<alg>[A-Za-z0-9]+)}(?P<hash>.+)", hash_value)
    if m:
        alg = m.group("alg")
        hashhex = m.group("hash")
    else:  # bw compat, used to be sha1
        alg = "sha1"
        hashhex = hash_value
    comphash = compute_row_hash(value, alg=alg)
    return comphash == hashhex
