# Generated by Django 5.2.6 on 2025-10-15 19:52

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('account', '0015_groupmember_last_activity'),
    ]

    operations = [
        migrations.AddField(
            model_name='geolocatedip',
            name='asn',
            field=models.CharField(blank=True, help_text='Autonomous System Number', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='geolocatedip',
            name='asn_org',
            field=models.CharField(blank=True, help_text='Organization owning the ASN', max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='geolocatedip',
            name='connection_type',
            field=models.CharField(blank=True, help_text='Connection type: residential, business, hosting, cellular, etc.', max_length=50, null=True),
        ),
        migrations.AddField(
            model_name='geolocatedip',
            name='is_cloud',
            field=models.BooleanField(db_index=True, default=False, help_text='Is this IP from a cloud platform (AWS, GCP, Azure, etc.)?'),
        ),
        migrations.AddField(
            model_name='geolocatedip',
            name='is_datacenter',
            field=models.BooleanField(db_index=True, default=False, help_text='Is this IP from a datacenter/hosting provider?'),
        ),
        migrations.AddField(
            model_name='geolocatedip',
            name='is_proxy',
            field=models.BooleanField(db_index=True, default=False, help_text='Is this IP a known proxy server?'),
        ),
        migrations.AddField(
            model_name='geolocatedip',
            name='is_tor',
            field=models.BooleanField(db_index=True, default=False, help_text='Is this IP a known Tor exit node?'),
        ),
        migrations.AddField(
            model_name='geolocatedip',
            name='is_vpn',
            field=models.BooleanField(db_index=True, default=False, help_text='Is this IP associated with a VPN service?'),
        ),
        migrations.AddField(
            model_name='geolocatedip',
            name='isp',
            field=models.CharField(blank=True, help_text='Internet Service Provider', max_length=255, null=True),
        ),
        migrations.AddField(
            model_name='geolocatedip',
            name='threat_level',
            field=models.CharField(blank=True, db_index=True, help_text='Threat level: low, medium, high, critical', max_length=20, null=True),
        ),
        migrations.AddIndex(
            model_name='geolocatedip',
            index=models.Index(fields=['is_tor', 'is_vpn', 'is_proxy'], name='account_geo_is_tor_4ed9e8_idx'),
        ),
        migrations.AddIndex(
            model_name='geolocatedip',
            index=models.Index(fields=['threat_level', 'modified'], name='account_geo_threat__73a490_idx'),
        ),
        migrations.AddIndex(
            model_name='geolocatedip',
            index=models.Index(fields=['is_cloud', 'is_datacenter'], name='account_geo_is_clou_b3c623_idx'),
        ),
    ]
