# AUTOGENERATED! DO NOT EDIT! File to edit: pynamodbAttributes.ipynb (unless otherwise specified).

__all__ = ['getTypes', 'typeMapJsonSchema', 'typeMap']

# Cell
from pynamodb.attributes import Attribute
import pynamodb

# Cell
typeMap = {'string': str, 'number': float, 'integer': int, 'object': dict, 'array': list, 'boolean': bool, 'null': None}
def getTypes(schemaUrl:str, typeMap:dict=typeMap)->dict:
  '''get python types from json schema'''
  r = requests.get(schemaUrl)
  s = yaml.load(r.text, Loader=yaml.FullLoader)
  properties = s['properties']
  dtypes = {k: typeMap.get(v['type']) for k,v in properties.items()}
  return dtypes
def typeMapJsonSchema(url:str, input_:dict = {}, typeMap:dict = typeMap, defaultType=str):
  '''
  try to map the datatype into the one specified in url of json schema.
  if type is not found, the defaultType is used
  '''
  typesDict = getTypes(url, typeMap=typeMap) # get dtype from schema url
  print(f'typesDict is: {typesDict}')
  convertedInput = {k: (typesDict.get(k) or defaultType)(v) for k,v in input_.items()}
  return convertedInput

