var ckan;
(function (ckan) {
    let CKANEXT_FILES;
    (function (CKANEXT_FILES) {
        let adapters;
        (function (adapters) {
            class S3Multipart extends adapters.Multipart {
                async __x_uploadChunk(info, part, start) {
                    if (!part.size) {
                        throw new Error("0-length chunks are not allowed");
                    }
                    debugger;
                    const request = new XMLHttpRequest();
                    request.open("PUT", info.storage_data.upload_url);
                    request.send(part);
                    const resp = await new Promise((done, fail) => {
                        request.addEventListener("load", (event) => done(request));
                    });
                    let uploaded;
                    if ([200, 201].includes(resp.status)) {
                        uploaded = info.size;
                    }
                    else {
                        throw new Error(await resp.responseText);
                    }
                    if (!Number.isInteger(uploaded)) {
                        throw new Error(`Invalid uploaded size ${uploaded}`);
                    }
                    return new Promise((done, fail) => {
                        this.sandbox.client.call("POST", "files_multipart_update", {
                            id: info.id,
                            uploaded,
                            etag: resp.getResponseHeader("ETag")
                        }, (data) => {
                            done(data.result);
                        }, (resp) => {
                            fail(typeof resp.responseJSON === "string"
                                ? resp.responseText
                                : resp.responseJSON.error);
                        });
                    });
                }
            }
            adapters.S3Multipart = S3Multipart;
        })(adapters = CKANEXT_FILES.adapters || (CKANEXT_FILES.adapters = {}));
    })(CKANEXT_FILES = ckan.CKANEXT_FILES || (ckan.CKANEXT_FILES = {}));
})(ckan || (ckan = {}));
//# sourceMappingURL=data:application/json;base64,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
