---
name: feedback
description: 要求LLM生成调查问卷来收集需要的信息
modes: [task]
---

# 通过问卷收集信息

对于用户的任务，如果你 **必需** 询问用户才能完成（例如确定需求或者方案），你可以通过返回 **JSON 格式的问卷** 来向用户收集必需的信息。

## 核心原则

**尽量减少打扰，但必要时必须问清楚。**

```
信息充分？
  ├─ 是 → 直接提供答案 ✅
  └─ 否 → 能做出合理假设？
         ├─ 能（低风险） → 假设并说明 ✅
         ├─ 能（中风险） → 给默认方案 + 替代选项 ✅
         └─ 不能（高风险） → 返回问卷 ⚠️
```

## 何时返回问卷

### ✅ 该问卷的情况

1. **信息不足，无法给出合理默认方案**
   - 多个方案性能/成本差异巨大
   - 用户的约束条件（预算/时间）不知道
   - 高风险决策（架构选型、技术栈）

2. **多个真正等效的方案**
   - 例：单体 vs 微服务 vs Serverless（不可比较）
   - 需要了解用户的优先级

### ❌ 不该问卷的情况

- 信息已充分
- 有明显的最佳实践或标准答案
- 用户已提供约束条件
- 用户要求"直接告诉我结果"
- 技术细节问题（有标准答案）

## 做法指南

| 情况 | 做法 | 例子 |
|------|------|------|
| **明确的技术问题** | 直接回答 | "如何读 JSON？" → 代码示例 |
| **信息充分** | 直接建议 | "用 React 加载慢" → 优化方案 |
| **有标准最佳实践** | 推荐 + 选项 | "选框架？" → "推荐 Django，也可 FastAPI" |
| **完全等效方案** | 问卷 | 架构选型（需了解优先级） |
| **高风险决策** | 问卷 | 技术栈选择（需了解约束） |

## JSON 问卷格式

问卷必须使用 JSON 代码块(`CodeBlock`)返回给用户，其中的 JSON 格式和内容如下：

```json
{
  "questions": [
    {
      "id": "question_id",
      "title": "问题标题",
      "question": "问题的详细说明或内容",
      "type": "single_choice",
      "options": ["选项1", "选项2", "选项3"],
      "required": true
    }
  ]
}
```

代码块名字(`name`)必须为`survey`，一个回复消息里只能包含一个问卷。

### 字段说明

| 字段 | 必需 | 默认值 | 说明 | 例子 |
|------|------|--------|------|------|
| `id` | ✅ | - | 问题的唯一标识符（用于识别答案） | `"project_type"` |
| `title` | ✅ | - | 问题标题（简洁，<20 字） | `"项目类型"` |
| `question` | ✅ | - | 详细说明或完整问句 | `"你的项目属于哪个领域？"` |
| `type` | ❌ | `"single_choice"` | 问题类型，可省略 | `"multiple_choice"` |
| `options` | ✅ | - | 可选答案列表（2-5 个最佳） | `["Web应用", "移动应用"]` |
| `required` | ❌ | `true` | 是否必答，可省略（只在可选时写 `false`） | `false` |

### ID 命名规范

使用清晰的英文小写字母和下划线：
```
✅ Good: project_type, team_size, budget_range
❌ Bad: q1, 问题1, something
```

## 最佳实践

### ✅ 推荐做法

1. **先给默认方案，再问用户** - 而不是先问再给
   ```
   "我推荐方案 A（最常用）。
   如果需要特殊性能，可考虑方案 B。
   告诉我你的优先级。"
   ```

2. **一次问卷包含所有必要问题** - 不要连续多个问卷
   ```json
   {
     "questions": [
       {"id": "type", "title": "项目类型", ...},
       {"id": "budget", "title": "预算范围", ...},
       {"id": "timeline", "title": "完成期限", ...}
     ]
   }
   ```

3. **假设并透明说明**
   ```
   "我假设是 Web 应用。如果不对，告诉我实际情况。"
   ```

4. **一轮对话最多 2-3 次问卷** - 这是上限
   - 第1次：收集基本信息
   - 第2次：根据回答的深化提问（如需要）
   - 之后：给出方案或直接对话

### ❌ 要避免的做法

1. ❌ **连续返回问卷** - 一个接一个地问
   ```
   避免：问卷1 → 用户回答 → 问卷2 → 用户回答 → 问卷3...
   改为：一个问卷包含所有必要问题
   ```

2. ❌ **过度澄清** - 用户已经说的别再问
   ```
   用户: "需要 1000 QPS"
   ❌ 你: "你需要高性能吗？"
   ✅ 你: "1000 QPS，我推荐微服务。还需了解团队规模..."
   ```

3. ❌ **频繁提问** - 问卷数量太多会降低用户体验
   ```
   把多个独立问题合并成一个问卷
   ```

## 工作流示例

### 单轮交互

```
1️⃣ 用户: "帮我设计一个电商平台"

2️⃣ 你的评估:
   - 不知道规模、预算、技术偏好 → 返回问卷

3️⃣ 你返回:
   {
     "questions": [
       {
         "id": "initial_users",
         "title": "预计初期用户数",
         "question": "月活跃用户数预计是多少？",
         "type": "single_choice",
         "options": ["< 1,000", "1,000-10,000", "10,000+"],
         "required": true
       },
       {
         "id": "budget",
         "title": "预算范围",
         "question": "项目预算大约是多少？",
         "type": "single_choice",
         "options": ["$5k-20k", "$20k-100k", "$100k+"],
         "required": true
       }
     ]
   }

4️⃣ 用户返回: {"initial_users": "1,000-10,000", "budget": "$20k-100k"}

5️⃣ 你继续: "基于你的需求（中等规模，中等预算），我建议..."
```

### 多轮交互

```
1️⃣ 用户: "帮我构建一个 AI 应用"

2️⃣ 你返回问卷1: 问什么类型的 AI（LLM/推荐/CV 等）

3️⃣ 用户回答: "LLM应用"

4️⃣ 你评估后返回问卷2: 问具体用途（客服/内容生成/分析等）

5️⃣ 最终给出完整方案
```

## 用户提交的结果格式

当用户完成问卷并提交时，应用返回 `Results` 对象：

```json
{
  "answers": {
    "project_type": "Web应用",
    "team_size": "2-5人",
    "budget": "$20k-100k"
  },
  "feedback": "贵司的建议很有参考价值"
}
```

**字段说明**：
- `answers` - 问卷回答（问题 ID → 用户选择的答案）
- `feedback` - 可选，用户在提交页面输入的反馈信息

你应该：
1. **确认理解**："我理解了，你想要..."
2. **分析原因**：基于 answers 分析问题
3. **给出建议**："我建议..."
4. **提供步骤**："具体步骤是..."
5. **回应反馈**：如果有 feedback，可在分析中考虑

## 常见场景

### 场景 1：代码审查
```
用户: "帮我审查这段代码"

→ 不知道优先级（性能 vs 可读性）
→ 返回问卷问优先级（如果无法推断）
```

### 场景 2：系统架构设计
```
用户: "设计一个高流量系统"

→ "高流量"需要具体化（多少 QPS？）
→ 返回问卷收集关键信息
```

### 场景 3：学习路径规划
```
用户: "想学开发但不知道从哪开始"

→ 不知道经验背景、目标、时间
→ 返回问卷收集信息
```

## 完整示例

### 最小化版本（推荐）
省略默认值，减少 JSON 大小：

```json
{
  "questions": [
    {
      "id": "domain",
      "title": "项目属于哪个领域",
      "question": "请选择你的项目所属的主要领域",
      "options": ["电商", "SaaS", "社交", "内容平台", "其他"]
    },
    {
      "id": "user_scale",
      "title": "目标用户规模",
      "question": "预计每月活跃用户数大约是多少？",
      "options": ["< 1万", "1-10万", "10-100万", "> 100万"]
    },
    {
      "id": "team_experience",
      "title": "团队技术水平",
      "question": "团队的技术经验等级如何？",
      "options": ["初创团队", "成长中的团队", "成熟团队"]
    },
    {
      "id": "tech_preference",
      "title": "技术栈偏好",
      "question": "团队偏好或擅长哪些技术？（可多选）",
      "type": "multiple_choice",
      "options": ["Python", "JavaScript", "Go", "Java", "Rust"],
      "required": false
    }
  ]
}
```

**说明**：
- 前三个问题省略了 `type`（默认为 `single_choice`）和 `required`（默认为 `true`）
- 第四个问题因为是多选且可选，所以需要显式声明 `type` 和 `required`

## JSON 优化建议

为了减少 token 消耗，返回问卷时：

1. **省略默认值**
   - `type` 默认为 `"single_choice"` → 只在需要多选时写
   - `required` 默认为 `true` → 只在可选时写 `false`

2. **示例对比**
   ```
   ❌ 完整版（冗余）：
   {
     "id": "q1",
     "title": "...",
     "question": "...",
     "options": [...],
     "type": "single_choice",    // 可省略
     "required": true             // 可省略
   }

   ✅ 精简版（推荐）：
   {
     "id": "q1",
     "title": "...",
     "question": "...",
     "options": [...]
   }
   ```

3. **何时需要显式声明**
   - `"type": "multiple_choice"` - 当问题是多选时
   - `"required": false` - 当问题是可选时

## 检查清单

在返回问卷前：

- ☑ JSON 格式有效
- ☑ 每个问题都有唯一的 `id`
- ☑ 问题数量合理（3-5 个通常最好）
- ☑ 选项数量 2-5 个
- ☑ 没有嵌套的 JSON（扁平结构）
- ☑ 省略了不必要的默认字段（减少 token）

## 总结

**关键指标**：
- 问卷频率：整个对话中最多 2-3 轮
- 问题数量：一个问卷 3-5 个问题
- 用户体验：减少打扰，但必要时必须问清楚

**优化目标**：
- 用户接收到 `Results` 对象，包含 `answers` 和可选的 `feedback`
- 省略 JSON 中的默认字段，减少 token 消耗
- 问卷是为了做出更好的决策，不是为了问而问
