<a id="mypy-boto3-iotthingsgraph"></a>

# mypy-boto3-iotthingsgraph

[![PyPI - mypy-boto3-iotthingsgraph](https://img.shields.io/pypi/v/mypy-boto3-iotthingsgraph.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotthingsgraph)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iotthingsgraph.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotthingsgraph)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-iotthingsgraph?color=blue)](https://pypistats.org/packages/mypy-boto3-iotthingsgraph)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.IoTThingsGraph 1.18.8](https://boto3.amazonaws.com/v1/documentation/api/1.18.8/reference/services/iotthingsgraph.html#IoTThingsGraph)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-iotthingsgraph docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotthingsgraph/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-iotthingsgraph](#mypy-boto3-iotthingsgraph)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `IoTThingsGraph` service.

```bash
python -m pip install boto3-stubs[iotthingsgraph]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[iotthingsgraph]` in your environment:
  `python -m pip install 'boto3-stubs[iotthingsgraph]'`

Both type checking and auto-complete should work for `IoTThingsGraph` service.
No explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[iotthingsgraph]` in your environment:
  `python -m pip install 'boto3-stubs[iotthingsgraph]'`

Both type checking and auto-complete should work for `IoTThingsGraph` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[iotthingsgraph]` in your environment:
  `python -m pip install 'boto3-stubs[iotthingsgraph]'`
- Run `mypy` as usual

Type checking should work for `IoTThingsGraph` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[iotthingsgraph]` in your environment:
  `python -m pip install 'boto3-stubs[iotthingsgraph]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `IoTThingsGraph` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`IoTThingsGraphClient` provides annotations for
`boto3.client("iotthingsgraph")`.

```python
import boto3

from mypy_boto3_iotthingsgraph import IoTThingsGraphClient

client: IoTThingsGraphClient = boto3.client("iotthingsgraph")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IoTThingsGraphClient = session.client("iotthingsgraph")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_iotthingsgraph.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_iotthingsgraph import IoTThingsGraphClient
from mypy_boto3_iotthingsgraph.paginator import (
    GetFlowTemplateRevisionsPaginator,
    GetSystemTemplateRevisionsPaginator,
    ListFlowExecutionMessagesPaginator,
    ListTagsForResourcePaginator,
    SearchEntitiesPaginator,
    SearchFlowExecutionsPaginator,
    SearchFlowTemplatesPaginator,
    SearchSystemInstancesPaginator,
    SearchSystemTemplatesPaginator,
    SearchThingsPaginator,
)

client: IoTThingsGraphClient = boto3.client("iotthingsgraph")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_flow_template_revisions_paginator: GetFlowTemplateRevisionsPaginator = client.get_paginator("get_flow_template_revisions")
get_system_template_revisions_paginator: GetSystemTemplateRevisionsPaginator = client.get_paginator("get_system_template_revisions")
list_flow_execution_messages_paginator: ListFlowExecutionMessagesPaginator = client.get_paginator("list_flow_execution_messages")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
search_entities_paginator: SearchEntitiesPaginator = client.get_paginator("search_entities")
search_flow_executions_paginator: SearchFlowExecutionsPaginator = client.get_paginator("search_flow_executions")
search_flow_templates_paginator: SearchFlowTemplatesPaginator = client.get_paginator("search_flow_templates")
search_system_instances_paginator: SearchSystemInstancesPaginator = client.get_paginator("search_system_instances")
search_system_templates_paginator: SearchSystemTemplatesPaginator = client.get_paginator("search_system_templates")
search_things_paginator: SearchThingsPaginator = client.get_paginator("search_things")
```

<a id="literals"></a>

### Literals

`mypy_boto3_iotthingsgraph.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_iotthingsgraph.literals import (
    DefinitionLanguageType,
    DeploymentTargetType,
    EntityFilterNameType,
    EntityTypeType,
    FlowExecutionEventTypeType,
    FlowExecutionStatusType,
    FlowTemplateFilterNameType,
    GetFlowTemplateRevisionsPaginatorName,
    GetSystemTemplateRevisionsPaginatorName,
    ListFlowExecutionMessagesPaginatorName,
    ListTagsForResourcePaginatorName,
    NamespaceDeletionStatusErrorCodesType,
    NamespaceDeletionStatusType,
    SearchEntitiesPaginatorName,
    SearchFlowExecutionsPaginatorName,
    SearchFlowTemplatesPaginatorName,
    SearchSystemInstancesPaginatorName,
    SearchSystemTemplatesPaginatorName,
    SearchThingsPaginatorName,
    SystemInstanceDeploymentStatusType,
    SystemInstanceFilterNameType,
    SystemTemplateFilterNameType,
    UploadStatusType,
)

def check_value(value: DefinitionLanguageType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_iotthingsgraph.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_iotthingsgraph.type_defs import (
    AssociateEntityToThingRequestRequestTypeDef,
    CreateFlowTemplateRequestRequestTypeDef,
    CreateFlowTemplateResponseTypeDef,
    CreateSystemInstanceRequestRequestTypeDef,
    CreateSystemInstanceResponseTypeDef,
    CreateSystemTemplateRequestRequestTypeDef,
    CreateSystemTemplateResponseTypeDef,
    DefinitionDocumentTypeDef,
    DeleteFlowTemplateRequestRequestTypeDef,
    DeleteNamespaceResponseTypeDef,
    DeleteSystemInstanceRequestRequestTypeDef,
    DeleteSystemTemplateRequestRequestTypeDef,
    DependencyRevisionTypeDef,
    DeploySystemInstanceRequestRequestTypeDef,
    DeploySystemInstanceResponseTypeDef,
    DeprecateFlowTemplateRequestRequestTypeDef,
    DeprecateSystemTemplateRequestRequestTypeDef,
    DescribeNamespaceRequestRequestTypeDef,
    DescribeNamespaceResponseTypeDef,
    DissociateEntityFromThingRequestRequestTypeDef,
    EntityDescriptionTypeDef,
    EntityFilterTypeDef,
    FlowExecutionMessageTypeDef,
    FlowExecutionSummaryTypeDef,
    FlowTemplateDescriptionTypeDef,
    FlowTemplateFilterTypeDef,
    FlowTemplateSummaryTypeDef,
    GetEntitiesRequestRequestTypeDef,
    GetEntitiesResponseTypeDef,
    GetFlowTemplateRequestRequestTypeDef,
    GetFlowTemplateResponseTypeDef,
    GetFlowTemplateRevisionsRequestRequestTypeDef,
    GetFlowTemplateRevisionsResponseTypeDef,
    GetNamespaceDeletionStatusResponseTypeDef,
    GetSystemInstanceRequestRequestTypeDef,
    GetSystemInstanceResponseTypeDef,
    GetSystemTemplateRequestRequestTypeDef,
    GetSystemTemplateResponseTypeDef,
    GetSystemTemplateRevisionsRequestRequestTypeDef,
    GetSystemTemplateRevisionsResponseTypeDef,
    GetUploadStatusRequestRequestTypeDef,
    GetUploadStatusResponseTypeDef,
    ListFlowExecutionMessagesRequestRequestTypeDef,
    ListFlowExecutionMessagesResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    MetricsConfigurationTypeDef,
    PaginatorConfigTypeDef,
    ResponseMetadataTypeDef,
    SearchEntitiesRequestRequestTypeDef,
    SearchEntitiesResponseTypeDef,
    SearchFlowExecutionsRequestRequestTypeDef,
    SearchFlowExecutionsResponseTypeDef,
    SearchFlowTemplatesRequestRequestTypeDef,
    SearchFlowTemplatesResponseTypeDef,
    SearchSystemInstancesRequestRequestTypeDef,
    SearchSystemInstancesResponseTypeDef,
    SearchSystemTemplatesRequestRequestTypeDef,
    SearchSystemTemplatesResponseTypeDef,
    SearchThingsRequestRequestTypeDef,
    SearchThingsResponseTypeDef,
    SystemInstanceDescriptionTypeDef,
    SystemInstanceFilterTypeDef,
    SystemInstanceSummaryTypeDef,
    SystemTemplateDescriptionTypeDef,
    SystemTemplateFilterTypeDef,
    SystemTemplateSummaryTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    ThingTypeDef,
    UndeploySystemInstanceRequestRequestTypeDef,
    UndeploySystemInstanceResponseTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateFlowTemplateRequestRequestTypeDef,
    UpdateFlowTemplateResponseTypeDef,
    UpdateSystemTemplateRequestRequestTypeDef,
    UpdateSystemTemplateResponseTypeDef,
    UploadEntityDefinitionsRequestRequestTypeDef,
    UploadEntityDefinitionsResponseTypeDef,
)

def get_structure() -> AssociateEntityToThingRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-iotthingsgraph` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-iotthingsgraph docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_iotthingsgraph/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
