CREATE TABLE ir_configuration (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL
        CONSTRAINT ir_configuration_id_positive CHECK(id >= 0),
    series VARCHAR,
    language VARCHAR,
    hostname VARCHAR,
    PRIMARY KEY(id)
);

CREATE TABLE ir_model (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 3) NOT NULL
        CONSTRAINT ir_model_id_positive CHECK(id >= 0),
    name VARCHAR NOT NULL,
    string VARCHAR,
    info TEXT,
    module VARCHAR,
    PRIMARY KEY(id)
);

ALTER TABLE ir_model ADD CONSTRAINT ir_model_name_unique UNIQUE (name);

INSERT INTO ir_model (id, name, module) VALUES (1, 'res.user', 'res');
INSERT INTO ir_model (id, name, module) VALUES (2, 'res.group', 'res');

CREATE TABLE ir_model_field (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL
        CONSTRAINT ir_model_field_id_positive CHECK(id >= 0),
    model VARCHAR NOT NULL,
    name VARCHAR NOT NULL,
    relation VARCHAR,
    string VARCHAR,
    ttype VARCHAR,
    help TEXT,
    module VARCHAR,
    "access" BOOL,
    PRIMARY KEY(id),
    FOREIGN KEY (model) REFERENCES ir_model(name) ON DELETE CASCADE
);

ALTER TABLE ir_model_field ADD CONSTRAINT ir_model_field_name_model_uniq UNIQUE (name, model);

CREATE TABLE ir_model_data (
   id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 3) NOT NULL
        CONSTRAINT ir_model_id_positive CHECK(id >= 0),
    db_id INTEGER,
    fs_id VARCHAR,
    model VARCHAR NOT NULL,
    module VARCHAR NOT NULL,
    noupdate BOOL,
    fs_values TEXT,
    "values" TEXT,
    PRIMARY KEY(id),
    FOREIGN KEY (model) REFERENCES ir_model(name) ON DELETE CASCADE
);

INSERT INTO ir_model_data (id, db_id, fs_id, model, module, noupdate, fs_values, "values") VALUES (1, 1, 'user_admin', 'res.user', 'res', False, '[["login","admin"],["name","Administrator"]]', '[["login","admin"],["name","Administrator"]]');
INSERT INTO ir_model_data (id, db_id, fs_id, model, module, noupdate, fs_values, "values") VALUES (2, 1, 'group_admin', 'res.group', 'res', False, '[["name","Administrator"]]', '[["name","Administrator"]]');

CREATE TABLE ir_ui_view (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL
        CONSTRAINT ir_ui_view_id_positive CHECK(id >= 0),
    model VARCHAR,
    "type" VARCHAR,
    data TEXT,
    field_childs VARCHAR,
    priority INTEGER NOT NULL,
    PRIMARY KEY(id)
);

CREATE TABLE ir_ui_menu (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL
        CONSTRAINT ir_ui_menu_id_positive CHECK(id >= 0),
    parent INTEGER,
    name VARCHAR NOT NULL,
    icon VARCHAR,
    PRIMARY KEY (id),
    FOREIGN KEY (parent) REFERENCES ir_ui_menu (id) ON DELETE SET NULL
);

CREATE TABLE ir_translation (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL
        CONSTRAINT ir_translation_id_positive CHECK(id >= 0),
    lang VARCHAR,
    src TEXT,
    name VARCHAR NOT NULL,
    res_id INTEGER,
    value TEXT,
    "type" VARCHAR,
    module VARCHAR,
    fuzzy BOOLEAN NOT NULL,
    PRIMARY KEY(id)
);

CREATE TABLE ir_lang (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL
        CONSTRAINT ir_lang_id_positive CHECK(id >= 0),
    name VARCHAR NOT NULL,
    code VARCHAR NOT NULL,
    translatable BOOLEAN NOT NULL,
    parent VARCHAR,
    active BOOLEAN NOT NULL,
    direction VARCHAR NOT NULL,
    PRIMARY KEY(id)
);

CREATE TABLE res_user (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 2) NOT NULL
        CONSTRAINT res_user_id_positive CHECK(id >= 0),
    name VARCHAR,
    active BOOLEAN NOT NULL,
    login VARCHAR NOT NULL,
    password VARCHAR,
    PRIMARY KEY(id)
);

ALTER TABLE res_user ADD CONSTRAINT res_user_login_key UNIQUE (login);

INSERT INTO res_user (id, login, password, name, active) VALUES (0, 'root', NULL, 'Root', False);
INSERT INTO res_user (id, login, password, name, active) VALUES (1, 'admin', NULL, 'Administrator', True);

CREATE TABLE res_group (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY (START WITH 2) NOT NULL
        CONSTRAINT res_group_id_positive CHECK(id >= 0),
    name VARCHAR NOT NULL,
    PRIMARY KEY(id)
);

INSERT INTO res_group (id, name) VALUES (1, 'Administration');

CREATE TABLE "res_user-res_group" (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL
        CONSTRAINT "res_user-res_group_id_positive" CHECK(id >= 0),
    "user" INTEGER NOT NULL,
    "group" INTEGER NOT NULL,
    FOREIGN KEY ("user") REFERENCES res_user (id) ON DELETE CASCADE,
    FOREIGN KEY ("group") REFERENCES res_group (id) ON DELETE CASCADE,
    PRIMARY KEY(id)
);

CREATE TABLE ir_module (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL
        CONSTRAINT ir_module_id_positive CHECK(id >= 0),
    create_uid INTEGER,
    create_date TIMESTAMP WITHOUT TIME ZONE,
    write_date TIMESTAMP WITHOUT TIME ZONE,
    write_uid INTEGER,
    name VARCHAR NOT NULL,
    state VARCHAR,
    PRIMARY KEY(id),
    FOREIGN KEY (create_uid) REFERENCES res_user ON DELETE SET NULL,
    FOREIGN KEY (write_uid) REFERENCES res_user ON DELETE SET NULL
);

ALTER TABLE ir_module ADD CONSTRAINT ir_module_name_uniq UNIQUE (name);

CREATE TABLE ir_module_dependency (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL
        CONSTRAINT ir_module_dependency_id_positive CHECK(id >= 0),
    create_uid INTEGER,
    create_date TIMESTAMP WITHOUT TIME ZONE,
    write_date TIMESTAMP WITHOUT TIME ZONE,
    write_uid INTEGER,
    name VARCHAR,
    module INTEGER,
    PRIMARY KEY(id),
    FOREIGN KEY (create_uid) REFERENCES res_user ON DELETE SET NULL,
    FOREIGN KEY (write_uid) REFERENCES res_user ON DELETE SET NULL,
    FOREIGN KEY (module) REFERENCES ir_module ON DELETE CASCADE
);

CREATE TABLE ir_cache (
    id INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL
        CONSTRAINT ir_cache_id_positive CHECK(id >= 0),
    name VARCHAR NOT NULL,
    "timestamp" TIMESTAMP WITHOUT TIME ZONE,
    create_date TIMESTAMP WITHOUT TIME ZONE,
    create_uid INTEGER,
    write_date TIMESTAMP WITHOUT TIME ZONE,
    write_uid INTEGER
);
