class ArticleRelatedKeywords:
    SECTION_TITLE_WORDS = {
        "abstract": ["abstract"],
        "introduction": ["introduction"],
        "methods": [
            "method",
            "methods",
            "methodology",
            "technique",
            "procedure",
            "computational",
            "simulation",
            "modeling",
            "theoretical",
            "dft",
            "density functional theory",
            "experimental",
            "experiment",
            "experiments",
        ],
        "results_discussion": [
            "results",
            "result",
            "discussion",
            "discussions",
            "analysis",
        ],
        "conclusion": ["conclusion", "conclusions", "summary"],
    }

    @property
    def all_article_related_keywords(self):
        return [
            word
            for word_list in self.SECTION_TITLE_WORDS.values()
            for word in word_list
        ]

    def get_section_keywords(self, section_name):
        return self.SECTION_TITLE_WORDS.get(section_name, [])

    COMP_KEYWORDS = [
        "quantum espresso",
        "vasp",
        "siesta",
        "cp2k",
        "wien2k",
        "medea",
        "castep",
        "dmol3",
        "pbe",
        "lda",
        "gga",
        "hse06",
        "plane waves",
        "planewaves",
        "planewave",
        "plane wave",
        "pseudopotentials",
        "basis set",
        "brillouin zone",
        "k-point",
        "k-points",
        "gamma point",
        "reciprocal space",
        "real space",
        "periodic boundary conditions",
        "spin polarization",
        "hubbard u",
        "vdw-df",
        "scf cycles",
        "convergence criteria",
        "self consistent field",
        "elementercells",
        "energy above hull",
        "convex hull",
    ]

    SYNTHESIS_INCLUDE_KEYWORDS = [
        # Time-related keywords
        r"\b\d+\s*(h|hr|hrs|hour|hours)\b",
        r"\b\d+\s*(m|min|mins|minute|minutes)\b",
        r"\b\d+\s*(s|sec|secs|second|seconds)\b",
        # Verb keywords
        r"\bobtain\w*\b",
        r"\bobserve\w*\b",
        r"\bobservation\w*\b",
        r"\bpurchase\w*\b",
        r"\bgrow\w*\b",
        r"\bmix\w*\b",
        r"\bcombine\w*\b",
        r"\bstir\w*\b",
        r"\bhot plate\w*\b",
        r"\bsynthesize\w*\b",
        r"\bsynthesis\w*\b",
        r"\bpress\w*\b",
        r"\bsinter\w*\b",
        r"\breact\w*\b",
        r"\bload\w*\b",
        r"\bunload\w*\b",
        r"\bcool\w*\b",
        r"\bfix\w*\b",
        r"\bcollect\w*\b",
        r"\brefine\w*\b",
        r"\breduce\w*\b",
        r"\breduction\b",
        r"\boxid\w*\b",
        r"\bsolve\w*\b",
        r"\bsolution\w*\b",
        r"\bsolvation\w*\b",
        r"\brecord\w*\b",
        r"\bmeasure\w*\b",
        r"\bpaste\w*\b",
        r"\bcoat\w*\b",
        r"\bdry\w*\b",
        r"\bdried\b",
        r"\bweigh\w*\b",
        r"\bheat\w*\b",
        r"\bremove\w*\b",
        r"\bremoval\w*\b",
        r"\badd\w*\b",
        r"\bplace\w*\b",
        r"\bdeposit\w*\b",
        r"\btransfer\w*\b",
        r"\bfilter\w*\b",
        r"\bfiltration\w*\b",
        r"\bwash\w*\b",
        r"\bstore\w*\b",
        r"\bstorage\w*\b",
        r"\bstored\b",
        r"\bstoring\w*\b",
        r"\bstock\w*\b",
        r"\bseal\w*\b",
        r"\bseparate\w*\b",
        r"\bseparation\w*\b",
        r"\bprepare\w*\b",
        r"\bpreparation\w*\b",
        r"\bpoling\w*\b",
        r"\bpolish\w*\b",
        r"\bmill\w*\b",
        r"\bcz method\w*\b",
        r"\bczochralski\w*\b",
        r"\bhydraulic\w*\b",
        r"\bpellet\w*\b",
        r"\bcalcination\w*\b",
        r"\bcalcine\w*\b",
        r"\bcrush\w*\b",
        r"\bgrind\w*\b",
        r"\bspeed\w*\b",
        r"\bdwell\w*\b",
        r"\bdisperse\w*\b",
        r"\bcentrifug\w*\b",
        r"\bfreeze\w*\b",
        r"\bfreeze-dry\w*\b",
        r"\bcontinuous\w*\b",
        r"\bdeioni\w*\b",
        r"\bdistill\w*\b",
        r"\banneal\w*\b",
        r"\bquench\w*\b",
        r"\breflux\w*\b",
        r"\bdesignate\w*\b",
        r"\btransform\w*\b",
        r"\benhance\w*\b",
        r"\bsieve\w*\b",
        r"\brotat\w*\b",
        # Technique-related keywords
        r"\bmesh\w*\b",
        r"\bsol-gel\w*\b" r"\bsolgel\w*\b",
        r"\bsolid-state\w*\b",
        r"\bsolid state\w*\b",
        r"\bhydrolysis\w*\b",
        r"\bhydrothermal\w*\b",
        r"\bultrasound\w*\b",
        r"\bmicrowave\w*\b",
        r"\bsonochemical\w*\b",
        r"\bbridgman\w*\b",
        r"\bbridgman-stockbarger\w*\b",
        r"\brate\w*\b",
        r"\bballpark\w*\b",
        r"\bball mill\w*\b",
        r"\bball-mill\w*\b",
        r"\bovernight\w*\b",
        r"\bthin-film\w*\b",
        # Equipment-related keywords
        r"\boven\w*\b",
        r"\bfurnace\w*\b",
        r"\btube furnace\w*\b",
        r"\bbox furnace\w*\b",
        r"\bheater\w*\b",
        r"\breactor\w*\b",
        r"\bautoclave\w*\b",
        r"\bchamber\w*\b",
        r"\bcrucible\w*\b",
        r"\bmortar\w*\b",
        r"\bpestle\w*\b",
        r"\bgrinder\w*\b",
        r"\bholder\w*\b",
        r"\bpvd\w*\b",
        r"\bphysical vapour deposition\w*\b",
        r"\bphysical vapor deposition\w*\b",
        r"\bcvd\w*\b",
        r"\bchemical vapour deposition\w*\b",
        r"\bchemical vapor deposition\w*\b",
        r"\bald\w*\b",
        r"\batomic layer deposition\w*\b",
        r"\bpld\w*\b",
        r"\bpulsed laser deposition\w*\b",
        # Sign/number-related keywords
        r"%",
        r"\d+(\.\d+)?",  # Any number
        r"\d+(\.\d+)?\s*%",  # Any number followed by a percentage sign
    ]

    SYNTHESIS_EXCLUDE_KEYWORDS = [
        # Instrument-related keywords
        r"\bp-e loop\b",
        r"\bpe loop\b",
        r"\bxrd\b",
        r"\bx-ray diffraction\b",
        r"\bx-ray diffractometer\b",
        r"\bftir\b",
        r"\bft-ir\b",
        r"\bfourier transform infrared\b",
        r"\bsem\b",
        r"\bscanning electron microscopy\b",
        r"\bfe-sem\b",
        r"\bfield-emission scanning electron microscopy\b",
        r"\btem\b",
        r"\btransmission electron microscopy\b",
        r"\bhrtem\b",
        r"\bhr-tem\b",
        r"\bhigh resolution transmission electron\b",
        r"\bhigh-resolution transmission electron\b",
        r"\bhigh-res transmission electron\b",
        r"\bspectrometer\b",
        r"\bspectrophotometer\b",
        r"\bspectra\b",
        r"\bspectroscopy\b",
        r"\bxenon lamp\b",
        r"\bpotentiostat\b",
        r"\bimpedance\b",
        r"\bx-ray photoelectron spectroscopy\b",
        r"\bxps\b",
        r"\bups\b",
        r"\bultraviolet photoelectron spectroscopy\b",
        r"\buv-vis\b",
        r"\buv-vis-nir\b",
        r"\belectrochemical impedance spectroscopy\b",
        r"\beis\b",
        r"\bxes\b",
        r"\bthermogravimetric analysis\b",
        r"\bdsc\b",
        r"\bdifferential scanning calori\b",
        r"\bdta\b",
        r"\bdifferential thermal analysis\b",
        r"\bdma\b",
        r"\bdynamic mechanical analysis\b",
        r"\btensile\b",
        r"\bellipsometry\b",
        r"\btga\b",
        r"\bthermogravimetric\b",
        r"\bthermogravimetry\b",
        r"\bmott-schottky\b",  # p-n junction measurement
        r"\brelative permittivity\b",
        r"\bdielectric constant\b",
        r"\bfrequency\b",
        # Verb keywords
        r"\bmeasure\w*\b",
        r"\bcharacterize\w*\b",
        r"\bcharacterization\w*\b",
        r"\bcharacterise\w*\b",
        r"\bcharacterisation\w*\b",
        r"\bidentify\w*\b",
        r"\banalyz\w*\b",
        r"\bevaluat\w*\b",
        # Technique-related keywords
        r"\bquantum efficiency\w*\b",
        r"\bqe\b",
        r"\bapparent quantum efficiency\w*\b",
        r"\baqe\b",
    ]
