# Advanced Configuration

When your API grows, you might need tools for shaping traffic, offloading
storage and refining responses. Beyond the basics, **flarchitect** offers
several options for these scenarios. The following sections walk through
common patterns such as rate limiting, cache configuration and response
metadata.

## Sections

- [Initialising with optional features](initialising-with-optional-features.md)
- [Full auto mode](full-auto-mode.md)
- [Rate limiting](rate-limiting.md)
- [Caching backends](caching-backends.md)
- [Response metadata](response-metadata.md)
- [Nested model creation](nested-model-creation.md)
- [Soft delete](soft-delete.md)
- [CORS](cors.md)
- [Query parameter controls](query-parameter-controls.md)
- [Cascade deletes](cascade-deletes.md)
- [Case conventions](case-conventions.md)
- [Extensions, validators and hooks](extensions-validators-and-hooks.md)
