# flarchitect

> flarchitect automates RESTful APIs from SQLAlchemy models, exposing configuration-rich tooling, authentication helpers, and documentation assets. It ships with an MCP server and composable hooks for plugins, callbacks, and schema orchestration.

<!-- Generated by tools/convert_docs.py; do not edit manually. -->

## Getting Started

- [Advanced Demo](https://lewis-morris.github.io/flarchitect/advanced_demo/index.md): This annotated example combines soft deletes, nested writes and custom callbacks.
- [Getting Started Sample Project](https://lewis-morris.github.io/flarchitect/getting_started/index.md): Flarchitect ships with a tiny demo that shows how it turns a SQLAlchemy model into a REST API.
- [Installation](https://lewis-morris.github.io/flarchitect/installation/index.md): Installation covers Prerequisites, Set up a virtual environment, Install Flarchitect.
- [Quick Start](https://lewis-morris.github.io/flarchitect/quickstart/index.md): This guide walks you through building a minimal API with **flarchitect**.
- [Configure Flask](https://lewis-morris.github.io/flarchitect/quickstart/configure-flask.md): Register the extension with a Flask app and supply configuration values.
- [Define your models](https://lewis-morris.github.io/flarchitect/quickstart/define-your-models.md): Define your models using SQLAlchemy.
- [From Model to API](https://lewis-morris.github.io/flarchitect/quickstart/from-model-to-api.md): Reference material.
- [Install Flarchitect](https://lewis-morris.github.io/flarchitect/installation/install-flarchitect.md): Reference material.
- [Installation](https://lewis-morris.github.io/flarchitect/quickstart/installation.md): Install the package via pip.
- [Key points](https://lewis-morris.github.io/flarchitect/advanced_demo/key-points.md): Reference material.
- [Next steps](https://lewis-morris.github.io/flarchitect/quickstart/next-steps.md): To secure the API and define user roles, see authentication and the.
- [Prerequisites](https://lewis-morris.github.io/flarchitect/installation/prerequisites.md): Reference material.
- [Run the demo](https://lewis-morris.github.io/flarchitect/advanced_demo/run-the-demo.md): For authentication strategies and role management, see authentication.
- [Run the demo](https://lewis-morris.github.io/flarchitect/getting_started/run-the-demo.md): The curl command answers with a JSON payload that includes some metadata and a `value` list of authors.
- [Set up a virtual environment](https://lewis-morris.github.io/flarchitect/installation/set-up-a-virtual-environment.md): Reference material.
- [Spin up the app](https://lewis-morris.github.io/flarchitect/quickstart/spin-up-the-app.md): Run the development server to expose the generated routes.
- [Test the endpoints](https://lewis-morris.github.io/flarchitect/quickstart/test-the-endpoints.md): Use `curl` to call an endpoint and view the response.
- [Verify the installation](https://lewis-morris.github.io/flarchitect/installation/verify-the-installation.md): This quick check ensures Flarchitect is ready to use.

## Security

- [Auth Cookbook](https://lewis-morris.github.io/flarchitect/auth_cookbook/index.md): This cookbook collects practical authentication patterns for flarchitect.
- [Authentication](https://lewis-morris.github.io/flarchitect/authentication/index.md): flarchitect provides several helpers to secure your API quickly.
- [Access policies](https://lewis-morris.github.io/flarchitect/authentication/access-policies.md): Attach `API_ACCESS_POLICY` to enforce row-level permissions.
- [API key authentication](https://lewis-morris.github.io/flarchitect/authentication/api-key-authentication.md): API key auth associates a user with a single token.
- [API key strategies](https://lewis-morris.github.io/flarchitect/auth_cookbook/api-key-strategies.md): Clients send `Authorization: Api-Key <token>`.
- [Auth requirements](https://lewis-morris.github.io/flarchitect/authentication/auth-requirements.md): Set `API_AUTH_REQUIREMENTS` to enable or disable authentication per HTTP.
- [Basic authentication](https://lewis-morris.github.io/flarchitect/auth_cookbook/basic-authentication.md): Send `Authorization: Basic <base64(username:password)>`.
- [Basic authentication](https://lewis-morris.github.io/flarchitect/authentication/basic-authentication.md): HTTP Basic Auth is the most straightforward option.
- [Config-driven roles](https://lewis-morris.github.io/flarchitect/authentication/config-driven-roles.md): You can assign roles to endpoints without decorating functions by setting a.
- [Contents](https://lewis-morris.github.io/flarchitect/auth_cookbook/contents.md): Reference material.
- [Cookie helpers](https://lewis-morris.github.io/flarchitect/authentication/cookie-helpers.md): token and calls `set_current_user`.
- [Custom authentication](https://lewis-morris.github.io/flarchitect/authentication/custom-authentication.md): For complete control supply your own callable.
- [Error responses](https://lewis-morris.github.io/flarchitect/authentication/error-responses.md): Authentication failures are serialised with create_response, so each.
- [Further reading](https://lewis-morris.github.io/flarchitect/auth_cookbook/further-reading.md): Reference material.
- [JWT authentication](https://lewis-morris.github.io/flarchitect/authentication/jwt-authentication.md): JSON Web Tokens (JWT) allow a client to prove their identity by including a.
- [JWT patterns](https://lewis-morris.github.io/flarchitect/auth_cookbook/jwt-patterns.md): leading `"Bearer "` prefix is tolerated and removed), then rotates the.
- [Multi‑tenant considerations](https://lewis-morris.github.io/flarchitect/auth_cookbook/multi-tenant-considerations.md): via a session/mapper event so all generated endpoints auto‑scope results.
- [Role mapping examples](https://lewis-morris.github.io/flarchitect/auth_cookbook/role-mapping-examples.md): See roles-required and the reference authentication for details.
- [Role-based access](https://lewis-morris.github.io/flarchitect/authentication/role-based-access.md): Use the `require_roles` decorator to restrict access based on user roles.
- [Token providers](https://lewis-morris.github.io/flarchitect/authentication/token-providers.md): Configure `API_AUTH_TOKEN_PROVIDERS` to control how JWTs are discovered.
- [Troubleshooting](https://lewis-morris.github.io/flarchitect/authentication/troubleshooting.md): Reference material.

## Configuration

- [ Configuration Table](https://lewis-morris.github.io/flarchitect/_configuration_table/index.md): Configuration Table covers Core Settings, Optional Settings.
- [Advanced Configuration](https://lewis-morris.github.io/flarchitect/advanced_configuration/index.md): When your API grows, you might need tools for shaping traffic, offloading.
- [Configuration](https://lewis-morris.github.io/flarchitect/configuration/index.md): Configuration covers Intro, Config Hierarchy, Config Value Structure.
- [Caching backends](https://lewis-morris.github.io/flarchitect/advanced_configuration/caching-backends.md): Memcached) may be used.
- [Cascade delete settings](https://lewis-morris.github.io/flarchitect/configuration/cascade-delete-settings.md): See cascade-deletes in the advanced configuration guide for usage examples of.
- [Cascade deletes](https://lewis-morris.github.io/flarchitect/advanced_configuration/cascade-deletes.md): When removing a record, related rows may block the operation.
- [Case conventions](https://lewis-morris.github.io/flarchitect/advanced_configuration/case-conventions.md): case conventions.
- [Complete Configuration Reference](https://lewis-morris.github.io/flarchitect/configuration/complete-configuration-reference.md): Reference material.
- [Config Hierarchy](https://lewis-morris.github.io/flarchitect/configuration/config-hierarchy.md): (for example `API_TITLE`).
- [Config Value Structure](https://lewis-morris.github.io/flarchitect/configuration/config-value-structure.md): Every configuration value has a specific structure that defines where it can be used and how it should be written.
- [Core configuration](https://lewis-morris.github.io/flarchitect/configuration/core-configuration.md): Some settings are essential for initialising the extension and controlling its.
- [Core Settings](https://lewis-morris.github.io/flarchitect/_configuration_table/core-settings.md): Essential configuration values needed to run `flarchitect` and control automatic route generation.
- [Core Settings](https://lewis-morris.github.io/flarchitect/configuration/core-settings.md): Essential configuration values needed to run `flarchitect` and control automatic route generation.
- [CORS](https://lewis-morris.github.io/flarchitect/advanced_configuration/cors.md): To enable Cross-Origin Resource Sharing (CORS) <[https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS](https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS)>.
- [Extensions, validators and hooks](https://lewis-morris.github.io/flarchitect/advanced_configuration/extensions-validators-and-hooks.md): configuration files.
- [Full auto mode](https://lewis-morris.github.io/flarchitect/advanced_configuration/full-auto-mode.md): startup and registers CRUD routes for each one.
- [Initialising with optional features](https://lewis-morris.github.io/flarchitect/advanced_configuration/initialising-with-optional-features.md): behaviour like caching, CORS handling and automatic documentation.
- [Intro](https://lewis-morris.github.io/flarchitect/configuration/intro.md): In flarchitect, configuration options are essential for customising the API and its accompanying documentation.
- [Nested model creation](https://lewis-morris.github.io/flarchitect/advanced_configuration/nested-model-creation.md): Nested writes are disabled by default.
- [Optional Settings](https://lewis-morris.github.io/flarchitect/_configuration_table/optional-settings.md): Reference material.
- [Optional Settings](https://lewis-morris.github.io/flarchitect/configuration/optional-settings.md): Reference material.
- [Query parameter controls](https://lewis-morris.github.io/flarchitect/advanced_configuration/query-parameter-controls.md): responses.
- [Rate limiting](https://lewis-morris.github.io/flarchitect/advanced_configuration/rate-limiting.md): Rate limits can be applied globally, per HTTP method or per model.
- [Response metadata](https://lewis-morris.github.io/flarchitect/advanced_configuration/response-metadata.md): keys let you toggle each field individually.
- [Soft delete](https://lewis-morris.github.io/flarchitect/advanced_configuration/soft-delete.md): database.

## Guides

- [Caching](https://lewis-morris.github.io/flarchitect/caching/index.md): Speed up repeated requests by caching GET responses.
- [Config by Method Models](https://lewis-morris.github.io/flarchitect/model_method/index.md): Model Method.
- [Config Globals](https://lewis-morris.github.io/flarchitect/global_/index.md): Global.
- [Config Models](https://lewis-morris.github.io/flarchitect/model/index.md): Model.
- [Custom Serialisation](https://lewis-morris.github.io/flarchitect/custom_serialization/index.md): flarchitect controls how relationships are represented in responses through a.
- [Error Handling](https://lewis-morris.github.io/flarchitect/error_handling/index.md): flarchitect standardises error reporting through a small set of helpers.
- [Extensions](https://lewis-morris.github.io/flarchitect/extensions/index.md): Callbacks let you hook into the request lifecycle to run custom logic around.
- [Feature Overview](https://lewis-morris.github.io/flarchitect/feature_overview/index.md): grouping/aggregation, pagination and response metadata.
- [Filtering](https://lewis-morris.github.io/flarchitect/filtering/index.md): explains how to enable/disable filtering, the syntax for predicates, how to.
- [flarchitect](https://lewis-morris.github.io/flarchitect/index/index.md): ![Coverage Report](/_static/coverage.svg).
- [Grouping & Aggregation](https://lewis-morris.github.io/flarchitect/grouping/index.md): functions when explicitly enabled.
- [Hooks & Plugins Cheatsheet](https://lewis-morris.github.io/flarchitect/hooks_cheatsheet/index.md): Quick reference for callbacks and plugin hooks: when they run, what they.
- [Joining Related Resources](https://lewis-morris.github.io/flarchitect/joining/index.md): relationships by joining tables at query time.
- [Manual Routes](https://lewis-morris.github.io/flarchitect/manual_routes/index.md): flarchitect can wrap your own Flask view functions with the same machinery it.
- [Plugins](https://lewis-morris.github.io/flarchitect/plugins/index.md): flarchitect supports a lightweight plugin system for observing and customising.
- [Rate Limiting](https://lewis-morris.github.io/flarchitect/rate_limiting/index.md): Protect your API from abuse and manage throughput with flexible rate limits.
- [Response Metadata](https://lewis-morris.github.io/flarchitect/response_metadata/index.md): flarchitect can attach metadata to each response.
- [SQLAlchemy Models](https://lewis-morris.github.io/flarchitect/models/index.md): That's all that's required to make the model available through the generated API.
- [Troubleshooting](https://lewis-morris.github.io/flarchitect/troubleshooting/index.md): Troubleshooting covers Joins don’t work, Nested objects don’t appear, Pagination counts look wrong with joins.
- [Validation](https://lewis-morris.github.io/flarchitect/validation/index.md): flarchitect ships with a suite of field validators that hook directly into.
- [WebSockets](https://lewis-morris.github.io/flarchitect/websockets/index.md): WebSockets covers Overview, Enable The Endpoint, Subscription Model.
- [Acceptable formats](https://lewis-morris.github.io/flarchitect/extensions/acceptable-formats.md): For comprehensive configuration details see configuration.
- [Acceptable types](https://lewis-morris.github.io/flarchitect/extensions/acceptable-types.md): Reference material.
- [Additional helpers](https://lewis-morris.github.io/flarchitect/manual_routes/additional-helpers.md): If you only need to protect a manual route with JWT and don’t require schema.
- [Advanced Configuration](https://lewis-morris.github.io/flarchitect/index/advanced-configuration.md): Need finer control? The Advanced Configuration <advanced_configuration> guide covers features like rate limiting, CORS, and custom cache backends.
- [Aggregate functions](https://lewis-morris.github.io/flarchitect/grouping/aggregate-functions.md): (`table.column`) when grouping across joins.
- [Available validators](https://lewis-morris.github.io/flarchitect/validation/available-validators.md): Reference material.
- [Backends](https://lewis-morris.github.io/flarchitect/caching/backends.md): Timeout is controlled by API_CACHE_TIMEOUT <configuration.html#CACHE_TIMEOUT>.
- [Basic syntax](https://lewis-morris.github.io/flarchitect/filtering/basic-syntax.md): Use the pattern `<field>__<operator>=<value>`.
- [Basic usage](https://lewis-morris.github.io/flarchitect/manual_routes/basic-usage.md): Reference material.
- [Basic usage](https://lewis-morris.github.io/flarchitect/validation/basic-usage.md): Reference material.
- [Callback quick reference](https://lewis-morris.github.io/flarchitect/hooks_cheatsheet/callback-quick-reference.md): Reference material.
- [Callback signatures](https://lewis-morris.github.io/flarchitect/extensions/callback-signatures.md): Setup‑style callbacks receive `model` and a set of keyword arguments.
- [Callback types](https://lewis-morris.github.io/flarchitect/extensions/callback-types.md): flarchitect recognises a number of callback hooks that allow you to run custom.
- [Choosing SQL join semantics](https://lewis-morris.github.io/flarchitect/joining/choosing-sql-join-semantics.md): Use `join_type` to control the SQL join operator applied to each related.
- [Client Example](https://lewis-morris.github.io/flarchitect/websockets/client-example.md): Reference material.
- [Combining with joins and filters](https://lewis-morris.github.io/flarchitect/grouping/combining-with-joins-and-filters.md): Grouping and aggregation work with joins, filters, `fields` selection and.
- [Common keys](https://lewis-morris.github.io/flarchitect/response_metadata/common-keys.md): Key | Default | Effect |.
- [Common status codes](https://lewis-morris.github.io/flarchitect/error_handling/common-status-codes.md): Reference material.
- [Configuration](https://lewis-morris.github.io/flarchitect/extensions/configuration.md): Callbacks are referenced by the following configuration keys (global variants.
- [Configuration](https://lewis-morris.github.io/flarchitect/rate_limiting/configuration.md): Reference material.
- [CustomHTTPException](https://lewis-morris.github.io/flarchitect/error_handling/customhttpexception.md): optional reason.
- [Depth and relation inclusion](https://lewis-morris.github.io/flarchitect/custom_serialization/depth-and-relation-inclusion.md): included at all.
- [Documentation metadata](https://lewis-morris.github.io/flarchitect/manual_routes/documentation-metadata.md): Reference material.
- [Dump types](https://lewis-morris.github.io/flarchitect/models/dump-types.md): by API_SERIALIZATION_TYPE <configuration.html#SERIALIZATION_TYPE> or `Meta.serialization_type`.
- [Enable joins](https://lewis-morris.github.io/flarchitect/joining/enable-joins.md): Reference material.
- [Enable or disable filtering](https://lewis-morris.github.io/flarchitect/filtering/enable-or-disable-filtering.md): Filtering is enabled by default.
- [Enable support](https://lewis-morris.github.io/flarchitect/grouping/enable-support.md): Both flags can be applied globally on the Flask config (`API_` prefix) or.
- [Enable The Endpoint](https://lewis-morris.github.io/flarchitect/websockets/enable-the-endpoint.md): pip install flask-sock.
- [Example](https://lewis-morris.github.io/flarchitect/caching/example.md): Reference material.
- [Example](https://lewis-morris.github.io/flarchitect/global_/example.md): Reference material.
- [Example](https://lewis-morris.github.io/flarchitect/model/example.md): Reference material.
- [Example](https://lewis-morris.github.io/flarchitect/model_method/example.md): Reference material.
- [Examples](https://lewis-morris.github.io/flarchitect/filtering/examples.md): Reference material.
- [Expected output (example)](https://lewis-morris.github.io/flarchitect/joining/expected-output-example.md): With `dump=dynamic` and `join=invoice-lines,payments,customer` you can.
- [Extending query parameters](https://lewis-morris.github.io/flarchitect/extensions/extending-query-parameters.md): Use ADDITIONAL_QUERY_PARAMS <configuration.html#ADDITIONAL_QUERY_PARAMS> to document extra query parameters introduced in.
- [Field validation](https://lewis-morris.github.io/flarchitect/validation/field-validation.md): attribute on SQLAlchemy columns to determine which validators to apply.
- [Filtering across joins](https://lewis-morris.github.io/flarchitect/filtering/filtering-across-joins.md): When you join related models, you can qualify a filter with the table name using.
- [Group results](https://lewis-morris.github.io/flarchitect/grouping/group-results.md): Once `API_ALLOW_GROUPBY` is active, clients can pass a comma-separated.
- [handle_http_exception](https://lewis-morris.github.io/flarchitect/error_handling/handle-http-exception.md): Register `handle_http_exception` as the Flask error handler for.
- [Hook reference](https://lewis-morris.github.io/flarchitect/plugins/hook-reference.md): Called at the beginning of each request.
- [How It Works](https://lewis-morris.github.io/flarchitect/websockets/how-it-works.md): subscribers and broadcasts events.
- [Input and output schemas](https://lewis-morris.github.io/flarchitect/manual_routes/input-and-output-schemas.md): You can validate request bodies and serialise responses with Marshmallow.
- [Joins don’t work](https://lewis-morris.github.io/flarchitect/troubleshooting/joins-don-t-work.md): (singular), kebab‑ or snake‑case; tokens are normalised and singular/plural.
- [Lifecycle at a glance](https://lewis-morris.github.io/flarchitect/hooks_cheatsheet/lifecycle-at-a-glance.md): Reference material.
- [llms.txt Manifest](https://lewis-morris.github.io/flarchitect/llms.md): Canonical llms.txt manifest for the flarchitect documentation set.
- [Message Format](https://lewis-morris.github.io/flarchitect/websockets/message-format.md): callbacks and serialisation.
- [Nested objects don’t appear](https://lewis-morris.github.io/flarchitect/troubleshooting/nested-objects-don-t-appear.md): Reference material.
- [Nested relationship dumping](https://lewis-morris.github.io/flarchitect/models/nested-relationship-dumping.md): API_ADD_RELATIONS <configuration.html#ADD_RELATIONS> controls whether relationship fields are included in the.
- [Normalised join tokens](https://lewis-morris.github.io/flarchitect/joining/normalised-join-tokens.md): The `join` query parameter accepts a comma‑separated list of relationship.
- [Notes](https://lewis-morris.github.io/flarchitect/plugins/notes.md): value wins (e.g., response replacement).
- [Notes & Limitations](https://lewis-morris.github.io/flarchitect/websockets/notes-limitations.md): development or single‑process servers.
- [OR conditions](https://lewis-morris.github.io/flarchitect/filtering/or-conditions.md): To express OR logic, wrap a comma‑separated list of full conditions inside a.
- [Overview](https://lewis-morris.github.io/flarchitect/websockets/overview.md): flarchitect ships with a lightweight, optional WebSocket integration intended.
- [Pagination counts look wrong with joins](https://lewis-morris.github.io/flarchitect/troubleshooting/pagination-counts-look-wrong-with-joins.md): join rows.
- [Pagination with joins](https://lewis-morris.github.io/flarchitect/joining/pagination-with-joins.md): Joining one‑to‑many relationships multiplies result rows at the SQL level.
- [Performance tips](https://lewis-morris.github.io/flarchitect/troubleshooting/performance-tips.md): Reference material.
- [Per‑request override](https://lewis-morris.github.io/flarchitect/custom_serialization/per-request-override.md): Clients can override the mode with a `dump` query parameter.
- [Plugin hooks](https://lewis-morris.github.io/flarchitect/extensions/plugin-hooks.md): Plugins provide a structured way to observe and influence behaviour across the.
- [Plugin hooks quick reference](https://lewis-morris.github.io/flarchitect/hooks_cheatsheet/plugin-hooks-quick-reference.md): Reference material.
- [Quick start](https://lewis-morris.github.io/flarchitect/plugins/quick-start.md): Reference material.
- [Request lifecycle and hook order](https://lewis-morris.github.io/flarchitect/extensions/request-lifecycle-and-hook-order.md): This is the high‑level order in which flarchitect processes a request and where.
- [Roles and authentication](https://lewis-morris.github.io/flarchitect/manual_routes/roles-and-authentication.md): If your application uses role‑based access control, supply `roles` to require.
- [Route handler signature](https://lewis-morris.github.io/flarchitect/manual_routes/route-handler-signature.md): Decorated handlers may optionally accept `deserialized_data` to receive the.
- [Serialisation and joins](https://lewis-morris.github.io/flarchitect/joining/serialisation-and-joins.md): Joining models does not by itself inline related objects.
- [Serialisation modes](https://lewis-morris.github.io/flarchitect/custom_serialization/serialisation-modes.md): all others remain URLs.
- [Spec documentation](https://lewis-morris.github.io/flarchitect/grouping/spec-documentation.md): When either flag is enabled `flarchitect` adds explanatory cards to the.
- [Storage backends](https://lewis-morris.github.io/flarchitect/rate_limiting/storage-backends.md): If none is provided, an in‑memory fallback is used (suitable for development.
- [Subscription Model](https://lewis-morris.github.io/flarchitect/websockets/subscription-model.md): Subscribe to a topic by connecting to the endpoint with an optional `topic`.
- [Supported operators](https://lewis-morris.github.io/flarchitect/filtering/supported-operators.md): The following operators are available.
- [Tips and combinations](https://lewis-morris.github.io/flarchitect/filtering/tips-and-combinations.md): sorting (`order_by`), pagination (`page`/`limit`), and dynamic nesting.
- [Using _handle_exception](https://lewis-morris.github.io/flarchitect/error_handling/using-handle-exception.md): For ad-hoc exception handling you can call `_handle_exception` directly.
- [Validation and errors](https://lewis-morris.github.io/flarchitect/joining/validation-and-errors.md): Join support is opt‑in.

## Developer Tooling

- [API Documentation](https://lewis-morris.github.io/flarchitect/openapi/index.md): flarchitect automatically generates an OpenAPI 3.0.2 document for every.
- [MCP Documentation Server](https://lewis-morris.github.io/flarchitect/mcp_server/index.md): The Model Context Protocol (MCP) server bundled with *flarchitect* exposes the project's documentation so tools and agents can query, search, and cite it without bespoke glue code.
- [GraphQL](https://lewis-morris.github.io/flarchitect/graphql/index.md): flarchitect can expose SQLAlchemy models through a GraphQL API.
- [llms.txt Manifest](https://lewis-morris.github.io/flarchitect/llms/index.md): The project ships an `llms.txt` manifest alongside the generated Markdown.
- [Accessing the spec](https://lewis-morris.github.io/flarchitect/openapi/accessing-the-spec.md): The canonical JSON schema is served under the docs path at `/docs/apispec.json`.
- [Advanced usage](https://lewis-morris.github.io/flarchitect/graphql/advanced-usage.md): and adds fields returning the related object types.
- [Automatic generation](https://lewis-morris.github.io/flarchitect/openapi/automatic-generation.md): When API_CREATE_DOCS <configuration.html#CREATE_DOCS> is enabled (it is `True` by default) the.
- [Configuration Reference](https://lewis-morris.github.io/flarchitect/mcp_server/configuration-reference.md): **`--project-root`**.
- [Customising the document](https://lewis-morris.github.io/flarchitect/openapi/customising-the-document.md): the docs page.
- [Documentation style](https://lewis-morris.github.io/flarchitect/openapi/documentation-style.md): By default, flarchitect renders docs with Redoc.
- [Error responses in the spec](https://lewis-morris.github.io/flarchitect/openapi/error-responses-in-the-spec.md): flarchitect includes common error responses in each operation based on your.
- [Exporting to a file](https://lewis-morris.github.io/flarchitect/openapi/exporting-to-a-file.md): Reference material.
- [Grouping and aggregation cards](https://lewis-morris.github.io/flarchitect/openapi/grouping-and-aggregation-cards.md): When API_ALLOW_GROUPBY <configuration.html#ALLOW_GROUPBY> or.
- [Integration Tips](https://lewis-morris.github.io/flarchitect/mcp_server/integration-tips.md): Reference material.
- [Quick start](https://lewis-morris.github.io/flarchitect/graphql/quick-start.md): The simplest way to enable GraphQL is to feed your models to.
- [Quick Start](https://lewis-morris.github.io/flarchitect/mcp_server/quick-start.md): 3.
- [Security scheme](https://lewis-morris.github.io/flarchitect/openapi/security-scheme.md): flarchitect defines a `bearerAuth` security scheme using HTTP bearer tokens.
- [Testing Strategy](https://lewis-morris.github.io/flarchitect/mcp_server/testing-strategy.md): Unit tests cover the `DocumentIndex` search/section helpers and the backend selection logic (including a stubbed `fastmcp` runtime).
- [Tips and trade-offs](https://lewis-morris.github.io/flarchitect/graphql/tips-and-trade-offs.md): GraphQL offers flexible queries and reduces the number of HTTP round-trips, but.
- [Type mapping](https://lewis-morris.github.io/flarchitect/graphql/type-mapping.md): scalars using flarchitect.graphql.SQLA_TYPE_MAPPING.
- [What the Server Provides](https://lewis-morris.github.io/flarchitect/mcp_server/what-the-server-provides.md): **Resources**.

## Optional

- [FAQ](https://lewis-morris.github.io/flarchitect/faq/index.md): By default URL endpoints are `pluralised kebab-case`, resources are `camelCase` and resource fields are.
- [Roadmap](https://lewis-morris.github.io/flarchitect/roadmap/index.md): Reference material.
- [Troubleshooting](https://lewis-morris.github.io/flarchitect/faq/troubleshooting.md): Ensure API_CREATE_DOCS <configuration.html#CREATE_DOCS> is set to `True` and that the.
