# This file is part of Elide, frontend to Lisien, a framework for life simulation games.
# Copyright (c) Zachary Spector, public@zacharyspector.com
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
from lisien.facade import EngineFacade

CHARACTER_UPDATES = [
	("empty", {}, {}, [], [], [], []),
	(
		"small",
		{0: [1], 1: [0], "kobold": []},
		{
			"spam": "eggs",
			"ham": {"baked beans": "delicious"},
			"qux": ["quux", "quuux"],
			"clothes": {"hats", "shirts", "pants"},
		},
		[
			("kobold", {"location": 0, "evil": True}),
			(0, {"evil": False}),
			(1, {"evil": False}),
		],
		[("spam", ...), ("qux", ["quux"]), ("clothes", "no")],
		[(2, {"evil": False}), ("kobold", {"evil": False})],
		[(0, 1, ...), (0, 2, {"hi": "hello"})],
	),
]

PHYSICAL_INITIAL_COPY = {
	"node_val": {
		"common0": {"rulebook": ("physical", "common0")},
		"dorm1room3": {"rulebook": ("physical", "dorm1room3")},
		"dorm1room4student1": {
			"rulebook": ("physical", "dorm1room4student1"),
			"location": "dorm1room4",
		},
		"dorm2room4student0": {
			"rulebook": ("physical", "dorm2room4student0"),
			"location": "dorm2room4",
		},
		"classroom": {"rulebook": ("physical", "classroom")},
		"dorm0room5student1": {
			"rulebook": ("physical", "dorm0room5student1"),
			"location": "dorm0room5",
		},
		"dorm2room3student1": {
			"rulebook": ("physical", "dorm2room3student1"),
			"location": "dorm2room3",
		},
		"dorm0room3student0": {
			"rulebook": ("physical", "dorm0room3student0"),
			"location": "dorm0room3",
		},
		"dorm0room2student0": {
			"rulebook": ("physical", "dorm0room2student0"),
			"location": "dorm0room2",
		},
		"dorm2room1student0": {
			"rulebook": ("physical", "dorm2room1student0"),
			"location": "dorm2room1",
		},
		"dorm1room4student0": {
			"rulebook": ("physical", "dorm1room4student0"),
			"location": "dorm1room4",
		},
		"dorm2room0student1": {
			"rulebook": ("physical", "dorm2room0student1"),
			"location": "dorm2room0",
		},
		"dorm1room1": {"rulebook": ("physical", "dorm1room1")},
		"dorm2room0": {"rulebook": ("physical", "dorm2room0")},
		"dorm2room3student0": {
			"rulebook": ("physical", "dorm2room3student0"),
			"location": "dorm2room3",
		},
		"dorm0room0student0": {
			"rulebook": ("physical", "dorm0room0student0"),
			"location": "dorm0room0",
		},
		"dorm2room2student0": {
			"rulebook": ("physical", "dorm2room2student0"),
			"location": "dorm2room2",
		},
		"dorm0room3student1": {
			"rulebook": ("physical", "dorm0room3student1"),
			"location": "dorm0room3",
		},
		"dorm0room5": {"rulebook": ("physical", "dorm0room5")},
		"dorm2room1": {"rulebook": ("physical", "dorm2room1")},
		"dorm1room1student1": {
			"rulebook": ("physical", "dorm1room1student1"),
			"location": "dorm1room1",
		},
		"dorm0room4student0": {
			"rulebook": ("physical", "dorm0room4student0"),
			"location": "dorm0room4",
		},
		"dorm2room2student1": {
			"rulebook": ("physical", "dorm2room2student1"),
			"location": "dorm2room2",
		},
		"dorm1room2": {"rulebook": ("physical", "dorm1room2")},
		"dorm0room2": {"rulebook": ("physical", "dorm0room2")},
		"dorm2room5": {"rulebook": ("physical", "dorm2room5")},
		"dorm1room3student1": {
			"rulebook": ("physical", "dorm1room3student1"),
			"location": "dorm1room3",
		},
		"dorm0room2student1": {
			"rulebook": ("physical", "dorm0room2student1"),
			"location": "dorm0room2",
		},
		"dorm1room5student0": {
			"rulebook": ("physical", "dorm1room5student0"),
			"location": "dorm1room5",
		},
		"dorm1room0student0": {
			"rulebook": ("physical", "dorm1room0student0"),
			"location": "dorm1room0",
		},
		"dorm2room5student0": {
			"rulebook": ("physical", "dorm2room5student0"),
			"location": "dorm2room5",
		},
		"dorm1room5student1": {
			"rulebook": ("physical", "dorm1room5student1"),
			"location": "dorm1room5",
		},
		"dorm1room4": {"rulebook": ("physical", "dorm1room4")},
		"dorm0room1student1": {
			"rulebook": ("physical", "dorm0room1student1"),
			"location": "dorm0room1",
		},
		"dorm1room2student0": {
			"rulebook": ("physical", "dorm1room2student0"),
			"location": "dorm1room2",
		},
		"common2": {"rulebook": ("physical", "common2")},
		"dorm2room1student1": {
			"rulebook": ("physical", "dorm2room1student1"),
			"location": "dorm2room1",
		},
		"dorm1room0student1": {
			"rulebook": ("physical", "dorm1room0student1"),
			"location": "dorm1room0",
		},
		"dorm1room2student1": {
			"rulebook": ("physical", "dorm1room2student1"),
			"location": "dorm1room2",
		},
		"dorm0room0student1": {
			"rulebook": ("physical", "dorm0room0student1"),
			"location": "dorm0room0",
		},
		"dorm0room1student0": {
			"rulebook": ("physical", "dorm0room1student0"),
			"location": "dorm0room1",
		},
		"dorm1room0": {"rulebook": ("physical", "dorm1room0")},
		"dorm2room0student0": {
			"rulebook": ("physical", "dorm2room0student0"),
			"location": "dorm2room0",
		},
		"dorm0room4": {"rulebook": ("physical", "dorm0room4")},
		"dorm0room4student1": {
			"rulebook": ("physical", "dorm0room4student1"),
			"location": "dorm0room4",
		},
		"dorm2room3": {"rulebook": ("physical", "dorm2room3")},
		"dorm0room1": {"rulebook": ("physical", "dorm0room1")},
		"dorm1room1student0": {
			"rulebook": ("physical", "dorm1room1student0"),
			"location": "dorm1room1",
		},
		"dorm0room0": {"rulebook": ("physical", "dorm0room0")},
		"dorm1room3student0": {
			"rulebook": ("physical", "dorm1room3student0"),
			"location": "dorm1room3",
		},
		"dorm2room2": {"rulebook": ("physical", "dorm2room2")},
		"dorm2room4student1": {
			"rulebook": ("physical", "dorm2room4student1"),
			"location": "dorm2room4",
		},
		"dorm0room5student0": {
			"rulebook": ("physical", "dorm0room5student0"),
			"location": "dorm0room5",
		},
		"dorm1room5": {"rulebook": ("physical", "dorm1room5")},
		"dorm0room3": {"rulebook": ("physical", "dorm0room3")},
		"dorm2room5student1": {
			"rulebook": ("physical", "dorm2room5student1"),
			"location": "dorm2room5",
		},
		"common1": {"rulebook": ("physical", "common1")},
		"dorm2room4": {"rulebook": ("physical", "dorm2room4")},
	},
	"hour": 0,
	"name": "physical",
	"edge_val": {
		"common0": {
			"dorm0room5": {},
			"dorm0room3": {},
			"classroom": {},
			"dorm0room1": {},
			"dorm0room0": {},
			"dorm0room4": {},
			"dorm0room2": {},
		},
		"dorm1room3": {"common1": {}},
		"common2": {
			"dorm2room1": {},
			"dorm2room2": {},
			"dorm2room0": {},
			"classroom": {},
			"dorm2room5": {},
			"dorm2room4": {},
			"dorm2room3": {},
		},
		"classroom": {"common0": {}, "common2": {}, "common1": {}},
		"dorm1room1": {"common1": {}},
		"dorm2room0": {"common2": {}},
		"dorm1room0": {"common1": {}},
		"dorm0room0": {"common0": {}},
		"dorm0room4": {"common0": {}},
		"dorm2room3": {"common2": {}},
		"dorm0room1": {"common0": {}},
		"dorm2room2": {"common2": {}},
		"dorm1room5": {"common1": {}},
		"dorm1room2": {"common1": {}},
		"dorm0room2": {"common0": {}},
		"dorm2room1": {"common2": {}},
		"dorm2room5": {"common2": {}},
		"dorm2room4": {"common2": {}},
		"dorm0room3": {"common0": {}},
		"dorm0room5": {"common0": {}},
		"common1": {
			"dorm1room3": {},
			"dorm1room1": {},
			"classroom": {},
			"dorm1room5": {},
			"dorm1room0": {},
			"dorm1room2": {},
			"dorm1room4": {},
		},
		"dorm1room4": {"common1": {}},
	},
	"rulebooks": {
		"character": ("physical", "character"),
		"thing": ("physical", "character_thing"),
		"unit": ("physical", "unit"),
		"place": ("physical", "character_place"),
		"portal": ("physical", "character_portal"),
	},
}
DORM_INITIAL_COPY = {
	"rulebooks": {
		"thing": ("dorm0", "character_thing"),
		"character": ("dorm0", "character"),
		"unit": ("dorm0", "unit"),
		"portal": ("dorm0", "character_portal"),
		"place": ("dorm0", "character_place"),
	},
	"name": "dorm0",
	"units": {
		"physical": frozenset(
			{
				"dorm0room1",
				"dorm0room2",
				"dorm0room4",
				"dorm0room5",
				"dorm0room3",
				"common0",
				"dorm0room0",
			}
		)
	},
}

KF_FROM = {
	"actions": {
		"anotherrule": ["ham", "baked beans"],
		"onerule": ["spam", "eggs"],
	},
	"edge_val": {
		"physical": {
			(0, 0): {(0, 1): {}},
			(0, 1): {(0, 0): {}},
			(0, 2): {(0, 1): {}},
			(0, 3): {(0, 2): {}},
			(0, 4): {(0, 3): {}},
			(0, 5): {(0, 4): {}},
			(0, 6): {(0, 5): {}},
			(0, 7): {(0, 6): {}},
			(0, 8): {(0, 7): {}},
			(0, 9): {(0, 8): {}},
			(0, 10): {(0, 9): {}},
			(0, 11): {(0, 10): {}},
			(0, 12): {(0, 11): {}},
			(0, 13): {(0, 12): {}},
			(0, 14): {(0, 13): {}},
			(0, 15): {(0, 14): {}},
			(0, 16): {(0, 15): {}},
			(0, 17): {(0, 16): {}},
			(0, 18): {(0, 17): {}},
			(0, 19): {(0, 18): {}},
			(0, 20): {(0, 19): {}},
			(0, 21): {(0, 20): {}},
			(0, 22): {(0, 21): {}},
			(0, 23): {(0, 22): {}},
			(0, 24): {(0, 23): {}},
			(1, 0): {(2, 0): {}},
			(1, 1): {(1, 2): {}},
			(1, 2): {(1, 3): {}},
			(1, 3): {(1, 4): {}},
			(1, 4): {(1, 5): {}},
			(1, 5): {(1, 6): {}},
			(1, 6): {(1, 7): {}},
			(1, 7): {(1, 8): {}},
			(1, 8): {(1, 9): {}},
			(1, 9): {(1, 10): {}},
			(1, 10): {(1, 11): {}},
			(1, 11): {(1, 12): {}},
			(1, 12): {(1, 13): {}},
			(1, 13): {(1, 14): {}},
			(1, 14): {(1, 15): {}},
			(1, 15): {(1, 16): {}},
			(1, 16): {(1, 17): {}},
			(1, 17): {(1, 18): {}},
			(1, 18): {(1, 19): {}},
			(1, 19): {(1, 20): {}},
			(1, 20): {(1, 21): {}},
			(1, 21): {(1, 22): {}},
			(1, 22): {(1, 23): {}},
			(1, 23): {(1, 24): {}},
			(1, 24): {(2, 24): {}},
			(2, 0): {(3, 0): {}},
			(2, 1): {(2, 2): {}},
			(2, 2): {(2, 3): {}},
			(2, 3): {(2, 4): {}},
			(2, 4): {(2, 5): {}},
			(2, 5): {(2, 6): {}},
			(2, 6): {(2, 7): {}},
			(2, 7): {(2, 8): {}},
			(2, 8): {(2, 9): {}},
			(2, 9): {(2, 10): {}},
			(2, 10): {(2, 11): {}},
			(2, 11): {(2, 12): {}},
			(2, 12): {(2, 13): {}},
			(2, 13): {(2, 14): {}},
			(2, 14): {(2, 15): {}},
			(2, 15): {(2, 16): {}},
			(2, 16): {(2, 17): {}},
			(2, 17): {(2, 18): {}},
			(2, 18): {(2, 19): {}},
			(2, 19): {(2, 20): {}},
			(2, 20): {(2, 21): {}},
			(2, 21): {(2, 22): {}},
			(2, 22): {(2, 23): {}},
			(2, 23): {(2, 24): {}},
			(2, 24): {(3, 24): {}},
			(3, 0): {(4, 0): {}},
			(3, 1): {(3, 2): {}},
			(3, 2): {(3, 3): {}},
			(3, 3): {(3, 4): {}},
			(3, 4): {(3, 5): {}},
			(3, 5): {(3, 6): {}},
			(3, 6): {(3, 7): {}},
			(3, 7): {(3, 8): {}},
			(3, 8): {(3, 9): {}},
			(3, 9): {(3, 10): {}},
			(3, 10): {(3, 11): {}},
			(3, 11): {(3, 12): {}},
			(3, 12): {(3, 13): {}},
			(3, 13): {(3, 14): {}},
			(3, 14): {(3, 15): {}},
			(3, 15): {(3, 16): {}},
			(3, 16): {(3, 17): {}},
			(3, 17): {(3, 18): {}},
			(3, 18): {(3, 19): {}},
			(3, 19): {(3, 20): {}},
			(3, 20): {(3, 21): {}},
			(3, 21): {(3, 22): {}},
			(3, 22): {(3, 23): {}},
			(3, 23): {(3, 24): {}},
			(3, 24): {(4, 24): {}},
			(4, 0): {(5, 0): {}},
			(4, 1): {(4, 2): {}},
			(4, 2): {(4, 3): {}},
			(4, 3): {(4, 4): {}},
			(4, 4): {(4, 5): {}},
			(4, 5): {(4, 6): {}},
			(4, 6): {(4, 7): {}},
			(4, 7): {(4, 8): {}},
			(4, 8): {(4, 9): {}},
			(4, 9): {(4, 10): {}},
			(4, 10): {(4, 11): {}},
			(4, 11): {(4, 12): {}},
			(4, 12): {(4, 13): {}},
			(4, 13): {(4, 14): {}},
			(4, 14): {(4, 15): {}},
			(4, 15): {(4, 16): {}},
			(4, 16): {(4, 17): {}},
			(4, 17): {(4, 18): {}},
			(4, 18): {(4, 19): {}},
			(4, 19): {(4, 20): {}},
			(4, 20): {(4, 21): {}},
			(4, 21): {(4, 22): {}},
			(4, 22): {(4, 23): {}},
			(4, 23): {(4, 24): {}},
			(4, 24): {(5, 24): {}},
			(5, 0): {(6, 0): {}},
			(5, 1): {(5, 2): {}},
			(5, 2): {(5, 3): {}},
			(5, 3): {(5, 4): {}},
			(5, 4): {(5, 5): {}},
			(5, 5): {(5, 6): {}},
			(5, 6): {(5, 7): {}},
			(5, 7): {(5, 8): {}},
			(5, 8): {(5, 9): {}},
			(5, 9): {(5, 10): {}},
			(5, 10): {(5, 11): {}},
			(5, 11): {(5, 12): {}},
			(5, 12): {(5, 13): {}},
			(5, 13): {(5, 14): {}},
			(5, 14): {(5, 15): {}},
			(5, 15): {(5, 16): {}},
			(5, 16): {(5, 17): {}},
			(5, 17): {(5, 18): {}},
			(5, 18): {(5, 19): {}},
			(5, 19): {(5, 20): {}},
			(5, 20): {(5, 21): {}},
			(5, 21): {(5, 22): {}},
			(5, 22): {(5, 23): {}},
			(5, 23): {(5, 24): {}},
			(5, 24): {(6, 24): {}},
			(6, 0): {(7, 0): {}},
			(6, 1): {(6, 2): {}},
			(6, 2): {(6, 3): {}},
			(6, 3): {(6, 4): {}},
			(6, 4): {(6, 5): {}},
			(6, 5): {(6, 6): {}},
			(6, 6): {(6, 7): {}},
			(6, 7): {(6, 8): {}},
			(6, 8): {(6, 9): {}},
			(6, 9): {(6, 10): {}},
			(6, 10): {(6, 11): {}},
			(6, 11): {(6, 12): {}},
			(6, 12): {(6, 13): {}},
			(6, 13): {(6, 14): {}},
			(6, 14): {(6, 15): {}},
			(6, 15): {(6, 16): {}},
			(6, 16): {(6, 17): {}},
			(6, 17): {(6, 18): {}},
			(6, 18): {(6, 19): {}},
			(6, 19): {(6, 20): {}},
			(6, 20): {(6, 21): {}},
			(6, 21): {(6, 22): {}},
			(6, 22): {(6, 23): {}},
			(6, 23): {(6, 24): {}},
			(6, 24): {(7, 24): {}},
			(7, 0): {(8, 0): {}},
			(7, 1): {(7, 2): {}},
			(7, 2): {(7, 3): {}},
			(7, 3): {(7, 4): {}},
			(7, 4): {(7, 5): {}},
			(7, 5): {(7, 6): {}},
			(7, 6): {(7, 7): {}},
			(7, 7): {(7, 8): {}},
			(7, 8): {(7, 9): {}},
			(7, 9): {(7, 10): {}},
			(7, 10): {(7, 11): {}},
			(7, 11): {(7, 12): {}},
			(7, 12): {(7, 13): {}},
			(7, 13): {(7, 14): {}},
			(7, 14): {(7, 15): {}},
			(7, 15): {(7, 16): {}},
			(7, 16): {(7, 17): {}},
			(7, 17): {(7, 18): {}},
			(7, 18): {(7, 19): {}},
			(7, 19): {(7, 20): {}},
			(7, 20): {(7, 21): {}},
			(7, 21): {(7, 22): {}},
			(7, 22): {(7, 23): {}},
			(7, 23): {(7, 24): {}},
			(7, 24): {(8, 24): {}},
			(8, 0): {(9, 0): {}},
			(8, 1): {(8, 2): {}},
			(8, 2): {(8, 3): {}},
			(8, 3): {(8, 4): {}},
			(8, 4): {(8, 5): {}},
			(8, 5): {(8, 6): {}},
			(8, 6): {(8, 7): {}},
			(8, 7): {(8, 8): {}},
			(8, 8): {(8, 9): {}},
			(8, 9): {(8, 10): {}},
			(8, 10): {(8, 11): {}},
			(8, 11): {(8, 12): {}},
			(8, 12): {(8, 13): {}},
			(8, 13): {(8, 14): {}},
			(8, 14): {(8, 15): {}},
			(8, 15): {(8, 16): {}},
			(8, 16): {(8, 17): {}},
			(8, 17): {(8, 18): {}},
			(8, 18): {(8, 19): {}},
			(8, 19): {(8, 20): {}},
			(8, 20): {(8, 21): {}},
			(8, 21): {(8, 22): {}},
			(8, 22): {(8, 23): {}},
			(8, 23): {(8, 24): {}},
			(8, 24): {(9, 24): {}},
			(9, 0): {(10, 0): {}},
			(9, 1): {(9, 2): {}},
			(9, 2): {(9, 3): {}},
			(9, 3): {(9, 4): {}},
			(9, 4): {(9, 5): {}},
			(9, 5): {(9, 6): {}},
			(9, 6): {(9, 7): {}},
			(9, 7): {(9, 8): {}},
			(9, 8): {(9, 9): {}},
			(9, 9): {(9, 10): {}},
			(9, 10): {(9, 11): {}},
			(9, 11): {(9, 12): {}},
			(9, 12): {(9, 13): {}},
			(9, 13): {(9, 14): {}},
			(9, 14): {(9, 15): {}},
			(9, 15): {(9, 16): {}},
			(9, 16): {(9, 17): {}},
			(9, 17): {(9, 18): {}},
			(9, 18): {(9, 19): {}},
			(9, 19): {(9, 20): {}},
			(9, 20): {(9, 21): {}},
			(9, 21): {(9, 22): {}},
			(9, 22): {(9, 23): {}},
			(9, 23): {(9, 24): {}},
			(9, 24): {(10, 24): {}},
			(10, 0): {(11, 0): {}},
			(10, 1): {(10, 2): {}},
			(10, 2): {(10, 3): {}},
			(10, 3): {(10, 4): {}},
			(10, 4): {(10, 5): {}},
			(10, 5): {(10, 6): {}},
			(10, 6): {(10, 7): {}},
			(10, 7): {(10, 8): {}},
			(10, 8): {(10, 9): {}},
			(10, 9): {(10, 10): {}},
			(10, 10): {(10, 11): {}},
			(10, 11): {(10, 12): {}},
			(10, 12): {(10, 13): {}},
			(10, 13): {(10, 14): {}},
			(10, 14): {(10, 15): {}},
			(10, 15): {(10, 16): {}},
			(10, 16): {(10, 17): {}},
			(10, 17): {(10, 18): {}},
			(10, 18): {(10, 19): {}},
			(10, 19): {(10, 20): {}},
			(10, 20): {(10, 21): {}},
			(10, 21): {(10, 22): {}},
			(10, 22): {(10, 23): {}},
			(10, 23): {(10, 24): {}},
			(10, 24): {(11, 24): {}},
			(11, 0): {(12, 0): {}},
			(11, 1): {(11, 2): {}},
			(11, 2): {(11, 3): {}},
			(11, 3): {(11, 4): {}},
			(11, 4): {(11, 5): {}},
			(11, 5): {(11, 6): {}},
			(11, 6): {(11, 7): {}},
			(11, 7): {(11, 8): {}},
			(11, 8): {(11, 9): {}},
			(11, 9): {(11, 10): {}},
			(11, 10): {(11, 11): {}},
			(11, 11): {(11, 12): {}},
			(11, 12): {(11, 13): {}},
			(11, 13): {(11, 14): {}},
			(11, 14): {(11, 15): {}},
			(11, 15): {(11, 16): {}},
			(11, 16): {(11, 17): {}},
			(11, 17): {(11, 18): {}},
			(11, 18): {(11, 19): {}},
			(11, 19): {(11, 20): {}},
			(11, 20): {(11, 21): {}},
			(11, 21): {(11, 22): {}},
			(11, 22): {(11, 23): {}},
			(11, 23): {(11, 24): {}},
			(11, 24): {(12, 24): {}},
			(12, 0): {(13, 0): {}},
			(12, 1): {(12, 2): {}},
			(12, 2): {(12, 3): {}},
			(12, 3): {(12, 4): {}},
			(12, 4): {(12, 5): {}},
			(12, 5): {(12, 6): {}},
			(12, 6): {(12, 7): {}},
			(12, 7): {(12, 8): {}},
			(12, 8): {(12, 9): {}},
			(12, 9): {(12, 10): {}},
			(12, 10): {(12, 11): {}},
			(12, 11): {(12, 12): {}},
			(12, 12): {(12, 13): {}},
			(12, 13): {(12, 14): {}},
			(12, 14): {(12, 15): {}},
			(12, 15): {(12, 16): {}},
			(12, 16): {(12, 17): {}},
			(12, 17): {(12, 18): {}},
			(12, 18): {(12, 19): {}},
			(12, 19): {(12, 20): {}},
			(12, 20): {(12, 21): {}},
			(12, 21): {(12, 22): {}},
			(12, 22): {(12, 23): {}},
			(12, 23): {(12, 24): {}},
			(12, 24): {(13, 24): {}},
			(13, 0): {(14, 0): {}},
			(13, 1): {(13, 2): {}},
			(13, 2): {(13, 3): {}},
			(13, 3): {(13, 4): {}},
			(13, 4): {(13, 5): {}},
			(13, 5): {(13, 6): {}},
			(13, 6): {(13, 7): {}},
			(13, 7): {(13, 8): {}},
			(13, 8): {(13, 9): {}},
			(13, 9): {(13, 10): {}},
			(13, 10): {(13, 11): {}},
			(13, 11): {(13, 12): {}},
			(13, 12): {(13, 13): {}},
			(13, 13): {(13, 14): {}},
			(13, 14): {(13, 15): {}},
			(13, 15): {(13, 16): {}},
			(13, 16): {(13, 17): {}},
			(13, 17): {(13, 18): {}},
			(13, 18): {(13, 19): {}},
			(13, 19): {(13, 20): {}},
			(13, 20): {(13, 21): {}},
			(13, 21): {(13, 22): {}},
			(13, 22): {(13, 23): {}},
			(13, 23): {(13, 24): {}},
			(13, 24): {(14, 24): {}},
			(14, 0): {(15, 0): {}},
			(14, 1): {(14, 2): {}},
			(14, 2): {(14, 3): {}},
			(14, 3): {(14, 4): {}},
			(14, 4): {(14, 5): {}},
			(14, 5): {(14, 6): {}},
			(14, 6): {(14, 7): {}},
			(14, 7): {(14, 8): {}},
			(14, 8): {(14, 9): {}},
			(14, 9): {(14, 10): {}},
			(14, 10): {(14, 11): {}},
			(14, 11): {(14, 12): {}},
			(14, 12): {(14, 13): {}},
			(14, 13): {(14, 14): {}},
			(14, 14): {(14, 15): {}},
			(14, 15): {(14, 16): {}},
			(14, 16): {(14, 17): {}},
			(14, 17): {(14, 18): {}},
			(14, 18): {(14, 19): {}},
			(14, 19): {(14, 20): {}},
			(14, 20): {(14, 21): {}},
			(14, 21): {(14, 22): {}},
			(14, 22): {(14, 23): {}},
			(14, 23): {(14, 24): {}},
			(14, 24): {(15, 24): {}},
			(15, 0): {(16, 0): {}},
			(15, 1): {(15, 2): {}},
			(15, 2): {(15, 3): {}},
			(15, 3): {(15, 4): {}},
			(15, 4): {(15, 5): {}},
			(15, 5): {(15, 6): {}},
			(15, 6): {(15, 7): {}},
			(15, 7): {(15, 8): {}},
			(15, 8): {(15, 9): {}},
			(15, 9): {(15, 10): {}},
			(15, 10): {(15, 11): {}},
			(15, 11): {(15, 12): {}},
			(15, 12): {(15, 13): {}},
			(15, 13): {(15, 14): {}},
			(15, 14): {(15, 15): {}},
			(15, 15): {(15, 16): {}},
			(15, 16): {(15, 17): {}},
			(15, 17): {(15, 18): {}},
			(15, 18): {(15, 19): {}},
			(15, 19): {(15, 20): {}},
			(15, 20): {(15, 21): {}},
			(15, 21): {(15, 22): {}},
			(15, 22): {(15, 23): {}},
			(15, 23): {(15, 24): {}},
			(15, 24): {(16, 24): {}},
			(16, 0): {(17, 0): {}},
			(16, 1): {(16, 2): {}},
			(16, 2): {(16, 3): {}},
			(16, 3): {(16, 4): {}},
			(16, 4): {(16, 5): {}},
			(16, 5): {(16, 6): {}},
			(16, 6): {(16, 7): {}},
			(16, 7): {(16, 8): {}},
			(16, 8): {(16, 9): {}},
			(16, 9): {(16, 10): {}},
			(16, 10): {(16, 11): {}},
			(16, 11): {(16, 12): {}},
			(16, 12): {(16, 13): {}},
			(16, 13): {(16, 14): {}},
			(16, 14): {(16, 15): {}},
			(16, 15): {(16, 16): {}},
			(16, 16): {(16, 17): {}},
			(16, 17): {(16, 18): {}},
			(16, 18): {(16, 19): {}},
			(16, 19): {(16, 20): {}},
			(16, 20): {(16, 21): {}},
			(16, 21): {(16, 22): {}},
			(16, 22): {(16, 23): {}},
			(16, 23): {(16, 24): {}},
			(16, 24): {(17, 24): {}},
			(17, 0): {(18, 0): {}},
			(17, 1): {(17, 2): {}},
			(17, 2): {(17, 3): {}},
			(17, 3): {(17, 4): {}},
			(17, 4): {(17, 5): {}},
			(17, 5): {(17, 6): {}},
			(17, 6): {(17, 7): {}},
			(17, 7): {(17, 8): {}},
			(17, 8): {(17, 9): {}},
			(17, 9): {(17, 10): {}},
			(17, 10): {(17, 11): {}},
			(17, 11): {(17, 12): {}},
			(17, 12): {(17, 13): {}},
			(17, 13): {(17, 14): {}},
			(17, 14): {(17, 15): {}},
			(17, 15): {(17, 16): {}},
			(17, 16): {(17, 17): {}},
			(17, 17): {(17, 18): {}},
			(17, 18): {(17, 19): {}},
			(17, 19): {(17, 20): {}},
			(17, 20): {(17, 21): {}},
			(17, 21): {(17, 22): {}},
			(17, 22): {(17, 23): {}},
			(17, 23): {(17, 24): {}},
			(17, 24): {(18, 24): {}},
			(18, 0): {(19, 0): {}},
			(18, 1): {(18, 2): {}},
			(18, 2): {(18, 3): {}},
			(18, 3): {(18, 4): {}},
			(18, 4): {(18, 5): {}},
			(18, 5): {(18, 6): {}},
			(18, 6): {(18, 7): {}},
			(18, 7): {(18, 8): {}},
			(18, 8): {(18, 9): {}},
			(18, 9): {(18, 10): {}},
			(18, 10): {(18, 11): {}},
			(18, 11): {(18, 12): {}},
			(18, 12): {(18, 13): {}},
			(18, 13): {(18, 14): {}},
			(18, 14): {(18, 15): {}},
			(18, 15): {(18, 16): {}},
			(18, 16): {(18, 17): {}},
			(18, 17): {(18, 18): {}},
			(18, 18): {(18, 19): {}},
			(18, 19): {(18, 20): {}},
			(18, 20): {(18, 21): {}},
			(18, 21): {(18, 22): {}},
			(18, 22): {(18, 23): {}},
			(18, 23): {(18, 24): {}},
			(18, 24): {(19, 24): {}},
			(19, 0): {(20, 0): {}},
			(19, 1): {(19, 2): {}},
			(19, 2): {(19, 3): {}},
			(19, 3): {(19, 4): {}},
			(19, 4): {(19, 5): {}},
			(19, 5): {(19, 6): {}},
			(19, 6): {(19, 7): {}},
			(19, 7): {(19, 8): {}},
			(19, 8): {(19, 9): {}},
			(19, 9): {(19, 10): {}},
			(19, 10): {(19, 11): {}},
			(19, 11): {(19, 12): {}},
			(19, 12): {(19, 13): {}},
			(19, 13): {(19, 14): {}},
			(19, 14): {(19, 15): {}},
			(19, 15): {(19, 16): {}},
			(19, 16): {(19, 17): {}},
			(19, 17): {(19, 18): {}},
			(19, 18): {(19, 19): {}},
			(19, 19): {(19, 20): {}},
			(19, 20): {(19, 21): {}},
			(19, 21): {(19, 22): {}},
			(19, 22): {(19, 23): {}},
			(19, 23): {(19, 24): {}},
			(19, 24): {(20, 24): {}},
			(20, 0): {(21, 0): {}},
			(20, 1): {(20, 2): {}},
			(20, 2): {(20, 3): {}},
			(20, 3): {(20, 4): {}},
			(20, 4): {(20, 5): {}},
			(20, 5): {(20, 6): {}},
			(20, 6): {(20, 7): {}},
			(20, 7): {(20, 8): {}},
			(20, 8): {(20, 9): {}},
			(20, 9): {(20, 10): {}},
			(20, 10): {(20, 11): {}},
			(20, 11): {(20, 12): {}},
			(20, 12): {(20, 13): {}},
			(20, 13): {(20, 14): {}},
			(20, 14): {(20, 15): {}},
			(20, 15): {(20, 16): {}},
			(20, 16): {(20, 17): {}},
			(20, 17): {(20, 18): {}},
			(20, 18): {(20, 19): {}},
			(20, 19): {(20, 20): {}},
			(20, 20): {(20, 21): {}},
			(20, 21): {(20, 22): {}},
			(20, 22): {(20, 23): {}},
			(20, 23): {(20, 24): {}},
			(20, 24): {(21, 24): {}},
			(21, 0): {(22, 0): {}},
			(21, 1): {(21, 2): {}},
			(21, 2): {(21, 3): {}},
			(21, 3): {(21, 4): {}},
			(21, 4): {(21, 5): {}},
			(21, 5): {(21, 6): {}},
			(21, 6): {(21, 7): {}},
			(21, 7): {(21, 8): {}},
			(21, 8): {(21, 9): {}},
			(21, 9): {(21, 10): {}},
			(21, 10): {(21, 11): {}},
			(21, 11): {(21, 12): {}},
			(21, 12): {(21, 13): {}},
			(21, 13): {(21, 14): {}},
			(21, 14): {(21, 15): {}},
			(21, 15): {(21, 16): {}},
			(21, 16): {(21, 17): {}},
			(21, 17): {(21, 18): {}},
			(21, 18): {(21, 19): {}},
			(21, 19): {(21, 20): {}},
			(21, 20): {(21, 21): {}},
			(21, 21): {(21, 22): {}},
			(21, 22): {(21, 23): {}},
			(21, 23): {(21, 24): {}},
			(21, 24): {(22, 24): {}},
			(22, 0): {(23, 0): {}},
			(22, 1): {(22, 2): {}},
			(22, 2): {(22, 3): {}},
			(22, 3): {(22, 4): {}},
			(22, 4): {(22, 5): {}},
			(22, 5): {(22, 6): {}},
			(22, 6): {(22, 7): {}},
			(22, 7): {(22, 8): {}},
			(22, 8): {(22, 9): {}},
			(22, 9): {(22, 10): {}},
			(22, 10): {(22, 11): {}},
			(22, 11): {(22, 12): {}},
			(22, 12): {(22, 13): {}},
			(22, 13): {(22, 14): {}},
			(22, 14): {(22, 15): {}},
			(22, 15): {(22, 16): {}},
			(22, 16): {(22, 17): {}},
			(22, 17): {(22, 18): {}},
			(22, 18): {(22, 19): {}},
			(22, 19): {(22, 20): {}},
			(22, 20): {(22, 21): {}},
			(22, 21): {(22, 22): {}},
			(22, 22): {(22, 23): {}},
			(22, 23): {(22, 24): {}},
			(22, 24): {(23, 24): {}},
			(23, 0): {(24, 0): {}},
			(23, 1): {(23, 2): {}},
			(23, 2): {(23, 3): {}},
			(23, 3): {(23, 4): {}},
			(23, 4): {(23, 5): {}},
			(23, 5): {(23, 6): {}},
			(23, 6): {(23, 7): {}},
			(23, 7): {(23, 8): {}},
			(23, 8): {(23, 9): {}},
			(23, 9): {(23, 10): {}},
			(23, 10): {(23, 11): {}},
			(23, 11): {(23, 12): {}},
			(23, 12): {(23, 13): {}},
			(23, 13): {(23, 14): {}},
			(23, 14): {(23, 15): {}},
			(23, 15): {(23, 16): {}},
			(23, 16): {(23, 17): {}},
			(23, 17): {(23, 18): {}},
			(23, 18): {(23, 19): {}},
			(23, 19): {(23, 20): {}},
			(23, 20): {(23, 21): {}},
			(23, 21): {(23, 22): {}},
			(23, 22): {(23, 23): {}},
			(23, 23): {(23, 24): {}},
			(23, 24): {(24, 24): {}},
			(24, 0): {(24, 1): {}},
			(24, 1): {(24, 0): {}},
			(24, 2): {(24, 1): {}},
			(24, 3): {(24, 2): {}},
			(24, 4): {(24, 3): {}},
			(24, 5): {(24, 4): {}},
			(24, 6): {(24, 5): {}},
			(24, 7): {(24, 6): {}},
			(24, 8): {(24, 7): {}},
			(24, 9): {(24, 8): {}},
			(24, 10): {(24, 9): {}},
			(24, 11): {(24, 10): {}},
			(24, 12): {(24, 11): {}},
			(24, 13): {(24, 12): {}},
			(24, 14): {(24, 13): {}},
			(24, 15): {(24, 14): {}},
			(24, 16): {(24, 15): {}},
			(24, 17): {(24, 16): {}},
			(24, 18): {(24, 17): {}},
			(24, 19): {(24, 18): {}},
			(24, 20): {(24, 19): {}},
			(24, 21): {(24, 20): {}},
			(24, 22): {(24, 21): {}},
			(24, 23): {(24, 22): {}},
			(24, 24): {(24, 23): {}},
		}
	},
	"edges": {
		"physical": {
			(0, 0): {(0, 1): {0: True}, (1, 0): {0: True}},
			(0, 1): {(0, 0): {0: True}, (0, 2): {0: True}, (1, 1): {0: True}},
			(0, 2): {(0, 1): {0: True}, (0, 3): {0: True}, (1, 2): {0: True}},
			(0, 3): {(0, 2): {0: True}, (0, 4): {0: True}, (1, 3): {0: True}},
			(0, 4): {(0, 3): {0: True}, (0, 5): {0: True}, (1, 4): {0: True}},
			(0, 5): {(0, 4): {0: True}, (0, 6): {0: True}, (1, 5): {0: True}},
			(0, 6): {(0, 5): {0: True}, (0, 7): {0: True}, (1, 6): {0: True}},
			(0, 7): {(0, 6): {0: True}, (0, 8): {0: True}, (1, 7): {0: True}},
			(0, 8): {(0, 7): {0: True}, (0, 9): {0: True}, (1, 8): {0: True}},
			(0, 9): {(0, 8): {0: True}, (0, 10): {0: True}, (1, 9): {0: True}},
			(0, 10): {
				(0, 9): {0: True},
				(0, 11): {0: True},
				(1, 10): {0: True},
			},
			(0, 11): {
				(0, 10): {0: True},
				(0, 12): {0: True},
				(1, 11): {0: True},
			},
			(0, 12): {
				(0, 11): {0: True},
				(0, 13): {0: True},
				(1, 12): {0: True},
			},
			(0, 13): {
				(0, 12): {0: True},
				(0, 14): {0: True},
				(1, 13): {0: True},
			},
			(0, 14): {
				(0, 13): {0: True},
				(0, 15): {0: True},
				(1, 14): {0: True},
			},
			(0, 15): {
				(0, 14): {0: True},
				(0, 16): {0: True},
				(1, 15): {0: True},
			},
			(0, 16): {
				(0, 15): {0: True},
				(0, 17): {0: True},
				(1, 16): {0: True},
			},
			(0, 17): {
				(0, 16): {0: True},
				(0, 18): {0: True},
				(1, 17): {0: True},
			},
			(0, 18): {
				(0, 17): {0: True},
				(0, 19): {0: True},
				(1, 18): {0: True},
			},
			(0, 19): {
				(0, 18): {0: True},
				(0, 20): {0: True},
				(1, 19): {0: True},
			},
			(0, 20): {
				(0, 19): {0: True},
				(0, 21): {0: True},
				(1, 20): {0: True},
			},
			(0, 21): {
				(0, 20): {0: True},
				(0, 22): {0: True},
				(1, 21): {0: True},
			},
			(0, 22): {
				(0, 21): {0: True},
				(0, 23): {0: True},
				(1, 22): {0: True},
			},
			(0, 23): {
				(0, 22): {0: True},
				(0, 24): {0: True},
				(1, 23): {0: True},
			},
			(0, 24): {(0, 23): {0: True}, (1, 24): {0: True}},
			(1, 0): {(0, 0): {0: True}, (1, 1): {0: True}, (2, 0): {0: True}},
			(1, 1): {
				(0, 1): {0: True},
				(1, 0): {0: True},
				(1, 2): {0: True},
				(2, 1): {0: True},
			},
			(1, 2): {
				(0, 2): {0: True},
				(1, 1): {0: True},
				(1, 3): {0: True},
				(2, 2): {0: True},
			},
			(1, 3): {
				(0, 3): {0: True},
				(1, 2): {0: True},
				(1, 4): {0: True},
				(2, 3): {0: True},
			},
			(1, 4): {
				(0, 4): {0: True},
				(1, 3): {0: True},
				(1, 5): {0: True},
				(2, 4): {0: True},
			},
			(1, 5): {
				(0, 5): {0: True},
				(1, 4): {0: True},
				(1, 6): {0: True},
				(2, 5): {0: True},
			},
			(1, 6): {
				(0, 6): {0: True},
				(1, 5): {0: True},
				(1, 7): {0: True},
				(2, 6): {0: True},
			},
			(1, 7): {
				(0, 7): {0: True},
				(1, 6): {0: True},
				(1, 8): {0: True},
				(2, 7): {0: True},
			},
			(1, 8): {
				(0, 8): {0: True},
				(1, 7): {0: True},
				(1, 9): {0: True},
				(2, 8): {0: True},
			},
			(1, 9): {
				(0, 9): {0: True},
				(1, 8): {0: True},
				(1, 10): {0: True},
				(2, 9): {0: True},
			},
			(1, 10): {
				(0, 10): {0: True},
				(1, 9): {0: True},
				(1, 11): {0: True},
				(2, 10): {0: True},
			},
			(1, 11): {
				(0, 11): {0: True},
				(1, 10): {0: True},
				(1, 12): {0: True},
				(2, 11): {0: True},
			},
			(1, 12): {
				(0, 12): {0: True},
				(1, 11): {0: True},
				(1, 13): {0: True},
				(2, 12): {0: True},
			},
			(1, 13): {
				(0, 13): {0: True},
				(1, 12): {0: True},
				(1, 14): {0: True},
				(2, 13): {0: True},
			},
			(1, 14): {
				(0, 14): {0: True},
				(1, 13): {0: True},
				(1, 15): {0: True},
				(2, 14): {0: True},
			},
			(1, 15): {
				(0, 15): {0: True},
				(1, 14): {0: True},
				(1, 16): {0: True},
				(2, 15): {0: True},
			},
			(1, 16): {
				(0, 16): {0: True},
				(1, 15): {0: True},
				(1, 17): {0: True},
				(2, 16): {0: True},
			},
			(1, 17): {
				(0, 17): {0: True},
				(1, 16): {0: True},
				(1, 18): {0: True},
				(2, 17): {0: True},
			},
			(1, 18): {
				(0, 18): {0: True},
				(1, 17): {0: True},
				(1, 19): {0: True},
				(2, 18): {0: True},
			},
			(1, 19): {
				(0, 19): {0: True},
				(1, 18): {0: True},
				(1, 20): {0: True},
				(2, 19): {0: True},
			},
			(1, 20): {
				(0, 20): {0: True},
				(1, 19): {0: True},
				(1, 21): {0: True},
				(2, 20): {0: True},
			},
			(1, 21): {
				(0, 21): {0: True},
				(1, 20): {0: True},
				(1, 22): {0: True},
				(2, 21): {0: True},
			},
			(1, 22): {
				(0, 22): {0: True},
				(1, 21): {0: True},
				(1, 23): {0: True},
				(2, 22): {0: True},
			},
			(1, 23): {
				(0, 23): {0: True},
				(1, 22): {0: True},
				(1, 24): {0: True},
				(2, 23): {0: True},
			},
			(1, 24): {
				(0, 24): {0: True},
				(1, 23): {0: True},
				(2, 24): {0: True},
			},
			(2, 0): {(1, 0): {0: True}, (2, 1): {0: True}, (3, 0): {0: True}},
			(2, 1): {
				(1, 1): {0: True},
				(2, 0): {0: True},
				(2, 2): {0: True},
				(3, 1): {0: True},
			},
			(2, 2): {
				(1, 2): {0: True},
				(2, 1): {0: True},
				(2, 3): {0: True},
				(3, 2): {0: True},
			},
			(2, 3): {
				(1, 3): {0: True},
				(2, 2): {0: True},
				(2, 4): {0: True},
				(3, 3): {0: True},
			},
			(2, 4): {
				(1, 4): {0: True},
				(2, 3): {0: True},
				(2, 5): {0: True},
				(3, 4): {0: True},
			},
			(2, 5): {
				(1, 5): {0: True},
				(2, 4): {0: True},
				(2, 6): {0: True},
				(3, 5): {0: True},
			},
			(2, 6): {
				(1, 6): {0: True},
				(2, 5): {0: True},
				(2, 7): {0: True},
				(3, 6): {0: True},
			},
			(2, 7): {
				(1, 7): {0: True},
				(2, 6): {0: True},
				(2, 8): {0: True},
				(3, 7): {0: True},
			},
			(2, 8): {
				(1, 8): {0: True},
				(2, 7): {0: True},
				(2, 9): {0: True},
				(3, 8): {0: True},
			},
			(2, 9): {
				(1, 9): {0: True},
				(2, 8): {0: True},
				(2, 10): {0: True},
				(3, 9): {0: True},
			},
			(2, 10): {
				(1, 10): {0: True},
				(2, 9): {0: True},
				(2, 11): {0: True},
				(3, 10): {0: True},
			},
			(2, 11): {
				(1, 11): {0: True},
				(2, 10): {0: True},
				(2, 12): {0: True},
				(3, 11): {0: True},
			},
			(2, 12): {
				(1, 12): {0: True},
				(2, 11): {0: True},
				(2, 13): {0: True},
				(3, 12): {0: True},
			},
			(2, 13): {
				(1, 13): {0: True},
				(2, 12): {0: True},
				(2, 14): {0: True},
				(3, 13): {0: True},
			},
			(2, 14): {
				(1, 14): {0: True},
				(2, 13): {0: True},
				(2, 15): {0: True},
				(3, 14): {0: True},
			},
			(2, 15): {
				(1, 15): {0: True},
				(2, 14): {0: True},
				(2, 16): {0: True},
				(3, 15): {0: True},
			},
			(2, 16): {
				(1, 16): {0: True},
				(2, 15): {0: True},
				(2, 17): {0: True},
				(3, 16): {0: True},
			},
			(2, 17): {
				(1, 17): {0: True},
				(2, 16): {0: True},
				(2, 18): {0: True},
				(3, 17): {0: True},
			},
			(2, 18): {
				(1, 18): {0: True},
				(2, 17): {0: True},
				(2, 19): {0: True},
				(3, 18): {0: True},
			},
			(2, 19): {
				(1, 19): {0: True},
				(2, 18): {0: True},
				(2, 20): {0: True},
				(3, 19): {0: True},
			},
			(2, 20): {
				(1, 20): {0: True},
				(2, 19): {0: True},
				(2, 21): {0: True},
				(3, 20): {0: True},
			},
			(2, 21): {
				(1, 21): {0: True},
				(2, 20): {0: True},
				(2, 22): {0: True},
				(3, 21): {0: True},
			},
			(2, 22): {
				(1, 22): {0: True},
				(2, 21): {0: True},
				(2, 23): {0: True},
				(3, 22): {0: True},
			},
			(2, 23): {
				(1, 23): {0: True},
				(2, 22): {0: True},
				(2, 24): {0: True},
				(3, 23): {0: True},
			},
			(2, 24): {
				(1, 24): {0: True},
				(2, 23): {0: True},
				(3, 24): {0: True},
			},
			(3, 0): {(2, 0): {0: True}, (3, 1): {0: True}, (4, 0): {0: True}},
			(3, 1): {
				(2, 1): {0: True},
				(3, 0): {0: True},
				(3, 2): {0: True},
				(4, 1): {0: True},
			},
			(3, 2): {
				(2, 2): {0: True},
				(3, 1): {0: True},
				(3, 3): {0: True},
				(4, 2): {0: True},
			},
			(3, 3): {
				(2, 3): {0: True},
				(3, 2): {0: True},
				(3, 4): {0: True},
				(4, 3): {0: True},
			},
			(3, 4): {
				(2, 4): {0: True},
				(3, 3): {0: True},
				(3, 5): {0: True},
				(4, 4): {0: True},
			},
			(3, 5): {
				(2, 5): {0: True},
				(3, 4): {0: True},
				(3, 6): {0: True},
				(4, 5): {0: True},
			},
			(3, 6): {
				(2, 6): {0: True},
				(3, 5): {0: True},
				(3, 7): {0: True},
				(4, 6): {0: True},
			},
			(3, 7): {
				(2, 7): {0: True},
				(3, 6): {0: True},
				(3, 8): {0: True},
				(4, 7): {0: True},
			},
			(3, 8): {
				(2, 8): {0: True},
				(3, 7): {0: True},
				(3, 9): {0: True},
				(4, 8): {0: True},
			},
			(3, 9): {
				(2, 9): {0: True},
				(3, 8): {0: True},
				(3, 10): {0: True},
				(4, 9): {0: True},
			},
			(3, 10): {
				(2, 10): {0: True},
				(3, 9): {0: True},
				(3, 11): {0: True},
				(4, 10): {0: True},
			},
			(3, 11): {
				(2, 11): {0: True},
				(3, 10): {0: True},
				(3, 12): {0: True},
				(4, 11): {0: True},
			},
			(3, 12): {
				(2, 12): {0: True},
				(3, 11): {0: True},
				(3, 13): {0: True},
				(4, 12): {0: True},
			},
			(3, 13): {
				(2, 13): {0: True},
				(3, 12): {0: True},
				(3, 14): {0: True},
				(4, 13): {0: True},
			},
			(3, 14): {
				(2, 14): {0: True},
				(3, 13): {0: True},
				(3, 15): {0: True},
				(4, 14): {0: True},
			},
			(3, 15): {
				(2, 15): {0: True},
				(3, 14): {0: True},
				(3, 16): {0: True},
				(4, 15): {0: True},
			},
			(3, 16): {
				(2, 16): {0: True},
				(3, 15): {0: True},
				(3, 17): {0: True},
				(4, 16): {0: True},
			},
			(3, 17): {
				(2, 17): {0: True},
				(3, 16): {0: True},
				(3, 18): {0: True},
				(4, 17): {0: True},
			},
			(3, 18): {
				(2, 18): {0: True},
				(3, 17): {0: True},
				(3, 19): {0: True},
				(4, 18): {0: True},
			},
			(3, 19): {
				(2, 19): {0: True},
				(3, 18): {0: True},
				(3, 20): {0: True},
				(4, 19): {0: True},
			},
			(3, 20): {
				(2, 20): {0: True},
				(3, 19): {0: True},
				(3, 21): {0: True},
				(4, 20): {0: True},
			},
			(3, 21): {
				(2, 21): {0: True},
				(3, 20): {0: True},
				(3, 22): {0: True},
				(4, 21): {0: True},
			},
			(3, 22): {
				(2, 22): {0: True},
				(3, 21): {0: True},
				(3, 23): {0: True},
				(4, 22): {0: True},
			},
			(3, 23): {
				(2, 23): {0: True},
				(3, 22): {0: True},
				(3, 24): {0: True},
				(4, 23): {0: True},
			},
			(3, 24): {
				(2, 24): {0: True},
				(3, 23): {0: True},
				(4, 24): {0: True},
			},
			(4, 0): {(3, 0): {0: True}, (4, 1): {0: True}, (5, 0): {0: True}},
			(4, 1): {
				(3, 1): {0: True},
				(4, 0): {0: True},
				(4, 2): {0: True},
				(5, 1): {0: True},
			},
			(4, 2): {
				(3, 2): {0: True},
				(4, 1): {0: True},
				(4, 3): {0: True},
				(5, 2): {0: True},
			},
			(4, 3): {
				(3, 3): {0: True},
				(4, 2): {0: True},
				(4, 4): {0: True},
				(5, 3): {0: True},
			},
			(4, 4): {
				(3, 4): {0: True},
				(4, 3): {0: True},
				(4, 5): {0: True},
				(5, 4): {0: True},
			},
			(4, 5): {
				(3, 5): {0: True},
				(4, 4): {0: True},
				(4, 6): {0: True},
				(5, 5): {0: True},
			},
			(4, 6): {
				(3, 6): {0: True},
				(4, 5): {0: True},
				(4, 7): {0: True},
				(5, 6): {0: True},
			},
			(4, 7): {
				(3, 7): {0: True},
				(4, 6): {0: True},
				(4, 8): {0: True},
				(5, 7): {0: True},
			},
			(4, 8): {
				(3, 8): {0: True},
				(4, 7): {0: True},
				(4, 9): {0: True},
				(5, 8): {0: True},
			},
			(4, 9): {
				(3, 9): {0: True},
				(4, 8): {0: True},
				(4, 10): {0: True},
				(5, 9): {0: True},
			},
			(4, 10): {
				(3, 10): {0: True},
				(4, 9): {0: True},
				(4, 11): {0: True},
				(5, 10): {0: True},
			},
			(4, 11): {
				(3, 11): {0: True},
				(4, 10): {0: True},
				(4, 12): {0: True},
				(5, 11): {0: True},
			},
			(4, 12): {
				(3, 12): {0: True},
				(4, 11): {0: True},
				(4, 13): {0: True},
				(5, 12): {0: True},
			},
			(4, 13): {
				(3, 13): {0: True},
				(4, 12): {0: True},
				(4, 14): {0: True},
				(5, 13): {0: True},
			},
			(4, 14): {
				(3, 14): {0: True},
				(4, 13): {0: True},
				(4, 15): {0: True},
				(5, 14): {0: True},
			},
			(4, 15): {
				(3, 15): {0: True},
				(4, 14): {0: True},
				(4, 16): {0: True},
				(5, 15): {0: True},
			},
			(4, 16): {
				(3, 16): {0: True},
				(4, 15): {0: True},
				(4, 17): {0: True},
				(5, 16): {0: True},
			},
			(4, 17): {
				(3, 17): {0: True},
				(4, 16): {0: True},
				(4, 18): {0: True},
				(5, 17): {0: True},
			},
			(4, 18): {
				(3, 18): {0: True},
				(4, 17): {0: True},
				(4, 19): {0: True},
				(5, 18): {0: True},
			},
			(4, 19): {
				(3, 19): {0: True},
				(4, 18): {0: True},
				(4, 20): {0: True},
				(5, 19): {0: True},
			},
			(4, 20): {
				(3, 20): {0: True},
				(4, 19): {0: True},
				(4, 21): {0: True},
				(5, 20): {0: True},
			},
			(4, 21): {
				(3, 21): {0: True},
				(4, 20): {0: True},
				(4, 22): {0: True},
				(5, 21): {0: True},
			},
			(4, 22): {
				(3, 22): {0: True},
				(4, 21): {0: True},
				(4, 23): {0: True},
				(5, 22): {0: True},
			},
			(4, 23): {
				(3, 23): {0: True},
				(4, 22): {0: True},
				(4, 24): {0: True},
				(5, 23): {0: True},
			},
			(4, 24): {
				(3, 24): {0: True},
				(4, 23): {0: True},
				(5, 24): {0: True},
			},
			(5, 0): {(4, 0): {0: True}, (5, 1): {0: True}, (6, 0): {0: True}},
			(5, 1): {
				(4, 1): {0: True},
				(5, 0): {0: True},
				(5, 2): {0: True},
				(6, 1): {0: True},
			},
			(5, 2): {
				(4, 2): {0: True},
				(5, 1): {0: True},
				(5, 3): {0: True},
				(6, 2): {0: True},
			},
			(5, 3): {
				(4, 3): {0: True},
				(5, 2): {0: True},
				(5, 4): {0: True},
				(6, 3): {0: True},
			},
			(5, 4): {
				(4, 4): {0: True},
				(5, 3): {0: True},
				(5, 5): {0: True},
				(6, 4): {0: True},
			},
			(5, 5): {
				(4, 5): {0: True},
				(5, 4): {0: True},
				(5, 6): {0: True},
				(6, 5): {0: True},
			},
			(5, 6): {
				(4, 6): {0: True},
				(5, 5): {0: True},
				(5, 7): {0: True},
				(6, 6): {0: True},
			},
			(5, 7): {
				(4, 7): {0: True},
				(5, 6): {0: True},
				(5, 8): {0: True},
				(6, 7): {0: True},
			},
			(5, 8): {
				(4, 8): {0: True},
				(5, 7): {0: True},
				(5, 9): {0: True},
				(6, 8): {0: True},
			},
			(5, 9): {
				(4, 9): {0: True},
				(5, 8): {0: True},
				(5, 10): {0: True},
				(6, 9): {0: True},
			},
			(5, 10): {
				(4, 10): {0: True},
				(5, 9): {0: True},
				(5, 11): {0: True},
				(6, 10): {0: True},
			},
			(5, 11): {
				(4, 11): {0: True},
				(5, 10): {0: True},
				(5, 12): {0: True},
				(6, 11): {0: True},
			},
			(5, 12): {
				(4, 12): {0: True},
				(5, 11): {0: True},
				(5, 13): {0: True},
				(6, 12): {0: True},
			},
			(5, 13): {
				(4, 13): {0: True},
				(5, 12): {0: True},
				(5, 14): {0: True},
				(6, 13): {0: True},
			},
			(5, 14): {
				(4, 14): {0: True},
				(5, 13): {0: True},
				(5, 15): {0: True},
				(6, 14): {0: True},
			},
			(5, 15): {
				(4, 15): {0: True},
				(5, 14): {0: True},
				(5, 16): {0: True},
				(6, 15): {0: True},
			},
			(5, 16): {
				(4, 16): {0: True},
				(5, 15): {0: True},
				(5, 17): {0: True},
				(6, 16): {0: True},
			},
			(5, 17): {
				(4, 17): {0: True},
				(5, 16): {0: True},
				(5, 18): {0: True},
				(6, 17): {0: True},
			},
			(5, 18): {
				(4, 18): {0: True},
				(5, 17): {0: True},
				(5, 19): {0: True},
				(6, 18): {0: True},
			},
			(5, 19): {
				(4, 19): {0: True},
				(5, 18): {0: True},
				(5, 20): {0: True},
				(6, 19): {0: True},
			},
			(5, 20): {
				(4, 20): {0: True},
				(5, 19): {0: True},
				(5, 21): {0: True},
				(6, 20): {0: True},
			},
			(5, 21): {
				(4, 21): {0: True},
				(5, 20): {0: True},
				(5, 22): {0: True},
				(6, 21): {0: True},
			},
			(5, 22): {
				(4, 22): {0: True},
				(5, 21): {0: True},
				(5, 23): {0: True},
				(6, 22): {0: True},
			},
			(5, 23): {
				(4, 23): {0: True},
				(5, 22): {0: True},
				(5, 24): {0: True},
				(6, 23): {0: True},
			},
			(5, 24): {
				(4, 24): {0: True},
				(5, 23): {0: True},
				(6, 24): {0: True},
			},
			(6, 0): {(5, 0): {0: True}, (6, 1): {0: True}, (7, 0): {0: True}},
			(6, 1): {
				(5, 1): {0: True},
				(6, 0): {0: True},
				(6, 2): {0: True},
				(7, 1): {0: True},
			},
			(6, 2): {
				(5, 2): {0: True},
				(6, 1): {0: True},
				(6, 3): {0: True},
				(7, 2): {0: True},
			},
			(6, 3): {
				(5, 3): {0: True},
				(6, 2): {0: True},
				(6, 4): {0: True},
				(7, 3): {0: True},
			},
			(6, 4): {
				(5, 4): {0: True},
				(6, 3): {0: True},
				(6, 5): {0: True},
				(7, 4): {0: True},
			},
			(6, 5): {
				(5, 5): {0: True},
				(6, 4): {0: True},
				(6, 6): {0: True},
				(7, 5): {0: True},
			},
			(6, 6): {
				(5, 6): {0: True},
				(6, 5): {0: True},
				(6, 7): {0: True},
				(7, 6): {0: True},
			},
			(6, 7): {
				(5, 7): {0: True},
				(6, 6): {0: True},
				(6, 8): {0: True},
				(7, 7): {0: True},
			},
			(6, 8): {
				(5, 8): {0: True},
				(6, 7): {0: True},
				(6, 9): {0: True},
				(7, 8): {0: True},
			},
			(6, 9): {
				(5, 9): {0: True},
				(6, 8): {0: True},
				(6, 10): {0: True},
				(7, 9): {0: True},
			},
			(6, 10): {
				(5, 10): {0: True},
				(6, 9): {0: True},
				(6, 11): {0: True},
				(7, 10): {0: True},
			},
			(6, 11): {
				(5, 11): {0: True},
				(6, 10): {0: True},
				(6, 12): {0: True},
				(7, 11): {0: True},
			},
			(6, 12): {
				(5, 12): {0: True},
				(6, 11): {0: True},
				(6, 13): {0: True},
				(7, 12): {0: True},
			},
			(6, 13): {
				(5, 13): {0: True},
				(6, 12): {0: True},
				(6, 14): {0: True},
				(7, 13): {0: True},
			},
			(6, 14): {
				(5, 14): {0: True},
				(6, 13): {0: True},
				(6, 15): {0: True},
				(7, 14): {0: True},
			},
			(6, 15): {
				(5, 15): {0: True},
				(6, 14): {0: True},
				(6, 16): {0: True},
				(7, 15): {0: True},
			},
			(6, 16): {
				(5, 16): {0: True},
				(6, 15): {0: True},
				(6, 17): {0: True},
				(7, 16): {0: True},
			},
			(6, 17): {
				(5, 17): {0: True},
				(6, 16): {0: True},
				(6, 18): {0: True},
				(7, 17): {0: True},
			},
			(6, 18): {
				(5, 18): {0: True},
				(6, 17): {0: True},
				(6, 19): {0: True},
				(7, 18): {0: True},
			},
			(6, 19): {
				(5, 19): {0: True},
				(6, 18): {0: True},
				(6, 20): {0: True},
				(7, 19): {0: True},
			},
			(6, 20): {
				(5, 20): {0: True},
				(6, 19): {0: True},
				(6, 21): {0: True},
				(7, 20): {0: True},
			},
			(6, 21): {
				(5, 21): {0: True},
				(6, 20): {0: True},
				(6, 22): {0: True},
				(7, 21): {0: True},
			},
			(6, 22): {
				(5, 22): {0: True},
				(6, 21): {0: True},
				(6, 23): {0: True},
				(7, 22): {0: True},
			},
			(6, 23): {
				(5, 23): {0: True},
				(6, 22): {0: True},
				(6, 24): {0: True},
				(7, 23): {0: True},
			},
			(6, 24): {
				(5, 24): {0: True},
				(6, 23): {0: True},
				(7, 24): {0: True},
			},
			(7, 0): {(6, 0): {0: True}, (7, 1): {0: True}, (8, 0): {0: True}},
			(7, 1): {
				(6, 1): {0: True},
				(7, 0): {0: True},
				(7, 2): {0: True},
				(8, 1): {0: True},
			},
			(7, 2): {
				(6, 2): {0: True},
				(7, 1): {0: True},
				(7, 3): {0: True},
				(8, 2): {0: True},
			},
			(7, 3): {
				(6, 3): {0: True},
				(7, 2): {0: True},
				(7, 4): {0: True},
				(8, 3): {0: True},
			},
			(7, 4): {
				(6, 4): {0: True},
				(7, 3): {0: True},
				(7, 5): {0: True},
				(8, 4): {0: True},
			},
			(7, 5): {
				(6, 5): {0: True},
				(7, 4): {0: True},
				(7, 6): {0: True},
				(8, 5): {0: True},
			},
			(7, 6): {
				(6, 6): {0: True},
				(7, 5): {0: True},
				(7, 7): {0: True},
				(8, 6): {0: True},
			},
			(7, 7): {
				(6, 7): {0: True},
				(7, 6): {0: True},
				(7, 8): {0: True},
				(8, 7): {0: True},
			},
			(7, 8): {
				(6, 8): {0: True},
				(7, 7): {0: True},
				(7, 9): {0: True},
				(8, 8): {0: True},
			},
			(7, 9): {
				(6, 9): {0: True},
				(7, 8): {0: True},
				(7, 10): {0: True},
				(8, 9): {0: True},
			},
			(7, 10): {
				(6, 10): {0: True},
				(7, 9): {0: True},
				(7, 11): {0: True},
				(8, 10): {0: True},
			},
			(7, 11): {
				(6, 11): {0: True},
				(7, 10): {0: True},
				(7, 12): {0: True},
				(8, 11): {0: True},
			},
			(7, 12): {
				(6, 12): {0: True},
				(7, 11): {0: True},
				(7, 13): {0: True},
				(8, 12): {0: True},
			},
			(7, 13): {
				(6, 13): {0: True},
				(7, 12): {0: True},
				(7, 14): {0: True},
				(8, 13): {0: True},
			},
			(7, 14): {
				(6, 14): {0: True},
				(7, 13): {0: True},
				(7, 15): {0: True},
				(8, 14): {0: True},
			},
			(7, 15): {
				(6, 15): {0: True},
				(7, 14): {0: True},
				(7, 16): {0: True},
				(8, 15): {0: True},
			},
			(7, 16): {
				(6, 16): {0: True},
				(7, 15): {0: True},
				(7, 17): {0: True},
				(8, 16): {0: True},
			},
			(7, 17): {
				(6, 17): {0: True},
				(7, 16): {0: True},
				(7, 18): {0: True},
				(8, 17): {0: True},
			},
			(7, 18): {
				(6, 18): {0: True},
				(7, 17): {0: True},
				(7, 19): {0: True},
				(8, 18): {0: True},
			},
			(7, 19): {
				(6, 19): {0: True},
				(7, 18): {0: True},
				(7, 20): {0: True},
				(8, 19): {0: True},
			},
			(7, 20): {
				(6, 20): {0: True},
				(7, 19): {0: True},
				(7, 21): {0: True},
				(8, 20): {0: True},
			},
			(7, 21): {
				(6, 21): {0: True},
				(7, 20): {0: True},
				(7, 22): {0: True},
				(8, 21): {0: True},
			},
			(7, 22): {
				(6, 22): {0: True},
				(7, 21): {0: True},
				(7, 23): {0: True},
				(8, 22): {0: True},
			},
			(7, 23): {
				(6, 23): {0: True},
				(7, 22): {0: True},
				(7, 24): {0: True},
				(8, 23): {0: True},
			},
			(7, 24): {
				(6, 24): {0: True},
				(7, 23): {0: True},
				(8, 24): {0: True},
			},
			(8, 0): {(7, 0): {0: True}, (8, 1): {0: True}, (9, 0): {0: True}},
			(8, 1): {
				(7, 1): {0: True},
				(8, 0): {0: True},
				(8, 2): {0: True},
				(9, 1): {0: True},
			},
			(8, 2): {
				(7, 2): {0: True},
				(8, 1): {0: True},
				(8, 3): {0: True},
				(9, 2): {0: True},
			},
			(8, 3): {
				(7, 3): {0: True},
				(8, 2): {0: True},
				(8, 4): {0: True},
				(9, 3): {0: True},
			},
			(8, 4): {
				(7, 4): {0: True},
				(8, 3): {0: True},
				(8, 5): {0: True},
				(9, 4): {0: True},
			},
			(8, 5): {
				(7, 5): {0: True},
				(8, 4): {0: True},
				(8, 6): {0: True},
				(9, 5): {0: True},
			},
			(8, 6): {
				(7, 6): {0: True},
				(8, 5): {0: True},
				(8, 7): {0: True},
				(9, 6): {0: True},
			},
			(8, 7): {
				(7, 7): {0: True},
				(8, 6): {0: True},
				(8, 8): {0: True},
				(9, 7): {0: True},
			},
			(8, 8): {
				(7, 8): {0: True},
				(8, 7): {0: True},
				(8, 9): {0: True},
				(9, 8): {0: True},
			},
			(8, 9): {
				(7, 9): {0: True},
				(8, 8): {0: True},
				(8, 10): {0: True},
				(9, 9): {0: True},
			},
			(8, 10): {
				(7, 10): {0: True},
				(8, 9): {0: True},
				(8, 11): {0: True},
				(9, 10): {0: True},
			},
			(8, 11): {
				(7, 11): {0: True},
				(8, 10): {0: True},
				(8, 12): {0: True},
				(9, 11): {0: True},
			},
			(8, 12): {
				(7, 12): {0: True},
				(8, 11): {0: True},
				(8, 13): {0: True},
				(9, 12): {0: True},
			},
			(8, 13): {
				(7, 13): {0: True},
				(8, 12): {0: True},
				(8, 14): {0: True},
				(9, 13): {0: True},
			},
			(8, 14): {
				(7, 14): {0: True},
				(8, 13): {0: True},
				(8, 15): {0: True},
				(9, 14): {0: True},
			},
			(8, 15): {
				(7, 15): {0: True},
				(8, 14): {0: True},
				(8, 16): {0: True},
				(9, 15): {0: True},
			},
			(8, 16): {
				(7, 16): {0: True},
				(8, 15): {0: True},
				(8, 17): {0: True},
				(9, 16): {0: True},
			},
			(8, 17): {
				(7, 17): {0: True},
				(8, 16): {0: True},
				(8, 18): {0: True},
				(9, 17): {0: True},
			},
			(8, 18): {
				(7, 18): {0: True},
				(8, 17): {0: True},
				(8, 19): {0: True},
				(9, 18): {0: True},
			},
			(8, 19): {
				(7, 19): {0: True},
				(8, 18): {0: True},
				(8, 20): {0: True},
				(9, 19): {0: True},
			},
			(8, 20): {
				(7, 20): {0: True},
				(8, 19): {0: True},
				(8, 21): {0: True},
				(9, 20): {0: True},
			},
			(8, 21): {
				(7, 21): {0: True},
				(8, 20): {0: True},
				(8, 22): {0: True},
				(9, 21): {0: True},
			},
			(8, 22): {
				(7, 22): {0: True},
				(8, 21): {0: True},
				(8, 23): {0: True},
				(9, 22): {0: True},
			},
			(8, 23): {
				(7, 23): {0: True},
				(8, 22): {0: True},
				(8, 24): {0: True},
				(9, 23): {0: True},
			},
			(8, 24): {
				(7, 24): {0: True},
				(8, 23): {0: True},
				(9, 24): {0: True},
			},
			(9, 0): {(8, 0): {0: True}, (9, 1): {0: True}, (10, 0): {0: True}},
			(9, 1): {
				(8, 1): {0: True},
				(9, 0): {0: True},
				(9, 2): {0: True},
				(10, 1): {0: True},
			},
			(9, 2): {
				(8, 2): {0: True},
				(9, 1): {0: True},
				(9, 3): {0: True},
				(10, 2): {0: True},
			},
			(9, 3): {
				(8, 3): {0: True},
				(9, 2): {0: True},
				(9, 4): {0: True},
				(10, 3): {0: True},
			},
			(9, 4): {
				(8, 4): {0: True},
				(9, 3): {0: True},
				(9, 5): {0: True},
				(10, 4): {0: True},
			},
			(9, 5): {
				(8, 5): {0: True},
				(9, 4): {0: True},
				(9, 6): {0: True},
				(10, 5): {0: True},
			},
			(9, 6): {
				(8, 6): {0: True},
				(9, 5): {0: True},
				(9, 7): {0: True},
				(10, 6): {0: True},
			},
			(9, 7): {
				(8, 7): {0: True},
				(9, 6): {0: True},
				(9, 8): {0: True},
				(10, 7): {0: True},
			},
			(9, 8): {
				(8, 8): {0: True},
				(9, 7): {0: True},
				(9, 9): {0: True},
				(10, 8): {0: True},
			},
			(9, 9): {
				(8, 9): {0: True},
				(9, 8): {0: True},
				(9, 10): {0: True},
				(10, 9): {0: True},
			},
			(9, 10): {
				(8, 10): {0: True},
				(9, 9): {0: True},
				(9, 11): {0: True},
				(10, 10): {0: True},
			},
			(9, 11): {
				(8, 11): {0: True},
				(9, 10): {0: True},
				(9, 12): {0: True},
				(10, 11): {0: True},
			},
			(9, 12): {
				(8, 12): {0: True},
				(9, 11): {0: True},
				(9, 13): {0: True},
				(10, 12): {0: True},
			},
			(9, 13): {
				(8, 13): {0: True},
				(9, 12): {0: True},
				(9, 14): {0: True},
				(10, 13): {0: True},
			},
			(9, 14): {
				(8, 14): {0: True},
				(9, 13): {0: True},
				(9, 15): {0: True},
				(10, 14): {0: True},
			},
			(9, 15): {
				(8, 15): {0: True},
				(9, 14): {0: True},
				(9, 16): {0: True},
				(10, 15): {0: True},
			},
			(9, 16): {
				(8, 16): {0: True},
				(9, 15): {0: True},
				(9, 17): {0: True},
				(10, 16): {0: True},
			},
			(9, 17): {
				(8, 17): {0: True},
				(9, 16): {0: True},
				(9, 18): {0: True},
				(10, 17): {0: True},
			},
			(9, 18): {
				(8, 18): {0: True},
				(9, 17): {0: True},
				(9, 19): {0: True},
				(10, 18): {0: True},
			},
			(9, 19): {
				(8, 19): {0: True},
				(9, 18): {0: True},
				(9, 20): {0: True},
				(10, 19): {0: True},
			},
			(9, 20): {
				(8, 20): {0: True},
				(9, 19): {0: True},
				(9, 21): {0: True},
				(10, 20): {0: True},
			},
			(9, 21): {
				(8, 21): {0: True},
				(9, 20): {0: True},
				(9, 22): {0: True},
				(10, 21): {0: True},
			},
			(9, 22): {
				(8, 22): {0: True},
				(9, 21): {0: True},
				(9, 23): {0: True},
				(10, 22): {0: True},
			},
			(9, 23): {
				(8, 23): {0: True},
				(9, 22): {0: True},
				(9, 24): {0: True},
				(10, 23): {0: True},
			},
			(9, 24): {
				(8, 24): {0: True},
				(9, 23): {0: True},
				(10, 24): {0: True},
			},
			(10, 0): {
				(9, 0): {0: True},
				(10, 1): {0: True},
				(11, 0): {0: True},
			},
			(10, 1): {
				(9, 1): {0: True},
				(10, 0): {0: True},
				(10, 2): {0: True},
				(11, 1): {0: True},
			},
			(10, 2): {
				(9, 2): {0: True},
				(10, 1): {0: True},
				(10, 3): {0: True},
				(11, 2): {0: True},
			},
			(10, 3): {
				(9, 3): {0: True},
				(10, 2): {0: True},
				(10, 4): {0: True},
				(11, 3): {0: True},
			},
			(10, 4): {
				(9, 4): {0: True},
				(10, 3): {0: True},
				(10, 5): {0: True},
				(11, 4): {0: True},
			},
			(10, 5): {
				(9, 5): {0: True},
				(10, 4): {0: True},
				(10, 6): {0: True},
				(11, 5): {0: True},
			},
			(10, 6): {
				(9, 6): {0: True},
				(10, 5): {0: True},
				(10, 7): {0: True},
				(11, 6): {0: True},
			},
			(10, 7): {
				(9, 7): {0: True},
				(10, 6): {0: True},
				(10, 8): {0: True},
				(11, 7): {0: True},
			},
			(10, 8): {
				(9, 8): {0: True},
				(10, 7): {0: True},
				(10, 9): {0: True},
				(11, 8): {0: True},
			},
			(10, 9): {
				(9, 9): {0: True},
				(10, 8): {0: True},
				(10, 10): {0: True},
				(11, 9): {0: True},
			},
			(10, 10): {
				(9, 10): {0: True},
				(10, 9): {0: True},
				(10, 11): {0: True},
				(11, 10): {0: True},
			},
			(10, 11): {
				(9, 11): {0: True},
				(10, 10): {0: True},
				(10, 12): {0: True},
				(11, 11): {0: True},
			},
			(10, 12): {
				(9, 12): {0: True},
				(10, 11): {0: True},
				(10, 13): {0: True},
				(11, 12): {0: True},
			},
			(10, 13): {
				(9, 13): {0: True},
				(10, 12): {0: True},
				(10, 14): {0: True},
				(11, 13): {0: True},
			},
			(10, 14): {
				(9, 14): {0: True},
				(10, 13): {0: True},
				(10, 15): {0: True},
				(11, 14): {0: True},
			},
			(10, 15): {
				(9, 15): {0: True},
				(10, 14): {0: True},
				(10, 16): {0: True},
				(11, 15): {0: True},
			},
			(10, 16): {
				(9, 16): {0: True},
				(10, 15): {0: True},
				(10, 17): {0: True},
				(11, 16): {0: True},
			},
			(10, 17): {
				(9, 17): {0: True},
				(10, 16): {0: True},
				(10, 18): {0: True},
				(11, 17): {0: True},
			},
			(10, 18): {
				(9, 18): {0: True},
				(10, 17): {0: True},
				(10, 19): {0: True},
				(11, 18): {0: True},
			},
			(10, 19): {
				(9, 19): {0: True},
				(10, 18): {0: True},
				(10, 20): {0: True},
				(11, 19): {0: True},
			},
			(10, 20): {
				(9, 20): {0: True},
				(10, 19): {0: True},
				(10, 21): {0: True},
				(11, 20): {0: True},
			},
			(10, 21): {
				(9, 21): {0: True},
				(10, 20): {0: True},
				(10, 22): {0: True},
				(11, 21): {0: True},
			},
			(10, 22): {
				(9, 22): {0: True},
				(10, 21): {0: True},
				(10, 23): {0: True},
				(11, 22): {0: True},
			},
			(10, 23): {
				(9, 23): {0: True},
				(10, 22): {0: True},
				(10, 24): {0: True},
				(11, 23): {0: True},
			},
			(10, 24): {
				(9, 24): {0: True},
				(10, 23): {0: True},
				(11, 24): {0: True},
			},
			(11, 0): {
				(10, 0): {0: True},
				(11, 1): {0: True},
				(12, 0): {0: True},
			},
			(11, 1): {
				(10, 1): {0: True},
				(11, 0): {0: True},
				(11, 2): {0: True},
				(12, 1): {0: True},
			},
			(11, 2): {
				(10, 2): {0: True},
				(11, 1): {0: True},
				(11, 3): {0: True},
				(12, 2): {0: True},
			},
			(11, 3): {
				(10, 3): {0: True},
				(11, 2): {0: True},
				(11, 4): {0: True},
				(12, 3): {0: True},
			},
			(11, 4): {
				(10, 4): {0: True},
				(11, 3): {0: True},
				(11, 5): {0: True},
				(12, 4): {0: True},
			},
			(11, 5): {
				(10, 5): {0: True},
				(11, 4): {0: True},
				(11, 6): {0: True},
				(12, 5): {0: True},
			},
			(11, 6): {
				(10, 6): {0: True},
				(11, 5): {0: True},
				(11, 7): {0: True},
				(12, 6): {0: True},
			},
			(11, 7): {
				(10, 7): {0: True},
				(11, 6): {0: True},
				(11, 8): {0: True},
				(12, 7): {0: True},
			},
			(11, 8): {
				(10, 8): {0: True},
				(11, 7): {0: True},
				(11, 9): {0: True},
				(12, 8): {0: True},
			},
			(11, 9): {
				(10, 9): {0: True},
				(11, 8): {0: True},
				(11, 10): {0: True},
				(12, 9): {0: True},
			},
			(11, 10): {
				(10, 10): {0: True},
				(11, 9): {0: True},
				(11, 11): {0: True},
				(12, 10): {0: True},
			},
			(11, 11): {
				(10, 11): {0: True},
				(11, 10): {0: True},
				(11, 12): {0: True},
				(12, 11): {0: True},
			},
			(11, 12): {
				(10, 12): {0: True},
				(11, 11): {0: True},
				(11, 13): {0: True},
				(12, 12): {0: True},
			},
			(11, 13): {
				(10, 13): {0: True},
				(11, 12): {0: True},
				(11, 14): {0: True},
				(12, 13): {0: True},
			},
			(11, 14): {
				(10, 14): {0: True},
				(11, 13): {0: True},
				(11, 15): {0: True},
				(12, 14): {0: True},
			},
			(11, 15): {
				(10, 15): {0: True},
				(11, 14): {0: True},
				(11, 16): {0: True},
				(12, 15): {0: True},
			},
			(11, 16): {
				(10, 16): {0: True},
				(11, 15): {0: True},
				(11, 17): {0: True},
				(12, 16): {0: True},
			},
			(11, 17): {
				(10, 17): {0: True},
				(11, 16): {0: True},
				(11, 18): {0: True},
				(12, 17): {0: True},
			},
			(11, 18): {
				(10, 18): {0: True},
				(11, 17): {0: True},
				(11, 19): {0: True},
				(12, 18): {0: True},
			},
			(11, 19): {
				(10, 19): {0: True},
				(11, 18): {0: True},
				(11, 20): {0: True},
				(12, 19): {0: True},
			},
			(11, 20): {
				(10, 20): {0: True},
				(11, 19): {0: True},
				(11, 21): {0: True},
				(12, 20): {0: True},
			},
			(11, 21): {
				(10, 21): {0: True},
				(11, 20): {0: True},
				(11, 22): {0: True},
				(12, 21): {0: True},
			},
			(11, 22): {
				(10, 22): {0: True},
				(11, 21): {0: True},
				(11, 23): {0: True},
				(12, 22): {0: True},
			},
			(11, 23): {
				(10, 23): {0: True},
				(11, 22): {0: True},
				(11, 24): {0: True},
				(12, 23): {0: True},
			},
			(11, 24): {
				(10, 24): {0: True},
				(11, 23): {0: True},
				(12, 24): {0: True},
			},
			(12, 0): {
				(11, 0): {0: True},
				(12, 1): {0: True},
				(13, 0): {0: True},
			},
			(12, 1): {
				(11, 1): {0: True},
				(12, 0): {0: True},
				(12, 2): {0: True},
				(13, 1): {0: True},
			},
			(12, 2): {
				(11, 2): {0: True},
				(12, 1): {0: True},
				(12, 3): {0: True},
				(13, 2): {0: True},
			},
			(12, 3): {
				(11, 3): {0: True},
				(12, 2): {0: True},
				(12, 4): {0: True},
				(13, 3): {0: True},
			},
			(12, 4): {
				(11, 4): {0: True},
				(12, 3): {0: True},
				(12, 5): {0: True},
				(13, 4): {0: True},
			},
			(12, 5): {
				(11, 5): {0: True},
				(12, 4): {0: True},
				(12, 6): {0: True},
				(13, 5): {0: True},
			},
			(12, 6): {
				(11, 6): {0: True},
				(12, 5): {0: True},
				(12, 7): {0: True},
				(13, 6): {0: True},
			},
			(12, 7): {
				(11, 7): {0: True},
				(12, 6): {0: True},
				(12, 8): {0: True},
				(13, 7): {0: True},
			},
			(12, 8): {
				(11, 8): {0: True},
				(12, 7): {0: True},
				(12, 9): {0: True},
				(13, 8): {0: True},
			},
			(12, 9): {
				(11, 9): {0: True},
				(12, 8): {0: True},
				(12, 10): {0: True},
				(13, 9): {0: True},
			},
			(12, 10): {
				(11, 10): {0: True},
				(12, 9): {0: True},
				(12, 11): {0: True},
				(13, 10): {0: True},
			},
			(12, 11): {
				(11, 11): {0: True},
				(12, 10): {0: True},
				(12, 12): {0: True},
				(13, 11): {0: True},
			},
			(12, 12): {
				(11, 12): {0: True},
				(12, 11): {0: True},
				(12, 13): {0: True},
				(13, 12): {0: True},
			},
			(12, 13): {
				(11, 13): {0: True},
				(12, 12): {0: True},
				(12, 14): {0: True},
				(13, 13): {0: True},
			},
			(12, 14): {
				(11, 14): {0: True},
				(12, 13): {0: True},
				(12, 15): {0: True},
				(13, 14): {0: True},
			},
			(12, 15): {
				(11, 15): {0: True},
				(12, 14): {0: True},
				(12, 16): {0: True},
				(13, 15): {0: True},
			},
			(12, 16): {
				(11, 16): {0: True},
				(12, 15): {0: True},
				(12, 17): {0: True},
				(13, 16): {0: True},
			},
			(12, 17): {
				(11, 17): {0: True},
				(12, 16): {0: True},
				(12, 18): {0: True},
				(13, 17): {0: True},
			},
			(12, 18): {
				(11, 18): {0: True},
				(12, 17): {0: True},
				(12, 19): {0: True},
				(13, 18): {0: True},
			},
			(12, 19): {
				(11, 19): {0: True},
				(12, 18): {0: True},
				(12, 20): {0: True},
				(13, 19): {0: True},
			},
			(12, 20): {
				(11, 20): {0: True},
				(12, 19): {0: True},
				(12, 21): {0: True},
				(13, 20): {0: True},
			},
			(12, 21): {
				(11, 21): {0: True},
				(12, 20): {0: True},
				(12, 22): {0: True},
				(13, 21): {0: True},
			},
			(12, 22): {
				(11, 22): {0: True},
				(12, 21): {0: True},
				(12, 23): {0: True},
				(13, 22): {0: True},
			},
			(12, 23): {
				(11, 23): {0: True},
				(12, 22): {0: True},
				(12, 24): {0: True},
				(13, 23): {0: True},
			},
			(12, 24): {
				(11, 24): {0: True},
				(12, 23): {0: True},
				(13, 24): {0: True},
			},
			(13, 0): {
				(12, 0): {0: True},
				(13, 1): {0: True},
				(14, 0): {0: True},
			},
			(13, 1): {
				(12, 1): {0: True},
				(13, 0): {0: True},
				(13, 2): {0: True},
				(14, 1): {0: True},
			},
			(13, 2): {
				(12, 2): {0: True},
				(13, 1): {0: True},
				(13, 3): {0: True},
				(14, 2): {0: True},
			},
			(13, 3): {
				(12, 3): {0: True},
				(13, 2): {0: True},
				(13, 4): {0: True},
				(14, 3): {0: True},
			},
			(13, 4): {
				(12, 4): {0: True},
				(13, 3): {0: True},
				(13, 5): {0: True},
				(14, 4): {0: True},
			},
			(13, 5): {
				(12, 5): {0: True},
				(13, 4): {0: True},
				(13, 6): {0: True},
				(14, 5): {0: True},
			},
			(13, 6): {
				(12, 6): {0: True},
				(13, 5): {0: True},
				(13, 7): {0: True},
				(14, 6): {0: True},
			},
			(13, 7): {
				(12, 7): {0: True},
				(13, 6): {0: True},
				(13, 8): {0: True},
				(14, 7): {0: True},
			},
			(13, 8): {
				(12, 8): {0: True},
				(13, 7): {0: True},
				(13, 9): {0: True},
				(14, 8): {0: True},
			},
			(13, 9): {
				(12, 9): {0: True},
				(13, 8): {0: True},
				(13, 10): {0: True},
				(14, 9): {0: True},
			},
			(13, 10): {
				(12, 10): {0: True},
				(13, 9): {0: True},
				(13, 11): {0: True},
				(14, 10): {0: True},
			},
			(13, 11): {
				(12, 11): {0: True},
				(13, 10): {0: True},
				(13, 12): {0: True},
				(14, 11): {0: True},
			},
			(13, 12): {
				(12, 12): {0: True},
				(13, 11): {0: True},
				(13, 13): {0: True},
				(14, 12): {0: True},
			},
			(13, 13): {
				(12, 13): {0: True},
				(13, 12): {0: True},
				(13, 14): {0: True},
				(14, 13): {0: True},
			},
			(13, 14): {
				(12, 14): {0: True},
				(13, 13): {0: True},
				(13, 15): {0: True},
				(14, 14): {0: True},
			},
			(13, 15): {
				(12, 15): {0: True},
				(13, 14): {0: True},
				(13, 16): {0: True},
				(14, 15): {0: True},
			},
			(13, 16): {
				(12, 16): {0: True},
				(13, 15): {0: True},
				(13, 17): {0: True},
				(14, 16): {0: True},
			},
			(13, 17): {
				(12, 17): {0: True},
				(13, 16): {0: True},
				(13, 18): {0: True},
				(14, 17): {0: True},
			},
			(13, 18): {
				(12, 18): {0: True},
				(13, 17): {0: True},
				(13, 19): {0: True},
				(14, 18): {0: True},
			},
			(13, 19): {
				(12, 19): {0: True},
				(13, 18): {0: True},
				(13, 20): {0: True},
				(14, 19): {0: True},
			},
			(13, 20): {
				(12, 20): {0: True},
				(13, 19): {0: True},
				(13, 21): {0: True},
				(14, 20): {0: True},
			},
			(13, 21): {
				(12, 21): {0: True},
				(13, 20): {0: True},
				(13, 22): {0: True},
				(14, 21): {0: True},
			},
			(13, 22): {
				(12, 22): {0: True},
				(13, 21): {0: True},
				(13, 23): {0: True},
				(14, 22): {0: True},
			},
			(13, 23): {
				(12, 23): {0: True},
				(13, 22): {0: True},
				(13, 24): {0: True},
				(14, 23): {0: True},
			},
			(13, 24): {
				(12, 24): {0: True},
				(13, 23): {0: True},
				(14, 24): {0: True},
			},
			(14, 0): {
				(13, 0): {0: True},
				(14, 1): {0: True},
				(15, 0): {0: True},
			},
			(14, 1): {
				(13, 1): {0: True},
				(14, 0): {0: True},
				(14, 2): {0: True},
				(15, 1): {0: True},
			},
			(14, 2): {
				(13, 2): {0: True},
				(14, 1): {0: True},
				(14, 3): {0: True},
				(15, 2): {0: True},
			},
			(14, 3): {
				(13, 3): {0: True},
				(14, 2): {0: True},
				(14, 4): {0: True},
				(15, 3): {0: True},
			},
			(14, 4): {
				(13, 4): {0: True},
				(14, 3): {0: True},
				(14, 5): {0: True},
				(15, 4): {0: True},
			},
			(14, 5): {
				(13, 5): {0: True},
				(14, 4): {0: True},
				(14, 6): {0: True},
				(15, 5): {0: True},
			},
			(14, 6): {
				(13, 6): {0: True},
				(14, 5): {0: True},
				(14, 7): {0: True},
				(15, 6): {0: True},
			},
			(14, 7): {
				(13, 7): {0: True},
				(14, 6): {0: True},
				(14, 8): {0: True},
				(15, 7): {0: True},
			},
			(14, 8): {
				(13, 8): {0: True},
				(14, 7): {0: True},
				(14, 9): {0: True},
				(15, 8): {0: True},
			},
			(14, 9): {
				(13, 9): {0: True},
				(14, 8): {0: True},
				(14, 10): {0: True},
				(15, 9): {0: True},
			},
			(14, 10): {
				(13, 10): {0: True},
				(14, 9): {0: True},
				(14, 11): {0: True},
				(15, 10): {0: True},
			},
			(14, 11): {
				(13, 11): {0: True},
				(14, 10): {0: True},
				(14, 12): {0: True},
				(15, 11): {0: True},
			},
			(14, 12): {
				(13, 12): {0: True},
				(14, 11): {0: True},
				(14, 13): {0: True},
				(15, 12): {0: True},
			},
			(14, 13): {
				(13, 13): {0: True},
				(14, 12): {0: True},
				(14, 14): {0: True},
				(15, 13): {0: True},
			},
			(14, 14): {
				(13, 14): {0: True},
				(14, 13): {0: True},
				(14, 15): {0: True},
				(15, 14): {0: True},
			},
			(14, 15): {
				(13, 15): {0: True},
				(14, 14): {0: True},
				(14, 16): {0: True},
				(15, 15): {0: True},
			},
			(14, 16): {
				(13, 16): {0: True},
				(14, 15): {0: True},
				(14, 17): {0: True},
				(15, 16): {0: True},
			},
			(14, 17): {
				(13, 17): {0: True},
				(14, 16): {0: True},
				(14, 18): {0: True},
				(15, 17): {0: True},
			},
			(14, 18): {
				(13, 18): {0: True},
				(14, 17): {0: True},
				(14, 19): {0: True},
				(15, 18): {0: True},
			},
			(14, 19): {
				(13, 19): {0: True},
				(14, 18): {0: True},
				(14, 20): {0: True},
				(15, 19): {0: True},
			},
			(14, 20): {
				(13, 20): {0: True},
				(14, 19): {0: True},
				(14, 21): {0: True},
				(15, 20): {0: True},
			},
			(14, 21): {
				(13, 21): {0: True},
				(14, 20): {0: True},
				(14, 22): {0: True},
				(15, 21): {0: True},
			},
			(14, 22): {
				(13, 22): {0: True},
				(14, 21): {0: True},
				(14, 23): {0: True},
				(15, 22): {0: True},
			},
			(14, 23): {
				(13, 23): {0: True},
				(14, 22): {0: True},
				(14, 24): {0: True},
				(15, 23): {0: True},
			},
			(14, 24): {
				(13, 24): {0: True},
				(14, 23): {0: True},
				(15, 24): {0: True},
			},
			(15, 0): {
				(14, 0): {0: True},
				(15, 1): {0: True},
				(16, 0): {0: True},
			},
			(15, 1): {
				(14, 1): {0: True},
				(15, 0): {0: True},
				(15, 2): {0: True},
				(16, 1): {0: True},
			},
			(15, 2): {
				(14, 2): {0: True},
				(15, 1): {0: True},
				(15, 3): {0: True},
				(16, 2): {0: True},
			},
			(15, 3): {
				(14, 3): {0: True},
				(15, 2): {0: True},
				(15, 4): {0: True},
				(16, 3): {0: True},
			},
			(15, 4): {
				(14, 4): {0: True},
				(15, 3): {0: True},
				(15, 5): {0: True},
				(16, 4): {0: True},
			},
			(15, 5): {
				(14, 5): {0: True},
				(15, 4): {0: True},
				(15, 6): {0: True},
				(16, 5): {0: True},
			},
			(15, 6): {
				(14, 6): {0: True},
				(15, 5): {0: True},
				(15, 7): {0: True},
				(16, 6): {0: True},
			},
			(15, 7): {
				(14, 7): {0: True},
				(15, 6): {0: True},
				(15, 8): {0: True},
				(16, 7): {0: True},
			},
			(15, 8): {
				(14, 8): {0: True},
				(15, 7): {0: True},
				(15, 9): {0: True},
				(16, 8): {0: True},
			},
			(15, 9): {
				(14, 9): {0: True},
				(15, 8): {0: True},
				(15, 10): {0: True},
				(16, 9): {0: True},
			},
			(15, 10): {
				(14, 10): {0: True},
				(15, 9): {0: True},
				(15, 11): {0: True},
				(16, 10): {0: True},
			},
			(15, 11): {
				(14, 11): {0: True},
				(15, 10): {0: True},
				(15, 12): {0: True},
				(16, 11): {0: True},
			},
			(15, 12): {
				(14, 12): {0: True},
				(15, 11): {0: True},
				(15, 13): {0: True},
				(16, 12): {0: True},
			},
			(15, 13): {
				(14, 13): {0: True},
				(15, 12): {0: True},
				(15, 14): {0: True},
				(16, 13): {0: True},
			},
			(15, 14): {
				(14, 14): {0: True},
				(15, 13): {0: True},
				(15, 15): {0: True},
				(16, 14): {0: True},
			},
			(15, 15): {
				(14, 15): {0: True},
				(15, 14): {0: True},
				(15, 16): {0: True},
				(16, 15): {0: True},
			},
			(15, 16): {
				(14, 16): {0: True},
				(15, 15): {0: True},
				(15, 17): {0: True},
				(16, 16): {0: True},
			},
			(15, 17): {
				(14, 17): {0: True},
				(15, 16): {0: True},
				(15, 18): {0: True},
				(16, 17): {0: True},
			},
			(15, 18): {
				(14, 18): {0: True},
				(15, 17): {0: True},
				(15, 19): {0: True},
				(16, 18): {0: True},
			},
			(15, 19): {
				(14, 19): {0: True},
				(15, 18): {0: True},
				(15, 20): {0: True},
				(16, 19): {0: True},
			},
			(15, 20): {
				(14, 20): {0: True},
				(15, 19): {0: True},
				(15, 21): {0: True},
				(16, 20): {0: True},
			},
			(15, 21): {
				(14, 21): {0: True},
				(15, 20): {0: True},
				(15, 22): {0: True},
				(16, 21): {0: True},
			},
			(15, 22): {
				(14, 22): {0: True},
				(15, 21): {0: True},
				(15, 23): {0: True},
				(16, 22): {0: True},
			},
			(15, 23): {
				(14, 23): {0: True},
				(15, 22): {0: True},
				(15, 24): {0: True},
				(16, 23): {0: True},
			},
			(15, 24): {
				(14, 24): {0: True},
				(15, 23): {0: True},
				(16, 24): {0: True},
			},
			(16, 0): {
				(15, 0): {0: True},
				(16, 1): {0: True},
				(17, 0): {0: True},
			},
			(16, 1): {
				(15, 1): {0: True},
				(16, 0): {0: True},
				(16, 2): {0: True},
				(17, 1): {0: True},
			},
			(16, 2): {
				(15, 2): {0: True},
				(16, 1): {0: True},
				(16, 3): {0: True},
				(17, 2): {0: True},
			},
			(16, 3): {
				(15, 3): {0: True},
				(16, 2): {0: True},
				(16, 4): {0: True},
				(17, 3): {0: True},
			},
			(16, 4): {
				(15, 4): {0: True},
				(16, 3): {0: True},
				(16, 5): {0: True},
				(17, 4): {0: True},
			},
			(16, 5): {
				(15, 5): {0: True},
				(16, 4): {0: True},
				(16, 6): {0: True},
				(17, 5): {0: True},
			},
			(16, 6): {
				(15, 6): {0: True},
				(16, 5): {0: True},
				(16, 7): {0: True},
				(17, 6): {0: True},
			},
			(16, 7): {
				(15, 7): {0: True},
				(16, 6): {0: True},
				(16, 8): {0: True},
				(17, 7): {0: True},
			},
			(16, 8): {
				(15, 8): {0: True},
				(16, 7): {0: True},
				(16, 9): {0: True},
				(17, 8): {0: True},
			},
			(16, 9): {
				(15, 9): {0: True},
				(16, 8): {0: True},
				(16, 10): {0: True},
				(17, 9): {0: True},
			},
			(16, 10): {
				(15, 10): {0: True},
				(16, 9): {0: True},
				(16, 11): {0: True},
				(17, 10): {0: True},
			},
			(16, 11): {
				(15, 11): {0: True},
				(16, 10): {0: True},
				(16, 12): {0: True},
				(17, 11): {0: True},
			},
			(16, 12): {
				(15, 12): {0: True},
				(16, 11): {0: True},
				(16, 13): {0: True},
				(17, 12): {0: True},
			},
			(16, 13): {
				(15, 13): {0: True},
				(16, 12): {0: True},
				(16, 14): {0: True},
				(17, 13): {0: True},
			},
			(16, 14): {
				(15, 14): {0: True},
				(16, 13): {0: True},
				(16, 15): {0: True},
				(17, 14): {0: True},
			},
			(16, 15): {
				(15, 15): {0: True},
				(16, 14): {0: True},
				(16, 16): {0: True},
				(17, 15): {0: True},
			},
			(16, 16): {
				(15, 16): {0: True},
				(16, 15): {0: True},
				(16, 17): {0: True},
				(17, 16): {0: True},
			},
			(16, 17): {
				(15, 17): {0: True},
				(16, 16): {0: True},
				(16, 18): {0: True},
				(17, 17): {0: True},
			},
			(16, 18): {
				(15, 18): {0: True},
				(16, 17): {0: True},
				(16, 19): {0: True},
				(17, 18): {0: True},
			},
			(16, 19): {
				(15, 19): {0: True},
				(16, 18): {0: True},
				(16, 20): {0: True},
				(17, 19): {0: True},
			},
			(16, 20): {
				(15, 20): {0: True},
				(16, 19): {0: True},
				(16, 21): {0: True},
				(17, 20): {0: True},
			},
			(16, 21): {
				(15, 21): {0: True},
				(16, 20): {0: True},
				(16, 22): {0: True},
				(17, 21): {0: True},
			},
			(16, 22): {
				(15, 22): {0: True},
				(16, 21): {0: True},
				(16, 23): {0: True},
				(17, 22): {0: True},
			},
			(16, 23): {
				(15, 23): {0: True},
				(16, 22): {0: True},
				(16, 24): {0: True},
				(17, 23): {0: True},
			},
			(16, 24): {
				(15, 24): {0: True},
				(16, 23): {0: True},
				(17, 24): {0: True},
			},
			(17, 0): {
				(16, 0): {0: True},
				(17, 1): {0: True},
				(18, 0): {0: True},
			},
			(17, 1): {
				(16, 1): {0: True},
				(17, 0): {0: True},
				(17, 2): {0: True},
				(18, 1): {0: True},
			},
			(17, 2): {
				(16, 2): {0: True},
				(17, 1): {0: True},
				(17, 3): {0: True},
				(18, 2): {0: True},
			},
			(17, 3): {
				(16, 3): {0: True},
				(17, 2): {0: True},
				(17, 4): {0: True},
				(18, 3): {0: True},
			},
			(17, 4): {
				(16, 4): {0: True},
				(17, 3): {0: True},
				(17, 5): {0: True},
				(18, 4): {0: True},
			},
			(17, 5): {
				(16, 5): {0: True},
				(17, 4): {0: True},
				(17, 6): {0: True},
				(18, 5): {0: True},
			},
			(17, 6): {
				(16, 6): {0: True},
				(17, 5): {0: True},
				(17, 7): {0: True},
				(18, 6): {0: True},
			},
			(17, 7): {
				(16, 7): {0: True},
				(17, 6): {0: True},
				(17, 8): {0: True},
				(18, 7): {0: True},
			},
			(17, 8): {
				(16, 8): {0: True},
				(17, 7): {0: True},
				(17, 9): {0: True},
				(18, 8): {0: True},
			},
			(17, 9): {
				(16, 9): {0: True},
				(17, 8): {0: True},
				(17, 10): {0: True},
				(18, 9): {0: True},
			},
			(17, 10): {
				(16, 10): {0: True},
				(17, 9): {0: True},
				(17, 11): {0: True},
				(18, 10): {0: True},
			},
			(17, 11): {
				(16, 11): {0: True},
				(17, 10): {0: True},
				(17, 12): {0: True},
				(18, 11): {0: True},
			},
			(17, 12): {
				(16, 12): {0: True},
				(17, 11): {0: True},
				(17, 13): {0: True},
				(18, 12): {0: True},
			},
			(17, 13): {
				(16, 13): {0: True},
				(17, 12): {0: True},
				(17, 14): {0: True},
				(18, 13): {0: True},
			},
			(17, 14): {
				(16, 14): {0: True},
				(17, 13): {0: True},
				(17, 15): {0: True},
				(18, 14): {0: True},
			},
			(17, 15): {
				(16, 15): {0: True},
				(17, 14): {0: True},
				(17, 16): {0: True},
				(18, 15): {0: True},
			},
			(17, 16): {
				(16, 16): {0: True},
				(17, 15): {0: True},
				(17, 17): {0: True},
				(18, 16): {0: True},
			},
			(17, 17): {
				(16, 17): {0: True},
				(17, 16): {0: True},
				(17, 18): {0: True},
				(18, 17): {0: True},
			},
			(17, 18): {
				(16, 18): {0: True},
				(17, 17): {0: True},
				(17, 19): {0: True},
				(18, 18): {0: True},
			},
			(17, 19): {
				(16, 19): {0: True},
				(17, 18): {0: True},
				(17, 20): {0: True},
				(18, 19): {0: True},
			},
			(17, 20): {
				(16, 20): {0: True},
				(17, 19): {0: True},
				(17, 21): {0: True},
				(18, 20): {0: True},
			},
			(17, 21): {
				(16, 21): {0: True},
				(17, 20): {0: True},
				(17, 22): {0: True},
				(18, 21): {0: True},
			},
			(17, 22): {
				(16, 22): {0: True},
				(17, 21): {0: True},
				(17, 23): {0: True},
				(18, 22): {0: True},
			},
			(17, 23): {
				(16, 23): {0: True},
				(17, 22): {0: True},
				(17, 24): {0: True},
				(18, 23): {0: True},
			},
			(17, 24): {
				(16, 24): {0: True},
				(17, 23): {0: True},
				(18, 24): {0: True},
			},
			(18, 0): {
				(17, 0): {0: True},
				(18, 1): {0: True},
				(19, 0): {0: True},
			},
			(18, 1): {
				(17, 1): {0: True},
				(18, 0): {0: True},
				(18, 2): {0: True},
				(19, 1): {0: True},
			},
			(18, 2): {
				(17, 2): {0: True},
				(18, 1): {0: True},
				(18, 3): {0: True},
				(19, 2): {0: True},
			},
			(18, 3): {
				(17, 3): {0: True},
				(18, 2): {0: True},
				(18, 4): {0: True},
				(19, 3): {0: True},
			},
			(18, 4): {
				(17, 4): {0: True},
				(18, 3): {0: True},
				(18, 5): {0: True},
				(19, 4): {0: True},
			},
			(18, 5): {
				(17, 5): {0: True},
				(18, 4): {0: True},
				(18, 6): {0: True},
				(19, 5): {0: True},
			},
			(18, 6): {
				(17, 6): {0: True},
				(18, 5): {0: True},
				(18, 7): {0: True},
				(19, 6): {0: True},
			},
			(18, 7): {
				(17, 7): {0: True},
				(18, 6): {0: True},
				(18, 8): {0: True},
				(19, 7): {0: True},
			},
			(18, 8): {
				(17, 8): {0: True},
				(18, 7): {0: True},
				(18, 9): {0: True},
				(19, 8): {0: True},
			},
			(18, 9): {
				(17, 9): {0: True},
				(18, 8): {0: True},
				(18, 10): {0: True},
				(19, 9): {0: True},
			},
			(18, 10): {
				(17, 10): {0: True},
				(18, 9): {0: True},
				(18, 11): {0: True},
				(19, 10): {0: True},
			},
			(18, 11): {
				(17, 11): {0: True},
				(18, 10): {0: True},
				(18, 12): {0: True},
				(19, 11): {0: True},
			},
			(18, 12): {
				(17, 12): {0: True},
				(18, 11): {0: True},
				(18, 13): {0: True},
				(19, 12): {0: True},
			},
			(18, 13): {
				(17, 13): {0: True},
				(18, 12): {0: True},
				(18, 14): {0: True},
				(19, 13): {0: True},
			},
			(18, 14): {
				(17, 14): {0: True},
				(18, 13): {0: True},
				(18, 15): {0: True},
				(19, 14): {0: True},
			},
			(18, 15): {
				(17, 15): {0: True},
				(18, 14): {0: True},
				(18, 16): {0: True},
				(19, 15): {0: True},
			},
			(18, 16): {
				(17, 16): {0: True},
				(18, 15): {0: True},
				(18, 17): {0: True},
				(19, 16): {0: True},
			},
			(18, 17): {
				(17, 17): {0: True},
				(18, 16): {0: True},
				(18, 18): {0: True},
				(19, 17): {0: True},
			},
			(18, 18): {
				(17, 18): {0: True},
				(18, 17): {0: True},
				(18, 19): {0: True},
				(19, 18): {0: True},
			},
			(18, 19): {
				(17, 19): {0: True},
				(18, 18): {0: True},
				(18, 20): {0: True},
				(19, 19): {0: True},
			},
			(18, 20): {
				(17, 20): {0: True},
				(18, 19): {0: True},
				(18, 21): {0: True},
				(19, 20): {0: True},
			},
			(18, 21): {
				(17, 21): {0: True},
				(18, 20): {0: True},
				(18, 22): {0: True},
				(19, 21): {0: True},
			},
			(18, 22): {
				(17, 22): {0: True},
				(18, 21): {0: True},
				(18, 23): {0: True},
				(19, 22): {0: True},
			},
			(18, 23): {
				(17, 23): {0: True},
				(18, 22): {0: True},
				(18, 24): {0: True},
				(19, 23): {0: True},
			},
			(18, 24): {
				(17, 24): {0: True},
				(18, 23): {0: True},
				(19, 24): {0: True},
			},
			(19, 0): {
				(18, 0): {0: True},
				(19, 1): {0: True},
				(20, 0): {0: True},
			},
			(19, 1): {
				(18, 1): {0: True},
				(19, 0): {0: True},
				(19, 2): {0: True},
				(20, 1): {0: True},
			},
			(19, 2): {
				(18, 2): {0: True},
				(19, 1): {0: True},
				(19, 3): {0: True},
				(20, 2): {0: True},
			},
			(19, 3): {
				(18, 3): {0: True},
				(19, 2): {0: True},
				(19, 4): {0: True},
				(20, 3): {0: True},
			},
			(19, 4): {
				(18, 4): {0: True},
				(19, 3): {0: True},
				(19, 5): {0: True},
				(20, 4): {0: True},
			},
			(19, 5): {
				(18, 5): {0: True},
				(19, 4): {0: True},
				(19, 6): {0: True},
				(20, 5): {0: True},
			},
			(19, 6): {
				(18, 6): {0: True},
				(19, 5): {0: True},
				(19, 7): {0: True},
				(20, 6): {0: True},
			},
			(19, 7): {
				(18, 7): {0: True},
				(19, 6): {0: True},
				(19, 8): {0: True},
				(20, 7): {0: True},
			},
			(19, 8): {
				(18, 8): {0: True},
				(19, 7): {0: True},
				(19, 9): {0: True},
				(20, 8): {0: True},
			},
			(19, 9): {
				(18, 9): {0: True},
				(19, 8): {0: True},
				(19, 10): {0: True},
				(20, 9): {0: True},
			},
			(19, 10): {
				(18, 10): {0: True},
				(19, 9): {0: True},
				(19, 11): {0: True},
				(20, 10): {0: True},
			},
			(19, 11): {
				(18, 11): {0: True},
				(19, 10): {0: True},
				(19, 12): {0: True},
				(20, 11): {0: True},
			},
			(19, 12): {
				(18, 12): {0: True},
				(19, 11): {0: True},
				(19, 13): {0: True},
				(20, 12): {0: True},
			},
			(19, 13): {
				(18, 13): {0: True},
				(19, 12): {0: True},
				(19, 14): {0: True},
				(20, 13): {0: True},
			},
			(19, 14): {
				(18, 14): {0: True},
				(19, 13): {0: True},
				(19, 15): {0: True},
				(20, 14): {0: True},
			},
			(19, 15): {
				(18, 15): {0: True},
				(19, 14): {0: True},
				(19, 16): {0: True},
				(20, 15): {0: True},
			},
			(19, 16): {
				(18, 16): {0: True},
				(19, 15): {0: True},
				(19, 17): {0: True},
				(20, 16): {0: True},
			},
			(19, 17): {
				(18, 17): {0: True},
				(19, 16): {0: True},
				(19, 18): {0: True},
				(20, 17): {0: True},
			},
			(19, 18): {
				(18, 18): {0: True},
				(19, 17): {0: True},
				(19, 19): {0: True},
				(20, 18): {0: True},
			},
			(19, 19): {
				(18, 19): {0: True},
				(19, 18): {0: True},
				(19, 20): {0: True},
				(20, 19): {0: True},
			},
			(19, 20): {
				(18, 20): {0: True},
				(19, 19): {0: True},
				(19, 21): {0: True},
				(20, 20): {0: True},
			},
			(19, 21): {
				(18, 21): {0: True},
				(19, 20): {0: True},
				(19, 22): {0: True},
				(20, 21): {0: True},
			},
			(19, 22): {
				(18, 22): {0: True},
				(19, 21): {0: True},
				(19, 23): {0: True},
				(20, 22): {0: True},
			},
			(19, 23): {
				(18, 23): {0: True},
				(19, 22): {0: True},
				(19, 24): {0: True},
				(20, 23): {0: True},
			},
			(19, 24): {
				(18, 24): {0: True},
				(19, 23): {0: True},
				(20, 24): {0: True},
			},
			(20, 0): {
				(19, 0): {0: True},
				(20, 1): {0: True},
				(21, 0): {0: True},
			},
			(20, 1): {
				(19, 1): {0: True},
				(20, 0): {0: True},
				(20, 2): {0: True},
				(21, 1): {0: True},
			},
			(20, 2): {
				(19, 2): {0: True},
				(20, 1): {0: True},
				(20, 3): {0: True},
				(21, 2): {0: True},
			},
			(20, 3): {
				(19, 3): {0: True},
				(20, 2): {0: True},
				(20, 4): {0: True},
				(21, 3): {0: True},
			},
			(20, 4): {
				(19, 4): {0: True},
				(20, 3): {0: True},
				(20, 5): {0: True},
				(21, 4): {0: True},
			},
			(20, 5): {
				(19, 5): {0: True},
				(20, 4): {0: True},
				(20, 6): {0: True},
				(21, 5): {0: True},
			},
			(20, 6): {
				(19, 6): {0: True},
				(20, 5): {0: True},
				(20, 7): {0: True},
				(21, 6): {0: True},
			},
			(20, 7): {
				(19, 7): {0: True},
				(20, 6): {0: True},
				(20, 8): {0: True},
				(21, 7): {0: True},
			},
			(20, 8): {
				(19, 8): {0: True},
				(20, 7): {0: True},
				(20, 9): {0: True},
				(21, 8): {0: True},
			},
			(20, 9): {
				(19, 9): {0: True},
				(20, 8): {0: True},
				(20, 10): {0: True},
				(21, 9): {0: True},
			},
			(20, 10): {
				(19, 10): {0: True},
				(20, 9): {0: True},
				(20, 11): {0: True},
				(21, 10): {0: True},
			},
			(20, 11): {
				(19, 11): {0: True},
				(20, 10): {0: True},
				(20, 12): {0: True},
				(21, 11): {0: True},
			},
			(20, 12): {
				(19, 12): {0: True},
				(20, 11): {0: True},
				(20, 13): {0: True},
				(21, 12): {0: True},
			},
			(20, 13): {
				(19, 13): {0: True},
				(20, 12): {0: True},
				(20, 14): {0: True},
				(21, 13): {0: True},
			},
			(20, 14): {
				(19, 14): {0: True},
				(20, 13): {0: True},
				(20, 15): {0: True},
				(21, 14): {0: True},
			},
			(20, 15): {
				(19, 15): {0: True},
				(20, 14): {0: True},
				(20, 16): {0: True},
				(21, 15): {0: True},
			},
			(20, 16): {
				(19, 16): {0: True},
				(20, 15): {0: True},
				(20, 17): {0: True},
				(21, 16): {0: True},
			},
			(20, 17): {
				(19, 17): {0: True},
				(20, 16): {0: True},
				(20, 18): {0: True},
				(21, 17): {0: True},
			},
			(20, 18): {
				(19, 18): {0: True},
				(20, 17): {0: True},
				(20, 19): {0: True},
				(21, 18): {0: True},
			},
			(20, 19): {
				(19, 19): {0: True},
				(20, 18): {0: True},
				(20, 20): {0: True},
				(21, 19): {0: True},
			},
			(20, 20): {
				(19, 20): {0: True},
				(20, 19): {0: True},
				(20, 21): {0: True},
				(21, 20): {0: True},
			},
			(20, 21): {
				(19, 21): {0: True},
				(20, 20): {0: True},
				(20, 22): {0: True},
				(21, 21): {0: True},
			},
			(20, 22): {
				(19, 22): {0: True},
				(20, 21): {0: True},
				(20, 23): {0: True},
				(21, 22): {0: True},
			},
			(20, 23): {
				(19, 23): {0: True},
				(20, 22): {0: True},
				(20, 24): {0: True},
				(21, 23): {0: True},
			},
			(20, 24): {
				(19, 24): {0: True},
				(20, 23): {0: True},
				(21, 24): {0: True},
			},
			(21, 0): {
				(20, 0): {0: True},
				(21, 1): {0: True},
				(22, 0): {0: True},
			},
			(21, 1): {
				(20, 1): {0: True},
				(21, 0): {0: True},
				(21, 2): {0: True},
				(22, 1): {0: True},
			},
			(21, 2): {
				(20, 2): {0: True},
				(21, 1): {0: True},
				(21, 3): {0: True},
				(22, 2): {0: True},
			},
			(21, 3): {
				(20, 3): {0: True},
				(21, 2): {0: True},
				(21, 4): {0: True},
				(22, 3): {0: True},
			},
			(21, 4): {
				(20, 4): {0: True},
				(21, 3): {0: True},
				(21, 5): {0: True},
				(22, 4): {0: True},
			},
			(21, 5): {
				(20, 5): {0: True},
				(21, 4): {0: True},
				(21, 6): {0: True},
				(22, 5): {0: True},
			},
			(21, 6): {
				(20, 6): {0: True},
				(21, 5): {0: True},
				(21, 7): {0: True},
				(22, 6): {0: True},
			},
			(21, 7): {
				(20, 7): {0: True},
				(21, 6): {0: True},
				(21, 8): {0: True},
				(22, 7): {0: True},
			},
			(21, 8): {
				(20, 8): {0: True},
				(21, 7): {0: True},
				(21, 9): {0: True},
				(22, 8): {0: True},
			},
			(21, 9): {
				(20, 9): {0: True},
				(21, 8): {0: True},
				(21, 10): {0: True},
				(22, 9): {0: True},
			},
			(21, 10): {
				(20, 10): {0: True},
				(21, 9): {0: True},
				(21, 11): {0: True},
				(22, 10): {0: True},
			},
			(21, 11): {
				(20, 11): {0: True},
				(21, 10): {0: True},
				(21, 12): {0: True},
				(22, 11): {0: True},
			},
			(21, 12): {
				(20, 12): {0: True},
				(21, 11): {0: True},
				(21, 13): {0: True},
				(22, 12): {0: True},
			},
			(21, 13): {
				(20, 13): {0: True},
				(21, 12): {0: True},
				(21, 14): {0: True},
				(22, 13): {0: True},
			},
			(21, 14): {
				(20, 14): {0: True},
				(21, 13): {0: True},
				(21, 15): {0: True},
				(22, 14): {0: True},
			},
			(21, 15): {
				(20, 15): {0: True},
				(21, 14): {0: True},
				(21, 16): {0: True},
				(22, 15): {0: True},
			},
			(21, 16): {
				(20, 16): {0: True},
				(21, 15): {0: True},
				(21, 17): {0: True},
				(22, 16): {0: True},
			},
			(21, 17): {
				(20, 17): {0: True},
				(21, 16): {0: True},
				(21, 18): {0: True},
				(22, 17): {0: True},
			},
			(21, 18): {
				(20, 18): {0: True},
				(21, 17): {0: True},
				(21, 19): {0: True},
				(22, 18): {0: True},
			},
			(21, 19): {
				(20, 19): {0: True},
				(21, 18): {0: True},
				(21, 20): {0: True},
				(22, 19): {0: True},
			},
			(21, 20): {
				(20, 20): {0: True},
				(21, 19): {0: True},
				(21, 21): {0: True},
				(22, 20): {0: True},
			},
			(21, 21): {
				(20, 21): {0: True},
				(21, 20): {0: True},
				(21, 22): {0: True},
				(22, 21): {0: True},
			},
			(21, 22): {
				(20, 22): {0: True},
				(21, 21): {0: True},
				(21, 23): {0: True},
				(22, 22): {0: True},
			},
			(21, 23): {
				(20, 23): {0: True},
				(21, 22): {0: True},
				(21, 24): {0: True},
				(22, 23): {0: True},
			},
			(21, 24): {
				(20, 24): {0: True},
				(21, 23): {0: True},
				(22, 24): {0: True},
			},
			(22, 0): {
				(21, 0): {0: True},
				(22, 1): {0: True},
				(23, 0): {0: True},
			},
			(22, 1): {
				(21, 1): {0: True},
				(22, 0): {0: True},
				(22, 2): {0: True},
				(23, 1): {0: True},
			},
			(22, 2): {
				(21, 2): {0: True},
				(22, 1): {0: True},
				(22, 3): {0: True},
				(23, 2): {0: True},
			},
			(22, 3): {
				(21, 3): {0: True},
				(22, 2): {0: True},
				(22, 4): {0: True},
				(23, 3): {0: True},
			},
			(22, 4): {
				(21, 4): {0: True},
				(22, 3): {0: True},
				(22, 5): {0: True},
				(23, 4): {0: True},
			},
			(22, 5): {
				(21, 5): {0: True},
				(22, 4): {0: True},
				(22, 6): {0: True},
				(23, 5): {0: True},
			},
			(22, 6): {
				(21, 6): {0: True},
				(22, 5): {0: True},
				(22, 7): {0: True},
				(23, 6): {0: True},
			},
			(22, 7): {
				(21, 7): {0: True},
				(22, 6): {0: True},
				(22, 8): {0: True},
				(23, 7): {0: True},
			},
			(22, 8): {
				(21, 8): {0: True},
				(22, 7): {0: True},
				(22, 9): {0: True},
				(23, 8): {0: True},
			},
			(22, 9): {
				(21, 9): {0: True},
				(22, 8): {0: True},
				(22, 10): {0: True},
				(23, 9): {0: True},
			},
			(22, 10): {
				(21, 10): {0: True},
				(22, 9): {0: True},
				(22, 11): {0: True},
				(23, 10): {0: True},
			},
			(22, 11): {
				(21, 11): {0: True},
				(22, 10): {0: True},
				(22, 12): {0: True},
				(23, 11): {0: True},
			},
			(22, 12): {
				(21, 12): {0: True},
				(22, 11): {0: True},
				(22, 13): {0: True},
				(23, 12): {0: True},
			},
			(22, 13): {
				(21, 13): {0: True},
				(22, 12): {0: True},
				(22, 14): {0: True},
				(23, 13): {0: True},
			},
			(22, 14): {
				(21, 14): {0: True},
				(22, 13): {0: True},
				(22, 15): {0: True},
				(23, 14): {0: True},
			},
			(22, 15): {
				(21, 15): {0: True},
				(22, 14): {0: True},
				(22, 16): {0: True},
				(23, 15): {0: True},
			},
			(22, 16): {
				(21, 16): {0: True},
				(22, 15): {0: True},
				(22, 17): {0: True},
				(23, 16): {0: True},
			},
			(22, 17): {
				(21, 17): {0: True},
				(22, 16): {0: True},
				(22, 18): {0: True},
				(23, 17): {0: True},
			},
			(22, 18): {
				(21, 18): {0: True},
				(22, 17): {0: True},
				(22, 19): {0: True},
				(23, 18): {0: True},
			},
			(22, 19): {
				(21, 19): {0: True},
				(22, 18): {0: True},
				(22, 20): {0: True},
				(23, 19): {0: True},
			},
			(22, 20): {
				(21, 20): {0: True},
				(22, 19): {0: True},
				(22, 21): {0: True},
				(23, 20): {0: True},
			},
			(22, 21): {
				(21, 21): {0: True},
				(22, 20): {0: True},
				(22, 22): {0: True},
				(23, 21): {0: True},
			},
			(22, 22): {
				(21, 22): {0: True},
				(22, 21): {0: True},
				(22, 23): {0: True},
				(23, 22): {0: True},
			},
			(22, 23): {
				(21, 23): {0: True},
				(22, 22): {0: True},
				(22, 24): {0: True},
				(23, 23): {0: True},
			},
			(22, 24): {
				(21, 24): {0: True},
				(22, 23): {0: True},
				(23, 24): {0: True},
			},
			(23, 0): {
				(22, 0): {0: True},
				(23, 1): {0: True},
				(24, 0): {0: True},
			},
			(23, 1): {
				(22, 1): {0: True},
				(23, 0): {0: True},
				(23, 2): {0: True},
				(24, 1): {0: True},
			},
			(23, 2): {
				(22, 2): {0: True},
				(23, 1): {0: True},
				(23, 3): {0: True},
				(24, 2): {0: True},
			},
			(23, 3): {
				(22, 3): {0: True},
				(23, 2): {0: True},
				(23, 4): {0: True},
				(24, 3): {0: True},
			},
			(23, 4): {
				(22, 4): {0: True},
				(23, 3): {0: True},
				(23, 5): {0: True},
				(24, 4): {0: True},
			},
			(23, 5): {
				(22, 5): {0: True},
				(23, 4): {0: True},
				(23, 6): {0: True},
				(24, 5): {0: True},
			},
			(23, 6): {
				(22, 6): {0: True},
				(23, 5): {0: True},
				(23, 7): {0: True},
				(24, 6): {0: True},
			},
			(23, 7): {
				(22, 7): {0: True},
				(23, 6): {0: True},
				(23, 8): {0: True},
				(24, 7): {0: True},
			},
			(23, 8): {
				(22, 8): {0: True},
				(23, 7): {0: True},
				(23, 9): {0: True},
				(24, 8): {0: True},
			},
			(23, 9): {
				(22, 9): {0: True},
				(23, 8): {0: True},
				(23, 10): {0: True},
				(24, 9): {0: True},
			},
			(23, 10): {
				(22, 10): {0: True},
				(23, 9): {0: True},
				(23, 11): {0: True},
				(24, 10): {0: True},
			},
			(23, 11): {
				(22, 11): {0: True},
				(23, 10): {0: True},
				(23, 12): {0: True},
				(24, 11): {0: True},
			},
			(23, 12): {
				(22, 12): {0: True},
				(23, 11): {0: True},
				(23, 13): {0: True},
				(24, 12): {0: True},
			},
			(23, 13): {
				(22, 13): {0: True},
				(23, 12): {0: True},
				(23, 14): {0: True},
				(24, 13): {0: True},
			},
			(23, 14): {
				(22, 14): {0: True},
				(23, 13): {0: True},
				(23, 15): {0: True},
				(24, 14): {0: True},
			},
			(23, 15): {
				(22, 15): {0: True},
				(23, 14): {0: True},
				(23, 16): {0: True},
				(24, 15): {0: True},
			},
			(23, 16): {
				(22, 16): {0: True},
				(23, 15): {0: True},
				(23, 17): {0: True},
				(24, 16): {0: True},
			},
			(23, 17): {
				(22, 17): {0: True},
				(23, 16): {0: True},
				(23, 18): {0: True},
				(24, 17): {0: True},
			},
			(23, 18): {
				(22, 18): {0: True},
				(23, 17): {0: True},
				(23, 19): {0: True},
				(24, 18): {0: True},
			},
			(23, 19): {
				(22, 19): {0: True},
				(23, 18): {0: True},
				(23, 20): {0: True},
				(24, 19): {0: True},
			},
			(23, 20): {
				(22, 20): {0: True},
				(23, 19): {0: True},
				(23, 21): {0: True},
				(24, 20): {0: True},
			},
			(23, 21): {
				(22, 21): {0: True},
				(23, 20): {0: True},
				(23, 22): {0: True},
				(24, 21): {0: True},
			},
			(23, 22): {
				(22, 22): {0: True},
				(23, 21): {0: True},
				(23, 23): {0: True},
				(24, 22): {0: True},
			},
			(23, 23): {
				(22, 23): {0: True},
				(23, 22): {0: True},
				(23, 24): {0: True},
				(24, 23): {0: True},
			},
			(23, 24): {
				(22, 24): {0: True},
				(23, 23): {0: True},
				(24, 24): {0: True},
			},
			(24, 0): {(23, 0): {0: True}, (24, 1): {0: True}},
			(24, 1): {
				(23, 1): {0: True},
				(24, 0): {0: True},
				(24, 2): {0: True},
			},
			(24, 2): {
				(23, 2): {0: True},
				(24, 1): {0: True},
				(24, 3): {0: True},
			},
			(24, 3): {
				(23, 3): {0: True},
				(24, 2): {0: True},
				(24, 4): {0: True},
			},
			(24, 4): {
				(23, 4): {0: True},
				(24, 3): {0: True},
				(24, 5): {0: True},
			},
			(24, 5): {
				(23, 5): {0: True},
				(24, 4): {0: True},
				(24, 6): {0: True},
			},
			(24, 6): {
				(23, 6): {0: True},
				(24, 5): {0: True},
				(24, 7): {0: True},
			},
			(24, 7): {
				(23, 7): {0: True},
				(24, 6): {0: True},
				(24, 8): {0: True},
			},
			(24, 8): {
				(23, 8): {0: True},
				(24, 7): {0: True},
				(24, 9): {0: True},
			},
			(24, 9): {
				(23, 9): {0: True},
				(24, 8): {0: True},
				(24, 10): {0: True},
			},
			(24, 10): {
				(23, 10): {0: True},
				(24, 9): {0: True},
				(24, 11): {0: True},
			},
			(24, 11): {
				(23, 11): {0: True},
				(24, 10): {0: True},
				(24, 12): {0: True},
			},
			(24, 12): {
				(23, 12): {0: True},
				(24, 11): {0: True},
				(24, 13): {0: True},
			},
			(24, 13): {
				(23, 13): {0: True},
				(24, 12): {0: True},
				(24, 14): {0: True},
			},
			(24, 14): {
				(23, 14): {0: True},
				(24, 13): {0: True},
				(24, 15): {0: True},
			},
			(24, 15): {
				(23, 15): {0: True},
				(24, 14): {0: True},
				(24, 16): {0: True},
			},
			(24, 16): {
				(23, 16): {0: True},
				(24, 15): {0: True},
				(24, 17): {0: True},
			},
			(24, 17): {
				(23, 17): {0: True},
				(24, 16): {0: True},
				(24, 18): {0: True},
			},
			(24, 18): {
				(23, 18): {0: True},
				(24, 17): {0: True},
				(24, 19): {0: True},
			},
			(24, 19): {
				(23, 19): {0: True},
				(24, 18): {0: True},
				(24, 20): {0: True},
			},
			(24, 20): {
				(23, 20): {0: True},
				(24, 19): {0: True},
				(24, 21): {0: True},
			},
			(24, 21): {
				(23, 21): {0: True},
				(24, 20): {0: True},
				(24, 22): {0: True},
			},
			(24, 22): {
				(23, 22): {0: True},
				(24, 21): {0: True},
				(24, 23): {0: True},
			},
			(24, 23): {
				(23, 23): {0: True},
				(24, 22): {0: True},
				(24, 24): {0: True},
			},
			(24, 24): {(23, 24): {0: True}, (24, 23): {0: True}},
		}
	},
	"graph_val": {
		"physical": {
			"bare_places": [
				(0, 1),
				(0, 2),
				(0, 3),
				(0, 4),
				(0, 6),
				(0, 8),
				(0, 10),
				(0, 12),
				(0, 13),
				(0, 14),
				(0, 16),
				(0, 20),
				(0, 21),
				(0, 24),
				(1, 0),
				(1, 4),
				(1, 8),
				(1, 10),
				(1, 14),
				(1, 15),
				(1, 16),
				(1, 17),
				(1, 18),
				(1, 20),
				(1, 24),
				(2, 1),
				(2, 2),
				(2, 6),
				(2, 8),
				(2, 9),
				(2, 14),
				(2, 17),
				(2, 18),
				(2, 19),
				(2, 20),
				(2, 22),
				(2, 23),
				(2, 24),
				(3, 8),
				(3, 9),
				(3, 10),
				(3, 11),
				(3, 15),
				(3, 17),
				(3, 20),
				(3, 21),
				(3, 22),
				(3, 24),
				(4, 1),
				(4, 2),
				(4, 3),
				(4, 6),
				(4, 8),
				(4, 9),
				(4, 10),
				(4, 14),
				(4, 16),
				(4, 18),
				(4, 21),
				(5, 4),
				(5, 8),
				(5, 9),
				(5, 11),
				(5, 16),
				(5, 18),
				(5, 19),
				(5, 20),
				(5, 24),
				(6, 0),
				(6, 1),
				(6, 2),
				(6, 9),
				(6, 11),
				(6, 15),
				(6, 17),
				(6, 23),
				(7, 4),
				(7, 6),
				(7, 9),
				(7, 10),
				(7, 11),
				(7, 12),
				(7, 14),
				(7, 16),
				(7, 17),
				(7, 19),
				(7, 23),
				(7, 24),
				(8, 0),
				(8, 1),
				(8, 2),
				(8, 6),
				(8, 8),
				(8, 10),
				(8, 12),
				(8, 15),
				(8, 18),
				(8, 19),
				(8, 21),
				(8, 22),
				(8, 23),
				(8, 24),
				(9, 0),
				(9, 1),
				(9, 2),
				(9, 4),
				(9, 5),
				(9, 6),
				(9, 8),
				(9, 11),
				(9, 15),
				(9, 16),
				(9, 17),
				(9, 18),
				(9, 20),
				(9, 21),
				(10, 0),
				(10, 1),
				(10, 2),
				(10, 3),
				(10, 4),
				(10, 5),
				(10, 6),
				(10, 7),
				(10, 10),
				(10, 11),
				(10, 14),
				(10, 15),
				(10, 16),
				(10, 17),
				(10, 19),
				(10, 20),
				(10, 21),
				(11, 0),
				(11, 1),
				(11, 3),
				(11, 4),
				(11, 5),
				(11, 10),
				(11, 11),
				(11, 12),
				(11, 13),
				(11, 14),
				(11, 15),
				(11, 18),
				(11, 20),
				(11, 22),
				(11, 23),
				(12, 1),
				(12, 2),
				(12, 3),
				(12, 4),
				(12, 5),
				(12, 7),
				(12, 8),
				(12, 9),
				(12, 10),
				(12, 14),
				(12, 17),
				(12, 19),
				(12, 20),
				(12, 21),
				(12, 22),
				(13, 1),
				(13, 2),
				(13, 5),
				(13, 6),
				(13, 7),
				(13, 12),
				(13, 13),
				(13, 14),
				(13, 15),
				(13, 17),
				(13, 18),
				(13, 20),
				(13, 23),
				(13, 24),
				(14, 1),
				(14, 5),
				(14, 7),
				(14, 10),
				(14, 12),
				(14, 15),
				(14, 17),
				(14, 19),
				(14, 23),
				(14, 24),
				(15, 1),
				(15, 3),
				(15, 4),
				(15, 6),
				(15, 7),
				(15, 8),
				(15, 10),
				(15, 12),
				(15, 14),
				(15, 15),
				(15, 18),
				(15, 19),
				(15, 20),
				(15, 22),
				(16, 0),
				(16, 3),
				(16, 5),
				(16, 7),
				(16, 9),
				(16, 11),
				(16, 12),
				(16, 13),
				(16, 17),
				(16, 18),
				(16, 20),
				(16, 22),
				(16, 24),
				(17, 4),
				(17, 6),
				(17, 7),
				(17, 8),
				(17, 10),
				(17, 13),
				(17, 14),
				(17, 15),
				(17, 16),
				(17, 17),
				(17, 20),
				(17, 21),
				(17, 22),
				(17, 23),
				(17, 24),
				(18, 3),
				(18, 4),
				(18, 6),
				(18, 9),
				(18, 11),
				(18, 13),
				(18, 16),
				(18, 17),
				(18, 18),
				(18, 20),
				(18, 21),
				(18, 23),
				(18, 24),
				(19, 0),
				(19, 1),
				(19, 2),
				(19, 3),
				(19, 8),
				(19, 9),
				(19, 10),
				(19, 11),
				(19, 17),
				(19, 19),
				(19, 20),
				(19, 21),
				(19, 24),
				(20, 6),
				(20, 8),
				(20, 9),
				(20, 11),
				(20, 12),
				(20, 16),
				(20, 18),
				(20, 19),
				(20, 21),
				(20, 23),
				(20, 24),
				(21, 1),
				(21, 4),
				(21, 6),
				(21, 7),
				(21, 8),
				(21, 14),
				(21, 16),
				(21, 17),
				(21, 21),
				(21, 22),
				(21, 23),
				(22, 4),
				(22, 6),
				(22, 7),
				(22, 8),
				(22, 10),
				(22, 11),
				(22, 13),
				(22, 15),
				(22, 17),
				(22, 20),
				(22, 21),
				(22, 24),
				(23, 0),
				(23, 1),
				(23, 2),
				(23, 7),
				(23, 8),
				(23, 11),
				(23, 12),
				(23, 13),
				(23, 15),
				(23, 18),
				(23, 19),
				(23, 20),
				(23, 21),
				(24, 0),
				(24, 2),
				(24, 3),
				(24, 4),
				(24, 9),
				(24, 11),
				(24, 13),
				(24, 14),
				(24, 15),
				(24, 19),
				(24, 22),
				(24, 23),
				(24, 24),
				(9, 13),
				(23, 22),
				(7, 21),
				(15, 16),
				(2, 12),
				(2, 21),
				(24, 16),
				(12, 6),
				(21, 13),
				(23, 17),
				(10, 13),
				(22, 22),
				(6, 21),
				(6, 12),
				(7, 0),
				(8, 20),
				(16, 16),
				(3, 12),
				(15, 17),
				(1, 21),
				(14, 2),
				(6, 6),
				(13, 0),
				(23, 16),
				(22, 23),
				(11, 6),
				(13, 22),
				(20, 13),
				(12, 15),
				(24, 17),
				(18, 14),
				(9, 23),
				(13, 11),
				(22, 14),
				(3, 16),
				(10, 12),
				(5, 21),
				(5, 12),
				(7, 1),
				(7, 20),
				(16, 15),
				(4, 12),
				(1, 22),
				(15, 2),
				(5, 6),
				(14, 0),
				(22, 16),
				(23, 23),
				(11, 7),
				(14, 22),
				(19, 13),
				(12, 16),
				(24, 18),
				(19, 14),
				(10, 23),
				(14, 11),
				(23, 14),
				(2, 16),
				(9, 12),
				(5, 22),
				(5, 13),
				(7, 2),
				(6, 20),
				(16, 14),
				(4, 13),
				(14, 18),
				(0, 22),
				(16, 2),
				(5, 7),
				(15, 0),
				(23, 24),
				(11, 8),
				(14, 21),
				(19, 12),
				(13, 16),
				(20, 14),
				(10, 24),
				(15, 11),
				(2, 15),
				(6, 22),
				(6, 13),
				(7, 3),
				(6, 19),
				(3, 13),
				(0, 23),
				(17, 2),
				(6, 7),
				(10, 8),
				(15, 21),
				(18, 12),
				(14, 16),
				(24, 20),
				(20, 15),
				(11, 24),
				(7, 22),
				(7, 13),
				(6, 3),
				(6, 18),
				(2, 13),
				(1, 23),
				(18, 2),
				(7, 7),
				(10, 9),
				(16, 21),
				(17, 12),
				(24, 21),
				(21, 15),
				(12, 24),
				(4, 15),
				(12, 12),
				(8, 13),
				(5, 3),
				(7, 18),
				(18, 15),
				(1, 13),
				(18, 1),
				(8, 7),
				(11, 9),
				(17, 11),
				(12, 23),
				(13, 10),
				(5, 15),
			],
			"wallpaper": "wallpape.jpg",
		},
		"sheep": {},
		"wolf": {
			"units": {
				"physical": {
					"wolf0": True,
					"wolf1": True,
					"wolf2": True,
					"wolf3": True,
					"wolf4": True,
					"wolf5": True,
					"wolf6": True,
					"wolf7": True,
					"wolf8": True,
					"wolf9": True,
				}
			}
		},
	},
	"node_val": {
		"physical": {
			(0, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.0,
				"bare": False,
				"name": (0, 0),
			},
			(0, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (0, 1),
			},
			(0, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (0, 2),
			},
			(0, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.1225,
				"bare": True,
				"name": (0, 3),
			},
			(0, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (0, 4),
			},
			(0, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (0, 5),
			},
			(0, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.245,
				"bare": True,
				"name": (0, 6),
			},
			(0, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (0, 7),
			},
			(0, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (0, 8),
			},
			(0, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.3675,
				"bare": False,
				"name": (0, 9),
			},
			(0, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (0, 10),
			},
			(0, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (0, 11),
			},
			(0, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.49,
				"bare": True,
				"name": (0, 12),
			},
			(0, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (0, 13),
			},
			(0, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (0, 14),
			},
			(0, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.6125,
				"bare": False,
				"name": (0, 15),
			},
			(0, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (0, 16),
			},
			(0, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (0, 17),
			},
			(0, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.735,
				"bare": False,
				"name": (0, 18),
			},
			(0, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (0, 19),
			},
			(0, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (0, 20),
			},
			(0, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (0, 21),
			},
			(0, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (0, 22),
			},
			(0, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (0, 23),
			},
			(0, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.98,
				"bare": True,
				"name": (0, 24),
			},
			(1, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.0,
				"bare": True,
				"name": (1, 0),
			},
			(1, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (1, 1),
			},
			(1, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (1, 2),
			},
			(1, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.1225,
				"bare": False,
				"name": (1, 3),
			},
			(1, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (1, 4),
			},
			(1, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (1, 5),
			},
			(1, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.245,
				"bare": False,
				"name": (1, 6),
			},
			(1, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (1, 7),
			},
			(1, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (1, 8),
			},
			(1, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.3675,
				"bare": False,
				"name": (1, 9),
			},
			(1, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (1, 10),
			},
			(1, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (1, 11),
			},
			(1, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.49,
				"bare": False,
				"name": (1, 12),
			},
			(1, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (1, 13),
			},
			(1, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (1, 14),
			},
			(1, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.6125,
				"bare": True,
				"name": (1, 15),
			},
			(1, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (1, 16),
			},
			(1, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (1, 17),
			},
			(1, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.735,
				"bare": True,
				"name": (1, 18),
			},
			(1, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (1, 19),
			},
			(1, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (1, 20),
			},
			(1, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.8574999999999999,
				"bare": False,
				"name": (1, 21),
			},
			(1, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (1, 22),
			},
			(1, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (1, 23),
			},
			(1, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.98,
				"bare": True,
				"name": (1, 24),
			},
			(2, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.0,
				"bare": False,
				"name": (2, 0),
			},
			(2, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (2, 1),
			},
			(2, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (2, 2),
			},
			(2, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.1225,
				"bare": False,
				"name": (2, 3),
			},
			(2, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (2, 4),
			},
			(2, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (2, 5),
			},
			(2, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.245,
				"bare": True,
				"name": (2, 6),
			},
			(2, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (2, 7),
			},
			(2, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (2, 8),
			},
			(2, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.3675,
				"bare": True,
				"name": (2, 9),
			},
			(2, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (2, 10),
			},
			(2, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (2, 11),
			},
			(2, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.49,
				"bare": False,
				"name": (2, 12),
			},
			(2, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (2, 13),
			},
			(2, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (2, 14),
			},
			(2, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.6125,
				"bare": False,
				"name": (2, 15),
			},
			(2, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (2, 16),
			},
			(2, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (2, 17),
			},
			(2, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.735,
				"bare": True,
				"name": (2, 18),
			},
			(2, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (2, 19),
			},
			(2, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (2, 20),
			},
			(2, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.8574999999999999,
				"bare": False,
				"name": (2, 21),
			},
			(2, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (2, 22),
			},
			(2, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (2, 23),
			},
			(2, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.98,
				"bare": True,
				"name": (2, 24),
			},
			(3, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.0,
				"bare": False,
				"name": (3, 0),
			},
			(3, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (3, 1),
			},
			(3, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (3, 2),
			},
			(3, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.1225,
				"bare": False,
				"name": (3, 3),
			},
			(3, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (3, 4),
			},
			(3, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (3, 5),
			},
			(3, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.245,
				"bare": False,
				"name": (3, 6),
			},
			(3, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (3, 7),
			},
			(3, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (3, 8),
			},
			(3, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.3675,
				"bare": True,
				"name": (3, 9),
			},
			(3, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (3, 10),
			},
			(3, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (3, 11),
			},
			(3, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.49,
				"bare": False,
				"name": (3, 12),
			},
			(3, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (3, 13),
			},
			(3, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (3, 14),
			},
			(3, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.6125,
				"bare": True,
				"name": (3, 15),
			},
			(3, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (3, 16),
			},
			(3, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (3, 17),
			},
			(3, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.735,
				"bare": False,
				"name": (3, 18),
			},
			(3, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (3, 19),
			},
			(3, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (3, 20),
			},
			(3, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (3, 21),
			},
			(3, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (3, 22),
			},
			(3, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (3, 23),
			},
			(3, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.98,
				"bare": True,
				"name": (3, 24),
			},
			(4, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.0,
				"bare": False,
				"name": (4, 0),
			},
			(4, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (4, 1),
			},
			(4, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (4, 2),
			},
			(4, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.1225,
				"bare": True,
				"name": (4, 3),
			},
			(4, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (4, 4),
			},
			(4, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (4, 5),
			},
			(4, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.245,
				"bare": True,
				"name": (4, 6),
			},
			(4, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (4, 7),
			},
			(4, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (4, 8),
			},
			(4, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.3675,
				"bare": True,
				"name": (4, 9),
			},
			(4, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (4, 10),
			},
			(4, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (4, 11),
			},
			(4, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.49,
				"bare": False,
				"name": (4, 12),
			},
			(4, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.5308333333333333,
				"bare": False,
				"name": (4, 13),
			},
			(4, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (4, 14),
			},
			(4, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.6125,
				"bare": True,
				"name": (4, 15),
			},
			(4, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (4, 16),
			},
			(4, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (4, 17),
			},
			(4, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.735,
				"bare": True,
				"name": (4, 18),
			},
			(4, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (4, 19),
			},
			(4, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.8166666666666667,
				"bare": False,
				"name": (4, 20),
			},
			(4, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (4, 21),
			},
			(4, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (4, 22),
			},
			(4, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (4, 23),
			},
			(4, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.98,
				"bare": False,
				"name": (4, 24),
			},
			(5, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.0,
				"bare": False,
				"name": (5, 0),
			},
			(5, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (5, 1),
			},
			(5, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (5, 2),
			},
			(5, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.1225,
				"bare": True,
				"name": (5, 3),
			},
			(5, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (5, 4),
			},
			(5, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (5, 5),
			},
			(5, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.245,
				"bare": False,
				"name": (5, 6),
			},
			(5, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (5, 7),
			},
			(5, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (5, 8),
			},
			(5, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.3675,
				"bare": True,
				"name": (5, 9),
			},
			(5, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (5, 10),
			},
			(5, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (5, 11),
			},
			(5, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.49,
				"bare": False,
				"name": (5, 12),
			},
			(5, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.5308333333333333,
				"bare": False,
				"name": (5, 13),
			},
			(5, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (5, 14),
			},
			(5, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.6125,
				"bare": True,
				"name": (5, 15),
			},
			(5, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (5, 16),
			},
			(5, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (5, 17),
			},
			(5, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.735,
				"bare": True,
				"name": (5, 18),
			},
			(5, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (5, 19),
			},
			(5, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (5, 20),
			},
			(5, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.8574999999999999,
				"bare": False,
				"name": (5, 21),
			},
			(5, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (5, 22),
			},
			(5, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (5, 23),
			},
			(5, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.98,
				"bare": True,
				"name": (5, 24),
			},
			(6, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.0,
				"bare": True,
				"name": (6, 0),
			},
			(6, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (6, 1),
			},
			(6, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (6, 2),
			},
			(6, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.1225,
				"bare": True,
				"name": (6, 3),
			},
			(6, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (6, 4),
			},
			(6, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (6, 5),
			},
			(6, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.245,
				"bare": False,
				"name": (6, 6),
			},
			(6, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (6, 7),
			},
			(6, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (6, 8),
			},
			(6, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.3675,
				"bare": True,
				"name": (6, 9),
			},
			(6, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (6, 10),
			},
			(6, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (6, 11),
			},
			(6, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.49,
				"bare": False,
				"name": (6, 12),
			},
			(6, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (6, 13),
			},
			(6, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (6, 14),
			},
			(6, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.6125,
				"bare": True,
				"name": (6, 15),
			},
			(6, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (6, 16),
			},
			(6, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (6, 17),
			},
			(6, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.735,
				"bare": True,
				"name": (6, 18),
			},
			(6, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (6, 19),
			},
			(6, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.8166666666666667,
				"bare": False,
				"name": (6, 20),
			},
			(6, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.8574999999999999,
				"bare": False,
				"name": (6, 21),
			},
			(6, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (6, 22),
			},
			(6, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (6, 23),
			},
			(6, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.98,
				"bare": False,
				"name": (6, 24),
			},
			(7, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.28583333333333333,
				"_y": 0.0,
				"bare": False,
				"name": (7, 0),
			},
			(7, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.28583333333333333,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (7, 1),
			},
			(7, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.28583333333333333,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (7, 2),
			},
			(7, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.1225,
				"bare": True,
				"name": (7, 3),
			},
			(7, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (7, 4),
			},
			(7, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.28583333333333333,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (7, 5),
			},
			(7, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.245,
				"bare": True,
				"name": (7, 6),
			},
			(7, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (7, 7),
			},
			(7, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.28583333333333333,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (7, 8),
			},
			(7, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.3675,
				"bare": True,
				"name": (7, 9),
			},
			(7, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (7, 10),
			},
			(7, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (7, 11),
			},
			(7, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.49,
				"bare": True,
				"name": (7, 12),
			},
			(7, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (7, 13),
			},
			(7, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (7, 14),
			},
			(7, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.28583333333333333,
				"_y": 0.6125,
				"bare": False,
				"name": (7, 15),
			},
			(7, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (7, 16),
			},
			(7, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (7, 17),
			},
			(7, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.735,
				"bare": True,
				"name": (7, 18),
			},
			(7, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (7, 19),
			},
			(7, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.28583333333333333,
				"_y": 0.8166666666666667,
				"bare": False,
				"name": (7, 20),
			},
			(7, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.28583333333333333,
				"_y": 0.8574999999999999,
				"bare": False,
				"name": (7, 21),
			},
			(7, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (7, 22),
			},
			(7, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (7, 23),
			},
			(7, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.98,
				"bare": True,
				"name": (7, 24),
			},
			(8, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.0,
				"bare": True,
				"name": (8, 0),
			},
			(8, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (8, 1),
			},
			(8, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (8, 2),
			},
			(8, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.1225,
				"bare": False,
				"name": (8, 3),
			},
			(8, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (8, 4),
			},
			(8, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (8, 5),
			},
			(8, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.245,
				"bare": True,
				"name": (8, 6),
			},
			(8, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (8, 7),
			},
			(8, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (8, 8),
			},
			(8, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.3675,
				"bare": False,
				"name": (8, 9),
			},
			(8, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (8, 10),
			},
			(8, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (8, 11),
			},
			(8, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.49,
				"bare": True,
				"name": (8, 12),
			},
			(8, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (8, 13),
			},
			(8, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (8, 14),
			},
			(8, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.6125,
				"bare": True,
				"name": (8, 15),
			},
			(8, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (8, 16),
			},
			(8, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (8, 17),
			},
			(8, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.735,
				"bare": True,
				"name": (8, 18),
			},
			(8, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (8, 19),
			},
			(8, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.8166666666666667,
				"bare": False,
				"name": (8, 20),
			},
			(8, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (8, 21),
			},
			(8, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (8, 22),
			},
			(8, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (8, 23),
			},
			(8, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.98,
				"bare": True,
				"name": (8, 24),
			},
			(9, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.0,
				"bare": True,
				"name": (9, 0),
			},
			(9, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (9, 1),
			},
			(9, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (9, 2),
			},
			(9, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.1225,
				"bare": False,
				"name": (9, 3),
			},
			(9, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (9, 4),
			},
			(9, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (9, 5),
			},
			(9, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.245,
				"bare": True,
				"name": (9, 6),
			},
			(9, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (9, 7),
			},
			(9, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (9, 8),
			},
			(9, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.3675,
				"bare": False,
				"name": (9, 9),
			},
			(9, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (9, 10),
			},
			(9, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (9, 11),
			},
			(9, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.49,
				"bare": False,
				"name": (9, 12),
			},
			(9, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.5308333333333333,
				"bare": False,
				"name": (9, 13),
			},
			(9, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (9, 14),
			},
			(9, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.6125,
				"bare": True,
				"name": (9, 15),
			},
			(9, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (9, 16),
			},
			(9, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (9, 17),
			},
			(9, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.735,
				"bare": True,
				"name": (9, 18),
			},
			(9, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (9, 19),
			},
			(9, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (9, 20),
			},
			(9, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (9, 21),
			},
			(9, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (9, 22),
			},
			(9, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (9, 23),
			},
			(9, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.98,
				"bare": False,
				"name": (9, 24),
			},
			(10, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.0,
				"bare": True,
				"name": (10, 0),
			},
			(10, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (10, 1),
			},
			(10, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (10, 2),
			},
			(10, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.1225,
				"bare": True,
				"name": (10, 3),
			},
			(10, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (10, 4),
			},
			(10, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (10, 5),
			},
			(10, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.245,
				"bare": True,
				"name": (10, 6),
			},
			(10, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (10, 7),
			},
			(10, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (10, 8),
			},
			(10, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.3675,
				"bare": True,
				"name": (10, 9),
			},
			(10, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (10, 10),
			},
			(10, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (10, 11),
			},
			(10, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.4083333333333333,
				"_y": 0.49,
				"bare": False,
				"name": (10, 12),
			},
			(10, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.4083333333333333,
				"_y": 0.5308333333333333,
				"bare": False,
				"name": (10, 13),
			},
			(10, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (10, 14),
			},
			(10, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.6125,
				"bare": True,
				"name": (10, 15),
			},
			(10, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (10, 16),
			},
			(10, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (10, 17),
			},
			(10, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.4083333333333333,
				"_y": 0.735,
				"bare": False,
				"name": (10, 18),
			},
			(10, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (10, 19),
			},
			(10, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (10, 20),
			},
			(10, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (10, 21),
			},
			(10, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (10, 22),
			},
			(10, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.4083333333333333,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (10, 23),
			},
			(10, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.4083333333333333,
				"_y": 0.98,
				"bare": False,
				"name": (10, 24),
			},
			(11, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.0,
				"bare": True,
				"name": (11, 0),
			},
			(11, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (11, 1),
			},
			(11, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.44916666666666666,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (11, 2),
			},
			(11, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.1225,
				"bare": True,
				"name": (11, 3),
			},
			(11, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (11, 4),
			},
			(11, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (11, 5),
			},
			(11, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.44916666666666666,
				"_y": 0.245,
				"bare": False,
				"name": (11, 6),
			},
			(11, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.44916666666666666,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (11, 7),
			},
			(11, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.44916666666666666,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (11, 8),
			},
			(11, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.3675,
				"bare": True,
				"name": (11, 9),
			},
			(11, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (11, 10),
			},
			(11, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (11, 11),
			},
			(11, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.49,
				"bare": True,
				"name": (11, 12),
			},
			(11, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (11, 13),
			},
			(11, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (11, 14),
			},
			(11, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.6125,
				"bare": True,
				"name": (11, 15),
			},
			(11, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.44916666666666666,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (11, 16),
			},
			(11, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.44916666666666666,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (11, 17),
			},
			(11, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.735,
				"bare": True,
				"name": (11, 18),
			},
			(11, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.44916666666666666,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (11, 19),
			},
			(11, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (11, 20),
			},
			(11, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.44916666666666666,
				"_y": 0.8574999999999999,
				"bare": False,
				"name": (11, 21),
			},
			(11, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (11, 22),
			},
			(11, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (11, 23),
			},
			(11, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.98,
				"bare": True,
				"name": (11, 24),
			},
			(12, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.49,
				"_y": 0.0,
				"bare": False,
				"name": (12, 0),
			},
			(12, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (12, 1),
			},
			(12, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (12, 2),
			},
			(12, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.1225,
				"bare": True,
				"name": (12, 3),
			},
			(12, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (12, 4),
			},
			(12, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (12, 5),
			},
			(12, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.49,
				"_y": 0.245,
				"bare": False,
				"name": (12, 6),
			},
			(12, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (12, 7),
			},
			(12, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (12, 8),
			},
			(12, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.3675,
				"bare": True,
				"name": (12, 9),
			},
			(12, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (12, 10),
			},
			(12, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.49,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (12, 11),
			},
			(12, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.49,
				"bare": True,
				"name": (12, 12),
			},
			(12, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.49,
				"_y": 0.5308333333333333,
				"bare": False,
				"name": (12, 13),
			},
			(12, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (12, 14),
			},
			(12, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.49,
				"_y": 0.6125,
				"bare": False,
				"name": (12, 15),
			},
			(12, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.49,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (12, 16),
			},
			(12, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (12, 17),
			},
			(12, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.49,
				"_y": 0.735,
				"bare": False,
				"name": (12, 18),
			},
			(12, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (12, 19),
			},
			(12, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (12, 20),
			},
			(12, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (12, 21),
			},
			(12, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (12, 22),
			},
			(12, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (12, 23),
			},
			(12, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.98,
				"bare": True,
				"name": (12, 24),
			},
			(13, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.0,
				"bare": False,
				"name": (13, 0),
			},
			(13, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (13, 1),
			},
			(13, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (13, 2),
			},
			(13, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.1225,
				"bare": False,
				"name": (13, 3),
			},
			(13, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (13, 4),
			},
			(13, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (13, 5),
			},
			(13, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.245,
				"bare": True,
				"name": (13, 6),
			},
			(13, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (13, 7),
			},
			(13, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (13, 8),
			},
			(13, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.3675,
				"bare": False,
				"name": (13, 9),
			},
			(13, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (13, 10),
			},
			(13, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (13, 11),
			},
			(13, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.49,
				"bare": True,
				"name": (13, 12),
			},
			(13, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (13, 13),
			},
			(13, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (13, 14),
			},
			(13, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.6125,
				"bare": True,
				"name": (13, 15),
			},
			(13, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (13, 16),
			},
			(13, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (13, 17),
			},
			(13, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.735,
				"bare": True,
				"name": (13, 18),
			},
			(13, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (13, 19),
			},
			(13, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (13, 20),
			},
			(13, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.8574999999999999,
				"bare": False,
				"name": (13, 21),
			},
			(13, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (13, 22),
			},
			(13, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (13, 23),
			},
			(13, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.98,
				"bare": True,
				"name": (13, 24),
			},
			(14, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.0,
				"bare": False,
				"name": (14, 0),
			},
			(14, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (14, 1),
			},
			(14, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (14, 2),
			},
			(14, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.1225,
				"bare": False,
				"name": (14, 3),
			},
			(14, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (14, 4),
			},
			(14, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (14, 5),
			},
			(14, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.245,
				"bare": False,
				"name": (14, 6),
			},
			(14, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (14, 7),
			},
			(14, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (14, 8),
			},
			(14, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.3675,
				"bare": False,
				"name": (14, 9),
			},
			(14, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (14, 10),
			},
			(14, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (14, 11),
			},
			(14, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.49,
				"bare": True,
				"name": (14, 12),
			},
			(14, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.5308333333333333,
				"bare": False,
				"name": (14, 13),
			},
			(14, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (14, 14),
			},
			(14, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.6125,
				"bare": True,
				"name": (14, 15),
			},
			(14, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (14, 16),
			},
			(14, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (14, 17),
			},
			(14, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.735,
				"bare": False,
				"name": (14, 18),
			},
			(14, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (14, 19),
			},
			(14, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.8166666666666667,
				"bare": False,
				"name": (14, 20),
			},
			(14, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.8574999999999999,
				"bare": False,
				"name": (14, 21),
			},
			(14, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (14, 22),
			},
			(14, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (14, 23),
			},
			(14, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.98,
				"bare": True,
				"name": (14, 24),
			},
			(15, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.0,
				"bare": False,
				"name": (15, 0),
			},
			(15, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (15, 1),
			},
			(15, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (15, 2),
			},
			(15, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.1225,
				"bare": True,
				"name": (15, 3),
			},
			(15, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (15, 4),
			},
			(15, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (15, 5),
			},
			(15, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.245,
				"bare": True,
				"name": (15, 6),
			},
			(15, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (15, 7),
			},
			(15, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (15, 8),
			},
			(15, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.3675,
				"bare": False,
				"name": (15, 9),
			},
			(15, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (15, 10),
			},
			(15, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (15, 11),
			},
			(15, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.49,
				"bare": True,
				"name": (15, 12),
			},
			(15, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.5308333333333333,
				"bare": False,
				"name": (15, 13),
			},
			(15, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (15, 14),
			},
			(15, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.6125,
				"bare": True,
				"name": (15, 15),
			},
			(15, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (15, 16),
			},
			(15, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (15, 17),
			},
			(15, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.735,
				"bare": True,
				"name": (15, 18),
			},
			(15, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (15, 19),
			},
			(15, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (15, 20),
			},
			(15, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (15, 21),
			},
			(15, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (15, 22),
			},
			(15, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (15, 23),
			},
			(15, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.98,
				"bare": False,
				"name": (15, 24),
			},
			(16, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.0,
				"bare": True,
				"name": (16, 0),
			},
			(16, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (16, 1),
			},
			(16, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (16, 2),
			},
			(16, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.1225,
				"bare": True,
				"name": (16, 3),
			},
			(16, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (16, 4),
			},
			(16, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (16, 5),
			},
			(16, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.245,
				"bare": False,
				"name": (16, 6),
			},
			(16, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (16, 7),
			},
			(16, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (16, 8),
			},
			(16, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.3675,
				"bare": True,
				"name": (16, 9),
			},
			(16, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (16, 10),
			},
			(16, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (16, 11),
			},
			(16, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.49,
				"bare": True,
				"name": (16, 12),
			},
			(16, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (16, 13),
			},
			(16, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (16, 14),
			},
			(16, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.6125,
				"bare": False,
				"name": (16, 15),
			},
			(16, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (16, 16),
			},
			(16, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (16, 17),
			},
			(16, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.735,
				"bare": True,
				"name": (16, 18),
			},
			(16, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (16, 19),
			},
			(16, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (16, 20),
			},
			(16, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (16, 21),
			},
			(16, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (16, 22),
			},
			(16, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (16, 23),
			},
			(16, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.98,
				"bare": True,
				"name": (16, 24),
			},
			(17, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6941666666666666,
				"_y": 0.0,
				"bare": False,
				"name": (17, 0),
			},
			(17, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (17, 1),
			},
			(17, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (17, 2),
			},
			(17, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6941666666666666,
				"_y": 0.1225,
				"bare": False,
				"name": (17, 3),
			},
			(17, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (17, 4),
			},
			(17, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6941666666666666,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (17, 5),
			},
			(17, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.245,
				"bare": True,
				"name": (17, 6),
			},
			(17, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (17, 7),
			},
			(17, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (17, 8),
			},
			(17, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6941666666666666,
				"_y": 0.3675,
				"bare": False,
				"name": (17, 9),
			},
			(17, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (17, 10),
			},
			(17, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (17, 11),
			},
			(17, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.49,
				"bare": True,
				"name": (17, 12),
			},
			(17, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (17, 13),
			},
			(17, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (17, 14),
			},
			(17, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.6125,
				"bare": True,
				"name": (17, 15),
			},
			(17, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (17, 16),
			},
			(17, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (17, 17),
			},
			(17, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6941666666666666,
				"_y": 0.735,
				"bare": False,
				"name": (17, 18),
			},
			(17, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6941666666666666,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (17, 19),
			},
			(17, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (17, 20),
			},
			(17, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (17, 21),
			},
			(17, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (17, 22),
			},
			(17, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (17, 23),
			},
			(17, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.98,
				"bare": True,
				"name": (17, 24),
			},
			(18, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.0,
				"bare": False,
				"name": (18, 0),
			},
			(18, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (18, 1),
			},
			(18, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (18, 2),
			},
			(18, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.1225,
				"bare": True,
				"name": (18, 3),
			},
			(18, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (18, 4),
			},
			(18, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (18, 5),
			},
			(18, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.245,
				"bare": True,
				"name": (18, 6),
			},
			(18, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (18, 7),
			},
			(18, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (18, 8),
			},
			(18, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.3675,
				"bare": True,
				"name": (18, 9),
			},
			(18, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (18, 10),
			},
			(18, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (18, 11),
			},
			(18, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.49,
				"bare": True,
				"name": (18, 12),
			},
			(18, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (18, 13),
			},
			(18, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (18, 14),
			},
			(18, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.6125,
				"bare": True,
				"name": (18, 15),
			},
			(18, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (18, 16),
			},
			(18, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (18, 17),
			},
			(18, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.735,
				"bare": True,
				"name": (18, 18),
			},
			(18, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (18, 19),
			},
			(18, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (18, 20),
			},
			(18, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (18, 21),
			},
			(18, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (18, 22),
			},
			(18, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (18, 23),
			},
			(18, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.98,
				"bare": True,
				"name": (18, 24),
			},
			(19, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.0,
				"bare": True,
				"name": (19, 0),
			},
			(19, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (19, 1),
			},
			(19, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (19, 2),
			},
			(19, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.1225,
				"bare": True,
				"name": (19, 3),
			},
			(19, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (19, 4),
			},
			(19, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (19, 5),
			},
			(19, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.245,
				"bare": False,
				"name": (19, 6),
			},
			(19, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (19, 7),
			},
			(19, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (19, 8),
			},
			(19, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.3675,
				"bare": True,
				"name": (19, 9),
			},
			(19, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (19, 10),
			},
			(19, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (19, 11),
			},
			(19, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.49,
				"bare": False,
				"name": (19, 12),
			},
			(19, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.5308333333333333,
				"bare": False,
				"name": (19, 13),
			},
			(19, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (19, 14),
			},
			(19, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.6125,
				"bare": False,
				"name": (19, 15),
			},
			(19, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (19, 16),
			},
			(19, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (19, 17),
			},
			(19, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.735,
				"bare": False,
				"name": (19, 18),
			},
			(19, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (19, 19),
			},
			(19, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (19, 20),
			},
			(19, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (19, 21),
			},
			(19, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (19, 22),
			},
			(19, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (19, 23),
			},
			(19, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.98,
				"bare": True,
				"name": (19, 24),
			},
			(20, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.0,
				"bare": False,
				"name": (20, 0),
			},
			(20, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (20, 1),
			},
			(20, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (20, 2),
			},
			(20, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.1225,
				"bare": False,
				"name": (20, 3),
			},
			(20, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (20, 4),
			},
			(20, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (20, 5),
			},
			(20, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.245,
				"bare": True,
				"name": (20, 6),
			},
			(20, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (20, 7),
			},
			(20, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (20, 8),
			},
			(20, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.3675,
				"bare": True,
				"name": (20, 9),
			},
			(20, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (20, 10),
			},
			(20, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (20, 11),
			},
			(20, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.49,
				"bare": True,
				"name": (20, 12),
			},
			(20, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.5308333333333333,
				"bare": False,
				"name": (20, 13),
			},
			(20, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (20, 14),
			},
			(20, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.6125,
				"bare": True,
				"name": (20, 15),
			},
			(20, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (20, 16),
			},
			(20, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (20, 17),
			},
			(20, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.735,
				"bare": True,
				"name": (20, 18),
			},
			(20, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (20, 19),
			},
			(20, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.8166666666666667,
				"bare": False,
				"name": (20, 20),
			},
			(20, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (20, 21),
			},
			(20, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.196,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (20, 22),
			},
			(20, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (20, 23),
			},
			(20, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.196,
				"_y": 0.98,
				"bare": True,
				"name": (20, 24),
			},
			(21, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.0,
				"bare": False,
				"name": (21, 0),
			},
			(21, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (21, 1),
			},
			(21, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (21, 2),
			},
			(21, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.1225,
				"bare": False,
				"name": (21, 3),
			},
			(21, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (21, 4),
			},
			(21, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (21, 5),
			},
			(21, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.245,
				"bare": True,
				"name": (21, 6),
			},
			(21, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (21, 7),
			},
			(21, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (21, 8),
			},
			(21, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.3675,
				"bare": False,
				"name": (21, 9),
			},
			(21, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (21, 10),
			},
			(21, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (21, 11),
			},
			(21, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.49,
				"bare": False,
				"name": (21, 12),
			},
			(21, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.5308333333333333,
				"bare": False,
				"name": (21, 13),
			},
			(21, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (21, 14),
			},
			(21, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.6125,
				"bare": True,
				"name": (21, 15),
			},
			(21, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (21, 16),
			},
			(21, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (21, 17),
			},
			(21, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.735,
				"bare": False,
				"name": (21, 18),
			},
			(21, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (21, 19),
			},
			(21, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.8166666666666667,
				"bare": False,
				"name": (21, 20),
			},
			(21, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (21, 21),
			},
			(21, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (21, 22),
			},
			(21, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.392,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (21, 23),
			},
			(21, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.392,
				"_y": 0.98,
				"bare": False,
				"name": (21, 24),
			},
			(22, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.0,
				"bare": False,
				"name": (22, 0),
			},
			(22, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (22, 1),
			},
			(22, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (22, 2),
			},
			(22, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.1225,
				"bare": False,
				"name": (22, 3),
			},
			(22, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (22, 4),
			},
			(22, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (22, 5),
			},
			(22, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.245,
				"bare": True,
				"name": (22, 6),
			},
			(22, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (22, 7),
			},
			(22, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (22, 8),
			},
			(22, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.3675,
				"bare": False,
				"name": (22, 9),
			},
			(22, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (22, 10),
			},
			(22, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (22, 11),
			},
			(22, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.49,
				"bare": False,
				"name": (22, 12),
			},
			(22, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (22, 13),
			},
			(22, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (22, 14),
			},
			(22, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.6125,
				"bare": True,
				"name": (22, 15),
			},
			(22, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (22, 16),
			},
			(22, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (22, 17),
			},
			(22, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.735,
				"bare": False,
				"name": (22, 18),
			},
			(22, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (22, 19),
			},
			(22, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (22, 20),
			},
			(22, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (22, 21),
			},
			(22, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (22, 22),
			},
			(22, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5880000000000001,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (22, 23),
			},
			(22, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5880000000000001,
				"_y": 0.98,
				"bare": True,
				"name": (22, 24),
			},
			(23, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.0,
				"bare": True,
				"name": (23, 0),
			},
			(23, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (23, 1),
			},
			(23, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (23, 2),
			},
			(23, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.1225,
				"bare": False,
				"name": (23, 3),
			},
			(23, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (23, 4),
			},
			(23, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (23, 5),
			},
			(23, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.245,
				"bare": False,
				"name": (23, 6),
			},
			(23, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (23, 7),
			},
			(23, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (23, 8),
			},
			(23, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.3675,
				"bare": False,
				"name": (23, 9),
			},
			(23, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (23, 10),
			},
			(23, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (23, 11),
			},
			(23, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.49,
				"bare": True,
				"name": (23, 12),
			},
			(23, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (23, 13),
			},
			(23, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (23, 14),
			},
			(23, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.6125,
				"bare": True,
				"name": (23, 15),
			},
			(23, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (23, 16),
			},
			(23, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (23, 17),
			},
			(23, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.735,
				"bare": True,
				"name": (23, 18),
			},
			(23, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (23, 19),
			},
			(23, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (23, 20),
			},
			(23, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.784,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (23, 21),
			},
			(23, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (23, 22),
			},
			(23, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (23, 23),
			},
			(23, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.784,
				"_y": 0.98,
				"bare": False,
				"name": (23, 24),
			},
			(24, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.0,
				"bare": True,
				"name": (24, 0),
			},
			(24, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (24, 1),
			},
			(24, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (24, 2),
			},
			(24, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.1225,
				"bare": True,
				"name": (24, 3),
			},
			(24, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (24, 4),
			},
			(24, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (24, 5),
			},
			(24, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.245,
				"bare": False,
				"name": (24, 6),
			},
			(24, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (24, 7),
			},
			(24, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (24, 8),
			},
			(24, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.3675,
				"bare": True,
				"name": (24, 9),
			},
			(24, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (24, 10),
			},
			(24, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (24, 11),
			},
			(24, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.49,
				"bare": False,
				"name": (24, 12),
			},
			(24, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (24, 13),
			},
			(24, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (24, 14),
			},
			(24, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.6125,
				"bare": True,
				"name": (24, 15),
			},
			(24, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.6533333333333333,
				"bare": False,
				"name": (24, 16),
			},
			(24, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (24, 17),
			},
			(24, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.735,
				"bare": False,
				"name": (24, 18),
			},
			(24, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (24, 19),
			},
			(24, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (24, 20),
			},
			(24, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (24, 21),
			},
			(24, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (24, 22),
			},
			(24, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (24, 23),
			},
			(24, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.98,
				"bare": True,
				"name": (24, 24),
			},
			"wolf0": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (19, 5),
				"name": "wolf0",
			},
			"wolf1": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (9, 14),
				"name": "wolf1",
			},
			"wolf2": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (20, 2),
				"name": "wolf2",
			},
			"wolf3": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (23, 22),
				"name": "wolf3",
			},
			"wolf4": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (23, 17),
				"name": "wolf4",
			},
			"wolf5": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (12, 9),
				"name": "wolf5",
			},
			"wolf6": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (5, 3),
				"name": "wolf6",
			},
			"wolf7": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (15, 16),
				"name": "wolf7",
			},
			"wolf8": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (1, 22),
				"name": "wolf8",
			},
			"wolf9": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (18, 20),
				"name": "wolf9",
			},
			"sheep0": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (12, 13),
				"name": "sheep0",
			},
			"sheep1": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (22, 20),
				"name": "sheep1",
			},
			"sheep2": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (17, 0),
				"name": "sheep2",
			},
			"sheep3": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (15, 16),
				"name": "sheep3",
			},
			"sheep4": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (23, 22),
				"name": "sheep4",
			},
			"sheep5": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (21, 15),
				"name": "sheep5",
			},
			"sheep6": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (11, 23),
				"name": "sheep6",
			},
			"sheep7": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (12, 10),
				"name": "sheep7",
			},
			"sheep9": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (5, 14),
				"name": "sheep9",
			},
			"sheep10": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (7, 22),
				"name": "sheep10",
			},
			"sheep11": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (9, 13),
				"name": "sheep11",
			},
			"sheep12": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (5, 2),
				"name": "sheep12",
			},
			"sheep13": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (8, 18),
				"name": "sheep13",
			},
			"sheep14": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (19, 15),
				"name": "sheep14",
			},
			"sheep15": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (1, 12),
				"name": "sheep15",
			},
			"sheep16": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (11, 17),
				"name": "sheep16",
			},
			"sheep17": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (1, 23),
				"name": "sheep17",
			},
			"sheep18": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (17, 1),
				"name": "sheep18",
			},
			"sheep19": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (9, 7),
				"name": "sheep19",
			},
			"sheep20": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (22, 15),
				"name": "sheep20",
			},
			"sheep21": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (24, 23),
				"name": "sheep21",
			},
			"sheep22": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (10, 9),
				"name": "sheep22",
			},
			"sheep23": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (18, 21),
				"name": "sheep23",
			},
			"sheep24": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (18, 11),
				"name": "sheep24",
			},
		}
	},
	"nodes": {
		"physical": {
			(0, 0): True,
			(0, 1): True,
			(0, 2): True,
			(0, 3): True,
			(0, 4): True,
			(0, 5): True,
			(0, 6): True,
			(0, 7): True,
			(0, 8): True,
			(0, 9): True,
			(0, 10): True,
			(0, 11): True,
			(0, 12): True,
			(0, 13): True,
			(0, 14): True,
			(0, 15): True,
			(0, 16): True,
			(0, 17): True,
			(0, 18): True,
			(0, 19): True,
			(0, 20): True,
			(0, 21): True,
			(0, 22): True,
			(0, 23): True,
			(0, 24): True,
			(1, 0): True,
			(1, 1): True,
			(1, 2): True,
			(1, 3): True,
			(1, 4): True,
			(1, 5): True,
			(1, 6): True,
			(1, 7): True,
			(1, 8): True,
			(1, 9): True,
			(1, 10): True,
			(1, 11): True,
			(1, 12): True,
			(1, 13): True,
			(1, 14): True,
			(1, 15): True,
			(1, 16): True,
			(1, 17): True,
			(1, 18): True,
			(1, 19): True,
			(1, 20): True,
			(1, 21): True,
			(1, 22): True,
			(1, 23): True,
			(1, 24): True,
			(2, 0): True,
			(2, 1): True,
			(2, 2): True,
			(2, 3): True,
			(2, 4): True,
			(2, 5): True,
			(2, 6): True,
			(2, 7): True,
			(2, 8): True,
			(2, 9): True,
			(2, 10): True,
			(2, 11): True,
			(2, 12): True,
			(2, 13): True,
			(2, 14): True,
			(2, 15): True,
			(2, 16): True,
			(2, 17): True,
			(2, 18): True,
			(2, 19): True,
			(2, 20): True,
			(2, 21): True,
			(2, 22): True,
			(2, 23): True,
			(2, 24): True,
			(3, 0): True,
			(3, 1): True,
			(3, 2): True,
			(3, 3): True,
			(3, 4): True,
			(3, 5): True,
			(3, 6): True,
			(3, 7): True,
			(3, 8): True,
			(3, 9): True,
			(3, 10): True,
			(3, 11): True,
			(3, 12): True,
			(3, 13): True,
			(3, 14): True,
			(3, 15): True,
			(3, 16): True,
			(3, 17): True,
			(3, 18): True,
			(3, 19): True,
			(3, 20): True,
			(3, 21): True,
			(3, 22): True,
			(3, 23): True,
			(3, 24): True,
			(4, 0): True,
			(4, 1): True,
			(4, 2): True,
			(4, 3): True,
			(4, 4): True,
			(4, 5): True,
			(4, 6): True,
			(4, 7): True,
			(4, 8): True,
			(4, 9): True,
			(4, 10): True,
			(4, 11): True,
			(4, 12): True,
			(4, 13): True,
			(4, 14): True,
			(4, 15): True,
			(4, 16): True,
			(4, 17): True,
			(4, 18): True,
			(4, 19): True,
			(4, 20): True,
			(4, 21): True,
			(4, 22): True,
			(4, 23): True,
			(4, 24): True,
			(5, 0): True,
			(5, 1): True,
			(5, 2): True,
			(5, 3): True,
			(5, 4): True,
			(5, 5): True,
			(5, 6): True,
			(5, 7): True,
			(5, 8): True,
			(5, 9): True,
			(5, 10): True,
			(5, 11): True,
			(5, 12): True,
			(5, 13): True,
			(5, 14): True,
			(5, 15): True,
			(5, 16): True,
			(5, 17): True,
			(5, 18): True,
			(5, 19): True,
			(5, 20): True,
			(5, 21): True,
			(5, 22): True,
			(5, 23): True,
			(5, 24): True,
			(6, 0): True,
			(6, 1): True,
			(6, 2): True,
			(6, 3): True,
			(6, 4): True,
			(6, 5): True,
			(6, 6): True,
			(6, 7): True,
			(6, 8): True,
			(6, 9): True,
			(6, 10): True,
			(6, 11): True,
			(6, 12): True,
			(6, 13): True,
			(6, 14): True,
			(6, 15): True,
			(6, 16): True,
			(6, 17): True,
			(6, 18): True,
			(6, 19): True,
			(6, 20): True,
			(6, 21): True,
			(6, 22): True,
			(6, 23): True,
			(6, 24): True,
			(7, 0): True,
			(7, 1): True,
			(7, 2): True,
			(7, 3): True,
			(7, 4): True,
			(7, 5): True,
			(7, 6): True,
			(7, 7): True,
			(7, 8): True,
			(7, 9): True,
			(7, 10): True,
			(7, 11): True,
			(7, 12): True,
			(7, 13): True,
			(7, 14): True,
			(7, 15): True,
			(7, 16): True,
			(7, 17): True,
			(7, 18): True,
			(7, 19): True,
			(7, 20): True,
			(7, 21): True,
			(7, 22): True,
			(7, 23): True,
			(7, 24): True,
			(8, 0): True,
			(8, 1): True,
			(8, 2): True,
			(8, 3): True,
			(8, 4): True,
			(8, 5): True,
			(8, 6): True,
			(8, 7): True,
			(8, 8): True,
			(8, 9): True,
			(8, 10): True,
			(8, 11): True,
			(8, 12): True,
			(8, 13): True,
			(8, 14): True,
			(8, 15): True,
			(8, 16): True,
			(8, 17): True,
			(8, 18): True,
			(8, 19): True,
			(8, 20): True,
			(8, 21): True,
			(8, 22): True,
			(8, 23): True,
			(8, 24): True,
			(9, 0): True,
			(9, 1): True,
			(9, 2): True,
			(9, 3): True,
			(9, 4): True,
			(9, 5): True,
			(9, 6): True,
			(9, 7): True,
			(9, 8): True,
			(9, 9): True,
			(9, 10): True,
			(9, 11): True,
			(9, 12): True,
			(9, 13): True,
			(9, 14): True,
			(9, 15): True,
			(9, 16): True,
			(9, 17): True,
			(9, 18): True,
			(9, 19): True,
			(9, 20): True,
			(9, 21): True,
			(9, 22): True,
			(9, 23): True,
			(9, 24): True,
			(10, 0): True,
			(10, 1): True,
			(10, 2): True,
			(10, 3): True,
			(10, 4): True,
			(10, 5): True,
			(10, 6): True,
			(10, 7): True,
			(10, 8): True,
			(10, 9): True,
			(10, 10): True,
			(10, 11): True,
			(10, 12): True,
			(10, 13): True,
			(10, 14): True,
			(10, 15): True,
			(10, 16): True,
			(10, 17): True,
			(10, 18): True,
			(10, 19): True,
			(10, 20): True,
			(10, 21): True,
			(10, 22): True,
			(10, 23): True,
			(10, 24): True,
			(11, 0): True,
			(11, 1): True,
			(11, 2): True,
			(11, 3): True,
			(11, 4): True,
			(11, 5): True,
			(11, 6): True,
			(11, 7): True,
			(11, 8): True,
			(11, 9): True,
			(11, 10): True,
			(11, 11): True,
			(11, 12): True,
			(11, 13): True,
			(11, 14): True,
			(11, 15): True,
			(11, 16): True,
			(11, 17): True,
			(11, 18): True,
			(11, 19): True,
			(11, 20): True,
			(11, 21): True,
			(11, 22): True,
			(11, 23): True,
			(11, 24): True,
			(12, 0): True,
			(12, 1): True,
			(12, 2): True,
			(12, 3): True,
			(12, 4): True,
			(12, 5): True,
			(12, 6): True,
			(12, 7): True,
			(12, 8): True,
			(12, 9): True,
			(12, 10): True,
			(12, 11): True,
			(12, 12): True,
			(12, 13): True,
			(12, 14): True,
			(12, 15): True,
			(12, 16): True,
			(12, 17): True,
			(12, 18): True,
			(12, 19): True,
			(12, 20): True,
			(12, 21): True,
			(12, 22): True,
			(12, 23): True,
			(12, 24): True,
			(13, 0): True,
			(13, 1): True,
			(13, 2): True,
			(13, 3): True,
			(13, 4): True,
			(13, 5): True,
			(13, 6): True,
			(13, 7): True,
			(13, 8): True,
			(13, 9): True,
			(13, 10): True,
			(13, 11): True,
			(13, 12): True,
			(13, 13): True,
			(13, 14): True,
			(13, 15): True,
			(13, 16): True,
			(13, 17): True,
			(13, 18): True,
			(13, 19): True,
			(13, 20): True,
			(13, 21): True,
			(13, 22): True,
			(13, 23): True,
			(13, 24): True,
			(14, 0): True,
			(14, 1): True,
			(14, 2): True,
			(14, 3): True,
			(14, 4): True,
			(14, 5): True,
			(14, 6): True,
			(14, 7): True,
			(14, 8): True,
			(14, 9): True,
			(14, 10): True,
			(14, 11): True,
			(14, 12): True,
			(14, 13): True,
			(14, 14): True,
			(14, 15): True,
			(14, 16): True,
			(14, 17): True,
			(14, 18): True,
			(14, 19): True,
			(14, 20): True,
			(14, 21): True,
			(14, 22): True,
			(14, 23): True,
			(14, 24): True,
			(15, 0): True,
			(15, 1): True,
			(15, 2): True,
			(15, 3): True,
			(15, 4): True,
			(15, 5): True,
			(15, 6): True,
			(15, 7): True,
			(15, 8): True,
			(15, 9): True,
			(15, 10): True,
			(15, 11): True,
			(15, 12): True,
			(15, 13): True,
			(15, 14): True,
			(15, 15): True,
			(15, 16): True,
			(15, 17): True,
			(15, 18): True,
			(15, 19): True,
			(15, 20): True,
			(15, 21): True,
			(15, 22): True,
			(15, 23): True,
			(15, 24): True,
			(16, 0): True,
			(16, 1): True,
			(16, 2): True,
			(16, 3): True,
			(16, 4): True,
			(16, 5): True,
			(16, 6): True,
			(16, 7): True,
			(16, 8): True,
			(16, 9): True,
			(16, 10): True,
			(16, 11): True,
			(16, 12): True,
			(16, 13): True,
			(16, 14): True,
			(16, 15): True,
			(16, 16): True,
			(16, 17): True,
			(16, 18): True,
			(16, 19): True,
			(16, 20): True,
			(16, 21): True,
			(16, 22): True,
			(16, 23): True,
			(16, 24): True,
			(17, 0): True,
			(17, 1): True,
			(17, 2): True,
			(17, 3): True,
			(17, 4): True,
			(17, 5): True,
			(17, 6): True,
			(17, 7): True,
			(17, 8): True,
			(17, 9): True,
			(17, 10): True,
			(17, 11): True,
			(17, 12): True,
			(17, 13): True,
			(17, 14): True,
			(17, 15): True,
			(17, 16): True,
			(17, 17): True,
			(17, 18): True,
			(17, 19): True,
			(17, 20): True,
			(17, 21): True,
			(17, 22): True,
			(17, 23): True,
			(17, 24): True,
			(18, 0): True,
			(18, 1): True,
			(18, 2): True,
			(18, 3): True,
			(18, 4): True,
			(18, 5): True,
			(18, 6): True,
			(18, 7): True,
			(18, 8): True,
			(18, 9): True,
			(18, 10): True,
			(18, 11): True,
			(18, 12): True,
			(18, 13): True,
			(18, 14): True,
			(18, 15): True,
			(18, 16): True,
			(18, 17): True,
			(18, 18): True,
			(18, 19): True,
			(18, 20): True,
			(18, 21): True,
			(18, 22): True,
			(18, 23): True,
			(18, 24): True,
			(19, 0): True,
			(19, 1): True,
			(19, 2): True,
			(19, 3): True,
			(19, 4): True,
			(19, 5): True,
			(19, 6): True,
			(19, 7): True,
			(19, 8): True,
			(19, 9): True,
			(19, 10): True,
			(19, 11): True,
			(19, 12): True,
			(19, 13): True,
			(19, 14): True,
			(19, 15): True,
			(19, 16): True,
			(19, 17): True,
			(19, 18): True,
			(19, 19): True,
			(19, 20): True,
			(19, 21): True,
			(19, 22): True,
			(19, 23): True,
			(19, 24): True,
			(20, 0): True,
			(20, 1): True,
			(20, 2): True,
			(20, 3): True,
			(20, 4): True,
			(20, 5): True,
			(20, 6): True,
			(20, 7): True,
			(20, 8): True,
			(20, 9): True,
			(20, 10): True,
			(20, 11): True,
			(20, 12): True,
			(20, 13): True,
			(20, 14): True,
			(20, 15): True,
			(20, 16): True,
			(20, 17): True,
			(20, 18): True,
			(20, 19): True,
			(20, 20): True,
			(20, 21): True,
			(20, 22): True,
			(20, 23): True,
			(20, 24): True,
			(21, 0): True,
			(21, 1): True,
			(21, 2): True,
			(21, 3): True,
			(21, 4): True,
			(21, 5): True,
			(21, 6): True,
			(21, 7): True,
			(21, 8): True,
			(21, 9): True,
			(21, 10): True,
			(21, 11): True,
			(21, 12): True,
			(21, 13): True,
			(21, 14): True,
			(21, 15): True,
			(21, 16): True,
			(21, 17): True,
			(21, 18): True,
			(21, 19): True,
			(21, 20): True,
			(21, 21): True,
			(21, 22): True,
			(21, 23): True,
			(21, 24): True,
			(22, 0): True,
			(22, 1): True,
			(22, 2): True,
			(22, 3): True,
			(22, 4): True,
			(22, 5): True,
			(22, 6): True,
			(22, 7): True,
			(22, 8): True,
			(22, 9): True,
			(22, 10): True,
			(22, 11): True,
			(22, 12): True,
			(22, 13): True,
			(22, 14): True,
			(22, 15): True,
			(22, 16): True,
			(22, 17): True,
			(22, 18): True,
			(22, 19): True,
			(22, 20): True,
			(22, 21): True,
			(22, 22): True,
			(22, 23): True,
			(22, 24): True,
			(23, 0): True,
			(23, 1): True,
			(23, 2): True,
			(23, 3): True,
			(23, 4): True,
			(23, 5): True,
			(23, 6): True,
			(23, 7): True,
			(23, 8): True,
			(23, 9): True,
			(23, 10): True,
			(23, 11): True,
			(23, 12): True,
			(23, 13): True,
			(23, 14): True,
			(23, 15): True,
			(23, 16): True,
			(23, 17): True,
			(23, 18): True,
			(23, 19): True,
			(23, 20): True,
			(23, 21): True,
			(23, 22): True,
			(23, 23): True,
			(23, 24): True,
			(24, 0): True,
			(24, 1): True,
			(24, 2): True,
			(24, 3): True,
			(24, 4): True,
			(24, 5): True,
			(24, 6): True,
			(24, 7): True,
			(24, 8): True,
			(24, 9): True,
			(24, 10): True,
			(24, 11): True,
			(24, 12): True,
			(24, 13): True,
			(24, 14): True,
			(24, 15): True,
			(24, 16): True,
			(24, 17): True,
			(24, 18): True,
			(24, 19): True,
			(24, 20): True,
			(24, 21): True,
			(24, 22): True,
			(24, 23): True,
			(24, 24): True,
			"wolf0": True,
			"wolf1": True,
			"wolf2": True,
			"wolf3": True,
			"wolf4": True,
			"wolf5": True,
			"wolf6": True,
			"wolf7": True,
			"wolf8": True,
			"wolf9": True,
			"sheep0": True,
			"sheep1": True,
			"sheep2": True,
			"sheep3": True,
			"sheep4": True,
			"sheep5": True,
			"sheep6": True,
			"sheep7": True,
			"sheep9": True,
			"sheep10": True,
			"sheep11": True,
			"sheep12": True,
			"sheep13": True,
			"sheep14": True,
			"sheep15": True,
			"sheep16": True,
			"sheep17": True,
			"sheep18": True,
			"sheep19": True,
			"sheep20": True,
			"sheep21": True,
			"sheep22": True,
			"sheep23": True,
			"sheep24": True,
		},
		"sheep": {},
		"wolf": {},
	},
	"prereqs": {"anotherrule": ["quux", "quuux"], "onerule": ["qux", "quux"]},
	"rulebook": {"somerules": ["onerule", "anotherrule"]},
	"triggers": {"anotherrule": ["bar", "bas"], "onerule": ["foo", "bar"]},
	"universal": {
		"rando_state": (
			3,
			(
				3399532814,
				1922621091,
				1318639202,
				1200287287,
				3284435864,
				3808930300,
				1747335490,
				3737760233,
				2715492764,
				183638019,
				3103353611,
				1217069546,
				1194190910,
				2470141417,
				528883139,
				1247094542,
				3065920289,
				4023506129,
				3986236424,
				3749810207,
				1213377109,
				2392958591,
				2637425708,
				506243303,
				1974338482,
				3524827911,
				3156542393,
				1548342757,
				91283707,
				3403533555,
				1364512744,
				993712879,
				949917159,
				3456526842,
				1616759050,
				1515251065,
				357043951,
				1352385251,
				1680586795,
				1069902820,
				2286504344,
				3262948456,
				1610629301,
				319919651,
				45107944,
				2045917580,
				2110902311,
				2464357864,
				2664307689,
				902983258,
				208177230,
				4130108282,
				1416039765,
				2461894687,
				3110756236,
				3470141532,
				2028342787,
				1781709104,
				2771498538,
				1351265847,
				304183294,
				2487644610,
				1121378284,
				4234462150,
				2171696954,
				1432476127,
				2747857624,
				3695920921,
				3988302868,
				1157199368,
				1411756053,
				2572580540,
				1410510534,
				2587342452,
				3046977583,
				4287127259,
				3252310090,
				1889562274,
				1285232301,
				2102539750,
				919647060,
				1878729190,
				837997469,
				3914202568,
				2865558995,
				1433236156,
				424157963,
				3858575292,
				3800780810,
				1344639319,
				1383058302,
				3649145092,
				1740604493,
				2985246546,
				3429535288,
				3587084276,
				3916818711,
				228645474,
				2798976986,
				1008992183,
				1597917797,
				3526936843,
				533626492,
				2612010317,
				1351135423,
				619036742,
				758900773,
				3167620717,
				4262803307,
				2927613508,
				1341810555,
				1385677314,
				3486740390,
				3628505064,
				3160038644,
				632320893,
				2972236317,
				2973155055,
				1040615847,
				1810847522,
				3695375695,
				1473230679,
				1785517482,
				2323990347,
				3829344560,
				1815628020,
				3228109550,
				1845817718,
				1600290058,
				2564572512,
				687088198,
				375571221,
				2647569431,
				2897219002,
				3029332029,
				3468442471,
				1471060578,
				1634853903,
				1706206173,
				2578029018,
				1402177220,
				3044222267,
				1413430456,
				4244498995,
				289959273,
				4106915877,
				1480055840,
				1670828849,
				2150193753,
				892238790,
				2021671481,
				2086509740,
				427575208,
				4044745485,
				3627920350,
				1612182500,
				1671043380,
				405713855,
				3483664227,
				2304922558,
				395614077,
				2350797015,
				1180850316,
				292433483,
				1333511644,
				3743603295,
				4019721169,
				2379423817,
				2431258913,
				1466514764,
				1066129045,
				477558949,
				3877267071,
				3674243700,
				1751659787,
				4097551726,
				3747439107,
				189793079,
				2467327892,
				3890055699,
				1656543049,
				175532463,
				1044881562,
				2954406023,
				2218430029,
				946001334,
				4103474870,
				766186315,
				1042145935,
				260188682,
				2878489308,
				3555411741,
				3023986187,
				3467384247,
				2174864312,
				3362440253,
				2953378436,
				19660317,
				1757532286,
				3513031710,
				1652951194,
				3049088961,
				3175452919,
				2035270037,
				1155415543,
				2934246475,
				840464792,
				407633508,
				1887661269,
				2359172041,
				968886421,
				911588093,
				3008303476,
				3521303176,
				828495762,
				771710338,
				298906623,
				3010795838,
				2770235797,
				3070544645,
				1353617353,
				2112742085,
				3228737385,
				3051453342,
				1594607522,
				4006552785,
				2729135020,
				3270702932,
				175384810,
				2169675714,
				554581549,
				3652858944,
				2892390819,
				999749053,
				893082860,
				973414218,
				3672054543,
				146531700,
				547933382,
				1836935847,
				868239712,
				1099781051,
				1576672760,
				3221746967,
				3876109239,
				2309164847,
				3865092624,
				1836244759,
				1768849141,
				2736176007,
				3510572365,
				2081525655,
				708719652,
				2743095338,
				1370536669,
				3969463016,
				106061602,
				2538980431,
				2308763556,
				412173904,
				945969761,
				1870394348,
				1070338339,
				3429806675,
				2933276694,
				1089771452,
				165596877,
				2692314790,
				1472770556,
				2529683641,
				3587633108,
				4015381206,
				954486772,
				3653418320,
				672945660,
				3995119822,
				509035573,
				2420650770,
				3167460230,
				1412904447,
				1004162553,
				359688731,
				1463730013,
				2654550898,
				2322490996,
				3587214037,
				2456381906,
				1284471257,
				3147223374,
				2962910796,
				2053633882,
				3671887914,
				3930424831,
				517344036,
				3276178055,
				2367449475,
				3829540347,
				2789357276,
				2737746061,
				1209592165,
				2765436616,
				1345522028,
				346724815,
				684933596,
				3266939327,
				869416558,
				1225816017,
				1711741543,
				1391185942,
				1195117282,
				4133900011,
				593222865,
				3599059573,
				506697230,
				2120454750,
				1106248566,
				1521609271,
				650513902,
				1941344688,
				1413850112,
				3365808516,
				600973466,
				261174065,
				275198882,
				1169627701,
				2842886091,
				3023520671,
				4219492612,
				2291549761,
				511351473,
				3018341917,
				2005076163,
				2549571737,
				2877512352,
				2873043204,
				2382566003,
				642232442,
				2261362316,
				2872306798,
				807064762,
				385341093,
				1450447147,
				3151840765,
				3621770746,
				2968319541,
				2372441200,
				2902359464,
				2182531666,
				433207909,
				1507595811,
				1685000795,
				3996524516,
				2146661000,
				2643629010,
				494082414,
				1317908926,
				1106650311,
				2244226475,
				569396640,
				95331498,
				126228182,
				702584211,
				2087141873,
				1308796343,
				3641135430,
				1166707701,
				377653635,
				2399255707,
				4192288347,
				3238330919,
				1201738531,
				2142578273,
				3256050407,
				2595925711,
				1518079532,
				2135642334,
				3084160563,
				241884221,
				3085550853,
				2436468269,
				1776983589,
				1837796627,
				396185930,
				3939082101,
				3593704069,
				1023570838,
				610201550,
				714376274,
				3482480746,
				552246385,
				496891656,
				1877800674,
				3261771839,
				2178180914,
				2212294024,
				4138961325,
				3420731064,
				2530612796,
				439727944,
				3703037321,
				2305158689,
				1529731382,
				217504291,
				1519235821,
				2732418024,
				1034439019,
				1478303207,
				1067492765,
				2780107589,
				3787048903,
				793506737,
				1301470626,
				1896781139,
				3277478514,
				3712248652,
				774847238,
				610271327,
				2631053471,
				3366302913,
				4053422276,
				2531760730,
				2041550780,
				1835981092,
				141364655,
				2133448092,
				4254040931,
				3622543914,
				2270417239,
				1209717711,
				1784903541,
				2400647874,
				3853156984,
				375118437,
				18561235,
				1443060812,
				3348607308,
				2981740304,
				1336940463,
				111193131,
				3277410661,
				3546533355,
				3092441981,
				3681307849,
				617600811,
				180806721,
				206808112,
				310645112,
				617818318,
				848332715,
				2705674327,
				1612233280,
				2810600848,
				1242839754,
				3337435622,
				3260744662,
				814455963,
				428179624,
				1976119480,
				1603386692,
				2019394322,
				3775072468,
				1288122375,
				1284053881,
				3989121801,
				1625343759,
				1949385796,
				3159082124,
				813794179,
				46872540,
				2076655045,
				2290247198,
				1043491508,
				3425447319,
				4177821993,
				250551383,
				2442303777,
				3861864670,
				4063579719,
				3409088439,
				760136108,
				758683634,
				1206840853,
				1743258086,
				3482774997,
				26579421,
				2612171602,
				1225127375,
				1303069907,
				3356197625,
				1726471078,
				3041788638,
				3326813669,
				365462487,
				2604299888,
				137785061,
				734599551,
				4281167486,
				4181648776,
				399704187,
				2185630586,
				2334476143,
				2124552519,
				1675645205,
				1687958968,
				2492364909,
				2199059955,
				15855711,
				1944418548,
				1585284131,
				3017502039,
				3542669732,
				2462391234,
				1290726696,
				4222914972,
				1483406477,
				1953508888,
				3791157178,
				2694244625,
				825495391,
				490181556,
				2122434879,
				3560588266,
				2396209291,
				4168258868,
				2825987662,
				2537163900,
				1079088369,
				3138881170,
				4078837965,
				493042506,
				1461355846,
				778622211,
				1304515156,
				3042476270,
				2474420910,
				501590610,
				1959808723,
				579379216,
				2223881595,
				587409929,
				4166117892,
				1817470172,
				2103076771,
				3309364256,
				733168470,
				4134197315,
				1212630909,
				399465005,
				2868316139,
				619834971,
				2388078861,
				1987853804,
				4141024030,
				636186497,
				2459021778,
				472143048,
				806913414,
				4082453804,
				202447953,
				3710630803,
				1271521185,
				3573749612,
				1755409516,
				4013838077,
				2017708168,
				2384253133,
				644042496,
				2821241237,
				3134223209,
				3271682952,
				434518586,
				916346595,
				2605891748,
				1235986954,
				2105707105,
				1824405608,
				1509384921,
				773752093,
				1560030029,
				56827310,
				786091112,
				1561697946,
				1774426505,
				799287221,
				1570759356,
				3457150661,
				3769914743,
				405752396,
				1549233748,
				3576579516,
				382348766,
				2895134811,
				1618176356,
				2959397351,
				1508533597,
				2490949198,
				4167064789,
				795399578,
				3303766464,
				2504198967,
				2608779501,
				2268202795,
				494725020,
				518601664,
				2977409184,
				2088836832,
				743764902,
				2696192420,
				4011378283,
				2968429477,
				859883567,
				359356418,
				3407829672,
				1900442649,
				2941584998,
				3448328286,
				2684915994,
				2928398899,
				3330869032,
				1420084479,
				1049788511,
				979750289,
				348001120,
				2931054143,
				140,
			),
			None,
		)
	},
}

BTT_FROM = ("trunk1", 7, 421)

KF_TO = {
	"actions": {
		"anotherrule": ["ham", "baked beans", "spam", "spam", "spam"],
		"onerule": ["eggs"],
	},
	"edge_val": {
		"physical": {
			(0, 1): {
				(0, 2): {"foo": "bar"},
				(1, 0): {"spam": "disgusting"},
				(1, 1): {},
			},
			(0, 2): {(0, 1): {}, (0, 3): {}, (1, 2): {}},
			(0, 3): {(0, 2): {}, (0, 4): {}, (1, 3): {}},
			(0, 4): {(0, 3): {}, (0, 5): {}, (1, 4): {}},
			(0, 5): {(0, 4): {}, (0, 6): {}, (1, 5): {}},
			(0, 6): {(0, 5): {}, (0, 7): {}, (1, 6): {}},
			(0, 7): {(0, 6): {}, (0, 8): {}, (1, 7): {}},
			(0, 8): {(0, 7): {}, (0, 9): {}, (1, 8): {}},
			(0, 9): {(0, 8): {}, (0, 10): {}, (1, 9): {}},
			(0, 10): {(0, 9): {}, (0, 11): {}, (1, 10): {}},
			(0, 11): {(0, 10): {}, (0, 12): {}, (1, 11): {}},
			(0, 12): {(0, 11): {}, (0, 13): {}, (1, 12): {}},
			(0, 13): {(0, 12): {}, (0, 14): {}, (1, 13): {}},
			(0, 14): {(0, 13): {}, (0, 15): {}, (1, 14): {}},
			(0, 15): {(0, 14): {}, (0, 16): {}, (1, 15): {}},
			(0, 16): {(0, 15): {}, (0, 17): {}, (1, 16): {}},
			(0, 17): {(0, 16): {}, (0, 18): {}, (1, 17): {}},
			(0, 18): {(0, 17): {}, (0, 19): {}, (1, 18): {}},
			(0, 19): {(0, 18): {}, (0, 20): {}, (1, 19): {}},
			(0, 20): {(0, 19): {}, (0, 21): {}, (1, 20): {}},
			(0, 21): {(0, 20): {}, (0, 22): {}, (1, 21): {}},
			(0, 22): {(0, 21): {}, (0, 23): {}, (1, 22): {}},
			(0, 23): {(0, 22): {}, (0, 24): {}, (1, 23): {}},
			(0, 24): {(0, 23): {}, (1, 24): {}},
			(1, 0): {(1, 1): {}, (2, 0): {}},
			(1, 1): {(0, 1): {}, (1, 0): {}, (1, 2): {}, (2, 1): {}},
			(1, 2): {(0, 2): {}, (1, 1): {}, (1, 3): {}, (2, 2): {}},
			(1, 3): {(0, 3): {}, (1, 2): {}, (1, 4): {}, (2, 3): {}},
			(1, 4): {(0, 4): {}, (1, 3): {}, (1, 5): {}, (2, 4): {}},
			(1, 5): {(0, 5): {}, (1, 4): {}, (1, 6): {}, (2, 5): {}},
			(1, 6): {(0, 6): {}, (1, 5): {}, (1, 7): {}, (2, 6): {}},
			(1, 7): {(0, 7): {}, (1, 6): {}, (1, 8): {}, (2, 7): {}},
			(1, 8): {(0, 8): {}, (1, 7): {}, (1, 9): {}, (2, 8): {}},
			(1, 9): {(0, 9): {}, (1, 8): {}, (1, 10): {}, (2, 9): {}},
			(1, 10): {(0, 10): {}, (1, 9): {}, (1, 11): {}, (2, 10): {}},
			(1, 11): {(0, 11): {}, (1, 10): {}, (1, 12): {}, (2, 11): {}},
			(1, 12): {(0, 12): {}, (1, 11): {}, (1, 13): {}, (2, 12): {}},
			(1, 13): {(0, 13): {}, (1, 12): {}, (1, 14): {}, (2, 13): {}},
			(1, 14): {(0, 14): {}, (1, 13): {}, (1, 15): {}, (2, 14): {}},
			(1, 15): {(0, 15): {}, (1, 14): {}, (1, 16): {}, (2, 15): {}},
			(1, 16): {(0, 16): {}, (1, 15): {}, (1, 17): {}, (2, 16): {}},
			(1, 17): {(0, 17): {}, (1, 16): {}, (1, 18): {}, (2, 17): {}},
			(1, 18): {(0, 18): {}, (1, 17): {}, (1, 19): {}, (2, 18): {}},
			(1, 19): {(0, 19): {}, (1, 18): {}, (1, 20): {}, (2, 19): {}},
			(1, 20): {(0, 20): {}, (1, 19): {}, (1, 21): {}, (2, 20): {}},
			(1, 21): {(0, 21): {}, (1, 20): {}, (1, 22): {}, (2, 21): {}},
			(1, 22): {(0, 22): {}, (1, 21): {}, (1, 23): {}, (2, 22): {}},
			(1, 23): {(0, 23): {}, (1, 22): {}, (1, 24): {}, (2, 23): {}},
			(1, 24): {(0, 24): {}, (1, 23): {}, (2, 24): {}},
			(2, 0): {(1, 0): {}, (2, 1): {}, (3, 0): {}},
			(2, 1): {(1, 1): {}, (2, 0): {}, (2, 2): {}, (3, 1): {}},
			(2, 2): {(1, 2): {}, (2, 1): {}, (2, 3): {}, (3, 2): {}},
			(2, 3): {(1, 3): {}, (2, 2): {}, (2, 4): {}, (3, 3): {}},
			(2, 4): {(1, 4): {}, (2, 3): {}, (2, 5): {}, (3, 4): {}},
			(2, 5): {(1, 5): {}, (2, 4): {}, (2, 6): {}, (3, 5): {}},
			(2, 6): {(1, 6): {}, (2, 5): {}, (2, 7): {}, (3, 6): {}},
			(2, 7): {(1, 7): {}, (2, 6): {}, (2, 8): {}, (3, 7): {}},
			(2, 8): {(1, 8): {}, (2, 7): {}, (2, 9): {}, (3, 8): {}},
			(2, 9): {(1, 9): {}, (2, 8): {}, (2, 10): {}, (3, 9): {}},
			(2, 10): {(1, 10): {}, (2, 9): {}, (2, 11): {}, (3, 10): {}},
			(2, 11): {(1, 11): {}, (2, 10): {}, (2, 12): {}, (3, 11): {}},
			(2, 12): {(1, 12): {}, (2, 11): {}, (2, 13): {}, (3, 12): {}},
			(2, 13): {(1, 13): {}, (2, 12): {}, (2, 14): {}, (3, 13): {}},
			(2, 14): {(1, 14): {}, (2, 13): {}, (2, 15): {}, (3, 14): {}},
			(2, 15): {(1, 15): {}, (2, 14): {}, (2, 16): {}, (3, 15): {}},
			(2, 16): {(1, 16): {}, (2, 15): {}, (2, 17): {}, (3, 16): {}},
			(2, 17): {(1, 17): {}, (2, 16): {}, (2, 18): {}, (3, 17): {}},
			(2, 18): {(1, 18): {}, (2, 17): {}, (2, 19): {}, (3, 18): {}},
			(2, 19): {(1, 19): {}, (2, 18): {}, (2, 20): {}, (3, 19): {}},
			(2, 20): {(1, 20): {}, (2, 19): {}, (2, 21): {}, (3, 20): {}},
			(2, 21): {(1, 21): {}, (2, 20): {}, (2, 22): {}, (3, 21): {}},
			(2, 22): {(1, 22): {}, (2, 21): {}, (2, 23): {}, (3, 22): {}},
			(2, 23): {(1, 23): {}, (2, 22): {}, (2, 24): {}, (3, 23): {}},
			(2, 24): {(1, 24): {}, (2, 23): {}, (3, 24): {}},
			(3, 0): {(2, 0): {}, (3, 1): {}, (4, 0): {}},
			(3, 1): {(2, 1): {}, (3, 0): {}, (3, 2): {}, (4, 1): {}},
			(3, 2): {(2, 2): {}, (3, 1): {}, (3, 3): {}, (4, 2): {}},
			(3, 3): {(2, 3): {}, (3, 2): {}, (3, 4): {}, (4, 3): {}},
			(3, 4): {(2, 4): {}, (3, 3): {}, (3, 5): {}, (4, 4): {}},
			(3, 5): {(2, 5): {}, (3, 4): {}, (3, 6): {}, (4, 5): {}},
			(3, 6): {(2, 6): {}, (3, 5): {}, (3, 7): {}, (4, 6): {}},
			(3, 7): {(2, 7): {}, (3, 6): {}, (3, 8): {}, (4, 7): {}},
			(3, 8): {(2, 8): {}, (3, 7): {}, (3, 9): {}, (4, 8): {}},
			(3, 9): {(2, 9): {}, (3, 8): {}, (3, 10): {}, (4, 9): {}},
			(3, 10): {(2, 10): {}, (3, 9): {}, (3, 11): {}, (4, 10): {}},
			(3, 11): {(2, 11): {}, (3, 10): {}, (3, 12): {}, (4, 11): {}},
			(3, 12): {(2, 12): {}, (3, 11): {}, (3, 13): {}, (4, 12): {}},
			(3, 13): {(2, 13): {}, (3, 12): {}, (3, 14): {}, (4, 13): {}},
			(3, 14): {(2, 14): {}, (3, 13): {}, (3, 15): {}, (4, 14): {}},
			(3, 15): {(2, 15): {}, (3, 14): {}, (3, 16): {}, (4, 15): {}},
			(3, 16): {(2, 16): {}, (3, 15): {}, (3, 17): {}, (4, 16): {}},
			(3, 17): {(2, 17): {}, (3, 16): {}, (3, 18): {}, (4, 17): {}},
			(3, 18): {(2, 18): {}, (3, 17): {}, (3, 19): {}, (4, 18): {}},
			(3, 19): {(2, 19): {}, (3, 18): {}, (3, 20): {}, (4, 19): {}},
			(3, 20): {(2, 20): {}, (3, 19): {}, (3, 21): {}, (4, 20): {}},
			(3, 21): {(2, 21): {}, (3, 20): {}, (3, 22): {}, (4, 21): {}},
			(3, 22): {(2, 22): {}, (3, 21): {}, (3, 23): {}, (4, 22): {}},
			(3, 23): {(2, 23): {}, (3, 22): {}, (3, 24): {}, (4, 23): {}},
			(3, 24): {(2, 24): {}, (3, 23): {}, (4, 24): {}},
			(4, 0): {(3, 0): {}, (4, 1): {}, (5, 0): {}},
			(4, 1): {(3, 1): {}, (4, 0): {}, (4, 2): {}, (5, 1): {}},
			(4, 2): {(3, 2): {}, (4, 1): {}, (4, 3): {}, (5, 2): {}},
			(4, 3): {(3, 3): {}, (4, 2): {}, (4, 4): {}, (5, 3): {}},
			(4, 4): {(3, 4): {}, (4, 3): {}, (4, 5): {}, (5, 4): {}},
			(4, 5): {(3, 5): {}, (4, 4): {}, (4, 6): {}, (5, 5): {}},
			(4, 6): {(3, 6): {}, (4, 5): {}, (4, 7): {}, (5, 6): {}},
			(4, 7): {(3, 7): {}, (4, 6): {}, (4, 8): {}, (5, 7): {}},
			(4, 8): {(3, 8): {}, (4, 7): {}, (4, 9): {}, (5, 8): {}},
			(4, 9): {(3, 9): {}, (4, 8): {}, (4, 10): {}, (5, 9): {}},
			(4, 10): {(3, 10): {}, (4, 9): {}, (4, 11): {}, (5, 10): {}},
			(4, 11): {(3, 11): {}, (4, 10): {}, (4, 12): {}, (5, 11): {}},
			(4, 12): {(3, 12): {}, (4, 11): {}, (4, 13): {}, (5, 12): {}},
			(4, 13): {(3, 13): {}, (4, 12): {}, (4, 14): {}, (5, 13): {}},
			(4, 14): {(3, 14): {}, (4, 13): {}, (4, 15): {}, (5, 14): {}},
			(4, 15): {(3, 15): {}, (4, 14): {}, (4, 16): {}, (5, 15): {}},
			(4, 16): {(3, 16): {}, (4, 15): {}, (4, 17): {}, (5, 16): {}},
			(4, 17): {(3, 17): {}, (4, 16): {}, (4, 18): {}, (5, 17): {}},
			(4, 18): {(3, 18): {}, (4, 17): {}, (4, 19): {}, (5, 18): {}},
			(4, 19): {(3, 19): {}, (4, 18): {}, (4, 20): {}, (5, 19): {}},
			(4, 20): {(3, 20): {}, (4, 19): {}, (4, 21): {}, (5, 20): {}},
			(4, 21): {(3, 21): {}, (4, 20): {}, (4, 22): {}, (5, 21): {}},
			(4, 22): {(3, 22): {}, (4, 21): {}, (4, 23): {}, (5, 22): {}},
			(4, 23): {(3, 23): {}, (4, 22): {}, (4, 24): {}, (5, 23): {}},
			(4, 24): {(3, 24): {}, (4, 23): {}, (5, 24): {}},
			(5, 0): {(4, 0): {}, (5, 1): {}, (6, 0): {}},
			(5, 1): {(4, 1): {}, (5, 0): {}, (5, 2): {}, (6, 1): {}},
			(5, 2): {(4, 2): {}, (5, 1): {}, (5, 3): {}, (6, 2): {}},
			(5, 3): {(4, 3): {}, (5, 2): {}, (5, 4): {}, (6, 3): {}},
			(5, 4): {(4, 4): {}, (5, 3): {}, (5, 5): {}, (6, 4): {}},
			(5, 5): {(4, 5): {}, (5, 4): {}, (5, 6): {}, (6, 5): {}},
			(5, 6): {(4, 6): {}, (5, 5): {}, (5, 7): {}, (6, 6): {}},
			(5, 7): {(4, 7): {}, (5, 6): {}, (5, 8): {}, (6, 7): {}},
			(5, 8): {(4, 8): {}, (5, 7): {}, (5, 9): {}, (6, 8): {}},
			(5, 9): {(4, 9): {}, (5, 8): {}, (5, 10): {}, (6, 9): {}},
			(5, 10): {(4, 10): {}, (5, 9): {}, (5, 11): {}, (6, 10): {}},
			(5, 11): {(4, 11): {}, (5, 10): {}, (5, 12): {}, (6, 11): {}},
			(5, 12): {(4, 12): {}, (5, 11): {}, (5, 13): {}, (6, 12): {}},
			(5, 13): {(4, 13): {}, (5, 12): {}, (5, 14): {}, (6, 13): {}},
			(5, 14): {(4, 14): {}, (5, 13): {}, (5, 15): {}, (6, 14): {}},
			(5, 15): {(4, 15): {}, (5, 14): {}, (5, 16): {}, (6, 15): {}},
			(5, 16): {(4, 16): {}, (5, 15): {}, (5, 17): {}, (6, 16): {}},
			(5, 17): {(4, 17): {}, (5, 16): {}, (5, 18): {}, (6, 17): {}},
			(5, 18): {(4, 18): {}, (5, 17): {}, (5, 19): {}, (6, 18): {}},
			(5, 19): {(4, 19): {}, (5, 18): {}, (5, 20): {}, (6, 19): {}},
			(5, 20): {(4, 20): {}, (5, 19): {}, (5, 21): {}, (6, 20): {}},
			(5, 21): {(4, 21): {}, (5, 20): {}, (5, 22): {}, (6, 21): {}},
			(5, 22): {(4, 22): {}, (5, 21): {}, (5, 23): {}, (6, 22): {}},
			(5, 23): {(4, 23): {}, (5, 22): {}, (5, 24): {}, (6, 23): {}},
			(5, 24): {(4, 24): {}, (5, 23): {}, (6, 24): {}},
			(6, 0): {(5, 0): {}, (6, 1): {}, (7, 0): {}},
			(6, 1): {(5, 1): {}, (6, 0): {}, (6, 2): {}, (7, 1): {}},
			(6, 2): {(5, 2): {}, (6, 1): {}, (6, 3): {}, (7, 2): {}},
			(6, 3): {(5, 3): {}, (6, 2): {}, (6, 4): {}, (7, 3): {}},
			(6, 4): {(5, 4): {}, (6, 3): {}, (6, 5): {}, (7, 4): {}},
			(6, 5): {(5, 5): {}, (6, 4): {}, (6, 6): {}, (7, 5): {}},
			(6, 6): {(5, 6): {}, (6, 5): {}, (6, 7): {}, (7, 6): {}},
			(6, 7): {(5, 7): {}, (6, 6): {}, (6, 8): {}, (7, 7): {}},
			(6, 8): {(5, 8): {}, (6, 7): {}, (6, 9): {}, (7, 8): {}},
			(6, 9): {(5, 9): {}, (6, 8): {}, (6, 10): {}, (7, 9): {}},
			(6, 10): {(5, 10): {}, (6, 9): {}, (6, 11): {}, (7, 10): {}},
			(6, 11): {(5, 11): {}, (6, 10): {}, (6, 12): {}, (7, 11): {}},
			(6, 12): {(5, 12): {}, (6, 11): {}, (6, 13): {}, (7, 12): {}},
			(6, 13): {(5, 13): {}, (6, 12): {}, (6, 14): {}, (7, 13): {}},
			(6, 14): {(5, 14): {}, (6, 13): {}, (6, 15): {}, (7, 14): {}},
			(6, 15): {(5, 15): {}, (6, 14): {}, (6, 16): {}, (7, 15): {}},
			(6, 16): {(5, 16): {}, (6, 15): {}, (6, 17): {}, (7, 16): {}},
			(6, 17): {(5, 17): {}, (6, 16): {}, (6, 18): {}, (7, 17): {}},
			(6, 18): {(5, 18): {}, (6, 17): {}, (6, 19): {}, (7, 18): {}},
			(6, 19): {(5, 19): {}, (6, 18): {}, (6, 20): {}, (7, 19): {}},
			(6, 20): {(5, 20): {}, (6, 19): {}, (6, 21): {}, (7, 20): {}},
			(6, 21): {(5, 21): {}, (6, 20): {}, (6, 22): {}, (7, 21): {}},
			(6, 22): {(5, 22): {}, (6, 21): {}, (6, 23): {}, (7, 22): {}},
			(6, 23): {(5, 23): {}, (6, 22): {}, (6, 24): {}, (7, 23): {}},
			(6, 24): {(5, 24): {}, (6, 23): {}, (7, 24): {}},
			(7, 0): {(6, 0): {}, (7, 1): {}, (8, 0): {}},
			(7, 1): {(6, 1): {}, (7, 0): {}, (7, 2): {}, (8, 1): {}},
			(7, 2): {(6, 2): {}, (7, 1): {}, (7, 3): {}, (8, 2): {}},
			(7, 3): {(6, 3): {}, (7, 2): {}, (7, 4): {}, (8, 3): {}},
			(7, 4): {(6, 4): {}, (7, 3): {}, (7, 5): {}, (8, 4): {}},
			(7, 5): {(6, 5): {}, (7, 4): {}, (7, 6): {}, (8, 5): {}},
			(7, 6): {(6, 6): {}, (7, 5): {}, (7, 7): {}, (8, 6): {}},
			(7, 7): {(6, 7): {}, (7, 6): {}, (7, 8): {}, (8, 7): {}},
			(7, 8): {(6, 8): {}, (7, 7): {}, (7, 9): {}, (8, 8): {}},
			(7, 9): {(6, 9): {}, (7, 8): {}, (7, 10): {}, (8, 9): {}},
			(7, 10): {(6, 10): {}, (7, 9): {}, (7, 11): {}, (8, 10): {}},
			(7, 11): {(6, 11): {}, (7, 10): {}, (7, 12): {}, (8, 11): {}},
			(7, 12): {(6, 12): {}, (7, 11): {}, (7, 13): {}, (8, 12): {}},
			(7, 13): {(6, 13): {}, (7, 12): {}, (7, 14): {}, (8, 13): {}},
			(7, 14): {(6, 14): {}, (7, 13): {}, (7, 15): {}, (8, 14): {}},
			(7, 15): {(6, 15): {}, (7, 14): {}, (7, 16): {}, (8, 15): {}},
			(7, 16): {(6, 16): {}, (7, 15): {}, (7, 17): {}, (8, 16): {}},
			(7, 17): {(6, 17): {}, (7, 16): {}, (7, 18): {}, (8, 17): {}},
			(7, 18): {(6, 18): {}, (7, 17): {}, (7, 19): {}, (8, 18): {}},
			(7, 19): {(6, 19): {}, (7, 18): {}, (7, 20): {}, (8, 19): {}},
			(7, 20): {(6, 20): {}, (7, 19): {}, (7, 21): {}, (8, 20): {}},
			(7, 21): {(6, 21): {}, (7, 20): {}, (7, 22): {}, (8, 21): {}},
			(7, 22): {(6, 22): {}, (7, 21): {}, (7, 23): {}, (8, 22): {}},
			(7, 23): {(6, 23): {}, (7, 22): {}, (7, 24): {}, (8, 23): {}},
			(7, 24): {(6, 24): {}, (7, 23): {}, (8, 24): {}},
			(8, 0): {(7, 0): {}, (8, 1): {}, (9, 0): {}},
			(8, 1): {(7, 1): {}, (8, 0): {}, (8, 2): {}, (9, 1): {}},
			(8, 2): {(7, 2): {}, (8, 1): {}, (8, 3): {}, (9, 2): {}},
			(8, 3): {(7, 3): {}, (8, 2): {}, (8, 4): {}, (9, 3): {}},
			(8, 4): {(7, 4): {}, (8, 3): {}, (8, 5): {}, (9, 4): {}},
			(8, 5): {(7, 5): {}, (8, 4): {}, (8, 6): {}, (9, 5): {}},
			(8, 6): {(7, 6): {}, (8, 5): {}, (8, 7): {}, (9, 6): {}},
			(8, 7): {(7, 7): {}, (8, 6): {}, (8, 8): {}, (9, 7): {}},
			(8, 8): {(7, 8): {}, (8, 7): {}, (8, 9): {}, (9, 8): {}},
			(8, 9): {(7, 9): {}, (8, 8): {}, (8, 10): {}, (9, 9): {}},
			(8, 10): {(7, 10): {}, (8, 9): {}, (8, 11): {}, (9, 10): {}},
			(8, 11): {(7, 11): {}, (8, 10): {}, (8, 12): {}, (9, 11): {}},
			(8, 12): {(7, 12): {}, (8, 11): {}, (8, 13): {}, (9, 12): {}},
			(8, 13): {(7, 13): {}, (8, 12): {}, (8, 14): {}, (9, 13): {}},
			(8, 14): {(7, 14): {}, (8, 13): {}, (8, 15): {}, (9, 14): {}},
			(8, 15): {(7, 15): {}, (8, 14): {}, (8, 16): {}, (9, 15): {}},
			(8, 16): {(7, 16): {}, (8, 15): {}, (8, 17): {}, (9, 16): {}},
			(8, 17): {(7, 17): {}, (8, 16): {}, (8, 18): {}, (9, 17): {}},
			(8, 18): {(7, 18): {}, (8, 17): {}, (8, 19): {}, (9, 18): {}},
			(8, 19): {(7, 19): {}, (8, 18): {}, (8, 20): {}, (9, 19): {}},
			(8, 20): {(7, 20): {}, (8, 19): {}, (8, 21): {}, (9, 20): {}},
			(8, 21): {(7, 21): {}, (8, 20): {}, (8, 22): {}, (9, 21): {}},
			(8, 22): {(7, 22): {}, (8, 21): {}, (8, 23): {}, (9, 22): {}},
			(8, 23): {(7, 23): {}, (8, 22): {}, (8, 24): {}, (9, 23): {}},
			(8, 24): {(7, 24): {}, (8, 23): {}, (9, 24): {}},
			(9, 0): {(8, 0): {}, (9, 1): {}, (10, 0): {}},
			(9, 1): {(8, 1): {}, (9, 0): {}, (9, 2): {}, (10, 1): {}},
			(9, 2): {(8, 2): {}, (9, 1): {}, (9, 3): {}, (10, 2): {}},
			(9, 3): {(8, 3): {}, (9, 2): {}, (9, 4): {}, (10, 3): {}},
			(9, 4): {(8, 4): {}, (9, 3): {}, (9, 5): {}, (10, 4): {}},
			(9, 5): {(8, 5): {}, (9, 4): {}, (9, 6): {}, (10, 5): {}},
			(9, 6): {(8, 6): {}, (9, 5): {}, (9, 7): {}, (10, 6): {}},
			(9, 7): {(8, 7): {}, (9, 6): {}, (9, 8): {}, (10, 7): {}},
			(9, 8): {(8, 8): {}, (9, 7): {}, (9, 9): {}, (10, 8): {}},
			(9, 9): {(8, 9): {}, (9, 8): {}, (9, 10): {}, (10, 9): {}},
			(9, 10): {(8, 10): {}, (9, 9): {}, (9, 11): {}, (10, 10): {}},
			(9, 11): {(8, 11): {}, (9, 10): {}, (9, 12): {}, (10, 11): {}},
			(9, 12): {(8, 12): {}, (9, 11): {}, (9, 13): {}, (10, 12): {}},
			(9, 13): {(8, 13): {}, (9, 12): {}, (9, 14): {}, (10, 13): {}},
			(9, 14): {(8, 14): {}, (9, 13): {}, (9, 15): {}, (10, 14): {}},
			(9, 15): {(8, 15): {}, (9, 14): {}, (9, 16): {}, (10, 15): {}},
			(9, 16): {(8, 16): {}, (9, 15): {}, (9, 17): {}, (10, 16): {}},
			(9, 17): {(8, 17): {}, (9, 16): {}, (9, 18): {}, (10, 17): {}},
			(9, 18): {(8, 18): {}, (9, 17): {}, (9, 19): {}, (10, 18): {}},
			(9, 19): {(8, 19): {}, (9, 18): {}, (9, 20): {}, (10, 19): {}},
			(9, 20): {(8, 20): {}, (9, 19): {}, (9, 21): {}, (10, 20): {}},
			(9, 21): {(8, 21): {}, (9, 20): {}, (9, 22): {}, (10, 21): {}},
			(9, 22): {(8, 22): {}, (9, 21): {}, (9, 23): {}, (10, 22): {}},
			(9, 23): {(8, 23): {}, (9, 22): {}, (9, 24): {}, (10, 23): {}},
			(9, 24): {(8, 24): {}, (9, 23): {}, (10, 24): {}},
			(10, 0): {(9, 0): {}, (10, 1): {}, (11, 0): {}},
			(10, 1): {(9, 1): {}, (10, 0): {}, (10, 2): {}, (11, 1): {}},
			(10, 2): {(9, 2): {}, (10, 1): {}, (10, 3): {}, (11, 2): {}},
			(10, 3): {(9, 3): {}, (10, 2): {}, (10, 4): {}, (11, 3): {}},
			(10, 4): {(9, 4): {}, (10, 3): {}, (10, 5): {}, (11, 4): {}},
			(10, 5): {(9, 5): {}, (10, 4): {}, (10, 6): {}, (11, 5): {}},
			(10, 6): {(9, 6): {}, (10, 5): {}, (10, 7): {}, (11, 6): {}},
			(10, 7): {(9, 7): {}, (10, 6): {}, (10, 8): {}, (11, 7): {}},
			(10, 8): {(9, 8): {}, (10, 7): {}, (10, 9): {}, (11, 8): {}},
			(10, 9): {(9, 9): {}, (10, 8): {}, (10, 10): {}, (11, 9): {}},
			(10, 10): {(9, 10): {}, (10, 9): {}, (10, 11): {}, (11, 10): {}},
			(10, 11): {(9, 11): {}, (10, 10): {}, (10, 12): {}, (11, 11): {}},
			(10, 12): {(9, 12): {}, (10, 11): {}, (10, 13): {}, (11, 12): {}},
			(10, 13): {(9, 13): {}, (10, 12): {}, (10, 14): {}, (11, 13): {}},
			(10, 14): {(9, 14): {}, (10, 13): {}, (10, 15): {}, (11, 14): {}},
			(10, 15): {(9, 15): {}, (10, 14): {}, (10, 16): {}, (11, 15): {}},
			(10, 16): {(9, 16): {}, (10, 15): {}, (10, 17): {}, (11, 16): {}},
			(10, 17): {(9, 17): {}, (10, 16): {}, (10, 18): {}, (11, 17): {}},
			(10, 18): {(9, 18): {}, (10, 17): {}, (10, 19): {}, (11, 18): {}},
			(10, 19): {(9, 19): {}, (10, 18): {}, (10, 20): {}, (11, 19): {}},
			(10, 20): {(9, 20): {}, (10, 19): {}, (10, 21): {}, (11, 20): {}},
			(10, 21): {(9, 21): {}, (10, 20): {}, (10, 22): {}, (11, 21): {}},
			(10, 22): {(9, 22): {}, (10, 21): {}, (10, 23): {}, (11, 22): {}},
			(10, 23): {(9, 23): {}, (10, 22): {}, (10, 24): {}, (11, 23): {}},
			(10, 24): {(9, 24): {}, (10, 23): {}, (11, 24): {}},
			(11, 0): {(10, 0): {}, (11, 1): {}, (12, 0): {}},
			(11, 1): {(10, 1): {}, (11, 0): {}, (11, 2): {}, (12, 1): {}},
			(11, 2): {(10, 2): {}, (11, 1): {}, (11, 3): {}, (12, 2): {}},
			(11, 3): {(10, 3): {}, (11, 2): {}, (11, 4): {}, (12, 3): {}},
			(11, 4): {(10, 4): {}, (11, 3): {}, (11, 5): {}, (12, 4): {}},
			(11, 5): {(10, 5): {}, (11, 4): {}, (11, 6): {}, (12, 5): {}},
			(11, 6): {(10, 6): {}, (11, 5): {}, (11, 7): {}, (12, 6): {}},
			(11, 7): {(10, 7): {}, (11, 6): {}, (11, 8): {}, (12, 7): {}},
			(11, 8): {(10, 8): {}, (11, 7): {}, (11, 9): {}, (12, 8): {}},
			(11, 9): {(10, 9): {}, (11, 8): {}, (11, 10): {}, (12, 9): {}},
			(11, 10): {(10, 10): {}, (11, 9): {}, (11, 11): {}, (12, 10): {}},
			(11, 11): {(10, 11): {}, (11, 10): {}, (11, 12): {}, (12, 11): {}},
			(11, 12): {(10, 12): {}, (11, 11): {}, (11, 13): {}, (12, 12): {}},
			(11, 13): {(10, 13): {}, (11, 12): {}, (11, 14): {}, (12, 13): {}},
			(11, 14): {(10, 14): {}, (11, 13): {}, (11, 15): {}, (12, 14): {}},
			(11, 15): {(10, 15): {}, (11, 14): {}, (11, 16): {}, (12, 15): {}},
			(11, 16): {(10, 16): {}, (11, 15): {}, (11, 17): {}, (12, 16): {}},
			(11, 17): {(10, 17): {}, (11, 16): {}, (11, 18): {}, (12, 17): {}},
			(11, 18): {(10, 18): {}, (11, 17): {}, (11, 19): {}, (12, 18): {}},
			(11, 19): {(10, 19): {}, (11, 18): {}, (11, 20): {}, (12, 19): {}},
			(11, 20): {(10, 20): {}, (11, 19): {}, (11, 21): {}, (12, 20): {}},
			(11, 21): {(10, 21): {}, (11, 20): {}, (11, 22): {}, (12, 21): {}},
			(11, 22): {(10, 22): {}, (11, 21): {}, (11, 23): {}, (12, 22): {}},
			(11, 23): {(10, 23): {}, (11, 22): {}, (11, 24): {}, (12, 23): {}},
			(11, 24): {(10, 24): {}, (11, 23): {}, (12, 24): {}},
			(12, 0): {(11, 0): {}, (12, 1): {}, (13, 0): {}},
			(12, 1): {(11, 1): {}, (12, 0): {}, (12, 2): {}, (13, 1): {}},
			(12, 2): {(11, 2): {}, (12, 1): {}, (12, 3): {}, (13, 2): {}},
			(12, 3): {(11, 3): {}, (12, 2): {}, (12, 4): {}, (13, 3): {}},
			(12, 4): {(11, 4): {}, (12, 3): {}, (12, 5): {}, (13, 4): {}},
			(12, 5): {(11, 5): {}, (12, 4): {}, (12, 6): {}, (13, 5): {}},
			(12, 6): {(11, 6): {}, (12, 5): {}, (12, 7): {}, (13, 6): {}},
			(12, 7): {(11, 7): {}, (12, 6): {}, (12, 8): {}, (13, 7): {}},
			(12, 8): {(11, 8): {}, (12, 7): {}, (12, 9): {}, (13, 8): {}},
			(12, 9): {(11, 9): {}, (12, 8): {}, (12, 10): {}, (13, 9): {}},
			(12, 10): {(11, 10): {}, (12, 9): {}, (12, 11): {}, (13, 10): {}},
			(12, 11): {(11, 11): {}, (12, 10): {}, (12, 12): {}, (13, 11): {}},
			(12, 12): {(11, 12): {}, (12, 11): {}, (12, 13): {}, (13, 12): {}},
			(12, 13): {(11, 13): {}, (12, 12): {}, (12, 14): {}, (13, 13): {}},
			(12, 14): {(11, 14): {}, (12, 13): {}, (12, 15): {}, (13, 14): {}},
			(12, 15): {(11, 15): {}, (12, 14): {}, (12, 16): {}, (13, 15): {}},
			(12, 16): {(11, 16): {}, (12, 15): {}, (12, 17): {}, (13, 16): {}},
			(12, 17): {(11, 17): {}, (12, 16): {}, (12, 18): {}, (13, 17): {}},
			(12, 18): {(11, 18): {}, (12, 17): {}, (12, 19): {}, (13, 18): {}},
			(12, 19): {(11, 19): {}, (12, 18): {}, (12, 20): {}, (13, 19): {}},
			(12, 20): {(11, 20): {}, (12, 19): {}, (12, 21): {}, (13, 20): {}},
			(12, 21): {(11, 21): {}, (12, 20): {}, (12, 22): {}, (13, 21): {}},
			(12, 22): {(11, 22): {}, (12, 21): {}, (12, 23): {}, (13, 22): {}},
			(12, 23): {(11, 23): {}, (12, 22): {}, (12, 24): {}, (13, 23): {}},
			(12, 24): {(11, 24): {}, (12, 23): {}, (13, 24): {}},
			(13, 0): {(12, 0): {}, (13, 1): {}, (14, 0): {}},
			(13, 1): {(12, 1): {}, (13, 0): {}, (13, 2): {}, (14, 1): {}},
			(13, 2): {(12, 2): {}, (13, 1): {}, (13, 3): {}, (14, 2): {}},
			(13, 3): {(12, 3): {}, (13, 2): {}, (13, 4): {}, (14, 3): {}},
			(13, 4): {(12, 4): {}, (13, 3): {}, (13, 5): {}, (14, 4): {}},
			(13, 5): {(12, 5): {}, (13, 4): {}, (13, 6): {}, (14, 5): {}},
			(13, 6): {(12, 6): {}, (13, 5): {}, (13, 7): {}, (14, 6): {}},
			(13, 7): {(12, 7): {}, (13, 6): {}, (13, 8): {}, (14, 7): {}},
			(13, 8): {(12, 8): {}, (13, 7): {}, (13, 9): {}, (14, 8): {}},
			(13, 9): {(12, 9): {}, (13, 8): {}, (13, 10): {}, (14, 9): {}},
			(13, 10): {(12, 10): {}, (13, 9): {}, (13, 11): {}, (14, 10): {}},
			(13, 11): {(12, 11): {}, (13, 10): {}, (13, 12): {}, (14, 11): {}},
			(13, 12): {(12, 12): {}, (13, 11): {}, (13, 13): {}, (14, 12): {}},
			(13, 13): {(12, 13): {}, (13, 12): {}, (13, 14): {}, (14, 13): {}},
			(13, 14): {(12, 14): {}, (13, 13): {}, (13, 15): {}, (14, 14): {}},
			(13, 15): {(12, 15): {}, (13, 14): {}, (13, 16): {}, (14, 15): {}},
			(13, 16): {(12, 16): {}, (13, 15): {}, (13, 17): {}, (14, 16): {}},
			(13, 17): {(12, 17): {}, (13, 16): {}, (13, 18): {}, (14, 17): {}},
			(13, 18): {(12, 18): {}, (13, 17): {}, (13, 19): {}, (14, 18): {}},
			(13, 19): {(12, 19): {}, (13, 18): {}, (13, 20): {}, (14, 19): {}},
			(13, 20): {(12, 20): {}, (13, 19): {}, (13, 21): {}, (14, 20): {}},
			(13, 21): {(12, 21): {}, (13, 20): {}, (13, 22): {}, (14, 21): {}},
			(13, 22): {(12, 22): {}, (13, 21): {}, (13, 23): {}, (14, 22): {}},
			(13, 23): {(12, 23): {}, (13, 22): {}, (13, 24): {}, (14, 23): {}},
			(13, 24): {(12, 24): {}, (13, 23): {}, (14, 24): {}},
			(14, 0): {(13, 0): {}, (14, 1): {}, (15, 0): {}},
			(14, 1): {(13, 1): {}, (14, 0): {}, (14, 2): {}, (15, 1): {}},
			(14, 2): {(13, 2): {}, (14, 1): {}, (14, 3): {}, (15, 2): {}},
			(14, 3): {(13, 3): {}, (14, 2): {}, (14, 4): {}, (15, 3): {}},
			(14, 4): {(13, 4): {}, (14, 3): {}, (14, 5): {}, (15, 4): {}},
			(14, 5): {(13, 5): {}, (14, 4): {}, (14, 6): {}, (15, 5): {}},
			(14, 6): {(13, 6): {}, (14, 5): {}, (14, 7): {}, (15, 6): {}},
			(14, 7): {(13, 7): {}, (14, 6): {}, (14, 8): {}, (15, 7): {}},
			(14, 8): {(13, 8): {}, (14, 7): {}, (14, 9): {}, (15, 8): {}},
			(14, 9): {(13, 9): {}, (14, 8): {}, (14, 10): {}, (15, 9): {}},
			(14, 10): {(13, 10): {}, (14, 9): {}, (14, 11): {}, (15, 10): {}},
			(14, 11): {(13, 11): {}, (14, 10): {}, (14, 12): {}, (15, 11): {}},
			(14, 12): {(13, 12): {}, (14, 11): {}, (14, 13): {}, (15, 12): {}},
			(14, 13): {(13, 13): {}, (14, 12): {}, (14, 14): {}, (15, 13): {}},
			(14, 14): {(13, 14): {}, (14, 13): {}, (14, 15): {}, (15, 14): {}},
			(14, 15): {(13, 15): {}, (14, 14): {}, (14, 16): {}, (15, 15): {}},
			(14, 16): {(13, 16): {}, (14, 15): {}, (14, 17): {}, (15, 16): {}},
			(14, 17): {(13, 17): {}, (14, 16): {}, (14, 18): {}, (15, 17): {}},
			(14, 18): {(13, 18): {}, (14, 17): {}, (14, 19): {}, (15, 18): {}},
			(14, 19): {(13, 19): {}, (14, 18): {}, (14, 20): {}, (15, 19): {}},
			(14, 20): {(13, 20): {}, (14, 19): {}, (14, 21): {}, (15, 20): {}},
			(14, 21): {(13, 21): {}, (14, 20): {}, (14, 22): {}, (15, 21): {}},
			(14, 22): {(13, 22): {}, (14, 21): {}, (14, 23): {}, (15, 22): {}},
			(14, 23): {(13, 23): {}, (14, 22): {}, (14, 24): {}, (15, 23): {}},
			(14, 24): {(13, 24): {}, (14, 23): {}, (15, 24): {}},
			(15, 0): {(14, 0): {}, (15, 1): {}, (16, 0): {}},
			(15, 1): {(14, 1): {}, (15, 0): {}, (15, 2): {}, (16, 1): {}},
			(15, 2): {(14, 2): {}, (15, 1): {}, (15, 3): {}, (16, 2): {}},
			(15, 3): {(14, 3): {}, (15, 2): {}, (15, 4): {}, (16, 3): {}},
			(15, 4): {(14, 4): {}, (15, 3): {}, (15, 5): {}, (16, 4): {}},
			(15, 5): {(14, 5): {}, (15, 4): {}, (15, 6): {}, (16, 5): {}},
			(15, 6): {(14, 6): {}, (15, 5): {}, (15, 7): {}, (16, 6): {}},
			(15, 7): {(14, 7): {}, (15, 6): {}, (15, 8): {}, (16, 7): {}},
			(15, 8): {(14, 8): {}, (15, 7): {}, (15, 9): {}, (16, 8): {}},
			(15, 9): {(14, 9): {}, (15, 8): {}, (15, 10): {}, (16, 9): {}},
			(15, 10): {(14, 10): {}, (15, 9): {}, (15, 11): {}, (16, 10): {}},
			(15, 11): {(14, 11): {}, (15, 10): {}, (15, 12): {}, (16, 11): {}},
			(15, 12): {(14, 12): {}, (15, 11): {}, (15, 13): {}, (16, 12): {}},
			(15, 13): {(14, 13): {}, (15, 12): {}, (15, 14): {}, (16, 13): {}},
			(15, 14): {(14, 14): {}, (15, 13): {}, (15, 15): {}, (16, 14): {}},
			(15, 15): {(14, 15): {}, (15, 14): {}, (15, 16): {}, (16, 15): {}},
			(15, 16): {(14, 16): {}, (15, 15): {}, (15, 17): {}, (16, 16): {}},
			(15, 17): {(14, 17): {}, (15, 16): {}, (15, 18): {}, (16, 17): {}},
			(15, 18): {(14, 18): {}, (15, 17): {}, (15, 19): {}, (16, 18): {}},
			(15, 19): {(14, 19): {}, (15, 18): {}, (15, 20): {}, (16, 19): {}},
			(15, 20): {(14, 20): {}, (15, 19): {}, (15, 21): {}, (16, 20): {}},
			(15, 21): {(14, 21): {}, (15, 20): {}, (15, 22): {}, (16, 21): {}},
			(15, 22): {(14, 22): {}, (15, 21): {}, (15, 23): {}, (16, 22): {}},
			(15, 23): {(14, 23): {}, (15, 22): {}, (15, 24): {}, (16, 23): {}},
			(15, 24): {(14, 24): {}, (15, 23): {}, (16, 24): {}},
			(16, 0): {(15, 0): {}, (16, 1): {}, (17, 0): {}},
			(16, 1): {(15, 1): {}, (16, 0): {}, (16, 2): {}, (17, 1): {}},
			(16, 2): {(15, 2): {}, (16, 1): {}, (16, 3): {}, (17, 2): {}},
			(16, 3): {(15, 3): {}, (16, 2): {}, (16, 4): {}, (17, 3): {}},
			(16, 4): {(15, 4): {}, (16, 3): {}, (16, 5): {}, (17, 4): {}},
			(16, 5): {(15, 5): {}, (16, 4): {}, (16, 6): {}, (17, 5): {}},
			(16, 6): {(15, 6): {}, (16, 5): {}, (16, 7): {}, (17, 6): {}},
			(16, 7): {(15, 7): {}, (16, 6): {}, (16, 8): {}, (17, 7): {}},
			(16, 8): {(15, 8): {}, (16, 7): {}, (16, 9): {}, (17, 8): {}},
			(16, 9): {(15, 9): {}, (16, 8): {}, (16, 10): {}, (17, 9): {}},
			(16, 10): {(15, 10): {}, (16, 9): {}, (16, 11): {}, (17, 10): {}},
			(16, 11): {(15, 11): {}, (16, 10): {}, (16, 12): {}, (17, 11): {}},
			(16, 12): {(15, 12): {}, (16, 11): {}, (16, 13): {}, (17, 12): {}},
			(16, 13): {(15, 13): {}, (16, 12): {}, (16, 14): {}, (17, 13): {}},
			(16, 14): {(15, 14): {}, (16, 13): {}, (16, 15): {}, (17, 14): {}},
			(16, 15): {(15, 15): {}, (16, 14): {}, (16, 16): {}, (17, 15): {}},
			(16, 16): {(15, 16): {}, (16, 15): {}, (16, 17): {}, (17, 16): {}},
			(16, 17): {(15, 17): {}, (16, 16): {}, (16, 18): {}, (17, 17): {}},
			(16, 18): {(15, 18): {}, (16, 17): {}, (16, 19): {}, (17, 18): {}},
			(16, 19): {(15, 19): {}, (16, 18): {}, (16, 20): {}, (17, 19): {}},
			(16, 20): {(15, 20): {}, (16, 19): {}, (16, 21): {}, (17, 20): {}},
			(16, 21): {(15, 21): {}, (16, 20): {}, (16, 22): {}, (17, 21): {}},
			(16, 22): {(15, 22): {}, (16, 21): {}, (16, 23): {}, (17, 22): {}},
			(16, 23): {(15, 23): {}, (16, 22): {}, (16, 24): {}, (17, 23): {}},
			(16, 24): {(15, 24): {}, (16, 23): {}, (17, 24): {}},
			(17, 0): {(16, 0): {}, (17, 1): {}, (18, 0): {}},
			(17, 1): {(16, 1): {}, (17, 0): {}, (17, 2): {}, (18, 1): {}},
			(17, 2): {(16, 2): {}, (17, 1): {}, (17, 3): {}, (18, 2): {}},
			(17, 3): {(16, 3): {}, (17, 2): {}, (17, 4): {}, (18, 3): {}},
			(17, 4): {(16, 4): {}, (17, 3): {}, (17, 5): {}, (18, 4): {}},
			(17, 5): {(16, 5): {}, (17, 4): {}, (17, 6): {}, (18, 5): {}},
			(17, 6): {(16, 6): {}, (17, 5): {}, (17, 7): {}, (18, 6): {}},
			(17, 7): {(16, 7): {}, (17, 6): {}, (17, 8): {}, (18, 7): {}},
			(17, 8): {(16, 8): {}, (17, 7): {}, (17, 9): {}, (18, 8): {}},
			(17, 9): {(16, 9): {}, (17, 8): {}, (17, 10): {}, (18, 9): {}},
			(17, 10): {(16, 10): {}, (17, 9): {}, (17, 11): {}, (18, 10): {}},
			(17, 11): {(16, 11): {}, (17, 10): {}, (17, 12): {}, (18, 11): {}},
			(17, 12): {(16, 12): {}, (17, 11): {}, (17, 13): {}, (18, 12): {}},
			(17, 13): {(16, 13): {}, (17, 12): {}, (17, 14): {}, (18, 13): {}},
			(17, 14): {(16, 14): {}, (17, 13): {}, (17, 15): {}, (18, 14): {}},
			(17, 15): {(16, 15): {}, (17, 14): {}, (17, 16): {}, (18, 15): {}},
			(17, 16): {(16, 16): {}, (17, 15): {}, (17, 17): {}, (18, 16): {}},
			(17, 17): {(16, 17): {}, (17, 16): {}, (17, 18): {}, (18, 17): {}},
			(17, 18): {(16, 18): {}, (17, 17): {}, (17, 19): {}, (18, 18): {}},
			(17, 19): {(16, 19): {}, (17, 18): {}, (17, 20): {}, (18, 19): {}},
			(17, 20): {(16, 20): {}, (17, 19): {}, (17, 21): {}, (18, 20): {}},
			(17, 21): {(16, 21): {}, (17, 20): {}, (17, 22): {}, (18, 21): {}},
			(17, 22): {(16, 22): {}, (17, 21): {}, (17, 23): {}, (18, 22): {}},
			(17, 23): {(16, 23): {}, (17, 22): {}, (17, 24): {}, (18, 23): {}},
			(17, 24): {(16, 24): {}, (17, 23): {}, (18, 24): {}},
			(18, 0): {(17, 0): {}, (18, 1): {}, (19, 0): {}},
			(18, 1): {(17, 1): {}, (18, 0): {}, (18, 2): {}, (19, 1): {}},
			(18, 2): {(17, 2): {}, (18, 1): {}, (18, 3): {}, (19, 2): {}},
			(18, 3): {(17, 3): {}, (18, 2): {}, (18, 4): {}, (19, 3): {}},
			(18, 4): {(17, 4): {}, (18, 3): {}, (18, 5): {}, (19, 4): {}},
			(18, 5): {(17, 5): {}, (18, 4): {}, (18, 6): {}, (19, 5): {}},
			(18, 6): {(17, 6): {}, (18, 5): {}, (18, 7): {}, (19, 6): {}},
			(18, 7): {(17, 7): {}, (18, 6): {}, (18, 8): {}, (19, 7): {}},
			(18, 8): {(17, 8): {}, (18, 7): {}, (18, 9): {}, (19, 8): {}},
			(18, 9): {(17, 9): {}, (18, 8): {}, (18, 10): {}, (19, 9): {}},
			(18, 10): {(17, 10): {}, (18, 9): {}, (18, 11): {}, (19, 10): {}},
			(18, 11): {(17, 11): {}, (18, 10): {}, (18, 12): {}, (19, 11): {}},
			(18, 12): {(17, 12): {}, (18, 11): {}, (18, 13): {}, (19, 12): {}},
			(18, 13): {(17, 13): {}, (18, 12): {}, (18, 14): {}, (19, 13): {}},
			(18, 14): {(17, 14): {}, (18, 13): {}, (18, 15): {}, (19, 14): {}},
			(18, 15): {(17, 15): {}, (18, 14): {}, (18, 16): {}, (19, 15): {}},
			(18, 16): {(17, 16): {}, (18, 15): {}, (18, 17): {}, (19, 16): {}},
			(18, 17): {(17, 17): {}, (18, 16): {}, (18, 18): {}, (19, 17): {}},
			(18, 18): {(17, 18): {}, (18, 17): {}, (18, 19): {}, (19, 18): {}},
			(18, 19): {(17, 19): {}, (18, 18): {}, (18, 20): {}, (19, 19): {}},
			(18, 20): {(17, 20): {}, (18, 19): {}, (18, 21): {}, (19, 20): {}},
			(18, 21): {(17, 21): {}, (18, 20): {}, (18, 22): {}, (19, 21): {}},
			(18, 22): {(17, 22): {}, (18, 21): {}, (18, 23): {}, (19, 22): {}},
			(18, 23): {(17, 23): {}, (18, 22): {}, (18, 24): {}, (19, 23): {}},
			(18, 24): {(17, 24): {}, (18, 23): {}, (19, 24): {}},
			(19, 0): {(18, 0): {}, (19, 1): {}, (20, 0): {}},
			(19, 1): {(18, 1): {}, (19, 0): {}, (19, 2): {}, (20, 1): {}},
			(19, 2): {(18, 2): {}, (19, 1): {}, (19, 3): {}, (20, 2): {}},
			(19, 3): {(18, 3): {}, (19, 2): {}, (19, 4): {}, (20, 3): {}},
			(19, 4): {(18, 4): {}, (19, 3): {}, (19, 5): {}, (20, 4): {}},
			(19, 5): {(18, 5): {}, (19, 4): {}, (19, 6): {}, (20, 5): {}},
			(19, 6): {(18, 6): {}, (19, 5): {}, (19, 7): {}, (20, 6): {}},
			(19, 7): {(18, 7): {}, (19, 6): {}, (19, 8): {}, (20, 7): {}},
			(19, 8): {(18, 8): {}, (19, 7): {}, (19, 9): {}, (20, 8): {}},
			(19, 9): {(18, 9): {}, (19, 8): {}, (19, 10): {}, (20, 9): {}},
			(19, 10): {(18, 10): {}, (19, 9): {}, (19, 11): {}, (20, 10): {}},
			(19, 11): {(18, 11): {}, (19, 10): {}, (19, 12): {}, (20, 11): {}},
			(19, 12): {(18, 12): {}, (19, 11): {}, (19, 13): {}, (20, 12): {}},
			(19, 13): {(18, 13): {}, (19, 12): {}, (19, 14): {}, (20, 13): {}},
			(19, 14): {(18, 14): {}, (19, 13): {}, (19, 15): {}, (20, 14): {}},
			(19, 15): {(18, 15): {}, (19, 14): {}, (19, 16): {}, (20, 15): {}},
			(19, 16): {(18, 16): {}, (19, 15): {}, (19, 17): {}, (20, 16): {}},
			(19, 17): {(18, 17): {}, (19, 16): {}, (19, 18): {}, (20, 17): {}},
			(19, 18): {(18, 18): {}, (19, 17): {}, (19, 19): {}, (20, 18): {}},
			(19, 19): {(18, 19): {}, (19, 18): {}, (19, 20): {}, (20, 19): {}},
			(19, 20): {(18, 20): {}, (19, 19): {}, (19, 21): {}, (20, 20): {}},
			(19, 21): {(18, 21): {}, (19, 20): {}, (19, 22): {}, (20, 21): {}},
			(19, 22): {(18, 22): {}, (19, 21): {}, (19, 23): {}, (20, 22): {}},
			(19, 23): {(18, 23): {}, (19, 22): {}, (19, 24): {}, (20, 23): {}},
			(19, 24): {(18, 24): {}, (19, 23): {}, (20, 24): {}},
			(20, 0): {(19, 0): {}, (20, 1): {}, (21, 0): {}},
			(20, 1): {(19, 1): {}, (20, 0): {}, (20, 2): {}, (21, 1): {}},
			(20, 2): {(19, 2): {}, (20, 1): {}, (20, 3): {}, (21, 2): {}},
			(20, 3): {(19, 3): {}, (20, 2): {}, (20, 4): {}, (21, 3): {}},
			(20, 4): {(19, 4): {}, (20, 3): {}, (20, 5): {}, (21, 4): {}},
			(20, 5): {(19, 5): {}, (20, 4): {}, (20, 6): {}, (21, 5): {}},
			(20, 6): {(19, 6): {}, (20, 5): {}, (20, 7): {}, (21, 6): {}},
			(20, 7): {(19, 7): {}, (20, 6): {}, (20, 8): {}, (21, 7): {}},
			(20, 8): {(19, 8): {}, (20, 7): {}, (20, 9): {}, (21, 8): {}},
			(20, 9): {(19, 9): {}, (20, 8): {}, (20, 10): {}, (21, 9): {}},
			(20, 10): {(19, 10): {}, (20, 9): {}, (20, 11): {}, (21, 10): {}},
			(20, 11): {(19, 11): {}, (20, 10): {}, (20, 12): {}, (21, 11): {}},
			(20, 12): {(19, 12): {}, (20, 11): {}, (20, 13): {}, (21, 12): {}},
			(20, 13): {(19, 13): {}, (20, 12): {}, (20, 14): {}, (21, 13): {}},
			(20, 14): {(19, 14): {}, (20, 13): {}, (20, 15): {}, (21, 14): {}},
			(20, 15): {(19, 15): {}, (20, 14): {}, (20, 16): {}, (21, 15): {}},
			(20, 16): {(19, 16): {}, (20, 15): {}, (20, 17): {}, (21, 16): {}},
			(20, 17): {(19, 17): {}, (20, 16): {}, (20, 18): {}, (21, 17): {}},
			(20, 18): {(19, 18): {}, (20, 17): {}, (20, 19): {}, (21, 18): {}},
			(20, 19): {(19, 19): {}, (20, 18): {}, (20, 20): {}, (21, 19): {}},
			(20, 20): {(19, 20): {}, (20, 19): {}, (20, 21): {}, (21, 20): {}},
			(20, 21): {(19, 21): {}, (20, 20): {}, (20, 22): {}, (21, 21): {}},
			(20, 22): {(19, 22): {}, (20, 21): {}, (20, 23): {}, (21, 22): {}},
			(20, 23): {(19, 23): {}, (20, 22): {}, (20, 24): {}, (21, 23): {}},
			(20, 24): {(19, 24): {}, (20, 23): {}, (21, 24): {}},
			(21, 0): {(20, 0): {}, (21, 1): {}, (22, 0): {}},
			(21, 1): {(20, 1): {}, (21, 0): {}, (21, 2): {}, (22, 1): {}},
			(21, 2): {(20, 2): {}, (21, 1): {}, (21, 3): {}, (22, 2): {}},
			(21, 3): {(20, 3): {}, (21, 2): {}, (21, 4): {}, (22, 3): {}},
			(21, 4): {(20, 4): {}, (21, 3): {}, (21, 5): {}, (22, 4): {}},
			(21, 5): {(20, 5): {}, (21, 4): {}, (21, 6): {}, (22, 5): {}},
			(21, 6): {(20, 6): {}, (21, 5): {}, (21, 7): {}, (22, 6): {}},
			(21, 7): {(20, 7): {}, (21, 6): {}, (21, 8): {}, (22, 7): {}},
			(21, 8): {(20, 8): {}, (21, 7): {}, (21, 9): {}, (22, 8): {}},
			(21, 9): {(20, 9): {}, (21, 8): {}, (21, 10): {}, (22, 9): {}},
			(21, 10): {(20, 10): {}, (21, 9): {}, (21, 11): {}, (22, 10): {}},
			(21, 11): {(20, 11): {}, (21, 10): {}, (21, 12): {}, (22, 11): {}},
			(21, 12): {(20, 12): {}, (21, 11): {}, (21, 13): {}, (22, 12): {}},
			(21, 13): {(20, 13): {}, (21, 12): {}, (21, 14): {}, (22, 13): {}},
			(21, 14): {(20, 14): {}, (21, 13): {}, (21, 15): {}, (22, 14): {}},
			(21, 15): {(20, 15): {}, (21, 14): {}, (21, 16): {}, (22, 15): {}},
			(21, 16): {(20, 16): {}, (21, 15): {}, (21, 17): {}, (22, 16): {}},
			(21, 17): {(20, 17): {}, (21, 16): {}, (21, 18): {}, (22, 17): {}},
			(21, 18): {(20, 18): {}, (21, 17): {}, (21, 19): {}, (22, 18): {}},
			(21, 19): {(20, 19): {}, (21, 18): {}, (21, 20): {}, (22, 19): {}},
			(21, 20): {(20, 20): {}, (21, 19): {}, (21, 21): {}, (22, 20): {}},
			(21, 21): {(20, 21): {}, (21, 20): {}, (21, 22): {}, (22, 21): {}},
			(21, 22): {(20, 22): {}, (21, 21): {}, (21, 23): {}, (22, 22): {}},
			(21, 23): {(20, 23): {}, (21, 22): {}, (21, 24): {}, (22, 23): {}},
			(21, 24): {(20, 24): {}, (21, 23): {}, (22, 24): {}},
			(22, 0): {(21, 0): {}, (22, 1): {}, (23, 0): {}},
			(22, 1): {(21, 1): {}, (22, 0): {}, (22, 2): {}, (23, 1): {}},
			(22, 2): {(21, 2): {}, (22, 1): {}, (22, 3): {}, (23, 2): {}},
			(22, 3): {(21, 3): {}, (22, 2): {}, (22, 4): {}, (23, 3): {}},
			(22, 4): {(21, 4): {}, (22, 3): {}, (22, 5): {}, (23, 4): {}},
			(22, 5): {(21, 5): {}, (22, 4): {}, (22, 6): {}, (23, 5): {}},
			(22, 6): {(21, 6): {}, (22, 5): {}, (22, 7): {}, (23, 6): {}},
			(22, 7): {(21, 7): {}, (22, 6): {}, (22, 8): {}, (23, 7): {}},
			(22, 8): {(21, 8): {}, (22, 7): {}, (22, 9): {}, (23, 8): {}},
			(22, 9): {(21, 9): {}, (22, 8): {}, (22, 10): {}, (23, 9): {}},
			(22, 10): {(21, 10): {}, (22, 9): {}, (22, 11): {}, (23, 10): {}},
			(22, 11): {(21, 11): {}, (22, 10): {}, (22, 12): {}, (23, 11): {}},
			(22, 12): {(21, 12): {}, (22, 11): {}, (22, 13): {}, (23, 12): {}},
			(22, 13): {(21, 13): {}, (22, 12): {}, (22, 14): {}, (23, 13): {}},
			(22, 14): {(21, 14): {}, (22, 13): {}, (22, 15): {}, (23, 14): {}},
			(22, 15): {(21, 15): {}, (22, 14): {}, (22, 16): {}, (23, 15): {}},
			(22, 16): {(21, 16): {}, (22, 15): {}, (22, 17): {}, (23, 16): {}},
			(22, 17): {(21, 17): {}, (22, 16): {}, (22, 18): {}, (23, 17): {}},
			(22, 18): {(21, 18): {}, (22, 17): {}, (22, 19): {}, (23, 18): {}},
			(22, 19): {(21, 19): {}, (22, 18): {}, (22, 20): {}, (23, 19): {}},
			(22, 20): {(21, 20): {}, (22, 19): {}, (22, 21): {}, (23, 20): {}},
			(22, 21): {(21, 21): {}, (22, 20): {}, (22, 22): {}, (23, 21): {}},
			(22, 22): {(21, 22): {}, (22, 21): {}, (22, 23): {}, (23, 22): {}},
			(22, 23): {(21, 23): {}, (22, 22): {}, (22, 24): {}, (23, 23): {}},
			(22, 24): {(21, 24): {}, (22, 23): {}, (23, 24): {}},
			(23, 0): {(22, 0): {}, (23, 1): {}, (24, 0): {}},
			(23, 1): {(22, 1): {}, (23, 0): {}, (23, 2): {}, (24, 1): {}},
			(23, 2): {(22, 2): {}, (23, 1): {}, (23, 3): {}, (24, 2): {}},
			(23, 3): {(22, 3): {}, (23, 2): {}, (23, 4): {}, (24, 3): {}},
			(23, 4): {(22, 4): {}, (23, 3): {}, (23, 5): {}, (24, 4): {}},
			(23, 5): {(22, 5): {}, (23, 4): {}, (23, 6): {}, (24, 5): {}},
			(23, 6): {(22, 6): {}, (23, 5): {}, (23, 7): {}, (24, 6): {}},
			(23, 7): {(22, 7): {}, (23, 6): {}, (23, 8): {}, (24, 7): {}},
			(23, 8): {(22, 8): {}, (23, 7): {}, (23, 9): {}, (24, 8): {}},
			(23, 9): {(22, 9): {}, (23, 8): {}, (23, 10): {}, (24, 9): {}},
			(23, 10): {(22, 10): {}, (23, 9): {}, (23, 11): {}, (24, 10): {}},
			(23, 11): {(22, 11): {}, (23, 10): {}, (23, 12): {}, (24, 11): {}},
			(23, 12): {(22, 12): {}, (23, 11): {}, (23, 13): {}, (24, 12): {}},
			(23, 13): {(22, 13): {}, (23, 12): {}, (23, 14): {}, (24, 13): {}},
			(23, 14): {(22, 14): {}, (23, 13): {}, (23, 15): {}, (24, 14): {}},
			(23, 15): {(22, 15): {}, (23, 14): {}, (23, 16): {}, (24, 15): {}},
			(23, 16): {(22, 16): {}, (23, 15): {}, (23, 17): {}, (24, 16): {}},
			(23, 17): {(22, 17): {}, (23, 16): {}, (23, 18): {}, (24, 17): {}},
			(23, 18): {(22, 18): {}, (23, 17): {}, (23, 19): {}, (24, 18): {}},
			(23, 19): {(22, 19): {}, (23, 18): {}, (23, 20): {}, (24, 19): {}},
			(23, 20): {(22, 20): {}, (23, 19): {}, (23, 21): {}, (24, 20): {}},
			(23, 21): {(22, 21): {}, (23, 20): {}, (23, 22): {}, (24, 21): {}},
			(23, 22): {(22, 22): {}, (23, 21): {}, (23, 23): {}, (24, 22): {}},
			(23, 23): {(22, 23): {}, (23, 22): {}, (23, 24): {}, (24, 23): {}},
			(23, 24): {(22, 24): {}, (23, 23): {}, (24, 24): {}},
			(24, 0): {(23, 0): {}, (24, 1): {}},
			(24, 1): {(23, 1): {}, (24, 0): {}, (24, 2): {}},
			(24, 2): {(23, 2): {}, (24, 1): {}, (24, 3): {}},
			(24, 3): {(23, 3): {}, (24, 2): {}, (24, 4): {}},
			(24, 4): {(23, 4): {}, (24, 3): {}, (24, 5): {}},
			(24, 5): {(23, 5): {}, (24, 4): {}, (24, 6): {}},
			(24, 6): {(23, 6): {}, (24, 5): {}, (24, 7): {}},
			(24, 7): {(23, 7): {}, (24, 6): {}, (24, 8): {}},
			(24, 8): {(23, 8): {}, (24, 7): {}, (24, 9): {}},
			(24, 9): {(23, 9): {}, (24, 8): {}, (24, 10): {}},
			(24, 10): {(23, 10): {}, (24, 9): {}, (24, 11): {}},
			(24, 11): {(23, 11): {}, (24, 10): {}, (24, 12): {}},
			(24, 12): {(23, 12): {}, (24, 11): {}, (24, 13): {}},
			(24, 13): {(23, 13): {}, (24, 12): {}, (24, 14): {}},
			(24, 14): {(23, 14): {}, (24, 13): {}, (24, 15): {}},
			(24, 15): {(23, 15): {}, (24, 14): {}, (24, 16): {}},
			(24, 16): {(23, 16): {}, (24, 15): {}, (24, 17): {}},
			(24, 17): {(23, 17): {}, (24, 16): {}, (24, 18): {}},
			(24, 18): {(23, 18): {}, (24, 17): {}, (24, 19): {}},
			(24, 19): {(23, 19): {}, (24, 18): {}, (24, 20): {}},
			(24, 20): {(23, 20): {}, (24, 19): {}, (24, 21): {}},
			(24, 21): {(23, 21): {}, (24, 20): {}, (24, 22): {}},
			(24, 22): {(23, 22): {}, (24, 21): {}, (24, 23): {}},
			(24, 23): {(23, 23): {}, (24, 22): {}, (24, 24): {}},
			(24, 24): {(23, 24): {}, (24, 23): {}},
		}
	},
	"edges": {
		"physical": {
			(0, 1): {(0, 2): {0: True}, (1, 1): {0: True}},
			(0, 2): {(0, 1): {0: True}, (0, 3): {0: True}, (1, 2): {0: True}},
			(0, 3): {(0, 2): {0: True}, (0, 4): {0: True}, (1, 3): {0: True}},
			(0, 4): {(0, 3): {0: True}, (0, 5): {0: True}, (1, 4): {0: True}},
			(0, 5): {(0, 4): {0: True}, (0, 6): {0: True}, (1, 5): {0: True}},
			(0, 6): {(0, 5): {0: True}, (0, 7): {0: True}, (1, 6): {0: True}},
			(0, 7): {(0, 6): {0: True}, (0, 8): {0: True}, (1, 7): {0: True}},
			(0, 8): {(0, 7): {0: True}, (0, 9): {0: True}, (1, 8): {0: True}},
			(0, 9): {(0, 8): {0: True}, (0, 10): {0: True}, (1, 9): {0: True}},
			(0, 10): {
				(0, 9): {0: True},
				(0, 11): {0: True},
				(1, 10): {0: True},
			},
			(0, 11): {
				(0, 10): {0: True},
				(0, 12): {0: True},
				(1, 11): {0: True},
			},
			(0, 12): {
				(0, 11): {0: True},
				(0, 13): {0: True},
				(1, 12): {0: True},
			},
			(0, 13): {
				(0, 12): {0: True},
				(0, 14): {0: True},
				(1, 13): {0: True},
			},
			(0, 14): {
				(0, 13): {0: True},
				(0, 15): {0: True},
				(1, 14): {0: True},
			},
			(0, 15): {
				(0, 14): {0: True},
				(0, 16): {0: True},
				(1, 15): {0: True},
			},
			(0, 16): {
				(0, 15): {0: True},
				(0, 17): {0: True},
				(1, 16): {0: True},
			},
			(0, 17): {
				(0, 16): {0: True},
				(0, 18): {0: True},
				(1, 17): {0: True},
			},
			(0, 18): {
				(0, 17): {0: True},
				(0, 19): {0: True},
				(1, 18): {0: True},
			},
			(0, 19): {
				(0, 18): {0: True},
				(0, 20): {0: True},
				(1, 19): {0: True},
			},
			(0, 20): {
				(0, 19): {0: True},
				(0, 21): {0: True},
				(1, 20): {0: True},
			},
			(0, 21): {
				(0, 20): {0: True},
				(0, 22): {0: True},
				(1, 21): {0: True},
			},
			(0, 22): {
				(0, 21): {0: True},
				(0, 23): {0: True},
				(1, 22): {0: True},
			},
			(0, 23): {
				(0, 22): {0: True},
				(0, 24): {0: True},
				(1, 23): {0: True},
			},
			(0, 24): {(0, 23): {0: True}, (1, 24): {0: True}},
			(1, 0): {(0, 1): {0: True}, (1, 1): {0: True}, (2, 0): {0: True}},
			(1, 1): {
				(0, 1): {0: True},
				(1, 0): {0: True},
				(1, 2): {0: True},
				(2, 1): {0: True},
			},
			(1, 2): {
				(0, 2): {0: True},
				(1, 1): {0: True},
				(1, 3): {0: True},
				(2, 2): {0: True},
			},
			(1, 3): {
				(0, 3): {0: True},
				(1, 2): {0: True},
				(1, 4): {0: True},
				(2, 3): {0: True},
			},
			(1, 4): {
				(0, 4): {0: True},
				(1, 3): {0: True},
				(1, 5): {0: True},
				(2, 4): {0: True},
			},
			(1, 5): {
				(0, 5): {0: True},
				(1, 4): {0: True},
				(1, 6): {0: True},
				(2, 5): {0: True},
			},
			(1, 6): {
				(0, 6): {0: True},
				(1, 5): {0: True},
				(1, 7): {0: True},
				(2, 6): {0: True},
			},
			(1, 7): {
				(0, 7): {0: True},
				(1, 6): {0: True},
				(1, 8): {0: True},
				(2, 7): {0: True},
			},
			(1, 8): {
				(0, 8): {0: True},
				(1, 7): {0: True},
				(1, 9): {0: True},
				(2, 8): {0: True},
			},
			(1, 9): {
				(0, 9): {0: True},
				(1, 8): {0: True},
				(1, 10): {0: True},
				(2, 9): {0: True},
			},
			(1, 10): {
				(0, 10): {0: True},
				(1, 9): {0: True},
				(1, 11): {0: True},
				(2, 10): {0: True},
			},
			(1, 11): {
				(0, 11): {0: True},
				(1, 10): {0: True},
				(1, 12): {0: True},
				(2, 11): {0: True},
			},
			(1, 12): {
				(0, 12): {0: True},
				(1, 11): {0: True},
				(1, 13): {0: True},
				(2, 12): {0: True},
			},
			(1, 13): {
				(0, 13): {0: True},
				(1, 12): {0: True},
				(1, 14): {0: True},
				(2, 13): {0: True},
			},
			(1, 14): {
				(0, 14): {0: True},
				(1, 13): {0: True},
				(1, 15): {0: True},
				(2, 14): {0: True},
			},
			(1, 15): {
				(0, 15): {0: True},
				(1, 14): {0: True},
				(1, 16): {0: True},
				(2, 15): {0: True},
			},
			(1, 16): {
				(0, 16): {0: True},
				(1, 15): {0: True},
				(1, 17): {0: True},
				(2, 16): {0: True},
			},
			(1, 17): {
				(0, 17): {0: True},
				(1, 16): {0: True},
				(1, 18): {0: True},
				(2, 17): {0: True},
			},
			(1, 18): {
				(0, 18): {0: True},
				(1, 17): {0: True},
				(1, 19): {0: True},
				(2, 18): {0: True},
			},
			(1, 19): {
				(0, 19): {0: True},
				(1, 18): {0: True},
				(1, 20): {0: True},
				(2, 19): {0: True},
			},
			(1, 20): {
				(0, 20): {0: True},
				(1, 19): {0: True},
				(1, 21): {0: True},
				(2, 20): {0: True},
			},
			(1, 21): {
				(0, 21): {0: True},
				(1, 20): {0: True},
				(1, 22): {0: True},
				(2, 21): {0: True},
			},
			(1, 22): {
				(0, 22): {0: True},
				(1, 21): {0: True},
				(1, 23): {0: True},
				(2, 22): {0: True},
			},
			(1, 23): {
				(0, 23): {0: True},
				(1, 22): {0: True},
				(1, 24): {0: True},
				(2, 23): {0: True},
			},
			(1, 24): {
				(0, 24): {0: True},
				(1, 23): {0: True},
				(2, 24): {0: True},
			},
			(2, 0): {(1, 0): {0: True}, (2, 1): {0: True}, (3, 0): {0: True}},
			(2, 1): {
				(1, 1): {0: True},
				(2, 0): {0: True},
				(2, 2): {0: True},
				(3, 1): {0: True},
			},
			(2, 2): {
				(1, 2): {0: True},
				(2, 1): {0: True},
				(2, 3): {0: True},
				(3, 2): {0: True},
			},
			(2, 3): {
				(1, 3): {0: True},
				(2, 2): {0: True},
				(2, 4): {0: True},
				(3, 3): {0: True},
			},
			(2, 4): {
				(1, 4): {0: True},
				(2, 3): {0: True},
				(2, 5): {0: True},
				(3, 4): {0: True},
			},
			(2, 5): {
				(1, 5): {0: True},
				(2, 4): {0: True},
				(2, 6): {0: True},
				(3, 5): {0: True},
			},
			(2, 6): {
				(1, 6): {0: True},
				(2, 5): {0: True},
				(2, 7): {0: True},
				(3, 6): {0: True},
			},
			(2, 7): {
				(1, 7): {0: True},
				(2, 6): {0: True},
				(2, 8): {0: True},
				(3, 7): {0: True},
			},
			(2, 8): {
				(1, 8): {0: True},
				(2, 7): {0: True},
				(2, 9): {0: True},
				(3, 8): {0: True},
			},
			(2, 9): {
				(1, 9): {0: True},
				(2, 8): {0: True},
				(2, 10): {0: True},
				(3, 9): {0: True},
			},
			(2, 10): {
				(1, 10): {0: True},
				(2, 9): {0: True},
				(2, 11): {0: True},
				(3, 10): {0: True},
			},
			(2, 11): {
				(1, 11): {0: True},
				(2, 10): {0: True},
				(2, 12): {0: True},
				(3, 11): {0: True},
			},
			(2, 12): {
				(1, 12): {0: True},
				(2, 11): {0: True},
				(2, 13): {0: True},
				(3, 12): {0: True},
			},
			(2, 13): {
				(1, 13): {0: True},
				(2, 12): {0: True},
				(2, 14): {0: True},
				(3, 13): {0: True},
			},
			(2, 14): {
				(1, 14): {0: True},
				(2, 13): {0: True},
				(2, 15): {0: True},
				(3, 14): {0: True},
			},
			(2, 15): {
				(1, 15): {0: True},
				(2, 14): {0: True},
				(2, 16): {0: True},
				(3, 15): {0: True},
			},
			(2, 16): {
				(1, 16): {0: True},
				(2, 15): {0: True},
				(2, 17): {0: True},
				(3, 16): {0: True},
			},
			(2, 17): {
				(1, 17): {0: True},
				(2, 16): {0: True},
				(2, 18): {0: True},
				(3, 17): {0: True},
			},
			(2, 18): {
				(1, 18): {0: True},
				(2, 17): {0: True},
				(2, 19): {0: True},
				(3, 18): {0: True},
			},
			(2, 19): {
				(1, 19): {0: True},
				(2, 18): {0: True},
				(2, 20): {0: True},
				(3, 19): {0: True},
			},
			(2, 20): {
				(1, 20): {0: True},
				(2, 19): {0: True},
				(2, 21): {0: True},
				(3, 20): {0: True},
			},
			(2, 21): {
				(1, 21): {0: True},
				(2, 20): {0: True},
				(2, 22): {0: True},
				(3, 21): {0: True},
			},
			(2, 22): {
				(1, 22): {0: True},
				(2, 21): {0: True},
				(2, 23): {0: True},
				(3, 22): {0: True},
			},
			(2, 23): {
				(1, 23): {0: True},
				(2, 22): {0: True},
				(2, 24): {0: True},
				(3, 23): {0: True},
			},
			(2, 24): {
				(1, 24): {0: True},
				(2, 23): {0: True},
				(3, 24): {0: True},
			},
			(3, 0): {(2, 0): {0: True}, (3, 1): {0: True}, (4, 0): {0: True}},
			(3, 1): {
				(2, 1): {0: True},
				(3, 0): {0: True},
				(3, 2): {0: True},
				(4, 1): {0: True},
			},
			(3, 2): {
				(2, 2): {0: True},
				(3, 1): {0: True},
				(3, 3): {0: True},
				(4, 2): {0: True},
			},
			(3, 3): {
				(2, 3): {0: True},
				(3, 2): {0: True},
				(3, 4): {0: True},
				(4, 3): {0: True},
			},
			(3, 4): {
				(2, 4): {0: True},
				(3, 3): {0: True},
				(3, 5): {0: True},
				(4, 4): {0: True},
			},
			(3, 5): {
				(2, 5): {0: True},
				(3, 4): {0: True},
				(3, 6): {0: True},
				(4, 5): {0: True},
			},
			(3, 6): {
				(2, 6): {0: True},
				(3, 5): {0: True},
				(3, 7): {0: True},
				(4, 6): {0: True},
			},
			(3, 7): {
				(2, 7): {0: True},
				(3, 6): {0: True},
				(3, 8): {0: True},
				(4, 7): {0: True},
			},
			(3, 8): {
				(2, 8): {0: True},
				(3, 7): {0: True},
				(3, 9): {0: True},
				(4, 8): {0: True},
			},
			(3, 9): {
				(2, 9): {0: True},
				(3, 8): {0: True},
				(3, 10): {0: True},
				(4, 9): {0: True},
			},
			(3, 10): {
				(2, 10): {0: True},
				(3, 9): {0: True},
				(3, 11): {0: True},
				(4, 10): {0: True},
			},
			(3, 11): {
				(2, 11): {0: True},
				(3, 10): {0: True},
				(3, 12): {0: True},
				(4, 11): {0: True},
			},
			(3, 12): {
				(2, 12): {0: True},
				(3, 11): {0: True},
				(3, 13): {0: True},
				(4, 12): {0: True},
			},
			(3, 13): {
				(2, 13): {0: True},
				(3, 12): {0: True},
				(3, 14): {0: True},
				(4, 13): {0: True},
			},
			(3, 14): {
				(2, 14): {0: True},
				(3, 13): {0: True},
				(3, 15): {0: True},
				(4, 14): {0: True},
			},
			(3, 15): {
				(2, 15): {0: True},
				(3, 14): {0: True},
				(3, 16): {0: True},
				(4, 15): {0: True},
			},
			(3, 16): {
				(2, 16): {0: True},
				(3, 15): {0: True},
				(3, 17): {0: True},
				(4, 16): {0: True},
			},
			(3, 17): {
				(2, 17): {0: True},
				(3, 16): {0: True},
				(3, 18): {0: True},
				(4, 17): {0: True},
			},
			(3, 18): {
				(2, 18): {0: True},
				(3, 17): {0: True},
				(3, 19): {0: True},
				(4, 18): {0: True},
			},
			(3, 19): {
				(2, 19): {0: True},
				(3, 18): {0: True},
				(3, 20): {0: True},
				(4, 19): {0: True},
			},
			(3, 20): {
				(2, 20): {0: True},
				(3, 19): {0: True},
				(3, 21): {0: True},
				(4, 20): {0: True},
			},
			(3, 21): {
				(2, 21): {0: True},
				(3, 20): {0: True},
				(3, 22): {0: True},
				(4, 21): {0: True},
			},
			(3, 22): {
				(2, 22): {0: True},
				(3, 21): {0: True},
				(3, 23): {0: True},
				(4, 22): {0: True},
			},
			(3, 23): {
				(2, 23): {0: True},
				(3, 22): {0: True},
				(3, 24): {0: True},
				(4, 23): {0: True},
			},
			(3, 24): {
				(2, 24): {0: True},
				(3, 23): {0: True},
				(4, 24): {0: True},
			},
			(4, 0): {(3, 0): {0: True}, (4, 1): {0: True}, (5, 0): {0: True}},
			(4, 1): {
				(3, 1): {0: True},
				(4, 0): {0: True},
				(4, 2): {0: True},
				(5, 1): {0: True},
			},
			(4, 2): {
				(3, 2): {0: True},
				(4, 1): {0: True},
				(4, 3): {0: True},
				(5, 2): {0: True},
			},
			(4, 3): {
				(3, 3): {0: True},
				(4, 2): {0: True},
				(4, 4): {0: True},
				(5, 3): {0: True},
			},
			(4, 4): {
				(3, 4): {0: True},
				(4, 3): {0: True},
				(4, 5): {0: True},
				(5, 4): {0: True},
			},
			(4, 5): {
				(3, 5): {0: True},
				(4, 4): {0: True},
				(4, 6): {0: True},
				(5, 5): {0: True},
			},
			(4, 6): {
				(3, 6): {0: True},
				(4, 5): {0: True},
				(4, 7): {0: True},
				(5, 6): {0: True},
			},
			(4, 7): {
				(3, 7): {0: True},
				(4, 6): {0: True},
				(4, 8): {0: True},
				(5, 7): {0: True},
			},
			(4, 8): {
				(3, 8): {0: True},
				(4, 7): {0: True},
				(4, 9): {0: True},
				(5, 8): {0: True},
			},
			(4, 9): {
				(3, 9): {0: True},
				(4, 8): {0: True},
				(4, 10): {0: True},
				(5, 9): {0: True},
			},
			(4, 10): {
				(3, 10): {0: True},
				(4, 9): {0: True},
				(4, 11): {0: True},
				(5, 10): {0: True},
			},
			(4, 11): {
				(3, 11): {0: True},
				(4, 10): {0: True},
				(4, 12): {0: True},
				(5, 11): {0: True},
			},
			(4, 12): {
				(3, 12): {0: True},
				(4, 11): {0: True},
				(4, 13): {0: True},
				(5, 12): {0: True},
			},
			(4, 13): {
				(3, 13): {0: True},
				(4, 12): {0: True},
				(4, 14): {0: True},
				(5, 13): {0: True},
			},
			(4, 14): {
				(3, 14): {0: True},
				(4, 13): {0: True},
				(4, 15): {0: True},
				(5, 14): {0: True},
			},
			(4, 15): {
				(3, 15): {0: True},
				(4, 14): {0: True},
				(4, 16): {0: True},
				(5, 15): {0: True},
			},
			(4, 16): {
				(3, 16): {0: True},
				(4, 15): {0: True},
				(4, 17): {0: True},
				(5, 16): {0: True},
			},
			(4, 17): {
				(3, 17): {0: True},
				(4, 16): {0: True},
				(4, 18): {0: True},
				(5, 17): {0: True},
			},
			(4, 18): {
				(3, 18): {0: True},
				(4, 17): {0: True},
				(4, 19): {0: True},
				(5, 18): {0: True},
			},
			(4, 19): {
				(3, 19): {0: True},
				(4, 18): {0: True},
				(4, 20): {0: True},
				(5, 19): {0: True},
			},
			(4, 20): {
				(3, 20): {0: True},
				(4, 19): {0: True},
				(4, 21): {0: True},
				(5, 20): {0: True},
			},
			(4, 21): {
				(3, 21): {0: True},
				(4, 20): {0: True},
				(4, 22): {0: True},
				(5, 21): {0: True},
			},
			(4, 22): {
				(3, 22): {0: True},
				(4, 21): {0: True},
				(4, 23): {0: True},
				(5, 22): {0: True},
			},
			(4, 23): {
				(3, 23): {0: True},
				(4, 22): {0: True},
				(4, 24): {0: True},
				(5, 23): {0: True},
			},
			(4, 24): {
				(3, 24): {0: True},
				(4, 23): {0: True},
				(5, 24): {0: True},
			},
			(5, 0): {(4, 0): {0: True}, (5, 1): {0: True}, (6, 0): {0: True}},
			(5, 1): {
				(4, 1): {0: True},
				(5, 0): {0: True},
				(5, 2): {0: True},
				(6, 1): {0: True},
			},
			(5, 2): {
				(4, 2): {0: True},
				(5, 1): {0: True},
				(5, 3): {0: True},
				(6, 2): {0: True},
			},
			(5, 3): {
				(4, 3): {0: True},
				(5, 2): {0: True},
				(5, 4): {0: True},
				(6, 3): {0: True},
			},
			(5, 4): {
				(4, 4): {0: True},
				(5, 3): {0: True},
				(5, 5): {0: True},
				(6, 4): {0: True},
			},
			(5, 5): {
				(4, 5): {0: True},
				(5, 4): {0: True},
				(5, 6): {0: True},
				(6, 5): {0: True},
			},
			(5, 6): {
				(4, 6): {0: True},
				(5, 5): {0: True},
				(5, 7): {0: True},
				(6, 6): {0: True},
			},
			(5, 7): {
				(4, 7): {0: True},
				(5, 6): {0: True},
				(5, 8): {0: True},
				(6, 7): {0: True},
			},
			(5, 8): {
				(4, 8): {0: True},
				(5, 7): {0: True},
				(5, 9): {0: True},
				(6, 8): {0: True},
			},
			(5, 9): {
				(4, 9): {0: True},
				(5, 8): {0: True},
				(5, 10): {0: True},
				(6, 9): {0: True},
			},
			(5, 10): {
				(4, 10): {0: True},
				(5, 9): {0: True},
				(5, 11): {0: True},
				(6, 10): {0: True},
			},
			(5, 11): {
				(4, 11): {0: True},
				(5, 10): {0: True},
				(5, 12): {0: True},
				(6, 11): {0: True},
			},
			(5, 12): {
				(4, 12): {0: True},
				(5, 11): {0: True},
				(5, 13): {0: True},
				(6, 12): {0: True},
			},
			(5, 13): {
				(4, 13): {0: True},
				(5, 12): {0: True},
				(5, 14): {0: True},
				(6, 13): {0: True},
			},
			(5, 14): {
				(4, 14): {0: True},
				(5, 13): {0: True},
				(5, 15): {0: True},
				(6, 14): {0: True},
			},
			(5, 15): {
				(4, 15): {0: True},
				(5, 14): {0: True},
				(5, 16): {0: True},
				(6, 15): {0: True},
			},
			(5, 16): {
				(4, 16): {0: True},
				(5, 15): {0: True},
				(5, 17): {0: True},
				(6, 16): {0: True},
			},
			(5, 17): {
				(4, 17): {0: True},
				(5, 16): {0: True},
				(5, 18): {0: True},
				(6, 17): {0: True},
			},
			(5, 18): {
				(4, 18): {0: True},
				(5, 17): {0: True},
				(5, 19): {0: True},
				(6, 18): {0: True},
			},
			(5, 19): {
				(4, 19): {0: True},
				(5, 18): {0: True},
				(5, 20): {0: True},
				(6, 19): {0: True},
			},
			(5, 20): {
				(4, 20): {0: True},
				(5, 19): {0: True},
				(5, 21): {0: True},
				(6, 20): {0: True},
			},
			(5, 21): {
				(4, 21): {0: True},
				(5, 20): {0: True},
				(5, 22): {0: True},
				(6, 21): {0: True},
			},
			(5, 22): {
				(4, 22): {0: True},
				(5, 21): {0: True},
				(5, 23): {0: True},
				(6, 22): {0: True},
			},
			(5, 23): {
				(4, 23): {0: True},
				(5, 22): {0: True},
				(5, 24): {0: True},
				(6, 23): {0: True},
			},
			(5, 24): {
				(4, 24): {0: True},
				(5, 23): {0: True},
				(6, 24): {0: True},
			},
			(6, 0): {(5, 0): {0: True}, (6, 1): {0: True}, (7, 0): {0: True}},
			(6, 1): {
				(5, 1): {0: True},
				(6, 0): {0: True},
				(6, 2): {0: True},
				(7, 1): {0: True},
			},
			(6, 2): {
				(5, 2): {0: True},
				(6, 1): {0: True},
				(6, 3): {0: True},
				(7, 2): {0: True},
			},
			(6, 3): {
				(5, 3): {0: True},
				(6, 2): {0: True},
				(6, 4): {0: True},
				(7, 3): {0: True},
			},
			(6, 4): {
				(5, 4): {0: True},
				(6, 3): {0: True},
				(6, 5): {0: True},
				(7, 4): {0: True},
			},
			(6, 5): {
				(5, 5): {0: True},
				(6, 4): {0: True},
				(6, 6): {0: True},
				(7, 5): {0: True},
			},
			(6, 6): {
				(5, 6): {0: True},
				(6, 5): {0: True},
				(6, 7): {0: True},
				(7, 6): {0: True},
			},
			(6, 7): {
				(5, 7): {0: True},
				(6, 6): {0: True},
				(6, 8): {0: True},
				(7, 7): {0: True},
			},
			(6, 8): {
				(5, 8): {0: True},
				(6, 7): {0: True},
				(6, 9): {0: True},
				(7, 8): {0: True},
			},
			(6, 9): {
				(5, 9): {0: True},
				(6, 8): {0: True},
				(6, 10): {0: True},
				(7, 9): {0: True},
			},
			(6, 10): {
				(5, 10): {0: True},
				(6, 9): {0: True},
				(6, 11): {0: True},
				(7, 10): {0: True},
			},
			(6, 11): {
				(5, 11): {0: True},
				(6, 10): {0: True},
				(6, 12): {0: True},
				(7, 11): {0: True},
			},
			(6, 12): {
				(5, 12): {0: True},
				(6, 11): {0: True},
				(6, 13): {0: True},
				(7, 12): {0: True},
			},
			(6, 13): {
				(5, 13): {0: True},
				(6, 12): {0: True},
				(6, 14): {0: True},
				(7, 13): {0: True},
			},
			(6, 14): {
				(5, 14): {0: True},
				(6, 13): {0: True},
				(6, 15): {0: True},
				(7, 14): {0: True},
			},
			(6, 15): {
				(5, 15): {0: True},
				(6, 14): {0: True},
				(6, 16): {0: True},
				(7, 15): {0: True},
			},
			(6, 16): {
				(5, 16): {0: True},
				(6, 15): {0: True},
				(6, 17): {0: True},
				(7, 16): {0: True},
			},
			(6, 17): {
				(5, 17): {0: True},
				(6, 16): {0: True},
				(6, 18): {0: True},
				(7, 17): {0: True},
			},
			(6, 18): {
				(5, 18): {0: True},
				(6, 17): {0: True},
				(6, 19): {0: True},
				(7, 18): {0: True},
			},
			(6, 19): {
				(5, 19): {0: True},
				(6, 18): {0: True},
				(6, 20): {0: True},
				(7, 19): {0: True},
			},
			(6, 20): {
				(5, 20): {0: True},
				(6, 19): {0: True},
				(6, 21): {0: True},
				(7, 20): {0: True},
			},
			(6, 21): {
				(5, 21): {0: True},
				(6, 20): {0: True},
				(6, 22): {0: True},
				(7, 21): {0: True},
			},
			(6, 22): {
				(5, 22): {0: True},
				(6, 21): {0: True},
				(6, 23): {0: True},
				(7, 22): {0: True},
			},
			(6, 23): {
				(5, 23): {0: True},
				(6, 22): {0: True},
				(6, 24): {0: True},
				(7, 23): {0: True},
			},
			(6, 24): {
				(5, 24): {0: True},
				(6, 23): {0: True},
				(7, 24): {0: True},
			},
			(7, 0): {(6, 0): {0: True}, (7, 1): {0: True}, (8, 0): {0: True}},
			(7, 1): {
				(6, 1): {0: True},
				(7, 0): {0: True},
				(7, 2): {0: True},
				(8, 1): {0: True},
			},
			(7, 2): {
				(6, 2): {0: True},
				(7, 1): {0: True},
				(7, 3): {0: True},
				(8, 2): {0: True},
			},
			(7, 3): {
				(6, 3): {0: True},
				(7, 2): {0: True},
				(7, 4): {0: True},
				(8, 3): {0: True},
			},
			(7, 4): {
				(6, 4): {0: True},
				(7, 3): {0: True},
				(7, 5): {0: True},
				(8, 4): {0: True},
			},
			(7, 5): {
				(6, 5): {0: True},
				(7, 4): {0: True},
				(7, 6): {0: True},
				(8, 5): {0: True},
			},
			(7, 6): {
				(6, 6): {0: True},
				(7, 5): {0: True},
				(7, 7): {0: True},
				(8, 6): {0: True},
			},
			(7, 7): {
				(6, 7): {0: True},
				(7, 6): {0: True},
				(7, 8): {0: True},
				(8, 7): {0: True},
			},
			(7, 8): {
				(6, 8): {0: True},
				(7, 7): {0: True},
				(7, 9): {0: True},
				(8, 8): {0: True},
			},
			(7, 9): {
				(6, 9): {0: True},
				(7, 8): {0: True},
				(7, 10): {0: True},
				(8, 9): {0: True},
			},
			(7, 10): {
				(6, 10): {0: True},
				(7, 9): {0: True},
				(7, 11): {0: True},
				(8, 10): {0: True},
			},
			(7, 11): {
				(6, 11): {0: True},
				(7, 10): {0: True},
				(7, 12): {0: True},
				(8, 11): {0: True},
			},
			(7, 12): {
				(6, 12): {0: True},
				(7, 11): {0: True},
				(7, 13): {0: True},
				(8, 12): {0: True},
			},
			(7, 13): {
				(6, 13): {0: True},
				(7, 12): {0: True},
				(7, 14): {0: True},
				(8, 13): {0: True},
			},
			(7, 14): {
				(6, 14): {0: True},
				(7, 13): {0: True},
				(7, 15): {0: True},
				(8, 14): {0: True},
			},
			(7, 15): {
				(6, 15): {0: True},
				(7, 14): {0: True},
				(7, 16): {0: True},
				(8, 15): {0: True},
			},
			(7, 16): {
				(6, 16): {0: True},
				(7, 15): {0: True},
				(7, 17): {0: True},
				(8, 16): {0: True},
			},
			(7, 17): {
				(6, 17): {0: True},
				(7, 16): {0: True},
				(7, 18): {0: True},
				(8, 17): {0: True},
			},
			(7, 18): {
				(6, 18): {0: True},
				(7, 17): {0: True},
				(7, 19): {0: True},
				(8, 18): {0: True},
			},
			(7, 19): {
				(6, 19): {0: True},
				(7, 18): {0: True},
				(7, 20): {0: True},
				(8, 19): {0: True},
			},
			(7, 20): {
				(6, 20): {0: True},
				(7, 19): {0: True},
				(7, 21): {0: True},
				(8, 20): {0: True},
			},
			(7, 21): {
				(6, 21): {0: True},
				(7, 20): {0: True},
				(7, 22): {0: True},
				(8, 21): {0: True},
			},
			(7, 22): {
				(6, 22): {0: True},
				(7, 21): {0: True},
				(7, 23): {0: True},
				(8, 22): {0: True},
			},
			(7, 23): {
				(6, 23): {0: True},
				(7, 22): {0: True},
				(7, 24): {0: True},
				(8, 23): {0: True},
			},
			(7, 24): {
				(6, 24): {0: True},
				(7, 23): {0: True},
				(8, 24): {0: True},
			},
			(8, 0): {(7, 0): {0: True}, (8, 1): {0: True}, (9, 0): {0: True}},
			(8, 1): {
				(7, 1): {0: True},
				(8, 0): {0: True},
				(8, 2): {0: True},
				(9, 1): {0: True},
			},
			(8, 2): {
				(7, 2): {0: True},
				(8, 1): {0: True},
				(8, 3): {0: True},
				(9, 2): {0: True},
			},
			(8, 3): {
				(7, 3): {0: True},
				(8, 2): {0: True},
				(8, 4): {0: True},
				(9, 3): {0: True},
			},
			(8, 4): {
				(7, 4): {0: True},
				(8, 3): {0: True},
				(8, 5): {0: True},
				(9, 4): {0: True},
			},
			(8, 5): {
				(7, 5): {0: True},
				(8, 4): {0: True},
				(8, 6): {0: True},
				(9, 5): {0: True},
			},
			(8, 6): {
				(7, 6): {0: True},
				(8, 5): {0: True},
				(8, 7): {0: True},
				(9, 6): {0: True},
			},
			(8, 7): {
				(7, 7): {0: True},
				(8, 6): {0: True},
				(8, 8): {0: True},
				(9, 7): {0: True},
			},
			(8, 8): {
				(7, 8): {0: True},
				(8, 7): {0: True},
				(8, 9): {0: True},
				(9, 8): {0: True},
			},
			(8, 9): {
				(7, 9): {0: True},
				(8, 8): {0: True},
				(8, 10): {0: True},
				(9, 9): {0: True},
			},
			(8, 10): {
				(7, 10): {0: True},
				(8, 9): {0: True},
				(8, 11): {0: True},
				(9, 10): {0: True},
			},
			(8, 11): {
				(7, 11): {0: True},
				(8, 10): {0: True},
				(8, 12): {0: True},
				(9, 11): {0: True},
			},
			(8, 12): {
				(7, 12): {0: True},
				(8, 11): {0: True},
				(8, 13): {0: True},
				(9, 12): {0: True},
			},
			(8, 13): {
				(7, 13): {0: True},
				(8, 12): {0: True},
				(8, 14): {0: True},
				(9, 13): {0: True},
			},
			(8, 14): {
				(7, 14): {0: True},
				(8, 13): {0: True},
				(8, 15): {0: True},
				(9, 14): {0: True},
			},
			(8, 15): {
				(7, 15): {0: True},
				(8, 14): {0: True},
				(8, 16): {0: True},
				(9, 15): {0: True},
			},
			(8, 16): {
				(7, 16): {0: True},
				(8, 15): {0: True},
				(8, 17): {0: True},
				(9, 16): {0: True},
			},
			(8, 17): {
				(7, 17): {0: True},
				(8, 16): {0: True},
				(8, 18): {0: True},
				(9, 17): {0: True},
			},
			(8, 18): {
				(7, 18): {0: True},
				(8, 17): {0: True},
				(8, 19): {0: True},
				(9, 18): {0: True},
			},
			(8, 19): {
				(7, 19): {0: True},
				(8, 18): {0: True},
				(8, 20): {0: True},
				(9, 19): {0: True},
			},
			(8, 20): {
				(7, 20): {0: True},
				(8, 19): {0: True},
				(8, 21): {0: True},
				(9, 20): {0: True},
			},
			(8, 21): {
				(7, 21): {0: True},
				(8, 20): {0: True},
				(8, 22): {0: True},
				(9, 21): {0: True},
			},
			(8, 22): {
				(7, 22): {0: True},
				(8, 21): {0: True},
				(8, 23): {0: True},
				(9, 22): {0: True},
			},
			(8, 23): {
				(7, 23): {0: True},
				(8, 22): {0: True},
				(8, 24): {0: True},
				(9, 23): {0: True},
			},
			(8, 24): {
				(7, 24): {0: True},
				(8, 23): {0: True},
				(9, 24): {0: True},
			},
			(9, 0): {(8, 0): {0: True}, (9, 1): {0: True}, (10, 0): {0: True}},
			(9, 1): {
				(8, 1): {0: True},
				(9, 0): {0: True},
				(9, 2): {0: True},
				(10, 1): {0: True},
			},
			(9, 2): {
				(8, 2): {0: True},
				(9, 1): {0: True},
				(9, 3): {0: True},
				(10, 2): {0: True},
			},
			(9, 3): {
				(8, 3): {0: True},
				(9, 2): {0: True},
				(9, 4): {0: True},
				(10, 3): {0: True},
			},
			(9, 4): {
				(8, 4): {0: True},
				(9, 3): {0: True},
				(9, 5): {0: True},
				(10, 4): {0: True},
			},
			(9, 5): {
				(8, 5): {0: True},
				(9, 4): {0: True},
				(9, 6): {0: True},
				(10, 5): {0: True},
			},
			(9, 6): {
				(8, 6): {0: True},
				(9, 5): {0: True},
				(9, 7): {0: True},
				(10, 6): {0: True},
			},
			(9, 7): {
				(8, 7): {0: True},
				(9, 6): {0: True},
				(9, 8): {0: True},
				(10, 7): {0: True},
			},
			(9, 8): {
				(8, 8): {0: True},
				(9, 7): {0: True},
				(9, 9): {0: True},
				(10, 8): {0: True},
			},
			(9, 9): {
				(8, 9): {0: True},
				(9, 8): {0: True},
				(9, 10): {0: True},
				(10, 9): {0: True},
			},
			(9, 10): {
				(8, 10): {0: True},
				(9, 9): {0: True},
				(9, 11): {0: True},
				(10, 10): {0: True},
			},
			(9, 11): {
				(8, 11): {0: True},
				(9, 10): {0: True},
				(9, 12): {0: True},
				(10, 11): {0: True},
			},
			(9, 12): {
				(8, 12): {0: True},
				(9, 11): {0: True},
				(9, 13): {0: True},
				(10, 12): {0: True},
			},
			(9, 13): {
				(8, 13): {0: True},
				(9, 12): {0: True},
				(9, 14): {0: True},
				(10, 13): {0: True},
			},
			(9, 14): {
				(8, 14): {0: True},
				(9, 13): {0: True},
				(9, 15): {0: True},
				(10, 14): {0: True},
			},
			(9, 15): {
				(8, 15): {0: True},
				(9, 14): {0: True},
				(9, 16): {0: True},
				(10, 15): {0: True},
			},
			(9, 16): {
				(8, 16): {0: True},
				(9, 15): {0: True},
				(9, 17): {0: True},
				(10, 16): {0: True},
			},
			(9, 17): {
				(8, 17): {0: True},
				(9, 16): {0: True},
				(9, 18): {0: True},
				(10, 17): {0: True},
			},
			(9, 18): {
				(8, 18): {0: True},
				(9, 17): {0: True},
				(9, 19): {0: True},
				(10, 18): {0: True},
			},
			(9, 19): {
				(8, 19): {0: True},
				(9, 18): {0: True},
				(9, 20): {0: True},
				(10, 19): {0: True},
			},
			(9, 20): {
				(8, 20): {0: True},
				(9, 19): {0: True},
				(9, 21): {0: True},
				(10, 20): {0: True},
			},
			(9, 21): {
				(8, 21): {0: True},
				(9, 20): {0: True},
				(9, 22): {0: True},
				(10, 21): {0: True},
			},
			(9, 22): {
				(8, 22): {0: True},
				(9, 21): {0: True},
				(9, 23): {0: True},
				(10, 22): {0: True},
			},
			(9, 23): {
				(8, 23): {0: True},
				(9, 22): {0: True},
				(9, 24): {0: True},
				(10, 23): {0: True},
			},
			(9, 24): {
				(8, 24): {0: True},
				(9, 23): {0: True},
				(10, 24): {0: True},
			},
			(10, 0): {
				(9, 0): {0: True},
				(10, 1): {0: True},
				(11, 0): {0: True},
			},
			(10, 1): {
				(9, 1): {0: True},
				(10, 0): {0: True},
				(10, 2): {0: True},
				(11, 1): {0: True},
			},
			(10, 2): {
				(9, 2): {0: True},
				(10, 1): {0: True},
				(10, 3): {0: True},
				(11, 2): {0: True},
			},
			(10, 3): {
				(9, 3): {0: True},
				(10, 2): {0: True},
				(10, 4): {0: True},
				(11, 3): {0: True},
			},
			(10, 4): {
				(9, 4): {0: True},
				(10, 3): {0: True},
				(10, 5): {0: True},
				(11, 4): {0: True},
			},
			(10, 5): {
				(9, 5): {0: True},
				(10, 4): {0: True},
				(10, 6): {0: True},
				(11, 5): {0: True},
			},
			(10, 6): {
				(9, 6): {0: True},
				(10, 5): {0: True},
				(10, 7): {0: True},
				(11, 6): {0: True},
			},
			(10, 7): {
				(9, 7): {0: True},
				(10, 6): {0: True},
				(10, 8): {0: True},
				(11, 7): {0: True},
			},
			(10, 8): {
				(9, 8): {0: True},
				(10, 7): {0: True},
				(10, 9): {0: True},
				(11, 8): {0: True},
			},
			(10, 9): {
				(9, 9): {0: True},
				(10, 8): {0: True},
				(10, 10): {0: True},
				(11, 9): {0: True},
			},
			(10, 10): {
				(9, 10): {0: True},
				(10, 9): {0: True},
				(10, 11): {0: True},
				(11, 10): {0: True},
			},
			(10, 11): {
				(9, 11): {0: True},
				(10, 10): {0: True},
				(10, 12): {0: True},
				(11, 11): {0: True},
			},
			(10, 12): {
				(9, 12): {0: True},
				(10, 11): {0: True},
				(10, 13): {0: True},
				(11, 12): {0: True},
			},
			(10, 13): {
				(9, 13): {0: True},
				(10, 12): {0: True},
				(10, 14): {0: True},
				(11, 13): {0: True},
			},
			(10, 14): {
				(9, 14): {0: True},
				(10, 13): {0: True},
				(10, 15): {0: True},
				(11, 14): {0: True},
			},
			(10, 15): {
				(9, 15): {0: True},
				(10, 14): {0: True},
				(10, 16): {0: True},
				(11, 15): {0: True},
			},
			(10, 16): {
				(9, 16): {0: True},
				(10, 15): {0: True},
				(10, 17): {0: True},
				(11, 16): {0: True},
			},
			(10, 17): {
				(9, 17): {0: True},
				(10, 16): {0: True},
				(10, 18): {0: True},
				(11, 17): {0: True},
			},
			(10, 18): {
				(9, 18): {0: True},
				(10, 17): {0: True},
				(10, 19): {0: True},
				(11, 18): {0: True},
			},
			(10, 19): {
				(9, 19): {0: True},
				(10, 18): {0: True},
				(10, 20): {0: True},
				(11, 19): {0: True},
			},
			(10, 20): {
				(9, 20): {0: True},
				(10, 19): {0: True},
				(10, 21): {0: True},
				(11, 20): {0: True},
			},
			(10, 21): {
				(9, 21): {0: True},
				(10, 20): {0: True},
				(10, 22): {0: True},
				(11, 21): {0: True},
			},
			(10, 22): {
				(9, 22): {0: True},
				(10, 21): {0: True},
				(10, 23): {0: True},
				(11, 22): {0: True},
			},
			(10, 23): {
				(9, 23): {0: True},
				(10, 22): {0: True},
				(10, 24): {0: True},
				(11, 23): {0: True},
			},
			(10, 24): {
				(9, 24): {0: True},
				(10, 23): {0: True},
				(11, 24): {0: True},
			},
			(11, 0): {
				(10, 0): {0: True},
				(11, 1): {0: True},
				(12, 0): {0: True},
			},
			(11, 1): {
				(10, 1): {0: True},
				(11, 0): {0: True},
				(11, 2): {0: True},
				(12, 1): {0: True},
			},
			(11, 2): {
				(10, 2): {0: True},
				(11, 1): {0: True},
				(11, 3): {0: True},
				(12, 2): {0: True},
			},
			(11, 3): {
				(10, 3): {0: True},
				(11, 2): {0: True},
				(11, 4): {0: True},
				(12, 3): {0: True},
			},
			(11, 4): {
				(10, 4): {0: True},
				(11, 3): {0: True},
				(11, 5): {0: True},
				(12, 4): {0: True},
			},
			(11, 5): {
				(10, 5): {0: True},
				(11, 4): {0: True},
				(11, 6): {0: True},
				(12, 5): {0: True},
			},
			(11, 6): {
				(10, 6): {0: True},
				(11, 5): {0: True},
				(11, 7): {0: True},
				(12, 6): {0: True},
			},
			(11, 7): {
				(10, 7): {0: True},
				(11, 6): {0: True},
				(11, 8): {0: True},
				(12, 7): {0: True},
			},
			(11, 8): {
				(10, 8): {0: True},
				(11, 7): {0: True},
				(11, 9): {0: True},
				(12, 8): {0: True},
			},
			(11, 9): {
				(10, 9): {0: True},
				(11, 8): {0: True},
				(11, 10): {0: True},
				(12, 9): {0: True},
			},
			(11, 10): {
				(10, 10): {0: True},
				(11, 9): {0: True},
				(11, 11): {0: True},
				(12, 10): {0: True},
			},
			(11, 11): {
				(10, 11): {0: True},
				(11, 10): {0: True},
				(11, 12): {0: True},
				(12, 11): {0: True},
			},
			(11, 12): {
				(10, 12): {0: True},
				(11, 11): {0: True},
				(11, 13): {0: True},
				(12, 12): {0: True},
			},
			(11, 13): {
				(10, 13): {0: True},
				(11, 12): {0: True},
				(11, 14): {0: True},
				(12, 13): {0: True},
			},
			(11, 14): {
				(10, 14): {0: True},
				(11, 13): {0: True},
				(11, 15): {0: True},
				(12, 14): {0: True},
			},
			(11, 15): {
				(10, 15): {0: True},
				(11, 14): {0: True},
				(11, 16): {0: True},
				(12, 15): {0: True},
			},
			(11, 16): {
				(10, 16): {0: True},
				(11, 15): {0: True},
				(11, 17): {0: True},
				(12, 16): {0: True},
			},
			(11, 17): {
				(10, 17): {0: True},
				(11, 16): {0: True},
				(11, 18): {0: True},
				(12, 17): {0: True},
			},
			(11, 18): {
				(10, 18): {0: True},
				(11, 17): {0: True},
				(11, 19): {0: True},
				(12, 18): {0: True},
			},
			(11, 19): {
				(10, 19): {0: True},
				(11, 18): {0: True},
				(11, 20): {0: True},
				(12, 19): {0: True},
			},
			(11, 20): {
				(10, 20): {0: True},
				(11, 19): {0: True},
				(11, 21): {0: True},
				(12, 20): {0: True},
			},
			(11, 21): {
				(10, 21): {0: True},
				(11, 20): {0: True},
				(11, 22): {0: True},
				(12, 21): {0: True},
			},
			(11, 22): {
				(10, 22): {0: True},
				(11, 21): {0: True},
				(11, 23): {0: True},
				(12, 22): {0: True},
			},
			(11, 23): {
				(10, 23): {0: True},
				(11, 22): {0: True},
				(11, 24): {0: True},
				(12, 23): {0: True},
			},
			(11, 24): {
				(10, 24): {0: True},
				(11, 23): {0: True},
				(12, 24): {0: True},
			},
			(12, 0): {
				(11, 0): {0: True},
				(12, 1): {0: True},
				(13, 0): {0: True},
			},
			(12, 1): {
				(11, 1): {0: True},
				(12, 0): {0: True},
				(12, 2): {0: True},
				(13, 1): {0: True},
			},
			(12, 2): {
				(11, 2): {0: True},
				(12, 1): {0: True},
				(12, 3): {0: True},
				(13, 2): {0: True},
			},
			(12, 3): {
				(11, 3): {0: True},
				(12, 2): {0: True},
				(12, 4): {0: True},
				(13, 3): {0: True},
			},
			(12, 4): {
				(11, 4): {0: True},
				(12, 3): {0: True},
				(12, 5): {0: True},
				(13, 4): {0: True},
			},
			(12, 5): {
				(11, 5): {0: True},
				(12, 4): {0: True},
				(12, 6): {0: True},
				(13, 5): {0: True},
			},
			(12, 6): {
				(11, 6): {0: True},
				(12, 5): {0: True},
				(12, 7): {0: True},
				(13, 6): {0: True},
			},
			(12, 7): {
				(11, 7): {0: True},
				(12, 6): {0: True},
				(12, 8): {0: True},
				(13, 7): {0: True},
			},
			(12, 8): {
				(11, 8): {0: True},
				(12, 7): {0: True},
				(12, 9): {0: True},
				(13, 8): {0: True},
			},
			(12, 9): {
				(11, 9): {0: True},
				(12, 8): {0: True},
				(12, 10): {0: True},
				(13, 9): {0: True},
			},
			(12, 10): {
				(11, 10): {0: True},
				(12, 9): {0: True},
				(12, 11): {0: True},
				(13, 10): {0: True},
			},
			(12, 11): {
				(11, 11): {0: True},
				(12, 10): {0: True},
				(12, 12): {0: True},
				(13, 11): {0: True},
			},
			(12, 12): {
				(11, 12): {0: True},
				(12, 11): {0: True},
				(12, 13): {0: True},
				(13, 12): {0: True},
			},
			(12, 13): {
				(11, 13): {0: True},
				(12, 12): {0: True},
				(12, 14): {0: True},
				(13, 13): {0: True},
			},
			(12, 14): {
				(11, 14): {0: True},
				(12, 13): {0: True},
				(12, 15): {0: True},
				(13, 14): {0: True},
			},
			(12, 15): {
				(11, 15): {0: True},
				(12, 14): {0: True},
				(12, 16): {0: True},
				(13, 15): {0: True},
			},
			(12, 16): {
				(11, 16): {0: True},
				(12, 15): {0: True},
				(12, 17): {0: True},
				(13, 16): {0: True},
			},
			(12, 17): {
				(11, 17): {0: True},
				(12, 16): {0: True},
				(12, 18): {0: True},
				(13, 17): {0: True},
			},
			(12, 18): {
				(11, 18): {0: True},
				(12, 17): {0: True},
				(12, 19): {0: True},
				(13, 18): {0: True},
			},
			(12, 19): {
				(11, 19): {0: True},
				(12, 18): {0: True},
				(12, 20): {0: True},
				(13, 19): {0: True},
			},
			(12, 20): {
				(11, 20): {0: True},
				(12, 19): {0: True},
				(12, 21): {0: True},
				(13, 20): {0: True},
			},
			(12, 21): {
				(11, 21): {0: True},
				(12, 20): {0: True},
				(12, 22): {0: True},
				(13, 21): {0: True},
			},
			(12, 22): {
				(11, 22): {0: True},
				(12, 21): {0: True},
				(12, 23): {0: True},
				(13, 22): {0: True},
			},
			(12, 23): {
				(11, 23): {0: True},
				(12, 22): {0: True},
				(12, 24): {0: True},
				(13, 23): {0: True},
			},
			(12, 24): {
				(11, 24): {0: True},
				(12, 23): {0: True},
				(13, 24): {0: True},
			},
			(13, 0): {
				(12, 0): {0: True},
				(13, 1): {0: True},
				(14, 0): {0: True},
			},
			(13, 1): {
				(12, 1): {0: True},
				(13, 0): {0: True},
				(13, 2): {0: True},
				(14, 1): {0: True},
			},
			(13, 2): {
				(12, 2): {0: True},
				(13, 1): {0: True},
				(13, 3): {0: True},
				(14, 2): {0: True},
			},
			(13, 3): {
				(12, 3): {0: True},
				(13, 2): {0: True},
				(13, 4): {0: True},
				(14, 3): {0: True},
			},
			(13, 4): {
				(12, 4): {0: True},
				(13, 3): {0: True},
				(13, 5): {0: True},
				(14, 4): {0: True},
			},
			(13, 5): {
				(12, 5): {0: True},
				(13, 4): {0: True},
				(13, 6): {0: True},
				(14, 5): {0: True},
			},
			(13, 6): {
				(12, 6): {0: True},
				(13, 5): {0: True},
				(13, 7): {0: True},
				(14, 6): {0: True},
			},
			(13, 7): {
				(12, 7): {0: True},
				(13, 6): {0: True},
				(13, 8): {0: True},
				(14, 7): {0: True},
			},
			(13, 8): {
				(12, 8): {0: True},
				(13, 7): {0: True},
				(13, 9): {0: True},
				(14, 8): {0: True},
			},
			(13, 9): {
				(12, 9): {0: True},
				(13, 8): {0: True},
				(13, 10): {0: True},
				(14, 9): {0: True},
			},
			(13, 10): {
				(12, 10): {0: True},
				(13, 9): {0: True},
				(13, 11): {0: True},
				(14, 10): {0: True},
			},
			(13, 11): {
				(12, 11): {0: True},
				(13, 10): {0: True},
				(13, 12): {0: True},
				(14, 11): {0: True},
			},
			(13, 12): {
				(12, 12): {0: True},
				(13, 11): {0: True},
				(13, 13): {0: True},
				(14, 12): {0: True},
			},
			(13, 13): {
				(12, 13): {0: True},
				(13, 12): {0: True},
				(13, 14): {0: True},
				(14, 13): {0: True},
			},
			(13, 14): {
				(12, 14): {0: True},
				(13, 13): {0: True},
				(13, 15): {0: True},
				(14, 14): {0: True},
			},
			(13, 15): {
				(12, 15): {0: True},
				(13, 14): {0: True},
				(13, 16): {0: True},
				(14, 15): {0: True},
			},
			(13, 16): {
				(12, 16): {0: True},
				(13, 15): {0: True},
				(13, 17): {0: True},
				(14, 16): {0: True},
			},
			(13, 17): {
				(12, 17): {0: True},
				(13, 16): {0: True},
				(13, 18): {0: True},
				(14, 17): {0: True},
			},
			(13, 18): {
				(12, 18): {0: True},
				(13, 17): {0: True},
				(13, 19): {0: True},
				(14, 18): {0: True},
			},
			(13, 19): {
				(12, 19): {0: True},
				(13, 18): {0: True},
				(13, 20): {0: True},
				(14, 19): {0: True},
			},
			(13, 20): {
				(12, 20): {0: True},
				(13, 19): {0: True},
				(13, 21): {0: True},
				(14, 20): {0: True},
			},
			(13, 21): {
				(12, 21): {0: True},
				(13, 20): {0: True},
				(13, 22): {0: True},
				(14, 21): {0: True},
			},
			(13, 22): {
				(12, 22): {0: True},
				(13, 21): {0: True},
				(13, 23): {0: True},
				(14, 22): {0: True},
			},
			(13, 23): {
				(12, 23): {0: True},
				(13, 22): {0: True},
				(13, 24): {0: True},
				(14, 23): {0: True},
			},
			(13, 24): {
				(12, 24): {0: True},
				(13, 23): {0: True},
				(14, 24): {0: True},
			},
			(14, 0): {
				(13, 0): {0: True},
				(14, 1): {0: True},
				(15, 0): {0: True},
			},
			(14, 1): {
				(13, 1): {0: True},
				(14, 0): {0: True},
				(14, 2): {0: True},
				(15, 1): {0: True},
			},
			(14, 2): {
				(13, 2): {0: True},
				(14, 1): {0: True},
				(14, 3): {0: True},
				(15, 2): {0: True},
			},
			(14, 3): {
				(13, 3): {0: True},
				(14, 2): {0: True},
				(14, 4): {0: True},
				(15, 3): {0: True},
			},
			(14, 4): {
				(13, 4): {0: True},
				(14, 3): {0: True},
				(14, 5): {0: True},
				(15, 4): {0: True},
			},
			(14, 5): {
				(13, 5): {0: True},
				(14, 4): {0: True},
				(14, 6): {0: True},
				(15, 5): {0: True},
			},
			(14, 6): {
				(13, 6): {0: True},
				(14, 5): {0: True},
				(14, 7): {0: True},
				(15, 6): {0: True},
			},
			(14, 7): {
				(13, 7): {0: True},
				(14, 6): {0: True},
				(14, 8): {0: True},
				(15, 7): {0: True},
			},
			(14, 8): {
				(13, 8): {0: True},
				(14, 7): {0: True},
				(14, 9): {0: True},
				(15, 8): {0: True},
			},
			(14, 9): {
				(13, 9): {0: True},
				(14, 8): {0: True},
				(14, 10): {0: True},
				(15, 9): {0: True},
			},
			(14, 10): {
				(13, 10): {0: True},
				(14, 9): {0: True},
				(14, 11): {0: True},
				(15, 10): {0: True},
			},
			(14, 11): {
				(13, 11): {0: True},
				(14, 10): {0: True},
				(14, 12): {0: True},
				(15, 11): {0: True},
			},
			(14, 12): {
				(13, 12): {0: True},
				(14, 11): {0: True},
				(14, 13): {0: True},
				(15, 12): {0: True},
			},
			(14, 13): {
				(13, 13): {0: True},
				(14, 12): {0: True},
				(14, 14): {0: True},
				(15, 13): {0: True},
			},
			(14, 14): {
				(13, 14): {0: True},
				(14, 13): {0: True},
				(14, 15): {0: True},
				(15, 14): {0: True},
			},
			(14, 15): {
				(13, 15): {0: True},
				(14, 14): {0: True},
				(14, 16): {0: True},
				(15, 15): {0: True},
			},
			(14, 16): {
				(13, 16): {0: True},
				(14, 15): {0: True},
				(14, 17): {0: True},
				(15, 16): {0: True},
			},
			(14, 17): {
				(13, 17): {0: True},
				(14, 16): {0: True},
				(14, 18): {0: True},
				(15, 17): {0: True},
			},
			(14, 18): {
				(13, 18): {0: True},
				(14, 17): {0: True},
				(14, 19): {0: True},
				(15, 18): {0: True},
			},
			(14, 19): {
				(13, 19): {0: True},
				(14, 18): {0: True},
				(14, 20): {0: True},
				(15, 19): {0: True},
			},
			(14, 20): {
				(13, 20): {0: True},
				(14, 19): {0: True},
				(14, 21): {0: True},
				(15, 20): {0: True},
			},
			(14, 21): {
				(13, 21): {0: True},
				(14, 20): {0: True},
				(14, 22): {0: True},
				(15, 21): {0: True},
			},
			(14, 22): {
				(13, 22): {0: True},
				(14, 21): {0: True},
				(14, 23): {0: True},
				(15, 22): {0: True},
			},
			(14, 23): {
				(13, 23): {0: True},
				(14, 22): {0: True},
				(14, 24): {0: True},
				(15, 23): {0: True},
			},
			(14, 24): {
				(13, 24): {0: True},
				(14, 23): {0: True},
				(15, 24): {0: True},
			},
			(15, 0): {
				(14, 0): {0: True},
				(15, 1): {0: True},
				(16, 0): {0: True},
			},
			(15, 1): {
				(14, 1): {0: True},
				(15, 0): {0: True},
				(15, 2): {0: True},
				(16, 1): {0: True},
			},
			(15, 2): {
				(14, 2): {0: True},
				(15, 1): {0: True},
				(15, 3): {0: True},
				(16, 2): {0: True},
			},
			(15, 3): {
				(14, 3): {0: True},
				(15, 2): {0: True},
				(15, 4): {0: True},
				(16, 3): {0: True},
			},
			(15, 4): {
				(14, 4): {0: True},
				(15, 3): {0: True},
				(15, 5): {0: True},
				(16, 4): {0: True},
			},
			(15, 5): {
				(14, 5): {0: True},
				(15, 4): {0: True},
				(15, 6): {0: True},
				(16, 5): {0: True},
			},
			(15, 6): {
				(14, 6): {0: True},
				(15, 5): {0: True},
				(15, 7): {0: True},
				(16, 6): {0: True},
			},
			(15, 7): {
				(14, 7): {0: True},
				(15, 6): {0: True},
				(15, 8): {0: True},
				(16, 7): {0: True},
			},
			(15, 8): {
				(14, 8): {0: True},
				(15, 7): {0: True},
				(15, 9): {0: True},
				(16, 8): {0: True},
			},
			(15, 9): {
				(14, 9): {0: True},
				(15, 8): {0: True},
				(15, 10): {0: True},
				(16, 9): {0: True},
			},
			(15, 10): {
				(14, 10): {0: True},
				(15, 9): {0: True},
				(15, 11): {0: True},
				(16, 10): {0: True},
			},
			(15, 11): {
				(14, 11): {0: True},
				(15, 10): {0: True},
				(15, 12): {0: True},
				(16, 11): {0: True},
			},
			(15, 12): {
				(14, 12): {0: True},
				(15, 11): {0: True},
				(15, 13): {0: True},
				(16, 12): {0: True},
			},
			(15, 13): {
				(14, 13): {0: True},
				(15, 12): {0: True},
				(15, 14): {0: True},
				(16, 13): {0: True},
			},
			(15, 14): {
				(14, 14): {0: True},
				(15, 13): {0: True},
				(15, 15): {0: True},
				(16, 14): {0: True},
			},
			(15, 15): {
				(14, 15): {0: True},
				(15, 14): {0: True},
				(15, 16): {0: True},
				(16, 15): {0: True},
			},
			(15, 16): {
				(14, 16): {0: True},
				(15, 15): {0: True},
				(15, 17): {0: True},
				(16, 16): {0: True},
			},
			(15, 17): {
				(14, 17): {0: True},
				(15, 16): {0: True},
				(15, 18): {0: True},
				(16, 17): {0: True},
			},
			(15, 18): {
				(14, 18): {0: True},
				(15, 17): {0: True},
				(15, 19): {0: True},
				(16, 18): {0: True},
			},
			(15, 19): {
				(14, 19): {0: True},
				(15, 18): {0: True},
				(15, 20): {0: True},
				(16, 19): {0: True},
			},
			(15, 20): {
				(14, 20): {0: True},
				(15, 19): {0: True},
				(15, 21): {0: True},
				(16, 20): {0: True},
			},
			(15, 21): {
				(14, 21): {0: True},
				(15, 20): {0: True},
				(15, 22): {0: True},
				(16, 21): {0: True},
			},
			(15, 22): {
				(14, 22): {0: True},
				(15, 21): {0: True},
				(15, 23): {0: True},
				(16, 22): {0: True},
			},
			(15, 23): {
				(14, 23): {0: True},
				(15, 22): {0: True},
				(15, 24): {0: True},
				(16, 23): {0: True},
			},
			(15, 24): {
				(14, 24): {0: True},
				(15, 23): {0: True},
				(16, 24): {0: True},
			},
			(16, 0): {
				(15, 0): {0: True},
				(16, 1): {0: True},
				(17, 0): {0: True},
			},
			(16, 1): {
				(15, 1): {0: True},
				(16, 0): {0: True},
				(16, 2): {0: True},
				(17, 1): {0: True},
			},
			(16, 2): {
				(15, 2): {0: True},
				(16, 1): {0: True},
				(16, 3): {0: True},
				(17, 2): {0: True},
			},
			(16, 3): {
				(15, 3): {0: True},
				(16, 2): {0: True},
				(16, 4): {0: True},
				(17, 3): {0: True},
			},
			(16, 4): {
				(15, 4): {0: True},
				(16, 3): {0: True},
				(16, 5): {0: True},
				(17, 4): {0: True},
			},
			(16, 5): {
				(15, 5): {0: True},
				(16, 4): {0: True},
				(16, 6): {0: True},
				(17, 5): {0: True},
			},
			(16, 6): {
				(15, 6): {0: True},
				(16, 5): {0: True},
				(16, 7): {0: True},
				(17, 6): {0: True},
			},
			(16, 7): {
				(15, 7): {0: True},
				(16, 6): {0: True},
				(16, 8): {0: True},
				(17, 7): {0: True},
			},
			(16, 8): {
				(15, 8): {0: True},
				(16, 7): {0: True},
				(16, 9): {0: True},
				(17, 8): {0: True},
			},
			(16, 9): {
				(15, 9): {0: True},
				(16, 8): {0: True},
				(16, 10): {0: True},
				(17, 9): {0: True},
			},
			(16, 10): {
				(15, 10): {0: True},
				(16, 9): {0: True},
				(16, 11): {0: True},
				(17, 10): {0: True},
			},
			(16, 11): {
				(15, 11): {0: True},
				(16, 10): {0: True},
				(16, 12): {0: True},
				(17, 11): {0: True},
			},
			(16, 12): {
				(15, 12): {0: True},
				(16, 11): {0: True},
				(16, 13): {0: True},
				(17, 12): {0: True},
			},
			(16, 13): {
				(15, 13): {0: True},
				(16, 12): {0: True},
				(16, 14): {0: True},
				(17, 13): {0: True},
			},
			(16, 14): {
				(15, 14): {0: True},
				(16, 13): {0: True},
				(16, 15): {0: True},
				(17, 14): {0: True},
			},
			(16, 15): {
				(15, 15): {0: True},
				(16, 14): {0: True},
				(16, 16): {0: True},
				(17, 15): {0: True},
			},
			(16, 16): {
				(15, 16): {0: True},
				(16, 15): {0: True},
				(16, 17): {0: True},
				(17, 16): {0: True},
			},
			(16, 17): {
				(15, 17): {0: True},
				(16, 16): {0: True},
				(16, 18): {0: True},
				(17, 17): {0: True},
			},
			(16, 18): {
				(15, 18): {0: True},
				(16, 17): {0: True},
				(16, 19): {0: True},
				(17, 18): {0: True},
			},
			(16, 19): {
				(15, 19): {0: True},
				(16, 18): {0: True},
				(16, 20): {0: True},
				(17, 19): {0: True},
			},
			(16, 20): {
				(15, 20): {0: True},
				(16, 19): {0: True},
				(16, 21): {0: True},
				(17, 20): {0: True},
			},
			(16, 21): {
				(15, 21): {0: True},
				(16, 20): {0: True},
				(16, 22): {0: True},
				(17, 21): {0: True},
			},
			(16, 22): {
				(15, 22): {0: True},
				(16, 21): {0: True},
				(16, 23): {0: True},
				(17, 22): {0: True},
			},
			(16, 23): {
				(15, 23): {0: True},
				(16, 22): {0: True},
				(16, 24): {0: True},
				(17, 23): {0: True},
			},
			(16, 24): {
				(15, 24): {0: True},
				(16, 23): {0: True},
				(17, 24): {0: True},
			},
			(17, 0): {
				(16, 0): {0: True},
				(17, 1): {0: True},
				(18, 0): {0: True},
			},
			(17, 1): {
				(16, 1): {0: True},
				(17, 0): {0: True},
				(17, 2): {0: True},
				(18, 1): {0: True},
			},
			(17, 2): {
				(16, 2): {0: True},
				(17, 1): {0: True},
				(17, 3): {0: True},
				(18, 2): {0: True},
			},
			(17, 3): {
				(16, 3): {0: True},
				(17, 2): {0: True},
				(17, 4): {0: True},
				(18, 3): {0: True},
			},
			(17, 4): {
				(16, 4): {0: True},
				(17, 3): {0: True},
				(17, 5): {0: True},
				(18, 4): {0: True},
			},
			(17, 5): {
				(16, 5): {0: True},
				(17, 4): {0: True},
				(17, 6): {0: True},
				(18, 5): {0: True},
			},
			(17, 6): {
				(16, 6): {0: True},
				(17, 5): {0: True},
				(17, 7): {0: True},
				(18, 6): {0: True},
			},
			(17, 7): {
				(16, 7): {0: True},
				(17, 6): {0: True},
				(17, 8): {0: True},
				(18, 7): {0: True},
			},
			(17, 8): {
				(16, 8): {0: True},
				(17, 7): {0: True},
				(17, 9): {0: True},
				(18, 8): {0: True},
			},
			(17, 9): {
				(16, 9): {0: True},
				(17, 8): {0: True},
				(17, 10): {0: True},
				(18, 9): {0: True},
			},
			(17, 10): {
				(16, 10): {0: True},
				(17, 9): {0: True},
				(17, 11): {0: True},
				(18, 10): {0: True},
			},
			(17, 11): {
				(16, 11): {0: True},
				(17, 10): {0: True},
				(17, 12): {0: True},
				(18, 11): {0: True},
			},
			(17, 12): {
				(16, 12): {0: True},
				(17, 11): {0: True},
				(17, 13): {0: True},
				(18, 12): {0: True},
			},
			(17, 13): {
				(16, 13): {0: True},
				(17, 12): {0: True},
				(17, 14): {0: True},
				(18, 13): {0: True},
			},
			(17, 14): {
				(16, 14): {0: True},
				(17, 13): {0: True},
				(17, 15): {0: True},
				(18, 14): {0: True},
			},
			(17, 15): {
				(16, 15): {0: True},
				(17, 14): {0: True},
				(17, 16): {0: True},
				(18, 15): {0: True},
			},
			(17, 16): {
				(16, 16): {0: True},
				(17, 15): {0: True},
				(17, 17): {0: True},
				(18, 16): {0: True},
			},
			(17, 17): {
				(16, 17): {0: True},
				(17, 16): {0: True},
				(17, 18): {0: True},
				(18, 17): {0: True},
			},
			(17, 18): {
				(16, 18): {0: True},
				(17, 17): {0: True},
				(17, 19): {0: True},
				(18, 18): {0: True},
			},
			(17, 19): {
				(16, 19): {0: True},
				(17, 18): {0: True},
				(17, 20): {0: True},
				(18, 19): {0: True},
			},
			(17, 20): {
				(16, 20): {0: True},
				(17, 19): {0: True},
				(17, 21): {0: True},
				(18, 20): {0: True},
			},
			(17, 21): {
				(16, 21): {0: True},
				(17, 20): {0: True},
				(17, 22): {0: True},
				(18, 21): {0: True},
			},
			(17, 22): {
				(16, 22): {0: True},
				(17, 21): {0: True},
				(17, 23): {0: True},
				(18, 22): {0: True},
			},
			(17, 23): {
				(16, 23): {0: True},
				(17, 22): {0: True},
				(17, 24): {0: True},
				(18, 23): {0: True},
			},
			(17, 24): {
				(16, 24): {0: True},
				(17, 23): {0: True},
				(18, 24): {0: True},
			},
			(18, 0): {
				(17, 0): {0: True},
				(18, 1): {0: True},
				(19, 0): {0: True},
			},
			(18, 1): {
				(17, 1): {0: True},
				(18, 0): {0: True},
				(18, 2): {0: True},
				(19, 1): {0: True},
			},
			(18, 2): {
				(17, 2): {0: True},
				(18, 1): {0: True},
				(18, 3): {0: True},
				(19, 2): {0: True},
			},
			(18, 3): {
				(17, 3): {0: True},
				(18, 2): {0: True},
				(18, 4): {0: True},
				(19, 3): {0: True},
			},
			(18, 4): {
				(17, 4): {0: True},
				(18, 3): {0: True},
				(18, 5): {0: True},
				(19, 4): {0: True},
			},
			(18, 5): {
				(17, 5): {0: True},
				(18, 4): {0: True},
				(18, 6): {0: True},
				(19, 5): {0: True},
			},
			(18, 6): {
				(17, 6): {0: True},
				(18, 5): {0: True},
				(18, 7): {0: True},
				(19, 6): {0: True},
			},
			(18, 7): {
				(17, 7): {0: True},
				(18, 6): {0: True},
				(18, 8): {0: True},
				(19, 7): {0: True},
			},
			(18, 8): {
				(17, 8): {0: True},
				(18, 7): {0: True},
				(18, 9): {0: True},
				(19, 8): {0: True},
			},
			(18, 9): {
				(17, 9): {0: True},
				(18, 8): {0: True},
				(18, 10): {0: True},
				(19, 9): {0: True},
			},
			(18, 10): {
				(17, 10): {0: True},
				(18, 9): {0: True},
				(18, 11): {0: True},
				(19, 10): {0: True},
			},
			(18, 11): {
				(17, 11): {0: True},
				(18, 10): {0: True},
				(18, 12): {0: True},
				(19, 11): {0: True},
			},
			(18, 12): {
				(17, 12): {0: True},
				(18, 11): {0: True},
				(18, 13): {0: True},
				(19, 12): {0: True},
			},
			(18, 13): {
				(17, 13): {0: True},
				(18, 12): {0: True},
				(18, 14): {0: True},
				(19, 13): {0: True},
			},
			(18, 14): {
				(17, 14): {0: True},
				(18, 13): {0: True},
				(18, 15): {0: True},
				(19, 14): {0: True},
			},
			(18, 15): {
				(17, 15): {0: True},
				(18, 14): {0: True},
				(18, 16): {0: True},
				(19, 15): {0: True},
			},
			(18, 16): {
				(17, 16): {0: True},
				(18, 15): {0: True},
				(18, 17): {0: True},
				(19, 16): {0: True},
			},
			(18, 17): {
				(17, 17): {0: True},
				(18, 16): {0: True},
				(18, 18): {0: True},
				(19, 17): {0: True},
			},
			(18, 18): {
				(17, 18): {0: True},
				(18, 17): {0: True},
				(18, 19): {0: True},
				(19, 18): {0: True},
			},
			(18, 19): {
				(17, 19): {0: True},
				(18, 18): {0: True},
				(18, 20): {0: True},
				(19, 19): {0: True},
			},
			(18, 20): {
				(17, 20): {0: True},
				(18, 19): {0: True},
				(18, 21): {0: True},
				(19, 20): {0: True},
			},
			(18, 21): {
				(17, 21): {0: True},
				(18, 20): {0: True},
				(18, 22): {0: True},
				(19, 21): {0: True},
			},
			(18, 22): {
				(17, 22): {0: True},
				(18, 21): {0: True},
				(18, 23): {0: True},
				(19, 22): {0: True},
			},
			(18, 23): {
				(17, 23): {0: True},
				(18, 22): {0: True},
				(18, 24): {0: True},
				(19, 23): {0: True},
			},
			(18, 24): {
				(17, 24): {0: True},
				(18, 23): {0: True},
				(19, 24): {0: True},
			},
			(19, 0): {
				(18, 0): {0: True},
				(19, 1): {0: True},
				(20, 0): {0: True},
			},
			(19, 1): {
				(18, 1): {0: True},
				(19, 0): {0: True},
				(19, 2): {0: True},
				(20, 1): {0: True},
			},
			(19, 2): {
				(18, 2): {0: True},
				(19, 1): {0: True},
				(19, 3): {0: True},
				(20, 2): {0: True},
			},
			(19, 3): {
				(18, 3): {0: True},
				(19, 2): {0: True},
				(19, 4): {0: True},
				(20, 3): {0: True},
			},
			(19, 4): {
				(18, 4): {0: True},
				(19, 3): {0: True},
				(19, 5): {0: True},
				(20, 4): {0: True},
			},
			(19, 5): {
				(18, 5): {0: True},
				(19, 4): {0: True},
				(19, 6): {0: True},
				(20, 5): {0: True},
			},
			(19, 6): {
				(18, 6): {0: True},
				(19, 5): {0: True},
				(19, 7): {0: True},
				(20, 6): {0: True},
			},
			(19, 7): {
				(18, 7): {0: True},
				(19, 6): {0: True},
				(19, 8): {0: True},
				(20, 7): {0: True},
			},
			(19, 8): {
				(18, 8): {0: True},
				(19, 7): {0: True},
				(19, 9): {0: True},
				(20, 8): {0: True},
			},
			(19, 9): {
				(18, 9): {0: True},
				(19, 8): {0: True},
				(19, 10): {0: True},
				(20, 9): {0: True},
			},
			(19, 10): {
				(18, 10): {0: True},
				(19, 9): {0: True},
				(19, 11): {0: True},
				(20, 10): {0: True},
			},
			(19, 11): {
				(18, 11): {0: True},
				(19, 10): {0: True},
				(19, 12): {0: True},
				(20, 11): {0: True},
			},
			(19, 12): {
				(18, 12): {0: True},
				(19, 11): {0: True},
				(19, 13): {0: True},
				(20, 12): {0: True},
			},
			(19, 13): {
				(18, 13): {0: True},
				(19, 12): {0: True},
				(19, 14): {0: True},
				(20, 13): {0: True},
			},
			(19, 14): {
				(18, 14): {0: True},
				(19, 13): {0: True},
				(19, 15): {0: True},
				(20, 14): {0: True},
			},
			(19, 15): {
				(18, 15): {0: True},
				(19, 14): {0: True},
				(19, 16): {0: True},
				(20, 15): {0: True},
			},
			(19, 16): {
				(18, 16): {0: True},
				(19, 15): {0: True},
				(19, 17): {0: True},
				(20, 16): {0: True},
			},
			(19, 17): {
				(18, 17): {0: True},
				(19, 16): {0: True},
				(19, 18): {0: True},
				(20, 17): {0: True},
			},
			(19, 18): {
				(18, 18): {0: True},
				(19, 17): {0: True},
				(19, 19): {0: True},
				(20, 18): {0: True},
			},
			(19, 19): {
				(18, 19): {0: True},
				(19, 18): {0: True},
				(19, 20): {0: True},
				(20, 19): {0: True},
			},
			(19, 20): {
				(18, 20): {0: True},
				(19, 19): {0: True},
				(19, 21): {0: True},
				(20, 20): {0: True},
			},
			(19, 21): {
				(18, 21): {0: True},
				(19, 20): {0: True},
				(19, 22): {0: True},
				(20, 21): {0: True},
			},
			(19, 22): {
				(18, 22): {0: True},
				(19, 21): {0: True},
				(19, 23): {0: True},
				(20, 22): {0: True},
			},
			(19, 23): {
				(18, 23): {0: True},
				(19, 22): {0: True},
				(19, 24): {0: True},
				(20, 23): {0: True},
			},
			(19, 24): {
				(18, 24): {0: True},
				(19, 23): {0: True},
				(20, 24): {0: True},
			},
			(20, 0): {
				(19, 0): {0: True},
				(20, 1): {0: True},
				(21, 0): {0: True},
			},
			(20, 1): {
				(19, 1): {0: True},
				(20, 0): {0: True},
				(20, 2): {0: True},
				(21, 1): {0: True},
			},
			(20, 2): {
				(19, 2): {0: True},
				(20, 1): {0: True},
				(20, 3): {0: True},
				(21, 2): {0: True},
			},
			(20, 3): {
				(19, 3): {0: True},
				(20, 2): {0: True},
				(20, 4): {0: True},
				(21, 3): {0: True},
			},
			(20, 4): {
				(19, 4): {0: True},
				(20, 3): {0: True},
				(20, 5): {0: True},
				(21, 4): {0: True},
			},
			(20, 5): {
				(19, 5): {0: True},
				(20, 4): {0: True},
				(20, 6): {0: True},
				(21, 5): {0: True},
			},
			(20, 6): {
				(19, 6): {0: True},
				(20, 5): {0: True},
				(20, 7): {0: True},
				(21, 6): {0: True},
			},
			(20, 7): {
				(19, 7): {0: True},
				(20, 6): {0: True},
				(20, 8): {0: True},
				(21, 7): {0: True},
			},
			(20, 8): {
				(19, 8): {0: True},
				(20, 7): {0: True},
				(20, 9): {0: True},
				(21, 8): {0: True},
			},
			(20, 9): {
				(19, 9): {0: True},
				(20, 8): {0: True},
				(20, 10): {0: True},
				(21, 9): {0: True},
			},
			(20, 10): {
				(19, 10): {0: True},
				(20, 9): {0: True},
				(20, 11): {0: True},
				(21, 10): {0: True},
			},
			(20, 11): {
				(19, 11): {0: True},
				(20, 10): {0: True},
				(20, 12): {0: True},
				(21, 11): {0: True},
			},
			(20, 12): {
				(19, 12): {0: True},
				(20, 11): {0: True},
				(20, 13): {0: True},
				(21, 12): {0: True},
			},
			(20, 13): {
				(19, 13): {0: True},
				(20, 12): {0: True},
				(20, 14): {0: True},
				(21, 13): {0: True},
			},
			(20, 14): {
				(19, 14): {0: True},
				(20, 13): {0: True},
				(20, 15): {0: True},
				(21, 14): {0: True},
			},
			(20, 15): {
				(19, 15): {0: True},
				(20, 14): {0: True},
				(20, 16): {0: True},
				(21, 15): {0: True},
			},
			(20, 16): {
				(19, 16): {0: True},
				(20, 15): {0: True},
				(20, 17): {0: True},
				(21, 16): {0: True},
			},
			(20, 17): {
				(19, 17): {0: True},
				(20, 16): {0: True},
				(20, 18): {0: True},
				(21, 17): {0: True},
			},
			(20, 18): {
				(19, 18): {0: True},
				(20, 17): {0: True},
				(20, 19): {0: True},
				(21, 18): {0: True},
			},
			(20, 19): {
				(19, 19): {0: True},
				(20, 18): {0: True},
				(20, 20): {0: True},
				(21, 19): {0: True},
			},
			(20, 20): {
				(19, 20): {0: True},
				(20, 19): {0: True},
				(20, 21): {0: True},
				(21, 20): {0: True},
			},
			(20, 21): {
				(19, 21): {0: True},
				(20, 20): {0: True},
				(20, 22): {0: True},
				(21, 21): {0: True},
			},
			(20, 22): {
				(19, 22): {0: True},
				(20, 21): {0: True},
				(20, 23): {0: True},
				(21, 22): {0: True},
			},
			(20, 23): {
				(19, 23): {0: True},
				(20, 22): {0: True},
				(20, 24): {0: True},
				(21, 23): {0: True},
			},
			(20, 24): {
				(19, 24): {0: True},
				(20, 23): {0: True},
				(21, 24): {0: True},
			},
			(21, 0): {
				(20, 0): {0: True},
				(21, 1): {0: True},
				(22, 0): {0: True},
			},
			(21, 1): {
				(20, 1): {0: True},
				(21, 0): {0: True},
				(21, 2): {0: True},
				(22, 1): {0: True},
			},
			(21, 2): {
				(20, 2): {0: True},
				(21, 1): {0: True},
				(21, 3): {0: True},
				(22, 2): {0: True},
			},
			(21, 3): {
				(20, 3): {0: True},
				(21, 2): {0: True},
				(21, 4): {0: True},
				(22, 3): {0: True},
			},
			(21, 4): {
				(20, 4): {0: True},
				(21, 3): {0: True},
				(21, 5): {0: True},
				(22, 4): {0: True},
			},
			(21, 5): {
				(20, 5): {0: True},
				(21, 4): {0: True},
				(21, 6): {0: True},
				(22, 5): {0: True},
			},
			(21, 6): {
				(20, 6): {0: True},
				(21, 5): {0: True},
				(21, 7): {0: True},
				(22, 6): {0: True},
			},
			(21, 7): {
				(20, 7): {0: True},
				(21, 6): {0: True},
				(21, 8): {0: True},
				(22, 7): {0: True},
			},
			(21, 8): {
				(20, 8): {0: True},
				(21, 7): {0: True},
				(21, 9): {0: True},
				(22, 8): {0: True},
			},
			(21, 9): {
				(20, 9): {0: True},
				(21, 8): {0: True},
				(21, 10): {0: True},
				(22, 9): {0: True},
			},
			(21, 10): {
				(20, 10): {0: True},
				(21, 9): {0: True},
				(21, 11): {0: True},
				(22, 10): {0: True},
			},
			(21, 11): {
				(20, 11): {0: True},
				(21, 10): {0: True},
				(21, 12): {0: True},
				(22, 11): {0: True},
			},
			(21, 12): {
				(20, 12): {0: True},
				(21, 11): {0: True},
				(21, 13): {0: True},
				(22, 12): {0: True},
			},
			(21, 13): {
				(20, 13): {0: True},
				(21, 12): {0: True},
				(21, 14): {0: True},
				(22, 13): {0: True},
			},
			(21, 14): {
				(20, 14): {0: True},
				(21, 13): {0: True},
				(21, 15): {0: True},
				(22, 14): {0: True},
			},
			(21, 15): {
				(20, 15): {0: True},
				(21, 14): {0: True},
				(21, 16): {0: True},
				(22, 15): {0: True},
			},
			(21, 16): {
				(20, 16): {0: True},
				(21, 15): {0: True},
				(21, 17): {0: True},
				(22, 16): {0: True},
			},
			(21, 17): {
				(20, 17): {0: True},
				(21, 16): {0: True},
				(21, 18): {0: True},
				(22, 17): {0: True},
			},
			(21, 18): {
				(20, 18): {0: True},
				(21, 17): {0: True},
				(21, 19): {0: True},
				(22, 18): {0: True},
			},
			(21, 19): {
				(20, 19): {0: True},
				(21, 18): {0: True},
				(21, 20): {0: True},
				(22, 19): {0: True},
			},
			(21, 20): {
				(20, 20): {0: True},
				(21, 19): {0: True},
				(21, 21): {0: True},
				(22, 20): {0: True},
			},
			(21, 21): {
				(20, 21): {0: True},
				(21, 20): {0: True},
				(21, 22): {0: True},
				(22, 21): {0: True},
			},
			(21, 22): {
				(20, 22): {0: True},
				(21, 21): {0: True},
				(21, 23): {0: True},
				(22, 22): {0: True},
			},
			(21, 23): {
				(20, 23): {0: True},
				(21, 22): {0: True},
				(21, 24): {0: True},
				(22, 23): {0: True},
			},
			(21, 24): {
				(20, 24): {0: True},
				(21, 23): {0: True},
				(22, 24): {0: True},
			},
			(22, 0): {
				(21, 0): {0: True},
				(22, 1): {0: True},
				(23, 0): {0: True},
			},
			(22, 1): {
				(21, 1): {0: True},
				(22, 0): {0: True},
				(22, 2): {0: True},
				(23, 1): {0: True},
			},
			(22, 2): {
				(21, 2): {0: True},
				(22, 1): {0: True},
				(22, 3): {0: True},
				(23, 2): {0: True},
			},
			(22, 3): {
				(21, 3): {0: True},
				(22, 2): {0: True},
				(22, 4): {0: True},
				(23, 3): {0: True},
			},
			(22, 4): {
				(21, 4): {0: True},
				(22, 3): {0: True},
				(22, 5): {0: True},
				(23, 4): {0: True},
			},
			(22, 5): {
				(21, 5): {0: True},
				(22, 4): {0: True},
				(22, 6): {0: True},
				(23, 5): {0: True},
			},
			(22, 6): {
				(21, 6): {0: True},
				(22, 5): {0: True},
				(22, 7): {0: True},
				(23, 6): {0: True},
			},
			(22, 7): {
				(21, 7): {0: True},
				(22, 6): {0: True},
				(22, 8): {0: True},
				(23, 7): {0: True},
			},
			(22, 8): {
				(21, 8): {0: True},
				(22, 7): {0: True},
				(22, 9): {0: True},
				(23, 8): {0: True},
			},
			(22, 9): {
				(21, 9): {0: True},
				(22, 8): {0: True},
				(22, 10): {0: True},
				(23, 9): {0: True},
			},
			(22, 10): {
				(21, 10): {0: True},
				(22, 9): {0: True},
				(22, 11): {0: True},
				(23, 10): {0: True},
			},
			(22, 11): {
				(21, 11): {0: True},
				(22, 10): {0: True},
				(22, 12): {0: True},
				(23, 11): {0: True},
			},
			(22, 12): {
				(21, 12): {0: True},
				(22, 11): {0: True},
				(22, 13): {0: True},
				(23, 12): {0: True},
			},
			(22, 13): {
				(21, 13): {0: True},
				(22, 12): {0: True},
				(22, 14): {0: True},
				(23, 13): {0: True},
			},
			(22, 14): {
				(21, 14): {0: True},
				(22, 13): {0: True},
				(22, 15): {0: True},
				(23, 14): {0: True},
			},
			(22, 15): {
				(21, 15): {0: True},
				(22, 14): {0: True},
				(22, 16): {0: True},
				(23, 15): {0: True},
			},
			(22, 16): {
				(21, 16): {0: True},
				(22, 15): {0: True},
				(22, 17): {0: True},
				(23, 16): {0: True},
			},
			(22, 17): {
				(21, 17): {0: True},
				(22, 16): {0: True},
				(22, 18): {0: True},
				(23, 17): {0: True},
			},
			(22, 18): {
				(21, 18): {0: True},
				(22, 17): {0: True},
				(22, 19): {0: True},
				(23, 18): {0: True},
			},
			(22, 19): {
				(21, 19): {0: True},
				(22, 18): {0: True},
				(22, 20): {0: True},
				(23, 19): {0: True},
			},
			(22, 20): {
				(21, 20): {0: True},
				(22, 19): {0: True},
				(22, 21): {0: True},
				(23, 20): {0: True},
			},
			(22, 21): {
				(21, 21): {0: True},
				(22, 20): {0: True},
				(22, 22): {0: True},
				(23, 21): {0: True},
			},
			(22, 22): {
				(21, 22): {0: True},
				(22, 21): {0: True},
				(22, 23): {0: True},
				(23, 22): {0: True},
			},
			(22, 23): {
				(21, 23): {0: True},
				(22, 22): {0: True},
				(22, 24): {0: True},
				(23, 23): {0: True},
			},
			(22, 24): {
				(21, 24): {0: True},
				(22, 23): {0: True},
				(23, 24): {0: True},
			},
			(23, 0): {
				(22, 0): {0: True},
				(23, 1): {0: True},
				(24, 0): {0: True},
			},
			(23, 1): {
				(22, 1): {0: True},
				(23, 0): {0: True},
				(23, 2): {0: True},
				(24, 1): {0: True},
			},
			(23, 2): {
				(22, 2): {0: True},
				(23, 1): {0: True},
				(23, 3): {0: True},
				(24, 2): {0: True},
			},
			(23, 3): {
				(22, 3): {0: True},
				(23, 2): {0: True},
				(23, 4): {0: True},
				(24, 3): {0: True},
			},
			(23, 4): {
				(22, 4): {0: True},
				(23, 3): {0: True},
				(23, 5): {0: True},
				(24, 4): {0: True},
			},
			(23, 5): {
				(22, 5): {0: True},
				(23, 4): {0: True},
				(23, 6): {0: True},
				(24, 5): {0: True},
			},
			(23, 6): {
				(22, 6): {0: True},
				(23, 5): {0: True},
				(23, 7): {0: True},
				(24, 6): {0: True},
			},
			(23, 7): {
				(22, 7): {0: True},
				(23, 6): {0: True},
				(23, 8): {0: True},
				(24, 7): {0: True},
			},
			(23, 8): {
				(22, 8): {0: True},
				(23, 7): {0: True},
				(23, 9): {0: True},
				(24, 8): {0: True},
			},
			(23, 9): {
				(22, 9): {0: True},
				(23, 8): {0: True},
				(23, 10): {0: True},
				(24, 9): {0: True},
			},
			(23, 10): {
				(22, 10): {0: True},
				(23, 9): {0: True},
				(23, 11): {0: True},
				(24, 10): {0: True},
			},
			(23, 11): {
				(22, 11): {0: True},
				(23, 10): {0: True},
				(23, 12): {0: True},
				(24, 11): {0: True},
			},
			(23, 12): {
				(22, 12): {0: True},
				(23, 11): {0: True},
				(23, 13): {0: True},
				(24, 12): {0: True},
			},
			(23, 13): {
				(22, 13): {0: True},
				(23, 12): {0: True},
				(23, 14): {0: True},
				(24, 13): {0: True},
			},
			(23, 14): {
				(22, 14): {0: True},
				(23, 13): {0: True},
				(23, 15): {0: True},
				(24, 14): {0: True},
			},
			(23, 15): {
				(22, 15): {0: True},
				(23, 14): {0: True},
				(23, 16): {0: True},
				(24, 15): {0: True},
			},
			(23, 16): {
				(22, 16): {0: True},
				(23, 15): {0: True},
				(23, 17): {0: True},
				(24, 16): {0: True},
			},
			(23, 17): {
				(22, 17): {0: True},
				(23, 16): {0: True},
				(23, 18): {0: True},
				(24, 17): {0: True},
			},
			(23, 18): {
				(22, 18): {0: True},
				(23, 17): {0: True},
				(23, 19): {0: True},
				(24, 18): {0: True},
			},
			(23, 19): {
				(22, 19): {0: True},
				(23, 18): {0: True},
				(23, 20): {0: True},
				(24, 19): {0: True},
			},
			(23, 20): {
				(22, 20): {0: True},
				(23, 19): {0: True},
				(23, 21): {0: True},
				(24, 20): {0: True},
			},
			(23, 21): {
				(22, 21): {0: True},
				(23, 20): {0: True},
				(23, 22): {0: True},
				(24, 21): {0: True},
			},
			(23, 22): {
				(22, 22): {0: True},
				(23, 21): {0: True},
				(23, 23): {0: True},
				(24, 22): {0: True},
			},
			(23, 23): {
				(22, 23): {0: True},
				(23, 22): {0: True},
				(23, 24): {0: True},
				(24, 23): {0: True},
			},
			(23, 24): {
				(22, 24): {0: True},
				(23, 23): {0: True},
				(24, 24): {0: True},
			},
			(24, 0): {(23, 0): {0: True}, (24, 1): {0: True}},
			(24, 1): {
				(23, 1): {0: True},
				(24, 0): {0: True},
				(24, 2): {0: True},
			},
			(24, 2): {
				(23, 2): {0: True},
				(24, 1): {0: True},
				(24, 3): {0: True},
			},
			(24, 3): {
				(23, 3): {0: True},
				(24, 2): {0: True},
				(24, 4): {0: True},
			},
			(24, 4): {
				(23, 4): {0: True},
				(24, 3): {0: True},
				(24, 5): {0: True},
			},
			(24, 5): {
				(23, 5): {0: True},
				(24, 4): {0: True},
				(24, 6): {0: True},
			},
			(24, 6): {
				(23, 6): {0: True},
				(24, 5): {0: True},
				(24, 7): {0: True},
			},
			(24, 7): {
				(23, 7): {0: True},
				(24, 6): {0: True},
				(24, 8): {0: True},
			},
			(24, 8): {
				(23, 8): {0: True},
				(24, 7): {0: True},
				(24, 9): {0: True},
			},
			(24, 9): {
				(23, 9): {0: True},
				(24, 8): {0: True},
				(24, 10): {0: True},
			},
			(24, 10): {
				(23, 10): {0: True},
				(24, 9): {0: True},
				(24, 11): {0: True},
			},
			(24, 11): {
				(23, 11): {0: True},
				(24, 10): {0: True},
				(24, 12): {0: True},
			},
			(24, 12): {
				(23, 12): {0: True},
				(24, 11): {0: True},
				(24, 13): {0: True},
			},
			(24, 13): {
				(23, 13): {0: True},
				(24, 12): {0: True},
				(24, 14): {0: True},
			},
			(24, 14): {
				(23, 14): {0: True},
				(24, 13): {0: True},
				(24, 15): {0: True},
			},
			(24, 15): {
				(23, 15): {0: True},
				(24, 14): {0: True},
				(24, 16): {0: True},
			},
			(24, 16): {
				(23, 16): {0: True},
				(24, 15): {0: True},
				(24, 17): {0: True},
			},
			(24, 17): {
				(23, 17): {0: True},
				(24, 16): {0: True},
				(24, 18): {0: True},
			},
			(24, 18): {
				(23, 18): {0: True},
				(24, 17): {0: True},
				(24, 19): {0: True},
			},
			(24, 19): {
				(23, 19): {0: True},
				(24, 18): {0: True},
				(24, 20): {0: True},
			},
			(24, 20): {
				(23, 20): {0: True},
				(24, 19): {0: True},
				(24, 21): {0: True},
			},
			(24, 21): {
				(23, 21): {0: True},
				(24, 20): {0: True},
				(24, 22): {0: True},
			},
			(24, 22): {
				(23, 22): {0: True},
				(24, 21): {0: True},
				(24, 23): {0: True},
			},
			(24, 23): {
				(23, 23): {0: True},
				(24, 22): {0: True},
				(24, 24): {0: True},
			},
			(24, 24): {(23, 24): {0: True}, (24, 23): {0: True}},
		}
	},
	"graph_val": {
		"physical": {
			"bare_places": [
				(0, 1),
				(0, 2),
				(0, 3),
				(0, 4),
				(0, 6),
				(0, 8),
				(0, 10),
				(0, 12),
				(0, 13),
				(0, 14),
				(0, 16),
				(0, 20),
				(0, 21),
				(0, 24),
				(1, 0),
				(1, 4),
				(1, 8),
				(1, 10),
				(1, 14),
				(1, 15),
				(1, 16),
				(1, 17),
				(1, 18),
				(1, 20),
				(1, 24),
				(2, 1),
				(2, 2),
				(2, 6),
				(2, 8),
				(2, 9),
				(2, 14),
				(2, 17),
				(2, 18),
				(2, 19),
				(2, 20),
				(2, 22),
				(2, 23),
				(2, 24),
				(3, 8),
				(3, 9),
				(3, 10),
				(3, 11),
				(3, 15),
				(3, 17),
				(3, 20),
				(3, 21),
				(3, 22),
				(3, 24),
				(4, 1),
				(4, 2),
				(4, 3),
				(4, 6),
				(4, 8),
				(4, 9),
				(4, 10),
				(4, 14),
				(4, 16),
				(4, 18),
				(4, 21),
				(5, 4),
				(5, 8),
				(5, 9),
				(5, 11),
				(5, 16),
				(5, 18),
				(5, 19),
				(5, 20),
				(5, 24),
				(6, 0),
				(6, 1),
				(6, 2),
				(6, 9),
				(6, 11),
				(6, 17),
				(6, 23),
				(7, 4),
				(7, 6),
				(7, 9),
				(7, 10),
				(7, 11),
				(7, 12),
				(7, 14),
				(7, 16),
				(7, 17),
				(7, 19),
				(7, 23),
				(7, 24),
				(8, 0),
				(8, 2),
				(8, 6),
				(8, 8),
				(8, 10),
				(8, 12),
				(8, 15),
				(8, 18),
				(8, 19),
				(8, 21),
				(8, 22),
				(8, 23),
				(8, 24),
				(9, 0),
				(9, 1),
				(9, 2),
				(9, 4),
				(9, 5),
				(9, 6),
				(9, 8),
				(9, 11),
				(9, 15),
				(9, 16),
				(9, 17),
				(9, 18),
				(9, 20),
				(9, 21),
				(10, 0),
				(10, 1),
				(10, 2),
				(10, 3),
				(10, 4),
				(10, 5),
				(10, 6),
				(10, 7),
				(10, 10),
				(10, 11),
				(10, 14),
				(10, 15),
				(10, 16),
				(10, 17),
				(10, 19),
				(10, 20),
				(10, 21),
				(11, 0),
				(11, 1),
				(11, 3),
				(11, 4),
				(11, 5),
				(11, 10),
				(11, 11),
				(11, 12),
				(11, 13),
				(11, 14),
				(11, 15),
				(11, 18),
				(11, 20),
				(11, 22),
				(11, 23),
				(12, 1),
				(12, 2),
				(12, 3),
				(12, 4),
				(12, 5),
				(12, 7),
				(12, 8),
				(12, 9),
				(12, 10),
				(12, 14),
				(12, 17),
				(12, 19),
				(12, 20),
				(12, 21),
				(12, 22),
				(13, 1),
				(13, 2),
				(13, 5),
				(13, 6),
				(13, 7),
				(13, 12),
				(13, 13),
				(13, 14),
				(13, 15),
				(13, 17),
				(13, 18),
				(13, 20),
				(13, 23),
				(13, 24),
				(14, 1),
				(14, 5),
				(14, 7),
				(14, 10),
				(14, 12),
				(14, 15),
				(14, 17),
				(14, 19),
				(14, 23),
				(14, 24),
				(15, 1),
				(15, 3),
				(15, 4),
				(15, 6),
				(15, 7),
				(15, 8),
				(15, 10),
				(15, 14),
				(15, 15),
				(15, 18),
				(15, 19),
				(15, 20),
				(15, 22),
				(16, 0),
				(16, 3),
				(16, 7),
				(16, 9),
				(16, 11),
				(16, 12),
				(16, 13),
				(16, 17),
				(16, 18),
				(16, 20),
				(16, 22),
				(16, 24),
				(17, 4),
				(17, 6),
				(17, 7),
				(17, 8),
				(17, 10),
				(17, 13),
				(17, 14),
				(17, 15),
				(17, 16),
				(17, 17),
				(17, 20),
				(17, 21),
				(17, 22),
				(17, 23),
				(17, 24),
				(18, 3),
				(18, 4),
				(18, 6),
				(18, 9),
				(18, 11),
				(18, 13),
				(18, 16),
				(18, 17),
				(18, 18),
				(18, 20),
				(18, 21),
				(18, 23),
				(18, 24),
				(19, 0),
				(19, 1),
				(19, 2),
				(19, 3),
				(19, 8),
				(19, 9),
				(19, 10),
				(19, 11),
				(19, 17),
				(19, 19),
				(19, 20),
				(19, 24),
				(20, 6),
				(20, 8),
				(20, 9),
				(20, 11),
				(20, 12),
				(20, 16),
				(20, 18),
				(20, 19),
				(20, 21),
				(20, 23),
				(20, 24),
				(21, 1),
				(21, 6),
				(21, 7),
				(21, 8),
				(21, 14),
				(21, 16),
				(21, 17),
				(21, 21),
				(21, 22),
				(21, 23),
				(22, 4),
				(22, 6),
				(22, 7),
				(22, 8),
				(22, 10),
				(22, 11),
				(22, 13),
				(22, 15),
				(22, 17),
				(22, 20),
				(22, 24),
				(23, 0),
				(23, 1),
				(23, 2),
				(23, 7),
				(23, 8),
				(23, 11),
				(23, 12),
				(23, 13),
				(23, 15),
				(23, 18),
				(23, 19),
				(23, 20),
				(23, 21),
				(24, 0),
				(24, 2),
				(24, 3),
				(24, 4),
				(24, 9),
				(24, 11),
				(24, 13),
				(24, 14),
				(24, 15),
				(24, 19),
				(24, 22),
				(24, 23),
				(24, 24),
				(9, 13),
				(23, 22),
				(7, 21),
				(15, 16),
				(2, 12),
				(2, 21),
				(24, 16),
				(12, 6),
				(21, 13),
				(23, 17),
				(10, 13),
				(22, 22),
				(6, 21),
				(6, 12),
				(7, 0),
				(8, 20),
				(3, 12),
				(15, 17),
				(1, 21),
				(14, 2),
				(6, 6),
				(13, 0),
				(23, 16),
				(22, 23),
				(11, 6),
				(13, 22),
				(20, 13),
				(12, 15),
				(24, 17),
				(18, 14),
				(9, 23),
				(13, 11),
				(22, 14),
				(3, 16),
				(10, 12),
				(5, 21),
				(5, 12),
				(7, 1),
				(7, 20),
				(16, 15),
				(4, 12),
				(1, 22),
				(15, 2),
				(5, 6),
				(14, 0),
				(22, 16),
				(23, 23),
				(11, 7),
				(19, 13),
				(12, 16),
				(24, 18),
				(19, 14),
				(10, 23),
				(14, 11),
				(23, 14),
				(2, 16),
				(9, 12),
				(5, 22),
				(5, 13),
				(7, 2),
				(6, 20),
				(16, 14),
				(4, 13),
				(14, 18),
				(0, 22),
				(16, 2),
				(5, 7),
				(15, 0),
				(23, 24),
				(11, 8),
				(14, 21),
				(19, 12),
				(13, 16),
				(20, 14),
				(10, 24),
				(15, 11),
				(2, 15),
				(6, 22),
				(6, 13),
				(7, 3),
				(6, 19),
				(3, 13),
				(0, 23),
				(17, 2),
				(6, 7),
				(10, 8),
				(15, 21),
				(18, 12),
				(14, 16),
				(24, 20),
				(20, 15),
				(11, 24),
				(7, 22),
				(7, 13),
				(6, 3),
				(6, 18),
				(2, 13),
				(18, 2),
				(7, 7),
				(10, 9),
				(16, 21),
				(17, 12),
				(24, 21),
				(21, 15),
				(12, 24),
				(4, 15),
				(8, 13),
				(5, 3),
				(7, 18),
				(18, 15),
				(1, 13),
				(18, 1),
				(8, 7),
				(11, 9),
				(17, 11),
				(12, 23),
				(14, 9),
				(5, 15),
				(8, 11),
				(5, 2),
				(19, 15),
				(1, 12),
				(17, 1),
				(9, 7),
				(13, 9),
				(9, 14),
				(5, 1),
				(8, 17),
				(19, 16),
				(1, 11),
				(16, 1),
				(12, 0),
				(18, 22),
				(13, 8),
				(6, 14),
				(9, 10),
				(9, 22),
				(5, 0),
				(8, 16),
				(2, 11),
				(14, 14),
				(9, 9),
				(20, 17),
				(19, 22),
				(14, 8),
				(24, 12),
				(10, 22),
				(4, 0),
				(2, 10),
				(14, 13),
				(17, 0),
				(8, 9),
				(20, 22),
				(15, 13),
				(16, 16),
				(7, 15),
				(3, 0),
				(6, 16),
				(1, 23),
				(18, 0),
				(11, 2),
				(21, 18),
				(22, 12),
				(11, 16),
				(2, 0),
				(6, 15),
				(1, 9),
				(12, 13),
				(22, 18),
				(20, 20),
				(21, 12),
				(11, 17),
				(0, 9),
				(12, 12),
				(20, 0),
				(22, 19),
				(22, 21),
				(21, 20),
				(21, 11),
				(21, 24),
				(5, 14),
				(12, 11),
				(21, 0),
				(21, 19),
				(21, 19),
				(21, 10),
			],
			"wallpaper": "wallpape.jpg",
		},
		"sheep": {
			"units": {
				"physical": {
					"sheep0": True,
					"sheep1": True,
					"sheep10": True,
					"sheep11": True,
					"sheep12": True,
					"sheep13": True,
					"sheep14": True,
					"sheep15": True,
					"sheep16": True,
					"sheep17": True,
					"sheep18": True,
					"sheep19": True,
					"sheep2": True,
					"sheep20": True,
					"sheep21": True,
					"sheep22": True,
					"sheep23": True,
					"sheep24": True,
					"sheep3": True,
					"sheep4": True,
					"sheep5": True,
					"sheep6": True,
					"sheep7": True,
					"sheep8": True,
					"sheep9": True,
				}
			}
		},
		"wolf": {
			"units": {
				"physical": {
					"wolf0": True,
					"wolf1": True,
					"wolf2": True,
					"wolf3": True,
					"wolf4": True,
					"wolf5": True,
					"wolf6": True,
					"wolf7": True,
					"wolf8": True,
					"wolf9": True,
				}
			}
		},
	},
	"node_val": {
		"physical": {
			(0, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (0, 1),
			},
			(0, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (0, 2),
			},
			(0, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.1225,
				"bare": True,
				"name": (0, 3),
			},
			(0, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (0, 4),
			},
			(0, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (0, 5),
			},
			(0, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.245,
				"bare": True,
				"name": (0, 6),
			},
			(0, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (0, 7),
			},
			(0, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (0, 8),
			},
			(0, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.3675,
				"bare": True,
				"name": (0, 9),
			},
			(0, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (0, 10),
			},
			(0, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (0, 11),
			},
			(0, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.49,
				"bare": True,
				"name": (0, 12),
			},
			(0, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (0, 13),
			},
			(0, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (0, 14),
			},
			(0, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.6125,
				"bare": False,
				"name": (0, 15),
			},
			(0, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (0, 16),
			},
			(0, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (0, 17),
			},
			(0, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.735,
				"bare": False,
				"name": (0, 18),
			},
			(0, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.0,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (0, 19),
			},
			(0, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (0, 20),
			},
			(0, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (0, 21),
			},
			(0, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (0, 22),
			},
			(0, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (0, 23),
			},
			(0, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.0,
				"_y": 0.98,
				"bare": True,
				"name": (0, 24),
			},
			(1, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.0,
				"bare": True,
				"name": (1, 0),
			},
			(1, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (1, 1),
			},
			(1, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (1, 2),
			},
			(1, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.1225,
				"bare": False,
				"name": (1, 3),
			},
			(1, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (1, 4),
			},
			(1, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (1, 5),
			},
			(1, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.245,
				"bare": False,
				"name": (1, 6),
			},
			(1, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (1, 7),
			},
			(1, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (1, 8),
			},
			(1, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.3675,
				"bare": True,
				"name": (1, 9),
			},
			(1, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (1, 10),
			},
			(1, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (1, 11),
			},
			(1, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.49,
				"bare": True,
				"name": (1, 12),
			},
			(1, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (1, 13),
			},
			(1, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (1, 14),
			},
			(1, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.6125,
				"bare": True,
				"name": (1, 15),
			},
			(1, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (1, 16),
			},
			(1, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (1, 17),
			},
			(1, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.735,
				"bare": True,
				"name": (1, 18),
			},
			(1, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.04083333333333333,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (1, 19),
			},
			(1, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (1, 20),
			},
			(1, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (1, 21),
			},
			(1, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (1, 22),
			},
			(1, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (1, 23),
			},
			(1, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.04083333333333333,
				"_y": 0.98,
				"bare": True,
				"name": (1, 24),
			},
			(2, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.0,
				"bare": True,
				"name": (2, 0),
			},
			(2, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (2, 1),
			},
			(2, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (2, 2),
			},
			(2, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.1225,
				"bare": False,
				"name": (2, 3),
			},
			(2, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (2, 4),
			},
			(2, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (2, 5),
			},
			(2, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.245,
				"bare": True,
				"name": (2, 6),
			},
			(2, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.08166666666666667,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (2, 7),
			},
			(2, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (2, 8),
			},
			(2, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.3675,
				"bare": True,
				"name": (2, 9),
			},
			(2, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (2, 10),
			},
			(2, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (2, 11),
			},
			(2, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.49,
				"bare": True,
				"name": (2, 12),
			},
			(2, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (2, 13),
			},
			(2, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (2, 14),
			},
			(2, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.6125,
				"bare": True,
				"name": (2, 15),
			},
			(2, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (2, 16),
			},
			(2, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (2, 17),
			},
			(2, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.735,
				"bare": True,
				"name": (2, 18),
			},
			(2, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (2, 19),
			},
			(2, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (2, 20),
			},
			(2, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (2, 21),
			},
			(2, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (2, 22),
			},
			(2, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (2, 23),
			},
			(2, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.08166666666666667,
				"_y": 0.98,
				"bare": True,
				"name": (2, 24),
			},
			(3, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.0,
				"bare": True,
				"name": (3, 0),
			},
			(3, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (3, 1),
			},
			(3, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (3, 2),
			},
			(3, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.1225,
				"bare": False,
				"name": (3, 3),
			},
			(3, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (3, 4),
			},
			(3, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (3, 5),
			},
			(3, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.245,
				"bare": False,
				"name": (3, 6),
			},
			(3, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (3, 7),
			},
			(3, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (3, 8),
			},
			(3, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.3675,
				"bare": True,
				"name": (3, 9),
			},
			(3, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (3, 10),
			},
			(3, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (3, 11),
			},
			(3, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.49,
				"bare": True,
				"name": (3, 12),
			},
			(3, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (3, 13),
			},
			(3, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (3, 14),
			},
			(3, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.6125,
				"bare": True,
				"name": (3, 15),
			},
			(3, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (3, 16),
			},
			(3, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (3, 17),
			},
			(3, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.735,
				"bare": False,
				"name": (3, 18),
			},
			(3, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (3, 19),
			},
			(3, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (3, 20),
			},
			(3, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (3, 21),
			},
			(3, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (3, 22),
			},
			(3, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.1225,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (3, 23),
			},
			(3, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.1225,
				"_y": 0.98,
				"bare": True,
				"name": (3, 24),
			},
			(4, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.0,
				"bare": True,
				"name": (4, 0),
			},
			(4, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (4, 1),
			},
			(4, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (4, 2),
			},
			(4, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.1225,
				"bare": True,
				"name": (4, 3),
			},
			(4, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (4, 4),
			},
			(4, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (4, 5),
			},
			(4, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.245,
				"bare": True,
				"name": (4, 6),
			},
			(4, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (4, 7),
			},
			(4, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (4, 8),
			},
			(4, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.3675,
				"bare": True,
				"name": (4, 9),
			},
			(4, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (4, 10),
			},
			(4, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.44916666666666666,
				"bare": False,
				"name": (4, 11),
			},
			(4, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.49,
				"bare": True,
				"name": (4, 12),
			},
			(4, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (4, 13),
			},
			(4, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (4, 14),
			},
			(4, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.6125,
				"bare": True,
				"name": (4, 15),
			},
			(4, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (4, 16),
			},
			(4, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (4, 17),
			},
			(4, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.735,
				"bare": True,
				"name": (4, 18),
			},
			(4, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (4, 19),
			},
			(4, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.8166666666666667,
				"bare": False,
				"name": (4, 20),
			},
			(4, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.16333333333333333,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (4, 21),
			},
			(4, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (4, 22),
			},
			(4, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (4, 23),
			},
			(4, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.16333333333333333,
				"_y": 0.98,
				"bare": False,
				"name": (4, 24),
			},
			(5, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.0,
				"bare": True,
				"name": (5, 0),
			},
			(5, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (5, 1),
			},
			(5, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (5, 2),
			},
			(5, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.1225,
				"bare": True,
				"name": (5, 3),
			},
			(5, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (5, 4),
			},
			(5, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (5, 5),
			},
			(5, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.245,
				"bare": True,
				"name": (5, 6),
			},
			(5, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (5, 7),
			},
			(5, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (5, 8),
			},
			(5, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.3675,
				"bare": True,
				"name": (5, 9),
			},
			(5, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (5, 10),
			},
			(5, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (5, 11),
			},
			(5, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.49,
				"bare": True,
				"name": (5, 12),
			},
			(5, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (5, 13),
			},
			(5, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (5, 14),
			},
			(5, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.6125,
				"bare": True,
				"name": (5, 15),
			},
			(5, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (5, 16),
			},
			(5, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.6941666666666666,
				"bare": False,
				"name": (5, 17),
			},
			(5, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.735,
				"bare": True,
				"name": (5, 18),
			},
			(5, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (5, 19),
			},
			(5, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (5, 20),
			},
			(5, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (5, 21),
			},
			(5, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (5, 22),
			},
			(5, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.20416666666666666,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (5, 23),
			},
			(5, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.20416666666666666,
				"_y": 0.98,
				"bare": True,
				"name": (5, 24),
			},
			(6, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.0,
				"bare": True,
				"name": (6, 0),
			},
			(6, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (6, 1),
			},
			(6, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (6, 2),
			},
			(6, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.1225,
				"bare": True,
				"name": (6, 3),
			},
			(6, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (6, 4),
			},
			(6, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (6, 5),
			},
			(6, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.245,
				"bare": True,
				"name": (6, 6),
			},
			(6, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (6, 7),
			},
			(6, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (6, 8),
			},
			(6, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.3675,
				"bare": True,
				"name": (6, 9),
			},
			(6, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (6, 10),
			},
			(6, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (6, 11),
			},
			(6, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.49,
				"bare": True,
				"name": (6, 12),
			},
			(6, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (6, 13),
			},
			(6, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (6, 14),
			},
			(6, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.6125,
				"bare": True,
				"name": (6, 15),
			},
			(6, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (6, 16),
			},
			(6, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (6, 17),
			},
			(6, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.735,
				"bare": True,
				"name": (6, 18),
			},
			(6, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (6, 19),
			},
			(6, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (6, 20),
			},
			(6, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (6, 21),
			},
			(6, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (6, 22),
			},
			(6, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.245,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (6, 23),
			},
			(6, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.245,
				"_y": 0.98,
				"bare": False,
				"name": (6, 24),
			},
			(7, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.0,
				"bare": True,
				"name": (7, 0),
			},
			(7, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (7, 1),
			},
			(7, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (7, 2),
			},
			(7, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.1225,
				"bare": True,
				"name": (7, 3),
			},
			(7, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (7, 4),
			},
			(7, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.28583333333333333,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (7, 5),
			},
			(7, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.245,
				"bare": True,
				"name": (7, 6),
			},
			(7, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (7, 7),
			},
			(7, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.28583333333333333,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (7, 8),
			},
			(7, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.3675,
				"bare": True,
				"name": (7, 9),
			},
			(7, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (7, 10),
			},
			(7, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (7, 11),
			},
			(7, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.49,
				"bare": True,
				"name": (7, 12),
			},
			(7, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (7, 13),
			},
			(7, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (7, 14),
			},
			(7, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.6125,
				"bare": True,
				"name": (7, 15),
			},
			(7, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (7, 16),
			},
			(7, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (7, 17),
			},
			(7, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.735,
				"bare": True,
				"name": (7, 18),
			},
			(7, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (7, 19),
			},
			(7, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (7, 20),
			},
			(7, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (7, 21),
			},
			(7, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (7, 22),
			},
			(7, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (7, 23),
			},
			(7, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.28583333333333333,
				"_y": 0.98,
				"bare": True,
				"name": (7, 24),
			},
			(8, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.0,
				"bare": True,
				"name": (8, 0),
			},
			(8, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (8, 1),
			},
			(8, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (8, 2),
			},
			(8, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.1225,
				"bare": False,
				"name": (8, 3),
			},
			(8, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (8, 4),
			},
			(8, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (8, 5),
			},
			(8, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.245,
				"bare": True,
				"name": (8, 6),
			},
			(8, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (8, 7),
			},
			(8, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (8, 8),
			},
			(8, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.3675,
				"bare": True,
				"name": (8, 9),
			},
			(8, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (8, 10),
			},
			(8, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (8, 11),
			},
			(8, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.49,
				"bare": True,
				"name": (8, 12),
			},
			(8, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (8, 13),
			},
			(8, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.32666666666666666,
				"_y": 0.5716666666666667,
				"bare": False,
				"name": (8, 14),
			},
			(8, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.6125,
				"bare": True,
				"name": (8, 15),
			},
			(8, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (8, 16),
			},
			(8, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (8, 17),
			},
			(8, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.735,
				"bare": True,
				"name": (8, 18),
			},
			(8, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (8, 19),
			},
			(8, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (8, 20),
			},
			(8, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (8, 21),
			},
			(8, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (8, 22),
			},
			(8, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (8, 23),
			},
			(8, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.32666666666666666,
				"_y": 0.98,
				"bare": True,
				"name": (8, 24),
			},
			(9, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.0,
				"bare": True,
				"name": (9, 0),
			},
			(9, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (9, 1),
			},
			(9, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (9, 2),
			},
			(9, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.1225,
				"bare": False,
				"name": (9, 3),
			},
			(9, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (9, 4),
			},
			(9, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (9, 5),
			},
			(9, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.245,
				"bare": True,
				"name": (9, 6),
			},
			(9, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (9, 7),
			},
			(9, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (9, 8),
			},
			(9, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.3675,
				"bare": True,
				"name": (9, 9),
			},
			(9, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (9, 10),
			},
			(9, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (9, 11),
			},
			(9, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.49,
				"bare": True,
				"name": (9, 12),
			},
			(9, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (9, 13),
			},
			(9, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (9, 14),
			},
			(9, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.6125,
				"bare": True,
				"name": (9, 15),
			},
			(9, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (9, 16),
			},
			(9, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (9, 17),
			},
			(9, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.735,
				"bare": True,
				"name": (9, 18),
			},
			(9, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (9, 19),
			},
			(9, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (9, 20),
			},
			(9, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (9, 21),
			},
			(9, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (9, 22),
			},
			(9, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.3675,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (9, 23),
			},
			(9, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.3675,
				"_y": 0.98,
				"bare": False,
				"name": (9, 24),
			},
			(10, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.0,
				"bare": True,
				"name": (10, 0),
			},
			(10, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (10, 1),
			},
			(10, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (10, 2),
			},
			(10, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.1225,
				"bare": True,
				"name": (10, 3),
			},
			(10, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (10, 4),
			},
			(10, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (10, 5),
			},
			(10, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.245,
				"bare": True,
				"name": (10, 6),
			},
			(10, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (10, 7),
			},
			(10, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (10, 8),
			},
			(10, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.3675,
				"bare": True,
				"name": (10, 9),
			},
			(10, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (10, 10),
			},
			(10, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (10, 11),
			},
			(10, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.49,
				"bare": True,
				"name": (10, 12),
			},
			(10, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (10, 13),
			},
			(10, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (10, 14),
			},
			(10, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.6125,
				"bare": True,
				"name": (10, 15),
			},
			(10, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (10, 16),
			},
			(10, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (10, 17),
			},
			(10, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.4083333333333333,
				"_y": 0.735,
				"bare": False,
				"name": (10, 18),
			},
			(10, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (10, 19),
			},
			(10, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (10, 20),
			},
			(10, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (10, 21),
			},
			(10, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (10, 22),
			},
			(10, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (10, 23),
			},
			(10, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.4083333333333333,
				"_y": 0.98,
				"bare": True,
				"name": (10, 24),
			},
			(11, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.0,
				"bare": True,
				"name": (11, 0),
			},
			(11, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (11, 1),
			},
			(11, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (11, 2),
			},
			(11, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.1225,
				"bare": True,
				"name": (11, 3),
			},
			(11, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (11, 4),
			},
			(11, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (11, 5),
			},
			(11, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.245,
				"bare": True,
				"name": (11, 6),
			},
			(11, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (11, 7),
			},
			(11, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (11, 8),
			},
			(11, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.3675,
				"bare": True,
				"name": (11, 9),
			},
			(11, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (11, 10),
			},
			(11, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (11, 11),
			},
			(11, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.49,
				"bare": True,
				"name": (11, 12),
			},
			(11, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (11, 13),
			},
			(11, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (11, 14),
			},
			(11, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.6125,
				"bare": True,
				"name": (11, 15),
			},
			(11, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (11, 16),
			},
			(11, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (11, 17),
			},
			(11, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.735,
				"bare": True,
				"name": (11, 18),
			},
			(11, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.44916666666666666,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (11, 19),
			},
			(11, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (11, 20),
			},
			(11, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.44916666666666666,
				"_y": 0.8574999999999999,
				"bare": False,
				"name": (11, 21),
			},
			(11, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (11, 22),
			},
			(11, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (11, 23),
			},
			(11, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.44916666666666666,
				"_y": 0.98,
				"bare": True,
				"name": (11, 24),
			},
			(12, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.0,
				"bare": True,
				"name": (12, 0),
			},
			(12, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (12, 1),
			},
			(12, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (12, 2),
			},
			(12, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.1225,
				"bare": True,
				"name": (12, 3),
			},
			(12, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (12, 4),
			},
			(12, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (12, 5),
			},
			(12, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.245,
				"bare": True,
				"name": (12, 6),
			},
			(12, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (12, 7),
			},
			(12, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (12, 8),
			},
			(12, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.3675,
				"bare": True,
				"name": (12, 9),
			},
			(12, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (12, 10),
			},
			(12, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (12, 11),
			},
			(12, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.49,
				"bare": True,
				"name": (12, 12),
			},
			(12, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (12, 13),
			},
			(12, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (12, 14),
			},
			(12, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.6125,
				"bare": True,
				"name": (12, 15),
			},
			(12, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (12, 16),
			},
			(12, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (12, 17),
			},
			(12, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.49,
				"_y": 0.735,
				"bare": False,
				"name": (12, 18),
			},
			(12, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (12, 19),
			},
			(12, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (12, 20),
			},
			(12, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (12, 21),
			},
			(12, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (12, 22),
			},
			(12, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (12, 23),
			},
			(12, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.49,
				"_y": 0.98,
				"bare": True,
				"name": (12, 24),
			},
			(13, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.0,
				"bare": True,
				"name": (13, 0),
			},
			(13, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (13, 1),
			},
			(13, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (13, 2),
			},
			(13, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.1225,
				"bare": False,
				"name": (13, 3),
			},
			(13, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (13, 4),
			},
			(13, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (13, 5),
			},
			(13, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.245,
				"bare": True,
				"name": (13, 6),
			},
			(13, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (13, 7),
			},
			(13, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (13, 8),
			},
			(13, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.3675,
				"bare": True,
				"name": (13, 9),
			},
			(13, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (13, 10),
			},
			(13, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (13, 11),
			},
			(13, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.49,
				"bare": True,
				"name": (13, 12),
			},
			(13, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (13, 13),
			},
			(13, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (13, 14),
			},
			(13, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.6125,
				"bare": True,
				"name": (13, 15),
			},
			(13, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (13, 16),
			},
			(13, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (13, 17),
			},
			(13, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.735,
				"bare": True,
				"name": (13, 18),
			},
			(13, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (13, 19),
			},
			(13, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (13, 20),
			},
			(13, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5308333333333333,
				"_y": 0.8574999999999999,
				"bare": False,
				"name": (13, 21),
			},
			(13, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (13, 22),
			},
			(13, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (13, 23),
			},
			(13, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5308333333333333,
				"_y": 0.98,
				"bare": True,
				"name": (13, 24),
			},
			(14, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.0,
				"bare": True,
				"name": (14, 0),
			},
			(14, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (14, 1),
			},
			(14, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (14, 2),
			},
			(14, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.1225,
				"bare": False,
				"name": (14, 3),
			},
			(14, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (14, 4),
			},
			(14, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.20416666666666666,
				"bare": True,
				"name": (14, 5),
			},
			(14, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.245,
				"bare": False,
				"name": (14, 6),
			},
			(14, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (14, 7),
			},
			(14, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (14, 8),
			},
			(14, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.3675,
				"bare": True,
				"name": (14, 9),
			},
			(14, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (14, 10),
			},
			(14, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (14, 11),
			},
			(14, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.49,
				"bare": True,
				"name": (14, 12),
			},
			(14, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (14, 13),
			},
			(14, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (14, 14),
			},
			(14, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.6125,
				"bare": True,
				"name": (14, 15),
			},
			(14, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (14, 16),
			},
			(14, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (14, 17),
			},
			(14, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.735,
				"bare": True,
				"name": (14, 18),
			},
			(14, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (14, 19),
			},
			(14, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.8166666666666667,
				"bare": False,
				"name": (14, 20),
			},
			(14, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (14, 21),
			},
			(14, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.5716666666666667,
				"_y": 0.8983333333333333,
				"bare": False,
				"name": (14, 22),
			},
			(14, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (14, 23),
			},
			(14, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.5716666666666667,
				"_y": 0.98,
				"bare": True,
				"name": (14, 24),
			},
			(15, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.0,
				"bare": True,
				"name": (15, 0),
			},
			(15, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (15, 1),
			},
			(15, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (15, 2),
			},
			(15, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.1225,
				"bare": True,
				"name": (15, 3),
			},
			(15, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (15, 4),
			},
			(15, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (15, 5),
			},
			(15, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.245,
				"bare": True,
				"name": (15, 6),
			},
			(15, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (15, 7),
			},
			(15, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (15, 8),
			},
			(15, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.3675,
				"bare": False,
				"name": (15, 9),
			},
			(15, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (15, 10),
			},
			(15, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (15, 11),
			},
			(15, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.49,
				"bare": False,
				"name": (15, 12),
			},
			(15, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (15, 13),
			},
			(15, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (15, 14),
			},
			(15, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.6125,
				"bare": True,
				"name": (15, 15),
			},
			(15, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (15, 16),
			},
			(15, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (15, 17),
			},
			(15, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.735,
				"bare": True,
				"name": (15, 18),
			},
			(15, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (15, 19),
			},
			(15, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (15, 20),
			},
			(15, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (15, 21),
			},
			(15, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6125,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (15, 22),
			},
			(15, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (15, 23),
			},
			(15, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6125,
				"_y": 0.98,
				"bare": False,
				"name": (15, 24),
			},
			(16, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.0,
				"bare": True,
				"name": (16, 0),
			},
			(16, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (16, 1),
			},
			(16, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (16, 2),
			},
			(16, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.1225,
				"bare": True,
				"name": (16, 3),
			},
			(16, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (16, 4),
			},
			(16, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (16, 5),
			},
			(16, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.245,
				"bare": False,
				"name": (16, 6),
			},
			(16, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (16, 7),
			},
			(16, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (16, 8),
			},
			(16, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.3675,
				"bare": True,
				"name": (16, 9),
			},
			(16, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (16, 10),
			},
			(16, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (16, 11),
			},
			(16, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.49,
				"bare": True,
				"name": (16, 12),
			},
			(16, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (16, 13),
			},
			(16, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (16, 14),
			},
			(16, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.6125,
				"bare": True,
				"name": (16, 15),
			},
			(16, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (16, 16),
			},
			(16, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (16, 17),
			},
			(16, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.735,
				"bare": True,
				"name": (16, 18),
			},
			(16, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (16, 19),
			},
			(16, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (16, 20),
			},
			(16, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (16, 21),
			},
			(16, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (16, 22),
			},
			(16, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6533333333333333,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (16, 23),
			},
			(16, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6533333333333333,
				"_y": 0.98,
				"bare": True,
				"name": (16, 24),
			},
			(17, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.0,
				"bare": True,
				"name": (17, 0),
			},
			(17, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (17, 1),
			},
			(17, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (17, 2),
			},
			(17, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6941666666666666,
				"_y": 0.1225,
				"bare": False,
				"name": (17, 3),
			},
			(17, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (17, 4),
			},
			(17, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6941666666666666,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (17, 5),
			},
			(17, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.245,
				"bare": True,
				"name": (17, 6),
			},
			(17, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (17, 7),
			},
			(17, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (17, 8),
			},
			(17, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6941666666666666,
				"_y": 0.3675,
				"bare": False,
				"name": (17, 9),
			},
			(17, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (17, 10),
			},
			(17, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (17, 11),
			},
			(17, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.49,
				"bare": True,
				"name": (17, 12),
			},
			(17, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (17, 13),
			},
			(17, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (17, 14),
			},
			(17, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.6125,
				"bare": True,
				"name": (17, 15),
			},
			(17, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (17, 16),
			},
			(17, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (17, 17),
			},
			(17, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6941666666666666,
				"_y": 0.735,
				"bare": False,
				"name": (17, 18),
			},
			(17, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.6941666666666666,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (17, 19),
			},
			(17, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (17, 20),
			},
			(17, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (17, 21),
			},
			(17, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (17, 22),
			},
			(17, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (17, 23),
			},
			(17, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.6941666666666666,
				"_y": 0.98,
				"bare": True,
				"name": (17, 24),
			},
			(18, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.0,
				"bare": True,
				"name": (18, 0),
			},
			(18, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (18, 1),
			},
			(18, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (18, 2),
			},
			(18, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.1225,
				"bare": True,
				"name": (18, 3),
			},
			(18, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (18, 4),
			},
			(18, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (18, 5),
			},
			(18, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.245,
				"bare": True,
				"name": (18, 6),
			},
			(18, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (18, 7),
			},
			(18, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (18, 8),
			},
			(18, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.3675,
				"bare": True,
				"name": (18, 9),
			},
			(18, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (18, 10),
			},
			(18, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (18, 11),
			},
			(18, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.49,
				"bare": True,
				"name": (18, 12),
			},
			(18, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (18, 13),
			},
			(18, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (18, 14),
			},
			(18, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.6125,
				"bare": True,
				"name": (18, 15),
			},
			(18, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (18, 16),
			},
			(18, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (18, 17),
			},
			(18, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.735,
				"bare": True,
				"name": (18, 18),
			},
			(18, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.735,
				"_y": 0.7758333333333334,
				"bare": False,
				"name": (18, 19),
			},
			(18, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (18, 20),
			},
			(18, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (18, 21),
			},
			(18, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (18, 22),
			},
			(18, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (18, 23),
			},
			(18, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.735,
				"_y": 0.98,
				"bare": True,
				"name": (18, 24),
			},
			(19, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.0,
				"bare": True,
				"name": (19, 0),
			},
			(19, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (19, 1),
			},
			(19, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (19, 2),
			},
			(19, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.1225,
				"bare": True,
				"name": (19, 3),
			},
			(19, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (19, 4),
			},
			(19, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (19, 5),
			},
			(19, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.245,
				"bare": False,
				"name": (19, 6),
			},
			(19, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (19, 7),
			},
			(19, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (19, 8),
			},
			(19, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.3675,
				"bare": True,
				"name": (19, 9),
			},
			(19, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (19, 10),
			},
			(19, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (19, 11),
			},
			(19, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.49,
				"bare": True,
				"name": (19, 12),
			},
			(19, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (19, 13),
			},
			(19, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (19, 14),
			},
			(19, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.6125,
				"bare": True,
				"name": (19, 15),
			},
			(19, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (19, 16),
			},
			(19, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (19, 17),
			},
			(19, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.735,
				"bare": False,
				"name": (19, 18),
			},
			(19, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (19, 19),
			},
			(19, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (19, 20),
			},
			(19, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.8574999999999999,
				"bare": False,
				"name": (19, 21),
			},
			(19, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (19, 22),
			},
			(19, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.7758333333333334,
				"_y": 0.9391666666666667,
				"bare": False,
				"name": (19, 23),
			},
			(19, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.7758333333333334,
				"_y": 0.98,
				"bare": True,
				"name": (19, 24),
			},
			(20, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.0,
				"bare": True,
				"name": (20, 0),
			},
			(20, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8166666666666667,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (20, 1),
			},
			(20, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8166666666666667,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (20, 2),
			},
			(20, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8166666666666667,
				"_y": 0.1225,
				"bare": False,
				"name": (20, 3),
			},
			(20, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8166666666666667,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (20, 4),
			},
			(20, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8166666666666667,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (20, 5),
			},
			(20, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.245,
				"bare": True,
				"name": (20, 6),
			},
			(20, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8166666666666667,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (20, 7),
			},
			(20, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (20, 8),
			},
			(20, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.3675,
				"bare": True,
				"name": (20, 9),
			},
			(20, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8166666666666667,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (20, 10),
			},
			(20, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (20, 11),
			},
			(20, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.49,
				"bare": True,
				"name": (20, 12),
			},
			(20, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (20, 13),
			},
			(20, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (20, 14),
			},
			(20, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.6125,
				"bare": True,
				"name": (20, 15),
			},
			(20, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (20, 16),
			},
			(20, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (20, 17),
			},
			(20, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.735,
				"bare": True,
				"name": (20, 18),
			},
			(20, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (20, 19),
			},
			(20, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (20, 20),
			},
			(20, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (20, 21),
			},
			(20, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (20, 22),
			},
			(20, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (20, 23),
			},
			(20, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"_y": 0.98,
				"bare": True,
				"name": (20, 24),
			},
			(21, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.0,
				"bare": True,
				"name": (21, 0),
			},
			(21, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (21, 1),
			},
			(21, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8574999999999999,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (21, 2),
			},
			(21, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8574999999999999,
				"_y": 0.1225,
				"bare": False,
				"name": (21, 3),
			},
			(21, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8574999999999999,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (21, 4),
			},
			(21, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8574999999999999,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (21, 5),
			},
			(21, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.245,
				"bare": True,
				"name": (21, 6),
			},
			(21, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (21, 7),
			},
			(21, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (21, 8),
			},
			(21, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8574999999999999,
				"_y": 0.3675,
				"bare": False,
				"name": (21, 9),
			},
			(21, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (21, 10),
			},
			(21, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (21, 11),
			},
			(21, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.49,
				"bare": True,
				"name": (21, 12),
			},
			(21, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (21, 13),
			},
			(21, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (21, 14),
			},
			(21, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.6125,
				"bare": True,
				"name": (21, 15),
			},
			(21, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (21, 16),
			},
			(21, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (21, 17),
			},
			(21, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.735,
				"bare": True,
				"name": (21, 18),
			},
			(21, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (21, 19),
			},
			(21, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (21, 20),
			},
			(21, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (21, 21),
			},
			(21, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (21, 22),
			},
			(21, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (21, 23),
			},
			(21, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"_y": 0.98,
				"bare": True,
				"name": (21, 24),
			},
			(22, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8983333333333333,
				"_y": 0.0,
				"bare": False,
				"name": (22, 0),
			},
			(22, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8983333333333333,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (22, 1),
			},
			(22, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8983333333333333,
				"_y": 0.08166666666666667,
				"bare": False,
				"name": (22, 2),
			},
			(22, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8983333333333333,
				"_y": 0.1225,
				"bare": False,
				"name": (22, 3),
			},
			(22, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (22, 4),
			},
			(22, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8983333333333333,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (22, 5),
			},
			(22, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.245,
				"bare": True,
				"name": (22, 6),
			},
			(22, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (22, 7),
			},
			(22, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (22, 8),
			},
			(22, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8983333333333333,
				"_y": 0.3675,
				"bare": False,
				"name": (22, 9),
			},
			(22, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.4083333333333333,
				"bare": True,
				"name": (22, 10),
			},
			(22, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (22, 11),
			},
			(22, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.49,
				"bare": True,
				"name": (22, 12),
			},
			(22, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (22, 13),
			},
			(22, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (22, 14),
			},
			(22, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.6125,
				"bare": True,
				"name": (22, 15),
			},
			(22, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (22, 16),
			},
			(22, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (22, 17),
			},
			(22, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.735,
				"bare": True,
				"name": (22, 18),
			},
			(22, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (22, 19),
			},
			(22, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (22, 20),
			},
			(22, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (22, 21),
			},
			(22, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (22, 22),
			},
			(22, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (22, 23),
			},
			(22, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"_y": 0.98,
				"bare": True,
				"name": (22, 24),
			},
			(23, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.0,
				"bare": True,
				"name": (23, 0),
			},
			(23, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.04083333333333333,
				"bare": True,
				"name": (23, 1),
			},
			(23, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (23, 2),
			},
			(23, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.9391666666666667,
				"_y": 0.1225,
				"bare": False,
				"name": (23, 3),
			},
			(23, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.9391666666666667,
				"_y": 0.16333333333333333,
				"bare": False,
				"name": (23, 4),
			},
			(23, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.9391666666666667,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (23, 5),
			},
			(23, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.9391666666666667,
				"_y": 0.245,
				"bare": False,
				"name": (23, 6),
			},
			(23, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.28583333333333333,
				"bare": True,
				"name": (23, 7),
			},
			(23, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.32666666666666666,
				"bare": True,
				"name": (23, 8),
			},
			(23, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.9391666666666667,
				"_y": 0.3675,
				"bare": False,
				"name": (23, 9),
			},
			(23, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.9391666666666667,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (23, 10),
			},
			(23, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (23, 11),
			},
			(23, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.49,
				"bare": True,
				"name": (23, 12),
			},
			(23, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (23, 13),
			},
			(23, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (23, 14),
			},
			(23, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.6125,
				"bare": True,
				"name": (23, 15),
			},
			(23, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (23, 16),
			},
			(23, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (23, 17),
			},
			(23, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.735,
				"bare": True,
				"name": (23, 18),
			},
			(23, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (23, 19),
			},
			(23, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (23, 20),
			},
			(23, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (23, 21),
			},
			(23, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (23, 22),
			},
			(23, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (23, 23),
			},
			(23, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"_y": 0.98,
				"bare": True,
				"name": (23, 24),
			},
			(24, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.0,
				"bare": True,
				"name": (24, 0),
			},
			(24, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.04083333333333333,
				"bare": False,
				"name": (24, 1),
			},
			(24, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.08166666666666667,
				"bare": True,
				"name": (24, 2),
			},
			(24, 3): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.1225,
				"bare": True,
				"name": (24, 3),
			},
			(24, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.16333333333333333,
				"bare": True,
				"name": (24, 4),
			},
			(24, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.20416666666666666,
				"bare": False,
				"name": (24, 5),
			},
			(24, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.245,
				"bare": False,
				"name": (24, 6),
			},
			(24, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.28583333333333333,
				"bare": False,
				"name": (24, 7),
			},
			(24, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.32666666666666666,
				"bare": False,
				"name": (24, 8),
			},
			(24, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.3675,
				"bare": True,
				"name": (24, 9),
			},
			(24, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.98,
				"_y": 0.4083333333333333,
				"bare": False,
				"name": (24, 10),
			},
			(24, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.44916666666666666,
				"bare": True,
				"name": (24, 11),
			},
			(24, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.49,
				"bare": True,
				"name": (24, 12),
			},
			(24, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.5308333333333333,
				"bare": True,
				"name": (24, 13),
			},
			(24, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.5716666666666667,
				"bare": True,
				"name": (24, 14),
			},
			(24, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.6125,
				"bare": True,
				"name": (24, 15),
			},
			(24, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.6533333333333333,
				"bare": True,
				"name": (24, 16),
			},
			(24, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.6941666666666666,
				"bare": True,
				"name": (24, 17),
			},
			(24, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.735,
				"bare": True,
				"name": (24, 18),
			},
			(24, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.7758333333333334,
				"bare": True,
				"name": (24, 19),
			},
			(24, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.8166666666666667,
				"bare": True,
				"name": (24, 20),
			},
			(24, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.8574999999999999,
				"bare": True,
				"name": (24, 21),
			},
			(24, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.8983333333333333,
				"bare": True,
				"name": (24, 22),
			},
			(24, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.9391666666666667,
				"bare": True,
				"name": (24, 23),
			},
			(24, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.98,
				"_y": 0.98,
				"bare": True,
				"name": (24, 24),
			},
			"wolf0": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (22, 5),
				"name": "wolf0",
			},
			"wolf1": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (8, 14),
				"name": "wolf1",
			},
			"wolf2": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (23, 2),
				"name": "wolf2",
			},
			"wolf3": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (22, 24),
				"name": "wolf3",
			},
			"wolf4": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (24, 18),
				"name": "wolf4",
			},
			"wolf5": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (15, 9),
				"name": "wolf5",
			},
			"wolf6": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (8, 3),
				"name": "wolf6",
			},
			"wolf7": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (13, 15),
				"name": "wolf7",
			},
			"wolf8": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (3, 21),
				"name": "wolf8",
			},
			"wolf9": {
				"_image_paths": ["atlas://rltiles/dc-mon/war_dog"],
				"location": (15, 20),
				"name": "wolf9",
			},
			"sheep0": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (10, 13),
				"name": "sheep0",
			},
			"sheep1": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (21, 23),
				"name": "sheep1",
			},
			"sheep2": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (10, 1),
				"name": "sheep2",
			},
			"sheep3": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (13, 16),
				"name": "sheep3",
			},
			"sheep4": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (23, 18),
				"name": "sheep4",
			},
			"sheep5": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (22, 14),
				"name": "sheep5",
			},
			"sheep6": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (11, 21),
				"name": "sheep6",
			},
			"sheep7": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (12, 6),
				"name": "sheep7",
			},
			"sheep9": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (7, 16),
				"name": "sheep9",
			},
			"sheep10": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (6, 21),
				"name": "sheep10",
			},
			"sheep11": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (10, 18),
				"name": "sheep11",
			},
			"sheep12": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (0, 1),
				"name": "sheep12",
			},
			"sheep13": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (5, 15),
				"name": "sheep13",
			},
			"sheep14": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (21, 17),
				"name": "sheep14",
			},
			"sheep15": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (0, 7),
				"name": "sheep15",
			},
			"sheep16": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (13, 11),
				"name": "sheep16",
			},
			"sheep17": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (0, 24),
				"name": "sheep17",
			},
			"sheep18": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (22, 0),
				"name": "sheep18",
			},
			"sheep19": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (9, 13),
				"name": "sheep19",
			},
			"sheep20": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (20, 19),
				"name": "sheep20",
			},
			"sheep21": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (24, 21),
				"name": "sheep21",
			},
			"sheep22": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (10, 9),
				"name": "sheep22",
			},
			"sheep23": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (22, 19),
				"name": "sheep23",
			},
			"sheep24": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (15, 12),
				"name": "sheep24",
			},
			"sheep8": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (20, 10),
				"name": "sheep8",
			},
		}
	},
	"nodes": {
		"physical": {
			(0, 1): True,
			(0, 2): True,
			(0, 3): True,
			(0, 4): True,
			(0, 5): True,
			(0, 6): True,
			(0, 7): True,
			(0, 8): True,
			(0, 9): True,
			(0, 10): True,
			(0, 11): True,
			(0, 12): True,
			(0, 13): True,
			(0, 14): True,
			(0, 15): True,
			(0, 16): True,
			(0, 17): True,
			(0, 18): True,
			(0, 19): True,
			(0, 20): True,
			(0, 21): True,
			(0, 22): True,
			(0, 23): True,
			(0, 24): True,
			(1, 0): True,
			(1, 1): True,
			(1, 2): True,
			(1, 3): True,
			(1, 4): True,
			(1, 5): True,
			(1, 6): True,
			(1, 7): True,
			(1, 8): True,
			(1, 9): True,
			(1, 10): True,
			(1, 11): True,
			(1, 12): True,
			(1, 13): True,
			(1, 14): True,
			(1, 15): True,
			(1, 16): True,
			(1, 17): True,
			(1, 18): True,
			(1, 19): True,
			(1, 20): True,
			(1, 21): True,
			(1, 22): True,
			(1, 23): True,
			(1, 24): True,
			(2, 0): True,
			(2, 1): True,
			(2, 2): True,
			(2, 3): True,
			(2, 4): True,
			(2, 5): True,
			(2, 6): True,
			(2, 7): True,
			(2, 8): True,
			(2, 9): True,
			(2, 10): True,
			(2, 11): True,
			(2, 12): True,
			(2, 13): True,
			(2, 14): True,
			(2, 15): True,
			(2, 16): True,
			(2, 17): True,
			(2, 18): True,
			(2, 19): True,
			(2, 20): True,
			(2, 21): True,
			(2, 22): True,
			(2, 23): True,
			(2, 24): True,
			(3, 0): True,
			(3, 1): True,
			(3, 2): True,
			(3, 3): True,
			(3, 4): True,
			(3, 5): True,
			(3, 6): True,
			(3, 7): True,
			(3, 8): True,
			(3, 9): True,
			(3, 10): True,
			(3, 11): True,
			(3, 12): True,
			(3, 13): True,
			(3, 14): True,
			(3, 15): True,
			(3, 16): True,
			(3, 17): True,
			(3, 18): True,
			(3, 19): True,
			(3, 20): True,
			(3, 21): True,
			(3, 22): True,
			(3, 23): True,
			(3, 24): True,
			(4, 0): True,
			(4, 1): True,
			(4, 2): True,
			(4, 3): True,
			(4, 4): True,
			(4, 5): True,
			(4, 6): True,
			(4, 7): True,
			(4, 8): True,
			(4, 9): True,
			(4, 10): True,
			(4, 11): True,
			(4, 12): True,
			(4, 13): True,
			(4, 14): True,
			(4, 15): True,
			(4, 16): True,
			(4, 17): True,
			(4, 18): True,
			(4, 19): True,
			(4, 20): True,
			(4, 21): True,
			(4, 22): True,
			(4, 23): True,
			(4, 24): True,
			(5, 0): True,
			(5, 1): True,
			(5, 2): True,
			(5, 3): True,
			(5, 4): True,
			(5, 5): True,
			(5, 6): True,
			(5, 7): True,
			(5, 8): True,
			(5, 9): True,
			(5, 10): True,
			(5, 11): True,
			(5, 12): True,
			(5, 13): True,
			(5, 14): True,
			(5, 15): True,
			(5, 16): True,
			(5, 17): True,
			(5, 18): True,
			(5, 19): True,
			(5, 20): True,
			(5, 21): True,
			(5, 22): True,
			(5, 23): True,
			(5, 24): True,
			(6, 0): True,
			(6, 1): True,
			(6, 2): True,
			(6, 3): True,
			(6, 4): True,
			(6, 5): True,
			(6, 6): True,
			(6, 7): True,
			(6, 8): True,
			(6, 9): True,
			(6, 10): True,
			(6, 11): True,
			(6, 12): True,
			(6, 13): True,
			(6, 14): True,
			(6, 15): True,
			(6, 16): True,
			(6, 17): True,
			(6, 18): True,
			(6, 19): True,
			(6, 20): True,
			(6, 21): True,
			(6, 22): True,
			(6, 23): True,
			(6, 24): True,
			(7, 0): True,
			(7, 1): True,
			(7, 2): True,
			(7, 3): True,
			(7, 4): True,
			(7, 5): True,
			(7, 6): True,
			(7, 7): True,
			(7, 8): True,
			(7, 9): True,
			(7, 10): True,
			(7, 11): True,
			(7, 12): True,
			(7, 13): True,
			(7, 14): True,
			(7, 15): True,
			(7, 16): True,
			(7, 17): True,
			(7, 18): True,
			(7, 19): True,
			(7, 20): True,
			(7, 21): True,
			(7, 22): True,
			(7, 23): True,
			(7, 24): True,
			(8, 0): True,
			(8, 1): True,
			(8, 2): True,
			(8, 3): True,
			(8, 4): True,
			(8, 5): True,
			(8, 6): True,
			(8, 7): True,
			(8, 8): True,
			(8, 9): True,
			(8, 10): True,
			(8, 11): True,
			(8, 12): True,
			(8, 13): True,
			(8, 14): True,
			(8, 15): True,
			(8, 16): True,
			(8, 17): True,
			(8, 18): True,
			(8, 19): True,
			(8, 20): True,
			(8, 21): True,
			(8, 22): True,
			(8, 23): True,
			(8, 24): True,
			(9, 0): True,
			(9, 1): True,
			(9, 2): True,
			(9, 3): True,
			(9, 4): True,
			(9, 5): True,
			(9, 6): True,
			(9, 7): True,
			(9, 8): True,
			(9, 9): True,
			(9, 10): True,
			(9, 11): True,
			(9, 12): True,
			(9, 13): True,
			(9, 14): True,
			(9, 15): True,
			(9, 16): True,
			(9, 17): True,
			(9, 18): True,
			(9, 19): True,
			(9, 20): True,
			(9, 21): True,
			(9, 22): True,
			(9, 23): True,
			(9, 24): True,
			(10, 0): True,
			(10, 1): True,
			(10, 2): True,
			(10, 3): True,
			(10, 4): True,
			(10, 5): True,
			(10, 6): True,
			(10, 7): True,
			(10, 8): True,
			(10, 9): True,
			(10, 10): True,
			(10, 11): True,
			(10, 12): True,
			(10, 13): True,
			(10, 14): True,
			(10, 15): True,
			(10, 16): True,
			(10, 17): True,
			(10, 18): True,
			(10, 19): True,
			(10, 20): True,
			(10, 21): True,
			(10, 22): True,
			(10, 23): True,
			(10, 24): True,
			(11, 0): True,
			(11, 1): True,
			(11, 2): True,
			(11, 3): True,
			(11, 4): True,
			(11, 5): True,
			(11, 6): True,
			(11, 7): True,
			(11, 8): True,
			(11, 9): True,
			(11, 10): True,
			(11, 11): True,
			(11, 12): True,
			(11, 13): True,
			(11, 14): True,
			(11, 15): True,
			(11, 16): True,
			(11, 17): True,
			(11, 18): True,
			(11, 19): True,
			(11, 20): True,
			(11, 21): True,
			(11, 22): True,
			(11, 23): True,
			(11, 24): True,
			(12, 0): True,
			(12, 1): True,
			(12, 2): True,
			(12, 3): True,
			(12, 4): True,
			(12, 5): True,
			(12, 6): True,
			(12, 7): True,
			(12, 8): True,
			(12, 9): True,
			(12, 10): True,
			(12, 11): True,
			(12, 12): True,
			(12, 13): True,
			(12, 14): True,
			(12, 15): True,
			(12, 16): True,
			(12, 17): True,
			(12, 18): True,
			(12, 19): True,
			(12, 20): True,
			(12, 21): True,
			(12, 22): True,
			(12, 23): True,
			(12, 24): True,
			(13, 0): True,
			(13, 1): True,
			(13, 2): True,
			(13, 3): True,
			(13, 4): True,
			(13, 5): True,
			(13, 6): True,
			(13, 7): True,
			(13, 8): True,
			(13, 9): True,
			(13, 10): True,
			(13, 11): True,
			(13, 12): True,
			(13, 13): True,
			(13, 14): True,
			(13, 15): True,
			(13, 16): True,
			(13, 17): True,
			(13, 18): True,
			(13, 19): True,
			(13, 20): True,
			(13, 21): True,
			(13, 22): True,
			(13, 23): True,
			(13, 24): True,
			(14, 0): True,
			(14, 1): True,
			(14, 2): True,
			(14, 3): True,
			(14, 4): True,
			(14, 5): True,
			(14, 6): True,
			(14, 7): True,
			(14, 8): True,
			(14, 9): True,
			(14, 10): True,
			(14, 11): True,
			(14, 12): True,
			(14, 13): True,
			(14, 14): True,
			(14, 15): True,
			(14, 16): True,
			(14, 17): True,
			(14, 18): True,
			(14, 19): True,
			(14, 20): True,
			(14, 21): True,
			(14, 22): True,
			(14, 23): True,
			(14, 24): True,
			(15, 0): True,
			(15, 1): True,
			(15, 2): True,
			(15, 3): True,
			(15, 4): True,
			(15, 5): True,
			(15, 6): True,
			(15, 7): True,
			(15, 8): True,
			(15, 9): True,
			(15, 10): True,
			(15, 11): True,
			(15, 12): True,
			(15, 13): True,
			(15, 14): True,
			(15, 15): True,
			(15, 16): True,
			(15, 17): True,
			(15, 18): True,
			(15, 19): True,
			(15, 20): True,
			(15, 21): True,
			(15, 22): True,
			(15, 23): True,
			(15, 24): True,
			(16, 0): True,
			(16, 1): True,
			(16, 2): True,
			(16, 3): True,
			(16, 4): True,
			(16, 5): True,
			(16, 6): True,
			(16, 7): True,
			(16, 8): True,
			(16, 9): True,
			(16, 10): True,
			(16, 11): True,
			(16, 12): True,
			(16, 13): True,
			(16, 14): True,
			(16, 15): True,
			(16, 16): True,
			(16, 17): True,
			(16, 18): True,
			(16, 19): True,
			(16, 20): True,
			(16, 21): True,
			(16, 22): True,
			(16, 23): True,
			(16, 24): True,
			(17, 0): True,
			(17, 1): True,
			(17, 2): True,
			(17, 3): True,
			(17, 4): True,
			(17, 5): True,
			(17, 6): True,
			(17, 7): True,
			(17, 8): True,
			(17, 9): True,
			(17, 10): True,
			(17, 11): True,
			(17, 12): True,
			(17, 13): True,
			(17, 14): True,
			(17, 15): True,
			(17, 16): True,
			(17, 17): True,
			(17, 18): True,
			(17, 19): True,
			(17, 20): True,
			(17, 21): True,
			(17, 22): True,
			(17, 23): True,
			(17, 24): True,
			(18, 0): True,
			(18, 1): True,
			(18, 2): True,
			(18, 3): True,
			(18, 4): True,
			(18, 5): True,
			(18, 6): True,
			(18, 7): True,
			(18, 8): True,
			(18, 9): True,
			(18, 10): True,
			(18, 11): True,
			(18, 12): True,
			(18, 13): True,
			(18, 14): True,
			(18, 15): True,
			(18, 16): True,
			(18, 17): True,
			(18, 18): True,
			(18, 19): True,
			(18, 20): True,
			(18, 21): True,
			(18, 22): True,
			(18, 23): True,
			(18, 24): True,
			(19, 0): True,
			(19, 1): True,
			(19, 2): True,
			(19, 3): True,
			(19, 4): True,
			(19, 5): True,
			(19, 6): True,
			(19, 7): True,
			(19, 8): True,
			(19, 9): True,
			(19, 10): True,
			(19, 11): True,
			(19, 12): True,
			(19, 13): True,
			(19, 14): True,
			(19, 15): True,
			(19, 16): True,
			(19, 17): True,
			(19, 18): True,
			(19, 19): True,
			(19, 20): True,
			(19, 21): True,
			(19, 22): True,
			(19, 23): True,
			(19, 24): True,
			(20, 0): True,
			(20, 1): True,
			(20, 2): True,
			(20, 3): True,
			(20, 4): True,
			(20, 5): True,
			(20, 6): True,
			(20, 7): True,
			(20, 8): True,
			(20, 9): True,
			(20, 10): True,
			(20, 11): True,
			(20, 12): True,
			(20, 13): True,
			(20, 14): True,
			(20, 15): True,
			(20, 16): True,
			(20, 17): True,
			(20, 18): True,
			(20, 19): True,
			(20, 20): True,
			(20, 21): True,
			(20, 22): True,
			(20, 23): True,
			(20, 24): True,
			(21, 0): True,
			(21, 1): True,
			(21, 2): True,
			(21, 3): True,
			(21, 4): True,
			(21, 5): True,
			(21, 6): True,
			(21, 7): True,
			(21, 8): True,
			(21, 9): True,
			(21, 10): True,
			(21, 11): True,
			(21, 12): True,
			(21, 13): True,
			(21, 14): True,
			(21, 15): True,
			(21, 16): True,
			(21, 17): True,
			(21, 18): True,
			(21, 19): True,
			(21, 20): True,
			(21, 21): True,
			(21, 22): True,
			(21, 23): True,
			(21, 24): True,
			(22, 0): True,
			(22, 1): True,
			(22, 2): True,
			(22, 3): True,
			(22, 4): True,
			(22, 5): True,
			(22, 6): True,
			(22, 7): True,
			(22, 8): True,
			(22, 9): True,
			(22, 10): True,
			(22, 11): True,
			(22, 12): True,
			(22, 13): True,
			(22, 14): True,
			(22, 15): True,
			(22, 16): True,
			(22, 17): True,
			(22, 18): True,
			(22, 19): True,
			(22, 20): True,
			(22, 21): True,
			(22, 22): True,
			(22, 23): True,
			(22, 24): True,
			(23, 0): True,
			(23, 1): True,
			(23, 2): True,
			(23, 3): True,
			(23, 4): True,
			(23, 5): True,
			(23, 6): True,
			(23, 7): True,
			(23, 8): True,
			(23, 9): True,
			(23, 10): True,
			(23, 11): True,
			(23, 12): True,
			(23, 13): True,
			(23, 14): True,
			(23, 15): True,
			(23, 16): True,
			(23, 17): True,
			(23, 18): True,
			(23, 19): True,
			(23, 20): True,
			(23, 21): True,
			(23, 22): True,
			(23, 23): True,
			(23, 24): True,
			(24, 0): True,
			(24, 1): True,
			(24, 2): True,
			(24, 3): True,
			(24, 4): True,
			(24, 5): True,
			(24, 6): True,
			(24, 7): True,
			(24, 8): True,
			(24, 9): True,
			(24, 10): True,
			(24, 11): True,
			(24, 12): True,
			(24, 13): True,
			(24, 14): True,
			(24, 15): True,
			(24, 16): True,
			(24, 17): True,
			(24, 18): True,
			(24, 19): True,
			(24, 20): True,
			(24, 21): True,
			(24, 22): True,
			(24, 23): True,
			(24, 24): True,
			"wolf0": True,
			"wolf1": True,
			"wolf2": True,
			"wolf3": True,
			"wolf4": True,
			"wolf5": True,
			"wolf6": True,
			"wolf7": True,
			"wolf8": True,
			"wolf9": True,
			"sheep0": True,
			"sheep1": True,
			"sheep2": True,
			"sheep3": True,
			"sheep4": True,
			"sheep5": True,
			"sheep6": True,
			"sheep7": True,
			"sheep8": True,
			"sheep9": True,
			"sheep10": True,
			"sheep11": True,
			"sheep12": True,
			"sheep13": True,
			"sheep14": True,
			"sheep15": True,
			"sheep16": True,
			"sheep17": True,
			"sheep18": True,
			"sheep19": True,
			"sheep20": True,
			"sheep21": True,
			"sheep22": True,
			"sheep23": True,
			"sheep24": True,
		},
		"sheep": {},
		"wolf": {},
	},
	"prereqs": {"anotherrule": ["quux"], "onerule": ["qux", "quux", "quuux"]},
	"rulebook": {"somerules": ["anotherrule", "thirdrule"]},
	"triggers": {"anotherrule": ["bar", "bas", "foo"], "onerule": ["foo"]},
	"universal": {
		"rando_state": (
			3,
			(
				3399532814,
				1922621091,
				1318639202,
				1200287287,
				3284435864,
				3808930300,
				1747335490,
				3737760233,
				2715492764,
				183638019,
				3103353611,
				1217069546,
				1194190910,
				2470141417,
				528883139,
				1247094542,
				3065920289,
				4023506129,
				3986236424,
				3749810207,
				1213377109,
				2392958591,
				2637425708,
				506243303,
				1974338482,
				3524827911,
				3156542393,
				1548342757,
				91283707,
				3403533555,
				1364512744,
				993712879,
				949917159,
				3456526842,
				1616759050,
				1515251065,
				357043951,
				1352385251,
				1680586795,
				1069902820,
				2286504344,
				3262948456,
				1610629301,
				319919651,
				45107944,
				2045917580,
				2110902311,
				2464357864,
				2664307689,
				902983258,
				208177230,
				4130108282,
				1416039765,
				2461894687,
				3110756236,
				3470141532,
				2028342787,
				1781709104,
				2771498538,
				1351265847,
				304183294,
				2487644610,
				1121378284,
				4234462150,
				2171696954,
				1432476127,
				2747857624,
				3695920921,
				3988302868,
				1157199368,
				1411756053,
				2572580540,
				1410510534,
				2587342452,
				3046977583,
				4287127259,
				3252310090,
				1889562274,
				1285232301,
				2102539750,
				919647060,
				1878729190,
				837997469,
				3914202568,
				2865558995,
				1433236156,
				424157963,
				3858575292,
				3800780810,
				1344639319,
				1383058302,
				3649145092,
				1740604493,
				2985246546,
				3429535288,
				3587084276,
				3916818711,
				228645474,
				2798976986,
				1008992183,
				1597917797,
				3526936843,
				533626492,
				2612010317,
				1351135423,
				619036742,
				758900773,
				3167620717,
				4262803307,
				2927613508,
				1341810555,
				1385677314,
				3486740390,
				3628505064,
				3160038644,
				632320893,
				2972236317,
				2973155055,
				1040615847,
				1810847522,
				3695375695,
				1473230679,
				1785517482,
				2323990347,
				3829344560,
				1815628020,
				3228109550,
				1845817718,
				1600290058,
				2564572512,
				687088198,
				375571221,
				2647569431,
				2897219002,
				3029332029,
				3468442471,
				1471060578,
				1634853903,
				1706206173,
				2578029018,
				1402177220,
				3044222267,
				1413430456,
				4244498995,
				289959273,
				4106915877,
				1480055840,
				1670828849,
				2150193753,
				892238790,
				2021671481,
				2086509740,
				427575208,
				4044745485,
				3627920350,
				1612182500,
				1671043380,
				405713855,
				3483664227,
				2304922558,
				395614077,
				2350797015,
				1180850316,
				292433483,
				1333511644,
				3743603295,
				4019721169,
				2379423817,
				2431258913,
				1466514764,
				1066129045,
				477558949,
				3877267071,
				3674243700,
				1751659787,
				4097551726,
				3747439107,
				189793079,
				2467327892,
				3890055699,
				1656543049,
				175532463,
				1044881562,
				2954406023,
				2218430029,
				946001334,
				4103474870,
				766186315,
				1042145935,
				260188682,
				2878489308,
				3555411741,
				3023986187,
				3467384247,
				2174864312,
				3362440253,
				2953378436,
				19660317,
				1757532286,
				3513031710,
				1652951194,
				3049088961,
				3175452919,
				2035270037,
				1155415543,
				2934246475,
				840464792,
				407633508,
				1887661269,
				2359172041,
				968886421,
				911588093,
				3008303476,
				3521303176,
				828495762,
				771710338,
				298906623,
				3010795838,
				2770235797,
				3070544645,
				1353617353,
				2112742085,
				3228737385,
				3051453342,
				1594607522,
				4006552785,
				2729135020,
				3270702932,
				175384810,
				2169675714,
				554581549,
				3652858944,
				2892390819,
				999749053,
				893082860,
				973414218,
				3672054543,
				146531700,
				547933382,
				1836935847,
				868239712,
				1099781051,
				1576672760,
				3221746967,
				3876109239,
				2309164847,
				3865092624,
				1836244759,
				1768849141,
				2736176007,
				3510572365,
				2081525655,
				708719652,
				2743095338,
				1370536669,
				3969463016,
				106061602,
				2538980431,
				2308763556,
				412173904,
				945969761,
				1870394348,
				1070338339,
				3429806675,
				2933276694,
				1089771452,
				165596877,
				2692314790,
				1472770556,
				2529683641,
				3587633108,
				4015381206,
				954486772,
				3653418320,
				672945660,
				3995119822,
				509035573,
				2420650770,
				3167460230,
				1412904447,
				1004162553,
				359688731,
				1463730013,
				2654550898,
				2322490996,
				3587214037,
				2456381906,
				1284471257,
				3147223374,
				2962910796,
				2053633882,
				3671887914,
				3930424831,
				517344036,
				3276178055,
				2367449475,
				3829540347,
				2789357276,
				2737746061,
				1209592165,
				2765436616,
				1345522028,
				346724815,
				684933596,
				3266939327,
				869416558,
				1225816017,
				1711741543,
				1391185942,
				1195117282,
				4133900011,
				593222865,
				3599059573,
				506697230,
				2120454750,
				1106248566,
				1521609271,
				650513902,
				1941344688,
				1413850112,
				3365808516,
				600973466,
				261174065,
				275198882,
				1169627701,
				2842886091,
				3023520671,
				4219492612,
				2291549761,
				511351473,
				3018341917,
				2005076163,
				2549571737,
				2877512352,
				2873043204,
				2382566003,
				642232442,
				2261362316,
				2872306798,
				807064762,
				385341093,
				1450447147,
				3151840765,
				3621770746,
				2968319541,
				2372441200,
				2902359464,
				2182531666,
				433207909,
				1507595811,
				1685000795,
				3996524516,
				2146661000,
				2643629010,
				494082414,
				1317908926,
				1106650311,
				2244226475,
				569396640,
				95331498,
				126228182,
				702584211,
				2087141873,
				1308796343,
				3641135430,
				1166707701,
				377653635,
				2399255707,
				4192288347,
				3238330919,
				1201738531,
				2142578273,
				3256050407,
				2595925711,
				1518079532,
				2135642334,
				3084160563,
				241884221,
				3085550853,
				2436468269,
				1776983589,
				1837796627,
				396185930,
				3939082101,
				3593704069,
				1023570838,
				610201550,
				714376274,
				3482480746,
				552246385,
				496891656,
				1877800674,
				3261771839,
				2178180914,
				2212294024,
				4138961325,
				3420731064,
				2530612796,
				439727944,
				3703037321,
				2305158689,
				1529731382,
				217504291,
				1519235821,
				2732418024,
				1034439019,
				1478303207,
				1067492765,
				2780107589,
				3787048903,
				793506737,
				1301470626,
				1896781139,
				3277478514,
				3712248652,
				774847238,
				610271327,
				2631053471,
				3366302913,
				4053422276,
				2531760730,
				2041550780,
				1835981092,
				141364655,
				2133448092,
				4254040931,
				3622543914,
				2270417239,
				1209717711,
				1784903541,
				2400647874,
				3853156984,
				375118437,
				18561235,
				1443060812,
				3348607308,
				2981740304,
				1336940463,
				111193131,
				3277410661,
				3546533355,
				3092441981,
				3681307849,
				617600811,
				180806721,
				206808112,
				310645112,
				617818318,
				848332715,
				2705674327,
				1612233280,
				2810600848,
				1242839754,
				3337435622,
				3260744662,
				814455963,
				428179624,
				1976119480,
				1603386692,
				2019394322,
				3775072468,
				1288122375,
				1284053881,
				3989121801,
				1625343759,
				1949385796,
				3159082124,
				813794179,
				46872540,
				2076655045,
				2290247198,
				1043491508,
				3425447319,
				4177821993,
				250551383,
				2442303777,
				3861864670,
				4063579719,
				3409088439,
				760136108,
				758683634,
				1206840853,
				1743258086,
				3482774997,
				26579421,
				2612171602,
				1225127375,
				1303069907,
				3356197625,
				1726471078,
				3041788638,
				3326813669,
				365462487,
				2604299888,
				137785061,
				734599551,
				4281167486,
				4181648776,
				399704187,
				2185630586,
				2334476143,
				2124552519,
				1675645205,
				1687958968,
				2492364909,
				2199059955,
				15855711,
				1944418548,
				1585284131,
				3017502039,
				3542669732,
				2462391234,
				1290726696,
				4222914972,
				1483406477,
				1953508888,
				3791157178,
				2694244625,
				825495391,
				490181556,
				2122434879,
				3560588266,
				2396209291,
				4168258868,
				2825987662,
				2537163900,
				1079088369,
				3138881170,
				4078837965,
				493042506,
				1461355846,
				778622211,
				1304515156,
				3042476270,
				2474420910,
				501590610,
				1959808723,
				579379216,
				2223881595,
				587409929,
				4166117892,
				1817470172,
				2103076771,
				3309364256,
				733168470,
				4134197315,
				1212630909,
				399465005,
				2868316139,
				619834971,
				2388078861,
				1987853804,
				4141024030,
				636186497,
				2459021778,
				472143048,
				806913414,
				4082453804,
				202447953,
				3710630803,
				1271521185,
				3573749612,
				1755409516,
				4013838077,
				2017708168,
				2384253133,
				644042496,
				2821241237,
				3134223209,
				3271682952,
				434518586,
				916346595,
				2605891748,
				1235986954,
				2105707105,
				1824405608,
				1509384921,
				773752093,
				1560030029,
				56827310,
				786091112,
				1561697946,
				1774426505,
				799287221,
				1570759356,
				3457150661,
				3769914743,
				405752396,
				1549233748,
				3576579516,
				382348766,
				2895134811,
				1618176356,
				2959397351,
				1508533597,
				2490949198,
				4167064789,
				795399578,
				3303766464,
				2504198967,
				2608779501,
				2268202795,
				494725020,
				518601664,
				2977409184,
				2088836832,
				743764902,
				2696192420,
				4011378283,
				2968429477,
				859883567,
				359356418,
				3407829672,
				1900442649,
				2941584998,
				3448328286,
				2684915994,
				2928398899,
				3330869032,
				1420084479,
				1049788511,
				979750289,
				348001120,
				2931054143,
				140,
			),
			None,
		)
	},
}
SLOW_DELTA = {
	"physical": {
		"bare_places": [
			(0, 1),
			(0, 2),
			(0, 3),
			(0, 4),
			(0, 6),
			(0, 8),
			(0, 10),
			(0, 12),
			(0, 13),
			(0, 14),
			(0, 16),
			(0, 20),
			(0, 21),
			(0, 24),
			(1, 0),
			(1, 4),
			(1, 8),
			(1, 10),
			(1, 14),
			(1, 15),
			(1, 16),
			(1, 17),
			(1, 18),
			(1, 20),
			(1, 24),
			(2, 1),
			(2, 2),
			(2, 6),
			(2, 8),
			(2, 9),
			(2, 14),
			(2, 17),
			(2, 18),
			(2, 19),
			(2, 20),
			(2, 22),
			(2, 23),
			(2, 24),
			(3, 8),
			(3, 9),
			(3, 10),
			(3, 11),
			(3, 15),
			(3, 17),
			(3, 20),
			(3, 21),
			(3, 22),
			(3, 24),
			(4, 1),
			(4, 2),
			(4, 3),
			(4, 6),
			(4, 8),
			(4, 9),
			(4, 10),
			(4, 14),
			(4, 16),
			(4, 18),
			(4, 21),
			(5, 4),
			(5, 8),
			(5, 9),
			(5, 11),
			(5, 16),
			(5, 18),
			(5, 19),
			(5, 20),
			(5, 24),
			(6, 0),
			(6, 1),
			(6, 2),
			(6, 9),
			(6, 11),
			(6, 17),
			(6, 23),
			(7, 4),
			(7, 6),
			(7, 9),
			(7, 10),
			(7, 11),
			(7, 12),
			(7, 14),
			(7, 16),
			(7, 17),
			(7, 19),
			(7, 23),
			(7, 24),
			(8, 0),
			(8, 2),
			(8, 6),
			(8, 8),
			(8, 10),
			(8, 12),
			(8, 15),
			(8, 18),
			(8, 19),
			(8, 21),
			(8, 22),
			(8, 23),
			(8, 24),
			(9, 0),
			(9, 1),
			(9, 2),
			(9, 4),
			(9, 5),
			(9, 6),
			(9, 8),
			(9, 11),
			(9, 15),
			(9, 16),
			(9, 17),
			(9, 18),
			(9, 20),
			(9, 21),
			(10, 0),
			(10, 1),
			(10, 2),
			(10, 3),
			(10, 4),
			(10, 5),
			(10, 6),
			(10, 7),
			(10, 10),
			(10, 11),
			(10, 14),
			(10, 15),
			(10, 16),
			(10, 17),
			(10, 19),
			(10, 20),
			(10, 21),
			(11, 0),
			(11, 1),
			(11, 3),
			(11, 4),
			(11, 5),
			(11, 10),
			(11, 11),
			(11, 12),
			(11, 13),
			(11, 14),
			(11, 15),
			(11, 18),
			(11, 20),
			(11, 22),
			(11, 23),
			(12, 1),
			(12, 2),
			(12, 3),
			(12, 4),
			(12, 5),
			(12, 7),
			(12, 8),
			(12, 9),
			(12, 10),
			(12, 14),
			(12, 17),
			(12, 19),
			(12, 20),
			(12, 21),
			(12, 22),
			(13, 1),
			(13, 2),
			(13, 5),
			(13, 6),
			(13, 7),
			(13, 12),
			(13, 13),
			(13, 14),
			(13, 15),
			(13, 17),
			(13, 18),
			(13, 20),
			(13, 23),
			(13, 24),
			(14, 1),
			(14, 5),
			(14, 7),
			(14, 10),
			(14, 12),
			(14, 15),
			(14, 17),
			(14, 19),
			(14, 23),
			(14, 24),
			(15, 1),
			(15, 3),
			(15, 4),
			(15, 6),
			(15, 7),
			(15, 8),
			(15, 10),
			(15, 14),
			(15, 15),
			(15, 18),
			(15, 19),
			(15, 20),
			(15, 22),
			(16, 0),
			(16, 3),
			(16, 7),
			(16, 9),
			(16, 11),
			(16, 12),
			(16, 13),
			(16, 17),
			(16, 18),
			(16, 20),
			(16, 22),
			(16, 24),
			(17, 4),
			(17, 6),
			(17, 7),
			(17, 8),
			(17, 10),
			(17, 13),
			(17, 14),
			(17, 15),
			(17, 16),
			(17, 17),
			(17, 20),
			(17, 21),
			(17, 22),
			(17, 23),
			(17, 24),
			(18, 3),
			(18, 4),
			(18, 6),
			(18, 9),
			(18, 11),
			(18, 13),
			(18, 16),
			(18, 17),
			(18, 18),
			(18, 20),
			(18, 21),
			(18, 23),
			(18, 24),
			(19, 0),
			(19, 1),
			(19, 2),
			(19, 3),
			(19, 8),
			(19, 9),
			(19, 10),
			(19, 11),
			(19, 17),
			(19, 19),
			(19, 20),
			(19, 24),
			(20, 6),
			(20, 8),
			(20, 9),
			(20, 11),
			(20, 12),
			(20, 16),
			(20, 18),
			(20, 19),
			(20, 21),
			(20, 23),
			(20, 24),
			(21, 1),
			(21, 6),
			(21, 7),
			(21, 8),
			(21, 14),
			(21, 16),
			(21, 17),
			(21, 21),
			(21, 22),
			(21, 23),
			(22, 4),
			(22, 6),
			(22, 7),
			(22, 8),
			(22, 10),
			(22, 11),
			(22, 13),
			(22, 15),
			(22, 17),
			(22, 20),
			(22, 24),
			(23, 0),
			(23, 1),
			(23, 2),
			(23, 7),
			(23, 8),
			(23, 11),
			(23, 12),
			(23, 13),
			(23, 15),
			(23, 18),
			(23, 19),
			(23, 20),
			(23, 21),
			(24, 0),
			(24, 2),
			(24, 3),
			(24, 4),
			(24, 9),
			(24, 11),
			(24, 13),
			(24, 14),
			(24, 15),
			(24, 19),
			(24, 22),
			(24, 23),
			(24, 24),
			(9, 13),
			(23, 22),
			(7, 21),
			(15, 16),
			(2, 12),
			(2, 21),
			(24, 16),
			(12, 6),
			(21, 13),
			(23, 17),
			(10, 13),
			(22, 22),
			(6, 21),
			(6, 12),
			(7, 0),
			(8, 20),
			(3, 12),
			(15, 17),
			(1, 21),
			(14, 2),
			(6, 6),
			(13, 0),
			(23, 16),
			(22, 23),
			(11, 6),
			(13, 22),
			(20, 13),
			(12, 15),
			(24, 17),
			(18, 14),
			(9, 23),
			(13, 11),
			(22, 14),
			(3, 16),
			(10, 12),
			(5, 21),
			(5, 12),
			(7, 1),
			(7, 20),
			(16, 15),
			(4, 12),
			(1, 22),
			(15, 2),
			(5, 6),
			(14, 0),
			(22, 16),
			(23, 23),
			(11, 7),
			(19, 13),
			(12, 16),
			(24, 18),
			(19, 14),
			(10, 23),
			(14, 11),
			(23, 14),
			(2, 16),
			(9, 12),
			(5, 22),
			(5, 13),
			(7, 2),
			(6, 20),
			(16, 14),
			(4, 13),
			(14, 18),
			(0, 22),
			(16, 2),
			(5, 7),
			(15, 0),
			(23, 24),
			(11, 8),
			(14, 21),
			(19, 12),
			(13, 16),
			(20, 14),
			(10, 24),
			(15, 11),
			(2, 15),
			(6, 22),
			(6, 13),
			(7, 3),
			(6, 19),
			(3, 13),
			(0, 23),
			(17, 2),
			(6, 7),
			(10, 8),
			(15, 21),
			(18, 12),
			(14, 16),
			(24, 20),
			(20, 15),
			(11, 24),
			(7, 22),
			(7, 13),
			(6, 3),
			(6, 18),
			(2, 13),
			(18, 2),
			(7, 7),
			(10, 9),
			(16, 21),
			(17, 12),
			(24, 21),
			(21, 15),
			(12, 24),
			(4, 15),
			(8, 13),
			(5, 3),
			(7, 18),
			(18, 15),
			(1, 13),
			(18, 1),
			(8, 7),
			(11, 9),
			(17, 11),
			(12, 23),
			(14, 9),
			(5, 15),
			(8, 11),
			(5, 2),
			(19, 15),
			(1, 12),
			(17, 1),
			(9, 7),
			(13, 9),
			(9, 14),
			(5, 1),
			(8, 17),
			(19, 16),
			(1, 11),
			(16, 1),
			(12, 0),
			(18, 22),
			(13, 8),
			(6, 14),
			(9, 10),
			(9, 22),
			(5, 0),
			(8, 16),
			(2, 11),
			(14, 14),
			(9, 9),
			(20, 17),
			(19, 22),
			(14, 8),
			(24, 12),
			(10, 22),
			(4, 0),
			(2, 10),
			(14, 13),
			(17, 0),
			(8, 9),
			(20, 22),
			(15, 13),
			(16, 16),
			(7, 15),
			(3, 0),
			(6, 16),
			(1, 23),
			(18, 0),
			(11, 2),
			(21, 18),
			(22, 12),
			(11, 16),
			(2, 0),
			(6, 15),
			(1, 9),
			(12, 13),
			(22, 18),
			(20, 20),
			(21, 12),
			(11, 17),
			(0, 9),
			(12, 12),
			(20, 0),
			(22, 19),
			(22, 21),
			(21, 20),
			(21, 11),
			(21, 24),
			(5, 14),
			(12, 11),
			(21, 0),
			(21, 19),
			(21, 19),
			(21, 10),
		],
		"edge_val": {
			(0, 1): {(0, 2): {"foo": "bar"}, (1, 0): {"spam": "disgusting"}}
		},
		"edges": {
			(0, 0): {(0, 1): False, (1, 0): False},
			(0, 1): {(0, 0): False},
			(1, 0): {(0, 0): False, (0, 1): True},
		},
		"node_val": {
			"wolf2": {"location": (23, 2)},
			(8, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"wolf4": {"location": (24, 18)},
			"sheep3": {"location": (13, 16)},
			(22, 10): {"_x": 0.8983333333333333},
			(22, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"bare": True,
			},
			(15, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(7, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(0, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(22, 5): {"_x": 0.8983333333333333},
			(22, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"bare": True,
			},
			(22, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"bare": True,
			},
			"sheep19": {"location": (9, 13)},
			"sheep14": {"location": (21, 17)},
			(15, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(15, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"bare": True,
			},
			"sheep6": {"location": (11, 21)},
			"sheep2": {"location": (10, 1)},
			(22, 0): {"_x": 0.8983333333333333},
			(22, 9): {"_x": 0.8983333333333333},
			(22, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"bare": True,
			},
			(14, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(7, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"bare": True,
			},
			(21, 22): {"_x": 0.8574999999999999},
			(10, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(22, 4): {"_x": 0.8983333333333333},
			(3, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(14, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(22, 13): {"_x": 0.8983333333333333},
			(14, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(14, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 8): {"_x": 0.8574999999999999},
			(21, 17): {"_x": 0.8574999999999999},
			(2, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(2, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(22, 8): {"_x": 0.8983333333333333},
			"wolf7": {"location": (13, 15)},
			"sheep16": {"location": (13, 11)},
			(5, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 3): {"_x": 0.8574999999999999},
			(6, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"sheep12": {"location": (0, 1)},
			(21, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"bare": True,
			},
			(21, 21): {"_x": 0.8574999999999999},
			(2, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(13, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 7): {"_x": 0.8574999999999999},
			(21, 16): {"_x": 0.8574999999999999},
			(20, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"bare": True,
			},
			"wolf1": {"location": (8, 14)},
			(2, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(13, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(24, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"sheep9": {"location": (7, 16)},
			"sheep4": {"location": (23, 18)},
			(5, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"sheep20": {"location": (20, 19)},
			(9, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(5, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 2): {"_x": 0.8574999999999999},
			(20, 15): {"_x": 0.8166666666666667},
			(20, 24): {"_x": 0.8166666666666667},
			(23, 20): {"_x": 0.9391666666666667},
			(24, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(17, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(5, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(9, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(20, 1): {"_x": 0.8166666666666667},
			(20, 10): {"_x": 0.8166666666666667},
			(12, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(23, 6): {"_x": 0.9391666666666667},
			(20, 19): {"_x": 0.8166666666666667},
			"sheep15": {"location": (0, 7)},
			(12, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(23, 15): {"_x": 0.9391666666666667},
			(23, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"bare": True,
			},
			(13, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(24, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"sheep0": {"location": (10, 13)},
			(5, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"sheep24": {"location": (15, 12)},
			(9, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(19, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(19, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(20, 5): {"_x": 0.8166666666666667},
			"sheep23": {"location": (22, 19)},
			(23, 1): {"_x": 0.9391666666666667},
			(20, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"bare": True,
			},
			(23, 10): {"_x": 0.9391666666666667},
			(20, 23): {"_x": 0.8166666666666667},
			"sheep17": {"location": (0, 24)},
			(23, 19): {"_x": 0.9391666666666667},
			(1, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(13, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(16, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(5, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(8, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(0, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(20, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"bare": True,
			},
			(20, 9): {"_x": 0.8166666666666667},
			(23, 5): {"_x": 0.9391666666666667},
			(20, 18): {"_x": 0.8166666666666667},
			(23, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"bare": True,
			},
			(23, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"bare": True,
			},
			"sheep18": {"location": (22, 0)},
			(16, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(7, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(19, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(11, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(19, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"bare": False,
			},
			(11, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(20, 4): {"_x": 0.8166666666666667},
			(12, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(23, 0): {"_x": 0.9391666666666667},
			(20, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"bare": True,
			},
			(23, 9): {"_x": 0.9391666666666667},
			"sheep21": {"location": (24, 21)},
			(23, 18): {"_x": 0.9391666666666667},
			(22, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"bare": True,
			},
			"sheep11": {"location": (10, 18)},
			(7, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(8, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(19, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(23, 4): {"_x": 0.9391666666666667},
			(4, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"wolf3": {"location": (22, 24)},
			(22, 17): {"_x": 0.8983333333333333},
			(14, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(15, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"bare": False,
			},
			(7, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(8, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(11, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(11, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(22, 3): {"_x": 0.8983333333333333},
			(22, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"bare": True,
			},
			(14, 8): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(22, 21): {"_x": 0.8983333333333333},
			(15, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"wolf5": {"location": (15, 9)},
			"wolf0": {"location": (22, 5)},
			(18, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"sheep13": {"location": (5, 15)},
			(11, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(10, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"wolf8": {"location": (3, 21)},
			(22, 7): {"_x": 0.8983333333333333},
			(22, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8983333333333333,
				"bare": True,
			},
			(3, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(14, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(7, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(18, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(15, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"bare": True,
			},
			(21, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"bare": True,
			},
			(2, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(22, 2): {"_x": 0.8983333333333333},
			(22, 11): {"_x": 0.8983333333333333},
			(22, 20): {"_x": 0.8983333333333333},
			(3, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(9, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 6): {"_x": 0.8574999999999999},
			(21, 15): {"_x": 0.8574999999999999},
			(21, 24): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"bare": True,
			},
			(2, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(10, 23): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(22, 6): {"_x": 0.8983333333333333},
			(14, 2): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(14, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 1): {"_x": 0.8574999999999999},
			(6, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"bare": True,
			},
			(6, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 19): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"bare": True,
			},
			(22, 1): {"_x": 0.8983333333333333},
			(9, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(9, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 5): {"_x": 0.8574999999999999},
			(6, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 14): {"_x": 0.8574999999999999},
			"sheep10": {"location": (6, 21)},
			(21, 23): {"_x": 0.8574999999999999},
			(2, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(10, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(1, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(5, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8574999999999999,
				"bare": True,
			},
			(21, 9): {"_x": 0.8574999999999999},
			(6, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(20, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"bare": True,
			},
			(13, 10): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"bare": False,
			},
			(16, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(5, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(9, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(6, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(21, 4): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"_x": 0.8574999999999999,
				"bare": False,
			},
			(20, 8): {"_x": 0.8166666666666667},
			(20, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.8166666666666667,
				"bare": True,
			},
			(12, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(23, 13): {"_x": 0.9391666666666667},
			(23, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"bare": True,
			},
			(16, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(1, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(1, 21): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"sheep5": {"location": (22, 14)},
			(5, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(9, 7): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(8, 20): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(20, 3): {"_x": 0.8166666666666667},
			(20, 12): {"_x": 0.8166666666666667},
			(23, 8): {"_x": 0.9391666666666667},
			(20, 21): {"_x": 0.8166666666666667},
			(23, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"bare": True,
			},
			(4, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(13, 0): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(13, 9): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(16, 5): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"bare": False,
			},
			"sheep1": {"location": (21, 23)},
			(24, 18): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(16, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(5, 13): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"wolf6": {"location": (8, 3)},
			"sheep8": {
				"_image_paths": ["atlas://rltiles/dc-mon/sheep"],
				"location": (20, 10),
				"name": "sheep8",
			},
			(19, 15): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"sheep7": {"location": (12, 6)},
			(19, 24): {"_x": 0.7758333333333334},
			(20, 7): {"_x": 0.8166666666666667},
			(23, 3): {"_x": 0.9391666666666667},
			(20, 16): {"_x": 0.8166666666666667},
			(23, 12): {"_x": 0.9391666666666667},
			(23, 21): {"_x": 0.9391666666666667},
			(1, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			"wolf9": {"location": (15, 20)},
			(8, 1): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"bare": False,
			},
			(11, 6): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(20, 2): {"_x": 0.8166666666666667},
			(20, 11): {"_x": 0.8166666666666667},
			(23, 7): {"_x": 0.9391666666666667},
			(12, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(23, 16): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"_x": 0.9391666666666667,
				"bare": True,
			},
			(4, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(15, 17): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(18, 22): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(19, 14): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(20, 6): {"_x": 0.8166666666666667},
			(23, 2): {"_x": 0.9391666666666667},
			(12, 11): {
				"_image_paths": ["atlas://rltiles/floor/floor-normal"],
				"bare": True,
			},
			(23, 11): {"_x": 0.9391666666666667},
			(22, 15): {"_x": 0.8983333333333333},
			(22, 24): {"_x": 0.8983333333333333},
			(15, 12): {
				"_image_paths": ["atlas://rltiles/floor/floor-moss"],
				"bare": False,
			},
		},
		"nodes": {(0, 0): False, "sheep8": True},
	},
	"rulebook": {"somerules": ["anotherrule", "thirdrule"]},
	"rules": {
		"anotherrule": {
			"actions": ["ham", "baked beans", "spam", "spam", "spam"],
			"prereqs": ["quux"],
			"triggers": ["bar", "bas", "foo"],
		},
		"onerule": {
			"actions": ["eggs"],
			"prereqs": ["qux", "quux", "quuux"],
			"triggers": ["foo"],
		},
	},
	"sheep": {
		"units": {
			"physical": {
				"sheep0": True,
				"sheep1": True,
				"sheep10": True,
				"sheep11": True,
				"sheep12": True,
				"sheep13": True,
				"sheep14": True,
				"sheep15": True,
				"sheep16": True,
				"sheep17": True,
				"sheep18": True,
				"sheep19": True,
				"sheep2": True,
				"sheep20": True,
				"sheep21": True,
				"sheep22": True,
				"sheep23": True,
				"sheep24": True,
				"sheep3": True,
				"sheep4": True,
				"sheep5": True,
				"sheep6": True,
				"sheep7": True,
				"sheep8": True,
				"sheep9": True,
			}
		}
	},
}

BTT_TO = ("trunk", 15, 186)

KOBOLD_KEYFRAME_0 = {
	"actions": {
		"fight": ["fight"],
		"go2kobold": ["go2kobold"],
		"kill_kobold": ["kill_kobold"],
		"shrubsprint": ["shrubsprint"],
		"wander": ["wander"],
	},
	"big": {},
	"edge_val": {
		"astronauts": {},
		"hello": {
			"hello": {},
			"hi": {
				"bye": {
					"is-an-edge": True,
					"rulebook": ("hello", "hi", "bye"),
				},
				"hello": {
					"good": "morning",
					"rulebook": ("hello", "hi", "hello"),
				},
			},
			"me": {},
			"moon": {"earth": {"rulebook": ("hello", "moon", "earth")}},
			"morning": {},
			"salutations": {},
		},
	},
	"edges": {
		"astronauts": {},
		"hello": {"hi": {"bye": True, "hello": True}, "moon": {"earth": True}},
	},
	"graph_val": {
		"astronauts": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"astronauts",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"astronauts",
			),
			"character_rulebook": "nasa",
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"astronauts",
			),
			"unit_rulebook": ("unit_rulebook", "astronauts"),
			"units": {"hello": {"neal": True}},
		},
		"hello": {
			"character_place_rulebook": ("character_place_rulebook", "hello"),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"hello",
			),
			"character_rulebook": ("character_rulebook", "hello"),
			"character_thing_rulebook": ("character_thing_rulebook", "hello"),
			"stoat": "bitter",
			"unit_rulebook": ("unit_rulebook", "hello"),
			"units": {},
		},
	},
	"neighborhood": {},
	"node_val": {
		"astronauts": {},
		"hello": {
			"bye": {"rulebook": ("hello", "bye"), "toodles": False},
			"earth": {"rulebook": ("hello", "earth")},
			"evening": {
				"location": "bye",
				"moon": 1.0,
				"rulebook": ("hello", "evening"),
			},
			"hello": {"rulebook": ("hello", "hello"), "you": "smart"},
			"hi": {
				"no": "very no",
				"rulebook": ("hello", "hi"),
				"tainted": True,
			},
			"me": {"location": "hi", "rulebook": ("hello", "me")},
			"moon": {
				"location": "evening",
				"phase": "waxing gibbous",
				"rulebook": ("hello", "moon"),
			},
			"neal": {"location": "moon", "rulebook": ("hello", "neal")},
		},
	},
	"nodes": {
		"astronauts": {},
		"hello": {
			"bye": True,
			"earth": True,
			"evening": True,
			"hello": True,
			"hi": True,
			"me": True,
			"moon": True,
			"neal": True,
		},
	},
	"prereqs": {
		"fight": ["kobold_alive", "aware"],
		"go2kobold": ["kobold_alive", "kobold_not_here"],
		"kill_kobold": ["unmerciful"],
		"shrubsprint": ["breakcover", "not_traveling"],
		"wander": [],
	},
	"rulebook": {
		("physical", "dwarf"): (
			["fight", "kill_kobold", "go2kobold", "wander"],
			0.0,
		),
		("physical", "kobold"): (["shrubsprint"], 0.0),
	},
	"triggers": {
		"fight": ["sametile"],
		"go2kobold": ["aware"],
		"kill_kobold": ["kobold_alive"],
		"shrubsprint": ["uncovered"],
		"wander": ["standing_still"],
	},
}

KOBOLD_KEYFRAME_1 = {
	"graph_val": {
		"physical": {
			"units": {},
			"character_rulebook": ("character_rulebook", "physical"),
			"unit_rulebook": ("unit_rulebook", "physical"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"physical",
			),
			"character_place_rulebook": (
				"character_place_rulebook",
				"physical",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"physical",
			),
		}
	},
	"nodes": {
		"physical": {
			(0, 0): True,
			(0, 1): True,
			(0, 2): True,
			(0, 3): True,
			(0, 4): True,
			(0, 5): True,
			(0, 6): True,
			(0, 7): True,
			(0, 8): True,
			(0, 9): True,
			(1, 0): True,
			(1, 1): True,
			(1, 2): True,
			(1, 3): True,
			(1, 4): True,
			(1, 5): True,
			(1, 6): True,
			(1, 7): True,
			(1, 8): True,
			(1, 9): True,
			(2, 0): True,
			(2, 1): True,
			(2, 2): True,
			(2, 3): True,
			(2, 4): True,
			(2, 5): True,
			(2, 6): True,
			(2, 7): True,
			(2, 8): True,
			(2, 9): True,
			(3, 0): True,
			(3, 1): True,
			(3, 2): True,
			(3, 3): True,
			(3, 4): True,
			(3, 5): True,
			(3, 6): True,
			(3, 7): True,
			(3, 8): True,
			(3, 9): True,
			(4, 0): True,
			(4, 1): True,
			(4, 2): True,
			(4, 3): True,
			(4, 4): True,
			(4, 5): True,
			(4, 6): True,
			(4, 7): True,
			(4, 8): True,
			(4, 9): True,
			(5, 0): True,
			(5, 1): True,
			(5, 2): True,
			(5, 3): True,
			(5, 4): True,
			(5, 5): True,
			(5, 6): True,
			(5, 7): True,
			(5, 8): True,
			(5, 9): True,
			(6, 0): True,
			(6, 1): True,
			(6, 2): True,
			(6, 3): True,
			(6, 4): True,
			(6, 5): True,
			(6, 6): True,
			(6, 7): True,
			(6, 8): True,
			(6, 9): True,
			(7, 0): True,
			(7, 1): True,
			(7, 2): True,
			(7, 3): True,
			(7, 4): True,
			(7, 5): True,
			(7, 6): True,
			(7, 7): True,
			(7, 8): True,
			(7, 9): True,
			(8, 0): True,
			(8, 1): True,
			(8, 2): True,
			(8, 3): True,
			(8, 4): True,
			(8, 5): True,
			(8, 6): True,
			(8, 7): True,
			(8, 8): True,
			(8, 9): True,
			(9, 0): True,
			(9, 1): True,
			(9, 2): True,
			(9, 3): True,
			(9, 4): True,
			(9, 5): True,
			(9, 6): True,
			(9, 7): True,
			(9, 8): True,
			(9, 9): True,
			"kobold": True,
			"dwarf": True,
			"shrub0": True,
			"shrub1": True,
			"shrub2": True,
			"shrub3": True,
			"shrub4": True,
			"shrub5": True,
			"shrub6": True,
			"shrub7": True,
			"shrub8": True,
			"shrub9": True,
			"shrub10": True,
			"shrub11": True,
			"shrub12": True,
			"shrub13": True,
			"shrub14": True,
			"shrub15": True,
			"shrub16": True,
			"shrub17": True,
			"shrub18": True,
			"shrub19": True,
		}
	},
	"node_val": {
		"physical": {
			(0, 0): {"rulebook": ("physical", (0, 0))},
			(0, 1): {"rulebook": ("physical", (0, 1))},
			(0, 2): {"rulebook": ("physical", (0, 2))},
			(0, 3): {"rulebook": ("physical", (0, 3))},
			(0, 4): {"rulebook": ("physical", (0, 4))},
			(0, 5): {"rulebook": ("physical", (0, 5))},
			(0, 6): {"rulebook": ("physical", (0, 6))},
			(0, 7): {"rulebook": ("physical", (0, 7))},
			(0, 8): {"rulebook": ("physical", (0, 8))},
			(0, 9): {"rulebook": ("physical", (0, 9))},
			(1, 0): {"rulebook": ("physical", (1, 0))},
			(1, 1): {"rulebook": ("physical", (1, 1))},
			(1, 2): {"rulebook": ("physical", (1, 2))},
			(1, 3): {"rulebook": ("physical", (1, 3))},
			(1, 4): {"rulebook": ("physical", (1, 4))},
			(1, 5): {"rulebook": ("physical", (1, 5))},
			(1, 6): {"rulebook": ("physical", (1, 6))},
			(1, 7): {"rulebook": ("physical", (1, 7))},
			(1, 8): {"rulebook": ("physical", (1, 8))},
			(1, 9): {"rulebook": ("physical", (1, 9))},
			(2, 0): {"rulebook": ("physical", (2, 0))},
			(2, 1): {"rulebook": ("physical", (2, 1))},
			(2, 2): {"rulebook": ("physical", (2, 2))},
			(2, 3): {"rulebook": ("physical", (2, 3))},
			(2, 4): {"rulebook": ("physical", (2, 4))},
			(2, 5): {"rulebook": ("physical", (2, 5))},
			(2, 6): {"rulebook": ("physical", (2, 6))},
			(2, 7): {"rulebook": ("physical", (2, 7))},
			(2, 8): {"rulebook": ("physical", (2, 8))},
			(2, 9): {"rulebook": ("physical", (2, 9))},
			(3, 0): {"rulebook": ("physical", (3, 0))},
			(3, 1): {"rulebook": ("physical", (3, 1))},
			(3, 2): {"rulebook": ("physical", (3, 2))},
			(3, 3): {"rulebook": ("physical", (3, 3))},
			(3, 4): {"rulebook": ("physical", (3, 4))},
			(3, 5): {"rulebook": ("physical", (3, 5))},
			(3, 6): {"rulebook": ("physical", (3, 6))},
			(3, 7): {"rulebook": ("physical", (3, 7))},
			(3, 8): {"rulebook": ("physical", (3, 8))},
			(3, 9): {"rulebook": ("physical", (3, 9))},
			(4, 0): {"rulebook": ("physical", (4, 0))},
			(4, 1): {"rulebook": ("physical", (4, 1))},
			(4, 2): {"rulebook": ("physical", (4, 2))},
			(4, 3): {"rulebook": ("physical", (4, 3))},
			(4, 4): {"rulebook": ("physical", (4, 4))},
			(4, 5): {"rulebook": ("physical", (4, 5))},
			(4, 6): {"rulebook": ("physical", (4, 6))},
			(4, 7): {"rulebook": ("physical", (4, 7))},
			(4, 8): {"rulebook": ("physical", (4, 8))},
			(4, 9): {"rulebook": ("physical", (4, 9))},
			(5, 0): {"rulebook": ("physical", (5, 0))},
			(5, 1): {"rulebook": ("physical", (5, 1))},
			(5, 2): {"rulebook": ("physical", (5, 2))},
			(5, 3): {"rulebook": ("physical", (5, 3))},
			(5, 4): {"rulebook": ("physical", (5, 4))},
			(5, 5): {"rulebook": ("physical", (5, 5))},
			(5, 6): {"rulebook": ("physical", (5, 6))},
			(5, 7): {"rulebook": ("physical", (5, 7))},
			(5, 8): {"rulebook": ("physical", (5, 8))},
			(5, 9): {"rulebook": ("physical", (5, 9))},
			(6, 0): {"rulebook": ("physical", (6, 0))},
			(6, 1): {"rulebook": ("physical", (6, 1))},
			(6, 2): {"rulebook": ("physical", (6, 2))},
			(6, 3): {"rulebook": ("physical", (6, 3))},
			(6, 4): {"rulebook": ("physical", (6, 4))},
			(6, 5): {"rulebook": ("physical", (6, 5))},
			(6, 6): {"rulebook": ("physical", (6, 6))},
			(6, 7): {"rulebook": ("physical", (6, 7))},
			(6, 8): {"rulebook": ("physical", (6, 8))},
			(6, 9): {"rulebook": ("physical", (6, 9))},
			(7, 0): {"rulebook": ("physical", (7, 0))},
			(7, 1): {"rulebook": ("physical", (7, 1))},
			(7, 2): {"rulebook": ("physical", (7, 2))},
			(7, 3): {"rulebook": ("physical", (7, 3))},
			(7, 4): {"rulebook": ("physical", (7, 4))},
			(7, 5): {"rulebook": ("physical", (7, 5))},
			(7, 6): {"rulebook": ("physical", (7, 6))},
			(7, 7): {"rulebook": ("physical", (7, 7))},
			(7, 8): {"rulebook": ("physical", (7, 8))},
			(7, 9): {"rulebook": ("physical", (7, 9))},
			(8, 0): {"rulebook": ("physical", (8, 0))},
			(8, 1): {"rulebook": ("physical", (8, 1))},
			(8, 2): {"rulebook": ("physical", (8, 2))},
			(8, 3): {"rulebook": ("physical", (8, 3))},
			(8, 4): {"rulebook": ("physical", (8, 4))},
			(8, 5): {"rulebook": ("physical", (8, 5))},
			(8, 6): {"rulebook": ("physical", (8, 6))},
			(8, 7): {"rulebook": ("physical", (8, 7))},
			(8, 8): {"rulebook": ("physical", (8, 8))},
			(8, 9): {"rulebook": ("physical", (8, 9))},
			(9, 0): {"rulebook": ("physical", (9, 0))},
			(9, 1): {"rulebook": ("physical", (9, 1))},
			(9, 2): {"rulebook": ("physical", (9, 2))},
			(9, 3): {"rulebook": ("physical", (9, 3))},
			(9, 4): {"rulebook": ("physical", (9, 4))},
			(9, 5): {"rulebook": ("physical", (9, 5))},
			(9, 6): {"rulebook": ("physical", (9, 6))},
			(9, 7): {"rulebook": ("physical", (9, 7))},
			(9, 8): {"rulebook": ("physical", (9, 8))},
			(9, 9): {"rulebook": ("physical", (9, 9))},
			"kobold": {
				"sprint_chance": 0.9,
				"_image_paths": ["atlas://rltiles/base.atlas/kobold_m"],
				"shrub_places": [
					(1, 9),
					(2, 2),
					(6, 0),
					(7, 4),
					(5, 0),
					(6, 5),
					(8, 7),
					(8, 5),
					(2, 3),
					(5, 7),
					(9, 0),
					(1, 6),
					(7, 3),
					(1, 8),
					(3, 9),
					(2, 9),
					(4, 5),
					(4, 2),
					(3, 8),
					(0, 1),
				],
				"location": (9, 9),
				"rulebook": ("physical", "kobold"),
			},
			"dwarf": {
				"sight_radius": 2,
				"seen_kobold": False,
				"_image_paths": ["atlas://rltiles/base.atlas/dwarf_m"],
				"location": (0, 0),
				"rulebook": ("physical", "dwarf"),
			},
			"shrub0": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (1, 9),
				"rulebook": ("physical", "shrub0"),
			},
			"shrub1": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (2, 2),
				"rulebook": ("physical", "shrub1"),
			},
			"shrub2": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (6, 0),
				"rulebook": ("physical", "shrub2"),
			},
			"shrub3": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (7, 4),
				"rulebook": ("physical", "shrub3"),
			},
			"shrub4": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (5, 0),
				"rulebook": ("physical", "shrub4"),
			},
			"shrub5": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (6, 5),
				"rulebook": ("physical", "shrub5"),
			},
			"shrub6": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (8, 7),
				"rulebook": ("physical", "shrub6"),
			},
			"shrub7": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (8, 5),
				"rulebook": ("physical", "shrub7"),
			},
			"shrub8": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (2, 3),
				"rulebook": ("physical", "shrub8"),
			},
			"shrub9": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (5, 7),
				"rulebook": ("physical", "shrub9"),
			},
			"shrub10": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (9, 0),
				"rulebook": ("physical", "shrub10"),
			},
			"shrub11": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (1, 6),
				"rulebook": ("physical", "shrub11"),
			},
			"shrub12": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (7, 3),
				"rulebook": ("physical", "shrub12"),
			},
			"shrub13": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (1, 8),
				"rulebook": ("physical", "shrub13"),
			},
			"shrub14": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (3, 9),
				"rulebook": ("physical", "shrub14"),
			},
			"shrub15": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (2, 9),
				"rulebook": ("physical", "shrub15"),
			},
			"shrub16": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (4, 5),
				"rulebook": ("physical", "shrub16"),
			},
			"shrub17": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (4, 2),
				"rulebook": ("physical", "shrub17"),
			},
			"shrub18": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (3, 8),
				"rulebook": ("physical", "shrub18"),
			},
			"shrub19": {
				"cover": 1,
				"_image_paths": ["atlas://rltiles/dc-mon.atlas/fungus"],
				"_group": "shrub",
				"location": (0, 1),
				"rulebook": ("physical", "shrub19"),
			},
		}
	},
	"edges": {
		"physical": {
			(0, 0): {(1, 0): True, (0, 1): True},
			(0, 1): {(1, 1): True, (0, 0): True, (0, 2): True},
			(0, 2): {(1, 2): True, (0, 1): True, (0, 3): True},
			(0, 3): {(1, 3): True, (0, 2): True, (0, 4): True},
			(0, 4): {(1, 4): True, (0, 3): True, (0, 5): True},
			(0, 5): {(1, 5): True, (0, 4): True, (0, 6): True},
			(0, 6): {(1, 6): True, (0, 5): True, (0, 7): True},
			(0, 7): {(1, 7): True, (0, 6): True, (0, 8): True},
			(0, 8): {(1, 8): True, (0, 7): True, (0, 9): True},
			(0, 9): {(1, 9): True, (0, 8): True},
			(1, 0): {(0, 0): True, (2, 0): True, (1, 1): True},
			(1, 1): {(0, 1): True, (2, 1): True, (1, 0): True, (1, 2): True},
			(1, 2): {(0, 2): True, (2, 2): True, (1, 1): True, (1, 3): True},
			(1, 3): {(0, 3): True, (2, 3): True, (1, 2): True, (1, 4): True},
			(1, 4): {(0, 4): True, (2, 4): True, (1, 3): True, (1, 5): True},
			(1, 5): {(0, 5): True, (2, 5): True, (1, 4): True, (1, 6): True},
			(1, 6): {(0, 6): True, (2, 6): True, (1, 5): True, (1, 7): True},
			(1, 7): {(0, 7): True, (2, 7): True, (1, 6): True, (1, 8): True},
			(1, 8): {(0, 8): True, (2, 8): True, (1, 7): True, (1, 9): True},
			(1, 9): {(0, 9): True, (2, 9): True, (1, 8): True},
			(2, 0): {(1, 0): True, (3, 0): True, (2, 1): True},
			(2, 1): {(1, 1): True, (3, 1): True, (2, 0): True, (2, 2): True},
			(2, 2): {(1, 2): True, (3, 2): True, (2, 1): True, (2, 3): True},
			(2, 3): {(1, 3): True, (3, 3): True, (2, 2): True, (2, 4): True},
			(2, 4): {(1, 4): True, (3, 4): True, (2, 3): True, (2, 5): True},
			(2, 5): {(1, 5): True, (3, 5): True, (2, 4): True, (2, 6): True},
			(2, 6): {(1, 6): True, (3, 6): True, (2, 5): True, (2, 7): True},
			(2, 7): {(1, 7): True, (3, 7): True, (2, 6): True, (2, 8): True},
			(2, 8): {(1, 8): True, (3, 8): True, (2, 7): True, (2, 9): True},
			(2, 9): {(1, 9): True, (3, 9): True, (2, 8): True},
			(3, 0): {(2, 0): True, (4, 0): True, (3, 1): True},
			(3, 1): {(2, 1): True, (4, 1): True, (3, 0): True, (3, 2): True},
			(3, 2): {(2, 2): True, (4, 2): True, (3, 1): True, (3, 3): True},
			(3, 3): {(2, 3): True, (4, 3): True, (3, 2): True, (3, 4): True},
			(3, 4): {(2, 4): True, (4, 4): True, (3, 3): True, (3, 5): True},
			(3, 5): {(2, 5): True, (4, 5): True, (3, 4): True, (3, 6): True},
			(3, 6): {(2, 6): True, (4, 6): True, (3, 5): True, (3, 7): True},
			(3, 7): {(2, 7): True, (4, 7): True, (3, 6): True, (3, 8): True},
			(3, 8): {(2, 8): True, (4, 8): True, (3, 7): True, (3, 9): True},
			(3, 9): {(2, 9): True, (4, 9): True, (3, 8): True},
			(4, 0): {(3, 0): True, (5, 0): True, (4, 1): True},
			(4, 1): {(3, 1): True, (5, 1): True, (4, 0): True, (4, 2): True},
			(4, 2): {(3, 2): True, (5, 2): True, (4, 1): True, (4, 3): True},
			(4, 3): {(3, 3): True, (5, 3): True, (4, 2): True, (4, 4): True},
			(4, 4): {(3, 4): True, (5, 4): True, (4, 3): True, (4, 5): True},
			(4, 5): {(3, 5): True, (5, 5): True, (4, 4): True, (4, 6): True},
			(4, 6): {(3, 6): True, (5, 6): True, (4, 5): True, (4, 7): True},
			(4, 7): {(3, 7): True, (5, 7): True, (4, 6): True, (4, 8): True},
			(4, 8): {(3, 8): True, (5, 8): True, (4, 7): True, (4, 9): True},
			(4, 9): {(3, 9): True, (5, 9): True, (4, 8): True},
			(5, 0): {(4, 0): True, (6, 0): True, (5, 1): True},
			(5, 1): {(4, 1): True, (6, 1): True, (5, 0): True, (5, 2): True},
			(5, 2): {(4, 2): True, (6, 2): True, (5, 1): True, (5, 3): True},
			(5, 3): {(4, 3): True, (6, 3): True, (5, 2): True, (5, 4): True},
			(5, 4): {(4, 4): True, (6, 4): True, (5, 3): True, (5, 5): True},
			(5, 5): {(4, 5): True, (6, 5): True, (5, 4): True, (5, 6): True},
			(5, 6): {(4, 6): True, (6, 6): True, (5, 5): True, (5, 7): True},
			(5, 7): {(4, 7): True, (6, 7): True, (5, 6): True, (5, 8): True},
			(5, 8): {(4, 8): True, (6, 8): True, (5, 7): True, (5, 9): True},
			(5, 9): {(4, 9): True, (6, 9): True, (5, 8): True},
			(6, 0): {(5, 0): True, (7, 0): True, (6, 1): True},
			(6, 1): {(5, 1): True, (7, 1): True, (6, 0): True, (6, 2): True},
			(6, 2): {(5, 2): True, (7, 2): True, (6, 1): True, (6, 3): True},
			(6, 3): {(5, 3): True, (7, 3): True, (6, 2): True, (6, 4): True},
			(6, 4): {(5, 4): True, (7, 4): True, (6, 3): True, (6, 5): True},
			(6, 5): {(5, 5): True, (7, 5): True, (6, 4): True, (6, 6): True},
			(6, 6): {(5, 6): True, (7, 6): True, (6, 5): True, (6, 7): True},
			(6, 7): {(5, 7): True, (7, 7): True, (6, 6): True, (6, 8): True},
			(6, 8): {(5, 8): True, (7, 8): True, (6, 7): True, (6, 9): True},
			(6, 9): {(5, 9): True, (7, 9): True, (6, 8): True},
			(7, 0): {(6, 0): True, (8, 0): True, (7, 1): True},
			(7, 1): {(6, 1): True, (8, 1): True, (7, 0): True, (7, 2): True},
			(7, 2): {(6, 2): True, (8, 2): True, (7, 1): True, (7, 3): True},
			(7, 3): {(6, 3): True, (8, 3): True, (7, 2): True, (7, 4): True},
			(7, 4): {(6, 4): True, (8, 4): True, (7, 3): True, (7, 5): True},
			(7, 5): {(6, 5): True, (8, 5): True, (7, 4): True, (7, 6): True},
			(7, 6): {(6, 6): True, (8, 6): True, (7, 5): True, (7, 7): True},
			(7, 7): {(6, 7): True, (8, 7): True, (7, 6): True, (7, 8): True},
			(7, 8): {(6, 8): True, (8, 8): True, (7, 7): True, (7, 9): True},
			(7, 9): {(6, 9): True, (8, 9): True, (7, 8): True},
			(8, 0): {(7, 0): True, (9, 0): True, (8, 1): True},
			(8, 1): {(7, 1): True, (9, 1): True, (8, 0): True, (8, 2): True},
			(8, 2): {(7, 2): True, (9, 2): True, (8, 1): True, (8, 3): True},
			(8, 3): {(7, 3): True, (9, 3): True, (8, 2): True, (8, 4): True},
			(8, 4): {(7, 4): True, (9, 4): True, (8, 3): True, (8, 5): True},
			(8, 5): {(7, 5): True, (9, 5): True, (8, 4): True, (8, 6): True},
			(8, 6): {(7, 6): True, (9, 6): True, (8, 5): True, (8, 7): True},
			(8, 7): {(7, 7): True, (9, 7): True, (8, 6): True, (8, 8): True},
			(8, 8): {(7, 8): True, (9, 8): True, (8, 7): True, (8, 9): True},
			(8, 9): {(7, 9): True, (9, 9): True, (8, 8): True},
			(9, 0): {(8, 0): True, (9, 1): True},
			(9, 1): {(8, 1): True, (9, 0): True, (9, 2): True},
			(9, 2): {(8, 2): True, (9, 1): True, (9, 3): True},
			(9, 3): {(8, 3): True, (9, 2): True, (9, 4): True},
			(9, 4): {(8, 4): True, (9, 3): True, (9, 5): True},
			(9, 5): {(8, 5): True, (9, 4): True, (9, 6): True},
			(9, 6): {(8, 6): True, (9, 5): True, (9, 7): True},
			(9, 7): {(8, 7): True, (9, 6): True, (9, 8): True},
			(9, 8): {(8, 8): True, (9, 7): True, (9, 9): True},
			(9, 9): {(8, 9): True, (9, 8): True},
		}
	},
	"edge_val": {
		"physical": {
			(0, 0): {
				(1, 0): {"rulebook": ("physical", (0, 0), (1, 0))},
				(0, 1): {"rulebook": ("physical", (0, 0), (0, 1))},
			},
			(0, 1): {
				(1, 1): {"rulebook": ("physical", (0, 1), (1, 1))},
				(0, 0): {"rulebook": ("physical", (0, 1), (0, 0))},
				(0, 2): {"rulebook": ("physical", (0, 1), (0, 2))},
			},
			(0, 2): {
				(1, 2): {"rulebook": ("physical", (0, 2), (1, 2))},
				(0, 1): {"rulebook": ("physical", (0, 2), (0, 1))},
				(0, 3): {"rulebook": ("physical", (0, 2), (0, 3))},
			},
			(0, 3): {
				(1, 3): {"rulebook": ("physical", (0, 3), (1, 3))},
				(0, 2): {"rulebook": ("physical", (0, 3), (0, 2))},
				(0, 4): {"rulebook": ("physical", (0, 3), (0, 4))},
			},
			(0, 4): {
				(1, 4): {"rulebook": ("physical", (0, 4), (1, 4))},
				(0, 3): {"rulebook": ("physical", (0, 4), (0, 3))},
				(0, 5): {"rulebook": ("physical", (0, 4), (0, 5))},
			},
			(0, 5): {
				(1, 5): {"rulebook": ("physical", (0, 5), (1, 5))},
				(0, 4): {"rulebook": ("physical", (0, 5), (0, 4))},
				(0, 6): {"rulebook": ("physical", (0, 5), (0, 6))},
			},
			(0, 6): {
				(1, 6): {"rulebook": ("physical", (0, 6), (1, 6))},
				(0, 5): {"rulebook": ("physical", (0, 6), (0, 5))},
				(0, 7): {"rulebook": ("physical", (0, 6), (0, 7))},
			},
			(0, 7): {
				(1, 7): {"rulebook": ("physical", (0, 7), (1, 7))},
				(0, 6): {"rulebook": ("physical", (0, 7), (0, 6))},
				(0, 8): {"rulebook": ("physical", (0, 7), (0, 8))},
			},
			(0, 8): {
				(1, 8): {"rulebook": ("physical", (0, 8), (1, 8))},
				(0, 7): {"rulebook": ("physical", (0, 8), (0, 7))},
				(0, 9): {"rulebook": ("physical", (0, 8), (0, 9))},
			},
			(0, 9): {
				(1, 9): {"rulebook": ("physical", (0, 9), (1, 9))},
				(0, 8): {"rulebook": ("physical", (0, 9), (0, 8))},
			},
			(1, 0): {
				(0, 0): {"rulebook": ("physical", (1, 0), (0, 0))},
				(2, 0): {"rulebook": ("physical", (1, 0), (2, 0))},
				(1, 1): {"rulebook": ("physical", (1, 0), (1, 1))},
			},
			(1, 1): {
				(0, 1): {"rulebook": ("physical", (1, 1), (0, 1))},
				(2, 1): {"rulebook": ("physical", (1, 1), (2, 1))},
				(1, 0): {"rulebook": ("physical", (1, 1), (1, 0))},
				(1, 2): {"rulebook": ("physical", (1, 1), (1, 2))},
			},
			(1, 2): {
				(0, 2): {"rulebook": ("physical", (1, 2), (0, 2))},
				(2, 2): {"rulebook": ("physical", (1, 2), (2, 2))},
				(1, 1): {"rulebook": ("physical", (1, 2), (1, 1))},
				(1, 3): {"rulebook": ("physical", (1, 2), (1, 3))},
			},
			(1, 3): {
				(0, 3): {"rulebook": ("physical", (1, 3), (0, 3))},
				(2, 3): {"rulebook": ("physical", (1, 3), (2, 3))},
				(1, 2): {"rulebook": ("physical", (1, 3), (1, 2))},
				(1, 4): {"rulebook": ("physical", (1, 3), (1, 4))},
			},
			(1, 4): {
				(0, 4): {"rulebook": ("physical", (1, 4), (0, 4))},
				(2, 4): {"rulebook": ("physical", (1, 4), (2, 4))},
				(1, 3): {"rulebook": ("physical", (1, 4), (1, 3))},
				(1, 5): {"rulebook": ("physical", (1, 4), (1, 5))},
			},
			(1, 5): {
				(0, 5): {"rulebook": ("physical", (1, 5), (0, 5))},
				(2, 5): {"rulebook": ("physical", (1, 5), (2, 5))},
				(1, 4): {"rulebook": ("physical", (1, 5), (1, 4))},
				(1, 6): {"rulebook": ("physical", (1, 5), (1, 6))},
			},
			(1, 6): {
				(0, 6): {"rulebook": ("physical", (1, 6), (0, 6))},
				(2, 6): {"rulebook": ("physical", (1, 6), (2, 6))},
				(1, 5): {"rulebook": ("physical", (1, 6), (1, 5))},
				(1, 7): {"rulebook": ("physical", (1, 6), (1, 7))},
			},
			(1, 7): {
				(0, 7): {"rulebook": ("physical", (1, 7), (0, 7))},
				(2, 7): {"rulebook": ("physical", (1, 7), (2, 7))},
				(1, 6): {"rulebook": ("physical", (1, 7), (1, 6))},
				(1, 8): {"rulebook": ("physical", (1, 7), (1, 8))},
			},
			(1, 8): {
				(0, 8): {"rulebook": ("physical", (1, 8), (0, 8))},
				(2, 8): {"rulebook": ("physical", (1, 8), (2, 8))},
				(1, 7): {"rulebook": ("physical", (1, 8), (1, 7))},
				(1, 9): {"rulebook": ("physical", (1, 8), (1, 9))},
			},
			(1, 9): {
				(0, 9): {"rulebook": ("physical", (1, 9), (0, 9))},
				(2, 9): {"rulebook": ("physical", (1, 9), (2, 9))},
				(1, 8): {"rulebook": ("physical", (1, 9), (1, 8))},
			},
			(2, 0): {
				(1, 0): {"rulebook": ("physical", (2, 0), (1, 0))},
				(3, 0): {"rulebook": ("physical", (2, 0), (3, 0))},
				(2, 1): {"rulebook": ("physical", (2, 0), (2, 1))},
			},
			(2, 1): {
				(1, 1): {"rulebook": ("physical", (2, 1), (1, 1))},
				(3, 1): {"rulebook": ("physical", (2, 1), (3, 1))},
				(2, 0): {"rulebook": ("physical", (2, 1), (2, 0))},
				(2, 2): {"rulebook": ("physical", (2, 1), (2, 2))},
			},
			(2, 2): {
				(1, 2): {"rulebook": ("physical", (2, 2), (1, 2))},
				(3, 2): {"rulebook": ("physical", (2, 2), (3, 2))},
				(2, 1): {"rulebook": ("physical", (2, 2), (2, 1))},
				(2, 3): {"rulebook": ("physical", (2, 2), (2, 3))},
			},
			(2, 3): {
				(1, 3): {"rulebook": ("physical", (2, 3), (1, 3))},
				(3, 3): {"rulebook": ("physical", (2, 3), (3, 3))},
				(2, 2): {"rulebook": ("physical", (2, 3), (2, 2))},
				(2, 4): {"rulebook": ("physical", (2, 3), (2, 4))},
			},
			(2, 4): {
				(1, 4): {"rulebook": ("physical", (2, 4), (1, 4))},
				(3, 4): {"rulebook": ("physical", (2, 4), (3, 4))},
				(2, 3): {"rulebook": ("physical", (2, 4), (2, 3))},
				(2, 5): {"rulebook": ("physical", (2, 4), (2, 5))},
			},
			(2, 5): {
				(1, 5): {"rulebook": ("physical", (2, 5), (1, 5))},
				(3, 5): {"rulebook": ("physical", (2, 5), (3, 5))},
				(2, 4): {"rulebook": ("physical", (2, 5), (2, 4))},
				(2, 6): {"rulebook": ("physical", (2, 5), (2, 6))},
			},
			(2, 6): {
				(1, 6): {"rulebook": ("physical", (2, 6), (1, 6))},
				(3, 6): {"rulebook": ("physical", (2, 6), (3, 6))},
				(2, 5): {"rulebook": ("physical", (2, 6), (2, 5))},
				(2, 7): {"rulebook": ("physical", (2, 6), (2, 7))},
			},
			(2, 7): {
				(1, 7): {"rulebook": ("physical", (2, 7), (1, 7))},
				(3, 7): {"rulebook": ("physical", (2, 7), (3, 7))},
				(2, 6): {"rulebook": ("physical", (2, 7), (2, 6))},
				(2, 8): {"rulebook": ("physical", (2, 7), (2, 8))},
			},
			(2, 8): {
				(1, 8): {"rulebook": ("physical", (2, 8), (1, 8))},
				(3, 8): {"rulebook": ("physical", (2, 8), (3, 8))},
				(2, 7): {"rulebook": ("physical", (2, 8), (2, 7))},
				(2, 9): {"rulebook": ("physical", (2, 8), (2, 9))},
			},
			(2, 9): {
				(1, 9): {"rulebook": ("physical", (2, 9), (1, 9))},
				(3, 9): {"rulebook": ("physical", (2, 9), (3, 9))},
				(2, 8): {"rulebook": ("physical", (2, 9), (2, 8))},
			},
			(3, 0): {
				(2, 0): {"rulebook": ("physical", (3, 0), (2, 0))},
				(4, 0): {"rulebook": ("physical", (3, 0), (4, 0))},
				(3, 1): {"rulebook": ("physical", (3, 0), (3, 1))},
			},
			(3, 1): {
				(2, 1): {"rulebook": ("physical", (3, 1), (2, 1))},
				(4, 1): {"rulebook": ("physical", (3, 1), (4, 1))},
				(3, 0): {"rulebook": ("physical", (3, 1), (3, 0))},
				(3, 2): {"rulebook": ("physical", (3, 1), (3, 2))},
			},
			(3, 2): {
				(2, 2): {"rulebook": ("physical", (3, 2), (2, 2))},
				(4, 2): {"rulebook": ("physical", (3, 2), (4, 2))},
				(3, 1): {"rulebook": ("physical", (3, 2), (3, 1))},
				(3, 3): {"rulebook": ("physical", (3, 2), (3, 3))},
			},
			(3, 3): {
				(2, 3): {"rulebook": ("physical", (3, 3), (2, 3))},
				(4, 3): {"rulebook": ("physical", (3, 3), (4, 3))},
				(3, 2): {"rulebook": ("physical", (3, 3), (3, 2))},
				(3, 4): {"rulebook": ("physical", (3, 3), (3, 4))},
			},
			(3, 4): {
				(2, 4): {"rulebook": ("physical", (3, 4), (2, 4))},
				(4, 4): {"rulebook": ("physical", (3, 4), (4, 4))},
				(3, 3): {"rulebook": ("physical", (3, 4), (3, 3))},
				(3, 5): {"rulebook": ("physical", (3, 4), (3, 5))},
			},
			(3, 5): {
				(2, 5): {"rulebook": ("physical", (3, 5), (2, 5))},
				(4, 5): {"rulebook": ("physical", (3, 5), (4, 5))},
				(3, 4): {"rulebook": ("physical", (3, 5), (3, 4))},
				(3, 6): {"rulebook": ("physical", (3, 5), (3, 6))},
			},
			(3, 6): {
				(2, 6): {"rulebook": ("physical", (3, 6), (2, 6))},
				(4, 6): {"rulebook": ("physical", (3, 6), (4, 6))},
				(3, 5): {"rulebook": ("physical", (3, 6), (3, 5))},
				(3, 7): {"rulebook": ("physical", (3, 6), (3, 7))},
			},
			(3, 7): {
				(2, 7): {"rulebook": ("physical", (3, 7), (2, 7))},
				(4, 7): {"rulebook": ("physical", (3, 7), (4, 7))},
				(3, 6): {"rulebook": ("physical", (3, 7), (3, 6))},
				(3, 8): {"rulebook": ("physical", (3, 7), (3, 8))},
			},
			(3, 8): {
				(2, 8): {"rulebook": ("physical", (3, 8), (2, 8))},
				(4, 8): {"rulebook": ("physical", (3, 8), (4, 8))},
				(3, 7): {"rulebook": ("physical", (3, 8), (3, 7))},
				(3, 9): {"rulebook": ("physical", (3, 8), (3, 9))},
			},
			(3, 9): {
				(2, 9): {"rulebook": ("physical", (3, 9), (2, 9))},
				(4, 9): {"rulebook": ("physical", (3, 9), (4, 9))},
				(3, 8): {"rulebook": ("physical", (3, 9), (3, 8))},
			},
			(4, 0): {
				(3, 0): {"rulebook": ("physical", (4, 0), (3, 0))},
				(5, 0): {"rulebook": ("physical", (4, 0), (5, 0))},
				(4, 1): {"rulebook": ("physical", (4, 0), (4, 1))},
			},
			(4, 1): {
				(3, 1): {"rulebook": ("physical", (4, 1), (3, 1))},
				(5, 1): {"rulebook": ("physical", (4, 1), (5, 1))},
				(4, 0): {"rulebook": ("physical", (4, 1), (4, 0))},
				(4, 2): {"rulebook": ("physical", (4, 1), (4, 2))},
			},
			(4, 2): {
				(3, 2): {"rulebook": ("physical", (4, 2), (3, 2))},
				(5, 2): {"rulebook": ("physical", (4, 2), (5, 2))},
				(4, 1): {"rulebook": ("physical", (4, 2), (4, 1))},
				(4, 3): {"rulebook": ("physical", (4, 2), (4, 3))},
			},
			(4, 3): {
				(3, 3): {"rulebook": ("physical", (4, 3), (3, 3))},
				(5, 3): {"rulebook": ("physical", (4, 3), (5, 3))},
				(4, 2): {"rulebook": ("physical", (4, 3), (4, 2))},
				(4, 4): {"rulebook": ("physical", (4, 3), (4, 4))},
			},
			(4, 4): {
				(3, 4): {"rulebook": ("physical", (4, 4), (3, 4))},
				(5, 4): {"rulebook": ("physical", (4, 4), (5, 4))},
				(4, 3): {"rulebook": ("physical", (4, 4), (4, 3))},
				(4, 5): {"rulebook": ("physical", (4, 4), (4, 5))},
			},
			(4, 5): {
				(3, 5): {"rulebook": ("physical", (4, 5), (3, 5))},
				(5, 5): {"rulebook": ("physical", (4, 5), (5, 5))},
				(4, 4): {"rulebook": ("physical", (4, 5), (4, 4))},
				(4, 6): {"rulebook": ("physical", (4, 5), (4, 6))},
			},
			(4, 6): {
				(3, 6): {"rulebook": ("physical", (4, 6), (3, 6))},
				(5, 6): {"rulebook": ("physical", (4, 6), (5, 6))},
				(4, 5): {"rulebook": ("physical", (4, 6), (4, 5))},
				(4, 7): {"rulebook": ("physical", (4, 6), (4, 7))},
			},
			(4, 7): {
				(3, 7): {"rulebook": ("physical", (4, 7), (3, 7))},
				(5, 7): {"rulebook": ("physical", (4, 7), (5, 7))},
				(4, 6): {"rulebook": ("physical", (4, 7), (4, 6))},
				(4, 8): {"rulebook": ("physical", (4, 7), (4, 8))},
			},
			(4, 8): {
				(3, 8): {"rulebook": ("physical", (4, 8), (3, 8))},
				(5, 8): {"rulebook": ("physical", (4, 8), (5, 8))},
				(4, 7): {"rulebook": ("physical", (4, 8), (4, 7))},
				(4, 9): {"rulebook": ("physical", (4, 8), (4, 9))},
			},
			(4, 9): {
				(3, 9): {"rulebook": ("physical", (4, 9), (3, 9))},
				(5, 9): {"rulebook": ("physical", (4, 9), (5, 9))},
				(4, 8): {"rulebook": ("physical", (4, 9), (4, 8))},
			},
			(5, 0): {
				(4, 0): {"rulebook": ("physical", (5, 0), (4, 0))},
				(6, 0): {"rulebook": ("physical", (5, 0), (6, 0))},
				(5, 1): {"rulebook": ("physical", (5, 0), (5, 1))},
			},
			(5, 1): {
				(4, 1): {"rulebook": ("physical", (5, 1), (4, 1))},
				(6, 1): {"rulebook": ("physical", (5, 1), (6, 1))},
				(5, 0): {"rulebook": ("physical", (5, 1), (5, 0))},
				(5, 2): {"rulebook": ("physical", (5, 1), (5, 2))},
			},
			(5, 2): {
				(4, 2): {"rulebook": ("physical", (5, 2), (4, 2))},
				(6, 2): {"rulebook": ("physical", (5, 2), (6, 2))},
				(5, 1): {"rulebook": ("physical", (5, 2), (5, 1))},
				(5, 3): {"rulebook": ("physical", (5, 2), (5, 3))},
			},
			(5, 3): {
				(4, 3): {"rulebook": ("physical", (5, 3), (4, 3))},
				(6, 3): {"rulebook": ("physical", (5, 3), (6, 3))},
				(5, 2): {"rulebook": ("physical", (5, 3), (5, 2))},
				(5, 4): {"rulebook": ("physical", (5, 3), (5, 4))},
			},
			(5, 4): {
				(4, 4): {"rulebook": ("physical", (5, 4), (4, 4))},
				(6, 4): {"rulebook": ("physical", (5, 4), (6, 4))},
				(5, 3): {"rulebook": ("physical", (5, 4), (5, 3))},
				(5, 5): {"rulebook": ("physical", (5, 4), (5, 5))},
			},
			(5, 5): {
				(4, 5): {"rulebook": ("physical", (5, 5), (4, 5))},
				(6, 5): {"rulebook": ("physical", (5, 5), (6, 5))},
				(5, 4): {"rulebook": ("physical", (5, 5), (5, 4))},
				(5, 6): {"rulebook": ("physical", (5, 5), (5, 6))},
			},
			(5, 6): {
				(4, 6): {"rulebook": ("physical", (5, 6), (4, 6))},
				(6, 6): {"rulebook": ("physical", (5, 6), (6, 6))},
				(5, 5): {"rulebook": ("physical", (5, 6), (5, 5))},
				(5, 7): {"rulebook": ("physical", (5, 6), (5, 7))},
			},
			(5, 7): {
				(4, 7): {"rulebook": ("physical", (5, 7), (4, 7))},
				(6, 7): {"rulebook": ("physical", (5, 7), (6, 7))},
				(5, 6): {"rulebook": ("physical", (5, 7), (5, 6))},
				(5, 8): {"rulebook": ("physical", (5, 7), (5, 8))},
			},
			(5, 8): {
				(4, 8): {"rulebook": ("physical", (5, 8), (4, 8))},
				(6, 8): {"rulebook": ("physical", (5, 8), (6, 8))},
				(5, 7): {"rulebook": ("physical", (5, 8), (5, 7))},
				(5, 9): {"rulebook": ("physical", (5, 8), (5, 9))},
			},
			(5, 9): {
				(4, 9): {"rulebook": ("physical", (5, 9), (4, 9))},
				(6, 9): {"rulebook": ("physical", (5, 9), (6, 9))},
				(5, 8): {"rulebook": ("physical", (5, 9), (5, 8))},
			},
			(6, 0): {
				(5, 0): {"rulebook": ("physical", (6, 0), (5, 0))},
				(7, 0): {"rulebook": ("physical", (6, 0), (7, 0))},
				(6, 1): {"rulebook": ("physical", (6, 0), (6, 1))},
			},
			(6, 1): {
				(5, 1): {"rulebook": ("physical", (6, 1), (5, 1))},
				(7, 1): {"rulebook": ("physical", (6, 1), (7, 1))},
				(6, 0): {"rulebook": ("physical", (6, 1), (6, 0))},
				(6, 2): {"rulebook": ("physical", (6, 1), (6, 2))},
			},
			(6, 2): {
				(5, 2): {"rulebook": ("physical", (6, 2), (5, 2))},
				(7, 2): {"rulebook": ("physical", (6, 2), (7, 2))},
				(6, 1): {"rulebook": ("physical", (6, 2), (6, 1))},
				(6, 3): {"rulebook": ("physical", (6, 2), (6, 3))},
			},
			(6, 3): {
				(5, 3): {"rulebook": ("physical", (6, 3), (5, 3))},
				(7, 3): {"rulebook": ("physical", (6, 3), (7, 3))},
				(6, 2): {"rulebook": ("physical", (6, 3), (6, 2))},
				(6, 4): {"rulebook": ("physical", (6, 3), (6, 4))},
			},
			(6, 4): {
				(5, 4): {"rulebook": ("physical", (6, 4), (5, 4))},
				(7, 4): {"rulebook": ("physical", (6, 4), (7, 4))},
				(6, 3): {"rulebook": ("physical", (6, 4), (6, 3))},
				(6, 5): {"rulebook": ("physical", (6, 4), (6, 5))},
			},
			(6, 5): {
				(5, 5): {"rulebook": ("physical", (6, 5), (5, 5))},
				(7, 5): {"rulebook": ("physical", (6, 5), (7, 5))},
				(6, 4): {"rulebook": ("physical", (6, 5), (6, 4))},
				(6, 6): {"rulebook": ("physical", (6, 5), (6, 6))},
			},
			(6, 6): {
				(5, 6): {"rulebook": ("physical", (6, 6), (5, 6))},
				(7, 6): {"rulebook": ("physical", (6, 6), (7, 6))},
				(6, 5): {"rulebook": ("physical", (6, 6), (6, 5))},
				(6, 7): {"rulebook": ("physical", (6, 6), (6, 7))},
			},
			(6, 7): {
				(5, 7): {"rulebook": ("physical", (6, 7), (5, 7))},
				(7, 7): {"rulebook": ("physical", (6, 7), (7, 7))},
				(6, 6): {"rulebook": ("physical", (6, 7), (6, 6))},
				(6, 8): {"rulebook": ("physical", (6, 7), (6, 8))},
			},
			(6, 8): {
				(5, 8): {"rulebook": ("physical", (6, 8), (5, 8))},
				(7, 8): {"rulebook": ("physical", (6, 8), (7, 8))},
				(6, 7): {"rulebook": ("physical", (6, 8), (6, 7))},
				(6, 9): {"rulebook": ("physical", (6, 8), (6, 9))},
			},
			(6, 9): {
				(5, 9): {"rulebook": ("physical", (6, 9), (5, 9))},
				(7, 9): {"rulebook": ("physical", (6, 9), (7, 9))},
				(6, 8): {"rulebook": ("physical", (6, 9), (6, 8))},
			},
			(7, 0): {
				(6, 0): {"rulebook": ("physical", (7, 0), (6, 0))},
				(8, 0): {"rulebook": ("physical", (7, 0), (8, 0))},
				(7, 1): {"rulebook": ("physical", (7, 0), (7, 1))},
			},
			(7, 1): {
				(6, 1): {"rulebook": ("physical", (7, 1), (6, 1))},
				(8, 1): {"rulebook": ("physical", (7, 1), (8, 1))},
				(7, 0): {"rulebook": ("physical", (7, 1), (7, 0))},
				(7, 2): {"rulebook": ("physical", (7, 1), (7, 2))},
			},
			(7, 2): {
				(6, 2): {"rulebook": ("physical", (7, 2), (6, 2))},
				(8, 2): {"rulebook": ("physical", (7, 2), (8, 2))},
				(7, 1): {"rulebook": ("physical", (7, 2), (7, 1))},
				(7, 3): {"rulebook": ("physical", (7, 2), (7, 3))},
			},
			(7, 3): {
				(6, 3): {"rulebook": ("physical", (7, 3), (6, 3))},
				(8, 3): {"rulebook": ("physical", (7, 3), (8, 3))},
				(7, 2): {"rulebook": ("physical", (7, 3), (7, 2))},
				(7, 4): {"rulebook": ("physical", (7, 3), (7, 4))},
			},
			(7, 4): {
				(6, 4): {"rulebook": ("physical", (7, 4), (6, 4))},
				(8, 4): {"rulebook": ("physical", (7, 4), (8, 4))},
				(7, 3): {"rulebook": ("physical", (7, 4), (7, 3))},
				(7, 5): {"rulebook": ("physical", (7, 4), (7, 5))},
			},
			(7, 5): {
				(6, 5): {"rulebook": ("physical", (7, 5), (6, 5))},
				(8, 5): {"rulebook": ("physical", (7, 5), (8, 5))},
				(7, 4): {"rulebook": ("physical", (7, 5), (7, 4))},
				(7, 6): {"rulebook": ("physical", (7, 5), (7, 6))},
			},
			(7, 6): {
				(6, 6): {"rulebook": ("physical", (7, 6), (6, 6))},
				(8, 6): {"rulebook": ("physical", (7, 6), (8, 6))},
				(7, 5): {"rulebook": ("physical", (7, 6), (7, 5))},
				(7, 7): {"rulebook": ("physical", (7, 6), (7, 7))},
			},
			(7, 7): {
				(6, 7): {"rulebook": ("physical", (7, 7), (6, 7))},
				(8, 7): {"rulebook": ("physical", (7, 7), (8, 7))},
				(7, 6): {"rulebook": ("physical", (7, 7), (7, 6))},
				(7, 8): {"rulebook": ("physical", (7, 7), (7, 8))},
			},
			(7, 8): {
				(6, 8): {"rulebook": ("physical", (7, 8), (6, 8))},
				(8, 8): {"rulebook": ("physical", (7, 8), (8, 8))},
				(7, 7): {"rulebook": ("physical", (7, 8), (7, 7))},
				(7, 9): {"rulebook": ("physical", (7, 8), (7, 9))},
			},
			(7, 9): {
				(6, 9): {"rulebook": ("physical", (7, 9), (6, 9))},
				(8, 9): {"rulebook": ("physical", (7, 9), (8, 9))},
				(7, 8): {"rulebook": ("physical", (7, 9), (7, 8))},
			},
			(8, 0): {
				(7, 0): {"rulebook": ("physical", (8, 0), (7, 0))},
				(9, 0): {"rulebook": ("physical", (8, 0), (9, 0))},
				(8, 1): {"rulebook": ("physical", (8, 0), (8, 1))},
			},
			(8, 1): {
				(7, 1): {"rulebook": ("physical", (8, 1), (7, 1))},
				(9, 1): {"rulebook": ("physical", (8, 1), (9, 1))},
				(8, 0): {"rulebook": ("physical", (8, 1), (8, 0))},
				(8, 2): {"rulebook": ("physical", (8, 1), (8, 2))},
			},
			(8, 2): {
				(7, 2): {"rulebook": ("physical", (8, 2), (7, 2))},
				(9, 2): {"rulebook": ("physical", (8, 2), (9, 2))},
				(8, 1): {"rulebook": ("physical", (8, 2), (8, 1))},
				(8, 3): {"rulebook": ("physical", (8, 2), (8, 3))},
			},
			(8, 3): {
				(7, 3): {"rulebook": ("physical", (8, 3), (7, 3))},
				(9, 3): {"rulebook": ("physical", (8, 3), (9, 3))},
				(8, 2): {"rulebook": ("physical", (8, 3), (8, 2))},
				(8, 4): {"rulebook": ("physical", (8, 3), (8, 4))},
			},
			(8, 4): {
				(7, 4): {"rulebook": ("physical", (8, 4), (7, 4))},
				(9, 4): {"rulebook": ("physical", (8, 4), (9, 4))},
				(8, 3): {"rulebook": ("physical", (8, 4), (8, 3))},
				(8, 5): {"rulebook": ("physical", (8, 4), (8, 5))},
			},
			(8, 5): {
				(7, 5): {"rulebook": ("physical", (8, 5), (7, 5))},
				(9, 5): {"rulebook": ("physical", (8, 5), (9, 5))},
				(8, 4): {"rulebook": ("physical", (8, 5), (8, 4))},
				(8, 6): {"rulebook": ("physical", (8, 5), (8, 6))},
			},
			(8, 6): {
				(7, 6): {"rulebook": ("physical", (8, 6), (7, 6))},
				(9, 6): {"rulebook": ("physical", (8, 6), (9, 6))},
				(8, 5): {"rulebook": ("physical", (8, 6), (8, 5))},
				(8, 7): {"rulebook": ("physical", (8, 6), (8, 7))},
			},
			(8, 7): {
				(7, 7): {"rulebook": ("physical", (8, 7), (7, 7))},
				(9, 7): {"rulebook": ("physical", (8, 7), (9, 7))},
				(8, 6): {"rulebook": ("physical", (8, 7), (8, 6))},
				(8, 8): {"rulebook": ("physical", (8, 7), (8, 8))},
			},
			(8, 8): {
				(7, 8): {"rulebook": ("physical", (8, 8), (7, 8))},
				(9, 8): {"rulebook": ("physical", (8, 8), (9, 8))},
				(8, 7): {"rulebook": ("physical", (8, 8), (8, 7))},
				(8, 9): {"rulebook": ("physical", (8, 8), (8, 9))},
			},
			(8, 9): {
				(7, 9): {"rulebook": ("physical", (8, 9), (7, 9))},
				(9, 9): {"rulebook": ("physical", (8, 9), (9, 9))},
				(8, 8): {"rulebook": ("physical", (8, 9), (8, 8))},
			},
			(9, 0): {
				(8, 0): {"rulebook": ("physical", (9, 0), (8, 0))},
				(9, 1): {"rulebook": ("physical", (9, 0), (9, 1))},
			},
			(9, 1): {
				(8, 1): {"rulebook": ("physical", (9, 1), (8, 1))},
				(9, 0): {"rulebook": ("physical", (9, 1), (9, 0))},
				(9, 2): {"rulebook": ("physical", (9, 1), (9, 2))},
			},
			(9, 2): {
				(8, 2): {"rulebook": ("physical", (9, 2), (8, 2))},
				(9, 1): {"rulebook": ("physical", (9, 2), (9, 1))},
				(9, 3): {"rulebook": ("physical", (9, 2), (9, 3))},
			},
			(9, 3): {
				(8, 3): {"rulebook": ("physical", (9, 3), (8, 3))},
				(9, 2): {"rulebook": ("physical", (9, 3), (9, 2))},
				(9, 4): {"rulebook": ("physical", (9, 3), (9, 4))},
			},
			(9, 4): {
				(8, 4): {"rulebook": ("physical", (9, 4), (8, 4))},
				(9, 3): {"rulebook": ("physical", (9, 4), (9, 3))},
				(9, 5): {"rulebook": ("physical", (9, 4), (9, 5))},
			},
			(9, 5): {
				(8, 5): {"rulebook": ("physical", (9, 5), (8, 5))},
				(9, 4): {"rulebook": ("physical", (9, 5), (9, 4))},
				(9, 6): {"rulebook": ("physical", (9, 5), (9, 6))},
			},
			(9, 6): {
				(8, 6): {"rulebook": ("physical", (9, 6), (8, 6))},
				(9, 5): {"rulebook": ("physical", (9, 6), (9, 5))},
				(9, 7): {"rulebook": ("physical", (9, 6), (9, 7))},
			},
			(9, 7): {
				(8, 7): {"rulebook": ("physical", (9, 7), (8, 7))},
				(9, 6): {"rulebook": ("physical", (9, 7), (9, 6))},
				(9, 8): {"rulebook": ("physical", (9, 7), (9, 8))},
			},
			(9, 8): {
				(8, 8): {"rulebook": ("physical", (9, 8), (8, 8))},
				(9, 7): {"rulebook": ("physical", (9, 8), (9, 7))},
				(9, 9): {"rulebook": ("physical", (9, 8), (9, 9))},
			},
			(9, 9): {
				(8, 9): {"rulebook": ("physical", (9, 9), (8, 9))},
				(9, 8): {"rulebook": ("physical", (9, 9), (9, 8))},
			},
		}
	},
	"triggers": {
		"shrubsprint": ["uncovered"],
		"fight": ["sametile"],
		"kill_kobold": ["kobold_alive"],
		"go2kobold": ["aware"],
		"wander": ["standing_still"],
	},
	"prereqs": {
		"shrubsprint": ["breakcover", "not_traveling"],
		"fight": ["kobold_alive", "aware"],
		"kill_kobold": ["unmerciful"],
		"go2kobold": ["kobold_alive", "kobold_not_here"],
		"wander": [],
	},
	"actions": {
		"shrubsprint": ["shrubsprint"],
		"fight": ["fight"],
		"kill_kobold": ["kill_kobold"],
		"go2kobold": ["go2kobold"],
		"wander": ["wander"],
	},
	"neighborhood": {},
	"big": {},
	"rulebook": {
		("physical", "kobold"): (["shrubsprint"], 0.0),
		("physical", "dwarf"): (
			["fight", "kill_kobold", "go2kobold", "wander"],
			0.0,
		),
	},
}

colleng = EngineFacade(None, mock=True)

COLLEGE_KEYFRAME_0 = {
	"actions": {
		"catch_up": ["catch_up"],
		"drink": ["drink"],
		"go_to_class": ["go_to_class"],
		"learn": ["learn"],
		"leave_class": ["leave_class"],
		"sloth": ["sloth"],
		"sober_up": ["sober_up"],
		"time_passes": ["time_passes"],
	},
	"big": {},
	"edge_val": {
		"astronauts": {},
		"dorm0": {},
		"dorm0room0student0": {},
		"dorm0room0student1": {},
		"dorm0room1student0": {},
		"dorm0room1student1": {},
		"dorm0room2student0": {},
		"dorm0room2student1": {},
		"dorm0room3student0": {},
		"dorm0room3student1": {},
		"dorm0room4student0": {},
		"dorm0room4student1": {},
		"dorm0room5student0": {},
		"dorm0room5student1": {},
		"dorm1": {},
		"dorm1room0student0": {},
		"dorm1room0student1": {},
		"dorm1room1student0": {},
		"dorm1room1student1": {},
		"dorm1room2student0": {},
		"dorm1room2student1": {},
		"dorm1room3student0": {},
		"dorm1room3student1": {},
		"dorm1room4student0": {},
		"dorm1room4student1": {},
		"dorm1room5student0": {},
		"dorm1room5student1": {},
		"dorm2": {},
		"dorm2room0student0": {},
		"dorm2room0student1": {},
		"dorm2room1student0": {},
		"dorm2room1student1": {},
		"dorm2room2student0": {},
		"dorm2room2student1": {},
		"dorm2room3student0": {},
		"dorm2room3student1": {},
		"dorm2room4student0": {},
		"dorm2room4student1": {},
		"dorm2room5student0": {},
		"dorm2room5student1": {},
		"hello": {
			"hello": {},
			"hi": {
				"bye": {
					"is-an-edge": True,
					"rulebook": ("hello", "hi", "bye"),
				},
				"hello": {
					"good": "morning",
					"rulebook": ("hello", "hi", "hello"),
				},
			},
			"me": {},
			"moon": {"earth": {"rulebook": ("hello", "moon", "earth")}},
			"morning": {},
			"salutations": {},
		},
		"student_body": {},
	},
	"edges": {
		"astronauts": {},
		"dorm0": {},
		"dorm0room0student0": {},
		"dorm0room0student1": {},
		"dorm0room1student0": {},
		"dorm0room1student1": {},
		"dorm0room2student0": {},
		"dorm0room2student1": {},
		"dorm0room3student0": {},
		"dorm0room3student1": {},
		"dorm0room4student0": {},
		"dorm0room4student1": {},
		"dorm0room5student0": {},
		"dorm0room5student1": {},
		"dorm1": {},
		"dorm1room0student0": {},
		"dorm1room0student1": {},
		"dorm1room1student0": {},
		"dorm1room1student1": {},
		"dorm1room2student0": {},
		"dorm1room2student1": {},
		"dorm1room3student0": {},
		"dorm1room3student1": {},
		"dorm1room4student0": {},
		"dorm1room4student1": {},
		"dorm1room5student0": {},
		"dorm1room5student1": {},
		"dorm2": {},
		"dorm2room0student0": {},
		"dorm2room0student1": {},
		"dorm2room1student0": {},
		"dorm2room1student1": {},
		"dorm2room2student0": {},
		"dorm2room2student1": {},
		"dorm2room3student0": {},
		"dorm2room3student1": {},
		"dorm2room4student0": {},
		"dorm2room4student1": {},
		"dorm2room5student0": {},
		"dorm2room5student1": {},
		"hello": {"hi": {"bye": True, "hello": True}, "moon": {"earth": True}},
		"student_body": {},
	},
	"graph_val": {
		"astronauts": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"astronauts",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"astronauts",
			),
			"character_rulebook": "nasa",
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"astronauts",
			),
			"unit_rulebook": ("unit_rulebook", "astronauts"),
			"units": {"hello": {"neal": True}},
		},
		"dorm0": {
			"character_place_rulebook": ("character_place_rulebook", "dorm0"),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0",
			),
			"character_rulebook": ("character_rulebook", "dorm0"),
			"character_thing_rulebook": ("character_thing_rulebook", "dorm0"),
			"unit_rulebook": ("unit_rulebook", "dorm0"),
			"units": {},
		},
		"dorm0room0student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room0student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room0student0",
			),
			"character_rulebook": ("character_rulebook", "dorm0room0student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room0student0",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm0room0"],
			"roommate": colleng.character["dorm0room0student1"],
			"unit_rulebook": ("unit_rulebook", "dorm0room0student0"),
			"units": {},
			"xp": 0,
		},
		"dorm0room0student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room0student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room0student1",
			),
			"character_rulebook": ("character_rulebook", "dorm0room0student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room0student1",
			),
			"drunkard": False,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm0room0"],
			"roommate": colleng.character["dorm0room0student0"],
			"unit_rulebook": ("unit_rulebook", "dorm0room0student1"),
			"units": {},
			"xp": 0,
		},
		"dorm0room1student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room1student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room1student0",
			),
			"character_rulebook": ("character_rulebook", "dorm0room1student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room1student0",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm0room1"],
			"roommate": colleng.character["dorm0room1student1"],
			"unit_rulebook": ("unit_rulebook", "dorm0room1student0"),
			"units": {},
			"xp": 0,
		},
		"dorm0room1student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room1student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room1student1",
			),
			"character_rulebook": ("character_rulebook", "dorm0room1student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room1student1",
			),
			"drunkard": True,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm0room1"],
			"roommate": colleng.character["dorm0room1student0"],
			"unit_rulebook": ("unit_rulebook", "dorm0room1student1"),
			"units": {},
			"xp": 0,
		},
		"dorm0room2student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room2student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room2student0",
			),
			"character_rulebook": ("character_rulebook", "dorm0room2student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room2student0",
			),
			"drunkard": True,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm0room2"],
			"roommate": colleng.character["dorm0room2student1"],
			"unit_rulebook": ("unit_rulebook", "dorm0room2student0"),
			"units": {},
			"xp": 0,
		},
		"dorm0room2student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room2student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room2student1",
			),
			"character_rulebook": ("character_rulebook", "dorm0room2student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room2student1",
			),
			"drunkard": True,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm0room2"],
			"roommate": colleng.character["dorm0room2student0"],
			"unit_rulebook": ("unit_rulebook", "dorm0room2student1"),
			"units": {},
			"xp": 0,
		},
		"dorm0room3student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room3student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room3student0",
			),
			"character_rulebook": ("character_rulebook", "dorm0room3student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room3student0",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm0room3"],
			"roommate": colleng.character["dorm0room3student1"],
			"unit_rulebook": ("unit_rulebook", "dorm0room3student0"),
			"units": {},
			"xp": 0,
		},
		"dorm0room3student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room3student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room3student1",
			),
			"character_rulebook": ("character_rulebook", "dorm0room3student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room3student1",
			),
			"drunkard": True,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm0room3"],
			"roommate": colleng.character["dorm0room3student0"],
			"unit_rulebook": ("unit_rulebook", "dorm0room3student1"),
			"units": {},
			"xp": 0,
		},
		"dorm0room4student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room4student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room4student0",
			),
			"character_rulebook": ("character_rulebook", "dorm0room4student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room4student0",
			),
			"drunkard": False,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm0room4"],
			"roommate": colleng.character["dorm0room4student1"],
			"unit_rulebook": ("unit_rulebook", "dorm0room4student0"),
			"units": {},
			"xp": 0,
		},
		"dorm0room4student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room4student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room4student1",
			),
			"character_rulebook": ("character_rulebook", "dorm0room4student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room4student1",
			),
			"drunkard": True,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm0room4"],
			"roommate": colleng.character["dorm0room4student0"],
			"unit_rulebook": ("unit_rulebook", "dorm0room4student1"),
			"units": {},
			"xp": 0,
		},
		"dorm0room5student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room5student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room5student0",
			),
			"character_rulebook": ("character_rulebook", "dorm0room5student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room5student0",
			),
			"drunkard": False,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm0room5"],
			"roommate": colleng.character["dorm0room5student1"],
			"unit_rulebook": ("unit_rulebook", "dorm0room5student0"),
			"units": {},
			"xp": 0,
		},
		"dorm0room5student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm0room5student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm0room5student1",
			),
			"character_rulebook": ("character_rulebook", "dorm0room5student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm0room5student1",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm0room5"],
			"roommate": colleng.character["dorm0room5student0"],
			"unit_rulebook": ("unit_rulebook", "dorm0room5student1"),
			"units": {},
			"xp": 0,
		},
		"dorm1": {
			"character_place_rulebook": ("character_place_rulebook", "dorm1"),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1",
			),
			"character_rulebook": ("character_rulebook", "dorm1"),
			"character_thing_rulebook": ("character_thing_rulebook", "dorm1"),
			"unit_rulebook": ("unit_rulebook", "dorm1"),
			"units": {},
		},
		"dorm1room0student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room0student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room0student0",
			),
			"character_rulebook": ("character_rulebook", "dorm1room0student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room0student0",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm1room0"],
			"roommate": colleng.character["dorm1room0student1"],
			"unit_rulebook": ("unit_rulebook", "dorm1room0student0"),
			"units": {},
			"xp": 0,
		},
		"dorm1room0student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room0student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room0student1",
			),
			"character_rulebook": ("character_rulebook", "dorm1room0student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room0student1",
			),
			"drunkard": False,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm1room0"],
			"roommate": colleng.character["dorm1room0student0"],
			"unit_rulebook": ("unit_rulebook", "dorm1room0student1"),
			"units": {},
			"xp": 0,
		},
		"dorm1room1student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room1student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room1student0",
			),
			"character_rulebook": ("character_rulebook", "dorm1room1student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room1student0",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm1room1"],
			"roommate": colleng.character["dorm1room1student1"],
			"unit_rulebook": ("unit_rulebook", "dorm1room1student0"),
			"units": {},
			"xp": 0,
		},
		"dorm1room1student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room1student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room1student1",
			),
			"character_rulebook": ("character_rulebook", "dorm1room1student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room1student1",
			),
			"drunkard": False,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm1room1"],
			"roommate": colleng.character["dorm1room1student0"],
			"unit_rulebook": ("unit_rulebook", "dorm1room1student1"),
			"units": {},
			"xp": 0,
		},
		"dorm1room2student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room2student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room2student0",
			),
			"character_rulebook": ("character_rulebook", "dorm1room2student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room2student0",
			),
			"drunkard": False,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm1room2"],
			"roommate": colleng.character["dorm1room2student1"],
			"unit_rulebook": ("unit_rulebook", "dorm1room2student0"),
			"units": {},
			"xp": 0,
		},
		"dorm1room2student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room2student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room2student1",
			),
			"character_rulebook": ("character_rulebook", "dorm1room2student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room2student1",
			),
			"drunkard": False,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm1room2"],
			"roommate": colleng.character["dorm1room2student0"],
			"unit_rulebook": ("unit_rulebook", "dorm1room2student1"),
			"units": {},
			"xp": 0,
		},
		"dorm1room3student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room3student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room3student0",
			),
			"character_rulebook": ("character_rulebook", "dorm1room3student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room3student0",
			),
			"drunkard": True,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm1room3"],
			"roommate": colleng.character["dorm1room3student1"],
			"unit_rulebook": ("unit_rulebook", "dorm1room3student0"),
			"units": {},
			"xp": 0,
		},
		"dorm1room3student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room3student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room3student1",
			),
			"character_rulebook": ("character_rulebook", "dorm1room3student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room3student1",
			),
			"drunkard": True,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm1room3"],
			"roommate": colleng.character["dorm1room3student0"],
			"unit_rulebook": ("unit_rulebook", "dorm1room3student1"),
			"units": {},
			"xp": 0,
		},
		"dorm1room4student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room4student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room4student0",
			),
			"character_rulebook": ("character_rulebook", "dorm1room4student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room4student0",
			),
			"drunkard": False,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm1room4"],
			"roommate": colleng.character["dorm1room4student1"],
			"unit_rulebook": ("unit_rulebook", "dorm1room4student0"),
			"units": {},
			"xp": 0,
		},
		"dorm1room4student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room4student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room4student1",
			),
			"character_rulebook": ("character_rulebook", "dorm1room4student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room4student1",
			),
			"drunkard": True,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm1room4"],
			"roommate": colleng.character["dorm1room4student0"],
			"unit_rulebook": ("unit_rulebook", "dorm1room4student1"),
			"units": {},
			"xp": 0,
		},
		"dorm1room5student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room5student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room5student0",
			),
			"character_rulebook": ("character_rulebook", "dorm1room5student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room5student0",
			),
			"drunkard": True,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm1room5"],
			"roommate": colleng.character["dorm1room5student1"],
			"unit_rulebook": ("unit_rulebook", "dorm1room5student0"),
			"units": {},
			"xp": 0,
		},
		"dorm1room5student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm1room5student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm1room5student1",
			),
			"character_rulebook": ("character_rulebook", "dorm1room5student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm1room5student1",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm1room5"],
			"roommate": colleng.character["dorm1room5student0"],
			"unit_rulebook": ("unit_rulebook", "dorm1room5student1"),
			"units": {},
			"xp": 0,
		},
		"dorm2": {
			"character_place_rulebook": ("character_place_rulebook", "dorm2"),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2",
			),
			"character_rulebook": ("character_rulebook", "dorm2"),
			"character_thing_rulebook": ("character_thing_rulebook", "dorm2"),
			"unit_rulebook": ("unit_rulebook", "dorm2"),
			"units": {},
		},
		"dorm2room0student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room0student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room0student0",
			),
			"character_rulebook": ("character_rulebook", "dorm2room0student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room0student0",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm2room0"],
			"roommate": colleng.character["dorm2room0student1"],
			"unit_rulebook": ("unit_rulebook", "dorm2room0student0"),
			"units": {},
			"xp": 0,
		},
		"dorm2room0student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room0student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room0student1",
			),
			"character_rulebook": ("character_rulebook", "dorm2room0student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room0student1",
			),
			"drunkard": True,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm2room0"],
			"roommate": colleng.character["dorm2room0student0"],
			"unit_rulebook": ("unit_rulebook", "dorm2room0student1"),
			"units": {},
			"xp": 0,
		},
		"dorm2room1student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room1student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room1student0",
			),
			"character_rulebook": ("character_rulebook", "dorm2room1student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room1student0",
			),
			"drunkard": True,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm2room1"],
			"roommate": colleng.character["dorm2room1student1"],
			"unit_rulebook": ("unit_rulebook", "dorm2room1student0"),
			"units": {},
			"xp": 0,
		},
		"dorm2room1student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room1student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room1student1",
			),
			"character_rulebook": ("character_rulebook", "dorm2room1student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room1student1",
			),
			"drunkard": True,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm2room1"],
			"roommate": colleng.character["dorm2room1student0"],
			"unit_rulebook": ("unit_rulebook", "dorm2room1student1"),
			"units": {},
			"xp": 0,
		},
		"dorm2room2student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room2student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room2student0",
			),
			"character_rulebook": ("character_rulebook", "dorm2room2student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room2student0",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm2room2"],
			"roommate": colleng.character["dorm2room2student1"],
			"unit_rulebook": ("unit_rulebook", "dorm2room2student0"),
			"units": {},
			"xp": 0,
		},
		"dorm2room2student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room2student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room2student1",
			),
			"character_rulebook": ("character_rulebook", "dorm2room2student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room2student1",
			),
			"drunkard": True,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm2room2"],
			"roommate": colleng.character["dorm2room2student0"],
			"unit_rulebook": ("unit_rulebook", "dorm2room2student1"),
			"units": {},
			"xp": 0,
		},
		"dorm2room3student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room3student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room3student0",
			),
			"character_rulebook": ("character_rulebook", "dorm2room3student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room3student0",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm2room3"],
			"roommate": colleng.character["dorm2room3student1"],
			"unit_rulebook": ("unit_rulebook", "dorm2room3student0"),
			"units": {},
			"xp": 0,
		},
		"dorm2room3student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room3student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room3student1",
			),
			"character_rulebook": ("character_rulebook", "dorm2room3student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room3student1",
			),
			"drunkard": False,
			"lazy": False,
			"room": colleng.character["physical"].place["dorm2room3"],
			"roommate": colleng.character["dorm2room3student0"],
			"unit_rulebook": ("unit_rulebook", "dorm2room3student1"),
			"units": {},
			"xp": 0,
		},
		"dorm2room4student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room4student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room4student0",
			),
			"character_rulebook": ("character_rulebook", "dorm2room4student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room4student0",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm2room4"],
			"roommate": colleng.character["dorm2room4student1"],
			"unit_rulebook": ("unit_rulebook", "dorm2room4student0"),
			"units": {},
			"xp": 0,
		},
		"dorm2room4student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room4student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room4student1",
			),
			"character_rulebook": ("character_rulebook", "dorm2room4student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room4student1",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm2room4"],
			"roommate": colleng.character["dorm2room4student0"],
			"unit_rulebook": ("unit_rulebook", "dorm2room4student1"),
			"units": {},
			"xp": 0,
		},
		"dorm2room5student0": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room5student0",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room5student0",
			),
			"character_rulebook": ("character_rulebook", "dorm2room5student0"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room5student0",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm2room5"],
			"roommate": colleng.character["dorm2room5student1"],
			"unit_rulebook": ("unit_rulebook", "dorm2room5student0"),
			"units": {},
			"xp": 0,
		},
		"dorm2room5student1": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"dorm2room5student1",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"dorm2room5student1",
			),
			"character_rulebook": ("character_rulebook", "dorm2room5student1"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"dorm2room5student1",
			),
			"drunkard": False,
			"lazy": True,
			"room": colleng.character["physical"].place["dorm2room5"],
			"roommate": colleng.character["dorm2room5student0"],
			"unit_rulebook": ("unit_rulebook", "dorm2room5student1"),
			"units": {},
			"xp": 0,
		},
		"hello": {
			"character_place_rulebook": ("character_place_rulebook", "hello"),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"hello",
			),
			"character_rulebook": ("character_rulebook", "hello"),
			"character_thing_rulebook": ("character_thing_rulebook", "hello"),
			"stoat": "bitter",
			"unit_rulebook": ("unit_rulebook", "hello"),
			"units": {},
		},
		"student_body": {
			"character_place_rulebook": (
				"character_place_rulebook",
				"student_body",
			),
			"character_portal_rulebook": (
				"character_portal_rulebook",
				"student_body",
			),
			"character_rulebook": ("character_rulebook", "student_body"),
			"character_thing_rulebook": (
				"character_thing_rulebook",
				"student_body",
			),
			"characters": [
				colleng.character["dorm0room0student0"],
				colleng.character["dorm0room0student1"],
				colleng.character["dorm0room1student0"],
				colleng.character["dorm0room1student1"],
				colleng.character["dorm0room2student0"],
				colleng.character["dorm0room2student1"],
				colleng.character["dorm0room3student0"],
				colleng.character["dorm0room3student1"],
				colleng.character["dorm0room4student0"],
				colleng.character["dorm0room4student1"],
				colleng.character["dorm0room5student0"],
				colleng.character["dorm0room5student1"],
				colleng.character["dorm1room0student0"],
				colleng.character["dorm1room0student1"],
				colleng.character["dorm1room1student0"],
				colleng.character["dorm1room1student1"],
				colleng.character["dorm1room2student0"],
				colleng.character["dorm1room2student1"],
				colleng.character["dorm1room3student0"],
				colleng.character["dorm1room3student1"],
				colleng.character["dorm1room4student0"],
				colleng.character["dorm1room4student1"],
				colleng.character["dorm1room5student0"],
				colleng.character["dorm1room5student1"],
				colleng.character["dorm2room0student0"],
				colleng.character["dorm2room0student1"],
				colleng.character["dorm2room1student0"],
				colleng.character["dorm2room1student1"],
				colleng.character["dorm2room2student0"],
				colleng.character["dorm2room2student1"],
				colleng.character["dorm2room3student0"],
				colleng.character["dorm2room3student1"],
				colleng.character["dorm2room4student0"],
				colleng.character["dorm2room4student1"],
				colleng.character["dorm2room5student0"],
				colleng.character["dorm2room5student1"],
			],
			"unit_rulebook": ("unit_rulebook", "student_body"),
			"units": {},
		},
	},
	"neighborhood": {"learn": 0},
	"node_val": {
		"astronauts": {},
		"dorm0": {},
		"dorm0room0student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room0student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm0room0student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room0student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm0room1student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room1student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm0room1student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room1student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm0room2student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room2student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm0room2student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room2student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm0room3student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room3student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm0room3student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room3student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm0room4student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room4student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm0room4student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room4student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm0room5student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room5student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm0room5student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm0room5student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm1": {},
		"dorm1room0student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room0student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm1room0student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room0student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm1room1student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room1student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm1room1student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room1student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm1room2student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room2student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm1room2student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room2student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm1room3student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room3student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm1room3student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room3student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm1room4student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room4student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm1room4student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room4student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm1room5student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room5student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm1room5student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm1room5student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm2": {},
		"dorm2room0student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room0student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm2room0student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room0student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm2room1student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room1student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm2room1student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room1student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm2room2student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room2student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm2room2student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room2student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm2room3student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room3student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm2room3student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room3student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm2room4student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room4student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm2room4student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room4student1", "cell99"),
				"slow": 0,
			},
		},
		"dorm2room5student0": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room5student0", "cell99"),
				"slow": 0,
			},
		},
		"dorm2room5student1": {
			"cell0": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell0"),
				"slow": 0,
			},
			"cell1": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell1"),
				"slow": 0,
			},
			"cell10": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell10"),
				"slow": 0,
			},
			"cell11": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell11"),
				"slow": 0,
			},
			"cell12": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell12"),
				"slow": 0,
			},
			"cell13": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell13"),
				"slow": 0,
			},
			"cell14": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell14"),
				"slow": 0,
			},
			"cell15": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell15"),
				"slow": 0,
			},
			"cell16": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell16"),
				"slow": 0,
			},
			"cell17": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell17"),
				"slow": 0,
			},
			"cell18": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell18"),
				"slow": 0,
			},
			"cell19": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell19"),
				"slow": 0,
			},
			"cell2": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell2"),
				"slow": 0,
			},
			"cell20": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell20"),
				"slow": 0,
			},
			"cell21": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell21"),
				"slow": 0,
			},
			"cell22": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell22"),
				"slow": 0,
			},
			"cell23": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell23"),
				"slow": 0,
			},
			"cell24": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell24"),
				"slow": 0,
			},
			"cell25": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell25"),
				"slow": 0,
			},
			"cell26": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell26"),
				"slow": 0,
			},
			"cell27": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell27"),
				"slow": 0,
			},
			"cell28": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell28"),
				"slow": 0,
			},
			"cell29": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell29"),
				"slow": 0,
			},
			"cell3": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell3"),
				"slow": 0,
			},
			"cell30": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell30"),
				"slow": 0,
			},
			"cell31": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell31"),
				"slow": 0,
			},
			"cell32": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell32"),
				"slow": 0,
			},
			"cell33": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell33"),
				"slow": 0,
			},
			"cell34": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell34"),
				"slow": 0,
			},
			"cell35": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell35"),
				"slow": 0,
			},
			"cell36": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell36"),
				"slow": 0,
			},
			"cell37": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell37"),
				"slow": 0,
			},
			"cell38": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell38"),
				"slow": 0,
			},
			"cell39": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell39"),
				"slow": 0,
			},
			"cell4": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell4"),
				"slow": 0,
			},
			"cell40": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell40"),
				"slow": 0,
			},
			"cell41": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell41"),
				"slow": 0,
			},
			"cell42": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell42"),
				"slow": 0,
			},
			"cell43": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell43"),
				"slow": 0,
			},
			"cell44": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell44"),
				"slow": 0,
			},
			"cell45": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell45"),
				"slow": 0,
			},
			"cell46": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell46"),
				"slow": 0,
			},
			"cell47": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell47"),
				"slow": 0,
			},
			"cell48": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell48"),
				"slow": 0,
			},
			"cell49": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell49"),
				"slow": 0,
			},
			"cell5": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell5"),
				"slow": 0,
			},
			"cell50": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell50"),
				"slow": 0,
			},
			"cell51": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell51"),
				"slow": 0,
			},
			"cell52": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell52"),
				"slow": 0,
			},
			"cell53": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell53"),
				"slow": 0,
			},
			"cell54": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell54"),
				"slow": 0,
			},
			"cell55": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell55"),
				"slow": 0,
			},
			"cell56": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell56"),
				"slow": 0,
			},
			"cell57": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell57"),
				"slow": 0,
			},
			"cell58": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell58"),
				"slow": 0,
			},
			"cell59": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell59"),
				"slow": 0,
			},
			"cell6": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell6"),
				"slow": 0,
			},
			"cell60": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell60"),
				"slow": 0,
			},
			"cell61": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell61"),
				"slow": 0,
			},
			"cell62": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell62"),
				"slow": 0,
			},
			"cell63": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell63"),
				"slow": 0,
			},
			"cell64": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell64"),
				"slow": 0,
			},
			"cell65": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell65"),
				"slow": 0,
			},
			"cell66": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell66"),
				"slow": 0,
			},
			"cell67": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell67"),
				"slow": 0,
			},
			"cell68": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell68"),
				"slow": 0,
			},
			"cell69": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell69"),
				"slow": 0,
			},
			"cell7": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell7"),
				"slow": 0,
			},
			"cell70": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell70"),
				"slow": 0,
			},
			"cell71": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell71"),
				"slow": 0,
			},
			"cell72": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell72"),
				"slow": 0,
			},
			"cell73": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell73"),
				"slow": 0,
			},
			"cell74": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell74"),
				"slow": 0,
			},
			"cell75": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell75"),
				"slow": 0,
			},
			"cell76": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell76"),
				"slow": 0,
			},
			"cell77": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell77"),
				"slow": 0,
			},
			"cell78": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell78"),
				"slow": 0,
			},
			"cell79": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell79"),
				"slow": 0,
			},
			"cell8": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell8"),
				"slow": 0,
			},
			"cell80": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell80"),
				"slow": 0,
			},
			"cell81": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell81"),
				"slow": 0,
			},
			"cell82": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell82"),
				"slow": 0,
			},
			"cell83": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell83"),
				"slow": 0,
			},
			"cell84": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell84"),
				"slow": 0,
			},
			"cell85": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell85"),
				"slow": 0,
			},
			"cell86": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell86"),
				"slow": 0,
			},
			"cell87": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell87"),
				"slow": 0,
			},
			"cell88": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell88"),
				"slow": 0,
			},
			"cell89": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell89"),
				"slow": 0,
			},
			"cell9": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell9"),
				"slow": 0,
			},
			"cell90": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell90"),
				"slow": 0,
			},
			"cell91": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell91"),
				"slow": 0,
			},
			"cell92": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell92"),
				"slow": 0,
			},
			"cell93": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell93"),
				"slow": 0,
			},
			"cell94": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell94"),
				"slow": 0,
			},
			"cell95": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell95"),
				"slow": 0,
			},
			"cell96": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell96"),
				"slow": 0,
			},
			"cell97": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell97"),
				"slow": 0,
			},
			"cell98": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell98"),
				"slow": 0,
			},
			"cell99": {
				"drunk": 0,
				"rulebook": ("dorm2room5student1", "cell99"),
				"slow": 0,
			},
		},
		"hello": {
			"bye": {"rulebook": ("hello", "bye"), "toodles": False},
			"earth": {"rulebook": ("hello", "earth")},
			"evening": {
				"location": "bye",
				"moon": 1.0,
				"rulebook": ("hello", "evening"),
			},
			"hello": {"rulebook": ("hello", "hello"), "you": "smart"},
			"hi": {
				"no": "very no",
				"rulebook": ("hello", "hi"),
				"tainted": True,
			},
			"me": {"location": "hi", "rulebook": ("hello", "me")},
			"moon": {
				"location": "evening",
				"phase": "waxing gibbous",
				"rulebook": ("hello", "moon"),
			},
			"neal": {"location": "moon", "rulebook": ("hello", "neal")},
		},
		"student_body": {},
	},
	"nodes": {
		"astronauts": {},
		"dorm0": {},
		"dorm0room0student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm0room0student1": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm0room1student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm0room1student1": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm0room2student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm0room2student1": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm0room3student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm0room3student1": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm0room4student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm0room4student1": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm0room5student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm0room5student1": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm1": {},
		"dorm1room0student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm1room0student1": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm1room1student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm1room1student1": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm1room2student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm1room2student1": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm1room3student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm1room3student1": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm1room4student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm1room4student1": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			"cell96": True,
			"cell97": True,
			"cell98": True,
			"cell99": True,
		},
		"dorm1room5student0": {
			"cell0": True,
			"cell1": True,
			"cell10": True,
			"cell11": True,
			"cell12": True,
			"cell13": True,
			"cell14": True,
			"cell15": True,
			"cell16": True,
			"cell17": True,
			"cell18": True,
			"cell19": True,
			"cell2": True,
			"cell20": True,
			"cell21": True,
			"cell22": True,
			"cell23": True,
			"cell24": True,
			"cell25": True,
			"cell26": True,
			"cell27": True,
			"cell28": True,
			"cell29": True,
			"cell3": True,
			"cell30": True,
			"cell31": True,
			"cell32": True,
			"cell33": True,
			"cell34": True,
			"cell35": True,
			"cell36": True,
			"cell37": True,
			"cell38": True,
			"cell39": True,
			"cell4": True,
			"cell40": True,
			"cell41": True,
			"cell42": True,
			"cell43": True,
			"cell44": True,
			"cell45": True,
			"cell46": True,
			"cell47": True,
			"cell48": True,
			"cell49": True,
			"cell5": True,
			"cell50": True,
			"cell51": True,
			"cell52": True,
			"cell53": True,
			"cell54": True,
			"cell55": True,
			"cell56": True,
			"cell57": True,
			"cell58": True,
			"cell59": True,
			"cell6": True,
			"cell60": True,
			"cell61": True,
			"cell62": True,
			"cell63": True,
			"cell64": True,
			"cell65": True,
			"cell66": True,
			"cell67": True,
			"cell68": True,
			"cell69": True,
			"cell7": True,
			"cell70": True,
			"cell71": True,
			"cell72": True,
			"cell73": True,
			"cell74": True,
			"cell75": True,
			"cell76": True,
			"cell77": True,
			"cell78": True,
			"cell79": True,
			"cell8": True,
			"cell80": True,
			"cell81": True,
			"cell82": True,
			"cell83": True,
			"cell84": True,
			"cell85": True,
			"cell86": True,
			"cell87": True,
			"cell88": True,
			"cell89": True,
			"cell9": True,
			"cell90": True,
			"cell91": True,
			"cell92": True,
			"cell93": True,
			"cell94": True,
			"cell95": True,
			