# encoding: utf-8

def time_passes(character):
    character.stat['hour'] = ((character.stat['hour'] + 1) % 24)

def go_to_class(node):
    node.travel_to(node.character.place['classroom'])

def leave_class(node):
    for user in node.user.values():
        if (user.name != 'student_body'):
            node.travel_to(user.stat['room'])
            return

def drink(character):
    braincells = list(character.node.values())
    character.engine.shuffle(braincells)
    for i in range(0, character.engine.randrange(1, 20)):
        braincells.pop()['drunk'] += 12

def sloth(character):
    braincells = list(character.node.values())
    character.engine.shuffle(braincells)
    for i in range(0, character.engine.randrange(1, 20)):
        braincells.pop()['slow'] += 1

def learn(node):
    for user in node.user.values():
        if ('xp' in user.stat):
            user.stat['xp'] += 1

def sober_up(node):
    node['drunk'] -= 1

def catch_up(node):
    node['slow'] -= 1
