from contextlib import contextmanager
from typing import Any, Callable, ClassVar, TypeVar, overload, Awaitable, Generator, AsyncGenerator, Generic

from tarina import ContextModel

from .provider import TProviders, Provider, ProviderFactory
from .exceptions import ExitState
from .publisher import Publisher
from .subscriber import Propagator, Subscriber
from .typing import Resultable

T = TypeVar("T")
T1 = TypeVar("T1")
_scopes: dict[str, Scope]
scope_ctx: ContextModel["Scope"]
global_propagators: list[Propagator]


class Scope:
    global_skip_req_missing: ClassVar[bool]
    id: str
    subscribers: dict[str, tuple[Subscriber, str]]
    available: bool
    providers: list[Provider[Any] | ProviderFactory]
    propagators: list[Propagator]

    @staticmethod
    def of(id_: str | None = None) -> Scope: ...
    def __init__(self, id_: str | None = None): ...
    def bind(self, *args: Provider | type[Provider] | ProviderFactory | type[ProviderFactory]) -> None: ...
    def unbind(self, arg: Provider | type[Provider] | ProviderFactory | type[ProviderFactory]) -> None: ...
    @contextmanager
    def context(self) -> Generator[Scope, None, None]: ...
    def remove_subscriber(self, subscriber: Subscriber) -> None: ...
    @overload
    def register(self, func: Callable[..., T], event: type | None = None, *, priority: int = 16, providers: TProviders | None = None, publisher: str | Publisher | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[T]: ...
    @overload
    def register(self, *, event: type | None = None, priority: int = 16, providers: TProviders | None = None, publisher: str | Publisher | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Callable[[Callable[..., T]], Subscriber[T]]: ...
    def iter(self, pub_ids: set[str], pass_backend: bool = True) -> Generator[Subscriber, None, None]: ...
    def disable(self) -> None: ...
    def enable(self) -> None: ...
    def dispose(self) -> None: ...


def configure(skip_req_missing: bool = False) -> None: ...


class _Wrapper(Generic[T]):
    @overload
    def __call__(self, func: Callable[..., AsyncGenerator[T | ExitState | None, None]]) -> Subscriber[AsyncGenerator[T, None]]: ...
    @overload
    def __call__(self, func: Callable[..., Generator[T | ExitState | None, None, None]]) -> Subscriber[Generator[T, None, None]]: ...
    @overload
    def __call__(self, func: Callable[..., Awaitable[T | ExitState | None]]) -> Subscriber[Awaitable[T]]: ...
    @overload
    def __call__(self, func: Callable[..., T | ExitState | None]) -> Subscriber[T]: ...


@overload
def on(event: type[Resultable[T1]], func: Callable[..., Generator[T1 | ExitState | None, None, None]], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[Generator[T1, None, None]]: ...
@overload
def on(event: type[Resultable[T1]], func: Callable[..., AsyncGenerator[T1 | ExitState | None, None]], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[AsyncGenerator[T1, None]]: ...
@overload
def on(event: type[Resultable[T1]], func: Callable[..., Awaitable[T1 | ExitState | None]], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[Awaitable[T1]]: ...
@overload
def on(event: type[Resultable[T1]], func: Callable[..., T1 | ExitState | None], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[T1]: ...
@overload
def on(event: type[Resultable[T1]], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> _Wrapper[T1]: ...
@overload
def on(event: type[Any], func: Callable[..., T], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[T]: ...  # type: ignore
@overload
def on(event: type[Any], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Callable[[Callable[..., T]], Subscriber[T]]: ...  # type: ignore
@overload
def on_global(func: Callable[..., T], *, priority: int = 16, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[T]: ...
@overload
def on_global(*, priority: int = 16, once: bool = False, skip_req_missing: bool | None = None) -> Callable[[Callable[..., T]], Subscriber[T]]: ...
@overload
def use(pub: Publisher[Resultable[T1]], func: Callable[..., Generator[T1 | ExitState | None, None, None]], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[Generator[T1, None, None]]: ...
@overload
def use(pub: Publisher[Resultable[T1]], func: Callable[..., AsyncGenerator[T1 | ExitState | None, None]], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[AsyncGenerator[T1, None]]: ...
@overload
def use(pub: Publisher[Resultable[T1]], func: Callable[..., Awaitable[T1 | ExitState | None]], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[Awaitable[T1]]: ...
@overload
def use(pub: Publisher[Resultable[T1]], func: Callable[..., T1 | ExitState | None], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[T1]: ...
@overload
def use(pub: Publisher[Resultable[T1]], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> _Wrapper[T1]: ...
@overload
def use(pub: Publisher[Any], func: Callable[..., T], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[T]: ...
@overload
def use(pub: Publisher[Any], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Callable[[Callable[..., T]], Subscriber[T]]: ...
@overload
def use(pub: str, func: Callable[..., T], *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Subscriber[T]: ...
@overload
def use(pub: str, *, priority: int = 16, providers: TProviders | None = None, once: bool = False, skip_req_missing: bool | None = None) -> Callable[[Callable[..., T]], Subscriber[T]]: ...
