# MCP-Agent Starter

Welcome! This project was generated by `mcp-agent init`. It’s a minimal, readable starting point you can run locally or expose as an MCP server.

## What’s included

- An `MCPApp` named `hello_world` (see `main.py`).
- Two tools defined with decorators:
  - `finder_agent(request: str, app_ctx?)`
    - An Agent that uses the `filesystem` and `fetch` MCP servers plus an LLM to answer the request.
    - Logs via the app logger (forwarded to the client as notifications when serving).
  - `run_agent_async(agent_name: str = "web_helper", prompt: str, app_ctx?)`
    - Loads an `AgentSpec` from `mcp_agent.config.yaml` (`agents.definitions`) and runs it.
    - Decorated with `@app.async_tool`: when serving, returns a workflow ID; when run in this script, it awaits and returns the string result.

## Quick start

1. Add API keys to `mcp_agent.secrets.yaml` (or set env vars):

   - `OPENAI_API_KEY` (recommended)
   - `ANTHROPIC_API_KEY` (optional)

2. Review `mcp_agent.config.yaml`:

   - Execution engine: `asyncio`
   - Logger settings
   - MCP servers: `filesystem`, `fetch`
   - `agents.definitions`: sample agents (`filesystem_helper`, `web_helper`)

3. Run locally:

```bash
uv run main.py
```

You’ll see two summaries printed:

- A summary of `README.md` from your current directory.
- A summary of the intro page at modelcontextprotocol.io.

4. Deploy a remote MCP server:

### Run as an MCP server

- In `main.py`, UNCOMMENT the server lines that call `create_mcp_server_for_app(agent_app)` and `run_sse_async()`.
- Start the server: `uv run main.py`

When you're ready to deploy, simply run:

```bash
mcp-agent deploy "hello_world"
```

- This wraps your app as a hosted MCP SSE server.
- Anything decorated with `@app.tool` (or `@app.async_tool`) runs as a Temporal workflow in the cloud.

Notes

- `app_ctx` is the MCPApp Context (configuration, logger, upstream session, etc.).
- Logging uses `app.logger` and is forwarded as notifications when connected to an MCP client.
- Configuration is read from `mcp_agent.config.yaml` and `mcp_agent.secrets.yaml` (env vars supported).
- The default model is configurable (see `openai.default_model` in config).

## Next steps

- Tweak `finder_agent` instructions or server list to fit your use case.
- Add more `AgentSpec` entries to `agents.definitions`.
- Add tools with `@app.tool` or `@app.async_tool` as you grow the app.
- Read the docs and explore examples:
  - GitHub: https://github.com/lastmile-ai/mcp-agent
  - Docs: https://docs.mcp-agent.com/
  - Discord: https://lmai.link/discord/mcp-agent

## Further reading

- Configuration reference and secrets management.
- MCP servers (stdio, SSE, streamable_http, websockets) and timeouts.
- Temporal workflows, activities, and logging/notifications when deployed.
- Agents and LLMs: `AgentSpec`, prompts, and model defaults.

Happy building!
