# MCP Tools

MCP tool definitions and adapters for the Crackerjack MCP server.

## Tool Categories

- **`execution_tools.py`** - Execute crackerjack workflows, get job progress
- **`monitoring_tools.py`** - System health, status reporting, workflow monitoring
- **`progress_tools.py`** - Real-time progress tracking for test execution
- **`semantic_tools.py`** - Semantic search, file indexing, embeddings
- **`intelligence_tools.py`** - AI agent selection, recommendations, performance analysis
- **`error_analyzer.py`** - Smart error analysis and pattern detection
- **`proactive_tools.py`** - Proactive monitoring and preventive quality checks
- **`utility_tools.py`** - Helper utilities and common operations
- **`workflow_executor.py`** - Workflow orchestration and execution management

## Core Tools

The MCP server provides these primary capabilities:

1. **Workflow Execution** - Run crackerjack quality checks via MCP
1. **Job Tracking** - Monitor async job progress and status
1. **Error Analysis** - Intelligent error detection and root cause analysis
1. **Semantic Search** - Code search with vector embeddings
1. **Agent Intelligence** - Smart agent selection based on task context

See parent `mcp/README.md` for server architecture details.
