# amphoradata
API for interacting with the Amphora Data platform.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.9.7
- Package version: 0.9.7.dev2
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import amphora_api_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import amphora_api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import amphora_api_client
from amphora_api_client.rest import ApiException
from pprint import pprint

configuration = amphora_api_client.Configuration()
# Configure API key authorization: Bearer
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# Defining host is optional and default to https://app.amphoradata.com
configuration.host = "https://app.amphoradata.com"
# Create an instance of the API class
api_instance = amphora_api_client.AmphoraeApi(amphora_api_client.ApiClient(configuration))
id = 'id_example' # str | Amphora Id.
organisation_access_rule = amphora_api_client.OrganisationAccessRule() # OrganisationAccessRule | The rule to create.
x_amphoradata_version = 'x_amphoradata_version_example' # str | API Version Number (optional)

try:
    # Creates an Access Control Rule on this Amphora.
    api_response = api_instance.amphorae_access_controls_create_for_organisation(id, organisation_access_rule, x_amphoradata_version=x_amphoradata_version)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AmphoraeApi->amphorae_access_controls_create_for_organisation: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://app.amphoradata.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AmphoraeApi* | [**amphorae_access_controls_create_for_organisation**](docs/AmphoraeApi.md#amphorae_access_controls_create_for_organisation) | **POST** /api/amphorae/{id}/AccessControls/ForOrganisation | Creates an Access Control Rule on this Amphora.
*AmphoraeApi* | [**amphorae_access_controls_create_for_user**](docs/AmphoraeApi.md#amphorae_access_controls_create_for_user) | **POST** /api/amphorae/{id}/AccessControls/ForUser | Creates an Access Control rule on this Amphora.
*AmphoraeApi* | [**amphorae_access_controls_delete**](docs/AmphoraeApi.md#amphorae_access_controls_delete) | **DELETE** /api/amphorae/{id}/AccessControls/{ruleId} | Deletes an Access Control on this Amphora.
*AmphoraeApi* | [**amphorae_access_controls_get_organisation_rules**](docs/AmphoraeApi.md#amphorae_access_controls_get_organisation_rules) | **GET** /api/amphorae/{id}/AccessControls/ForOrganisation | Get&#39;s the list of access rules applied to organisations.
*AmphoraeApi* | [**amphorae_access_controls_get_user_rules**](docs/AmphoraeApi.md#amphorae_access_controls_get_user_rules) | **GET** /api/amphorae/{id}/AccessControls/ForUser | Get&#39;s the list of access rules applied to users.
*AmphoraeApi* | [**amphorae_create**](docs/AmphoraeApi.md#amphorae_create) | **POST** /api/amphorae | Creates a new empty Amphora in the user&#39;s organisation.
*AmphoraeApi* | [**amphorae_delete**](docs/AmphoraeApi.md#amphorae_delete) | **DELETE** /api/amphorae/{id} | Deletes an Amphora.
*AmphoraeApi* | [**amphorae_files_create_file_request**](docs/AmphoraeApi.md#amphorae_files_create_file_request) | **POST** /api/amphorae/{id}/files/{file} | Creates a file. Returns a blob URL to upload to.
*AmphoraeApi* | [**amphorae_files_delete_file**](docs/AmphoraeApi.md#amphorae_files_delete_file) | **DELETE** /api/amphorae/{id}/files/{file} | Get&#39;s the contents of a file. Returns application/octet-stream.
*AmphoraeApi* | [**amphorae_files_download_file**](docs/AmphoraeApi.md#amphorae_files_download_file) | **GET** /api/amphorae/{id}/files/{file} | Get&#39;s the contents of a file. Returns application/octet-stream.
*AmphoraeApi* | [**amphorae_files_list_files**](docs/AmphoraeApi.md#amphorae_files_list_files) | **GET** /api/amphorae/{id}/files | Get&#39;s a list of an Amphora&#39;s files.
*AmphoraeApi* | [**amphorae_files_write_file_metadata**](docs/AmphoraeApi.md#amphorae_files_write_file_metadata) | **POST** /api/amphorae/{id}/files/{file}/meta | 
*AmphoraeApi* | [**amphorae_read**](docs/AmphoraeApi.md#amphorae_read) | **GET** /api/amphorae/{id} | Get&#39;s details of an Amphora by Id.
*AmphoraeApi* | [**amphorae_signals_create_signal**](docs/AmphoraeApi.md#amphorae_signals_create_signal) | **POST** /api/amphorae/{id}/signals | Associates a signal with an Amphora. Signal is created if not existing.
*AmphoraeApi* | [**amphorae_signals_get_signal**](docs/AmphoraeApi.md#amphorae_signals_get_signal) | **GET** /api/amphorae/{id}/signals/{property} | Get&#39;s the signals associated with an Amphora.
*AmphoraeApi* | [**amphorae_signals_get_signals**](docs/AmphoraeApi.md#amphorae_signals_get_signals) | **GET** /api/amphorae/{id}/signals | Get&#39;s the signals associated with an Amphora.
*AmphoraeApi* | [**amphorae_signals_update_signal**](docs/AmphoraeApi.md#amphorae_signals_update_signal) | **PUT** /api/amphorae/{id}/signals/{signalId} | Associates a signal with an Amphora. Signal is created if not existing.
*AmphoraeApi* | [**amphorae_signals_upload_signal**](docs/AmphoraeApi.md#amphorae_signals_upload_signal) | **POST** /api/amphorae/{id}/signals/values | 
*AmphoraeApi* | [**amphorae_signals_upload_signal2**](docs/AmphoraeApi.md#amphorae_signals_upload_signal2) | **POST** /api/amphorae/{id}/signalValues | 
*AmphoraeApi* | [**amphorae_signals_upload_signal_batch**](docs/AmphoraeApi.md#amphorae_signals_upload_signal_batch) | **POST** /api/amphorae/{id}/signals/batchvalues | 
*AmphoraeApi* | [**amphorae_signals_upload_signal_batch2**](docs/AmphoraeApi.md#amphorae_signals_upload_signal_batch2) | **POST** /api/amphorae/{id}/batchSignalValues | 
*AmphoraeApi* | [**amphorae_update**](docs/AmphoraeApi.md#amphorae_update) | **PUT** /api/amphorae/{id} | Updates the details of an Amphora by Id.
*AmphoraeApi* | [**purchases_purchase**](docs/AmphoraeApi.md#purchases_purchase) | **POST** /api/Amphorae/{id}/Purchases | Purchases an Amphora as the logged in user.
*AuthenticationApi* | [**authentication_request_token**](docs/AuthenticationApi.md#authentication_request_token) | **POST** /api/authentication/request | Returns a JWT (JSON Web Token).             
*IdentityApi* | [**identity_get**](docs/IdentityApi.md#identity_get) | **GET** /identity | 
*MarketApi* | [**market_find**](docs/MarketApi.md#market_find) | **GET** /api/market/search | Finds Amphora using a fuzzy search.
*MarketApi* | [**market_lookup_location**](docs/MarketApi.md#market_lookup_location) | **GET** /api/location/fuzzy | Executes a fuzzy location search.
*OrganisationsApi* | [**account_get_plan**](docs/OrganisationsApi.md#account_get_plan) | **GET** /api/Organisations/{id}/Account/Plan | Get&#39;s an Organisation&#39;s plan information.
*OrganisationsApi* | [**account_read**](docs/OrganisationsApi.md#account_read) | **GET** /api/Organisations/{id}/Account | Get&#39;s an Organisation&#39;s account information.
*OrganisationsApi* | [**organisations_create**](docs/OrganisationsApi.md#organisations_create) | **POST** /api/organisations | Creates a new Organisation. This will assign the logged in user to the organisation.
*OrganisationsApi* | [**organisations_delete**](docs/OrganisationsApi.md#organisations_delete) | **DELETE** /api/organisations/{id} | Deletes an organisation.
*OrganisationsApi* | [**organisations_read**](docs/OrganisationsApi.md#organisations_read) | **GET** /api/organisations/{id} | Gets an organisation&#39;s details.
*OrganisationsApi* | [**organisations_update**](docs/OrganisationsApi.md#organisations_update) | **PUT** /api/organisations/{id} | Updates an organisation.
*OrganisationsApi* | [**terms_and_conditions_create**](docs/OrganisationsApi.md#terms_and_conditions_create) | **POST** /api/Organisations/{id}/TermsAndConditions | Adds new Terms and Conditions to your Organisations T/C Library.
*OrganisationsApi* | [**terms_and_conditions_read**](docs/OrganisationsApi.md#terms_and_conditions_read) | **GET** /api/Organisations/{id}/TermsAndConditions | Get&#39;s a list of an Organisation&#39;s Terms and Conditions.
*SearchApi* | [**search_search_amphorae**](docs/SearchApi.md#search_search_amphorae) | **POST** /api/search/amphorae | Searches for Amphorae.
*SearchApi* | [**search_search_amphorae_by_location**](docs/SearchApi.md#search_search_amphorae_by_location) | **GET** /api/search/amphorae/byLocation | Searches for Amphorae by loction.
*SearchApi* | [**search_search_amphorae_by_organisation**](docs/SearchApi.md#search_search_amphorae_by_organisation) | **GET** /api/search/amphorae/byOrganisation | Searches for Amphorae in an Organisation.
*SearchApi* | [**search_search_organisations**](docs/SearchApi.md#search_search_organisations) | **GET** /api/search/organisations | Searches for Organisations with fuzzy search.
*TimeSeriesApi* | [**time_series_query_time_series**](docs/TimeSeriesApi.md#time_series_query_time_series) | **POST** /api/timeseries/query | Updates the details of an Amphora by Id.
*UsersApi* | [**users_create**](docs/UsersApi.md#users_create) | **POST** /api/users | Creates a new User. Returns the password.
*UsersApi* | [**users_read_self**](docs/UsersApi.md#users_read_self) | **GET** /api/users/self | Get&#39;s logged in users information.
*VersionApi* | [**version_get_current_version**](docs/VersionApi.md#version_get_current_version) | **GET** /api/version | Get&#39;s the current server version.


## Documentation For Models

 - [AccessRuleDtoBase](docs/AccessRuleDtoBase.md)
 - [Account](docs/Account.md)
 - [Address](docs/Address.md)
 - [AggregateSeries](docs/AggregateSeries.md)
 - [AggregateVariable](docs/AggregateVariable.md)
 - [AmphoraUser](docs/AmphoraUser.md)
 - [AmphoraUserAllOf](docs/AmphoraUserAllOf.md)
 - [AttributeStore](docs/AttributeStore.md)
 - [BaseAmphoraUser](docs/BaseAmphoraUser.md)
 - [BasicAmphora](docs/BasicAmphora.md)
 - [BasicAmphoraAllOf](docs/BasicAmphoraAllOf.md)
 - [CategorySet](docs/CategorySet.md)
 - [Classification](docs/Classification.md)
 - [CreateAmphora](docs/CreateAmphora.md)
 - [CreateAmphoraAllOf](docs/CreateAmphoraAllOf.md)
 - [CreateAmphoraUser](docs/CreateAmphoraUser.md)
 - [CreateAmphoraUserAllOf](docs/CreateAmphoraUserAllOf.md)
 - [DateTimeRange](docs/DateTimeRange.md)
 - [DetailedAmphora](docs/DetailedAmphora.md)
 - [DetailedAmphoraAllOf](docs/DetailedAmphoraAllOf.md)
 - [EditAmphora](docs/EditAmphora.md)
 - [EditAmphoraAllOf](docs/EditAmphoraAllOf.md)
 - [Entity](docs/Entity.md)
 - [EntryPoint](docs/EntryPoint.md)
 - [EventProperty](docs/EventProperty.md)
 - [FuzzySearchResponse](docs/FuzzySearchResponse.md)
 - [GetEvents](docs/GetEvents.md)
 - [GetSeries](docs/GetSeries.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [Name](docs/Name.md)
 - [NumericVariable](docs/NumericVariable.md)
 - [Organisation](docs/Organisation.md)
 - [OrganisationAccessRule](docs/OrganisationAccessRule.md)
 - [OrganisationAccessRuleAllOf](docs/OrganisationAccessRuleAllOf.md)
 - [OrganisationAllOf](docs/OrganisationAllOf.md)
 - [PagedResponse](docs/PagedResponse.md)
 - [PlanInformation](docs/PlanInformation.md)
 - [PlanTypes](docs/PlanTypes.md)
 - [Poi](docs/Poi.md)
 - [Position](docs/Position.md)
 - [ProblemDetails](docs/ProblemDetails.md)
 - [PropertyValues](docs/PropertyValues.md)
 - [PropertyValuesAllOf](docs/PropertyValuesAllOf.md)
 - [QueryRequest](docs/QueryRequest.md)
 - [QueryResultPage](docs/QueryResultPage.md)
 - [QueryResultPageAllOf](docs/QueryResultPageAllOf.md)
 - [Result](docs/Result.md)
 - [SearchParameters](docs/SearchParameters.md)
 - [Signal](docs/Signal.md)
 - [Summary](docs/Summary.md)
 - [TermsAndConditions](docs/TermsAndConditions.md)
 - [Tsx](docs/Tsx.md)
 - [UpdateSignal](docs/UpdateSignal.md)
 - [UploadResponse](docs/UploadResponse.md)
 - [UserAccessRule](docs/UserAccessRule.md)
 - [UserAccessRuleAllOf](docs/UserAccessRuleAllOf.md)
 - [Variable](docs/Variable.md)
 - [Viewport](docs/Viewport.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author




