# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401
from typing import Any, Dict, Optional

from pydantic import (
    Field,
    StrictBool,
    StrictInt,
    StrictStr,
    ValidationError,
    conint,
    validate_arguments,
)
from typing_extensions import Annotated

from databricks_jobs.api_client import ApiClient
from databricks_jobs.exceptions import ApiTypeError, ApiValueError  # noqa: F401
from databricks_jobs.models.jobs_create200_response import JobsCreate200Response
from databricks_jobs.models.jobs_create_request import JobsCreateRequest
from databricks_jobs.models.jobs_delete_request import JobsDeleteRequest
from databricks_jobs.models.jobs_get200_response import JobsGet200Response
from databricks_jobs.models.jobs_list200_response import JobsList200Response
from databricks_jobs.models.jobs_reset_request import JobsResetRequest
from databricks_jobs.models.jobs_run_now200_response import JobsRunNow200Response
from databricks_jobs.models.jobs_run_now_request import JobsRunNowRequest
from databricks_jobs.models.jobs_runs_cancel_all_request import JobsRunsCancelAllRequest
from databricks_jobs.models.jobs_runs_cancel_request import JobsRunsCancelRequest
from databricks_jobs.models.jobs_runs_delete_request import JobsRunsDeleteRequest
from databricks_jobs.models.jobs_runs_export200_response import (
    JobsRunsExport200Response,
)
from databricks_jobs.models.jobs_runs_get200_response import JobsRunsGet200Response
from databricks_jobs.models.jobs_runs_get_output200_response import (
    JobsRunsGetOutput200Response,
)
from databricks_jobs.models.jobs_runs_list200_response import JobsRunsList200Response
from databricks_jobs.models.jobs_runs_repair200_response import (
    JobsRunsRepair200Response,
)
from databricks_jobs.models.jobs_runs_repair_request import JobsRunsRepairRequest
from databricks_jobs.models.jobs_runs_submit200_response import (
    JobsRunsSubmit200Response,
)
from databricks_jobs.models.jobs_runs_submit_request import JobsRunsSubmitRequest
from databricks_jobs.models.jobs_update_request import JobsUpdateRequest
from databricks_jobs.models.views_to_export import ViewsToExport


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def jobs_create(
        self, jobs_create_request: JobsCreateRequest, **kwargs
    ) -> JobsCreate200Response:  # noqa: E501
        """Create a new job  # noqa: E501

        Create a new job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_create(jobs_create_request, async_req=True)
        >>> result = thread.get()

        :param jobs_create_request: (required)
        :type jobs_create_request: JobsCreateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobsCreate200Response
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_create_with_http_info(
            jobs_create_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_create_with_http_info(
        self, jobs_create_request: JobsCreateRequest, **kwargs
    ):  # noqa: E501
        """Create a new job  # noqa: E501

        Create a new job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_create_with_http_info(jobs_create_request, async_req=True)
        >>> result = thread.get()

        :param jobs_create_request: (required)
        :type jobs_create_request: JobsCreateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobsCreate200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["jobs_create_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_create" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["jobs_create_request"]:
            _body_params = _params["jobs_create_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobsCreate200Response",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/create",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_delete(
        self, jobs_delete_request: JobsDeleteRequest, **kwargs
    ) -> object:  # noqa: E501
        """Delete a job  # noqa: E501

        Deletes a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_delete(jobs_delete_request, async_req=True)
        >>> result = thread.get()

        :param jobs_delete_request: (required)
        :type jobs_delete_request: JobsDeleteRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_delete_with_http_info(
            jobs_delete_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_delete_with_http_info(
        self, jobs_delete_request: JobsDeleteRequest, **kwargs
    ):  # noqa: E501
        """Delete a job  # noqa: E501

        Deletes a job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_delete_with_http_info(jobs_delete_request, async_req=True)
        >>> result = thread.get()

        :param jobs_delete_request: (required)
        :type jobs_delete_request: JobsDeleteRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["jobs_delete_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_delete" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["jobs_delete_request"]:
            _body_params = _params["jobs_delete_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "object",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/delete",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_get(
        self,
        job_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="The canonical identifier of the job to retrieve information about. This field is required.",
            ),
        ],
        **kwargs
    ) -> JobsGet200Response:  # noqa: E501
        """Get a single job  # noqa: E501

        Retrieves the details for a single job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_get(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The canonical identifier of the job to retrieve information about. This field is required. (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobsGet200Response
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_get_with_http_info(job_id, **kwargs)  # noqa: E501

    @validate_arguments
    def jobs_get_with_http_info(
        self,
        job_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="The canonical identifier of the job to retrieve information about. This field is required.",
            ),
        ],
        **kwargs
    ):  # noqa: E501
        """Get a single job  # noqa: E501

        Retrieves the details for a single job.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_get_with_http_info(job_id, async_req=True)
        >>> result = thread.get()

        :param job_id: The canonical identifier of the job to retrieve information about. This field is required. (required)
        :type job_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobsGet200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["job_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_get" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("job_id") is not None:  # noqa: E501
            _query_params.append(("job_id", _params["job_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobsGet200Response",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/get",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_list(
        self,
        limit: Annotated[
            Optional[conint(strict=True, le=25, ge=1)],
            Field(
                description="The number of jobs to return. This value must be greater than 0 and less or equal to 25. The default value is 20."
            ),
        ] = None,
        offset: Annotated[
            Optional[conint(strict=True, ge=0)],
            Field(
                description="The offset of the first job to return, relative to the most recently created job."
            ),
        ] = None,
        name: Annotated[
            Optional[StrictStr],
            Field(
                description="A filter on the list based on the exact (case insensitive) job name."
            ),
        ] = None,
        expand_tasks: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to include task and cluster details in the response."
            ),
        ] = None,
        **kwargs
    ) -> JobsList200Response:  # noqa: E501
        """List all jobs  # noqa: E501

        Retrieves a list of jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_list(limit, offset, name, expand_tasks, async_req=True)
        >>> result = thread.get()

        :param limit: The number of jobs to return. This value must be greater than 0 and less or equal to 25. The default value is 20.
        :type limit: int
        :param offset: The offset of the first job to return, relative to the most recently created job.
        :type offset: int
        :param name: A filter on the list based on the exact (case insensitive) job name.
        :type name: str
        :param expand_tasks: Whether to include task and cluster details in the response.
        :type expand_tasks: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobsList200Response
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_list_with_http_info(
            limit, offset, name, expand_tasks, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_list_with_http_info(
        self,
        limit: Annotated[
            Optional[conint(strict=True, le=25, ge=1)],
            Field(
                description="The number of jobs to return. This value must be greater than 0 and less or equal to 25. The default value is 20."
            ),
        ] = None,
        offset: Annotated[
            Optional[conint(strict=True, ge=0)],
            Field(
                description="The offset of the first job to return, relative to the most recently created job."
            ),
        ] = None,
        name: Annotated[
            Optional[StrictStr],
            Field(
                description="A filter on the list based on the exact (case insensitive) job name."
            ),
        ] = None,
        expand_tasks: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to include task and cluster details in the response."
            ),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """List all jobs  # noqa: E501

        Retrieves a list of jobs.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_list_with_http_info(limit, offset, name, expand_tasks, async_req=True)
        >>> result = thread.get()

        :param limit: The number of jobs to return. This value must be greater than 0 and less or equal to 25. The default value is 20.
        :type limit: int
        :param offset: The offset of the first job to return, relative to the most recently created job.
        :type offset: int
        :param name: A filter on the list based on the exact (case insensitive) job name.
        :type name: str
        :param expand_tasks: Whether to include task and cluster details in the response.
        :type expand_tasks: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobsList200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["limit", "offset", "name", "expand_tasks"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_list" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("name") is not None:  # noqa: E501
            _query_params.append(("name", _params["name"]))
        if _params.get("expand_tasks") is not None:  # noqa: E501
            _query_params.append(("expand_tasks", _params["expand_tasks"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobsList200Response",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/list",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_reset(
        self, jobs_reset_request: JobsResetRequest, **kwargs
    ) -> object:  # noqa: E501
        """Overwrites all settings for a job  # noqa: E501

        Overwrites all the settings for a specific job. Use the Update endpoint to update job settings partially.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_reset(jobs_reset_request, async_req=True)
        >>> result = thread.get()

        :param jobs_reset_request: (required)
        :type jobs_reset_request: JobsResetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_reset_with_http_info(
            jobs_reset_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_reset_with_http_info(
        self, jobs_reset_request: JobsResetRequest, **kwargs
    ):  # noqa: E501
        """Overwrites all settings for a job  # noqa: E501

        Overwrites all the settings for a specific job. Use the Update endpoint to update job settings partially.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_reset_with_http_info(jobs_reset_request, async_req=True)
        >>> result = thread.get()

        :param jobs_reset_request: (required)
        :type jobs_reset_request: JobsResetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["jobs_reset_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_reset" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["jobs_reset_request"]:
            _body_params = _params["jobs_reset_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "object",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/reset",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_run_now(
        self, jobs_run_now_request: JobsRunNowRequest, **kwargs
    ) -> JobsRunNow200Response:  # noqa: E501
        """Trigger a new job run  # noqa: E501

        Run a job and return the `run_id` of the triggered run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_run_now(jobs_run_now_request, async_req=True)
        >>> result = thread.get()

        :param jobs_run_now_request: (required)
        :type jobs_run_now_request: JobsRunNowRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobsRunNow200Response
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_run_now_with_http_info(
            jobs_run_now_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_run_now_with_http_info(
        self, jobs_run_now_request: JobsRunNowRequest, **kwargs
    ):  # noqa: E501
        """Trigger a new job run  # noqa: E501

        Run a job and return the `run_id` of the triggered run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_run_now_with_http_info(jobs_run_now_request, async_req=True)
        >>> result = thread.get()

        :param jobs_run_now_request: (required)
        :type jobs_run_now_request: JobsRunNowRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobsRunNow200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["jobs_run_now_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_run_now" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["jobs_run_now_request"]:
            _body_params = _params["jobs_run_now_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobsRunNow200Response",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/run-now",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_runs_cancel(
        self, jobs_runs_cancel_request: JobsRunsCancelRequest, **kwargs
    ) -> object:  # noqa: E501
        """Cancel a job run  # noqa: E501

        Cancels a job run. The run is canceled asynchronously, so it may still be running when this request completes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_cancel(jobs_runs_cancel_request, async_req=True)
        >>> result = thread.get()

        :param jobs_runs_cancel_request: (required)
        :type jobs_runs_cancel_request: JobsRunsCancelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_runs_cancel_with_http_info(
            jobs_runs_cancel_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_runs_cancel_with_http_info(
        self, jobs_runs_cancel_request: JobsRunsCancelRequest, **kwargs
    ):  # noqa: E501
        """Cancel a job run  # noqa: E501

        Cancels a job run. The run is canceled asynchronously, so it may still be running when this request completes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_cancel_with_http_info(jobs_runs_cancel_request, async_req=True)
        >>> result = thread.get()

        :param jobs_runs_cancel_request: (required)
        :type jobs_runs_cancel_request: JobsRunsCancelRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["jobs_runs_cancel_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_cancel" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["jobs_runs_cancel_request"]:
            _body_params = _params["jobs_runs_cancel_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "object",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/runs/cancel",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_runs_cancel_all(
        self, jobs_runs_cancel_all_request: JobsRunsCancelAllRequest, **kwargs
    ) -> object:  # noqa: E501
        """Cancel all runs of a job  # noqa: E501

        Cancels all active runs of a job. The runs are canceled asynchronously, so it doesn't prevent new runs from being started.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_cancel_all(jobs_runs_cancel_all_request, async_req=True)
        >>> result = thread.get()

        :param jobs_runs_cancel_all_request: (required)
        :type jobs_runs_cancel_all_request: JobsRunsCancelAllRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_runs_cancel_all_with_http_info(
            jobs_runs_cancel_all_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_runs_cancel_all_with_http_info(
        self, jobs_runs_cancel_all_request: JobsRunsCancelAllRequest, **kwargs
    ):  # noqa: E501
        """Cancel all runs of a job  # noqa: E501

        Cancels all active runs of a job. The runs are canceled asynchronously, so it doesn't prevent new runs from being started.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_cancel_all_with_http_info(jobs_runs_cancel_all_request, async_req=True)
        >>> result = thread.get()

        :param jobs_runs_cancel_all_request: (required)
        :type jobs_runs_cancel_all_request: JobsRunsCancelAllRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["jobs_runs_cancel_all_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_cancel_all" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["jobs_runs_cancel_all_request"]:
            _body_params = _params["jobs_runs_cancel_all_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "object",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/runs/cancel-all",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_runs_delete(
        self, jobs_runs_delete_request: JobsRunsDeleteRequest, **kwargs
    ) -> object:  # noqa: E501
        """Delete a job run  # noqa: E501

        Deletes a non-active run. Returns an error if the run is active.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_delete(jobs_runs_delete_request, async_req=True)
        >>> result = thread.get()

        :param jobs_runs_delete_request: (required)
        :type jobs_runs_delete_request: JobsRunsDeleteRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_runs_delete_with_http_info(
            jobs_runs_delete_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_runs_delete_with_http_info(
        self, jobs_runs_delete_request: JobsRunsDeleteRequest, **kwargs
    ):  # noqa: E501
        """Delete a job run  # noqa: E501

        Deletes a non-active run. Returns an error if the run is active.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_delete_with_http_info(jobs_runs_delete_request, async_req=True)
        >>> result = thread.get()

        :param jobs_runs_delete_request: (required)
        :type jobs_runs_delete_request: JobsRunsDeleteRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["jobs_runs_delete_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_delete" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["jobs_runs_delete_request"]:
            _body_params = _params["jobs_runs_delete_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "object",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/runs/delete",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_runs_export(
        self,
        run_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="The canonical identifier for the run. This field is required.",
            ),
        ],
        views_to_export: Annotated[
            Optional[ViewsToExport],
            Field(
                description="Which views to export (CODE, DASHBOARDS, or ALL). Defaults to CODE."
            ),
        ] = None,
        **kwargs
    ) -> JobsRunsExport200Response:  # noqa: E501
        """Export and retrieve a job run  # noqa: E501

        Export and retrieve the job run task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_export(run_id, views_to_export, async_req=True)
        >>> result = thread.get()

        :param run_id: The canonical identifier for the run. This field is required. (required)
        :type run_id: int
        :param views_to_export: Which views to export (CODE, DASHBOARDS, or ALL). Defaults to CODE.
        :type views_to_export: ViewsToExport
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobsRunsExport200Response
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_runs_export_with_http_info(
            run_id, views_to_export, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_runs_export_with_http_info(
        self,
        run_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="The canonical identifier for the run. This field is required.",
            ),
        ],
        views_to_export: Annotated[
            Optional[ViewsToExport],
            Field(
                description="Which views to export (CODE, DASHBOARDS, or ALL). Defaults to CODE."
            ),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Export and retrieve a job run  # noqa: E501

        Export and retrieve the job run task.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_export_with_http_info(run_id, views_to_export, async_req=True)
        >>> result = thread.get()

        :param run_id: The canonical identifier for the run. This field is required. (required)
        :type run_id: int
        :param views_to_export: Which views to export (CODE, DASHBOARDS, or ALL). Defaults to CODE.
        :type views_to_export: ViewsToExport
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobsRunsExport200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["run_id", "views_to_export"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_export" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("run_id") is not None:  # noqa: E501
            _query_params.append(("run_id", _params["run_id"]))
        if _params.get("views_to_export") is not None:  # noqa: E501
            _query_params.append(("views_to_export", _params["views_to_export"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobsRunsExport200Response",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.0/jobs/runs/export",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_runs_get(
        self,
        run_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="The canonical identifier of the run for which to retrieve the metadata. This field is required.",
            ),
        ],
        include_history: Annotated[
            Optional[StrictBool],
            Field(description="Whether to include the repair history in the response."),
        ] = None,
        **kwargs
    ) -> JobsRunsGet200Response:  # noqa: E501
        """Get a single job run  # noqa: E501

        Retrieve the metadata of a run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_get(run_id, include_history, async_req=True)
        >>> result = thread.get()

        :param run_id: The canonical identifier of the run for which to retrieve the metadata. This field is required. (required)
        :type run_id: int
        :param include_history: Whether to include the repair history in the response.
        :type include_history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobsRunsGet200Response
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_runs_get_with_http_info(
            run_id, include_history, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_runs_get_with_http_info(
        self,
        run_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="The canonical identifier of the run for which to retrieve the metadata. This field is required.",
            ),
        ],
        include_history: Annotated[
            Optional[StrictBool],
            Field(description="Whether to include the repair history in the response."),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """Get a single job run  # noqa: E501

        Retrieve the metadata of a run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_get_with_http_info(run_id, include_history, async_req=True)
        >>> result = thread.get()

        :param run_id: The canonical identifier of the run for which to retrieve the metadata. This field is required. (required)
        :type run_id: int
        :param include_history: Whether to include the repair history in the response.
        :type include_history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobsRunsGet200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["run_id", "include_history"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_get" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("run_id") is not None:  # noqa: E501
            _query_params.append(("run_id", _params["run_id"]))
        if _params.get("include_history") is not None:  # noqa: E501
            _query_params.append(("include_history", _params["include_history"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobsRunsGet200Response",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/runs/get",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_runs_get_output(
        self,
        run_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="The canonical identifier for the run. This field is required.",
            ),
        ],
        **kwargs
    ) -> JobsRunsGetOutput200Response:  # noqa: E501
        """Get the output for a single run  # noqa: E501

        Retrieve the output and metadata of a single task run. When a notebook task returns a value through the dbutils.notebook.exit() call, you can use this endpoint to retrieve that value. Azure Databricks restricts this API to return the first 5 MB of the output. To return a larger result, you can store job results in a cloud storage service. This endpoint validates that the run_id parameter is valid and returns an HTTP status code 400 if the run_id parameter is invalid. Runs are automatically removed after 60 days. If you to want to reference them beyond 60 days, you must save old run results before they expire. To export using the UI, see Export job run results. To export using the Jobs API, see Runs export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_get_output(run_id, async_req=True)
        >>> result = thread.get()

        :param run_id: The canonical identifier for the run. This field is required. (required)
        :type run_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobsRunsGetOutput200Response
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_runs_get_output_with_http_info(run_id, **kwargs)  # noqa: E501

    @validate_arguments
    def jobs_runs_get_output_with_http_info(
        self,
        run_id: Annotated[
            StrictInt,
            Field(
                ...,
                description="The canonical identifier for the run. This field is required.",
            ),
        ],
        **kwargs
    ):  # noqa: E501
        """Get the output for a single run  # noqa: E501

        Retrieve the output and metadata of a single task run. When a notebook task returns a value through the dbutils.notebook.exit() call, you can use this endpoint to retrieve that value. Azure Databricks restricts this API to return the first 5 MB of the output. To return a larger result, you can store job results in a cloud storage service. This endpoint validates that the run_id parameter is valid and returns an HTTP status code 400 if the run_id parameter is invalid. Runs are automatically removed after 60 days. If you to want to reference them beyond 60 days, you must save old run results before they expire. To export using the UI, see Export job run results. To export using the Jobs API, see Runs export.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_get_output_with_http_info(run_id, async_req=True)
        >>> result = thread.get()

        :param run_id: The canonical identifier for the run. This field is required. (required)
        :type run_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobsRunsGetOutput200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["run_id"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_get_output" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("run_id") is not None:  # noqa: E501
            _query_params.append(("run_id", _params["run_id"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobsRunsGetOutput200Response",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/runs/get-output",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_runs_list(
        self,
        active_only: Annotated[
            Optional[StrictBool],
            Field(
                description="If active_only is `true`, only active runs are included in the results; otherwise, lists both active and completed runs. An active run is a run in the `PENDING`, `RUNNING`, or `TERMINATING`. This field cannot be `true` when completed_only is `true`."
            ),
        ] = None,
        completed_only: Annotated[
            Optional[StrictBool],
            Field(
                description="If completed_only is `true`, only completed runs are included in the results; otherwise, lists both active and completed runs. This field cannot be `true` when active_only is `true`."
            ),
        ] = None,
        job_id: Annotated[
            Optional[StrictInt],
            Field(
                description="The job for which to list runs. If omitted, the Jobs service lists runs from all jobs."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the first run to return, relative to the most recent run."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=25, ge=1)],
            Field(
                description="The number of runs to return. This value must be greater than 0 and less than 25\\. The default value is 25\\. If a request specifies a limit of 0, the service instead uses the maximum limit."
            ),
        ] = None,
        run_type: Annotated[
            Optional[StrictStr],
            Field(
                description="The type of runs to return. For a description of run types, see [Run](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/jobs#operation/JobsRunsGet)."
            ),
        ] = None,
        expand_tasks: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to include task and cluster details in the response."
            ),
        ] = None,
        start_time_from: Annotated[
            Optional[StrictInt],
            Field(
                description="Show runs that started _at or after_ this value. The value must be a UTC timestamp in milliseconds. Can be combined with _start_time_to_ to filter by a time range."
            ),
        ] = None,
        start_time_to: Annotated[
            Optional[StrictInt],
            Field(
                description="Show runs that started _at or before_ this value. The value must be a UTC timestamp in milliseconds. Can be combined with _start_time_from_ to filter by a time range."
            ),
        ] = None,
        **kwargs
    ) -> JobsRunsList200Response:  # noqa: E501
        """List runs for a job  # noqa: E501

        List runs in descending order by start time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_list(active_only, completed_only, job_id, offset, limit, run_type, expand_tasks, start_time_from, start_time_to, async_req=True)
        >>> result = thread.get()

        :param active_only: If active_only is `true`, only active runs are included in the results; otherwise, lists both active and completed runs. An active run is a run in the `PENDING`, `RUNNING`, or `TERMINATING`. This field cannot be `true` when completed_only is `true`.
        :type active_only: bool
        :param completed_only: If completed_only is `true`, only completed runs are included in the results; otherwise, lists both active and completed runs. This field cannot be `true` when active_only is `true`.
        :type completed_only: bool
        :param job_id: The job for which to list runs. If omitted, the Jobs service lists runs from all jobs.
        :type job_id: int
        :param offset: The offset of the first run to return, relative to the most recent run.
        :type offset: int
        :param limit: The number of runs to return. This value must be greater than 0 and less than 25\\. The default value is 25\\. If a request specifies a limit of 0, the service instead uses the maximum limit.
        :type limit: int
        :param run_type: The type of runs to return. For a description of run types, see [Run](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/jobs#operation/JobsRunsGet).
        :type run_type: str
        :param expand_tasks: Whether to include task and cluster details in the response.
        :type expand_tasks: bool
        :param start_time_from: Show runs that started _at or after_ this value. The value must be a UTC timestamp in milliseconds. Can be combined with _start_time_to_ to filter by a time range.
        :type start_time_from: int
        :param start_time_to: Show runs that started _at or before_ this value. The value must be a UTC timestamp in milliseconds. Can be combined with _start_time_from_ to filter by a time range.
        :type start_time_to: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobsRunsList200Response
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_runs_list_with_http_info(
            active_only,
            completed_only,
            job_id,
            offset,
            limit,
            run_type,
            expand_tasks,
            start_time_from,
            start_time_to,
            **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_runs_list_with_http_info(
        self,
        active_only: Annotated[
            Optional[StrictBool],
            Field(
                description="If active_only is `true`, only active runs are included in the results; otherwise, lists both active and completed runs. An active run is a run in the `PENDING`, `RUNNING`, or `TERMINATING`. This field cannot be `true` when completed_only is `true`."
            ),
        ] = None,
        completed_only: Annotated[
            Optional[StrictBool],
            Field(
                description="If completed_only is `true`, only completed runs are included in the results; otherwise, lists both active and completed runs. This field cannot be `true` when active_only is `true`."
            ),
        ] = None,
        job_id: Annotated[
            Optional[StrictInt],
            Field(
                description="The job for which to list runs. If omitted, the Jobs service lists runs from all jobs."
            ),
        ] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description="The offset of the first run to return, relative to the most recent run."
            ),
        ] = None,
        limit: Annotated[
            Optional[conint(strict=True, le=25, ge=1)],
            Field(
                description="The number of runs to return. This value must be greater than 0 and less than 25\\. The default value is 25\\. If a request specifies a limit of 0, the service instead uses the maximum limit."
            ),
        ] = None,
        run_type: Annotated[
            Optional[StrictStr],
            Field(
                description="The type of runs to return. For a description of run types, see [Run](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/jobs#operation/JobsRunsGet)."
            ),
        ] = None,
        expand_tasks: Annotated[
            Optional[StrictBool],
            Field(
                description="Whether to include task and cluster details in the response."
            ),
        ] = None,
        start_time_from: Annotated[
            Optional[StrictInt],
            Field(
                description="Show runs that started _at or after_ this value. The value must be a UTC timestamp in milliseconds. Can be combined with _start_time_to_ to filter by a time range."
            ),
        ] = None,
        start_time_to: Annotated[
            Optional[StrictInt],
            Field(
                description="Show runs that started _at or before_ this value. The value must be a UTC timestamp in milliseconds. Can be combined with _start_time_from_ to filter by a time range."
            ),
        ] = None,
        **kwargs
    ):  # noqa: E501
        """List runs for a job  # noqa: E501

        List runs in descending order by start time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_list_with_http_info(active_only, completed_only, job_id, offset, limit, run_type, expand_tasks, start_time_from, start_time_to, async_req=True)
        >>> result = thread.get()

        :param active_only: If active_only is `true`, only active runs are included in the results; otherwise, lists both active and completed runs. An active run is a run in the `PENDING`, `RUNNING`, or `TERMINATING`. This field cannot be `true` when completed_only is `true`.
        :type active_only: bool
        :param completed_only: If completed_only is `true`, only completed runs are included in the results; otherwise, lists both active and completed runs. This field cannot be `true` when active_only is `true`.
        :type completed_only: bool
        :param job_id: The job for which to list runs. If omitted, the Jobs service lists runs from all jobs.
        :type job_id: int
        :param offset: The offset of the first run to return, relative to the most recent run.
        :type offset: int
        :param limit: The number of runs to return. This value must be greater than 0 and less than 25\\. The default value is 25\\. If a request specifies a limit of 0, the service instead uses the maximum limit.
        :type limit: int
        :param run_type: The type of runs to return. For a description of run types, see [Run](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/jobs#operation/JobsRunsGet).
        :type run_type: str
        :param expand_tasks: Whether to include task and cluster details in the response.
        :type expand_tasks: bool
        :param start_time_from: Show runs that started _at or after_ this value. The value must be a UTC timestamp in milliseconds. Can be combined with _start_time_to_ to filter by a time range.
        :type start_time_from: int
        :param start_time_to: Show runs that started _at or before_ this value. The value must be a UTC timestamp in milliseconds. Can be combined with _start_time_from_ to filter by a time range.
        :type start_time_to: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobsRunsList200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            "active_only",
            "completed_only",
            "job_id",
            "offset",
            "limit",
            "run_type",
            "expand_tasks",
            "start_time_from",
            "start_time_to",
        ]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_list" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get("active_only") is not None:  # noqa: E501
            _query_params.append(("active_only", _params["active_only"]))
        if _params.get("completed_only") is not None:  # noqa: E501
            _query_params.append(("completed_only", _params["completed_only"]))
        if _params.get("job_id") is not None:  # noqa: E501
            _query_params.append(("job_id", _params["job_id"]))
        if _params.get("offset") is not None:  # noqa: E501
            _query_params.append(("offset", _params["offset"]))
        if _params.get("limit") is not None:  # noqa: E501
            _query_params.append(("limit", _params["limit"]))
        if _params.get("run_type") is not None:  # noqa: E501
            _query_params.append(("run_type", _params["run_type"]))
        if _params.get("expand_tasks") is not None:  # noqa: E501
            _query_params.append(("expand_tasks", _params["expand_tasks"]))
        if _params.get("start_time_from") is not None:  # noqa: E501
            _query_params.append(("start_time_from", _params["start_time_from"]))
        if _params.get("start_time_to") is not None:  # noqa: E501
            _query_params.append(("start_time_to", _params["start_time_to"]))

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobsRunsList200Response",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/runs/list",
            "GET",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_runs_repair(
        self, jobs_runs_repair_request: JobsRunsRepairRequest, **kwargs
    ) -> JobsRunsRepair200Response:  # noqa: E501
        """Repair a job run  # noqa: E501

        Re-run one or more tasks. Tasks are re-run as part of the original job run, use the current job and task settings, and can be viewed in the history for the original job run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_repair(jobs_runs_repair_request, async_req=True)
        >>> result = thread.get()

        :param jobs_runs_repair_request: (required)
        :type jobs_runs_repair_request: JobsRunsRepairRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobsRunsRepair200Response
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_runs_repair_with_http_info(
            jobs_runs_repair_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_runs_repair_with_http_info(
        self, jobs_runs_repair_request: JobsRunsRepairRequest, **kwargs
    ):  # noqa: E501
        """Repair a job run  # noqa: E501

        Re-run one or more tasks. Tasks are re-run as part of the original job run, use the current job and task settings, and can be viewed in the history for the original job run.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_repair_with_http_info(jobs_runs_repair_request, async_req=True)
        >>> result = thread.get()

        :param jobs_runs_repair_request: (required)
        :type jobs_runs_repair_request: JobsRunsRepairRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobsRunsRepair200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["jobs_runs_repair_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_repair" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["jobs_runs_repair_request"]:
            _body_params = _params["jobs_runs_repair_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobsRunsRepair200Response",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/runs/repair",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_runs_submit(
        self, jobs_runs_submit_request: JobsRunsSubmitRequest, **kwargs
    ) -> JobsRunsSubmit200Response:  # noqa: E501
        """Create and trigger a one-time run  # noqa: E501

        Submit a one-time run. This endpoint allows you to submit a workload directly without creating a job. Use the `jobs/runs/get` API to check the run state after the job is submitted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_submit(jobs_runs_submit_request, async_req=True)
        >>> result = thread.get()

        :param jobs_runs_submit_request: (required)
        :type jobs_runs_submit_request: JobsRunsSubmitRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: JobsRunsSubmit200Response
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_runs_submit_with_http_info(
            jobs_runs_submit_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_runs_submit_with_http_info(
        self, jobs_runs_submit_request: JobsRunsSubmitRequest, **kwargs
    ):  # noqa: E501
        """Create and trigger a one-time run  # noqa: E501

        Submit a one-time run. This endpoint allows you to submit a workload directly without creating a job. Use the `jobs/runs/get` API to check the run state after the job is submitted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_runs_submit_with_http_info(jobs_runs_submit_request, async_req=True)
        >>> result = thread.get()

        :param jobs_runs_submit_request: (required)
        :type jobs_runs_submit_request: JobsRunsSubmitRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(JobsRunsSubmit200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["jobs_runs_submit_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_runs_submit" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["jobs_runs_submit_request"]:
            _body_params = _params["jobs_runs_submit_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "JobsRunsSubmit200Response",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/runs/submit",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )

    @validate_arguments
    def jobs_update(
        self, jobs_update_request: JobsUpdateRequest, **kwargs
    ) -> object:  # noqa: E501
        """Partially updates a job  # noqa: E501

        Add, update, or remove specific settings of an existing job. Use the Reset endpoint to overwrite all job settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_update(jobs_update_request, async_req=True)
        >>> result = thread.get()

        :param jobs_update_request: (required)
        :type jobs_update_request: JobsUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: object
        """
        kwargs["_return_http_data_only"] = True
        return self.jobs_update_with_http_info(
            jobs_update_request, **kwargs
        )  # noqa: E501

    @validate_arguments
    def jobs_update_with_http_info(
        self, jobs_update_request: JobsUpdateRequest, **kwargs
    ):  # noqa: E501
        """Partially updates a job  # noqa: E501

        Add, update, or remove specific settings of an existing job. Use the Reset endpoint to overwrite all job settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.jobs_update_with_http_info(jobs_update_request, async_req=True)
        >>> result = thread.get()

        :param jobs_update_request: (required)
        :type jobs_update_request: JobsUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(object, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ["jobs_update_request"]
        _all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
                "_request_auth",
                "_content_type",
                "_headers",
            ]
        )

        # validate the arguments
        for _key, _val in _params["kwargs"].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method jobs_update" % _key
                )
            _params[_key] = _val
        del _params["kwargs"]

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get("_headers", {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params["jobs_update_request"]:
            _body_params = _params["jobs_update_request"]

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            "_content_type",
            self.api_client.select_header_content_type(["application/json"]),
        )
        if _content_types_list:
            _header_params["Content-Type"] = _content_types_list

        # authentication setting
        _auth_settings = ["bearerAuth"]  # noqa: E501

        _response_types_map = {
            "200": "object",
            "400": "Error",
            "401": "Error",
            "500": "Error",
        }

        return self.api_client.call_api(
            "/2.1/jobs/update",
            "POST",
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get("async_req"),
            _return_http_data_only=_params.get("_return_http_data_only"),  # noqa: E501
            _preload_content=_params.get("_preload_content", True),
            _request_timeout=_params.get("_request_timeout"),
            collection_formats=_collection_formats,
            _request_auth=_params.get("_request_auth"),
        )
