# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, validator


class AzureAttributes(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    first_on_demand: Optional[StrictInt] = Field(
        None,
        description="The first `first_on_demand` nodes of the cluster are placed on on-demand instances. This value must be greater than 0, or else cluster creation validation fails. If this value is greater than or equal to the current cluster size, all nodes are placed on on-demand instances. If this value is less than the current cluster size, `first_on_demand` nodes are placed on on-demand instances and the remainder are placed on availability instances. This value does not affect cluster size and cannot be mutated over the lifetime of a cluster.",
    )
    availability: Optional[StrictStr] = Field(
        None,
        description="Availability type used for all subsequent nodes past the `first_on_demand` ones.  `SPOT_AZURE`: use spot instances. `ON_DEMAND_AZURE`: use on demand instances. `SPOT_WITH_FALLBACK_AZURE`: preferably use spot instances, but fall back to on-demand instances if spot instances cannot be acquired (for example, if Azure spot prices are too high or out of quota). Does not apply to pool availability.",
    )
    spot_bid_max_price: Optional[StrictFloat] = Field(
        None,
        description="The max bid price used for Azure spot instances. You can set this to greater than or equal to the current spot price. You can also set this to -1 (the default), which specifies that the instance cannot be evicted on the basis of price. The price for the instance is the current price for spot instances or the price for a standard instance. You can view historical pricing and eviction rates in the Azure portal.",
    )
    __properties = ["first_on_demand", "availability", "spot_bid_max_price"]

    @validator("availability")
    def availability_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("SPOT_AZURE", "ON_DEMAND_AZURE", "SPOT_WITH_FALLBACK_AZURE"):
            raise ValueError(
                "must validate the enum values ('SPOT_AZURE', 'ON_DEMAND_AZURE', 'SPOT_WITH_FALLBACK_AZURE')"
            )
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AzureAttributes:
        """Create an instance of AzureAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AzureAttributes:
        """Create an instance of AzureAttributes from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AzureAttributes.parse_obj(obj)

        _obj = AzureAttributes.parse_obj(
            {
                "first_on_demand": obj.get("first_on_demand"),
                "availability": obj.get("availability"),
                "spot_bid_max_price": obj.get("spot_bid_max_price"),
            }
        )
        return _obj
