# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr

from databricks_jobs.models.aws_attributes import AwsAttributes
from databricks_jobs.models.azure_attributes import AzureAttributes
from databricks_jobs.models.cluster_log_conf import ClusterLogConf
from databricks_jobs.models.cluster_source import ClusterSource
from databricks_jobs.models.docker_image import DockerImage
from databricks_jobs.models.gcp_attributes import GcpAttributes
from databricks_jobs.models.init_script_info import InitScriptInfo


class ClusterAttributes(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    cluster_name: Optional[StrictStr] = Field(
        None,
        description="Cluster name requested by the user. This doesn’t have to be unique. If not specified at creation, the cluster name is an empty string.",
    )
    spark_version: Optional[StrictStr] = Field(
        None,
        description="The runtime version of the cluster, for example “5.0.x-scala2.11”. You can retrieve a list of available runtime versions by using the [Runtime versions](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/clusters#runtime-versions) API call.",
    )
    spark_conf: Optional[Dict[str, Any]] = Field(
        None,
        description="An arbitrary object where the object key is a configuration propery name and the value is a configuration property value.",
    )
    aws_attributes: Optional[AwsAttributes] = None
    node_type_id: Optional[StrictStr] = Field(
        None,
        description="This field encodes, through a single value, the resources available to each of the Spark nodes in this cluster. For example, the Spark nodes can be provisioned and optimized for memory or compute intensive workloads A list of available node types can be retrieved by using the [List node types](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/clusters#list-node-types) API call.",
    )
    driver_node_type_id: Optional[StrictStr] = Field(
        None,
        description="The node type of the Spark driver. This field is optional; if unset, the driver node type is set as the same value as `node_type_id` defined above.",
    )
    ssh_public_keys: Optional[List[StrictStr]] = None
    custom_tags: Optional[Dict[str, StrictStr]] = Field(
        None,
        description="An object with key value pairs. The key length must be between 1 and 127 UTF-8 characters, inclusive. The value length must be less than or equal to 255 UTF-8 characters.",
    )
    cluster_log_conf: Optional[ClusterLogConf] = None
    init_scripts: Optional[List[InitScriptInfo]] = Field(
        None,
        description="The configuration for storing init scripts. Any number of destinations can be specified. The scripts are executed sequentially in the order provided. If `cluster_log_conf` is specified, init script logs are sent to `<destination>/<cluster-ID>/init_scripts`.",
    )
    docker_image: Optional[DockerImage] = None
    runtime_engine: Optional[StrictStr] = Field(
        None,
        description="The type of runtime engine to use. If not specified, the runtime engine type is inferred based on the `spark_version` value. Allowed values include  * `PHOTON`: Use the Photon runtime engine type. * `STANDARD`: Use the standard runtime engine type.  This field is optional.",
    )
    spark_env_vars: Optional[Dict[str, Any]] = Field(
        None,
        description="An arbitrary object where the object key is an environment variable name and the value is an environment variable value.",
    )
    autotermination_minutes: Optional[StrictInt] = Field(
        None,
        description="Automatically terminates the cluster after it is inactive for this time in minutes. If not set, this cluster is not be automatically terminated. If specified, the threshold must be between 10 and 10000 minutes. You can also set this value to 0 to explicitly disable automatic termination.",
    )
    enable_elastic_disk: Optional[StrictBool] = Field(
        None,
        description="Autoscaling Local Storage: when enabled, this cluster dynamically acquires additional disk space when its Spark workers are running low on disk space.null Refer to [Autoscaling local storage](https://docs.microsoft.com/azure/databricks/clusters/configure#autoscaling-local-storage) for details.",
    )
    instance_pool_id: Optional[StrictStr] = Field(
        None,
        description="The optional ID of the instance pool to which the cluster belongs. Refer to [Pools](https://docs.microsoft.com/azure/databricks/clusters/pools) for details.",
    )
    cluster_source: Optional[ClusterSource] = None
    policy_id: Optional[StrictStr] = Field(
        None,
        description="A [cluster policy](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/policies) ID.",
    )
    enable_local_disk_encryption: Optional[StrictBool] = Field(
        None,
        description="Determines whether encryption of the disks attached to the cluster locally is enabled.",
    )
    gcp_attributes: Optional[GcpAttributes] = None
    azure_attributes: Optional[AzureAttributes] = None
    __properties = [
        "cluster_name",
        "spark_version",
        "spark_conf",
        "aws_attributes",
        "node_type_id",
        "driver_node_type_id",
        "ssh_public_keys",
        "custom_tags",
        "cluster_log_conf",
        "init_scripts",
        "docker_image",
        "runtime_engine",
        "spark_env_vars",
        "autotermination_minutes",
        "enable_elastic_disk",
        "instance_pool_id",
        "cluster_source",
        "policy_id",
        "enable_local_disk_encryption",
        "gcp_attributes",
        "azure_attributes",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ClusterAttributes:
        """Create an instance of ClusterAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of aws_attributes
        if self.aws_attributes:
            _dict["aws_attributes"] = self.aws_attributes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cluster_log_conf
        if self.cluster_log_conf:
            _dict["cluster_log_conf"] = self.cluster_log_conf.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in init_scripts (list)
        _items = []
        if self.init_scripts:
            for _item in self.init_scripts:
                if _item:
                    _items.append(_item.to_dict())
            _dict["init_scripts"] = _items
        # override the default output from pydantic by calling `to_dict()` of docker_image
        if self.docker_image:
            _dict["docker_image"] = self.docker_image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gcp_attributes
        if self.gcp_attributes:
            _dict["gcp_attributes"] = self.gcp_attributes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of azure_attributes
        if self.azure_attributes:
            _dict["azure_attributes"] = self.azure_attributes.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ClusterAttributes:
        """Create an instance of ClusterAttributes from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ClusterAttributes.parse_obj(obj)

        _obj = ClusterAttributes.parse_obj(
            {
                "cluster_name": obj.get("cluster_name"),
                "spark_version": obj.get("spark_version"),
                "spark_conf": obj.get("spark_conf"),
                "aws_attributes": AwsAttributes.from_dict(obj.get("aws_attributes"))
                if obj.get("aws_attributes") is not None
                else None,
                "node_type_id": obj.get("node_type_id"),
                "driver_node_type_id": obj.get("driver_node_type_id"),
                "ssh_public_keys": obj.get("ssh_public_keys"),
                "custom_tags": obj.get("custom_tags"),
                "cluster_log_conf": ClusterLogConf.from_dict(
                    obj.get("cluster_log_conf")
                )
                if obj.get("cluster_log_conf") is not None
                else None,
                "init_scripts": [
                    InitScriptInfo.from_dict(_item) for _item in obj.get("init_scripts")
                ]
                if obj.get("init_scripts") is not None
                else None,
                "docker_image": DockerImage.from_dict(obj.get("docker_image"))
                if obj.get("docker_image") is not None
                else None,
                "runtime_engine": obj.get("runtime_engine"),
                "spark_env_vars": obj.get("spark_env_vars"),
                "autotermination_minutes": obj.get("autotermination_minutes"),
                "enable_elastic_disk": obj.get("enable_elastic_disk"),
                "instance_pool_id": obj.get("instance_pool_id"),
                "cluster_source": obj.get("cluster_source"),
                "policy_id": obj.get("policy_id"),
                "enable_local_disk_encryption": obj.get("enable_local_disk_encryption"),
                "gcp_attributes": GcpAttributes.from_dict(obj.get("gcp_attributes"))
                if obj.get("gcp_attributes") is not None
                else None,
                "azure_attributes": AzureAttributes.from_dict(
                    obj.get("azure_attributes")
                )
                if obj.get("azure_attributes") is not None
                else None,
            }
        )
        return _obj
