# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictStr

from databricks_jobs.models.library import Library
from databricks_jobs.models.new_cluster import NewCluster


class ClusterSpec(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    existing_cluster_id: Optional[StrictStr] = Field(
        None,
        description="If existing_cluster_id, the ID of an existing cluster that is used for all runs of this job. When running jobs on an existing cluster, you may need to manually restart the cluster if it stops responding. We suggest running jobs on new clusters for greater reliability.",
    )
    new_cluster: Optional[NewCluster] = None
    libraries: Optional[List[Library]] = Field(
        None,
        description="An optional list of libraries to be installed on the cluster that executes the job. The default value is an empty list.",
    )
    __properties = ["existing_cluster_id", "new_cluster", "libraries"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ClusterSpec:
        """Create an instance of ClusterSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of new_cluster
        if self.new_cluster:
            _dict["new_cluster"] = self.new_cluster.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in libraries (list)
        _items = []
        if self.libraries:
            for _item in self.libraries:
                if _item:
                    _items.append(_item.to_dict())
            _dict["libraries"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ClusterSpec:
        """Create an instance of ClusterSpec from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ClusterSpec.parse_obj(obj)

        _obj = ClusterSpec.parse_obj(
            {
                "existing_cluster_id": obj.get("existing_cluster_id"),
                "new_cluster": NewCluster.from_dict(obj.get("new_cluster"))
                if obj.get("new_cluster") is not None
                else None,
                "libraries": [
                    Library.from_dict(_item) for _item in obj.get("libraries")
                ]
                if obj.get("libraries") is not None
                else None,
            }
        )
        return _obj
