# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictStr, validator


class CronSchedule(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    quartz_cron_expression: StrictStr = Field(
        ...,
        description="A Cron expression using Quartz syntax that describes the schedule for a job. See [Cron Trigger](http://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html) for details. This field is required.",
    )
    timezone_id: StrictStr = Field(
        ...,
        description="A Java timezone ID. The schedule for a job is resolved with respect to this timezone. See [Java TimeZone](https://docs.oracle.com/javase/7/docs/api/java/util/TimeZone.html) for details. This field is required.",
    )
    pause_status: Optional[StrictStr] = Field(
        None, description="Indicate whether this schedule is paused or not."
    )
    __properties = ["quartz_cron_expression", "timezone_id", "pause_status"]

    @validator("pause_status")
    def pause_status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ("PAUSED", "UNPAUSED"):
            raise ValueError("must validate the enum values ('PAUSED', 'UNPAUSED')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CronSchedule:
        """Create an instance of CronSchedule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CronSchedule:
        """Create an instance of CronSchedule from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CronSchedule.parse_obj(obj)

        _obj = CronSchedule.parse_obj(
            {
                "quartz_cron_expression": obj.get("quartz_cron_expression"),
                "timezone_id": obj.get("timezone_id"),
                "pause_status": obj.get("pause_status"),
            }
        )
        return _obj
