# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictStr


class DbtTask(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    project_directory: Optional[StrictStr] = Field(
        None,
        description="Optional (relative) path to the project directory, if no value is provided, the root of the git repository is used.",
    )
    commands: List[StrictStr] = Field(
        ...,
        description="A list of dbt commands to execute. All commands must start with `dbt`. This parameter must not be empty. A maximum of up to 10 commands can be provided.",
    )
    var_schema: Optional[StrictStr] = Field(
        None,
        alias="schema",
        description="Optional schema to write to. This parameter is only used when a warehouse_id is also provided. If not provided, the `default` schema is used.",
    )
    warehouse_id: Optional[StrictStr] = Field(
        None,
        description="ID of the SQL warehouse to connect to. If provided, we automatically generate and provide the profile and connection details to dbt. It can be overridden on a per-command basis by using the `--profiles-dir` command line argument.",
    )
    catalog: Optional[StrictStr] = Field(
        None,
        description="Optional name of the catalog to use. The value is the top level in the 3-level namespace of Unity Catalog (catalog / schema / relation). The catalog value can only be specified if a warehouse_id is specified. Requires dbt-databricks >= 1.1.1.",
    )
    profiles_directory: Optional[StrictStr] = Field(
        None,
        description="Optional (relative) path to the profiles directory. Can only be specified if no warehouse_id is specified. If no warehouse_id is specified and this folder is unset, the root directory is used.",
    )
    __properties = [
        "project_directory",
        "commands",
        "schema",
        "warehouse_id",
        "catalog",
        "profiles_directory",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DbtTask:
        """Create an instance of DbtTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DbtTask:
        """Create an instance of DbtTask from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DbtTask.parse_obj(obj)

        _obj = DbtTask.parse_obj(
            {
                "project_directory": obj.get("project_directory"),
                "commands": obj.get("commands"),
                "var_schema": obj.get("schema"),
                "warehouse_id": obj.get("warehouse_id"),
                "catalog": obj.get("catalog"),
                "profiles_directory": obj.get("profiles_directory"),
            }
        )
        return _obj
