# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr

from databricks_jobs.models.azure_attributes import AzureAttributes
from databricks_jobs.models.cluster_size import ClusterSize
from databricks_jobs.models.resize_cause import ResizeCause
from databricks_jobs.models.termination_reason import TerminationReason


class EventDetails(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    current_num_workers: Optional[StrictInt] = Field(
        None, description="The number of nodes in the cluster."
    )
    target_num_workers: Optional[StrictInt] = Field(
        None, description="The targeted number of nodes in the cluster."
    )
    previous_attributes: Optional[AzureAttributes] = None
    attributes: Optional[AzureAttributes] = None
    previous_cluster_size: Optional[ClusterSize] = None
    cluster_size: Optional[ClusterSize] = None
    cause: Optional[ResizeCause] = None
    reason: Optional[TerminationReason] = None
    user: Optional[StrictStr] = Field(
        None,
        description="The user that caused the event to occur. (Empty if it was done by Azure Databricks.)",
    )
    __properties = [
        "current_num_workers",
        "target_num_workers",
        "previous_attributes",
        "attributes",
        "previous_cluster_size",
        "cluster_size",
        "cause",
        "reason",
        "user",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EventDetails:
        """Create an instance of EventDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of previous_attributes
        if self.previous_attributes:
            _dict["previous_attributes"] = self.previous_attributes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of attributes
        if self.attributes:
            _dict["attributes"] = self.attributes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of previous_cluster_size
        if self.previous_cluster_size:
            _dict["previous_cluster_size"] = self.previous_cluster_size.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cluster_size
        if self.cluster_size:
            _dict["cluster_size"] = self.cluster_size.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reason
        if self.reason:
            _dict["reason"] = self.reason.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EventDetails:
        """Create an instance of EventDetails from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EventDetails.parse_obj(obj)

        _obj = EventDetails.parse_obj(
            {
                "current_num_workers": obj.get("current_num_workers"),
                "target_num_workers": obj.get("target_num_workers"),
                "previous_attributes": AzureAttributes.from_dict(
                    obj.get("previous_attributes")
                )
                if obj.get("previous_attributes") is not None
                else None,
                "attributes": AzureAttributes.from_dict(obj.get("attributes"))
                if obj.get("attributes") is not None
                else None,
                "previous_cluster_size": ClusterSize.from_dict(
                    obj.get("previous_cluster_size")
                )
                if obj.get("previous_cluster_size") is not None
                else None,
                "cluster_size": ClusterSize.from_dict(obj.get("cluster_size"))
                if obj.get("cluster_size") is not None
                else None,
                "cause": obj.get("cause"),
                "reason": TerminationReason.from_dict(obj.get("reason"))
                if obj.get("reason") is not None
                else None,
                "user": obj.get("user"),
            }
        )
        return _obj
