# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, constr, validator

from databricks_jobs.models.new_cluster import NewCluster


class JobCluster(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    job_cluster_key: constr(strict=True, max_length=100, min_length=1) = Field(
        ...,
        description="A unique name for the job cluster. This field is required and must be unique within the job. `JobTaskSettings` may refer to this field to determine which cluster to launch for the task execution.",
    )
    new_cluster: Optional[NewCluster] = None
    __properties = ["job_cluster_key", "new_cluster"]

    @validator("job_cluster_key")
    def job_cluster_key_validate_regular_expression(cls, v):
        if not re.match(r"^[\w\-]+$", v):
            raise ValueError(r"must validate the regular expression /^[\w\-]+$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobCluster:
        """Create an instance of JobCluster from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of new_cluster
        if self.new_cluster:
            _dict["new_cluster"] = self.new_cluster.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobCluster:
        """Create an instance of JobCluster from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return JobCluster.parse_obj(obj)

        _obj = JobCluster.parse_obj(
            {
                "job_cluster_key": obj.get("job_cluster_key"),
                "new_cluster": NewCluster.from_dict(obj.get("new_cluster"))
                if obj.get("new_cluster") is not None
                else None,
            }
        )
        return _obj
