# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictBool, StrictStr


class JobEmailNotifications(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    on_start: Optional[List[StrictStr]] = Field(
        None,
        description="A list of email addresses to be notified when a run begins. If not specified on job creation, reset, or update, the list is empty, and notifications are not sent.",
    )
    on_success: Optional[List[StrictStr]] = Field(
        None,
        description="A list of email addresses to be notified when a run successfully completes. A run is considered to have completed successfully if it ends with a `TERMINATED` `life_cycle_state` and a `SUCCESSFUL` result_state. If not specified on job creation, reset, or update, the list is empty, and notifications are not sent.",
    )
    on_failure: Optional[List[StrictStr]] = Field(
        None,
        description="A list of email addresses to notify when a run completes unsuccessfully. A run is considered unsuccessful if it ends with an `INTERNAL_ERROR` `life_cycle_state` or a `SKIPPED`, `FAILED`, or `TIMED_OUT` `result_state`. If not specified on job creation, reset, or update, or the list is empty, then notifications are not sent. Job-level failure notifications are sent only once after the entire job run (including all of its retries) has failed. Notifications are not sent when failed job runs are retried. To receive a failure notification after every failed task (including every failed retry), use task-level notifications instead.",
    )
    no_alert_for_skipped_runs: Optional[StrictBool] = Field(
        None,
        description="If true, do not send email to recipients specified in `on_failure` if the run is skipped.",
    )
    __properties = ["on_start", "on_success", "on_failure", "no_alert_for_skipped_runs"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobEmailNotifications:
        """Create an instance of JobEmailNotifications from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobEmailNotifications:
        """Create an instance of JobEmailNotifications from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return JobEmailNotifications.parse_obj(obj)

        _obj = JobEmailNotifications.parse_obj(
            {
                "on_start": obj.get("on_start"),
                "on_success": obj.get("on_success"),
                "on_failure": obj.get("on_failure"),
                "no_alert_for_skipped_runs": obj.get("no_alert_for_skipped_runs"),
            }
        )
        return _obj
