# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr

from databricks_jobs.models.job_settings import JobSettings


class JobsGet200Response(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    job_id: Optional[StrictInt] = Field(
        None, description="The canonical identifier for this job."
    )
    creator_user_name: Optional[StrictStr] = Field(
        None,
        description="The creator user name. This field won’t be included in the response if the user has been deleted.",
    )
    run_as_user_name: Optional[StrictStr] = Field(
        None,
        description="The user name that the job runs as. `run_as_user_name` is based on the current job settings, and is set to the creator of the job if job access control is disabled, or the `is_owner` permission if job access control is enabled.",
    )
    settings: Optional[JobSettings] = None
    created_time: Optional[StrictInt] = Field(
        None,
        description="The time at which this job was created in epoch milliseconds (milliseconds since 1/1/1970 UTC).",
    )
    __properties = [
        "job_id",
        "creator_user_name",
        "run_as_user_name",
        "settings",
        "created_time",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobsGet200Response:
        """Create an instance of JobsGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of settings
        if self.settings:
            _dict["settings"] = self.settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobsGet200Response:
        """Create an instance of JobsGet200Response from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return JobsGet200Response.parse_obj(obj)

        _obj = JobsGet200Response.parse_obj(
            {
                "job_id": obj.get("job_id"),
                "creator_user_name": obj.get("creator_user_name"),
                "run_as_user_name": obj.get("run_as_user_name"),
                "settings": JobSettings.from_dict(obj.get("settings"))
                if obj.get("settings") is not None
                else None,
                "created_time": obj.get("created_time"),
            }
        )
        return _obj
