# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictBool

from databricks_jobs.models.run import Run


class JobsRunsList200Response(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    runs: Optional[List[Run]] = Field(
        None, description="A list of runs, from most recently started to least."
    )
    has_more: Optional[StrictBool] = Field(
        None,
        description="If true, additional runs matching the provided filter are available for listing.",
    )
    __properties = ["runs", "has_more"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobsRunsList200Response:
        """Create an instance of JobsRunsList200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in runs (list)
        _items = []
        if self.runs:
            for _item in self.runs:
                if _item:
                    _items.append(_item.to_dict())
            _dict["runs"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobsRunsList200Response:
        """Create an instance of JobsRunsList200Response from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return JobsRunsList200Response.parse_obj(obj)

        _obj = JobsRunsList200Response.parse_obj(
            {
                "runs": [Run.from_dict(_item) for _item in obj.get("runs")]
                if obj.get("runs") is not None
                else None,
                "has_more": obj.get("has_more"),
            }
        )
        return _obj
