# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr

from databricks_jobs.models.job_settings import JobSettings


class JobsUpdateRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    job_id: StrictInt = Field(
        ...,
        description="The canonical identifier of the job to update. This field is required.",
    )
    new_settings: Optional[JobSettings] = None
    fields_to_remove: Optional[List[StrictStr]] = Field(
        None,
        description="Remove top-level fields in the job settings. Removing nested fields is not supported. This field is optional.",
    )
    __properties = ["job_id", "new_settings", "fields_to_remove"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobsUpdateRequest:
        """Create an instance of JobsUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of new_settings
        if self.new_settings:
            _dict["new_settings"] = self.new_settings.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobsUpdateRequest:
        """Create an instance of JobsUpdateRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return JobsUpdateRequest.parse_obj(obj)

        _obj = JobsUpdateRequest.parse_obj(
            {
                "job_id": obj.get("job_id"),
                "new_settings": JobSettings.from_dict(obj.get("new_settings"))
                if obj.get("new_settings") is not None
                else None,
                "fields_to_remove": obj.get("fields_to_remove"),
            }
        )
        return _obj
