# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictBool, StrictStr

from databricks_jobs.models.library import Library
from databricks_jobs.models.library_install_status import LibraryInstallStatus


class LibraryFullStatus(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    library: Optional[Library] = None
    status: Optional[LibraryInstallStatus] = None
    messages: Optional[List[StrictStr]] = Field(
        None,
        description="All the info and warning messages that have occurred so far for this library.",
    )
    is_library_for_all_clusters: Optional[StrictBool] = Field(
        None,
        description="Whether the library was set to be installed on all clusters via the libraries UI.",
    )
    __properties = ["library", "status", "messages", "is_library_for_all_clusters"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LibraryFullStatus:
        """Create an instance of LibraryFullStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of library
        if self.library:
            _dict["library"] = self.library.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LibraryFullStatus:
        """Create an instance of LibraryFullStatus from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return LibraryFullStatus.parse_obj(obj)

        _obj = LibraryFullStatus.parse_obj(
            {
                "library": Library.from_dict(obj.get("library"))
                if obj.get("library") is not None
                else None,
                "status": obj.get("status"),
                "messages": obj.get("messages"),
                "is_library_for_all_clusters": obj.get("is_library_for_all_clusters"),
            }
        )
        return _obj
