# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr

from databricks_jobs.models.cluster_cloud_provider_node_info import (
    ClusterCloudProviderNodeInfo,
)


class NodeType(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    node_type_id: StrictStr = Field(
        ..., description="Unique identifier for this node type. This field is required."
    )
    memory_mb: StrictInt = Field(
        ...,
        description="Memory (in MB) available for this node type. This field is required.",
    )
    num_cores: Optional[StrictFloat] = Field(
        None,
        description="Number of CPU cores available for this node type. This can be fractional if the number of cores on a machine instance is not divisible by the number of Spark nodes on that machine. This field is required.",
    )
    description: StrictStr = Field(
        ...,
        description="A string description associated with this node type. This field is required.",
    )
    instance_type_id: StrictStr = Field(
        ...,
        description="An identifier for the type of hardware that this node runs on. This field is required.",
    )
    is_deprecated: Optional[StrictBool] = Field(
        None,
        description="Whether the node type is deprecated. Non-deprecated node types offer greater performance.",
    )
    node_info: Optional[ClusterCloudProviderNodeInfo] = None
    __properties = [
        "node_type_id",
        "memory_mb",
        "num_cores",
        "description",
        "instance_type_id",
        "is_deprecated",
        "node_info",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NodeType:
        """Create an instance of NodeType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of node_info
        if self.node_info:
            _dict["node_info"] = self.node_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NodeType:
        """Create an instance of NodeType from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return NodeType.parse_obj(obj)

        _obj = NodeType.parse_obj(
            {
                "node_type_id": obj.get("node_type_id"),
                "memory_mb": obj.get("memory_mb"),
                "num_cores": obj.get("num_cores"),
                "description": obj.get("description"),
                "instance_type_id": obj.get("instance_type_id"),
                "is_deprecated": obj.get("is_deprecated"),
                "node_info": ClusterCloudProviderNodeInfo.from_dict(
                    obj.get("node_info")
                )
                if obj.get("node_info") is not None
                else None,
            }
        )
        return _obj
