# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, Field, StrictStr


class PythonWheelTask(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    package_name: Optional[StrictStr] = Field(
        None, description="Name of the package to execute"
    )
    entry_point: Optional[StrictStr] = Field(
        None,
        description="Named entry point to use, if it does not exist in the metadata of the package it executes the function from the package directly using `$packageName.$entryPoint()`",
    )
    parameters: Optional[List[StrictStr]] = Field(
        None,
        description="Command-line parameters passed to Python wheel task. Leave it empty if `named_parameters` is not null.",
    )
    named_parameters: Optional[Dict[str, Any]] = Field(
        None,
        description='Command-line parameters passed to Python wheel task in the form of `["--name=task", "--data=dbfs:/path/to/data.json"]`. Leave it empty if `parameters` is not null.',
    )
    __properties = ["package_name", "entry_point", "parameters", "named_parameters"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PythonWheelTask:
        """Create an instance of PythonWheelTask from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PythonWheelTask:
        """Create an instance of PythonWheelTask from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PythonWheelTask.parse_obj(obj)

        _obj = PythonWheelTask.parse_obj(
            {
                "package_name": obj.get("package_name"),
                "entry_point": obj.get("entry_point"),
                "parameters": obj.get("parameters"),
                "named_parameters": obj.get("named_parameters"),
            }
        )
        return _obj
