# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import List, Optional

from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr


class RepairRunInput(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    run_id: Optional[StrictInt] = Field(
        None,
        description="The job run ID of the run to repair. The run must not be in progress.",
    )
    rerun_tasks: Optional[List[StrictStr]] = Field(
        None, description="The task keys of the task runs to repair."
    )
    latest_repair_id: Optional[StrictInt] = Field(
        None,
        description="The ID of the latest repair. This parameter is not required when repairing a run for the first time, but must be provided on subsequent requests to repair the same run.",
    )
    rerun_all_failed_tasks: Optional[StrictBool] = Field(
        False,
        description="If true, repair all failed tasks. Only one of rerun_tasks or rerun_all_failed_tasks can be used.",
    )
    __properties = [
        "run_id",
        "rerun_tasks",
        "latest_repair_id",
        "rerun_all_failed_tasks",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RepairRunInput:
        """Create an instance of RepairRunInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RepairRunInput:
        """Create an instance of RepairRunInput from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return RepairRunInput.parse_obj(obj)

        _obj = RepairRunInput.parse_obj(
            {
                "run_id": obj.get("run_id"),
                "rerun_tasks": obj.get("rerun_tasks"),
                "latest_repair_id": obj.get("latest_repair_id"),
                "rerun_all_failed_tasks": obj.get("rerun_all_failed_tasks")
                if obj.get("rerun_all_failed_tasks") is not None
                else False,
            }
        )
        return _obj
