# coding: utf-8

"""
    Jobs API 2.1

    The Jobs API allows you to create, edit, and delete jobs. You should never hard code secrets or store them in plain text. Use the [Secrets API](https://docs.microsoft.com/azure/databricks/dev-tools/api/latest/secrets) to manage secrets in the [Databricks CLI](https://docs.microsoft.com/azure/databricks/dev-tools/cli/index). Use the [Secrets utility](https://docs.microsoft.com/azure/databricks/dev-tools/databricks-utils#dbutils-secrets) to reference secrets in notebooks and jobs.  # noqa: E501

    The version of the OpenAPI document: 2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from inspect import getfullargspec
from typing import Optional

from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist

from databricks_jobs.models.git_source import GitSource
from databricks_jobs.models.run_submit_task_settings import RunSubmitTaskSettings
from databricks_jobs.models.webhook_notifications import WebhookNotifications


class RunSubmitSettings(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    tasks: Optional[conlist(RunSubmitTaskSettings, max_items=100)] = None
    run_name: Optional[StrictStr] = Field(
        None,
        description="An optional name for the run. The default value is `Untitled`.",
    )
    webhook_notifications: Optional[WebhookNotifications] = None
    git_source: Optional[GitSource] = None
    timeout_seconds: Optional[StrictInt] = Field(
        None,
        description="An optional timeout applied to each run of this job. The default behavior is to have no timeout.",
    )
    idempotency_token: Optional[StrictStr] = Field(
        None,
        description="An optional token that can be used to guarantee the idempotency of job run requests. If a run with the provided token already exists, the request does not create a new run but returns the ID of the existing run instead. If a run with the provided token is deleted, an error is returned.  If you specify the idempotency token, upon failure you can retry until the request succeeds. Databricks guarantees that exactly one run is launched with that idempotency token.  This token must have at most 64 characters.  For more information, see [How to ensure idempotency for jobs](https://docs.microsoft.com/azure/databricks/kb/jobs/jobs-idempotency).",
    )
    __properties = [
        "tasks",
        "run_name",
        "webhook_notifications",
        "git_source",
        "timeout_seconds",
        "idempotency_token",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RunSubmitSettings:
        """Create an instance of RunSubmitSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in tasks (list)
        _items = []
        if self.tasks:
            for _item in self.tasks:
                if _item:
                    _items.append(_item.to_dict())
            _dict["tasks"] = _items
        # override the default output from pydantic by calling `to_dict()` of webhook_notifications
        if self.webhook_notifications:
            _dict["webhook_notifications"] = self.webhook_notifications.to_dict()
        # override the default output from pydantic by calling `to_dict()` of git_source
        if self.git_source:
            _dict["git_source"] = self.git_source.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RunSubmitSettings:
        """Create an instance of RunSubmitSettings from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return RunSubmitSettings.parse_obj(obj)

        _obj = RunSubmitSettings.parse_obj(
            {
                "tasks": [
                    RunSubmitTaskSettings.from_dict(_item) for _item in obj.get("tasks")
                ]
                if obj.get("tasks") is not None
                else None,
                "run_name": obj.get("run_name"),
                "webhook_notifications": WebhookNotifications.from_dict(
                    obj.get("webhook_notifications")
                )
                if obj.get("webhook_notifications") is not None
                else None,
                "git_source": GitSource.from_dict(obj.get("git_source"))
                if obj.get("git_source") is not None
                else None,
                "timeout_seconds": obj.get("timeout_seconds"),
                "idempotency_token": obj.get("idempotency_token"),
            }
        )
        return _obj
